#!/usr/bin/env bash

#
# see the README.md in the same directory as this script for a
# description of why this script exists what this script does
#

set -e

SCRIPT_DIR_NAME="$( cd "$( dirname "$0" )" && pwd )"

if [ $# != 0 ]; then
    echo "usage: $(basename "$0")" >&2
    exit 1
fi

REPO_ROOT_DIR=$("${SCRIPT_DIR_NAME}/repo-root-dir.sh")
DOT_COVERAGE=${REPO_ROOT_DIR}/.coverage
if [ -e "${DOT_COVERAGE}" ]; then
    codecov -f "${DOT_COVERAGE}"
fi

exit 0
