# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2017-04-17 17:14
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import spectator.core.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('spectator_core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Publication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_created', models.DateTimeField(auto_now_add=True, help_text='The time this item was created in the database.')),
                ('time_modified', models.DateTimeField(auto_now=True, help_text='The time this item was last saved to the database.')),
                ('title', models.CharField(help_text="e.g. 'Aurora' or 'Vol. 39 No. 4, 16 February 2017'.", max_length=255)),
                ('title_sort', spectator.core.fields.NaturalSortField('title', db_index=True, default='', editable=False, help_text="e.g. 'clockwork orange, a' or 'world cities, the'.", max_length=255)),
                ('kind', models.CharField(choices=[('book', 'Book'), ('periodical', 'Periodical')], default='book', max_length=20)),
                ('official_url', models.URLField(blank=True, help_text='Official URL for this book/issue.', max_length=255, verbose_name='Official URL')),
                ('isbn_uk', models.CharField(blank=True, help_text="e.g. '0356500489'.", max_length=20, verbose_name='UK ISBN')),
                ('isbn_us', models.CharField(blank=True, help_text="e.g. '0316098094'.", max_length=20, verbose_name='US ISBN')),
                ('notes_url', models.URLField(blank=True, help_text='URL of your notes/review.', max_length=255, verbose_name='Notes URL')),
            ],
            options={
                'ordering': ('title_sort',),
            },
        ),
        migrations.CreateModel(
            name='PublicationRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_created', models.DateTimeField(auto_now_add=True, help_text='The time this item was created in the database.')),
                ('time_modified', models.DateTimeField(auto_now=True, help_text='The time this item was last saved to the database.')),
                ('role_name', models.CharField(blank=True, help_text="e.g. 'Headliner', 'Support', 'Editor', 'Illustrator', 'Director', etc. Optional.", max_length=50)),
                ('role_order', models.PositiveSmallIntegerField(default=1, help_text='The order in which the Creators will be listed.')),
                ('creator', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='publication_roles', to='spectator_core.Creator')),
                ('publication', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', to='spectator_reading.Publication')),
            ],
            options={
                'ordering': ('role_order', 'role_name'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PublicationSeries',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_created', models.DateTimeField(auto_now_add=True, help_text='The time this item was created in the database.')),
                ('time_modified', models.DateTimeField(auto_now=True, help_text='The time this item was last saved to the database.')),
                ('title', models.CharField(help_text="e.g. 'The London Review of Books'.", max_length=255)),
                ('title_sort', spectator.core.fields.NaturalSortField('title', db_index=True, default='', editable=False, help_text="e.g. 'london review of books, the'.", max_length=255)),
                ('url', models.URLField(blank=True, help_text="e.g. 'https://www.lrb.co.uk/'.", max_length=255, verbose_name='URL')),
            ],
            options={
                'verbose_name_plural': 'Publication series',
                'ordering': ('title_sort',),
            },
        ),
        migrations.CreateModel(
            name='Reading',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_created', models.DateTimeField(auto_now_add=True, help_text='The time this item was created in the database.')),
                ('time_modified', models.DateTimeField(auto_now=True, help_text='The time this item was last saved to the database.')),
                ('start_date', models.DateField(blank=True, null=True)),
                ('start_granularity', models.PositiveSmallIntegerField(choices=[(3, 'Y-m-d'), (4, 'Y-m'), (6, 'Y')], default=3)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('end_granularity', models.PositiveSmallIntegerField(choices=[(3, 'Y-m-d'), (4, 'Y-m'), (6, 'Y')], default=3)),
                ('is_finished', models.BooleanField(default=False, help_text='Did you finish the publication?')),
                ('publication', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='spectator_reading.Publication')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='publication',
            name='creators',
            field=models.ManyToManyField(related_name='publications', through='spectator_reading.PublicationRole', to='spectator_core.Creator'),
        ),
        migrations.AddField(
            model_name='publication',
            name='series',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='spectator_reading.PublicationSeries'),
        ),
    ]
