# Generated by Django 2.0 on 2018-02-08 11:26

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import spectator.core.fields


class Migration(migrations.Migration):

    dependencies = [
        ('spectator_core', '0004_auto_20180102_0959'),
        ('spectator_events', '0025_auto_20180131_1755'),
    ]

    operations = [
        migrations.CreateModel(
            name='Work',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_created', models.DateTimeField(auto_now_add=True, help_text='The time this item was created in the database.')),
                ('time_modified', models.DateTimeField(auto_now=True, help_text='The time this item was last saved to the database.')),
                ('slug', models.SlugField(blank=True, max_length=10)),
                ('kind', models.CharField(choices=[('classicalwork', 'Classical work'), ('dancepiece', 'Dance piece'), ('movie', 'Movie'), ('play', 'Play')], max_length=20)),
                ('title', models.CharField(max_length=255)),
                ('title_sort', spectator.core.fields.NaturalSortField('title', db_index=True, default='', editable=False, help_text="e.g. 'big piece, a' or 'biggest piece, the'.", max_length=255)),
                ('imdb_id', models.CharField(blank=True, help_text="Starts with 'tt', e.g. 'tt0100842'.", max_length=12, validators=[django.core.validators.RegexValidator(code='invalid_imdb_id', message='IMDb ID should be like "tt1234567"', regex='^tt\\d{7,10}$')], verbose_name='IMDb ID')),
                ('year', models.PositiveSmallIntegerField(blank=True, default=None, help_text='Year of release, composition, publication, etc.', null=True)),
            ],
            options={
                'verbose_name': 'work',
                'ordering': ('title_sort',),
            },
        ),
        migrations.CreateModel(
            name='WorkRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_created', models.DateTimeField(auto_now_add=True, help_text='The time this item was created in the database.')),
                ('time_modified', models.DateTimeField(auto_now=True, help_text='The time this item was last saved to the database.')),
                ('role_name', models.CharField(blank=True, help_text="e.g. 'Headliner', 'Support', 'Editor', 'Illustrator', 'Director', etc. Optional.", max_length=50)),
                ('role_order', models.PositiveSmallIntegerField(default=1, help_text='The order in which the Creators will be listed.')),
                ('creator', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='work_roles', to='spectator_core.Creator')),
                ('work', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', to='spectator_events.Work')),
            ],
            options={
                'verbose_name': 'work role',
                'ordering': ('role_order', 'role_name'),
            },
        ),
        migrations.CreateModel(
            name='WorkSelection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveSmallIntegerField(default=1, help_text='Position on the Event programme.')),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='work_selections', to='spectator_events.Event')),
                ('work', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='events', to='spectator_events.Work')),
            ],
            options={
                'verbose_name': 'work selection',
                'ordering': ('order',),
            },
        ),
        migrations.AddField(
            model_name='work',
            name='creators',
            field=models.ManyToManyField(related_name='works', through='spectator_events.WorkRole', to='spectator_core.Creator'),
        ),
    ]
