# Generated by Django 2.0 on 2018-01-26 09:09

from django.db import migrations


def forward(apps, schema_editor):
    """
    Copying data from the old `Event.movie` and `Event.play` ForeignKey fields
    into the new `Event.movies` and `Event.plays` ManyToManyFields.
    """

    Event = apps.get_model('spectator_events', 'Event')
    MovieSelection = apps.get_model('spectator_events', 'MovieSelection')
    PlaySelection = apps.get_model('spectator_events', 'PlaySelection')

    for event in Event.objects.all():
        if event.movie is not None:
            selection = MovieSelection(event=event, movie=event.movie)
            selection.save()

        if event.play is not None:
            selection = PlaySelection(event=event, play=event.play)
            selection.save()


class Migration(migrations.Migration):

    dependencies = [
        ('spectator_events', '0016_add_movies_plays_m2ms_on_event'),
    ]

    operations = [
        migrations.RunPython(forward),
    ]
