# Generated by Django 2.0 on 2018-01-02 11:47

from django.db import migrations, models
from django.conf import settings
from hashids import Hashids


def generate_slug(value):
    "A copy of spectator.core.models.SluggedModelMixin._generate_slug()"
    alphabet = 'abcdefghijkmnopqrstuvwxyz23456789'
    salt = 'Django Spectator'

    if hasattr(settings, 'SPECTATOR_SLUG_ALPHABET'):
        alphabet = settings.SPECTATOR_SLUG_ALPHABET

    if hasattr(settings, 'SPECTATOR_SLUG_SALT'):
        salt = settings.SPECTATOR_SLUG_SALT

    hashids = Hashids(alphabet=alphabet, salt=salt, min_length=5)

    return hashids.encode(value)


def set_slug(apps, schema_editor):
    """
    Create a slug for each Venue already in the DB.
    """
    Cls = apps.get_model('spectator_events', 'Venue')

    for obj in Cls.objects.all():
        obj.slug = generate_slug(obj.pk)
        obj.save(update_fields=['slug'])


class Migration(migrations.Migration):

    dependencies = [
        ('spectator_events', '0007_work_slug_20180102_1137'),
    ]

    operations = [
        migrations.AlterField(
            model_name='venue',
            name='slug',
            field=models.SlugField(blank=True, default='a', max_length=10),
            preserve_default=False,
        ),
        migrations.RunPython(set_slug),
    ]
