# Generated by Django 2.0 on 2018-01-02 11:27

from django.db import migrations, models
from django.conf import settings
from hashids import Hashids


def generate_slug(value):
    "A copy of spectator.core.models.SluggedModelMixin._generate_slug()"
    alphabet = 'abcdefghijkmnopqrstuvwxyz23456789'
    salt = 'Django Spectator'

    if hasattr(settings, 'SPECTATOR_SLUG_ALPHABET'):
        alphabet = settings.SPECTATOR_SLUG_ALPHABET

    if hasattr(settings, 'SPECTATOR_SLUG_SALT'):
        salt = settings.SPECTATOR_SLUG_SALT

    hashids = Hashids(alphabet=alphabet, salt=salt, min_length=5)

    return hashids.encode(value)


def set_slug(apps, schema_editor):
    """
    Create a slug for each Event already in the DB.
    """
    Event = apps.get_model('spectator_events', 'Event')

    for e in Event.objects.all():
        e.slug = generate_slug(e.pk)
        e.save(update_fields=['slug'])


class Migration(migrations.Migration):

    dependencies = [
        ('spectator_events', '0005_auto_20180102_0959'),
    ]

    operations = [
        migrations.AlterField(
            model_name='event',
            name='slug',
            field=models.SlugField(blank=True, default='a', max_length=10),
            preserve_default=False,
        ),
        migrations.RunPython(set_slug),
    ]
