"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDictionaryItem = exports.toJson_CfnDictionaryItemProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnDictionaryItemProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnDictionaryItemProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ItemKey': obj.itemKey,
        'ItemValue': obj.itemValue,
        'DictionaryId': obj.dictionaryId,
        'ServiceId': obj.serviceId,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnDictionaryItemProps = toJson_CfnDictionaryItemProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Fastly::Dictionary::DictionaryItem`
 *
 * @cloudformationResource Fastly::Dictionary::DictionaryItem
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
 */
class CfnDictionaryItem extends cdk.CfnResource {
    /**
     * Create a new `Fastly::Dictionary::DictionaryItem`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDictionaryItem.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnDictionaryItemProps(props) });
        this.props = props;
        this.attrCreatedAt = cdk.Token.asString(this.getAtt('CreatedAt'));
        this.attrDeletedAt = cdk.Token.asString(this.getAtt('DeletedAt'));
        this.attrUpdatedAt = cdk.Token.asString(this.getAtt('UpdatedAt'));
    }
}
exports.CfnDictionaryItem = CfnDictionaryItem;
_a = JSII_RTTI_SYMBOL_1;
CfnDictionaryItem[_a] = { fqn: "@cdk-cloudformation/fastly-dictionary-dictionaryitem.CfnDictionaryItem", version: "1.5.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnDictionaryItem.CFN_RESOURCE_TYPE_NAME = "Fastly::Dictionary::DictionaryItem";
//# sourceMappingURL=data:application/json;base64,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