import * as codepipeline from "../../../aws-codepipeline";
import * as ec2 from "../../../aws-ec2";
import * as events from "../../../aws-events";
import * as iam from "../../../aws-iam";
import { Construct } from "../../../core";
/**
 * Type of the asset that is being published
 */
export declare enum AssetType {
    /**
     * A file
     */
    FILE = "file",
    /**
     * A Docker image
     */
    DOCKER_IMAGE = "docker-image"
}
/**
 * Props for a PublishAssetsAction
 */
export interface PublishAssetsActionProps {
    /**
     * Name of publishing action
     */
    readonly actionName: string;
    /**
     * The CodePipeline artifact that holds the Cloud Assembly.
     */
    readonly cloudAssemblyInput: codepipeline.Artifact;
    /**
     * AssetType we're publishing
     */
    readonly assetType: AssetType;
    /**
     * Version of CDK CLI to 'npm install'.
     *
     * @default - Latest version
     */
    readonly cdkCliVersion?: string;
    /**
     * Name of the CodeBuild project
     *
     * @default - Automatically generated
     */
    readonly projectName?: string;
    /**
     * Role to use for CodePipeline and CodeBuild to build and publish the assets.
     *
     * @default - Automatically generated
     */
    readonly role?: iam.IRole;
    /**
     * The VPC where to execute the PublishAssetsAction.
     *
     * @default - No VPC
     */
    readonly vpc?: ec2.IVpc;
    /**
     * Which subnets to use.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - All private subnets.
     */
    readonly subnetSelection?: ec2.SubnetSelection;
}
/**
 * Action to publish an asset in the pipeline
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to prepare and publish the asset.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline when you add stacks that use assets.
 */
export declare class PublishAssetsAction extends Construct implements codepipeline.IAction {
    private readonly props;
    private readonly action;
    private readonly commands;
    constructor(scope: Construct, id: string, props: PublishAssetsActionProps);
    /**
     * Add a single publishing command
     *
     * Manifest path should be relative to the root Cloud Assembly.
     */
    addPublishCommand(relativeManifestPath: string, assetSelector: string): void;
    /**
     * Exists to implement IAction
     */
    bind(scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * Exists to implement IAction
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
    /**
     * Exists to implement IAction
     */
    get actionProperties(): codepipeline.ActionProperties;
}
