"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedStackSynthesizer = void 0;
const _shared_1 = require("./_shared");
const stack_synthesizer_1 = require("./stack-synthesizer");
/**
 * Deployment environment for a nested stack
 *
 * Interoperates with the StackSynthesizer of the parent stack.
 */
class NestedStackSynthesizer extends stack_synthesizer_1.StackSynthesizer {
    constructor(parentDeployment) {
        super();
        this.parentDeployment = parentDeployment;
    }
    bind(stack) {
        this.stack = stack;
    }
    addFileAsset(asset) {
        // Forward to parent deployment. By the magic of cross-stack references any parameter
        // returned and used will magically be forwarded to the nested stack.
        return this.parentDeployment.addFileAsset(asset);
    }
    addDockerImageAsset(asset) {
        // Forward to parent deployment. By the magic of cross-stack references any parameter
        // returned and used will magically be forwarded to the nested stack.
        return this.parentDeployment.addDockerImageAsset(asset);
    }
    synthesize(session) {
        _shared_1.assertBound(this.stack);
        // Synthesize the template, but don't emit as a cloud assembly artifact.
        // It will be registered as an S3 asset of its parent instead.
        this.synthesizeStackTemplate(this.stack, session);
    }
}
exports.NestedStackSynthesizer = NestedStackSynthesizer;
//# sourceMappingURL=data:application/json;base64,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