"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BootstraplessSynthesizer = void 0;
const _shared_1 = require("./_shared");
const default_synthesizer_1 = require("./default-synthesizer");
/**
 * A special synthesizer that behaves similarly to DefaultStackSynthesizer,
 * but doesn't require bootstrapping the environment it operates in.
 * Because of that, stacks using it cannot have assets inside of them.
 * Used by the CodePipeline construct for the support stacks needed for
 * cross-region replication S3 buckets.
 */
class BootstraplessSynthesizer extends default_synthesizer_1.DefaultStackSynthesizer {
    constructor(props) {
        super({
            deployRoleArn: props.deployRoleArn,
            cloudFormationExecutionRole: props.cloudFormationExecutionRoleArn,
            generateBootstrapVersionRule: false,
        });
    }
    addFileAsset(_asset) {
        throw new Error('Cannot add assets to a Stack that uses the BootstraplessSynthesizer');
    }
    addDockerImageAsset(_asset) {
        throw new Error('Cannot add assets to a Stack that uses the BootstraplessSynthesizer');
    }
    synthesize(session) {
        _shared_1.assertBound(this.stack);
        this.synthesizeStackTemplate(this.stack, session);
        // do _not_ treat the template as an asset,
        // because this synthesizer doesn't have a bootstrap bucket to put it in
        this.emitStackArtifact(this.stack, session, {
            assumeRoleArn: this.deployRoleArn,
            cloudFormationExecutionRoleArn: this.cloudFormationExecutionRoleArn,
            requiresBootstrapStackVersion: 1,
        });
    }
}
exports.BootstraplessSynthesizer = BootstraplessSynthesizer;
//# sourceMappingURL=data:application/json;base64,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