"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeatureFlags = void 0;
const cxapi = require("../../cx-api"); // Automatically re-written from '@aws-cdk/cx-api'
/**
 * Features that are implemented behind a flag in order to preserve backwards
 * compatibility for existing apps. The list of flags are available in the
 * `@aws-cdk/cx-api` module.
 *
 * The state of the flag for this application is stored as a CDK context variable.
 */
class FeatureFlags {
    constructor(construct) {
        this.construct = construct;
    }
    /**
     * Inspect feature flags on the construct node's context.
     */
    static of(scope) {
        return new FeatureFlags(scope);
    }
    /**
     * Check whether a feature flag is enabled. If configured, the flag is present in
     * the construct node context. Falls back to the defaults defined in the `cx-api`
     * module.
     */
    isEnabled(featureFlag) {
        var _a;
        return (_a = this.construct.node.tryGetContext(featureFlag)) !== null && _a !== void 0 ? _a : cxapi.futureFlagDefault(featureFlag);
    }
}
exports.FeatureFlags = FeatureFlags;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmVhdHVyZS1mbGFncy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImZlYXR1cmUtZmxhZ3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsc0NBQXNDLENBQUMsa0RBQWtEO0FBRXpGOzs7Ozs7R0FNRztBQUNILE1BQWEsWUFBWTtJQU9yQixZQUFxQyxTQUFvQjtRQUFwQixjQUFTLEdBQVQsU0FBUyxDQUFXO0lBQUksQ0FBQztJQU45RDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxFQUFFLENBQUMsS0FBZ0I7UUFDN0IsT0FBTyxJQUFJLFlBQVksQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7T0FJRztJQUNJLFNBQVMsQ0FBQyxXQUFtQjs7UUFDaEMsYUFBTyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUFDLG1DQUFJLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUNsRyxDQUFDO0NBQ0o7QUFoQkQsb0NBZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY3hhcGkgZnJvbSBcIi4uLy4uL2N4LWFwaVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY3gtYXBpJ1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnLi4vbGliL2NvbnN0cnVjdC1jb21wYXQnO1xuLyoqXG4gKiBGZWF0dXJlcyB0aGF0IGFyZSBpbXBsZW1lbnRlZCBiZWhpbmQgYSBmbGFnIGluIG9yZGVyIHRvIHByZXNlcnZlIGJhY2t3YXJkc1xuICogY29tcGF0aWJpbGl0eSBmb3IgZXhpc3RpbmcgYXBwcy4gVGhlIGxpc3Qgb2YgZmxhZ3MgYXJlIGF2YWlsYWJsZSBpbiB0aGVcbiAqIGBAYXdzLWNkay9jeC1hcGlgIG1vZHVsZS5cbiAqXG4gKiBUaGUgc3RhdGUgb2YgdGhlIGZsYWcgZm9yIHRoaXMgYXBwbGljYXRpb24gaXMgc3RvcmVkIGFzIGEgQ0RLIGNvbnRleHQgdmFyaWFibGUuXG4gKi9cbmV4cG9ydCBjbGFzcyBGZWF0dXJlRmxhZ3Mge1xuICAgIC8qKlxuICAgICAqIEluc3BlY3QgZmVhdHVyZSBmbGFncyBvbiB0aGUgY29uc3RydWN0IG5vZGUncyBjb250ZXh0LlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgb2Yoc2NvcGU6IENvbnN0cnVjdCkge1xuICAgICAgICByZXR1cm4gbmV3IEZlYXR1cmVGbGFncyhzY29wZSk7XG4gICAgfVxuICAgIHByaXZhdGUgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBjb25zdHJ1Y3Q6IENvbnN0cnVjdCkgeyB9XG4gICAgLyoqXG4gICAgICogQ2hlY2sgd2hldGhlciBhIGZlYXR1cmUgZmxhZyBpcyBlbmFibGVkLiBJZiBjb25maWd1cmVkLCB0aGUgZmxhZyBpcyBwcmVzZW50IGluXG4gICAgICogdGhlIGNvbnN0cnVjdCBub2RlIGNvbnRleHQuIEZhbGxzIGJhY2sgdG8gdGhlIGRlZmF1bHRzIGRlZmluZWQgaW4gdGhlIGBjeC1hcGlgXG4gICAgICogbW9kdWxlLlxuICAgICAqL1xuICAgIHB1YmxpYyBpc0VuYWJsZWQoZmVhdHVyZUZsYWc6IHN0cmluZyk6IGJvb2xlYW4gfCB1bmRlZmluZWQge1xuICAgICAgICByZXR1cm4gdGhpcy5jb25zdHJ1Y3Qubm9kZS50cnlHZXRDb250ZXh0KGZlYXR1cmVGbGFnKSA/PyBjeGFwaS5mdXR1cmVGbGFnRGVmYXVsdChmZWF0dXJlRmxhZyk7XG4gICAgfVxufVxuIl19