"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionFilter = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const logs_generated_1 = require("./logs.generated");
/**
 * A new Subscription on a CloudWatch log group.
 */
class SubscriptionFilter extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const destProps = props.destination.bind(this, props.logGroup);
        new logs_generated_1.CfnSubscriptionFilter(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            destinationArn: destProps.arn,
            roleArn: destProps.role && destProps.role.roleArn,
            filterPattern: props.filterPattern.logPatternString,
        });
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
//# sourceMappingURL=data:application/json;base64,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