"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsEventSource = void 0;
const subs = require("../../aws-sns-subscriptions"); // Automatically re-written from '@aws-cdk/aws-sns-subscriptions'
/**
 * Use an Amazon SNS topic as an event source for AWS Lambda.
 */
class SnsEventSource {
    constructor(topic, props) {
        this.topic = topic;
        this.props = props;
    }
    bind(target) {
        this.topic.addSubscription(new subs.LambdaSubscription(target, this.props));
    }
}
exports.SnsEventSource = SnsEventSource;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLG9EQUFvRCxDQUFDLGlFQUFpRTtBQU10SDs7R0FFRztBQUNILE1BQWEsY0FBYztJQUV2QixZQUFxQixLQUFpQixFQUFFLEtBQTJCO1FBQTlDLFVBQUssR0FBTCxLQUFLLENBQVk7UUFDbEMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNNLElBQUksQ0FBQyxNQUF3QjtRQUNoQyxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsQ0FBQyxJQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDaEYsQ0FBQztDQUNKO0FBUkQsd0NBUUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSBcIi4uLy4uL2F3cy1sYW1iZGFcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnXG5pbXBvcnQgKiBhcyBzbnMgZnJvbSBcIi4uLy4uL2F3cy1zbnNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnXG5pbXBvcnQgKiBhcyBzdWJzIGZyb20gXCIuLi8uLi9hd3Mtc25zLXN1YnNjcmlwdGlvbnNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMtc3Vic2NyaXB0aW9ucydcbi8qKlxuICogUHJvcGVydGllcyBmb3J3YXJkZWQgdG8gdGhlIExhbWJkYSBTdWJzY3JpcHRpb24uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU25zRXZlbnRTb3VyY2VQcm9wcyBleHRlbmRzIHN1YnMuTGFtYmRhU3Vic2NyaXB0aW9uUHJvcHMge1xufVxuLyoqXG4gKiBVc2UgYW4gQW1hem9uIFNOUyB0b3BpYyBhcyBhbiBldmVudCBzb3VyY2UgZm9yIEFXUyBMYW1iZGEuXG4gKi9cbmV4cG9ydCBjbGFzcyBTbnNFdmVudFNvdXJjZSBpbXBsZW1lbnRzIGxhbWJkYS5JRXZlbnRTb3VyY2Uge1xuICAgIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM/OiBTbnNFdmVudFNvdXJjZVByb3BzO1xuICAgIGNvbnN0cnVjdG9yKHJlYWRvbmx5IHRvcGljOiBzbnMuSVRvcGljLCBwcm9wcz86IFNuc0V2ZW50U291cmNlUHJvcHMpIHtcbiAgICAgICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICAgIH1cbiAgICBwdWJsaWMgYmluZCh0YXJnZXQ6IGxhbWJkYS5JRnVuY3Rpb24pIHtcbiAgICAgICAgdGhpcy50b3BpYy5hZGRTdWJzY3JpcHRpb24obmV3IHN1YnMuTGFtYmRhU3Vic2NyaXB0aW9uKHRhcmdldCwgdGhpcy5wcm9wcykpO1xuICAgIH1cbn1cbiJdfQ==