"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsDlq = void 0;
/**
 * An SNS dead letter queue destination configuration for a Lambda event source
 */
class SnsDlq {
    constructor(topic) {
        this.topic = topic;
    }
    /**
     * Returns a destination configuration for the DLQ
     */
    bind(_target, targetHandler) {
        this.topic.grantPublish(targetHandler);
        return {
            destination: this.topic.topicArn,
        };
    }
}
exports.SnsDlq = SnsDlq;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNucy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUE7O0dBRUc7QUFDSCxNQUFhLE1BQU07SUFDZixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0lBQzlDLENBQUM7SUFDRDs7T0FFRztJQUNJLElBQUksQ0FBQyxPQUE0QixFQUFFLGFBQXdCO1FBQzlELElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ3ZDLE9BQU87WUFDSCxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO1NBQ25DLENBQUM7SUFDTixDQUFDO0NBQ0o7QUFaRCx3QkFZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IERscURlc3RpbmF0aW9uQ29uZmlnLCBJRXZlbnRTb3VyY2VEbHEsIElFdmVudFNvdXJjZU1hcHBpbmcsIElGdW5jdGlvbiB9IGZyb20gXCIuLi8uLi9hd3MtbGFtYmRhXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJ1xuaW1wb3J0ICogYXMgc25zIGZyb20gXCIuLi8uLi9hd3Mtc25zXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtc25zJ1xuLyoqXG4gKiBBbiBTTlMgZGVhZCBsZXR0ZXIgcXVldWUgZGVzdGluYXRpb24gY29uZmlndXJhdGlvbiBmb3IgYSBMYW1iZGEgZXZlbnQgc291cmNlXG4gKi9cbmV4cG9ydCBjbGFzcyBTbnNEbHEgaW1wbGVtZW50cyBJRXZlbnRTb3VyY2VEbHEge1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgdG9waWM6IHNucy5JVG9waWMpIHtcbiAgICB9XG4gICAgLyoqXG4gICAgICogUmV0dXJucyBhIGRlc3RpbmF0aW9uIGNvbmZpZ3VyYXRpb24gZm9yIHRoZSBETFFcbiAgICAgKi9cbiAgICBwdWJsaWMgYmluZChfdGFyZ2V0OiBJRXZlbnRTb3VyY2VNYXBwaW5nLCB0YXJnZXRIYW5kbGVyOiBJRnVuY3Rpb24pOiBEbHFEZXN0aW5hdGlvbkNvbmZpZyB7XG4gICAgICAgIHRoaXMudG9waWMuZ3JhbnRQdWJsaXNoKHRhcmdldEhhbmRsZXIpO1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgZGVzdGluYXRpb246IHRoaXMudG9waWMudG9waWNBcm4sXG4gICAgICAgIH07XG4gICAgfVxufVxuIl19