"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationListenerCertificate = void 0;
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const elasticloadbalancingv2_generated_1 = require("../elasticloadbalancingv2.generated");
/**
 * Add certificates to a listener
 */
class ApplicationListenerCertificate extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (!props.certificateArns && !props.certificates) {
            throw new Error('At least one of \'certificateArns\' or \'certificates\' is required');
        }
        const certificates = [
            ...(props.certificates || []).map(c => ({ certificateArn: c.certificateArn })),
            ...(props.certificateArns || []).map(certificateArn => ({ certificateArn })),
        ];
        new elasticloadbalancingv2_generated_1.CfnListenerCertificate(this, 'Resource', {
            listenerArn: props.listener.listenerArn,
            certificates,
        });
    }
}
exports.ApplicationListenerCertificate = ApplicationListenerCertificate;
//# sourceMappingURL=data:application/json;base64,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