"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesPatch = exports.PatchType = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const kubectl_provider_1 = require("./kubectl-provider");
/**
 * Values for `kubectl patch` --type argument
 */
var PatchType;
(function (PatchType) {
    /**
     * JSON Patch, RFC 6902
     */
    PatchType["JSON"] = "json";
    /**
     * JSON Merge patch
     */
    PatchType["MERGE"] = "merge";
    /**
     * Strategic merge patch
     */
    PatchType["STRATEGIC"] = "strategic";
})(PatchType = exports.PatchType || (exports.PatchType = {}));
/**
 * A CloudFormation resource which applies/restores a JSON patch into a
 * Kubernetes resource.
 * @see https://kubernetes.io/docs/tasks/run-application/update-api-object-kubectl-patch/
 */
class KubernetesPatch extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::AWSCDK-EKS-KubernetesPatch',
            properties: {
                ResourceName: props.resourceName,
                ResourceNamespace: (_a = props.resourceNamespace) !== null && _a !== void 0 ? _a : 'default',
                ApplyPatchJson: stack.toJsonString(props.applyPatch),
                RestorePatchJson: stack.toJsonString(props.restorePatch),
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                PatchType: (_b = props.patchType) !== null && _b !== void 0 ? _b : PatchType.STRATEGIC,
            },
        });
    }
}
exports.KubernetesPatch = KubernetesPatch;
//# sourceMappingURL=data:application/json;base64,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