"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseSecret = void 0;
const aws_secretsmanager_1 = require("../../aws-secretsmanager"); // Automatically re-written from '@aws-cdk/aws-secretsmanager'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 *
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends aws_secretsmanager_1.Secret {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, {
            secretName: props.secretName,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            encryptionKey: props.encryptionKey,
            // The CloudFormation resource provider for AWS::DocDB::DBCluster currently limits the DocDB master password to
            // 41 characters when pulling the password from secrets manager using a CloudFormation reference. This does not
            // line up with the CloudFormation resource specification which states a maximum of 100 characters:
            //
            // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-masteruserpassword
            //
            // When attempting to exceed 41 characters, a deployment fails with the message:
            // Length of value for property {/MasterUserPassword} is greater than maximum allowed length {41}
            generateSecretString: {
                passwordLength: 41,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    masterarn: (_a = props.masterSecret) === null || _a === void 0 ? void 0 : _a.secretArn,
                }),
                generateStringKey: 'password',
                excludeCharacters: '"@/',
            },
        });
    }
}
exports.DatabaseSecret = DatabaseSecret;
//# sourceMappingURL=data:application/json;base64,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