"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDeploymentConfig = void 0;
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom Lambda Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class LambdaDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom lambda deployment configurations
    }
    /**
     * Import a custom Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param props the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static import(_scope, _id, props) {
        return deploymentConfig(props.deploymentConfigName);
    }
}
exports.LambdaDeploymentConfig = LambdaDeploymentConfig;
LambdaDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.LambdaAllAtOnce');
LambdaDeploymentConfig.CANARY_10PERCENT_30MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent30Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent5Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent10Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_15MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent15Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery10Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery1Minute');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_2MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery2Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_3MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery3Minutes');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,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