"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeploymentConfig = void 0;
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for an ECS Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom ECS Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class EcsDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom ECS deployment configurations
    }
    /**
     * Import a custom Deployment Configuration for an ECS Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param ecsDeploymentConfigName the name of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromEcsDeploymentConfigName(_scope, _id, ecsDeploymentConfigName) {
        return deploymentConfig(ecsDeploymentConfigName);
    }
}
exports.EcsDeploymentConfig = EcsDeploymentConfig;
EcsDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.ECSAllAtOnce');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,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