"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobDefinitionImageConfig = void 0;
const ecs = require("../../aws-ecs"); // Automatically re-written from '@aws-cdk/aws-ecs'
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * Batch Job Task Definition
 *
 * Defines a Batch Job Task Definition. The properties of this task definition mirrors
 * those of an {@link ecs.ContainerDefinition}. This class is a wrapper on that structure.
 */
class TaskDefinition {
    constructor(props) {
        this.executionRole = props.executionRole;
    }
    /**
     * Internal function to allow the Batch Job task defintion
     * to match the CDK requirements of an EC2 task definition.
     *
     * @internal
     */
    _linkContainer() { }
    /**
     * Retrieves the execution role for this task definition
     */
    obtainExecutionRole() {
        return this.executionRole;
    }
}
/**
 * The configuration for creating a batch container image.
 */
class JobDefinitionImageConfig {
    constructor(scope, container) {
        const config = this.bindImageConfig(scope, container);
        this.imageName = config.imageName;
    }
    bindImageConfig(scope, container) {
        return container.image.bind(scope, new ecs.ContainerDefinition(scope, 'Resource-Batch-Job-Container-Definition', {
            command: container.command,
            cpu: container.vcpus,
            image: container.image,
            environment: container.environment,
            linuxParameters: container.linuxParams,
            memoryLimitMiB: container.memoryLimitMiB,
            privileged: container.privileged,
            readonlyRootFilesystem: container.readOnly,
            gpuCount: container.gpuCount,
            user: container.user,
            taskDefinition: new TaskDefinition({
                executionRole: container.jobRole || new iam.LazyRole(scope, 'Resource-Batch-Task-Definition-Role', {
                    assumedBy: new iam.ServicePrincipal('batch.amazonaws.com'),
                }),
            }),
        }));
    }
}
exports.JobDefinitionImageConfig = JobDefinitionImageConfig;
//# sourceMappingURL=data:application/json;base64,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