"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RateLimitedApiKey = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const api_key_1 = require("./api-key");
const usage_plan_1 = require("./usage-plan");
/**
 * An API Gateway ApiKey, for which a rate limiting configuration can be specified.
 *
 * @resource AWS::ApiGateway::ApiKey
 */
class RateLimitedApiKey extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.apiKeyName,
        });
        const resource = new api_key_1.ApiKey(this, 'Resource', props);
        if (props.apiStages || props.quota || props.throttle) {
            new usage_plan_1.UsagePlan(this, 'UsagePlanResource', {
                apiKey: resource,
                apiStages: props.apiStages,
                quota: props.quota,
                throttle: props.throttle,
            });
        }
        this.keyId = resource.keyId;
    }
}
exports.RateLimitedApiKey = RateLimitedApiKey;
//# sourceMappingURL=data:application/json;base64,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