"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasePathMapping = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
/**
 * This resource creates a base path that clients who call your API must use in
 * the invocation URL.
 *
 * Unless you're importing a domain with `DomainName.fromDomainNameAttributes()`,
 * you can use `DomainName.addBasePathMapping()` to define mappings.
 */
class BasePathMapping extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        if (props.basePath && !core_1.Token.isUnresolved(props.basePath)) {
            if (!props.basePath.match(/^[a-z0-9$_.+!*'()-]+$/)) {
                throw new Error(`A base path may only contain letters, numbers, and one of "$-_.+!*'()", received: ${props.basePath}`);
            }
        }
        // if restApi is an owned API and it has a deployment stage, map all requests
        // to that stage. otherwise, the stage will have to be specified in the URL.
        const stage = (_a = props.stage) !== null && _a !== void 0 ? _a : (props.restApi instanceof restapi_1.RestApi
            ? props.restApi.deploymentStage
            : undefined);
        new apigateway_generated_1.CfnBasePathMapping(this, 'Resource', {
            basePath: props.basePath,
            domainName: props.domainName.domainName,
            restApiId: props.restApi.restApiId,
            stage: stage && stage.stageName,
        });
    }
}
exports.BasePathMapping = BasePathMapping;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzZS1wYXRoLW1hcHBpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJiYXNlLXBhdGgtbWFwcGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxxQ0FBNkMsQ0FBQyxnREFBZ0Q7QUFFOUYsaUVBQTREO0FBRTVELHVDQUE4QztBQTZCOUM7Ozs7OztHQU1HO0FBQ0gsTUFBYSxlQUFnQixTQUFRLGVBQVE7SUFDekMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEyQjs7UUFDakUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixJQUFJLEtBQUssQ0FBQyxRQUFRLElBQUksQ0FBQyxZQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRTtZQUN2RCxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsdUJBQXVCLENBQUMsRUFBRTtnQkFDaEQsTUFBTSxJQUFJLEtBQUssQ0FBQyxxRkFBcUYsS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7YUFDMUg7U0FDSjtRQUNELDZFQUE2RTtRQUM3RSw0RUFBNEU7UUFDNUUsTUFBTSxLQUFLLFNBQUcsS0FBSyxDQUFDLEtBQUssbUNBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxZQUFZLGlCQUFPO1lBQzFELENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLGVBQWU7WUFDL0IsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ2pCLElBQUkseUNBQWtCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNyQyxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsVUFBVTtZQUN2QyxTQUFTLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxTQUFTO1lBQ2xDLEtBQUssRUFBRSxLQUFLLElBQUksS0FBSyxDQUFDLFNBQVM7U0FDbEMsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztDQUNKO0FBcEJELDBDQW9CQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFJlc291cmNlLCBUb2tlbiB9IGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDZm5CYXNlUGF0aE1hcHBpbmcgfSBmcm9tICcuL2FwaWdhdGV3YXkuZ2VuZXJhdGVkJztcbmltcG9ydCB7IElEb21haW5OYW1lIH0gZnJvbSAnLi9kb21haW4tbmFtZSc7XG5pbXBvcnQgeyBJUmVzdEFwaSwgUmVzdEFwaSB9IGZyb20gJy4vcmVzdGFwaSc7XG5pbXBvcnQgeyBTdGFnZSB9IGZyb20gJy4vc3RhZ2UnO1xuZXhwb3J0IGludGVyZmFjZSBCYXNlUGF0aE1hcHBpbmdPcHRpb25zIHtcbiAgICAvKipcbiAgICAgKiBUaGUgYmFzZSBwYXRoIG5hbWUgdGhhdCBjYWxsZXJzIG9mIHRoZSBBUEkgbXVzdCBwcm92aWRlIGluIHRoZSBVUkwgYWZ0ZXJcbiAgICAgKiB0aGUgZG9tYWluIG5hbWUgKGUuZy4gYGV4YW1wbGUuY29tL2Jhc2UtcGF0aGApLiBJZiB5b3Ugc3BlY2lmeSB0aGlzXG4gICAgICogcHJvcGVydHksIGl0IGNhbid0IGJlIGFuIGVtcHR5IHN0cmluZy5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gbWFwIHJlcXVlc3RzIGZyb20gdGhlIGRvbWFpbiByb290IChlLmcuIGBleGFtcGxlLmNvbWApLiBJZiB0aGlzXG4gICAgICogaXMgdW5kZWZpbmVkLCBubyBhZGRpdGlvbmFsIG1hcHBpbmdzIHdpbGwgYmUgYWxsb3dlZCBvbiB0aGlzIGRvbWFpbiBuYW1lLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGJhc2VQYXRoPzogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFRoZSBEZXBsb3ltZW50IHN0YWdlIG9mIEFQSVxuICAgICAqIFtkaXNhYmxlLWF3c2xpbnQ6cmVmLXZpYS1pbnRlcmZhY2VdXG4gICAgICogQGRlZmF1bHQgLSBtYXAgdG8gZGVwbG95bWVudFN0YWdlIG9mIHJlc3RBcGkgb3RoZXJ3aXNlIHN0YWdlIG5lZWRzIHRvIHBhc3MgaW4gVVJMXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3RhZ2U/OiBTdGFnZTtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgQmFzZVBhdGhNYXBwaW5nUHJvcHMgZXh0ZW5kcyBCYXNlUGF0aE1hcHBpbmdPcHRpb25zIHtcbiAgICAvKipcbiAgICAgKiBUaGUgRG9tYWluTmFtZSB0byBhc3NvY2lhdGUgd2l0aCB0aGlzIGJhc2UgcGF0aCBtYXBwaW5nLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRvbWFpbk5hbWU6IElEb21haW5OYW1lO1xuICAgIC8qKlxuICAgICAqIFRoZSBSZXN0QXBpIHJlc291cmNlIHRvIHRhcmdldC5cbiAgICAgKi9cbiAgICByZWFkb25seSByZXN0QXBpOiBJUmVzdEFwaTtcbn1cbi8qKlxuICogVGhpcyByZXNvdXJjZSBjcmVhdGVzIGEgYmFzZSBwYXRoIHRoYXQgY2xpZW50cyB3aG8gY2FsbCB5b3VyIEFQSSBtdXN0IHVzZSBpblxuICogdGhlIGludm9jYXRpb24gVVJMLlxuICpcbiAqIFVubGVzcyB5b3UncmUgaW1wb3J0aW5nIGEgZG9tYWluIHdpdGggYERvbWFpbk5hbWUuZnJvbURvbWFpbk5hbWVBdHRyaWJ1dGVzKClgLFxuICogeW91IGNhbiB1c2UgYERvbWFpbk5hbWUuYWRkQmFzZVBhdGhNYXBwaW5nKClgIHRvIGRlZmluZSBtYXBwaW5ncy5cbiAqL1xuZXhwb3J0IGNsYXNzIEJhc2VQYXRoTWFwcGluZyBleHRlbmRzIFJlc291cmNlIHtcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQmFzZVBhdGhNYXBwaW5nUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgICAgaWYgKHByb3BzLmJhc2VQYXRoICYmICFUb2tlbi5pc1VucmVzb2x2ZWQocHJvcHMuYmFzZVBhdGgpKSB7XG4gICAgICAgICAgICBpZiAoIXByb3BzLmJhc2VQYXRoLm1hdGNoKC9eW2EtejAtOSRfLishKicoKS1dKyQvKSkge1xuICAgICAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcihgQSBiYXNlIHBhdGggbWF5IG9ubHkgY29udGFpbiBsZXR0ZXJzLCBudW1iZXJzLCBhbmQgb25lIG9mIFwiJC1fLishKicoKVwiLCByZWNlaXZlZDogJHtwcm9wcy5iYXNlUGF0aH1gKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICAvLyBpZiByZXN0QXBpIGlzIGFuIG93bmVkIEFQSSBhbmQgaXQgaGFzIGEgZGVwbG95bWVudCBzdGFnZSwgbWFwIGFsbCByZXF1ZXN0c1xuICAgICAgICAvLyB0byB0aGF0IHN0YWdlLiBvdGhlcndpc2UsIHRoZSBzdGFnZSB3aWxsIGhhdmUgdG8gYmUgc3BlY2lmaWVkIGluIHRoZSBVUkwuXG4gICAgICAgIGNvbnN0IHN0YWdlID0gcHJvcHMuc3RhZ2UgPz8gKHByb3BzLnJlc3RBcGkgaW5zdGFuY2VvZiBSZXN0QXBpXG4gICAgICAgICAgICA/IHByb3BzLnJlc3RBcGkuZGVwbG95bWVudFN0YWdlXG4gICAgICAgICAgICA6IHVuZGVmaW5lZCk7XG4gICAgICAgIG5ldyBDZm5CYXNlUGF0aE1hcHBpbmcodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgICAgICAgYmFzZVBhdGg6IHByb3BzLmJhc2VQYXRoLFxuICAgICAgICAgICAgZG9tYWluTmFtZTogcHJvcHMuZG9tYWluTmFtZS5kb21haW5OYW1lLFxuICAgICAgICAgICAgcmVzdEFwaUlkOiBwcm9wcy5yZXN0QXBpLnJlc3RBcGlJZCxcbiAgICAgICAgICAgIHN0YWdlOiBzdGFnZSAmJiBzdGFnZS5zdGFnZU5hbWUsXG4gICAgICAgIH0pO1xuICAgIH1cbn1cbiJdfQ==