"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cloudmap = require("@aws-cdk/aws-servicediscovery");
const cdk = require("@aws-cdk/core");
const appmesh = require("../lib/");
exports.app = new cdk.App();
const stack = new cdk.Stack(exports.app, 'mesh-stack', {});
const vpc = new ec2.Vpc(stack, 'vpc', {
    natGateways: 1,
});
const namespace = new cloudmap.PrivateDnsNamespace(stack, 'test-namespace', {
    vpc,
    name: 'domain.local',
});
const mesh = new appmesh.Mesh(stack, 'mesh');
const router = mesh.addVirtualRouter('router', {
    listener: {
        portMapping: {
            port: 8080,
            protocol: appmesh.Protocol.HTTP,
        },
    },
});
const virtualService = mesh.addVirtualService('service', {
    virtualRouter: router,
    virtualServiceName: 'service1.domain.local',
});
const node = mesh.addVirtualNode('node', {
    dnsHostName: `node1.${namespace.namespaceName}`,
    listener: {
        healthCheck: {
            healthyThreshold: 3,
            path: '/check-path',
        },
    },
    backends: [
        virtualService,
    ],
});
node.addBackends(new appmesh.VirtualService(stack, 'service-2', {
    virtualServiceName: 'service2.domain.local',
    mesh,
}));
router.addRoute('route-1', {
    routeTargets: [
        {
            virtualNode: node,
            weight: 50,
        },
    ],
    prefix: '/',
});
const node2 = mesh.addVirtualNode('node2', {
    dnsHostName: `node2.${namespace.namespaceName}`,
    listener: {
        healthCheck: {
            healthyThreshold: 3,
            interval: cdk.Duration.seconds(5),
            path: '/check-path2',
            port: 8080,
            protocol: appmesh.Protocol.HTTP,
            timeout: cdk.Duration.seconds(2),
            unhealthyThreshold: 2,
        },
    },
    backends: [
        new appmesh.VirtualService(stack, 'service-3', {
            virtualServiceName: 'service3.domain.local',
            mesh,
        }),
    ],
});
const node3 = mesh.addVirtualNode('node3', {
    dnsHostName: `node3.${namespace.namespaceName}`,
    listener: {
        healthCheck: {
            healthyThreshold: 3,
            interval: cdk.Duration.seconds(5),
            path: '/check-path3',
            port: 8080,
            protocol: appmesh.Protocol.HTTP,
            timeout: cdk.Duration.seconds(2),
            unhealthyThreshold: 2,
        },
    },
});
router.addRoute('route-2', {
    routeTargets: [
        {
            virtualNode: node2,
            weight: 30,
        },
    ],
    prefix: '/path2',
});
router.addRoute('route-3', {
    routeTargets: [
        {
            virtualNode: node3,
            weight: 20,
        },
    ],
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubWVzaC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLm1lc2gudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSx3Q0FBd0M7QUFDeEMsMERBQTBEO0FBQzFELHFDQUFxQztBQUVyQyxtQ0FBbUM7QUFFdEIsUUFBQSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFFakMsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLFdBQUcsRUFBRSxZQUFZLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFFbkQsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUU7SUFDcEMsV0FBVyxFQUFFLENBQUM7Q0FDZixDQUFDLENBQUM7QUFFSCxNQUFNLFNBQVMsR0FBRyxJQUFJLFFBQVEsQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLEVBQUUsZ0JBQWdCLEVBQUU7SUFDMUUsR0FBRztJQUNILElBQUksRUFBRSxjQUFjO0NBQ3JCLENBQUMsQ0FBQztBQUVILE1BQU0sSUFBSSxHQUFHLElBQUksT0FBTyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFDN0MsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFFBQVEsRUFBRTtJQUM3QyxRQUFRLEVBQUU7UUFDUixXQUFXLEVBQUU7WUFDWCxJQUFJLEVBQUUsSUFBSTtZQUNWLFFBQVEsRUFBRSxPQUFPLENBQUMsUUFBUSxDQUFDLElBQUk7U0FDaEM7S0FDRjtDQUNGLENBQUMsQ0FBQztBQUVILE1BQU0sY0FBYyxHQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUU7SUFDdkQsYUFBYSxFQUFFLE1BQU07SUFDckIsa0JBQWtCLEVBQUUsdUJBQXVCO0NBQzVDLENBQUMsQ0FBQztBQUVILE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsTUFBTSxFQUFFO0lBQ3ZDLFdBQVcsRUFBRSxTQUFTLFNBQVMsQ0FBQyxhQUFhLEVBQUU7SUFDL0MsUUFBUSxFQUFFO1FBQ1IsV0FBVyxFQUFFO1lBQ1gsZ0JBQWdCLEVBQUUsQ0FBQztZQUNuQixJQUFJLEVBQUUsYUFBYTtTQUNwQjtLQUNGO0lBQ0QsUUFBUSxFQUFFO1FBQ1IsY0FBYztLQUNmO0NBQ0YsQ0FBQyxDQUFDO0FBRUgsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLE9BQU8sQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFFLFdBQVcsRUFBRTtJQUM5RCxrQkFBa0IsRUFBRSx1QkFBdUI7SUFDM0MsSUFBSTtDQUNMLENBQUMsQ0FDRCxDQUFDO0FBRUYsTUFBTSxDQUFDLFFBQVEsQ0FBQyxTQUFTLEVBQUU7SUFDekIsWUFBWSxFQUFFO1FBQ1o7WUFDRSxXQUFXLEVBQUUsSUFBSTtZQUNqQixNQUFNLEVBQUUsRUFBRTtTQUNYO0tBQ0Y7SUFDRCxNQUFNLEVBQUUsR0FBRztDQUNaLENBQUMsQ0FBQztBQUVILE1BQU0sS0FBSyxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxFQUFFO0lBQ3pDLFdBQVcsRUFBRSxTQUFTLFNBQVMsQ0FBQyxhQUFhLEVBQUU7SUFDL0MsUUFBUSxFQUFFO1FBQ1IsV0FBVyxFQUFFO1lBQ1gsZ0JBQWdCLEVBQUUsQ0FBQztZQUNuQixRQUFRLEVBQUUsR0FBRyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1lBQ2pDLElBQUksRUFBRSxjQUFjO1lBQ3BCLElBQUksRUFBRSxJQUFJO1lBQ1YsUUFBUSxFQUFFLE9BQU8sQ0FBQyxRQUFRLENBQUMsSUFBSTtZQUMvQixPQUFPLEVBQUUsR0FBRyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1lBQ2hDLGtCQUFrQixFQUFFLENBQUM7U0FDdEI7S0FDRjtJQUNELFFBQVEsRUFBRTtRQUNSLElBQUksT0FBTyxDQUFDLGNBQWMsQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFO1lBQzdDLGtCQUFrQixFQUFFLHVCQUF1QjtZQUMzQyxJQUFJO1NBQ0wsQ0FBQztLQUNIO0NBQ0YsQ0FBQyxDQUFDO0FBRUgsTUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxPQUFPLEVBQUU7SUFDekMsV0FBVyxFQUFFLFNBQVMsU0FBUyxDQUFDLGFBQWEsRUFBRTtJQUMvQyxRQUFRLEVBQUU7UUFDUixXQUFXLEVBQUU7WUFDWCxnQkFBZ0IsRUFBRSxDQUFDO1lBQ25CLFFBQVEsRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7WUFDakMsSUFBSSxFQUFFLGNBQWM7WUFDcEIsSUFBSSxFQUFFLElBQUk7WUFDVixRQUFRLEVBQUUsT0FBTyxDQUFDLFFBQVEsQ0FBQyxJQUFJO1lBQy9CLE9BQU8sRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7WUFDaEMsa0JBQWtCLEVBQUUsQ0FBQztTQUN0QjtLQUNGO0NBQ0YsQ0FBQyxDQUFDO0FBRUgsTUFBTSxDQUFDLFFBQVEsQ0FBQyxTQUFTLEVBQUU7SUFDekIsWUFBWSxFQUFFO1FBQ1o7WUFDRSxXQUFXLEVBQUUsS0FBSztZQUNsQixNQUFNLEVBQUUsRUFBRTtTQUNYO0tBQ0Y7SUFDRCxNQUFNLEVBQUUsUUFBUTtDQUNqQixDQUFDLENBQUM7QUFFSCxNQUFNLENBQUMsUUFBUSxDQUFDLFNBQVMsRUFBRTtJQUN6QixZQUFZLEVBQUU7UUFDWjtZQUNFLFdBQVcsRUFBRSxLQUFLO1lBQ2xCLE1BQU0sRUFBRSxFQUFFO1NBQ1g7S0FDRjtDQUNGLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGNsb3VkbWFwIGZyb20gJ0Bhd3MtY2RrL2F3cy1zZXJ2aWNlZGlzY292ZXJ5JztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuaW1wb3J0ICogYXMgYXBwbWVzaCBmcm9tICcuLi9saWIvJztcblxuZXhwb3J0IGNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5cbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdtZXNoLXN0YWNrJywge30pO1xuXG5jb25zdCB2cGMgPSBuZXcgZWMyLlZwYyhzdGFjaywgJ3ZwYycsIHtcbiAgbmF0R2F0ZXdheXM6IDEsXG59KTtcblxuY29uc3QgbmFtZXNwYWNlID0gbmV3IGNsb3VkbWFwLlByaXZhdGVEbnNOYW1lc3BhY2Uoc3RhY2ssICd0ZXN0LW5hbWVzcGFjZScsIHtcbiAgdnBjLFxuICBuYW1lOiAnZG9tYWluLmxvY2FsJyxcbn0pO1xuXG5jb25zdCBtZXNoID0gbmV3IGFwcG1lc2guTWVzaChzdGFjaywgJ21lc2gnKTtcbmNvbnN0IHJvdXRlciA9IG1lc2guYWRkVmlydHVhbFJvdXRlcigncm91dGVyJywge1xuICBsaXN0ZW5lcjoge1xuICAgIHBvcnRNYXBwaW5nOiB7XG4gICAgICBwb3J0OiA4MDgwLFxuICAgICAgcHJvdG9jb2w6IGFwcG1lc2guUHJvdG9jb2wuSFRUUCxcbiAgICB9LFxuICB9LFxufSk7XG5cbmNvbnN0IHZpcnR1YWxTZXJ2aWNlID0gbWVzaC5hZGRWaXJ0dWFsU2VydmljZSgnc2VydmljZScsIHtcbiAgdmlydHVhbFJvdXRlcjogcm91dGVyLFxuICB2aXJ0dWFsU2VydmljZU5hbWU6ICdzZXJ2aWNlMS5kb21haW4ubG9jYWwnLFxufSk7XG5cbmNvbnN0IG5vZGUgPSBtZXNoLmFkZFZpcnR1YWxOb2RlKCdub2RlJywge1xuICBkbnNIb3N0TmFtZTogYG5vZGUxLiR7bmFtZXNwYWNlLm5hbWVzcGFjZU5hbWV9YCxcbiAgbGlzdGVuZXI6IHtcbiAgICBoZWFsdGhDaGVjazoge1xuICAgICAgaGVhbHRoeVRocmVzaG9sZDogMyxcbiAgICAgIHBhdGg6ICcvY2hlY2stcGF0aCcsXG4gICAgfSxcbiAgfSxcbiAgYmFja2VuZHM6IFtcbiAgICB2aXJ0dWFsU2VydmljZSxcbiAgXSxcbn0pO1xuXG5ub2RlLmFkZEJhY2tlbmRzKG5ldyBhcHBtZXNoLlZpcnR1YWxTZXJ2aWNlKHN0YWNrLCAnc2VydmljZS0yJywge1xuICB2aXJ0dWFsU2VydmljZU5hbWU6ICdzZXJ2aWNlMi5kb21haW4ubG9jYWwnLFxuICBtZXNoLFxufSksXG4pO1xuXG5yb3V0ZXIuYWRkUm91dGUoJ3JvdXRlLTEnLCB7XG4gIHJvdXRlVGFyZ2V0czogW1xuICAgIHtcbiAgICAgIHZpcnR1YWxOb2RlOiBub2RlLFxuICAgICAgd2VpZ2h0OiA1MCxcbiAgICB9LFxuICBdLFxuICBwcmVmaXg6ICcvJyxcbn0pO1xuXG5jb25zdCBub2RlMiA9IG1lc2guYWRkVmlydHVhbE5vZGUoJ25vZGUyJywge1xuICBkbnNIb3N0TmFtZTogYG5vZGUyLiR7bmFtZXNwYWNlLm5hbWVzcGFjZU5hbWV9YCxcbiAgbGlzdGVuZXI6IHtcbiAgICBoZWFsdGhDaGVjazoge1xuICAgICAgaGVhbHRoeVRocmVzaG9sZDogMyxcbiAgICAgIGludGVydmFsOiBjZGsuRHVyYXRpb24uc2Vjb25kcyg1KSxcbiAgICAgIHBhdGg6ICcvY2hlY2stcGF0aDInLFxuICAgICAgcG9ydDogODA4MCxcbiAgICAgIHByb3RvY29sOiBhcHBtZXNoLlByb3RvY29sLkhUVFAsXG4gICAgICB0aW1lb3V0OiBjZGsuRHVyYXRpb24uc2Vjb25kcygyKSxcbiAgICAgIHVuaGVhbHRoeVRocmVzaG9sZDogMixcbiAgICB9LFxuICB9LFxuICBiYWNrZW5kczogW1xuICAgIG5ldyBhcHBtZXNoLlZpcnR1YWxTZXJ2aWNlKHN0YWNrLCAnc2VydmljZS0zJywge1xuICAgICAgdmlydHVhbFNlcnZpY2VOYW1lOiAnc2VydmljZTMuZG9tYWluLmxvY2FsJyxcbiAgICAgIG1lc2gsXG4gICAgfSksXG4gIF0sXG59KTtcblxuY29uc3Qgbm9kZTMgPSBtZXNoLmFkZFZpcnR1YWxOb2RlKCdub2RlMycsIHtcbiAgZG5zSG9zdE5hbWU6IGBub2RlMy4ke25hbWVzcGFjZS5uYW1lc3BhY2VOYW1lfWAsXG4gIGxpc3RlbmVyOiB7XG4gICAgaGVhbHRoQ2hlY2s6IHtcbiAgICAgIGhlYWx0aHlUaHJlc2hvbGQ6IDMsXG4gICAgICBpbnRlcnZhbDogY2RrLkR1cmF0aW9uLnNlY29uZHMoNSksXG4gICAgICBwYXRoOiAnL2NoZWNrLXBhdGgzJyxcbiAgICAgIHBvcnQ6IDgwODAsXG4gICAgICBwcm90b2NvbDogYXBwbWVzaC5Qcm90b2NvbC5IVFRQLFxuICAgICAgdGltZW91dDogY2RrLkR1cmF0aW9uLnNlY29uZHMoMiksXG4gICAgICB1bmhlYWx0aHlUaHJlc2hvbGQ6IDIsXG4gICAgfSxcbiAgfSxcbn0pO1xuXG5yb3V0ZXIuYWRkUm91dGUoJ3JvdXRlLTInLCB7XG4gIHJvdXRlVGFyZ2V0czogW1xuICAgIHtcbiAgICAgIHZpcnR1YWxOb2RlOiBub2RlMixcbiAgICAgIHdlaWdodDogMzAsXG4gICAgfSxcbiAgXSxcbiAgcHJlZml4OiAnL3BhdGgyJyxcbn0pO1xuXG5yb3V0ZXIuYWRkUm91dGUoJ3JvdXRlLTMnLCB7XG4gIHJvdXRlVGFyZ2V0czogW1xuICAgIHtcbiAgICAgIHZpcnR1YWxOb2RlOiBub2RlMyxcbiAgICAgIHdlaWdodDogMjAsXG4gICAgfSxcbiAgXSxcbn0pO1xuIl19