"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.readSchema = exports.loadProject = exports.writeConfig = exports.loadConfig = exports.ConflictHandlerType = exports.TRANSFORM_CURRENT_VERSION = exports.TRANSFORM_BASE_VERSION = exports.TRANSFORM_CONFIG_FILE_NAME = void 0;
const path = __importStar(require("path"));
const fileUtils_1 = require("./fileUtils");
const fs = require('fs-extra');
exports.TRANSFORM_CONFIG_FILE_NAME = `transform.conf.json`;
exports.TRANSFORM_BASE_VERSION = 4;
exports.TRANSFORM_CURRENT_VERSION = 5;
var ConflictHandlerType;
(function (ConflictHandlerType) {
    ConflictHandlerType["OPTIMISTIC"] = "OPTIMISTIC_CONCURRENCY";
    ConflictHandlerType["AUTOMERGE"] = "AUTOMERGE";
    ConflictHandlerType["LAMBDA"] = "LAMBDA";
})(ConflictHandlerType = exports.ConflictHandlerType || (exports.ConflictHandlerType = {}));
async function loadConfig(projectDir) {
    let config = {
        Version: exports.TRANSFORM_CURRENT_VERSION,
    };
    try {
        const configPath = path.join(projectDir, exports.TRANSFORM_CONFIG_FILE_NAME);
        const configExists = await fs.exists(configPath);
        if (configExists) {
            const configStr = await fs.readFile(configPath);
            config = JSON.parse(configStr.toString());
        }
        return config;
    }
    catch (err) {
        return config;
    }
}
exports.loadConfig = loadConfig;
async function writeConfig(projectDir, config) {
    const configFilePath = path.join(projectDir, exports.TRANSFORM_CONFIG_FILE_NAME);
    await fs.writeFile(configFilePath, JSON.stringify(config, null, 4));
    return config;
}
exports.writeConfig = writeConfig;
async function loadProject(projectDirectory, opts) {
    const schema = await readSchema(projectDirectory);
    const functions = {};
    if (!(opts && opts.disableFunctionOverrides === true)) {
        const functionDirectory = path.join(projectDirectory, 'functions');
        const functionDirectoryExists = await fs.exists(functionDirectory);
        if (functionDirectoryExists) {
            const functionFiles = await fs.readdir(functionDirectory);
            for (const functionFile of functionFiles) {
                if (functionFile.indexOf('.') === 0) {
                    continue;
                }
                const functionFilePath = path.join(functionDirectory, functionFile);
                functions[functionFile] = functionFilePath;
            }
        }
    }
    const pipelineFunctions = {};
    if (!(opts && opts.disablePipelineFunctionOverrides === true)) {
        const pipelineFunctionDirectory = path.join(projectDirectory, 'pipelineFunctions');
        const pipelineFunctionDirectoryExists = await fs.exists(pipelineFunctionDirectory);
        if (pipelineFunctionDirectoryExists) {
            const pipelineFunctionFiles = await fs.readdir(pipelineFunctionDirectory);
            for (const pipelineFunctionFile of pipelineFunctionFiles) {
                if (pipelineFunctionFile.indexOf('.') === 0) {
                    continue;
                }
                const pipelineFunctionPath = path.join(pipelineFunctionDirectory, pipelineFunctionFile);
                pipelineFunctions[pipelineFunctionFile] = await fs.readFile(pipelineFunctionPath);
            }
        }
    }
    const resolvers = {};
    if (!(opts && opts.disableResolverOverrides === true)) {
        const resolverDirectory = path.join(projectDirectory, 'resolvers');
        const resolverDirExists = await fs.exists(resolverDirectory);
        if (resolverDirExists) {
            const resolverFiles = await fs.readdir(resolverDirectory);
            for (const resolverFile of resolverFiles) {
                if (resolverFile.indexOf('.') === 0) {
                    continue;
                }
                const resolverFilePath = path.join(resolverDirectory, resolverFile);
                resolvers[resolverFile] = await fs.readFile(resolverFilePath);
            }
        }
    }
    const stacksDirectory = path.join(projectDirectory, 'stacks');
    const stacksDirExists = await fs.exists(stacksDirectory);
    const stacks = {};
    if (stacksDirExists) {
        const stackFiles = await fs.readdir(stacksDirectory);
        for (const stackFile of stackFiles) {
            if (stackFile.indexOf('.') === 0) {
                continue;
            }
            const stackFilePath = path.join(stacksDirectory, stackFile);
            fileUtils_1.throwIfNotJSONExt(stackFile);
            const stackBuffer = await fs.readFile(stackFilePath);
            try {
                stacks[stackFile] = JSON.parse(stackBuffer.toString());
            }
            catch (e) {
                throw new Error(`The CloudFormation template ${stackFiles} does not contain valid JSON.`);
            }
        }
    }
    const config = await loadConfig(projectDirectory);
    return {
        functions,
        pipelineFunctions,
        stacks,
        resolvers,
        schema,
        config,
    };
}
exports.loadProject = loadProject;
async function readSchema(projectDirectory) {
    const schemaFilePath = path.join(projectDirectory, 'schema.graphql');
    const schemaDirectoryPath = path.join(projectDirectory, 'schema');
    const schemaFileExists = await fs.exists(schemaFilePath);
    const schemaDirectoryExists = await fs.exists(schemaDirectoryPath);
    let schema;
    if (schemaFileExists) {
        schema = (await fs.readFile(schemaFilePath)).toString();
    }
    else if (schemaDirectoryExists) {
        schema = (await readSchemaDocuments(schemaDirectoryPath)).join('\n');
    }
    else {
        throw new Error(`Could not find a schema at ${schemaFilePath}`);
    }
    return schema;
}
exports.readSchema = readSchema;
async function readSchemaDocuments(schemaDirectoryPath) {
    const files = await fs.readdir(schemaDirectoryPath);
    let schemaDocuments = [];
    for (const fileName of files) {
        if (fileName.indexOf('.') === 0) {
            continue;
        }
        const fullPath = `${schemaDirectoryPath}/${fileName}`;
        const stats = await fs.lstat(fullPath);
        if (stats.isDirectory()) {
            const childDocs = await readSchemaDocuments(fullPath);
            schemaDocuments = schemaDocuments.concat(childDocs);
        }
        else if (stats.isFile()) {
            const schemaDoc = await fs.readFile(fullPath);
            schemaDocuments.push(schemaDoc);
        }
    }
    return schemaDocuments;
}
//# sourceMappingURL=transformConfig.js.map