import { Template } from 'cloudform-types';
import { ProjectOptions } from './amplifyUtils';
export declare const TRANSFORM_CONFIG_FILE_NAME = "transform.conf.json";
export declare const TRANSFORM_BASE_VERSION = 4;
export declare const TRANSFORM_CURRENT_VERSION = 5;
export interface TransformMigrationConfig {
    V1?: {
        Resources: string[];
    };
}
export declare const enum ConflictHandlerType {
    OPTIMISTIC = "OPTIMISTIC_CONCURRENCY",
    AUTOMERGE = "AUTOMERGE",
    LAMBDA = "LAMBDA"
}
export declare type ConflictDetectionType = 'VERSION' | 'NONE';
export declare type SyncConfigOPTIMISTIC = {
    ConflictDetection: ConflictDetectionType;
    ConflictHandler: ConflictHandlerType.OPTIMISTIC;
};
export declare type SyncConfigSERVER = {
    ConflictDetection: ConflictDetectionType;
    ConflictHandler: ConflictHandlerType.AUTOMERGE;
};
export declare type SyncConfigLAMBDA = {
    ConflictDetection: ConflictDetectionType;
    ConflictHandler: ConflictHandlerType.LAMBDA;
    LambdaConflictHandler: {
        name: string;
        region?: string;
        lambdaArn?: any;
    };
};
export declare type SyncConfig = SyncConfigOPTIMISTIC | SyncConfigSERVER | SyncConfigLAMBDA;
export declare type ResolverConfig = {
    project?: SyncConfig;
    models?: {
        [key: string]: SyncConfig;
    };
};
export interface TransformConfig {
    StackMapping?: {
        [resourceId: string]: string;
    };
    TransformerOptions?: {
        [transformer: string]: {
            [option: string]: any;
        };
    };
    Migration?: TransformMigrationConfig;
    Version?: number;
    ElasticsearchWarning?: boolean;
    ResolverConfig?: ResolverConfig;
    transformers?: string[];
    warningESMessage?: boolean;
}
export declare function loadConfig(projectDir: string): Promise<TransformConfig>;
export declare function writeConfig(projectDir: string, config: TransformConfig): Promise<TransformConfig>;
interface ProjectConfiguration {
    schema: string;
    functions: {
        [k: string]: string;
    };
    pipelineFunctions: {
        [k: string]: string;
    };
    resolvers: {
        [k: string]: string;
    };
    stacks: {
        [k: string]: Template;
    };
    config: TransformConfig;
}
export declare function loadProject(projectDirectory: string, opts?: ProjectOptions): Promise<ProjectConfiguration>;
export declare function readSchema(projectDirectory: string): Promise<string>;
export {};
//# sourceMappingURL=transformConfig.d.ts.map