import './polyfills/Object.assign';
import { TransformerContext } from './TransformerContext';
import { Transformer } from './Transformer';
import { ITransformer } from './ITransformer';
import { GraphQLTransform } from './GraphQLTransform';
import { collectDirectiveNames, collectDirectivesByTypeNames } from './collectDirectives';
import { stripDirectives } from './stripDirectives';
import { DeploymentResources } from './DeploymentResources';
import { buildProject as buildAPIProject, uploadDeployment as uploadAPIProject, migrateAPIProject, revertAPIMigration, CLOUDFORMATION_FILE_NAME, PARAMETERS_FILE_NAME } from './util/amplifyUtils';
import { readSchema as readProjectSchema, loadProject as readProjectConfiguration, loadConfig as readTransformerConfiguration, writeConfig as writeTransformerConfiguration, TRANSFORM_CONFIG_FILE_NAME, TRANSFORM_BASE_VERSION, TRANSFORM_CURRENT_VERSION, TransformConfig, ConflictHandlerType, ConflictDetectionType, ResolverConfig, SyncConfig } from './util/transformConfig';
export * from './errors';
export * from './util';
export declare function getAppSyncServiceExtraDirectives(): string;
export { FeatureFlagProvider } from './FeatureFlags';
export { GraphQLTransform, TransformConfig, TransformerContext, Transformer, ITransformer, collectDirectiveNames, collectDirectivesByTypeNames, stripDirectives, buildAPIProject, migrateAPIProject, uploadAPIProject, readProjectSchema, readProjectConfiguration, readTransformerConfiguration, writeTransformerConfiguration, revertAPIMigration, TRANSFORM_CONFIG_FILE_NAME, TRANSFORM_BASE_VERSION, TRANSFORM_CURRENT_VERSION, ConflictHandlerType, ConflictDetectionType, ResolverConfig, SyncConfig, DeploymentResources, CLOUDFORMATION_FILE_NAME, PARAMETERS_FILE_NAME, };
//# sourceMappingURL=index.d.ts.map