import { Construct, NestedStack } from '@aws-cdk/core';
import { GraphqlApi, FieldLogLevel, AuthorizationConfig } from '@aws-cdk/aws-appsync';
/**
 * (experimental) Properties for AppSyncTransformer Construct.
 *
 * @experimental
 * @link FieldLogLevel} type for AppSync GraphqlApi log level
 */
export interface AppSyncTransformerProps {
    /**
     * (experimental) Required.
     *
     * Relative path where schema.graphql exists
     *
     * @experimental
     */
    readonly schemaPath: string;
    /**
     * (experimental) Optional.
     *
     * {@link AuthorizationConfig} type defining authorization for AppSync GraphqlApi. Defaults to API_KEY
     *
     * @default API_KEY authorization config
     * @experimental
     */
    readonly authorizationConfig?: AuthorizationConfig;
    /**
     * (experimental) Optional.
     *
     * String value representing the api name
     *
     * @default `${id}-api`
     * @experimental
     */
    readonly apiName?: string;
    /**
     * (experimental) Optional.
     *
     * Boolean to enable DataStore Sync Tables
     *
     * @default false
     * @experimental
     */
    readonly syncEnabled?: boolean;
    /**
     * (experimental) Optional.
     *
     * {@link FieldLogLevel} type for AppSync GraphqlApi log level
     *
     * @default FieldLogLevel.NONE
     * @experimental
     */
    readonly fieldLogLevel?: FieldLogLevel;
}
/**
 * (experimental) AppSyncTransformer Construct.
 *
 * @experimental
 */
export declare class AppSyncTransformer extends Construct {
    /**
     * (experimental) The cdk GraphqlApi construct.
     *
     * @experimental
     */
    readonly appsyncAPI: GraphqlApi;
    /**
     * (experimental) The NestedStack that contains the AppSync resources.
     *
     * @experimental
     */
    readonly nestedAppsyncStack: NestedStack;
    /**
     * (experimental) Map of cdk table tokens to table names.
     *
     * @experimental
     */
    readonly tableNameMap: any;
    /**
     * (experimental) The outputs from the SchemaTransformer.
     *
     * @experimental
     */
    readonly outputs: any;
    /**
     * (experimental) The AppSync resolvers from the transformer minus any function resolvers.
     *
     * @experimental
     */
    readonly resolvers: any;
    /**
     * (experimental) The Lambda Function resolvers designated by the function directive.
     *
     * @experimental
     */
    readonly functionResolvers: any;
    private isSyncEnabled;
    private syncTable;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AppSyncTransformerProps);
    private createNoneDataSourceAndResolvers;
    private createTablesAndResolvers;
    private createTable;
    private createSyncTable;
    private convertAttributeType;
    private convertProjectionType;
}
