#cheese

import sys
import os
import requests
from pathlib import Path


from Cheese.cheeser import Cheeser
from Cheese.metadata import Metadata
from Cheese.resourceManager import ResMan
from Cheese.appSettings import Settings
from Cheese.cheeseServer import *
from Cheese.database import Database
from Cheese.cheeseRepository import CheeseRepository
from Cheese.ErrorCodes import Error
from Cheese.Logger import Logger

"""
File generated by Cheese Framework

initialize Cheese Application
"""

class CheeseBurger:

    @staticmethod
    def init(file):
        # initialization of root directory
        ResMan.setPath(Path(file).parent.parent)

        # application build
        Cheeser.build()

        # loads metadata
        Metadata.loadMedatada()

        # loads application settings
        Settings.loadSettings()

        #init logger
        Logger.initLogger()

        # init errors
        Error.init()

        # check licence
        CheeseBurger.loadLicence()

        # log new line
        Logger.info(10*"=" + f"Start in file {ResMan.path}" + 10*"=" + "\n", False, False)

        # connect to database
        if (Settings.allowDB):
            Logger.warning("Initializing database connection...", silence=False)
            try:
                db = Database()
                db.connect()
                db.close()
                Logger.okBlue(f"CONNECTED TO {Settings.dbHost}:{Settings.dbPort} {Settings.dbName}", silence=False)
            except Exception as e:
                Logger.fail(f"CONNECTION TO {Settings.dbHost}:{Settings.dbPort} {Settings.dbName} CANNOT BE DONE", e, silence=False)
        else:
            Logger.warning("Database connection is turned off", silence=False)

        # initialization of server
        CheeseBurger.initServer()

    # initialization application server
    @staticmethod
    def initServer():
        if (Settings.allowMultiThreading):
            CheeseBurger.server = CheeseServerMulti((Settings.host, Settings.port), CheeseHandler)
        else:
            CheeseBurger.server = CheeseServer((Settings.host, Settings.port), CheeseHandler)

    # start server
    @staticmethod
    def serveForever():
        Logger.info(f"Server Starts - {Settings.host}:{Settings.port}", silence=False)
        try:
            CheeseBurger.server.serve_forever()
        except KeyboardInterrupt:
            pass
        except OSError:
            Logger.warning("SHUTING SERVER DOWN")
        except Exception as e:
            Logger.fail("UNKNOWN ERROR WHILE RUNNING SERVER ", e)
        Logger.info(f"Server Stops - {Settings.host}:{Settings.port}", silence=False)
        sys.exit()

    # loads licence
    @staticmethod
    def loadLicence():
        try:
            r = requests.get(f"http://frogie.cz:6969/licence/authLic?code={Settings.licenseCode}")
            Settings.activeLicense = json.loads(r.text)["LICENCE"]
            print("License: " + Settings.activeLicense)
            print("")
        except Exception as e:
            Logger.warning("Unable to contact licensing server", silence=False)

    

