import textwrap

import pytest

from neoteroi.mkdocs.oad import MkDocsOpenAPIDocumentationPlugin

from . import get_resource_file_path


def test_markdown_without_oad():
    handler = MkDocsOpenAPIDocumentationPlugin()

    example = textwrap.dedent(
        """
        # Hello World!

        Lorem ipsum dolor sit amet.
        """.strip(
            "\n"
        )
    )

    result = handler.on_page_markdown(example)
    assert result == example


@pytest.mark.parametrize("file_name", ["swagger.json", "swagger.yaml"])
def test_markdown_with_oad(file_name):
    file_path = get_resource_file_path(file_name)
    handler = MkDocsOpenAPIDocumentationPlugin()

    example = textwrap.dedent(
        f"""
        # Hello World!

        [OAD({file_path})]
        """.strip(
            "\n"
        )
    )

    result = handler.on_page_markdown(example)

    # Note: not testing the full output since this responsibility belongs to the
    # essentials-openapi package
    assert "This Markdown has been generated by essentials-openapi" in result
    assert "# Swagger Petstore" in result
