# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_gateway_spi.client import Client as SPIClient
from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_gateway_pop.client import Client as GatewayClientClient
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_vpc20160428 import models as vpc_20160428_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    _client: SPIClient = None

    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._client = GatewayClientClient()
        self._spi = self._client
        self._endpoint_rule = 'regional'
        self._endpoint_map = {
            'cn-qingdao': 'vpc.aliyuncs.com',
            'cn-beijing': 'vpc.aliyuncs.com',
            'cn-hangzhou': 'vpc.aliyuncs.com',
            'cn-shanghai': 'vpc.aliyuncs.com',
            'cn-shenzhen': 'vpc.aliyuncs.com',
            'cn-hongkong': 'vpc.aliyuncs.com',
            'ap-southeast-1': 'vpc.aliyuncs.com',
            'us-east-1': 'vpc.aliyuncs.com',
            'us-west-1': 'vpc.aliyuncs.com',
            'cn-shanghai-finance-1': 'vpc.aliyuncs.com',
            'cn-shenzhen-finance-1': 'vpc.aliyuncs.com',
            'cn-north-2-gov-1': 'vpc.aliyuncs.com',
            'ap-northeast-2-pop': 'vpc.aliyuncs.com',
            'cn-beijing-finance-1': 'vpc.aliyuncs.com',
            'cn-beijing-finance-pop': 'vpc.aliyuncs.com',
            'cn-beijing-gov-1': 'vpc.aliyuncs.com',
            'cn-beijing-nu16-b01': 'vpc.aliyuncs.com',
            'cn-edge-1': 'vpc-nebula.cn-qingdao-nebula.aliyuncs.com',
            'cn-fujian': 'vpc.aliyuncs.com',
            'cn-haidian-cm12-c01': 'vpc.aliyuncs.com',
            'cn-hangzhou-bj-b01': 'vpc.aliyuncs.com',
            'cn-hangzhou-finance': 'vpc.aliyuncs.com',
            'cn-hangzhou-internal-prod-1': 'vpc.aliyuncs.com',
            'cn-hangzhou-internal-test-1': 'vpc.aliyuncs.com',
            'cn-hangzhou-internal-test-2': 'vpc.aliyuncs.com',
            'cn-hangzhou-internal-test-3': 'vpc.aliyuncs.com',
            'cn-hangzhou-test-306': 'vpc.aliyuncs.com',
            'cn-hongkong-finance-pop': 'vpc.aliyuncs.com',
            'cn-huhehaote-nebula-1': 'vpc-nebula.cn-qingdao-nebula.aliyuncs.com',
            'cn-qingdao-nebula': 'vpc-nebula.cn-qingdao-nebula.aliyuncs.com',
            'cn-shanghai-et15-b01': 'vpc.aliyuncs.com',
            'cn-shanghai-et2-b01': 'vpc.aliyuncs.com',
            'cn-shanghai-inner': 'vpc.aliyuncs.com',
            'cn-shanghai-internal-test-1': 'vpc.aliyuncs.com',
            'cn-shenzhen-inner': 'vpc.aliyuncs.com',
            'cn-shenzhen-st4-d01': 'vpc.aliyuncs.com',
            'cn-shenzhen-su18-b01': 'vpc.aliyuncs.com',
            'cn-wuhan': 'vpc.aliyuncs.com',
            'cn-yushanfang': 'vpc.aliyuncs.com',
            'cn-zhangbei': 'vpc.aliyuncs.com',
            'cn-zhangbei-na61-b01': 'vpc.aliyuncs.com',
            'cn-zhangjiakou-na62-a01': 'vpc.cn-zhangjiakou.aliyuncs.com',
            'cn-zhengzhou-nebula-1': 'vpc-nebula.cn-qingdao-nebula.aliyuncs.com',
            'eu-west-1-oxs': 'vpc-nebula.cn-shenzhen-cloudstone.aliyuncs.com',
            'rus-west-1-pop': 'vpc.aliyuncs.com'
        }
        self.check_config(config)
        self._endpoint = self.get_endpoint('vpc', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def activate_router_interface_with_options(
        self,
        request: vpc_20160428_models.ActivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ActivateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ActivateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ActivateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def activate_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.ActivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ActivateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ActivateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ActivateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def activate_router_interface(
        self,
        request: vpc_20160428_models.ActivateRouterInterfaceRequest,
    ) -> vpc_20160428_models.ActivateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return self.activate_router_interface_with_options(request, runtime)

    async def activate_router_interface_async(
        self,
        request: vpc_20160428_models.ActivateRouterInterfaceRequest,
    ) -> vpc_20160428_models.ActivateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.activate_router_interface_with_options_async(request, runtime)

    def active_flow_log_with_options(
        self,
        request: vpc_20160428_models.ActiveFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ActiveFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        query['FlowLogId'] = request.flow_log_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ActiveFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ActiveFlowLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def active_flow_log_with_options_async(
        self,
        request: vpc_20160428_models.ActiveFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ActiveFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        query['FlowLogId'] = request.flow_log_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ActiveFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ActiveFlowLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def active_flow_log(
        self,
        request: vpc_20160428_models.ActiveFlowLogRequest,
    ) -> vpc_20160428_models.ActiveFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return self.active_flow_log_with_options(request, runtime)

    async def active_flow_log_async(
        self,
        request: vpc_20160428_models.ActiveFlowLogRequest,
    ) -> vpc_20160428_models.ActiveFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return await self.active_flow_log_with_options_async(request, runtime)

    def add_bgp_network_with_options(
        self,
        request: vpc_20160428_models.AddBgpNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddBgpNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DstCidrBlock'] = request.dst_cidr_block
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterId'] = request.router_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AddBgpNetwork',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddBgpNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_bgp_network_with_options_async(
        self,
        request: vpc_20160428_models.AddBgpNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddBgpNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DstCidrBlock'] = request.dst_cidr_block
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterId'] = request.router_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AddBgpNetwork',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddBgpNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_bgp_network(
        self,
        request: vpc_20160428_models.AddBgpNetworkRequest,
    ) -> vpc_20160428_models.AddBgpNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_bgp_network_with_options(request, runtime)

    async def add_bgp_network_async(
        self,
        request: vpc_20160428_models.AddBgpNetworkRequest,
    ) -> vpc_20160428_models.AddBgpNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_bgp_network_with_options_async(request, runtime)

    def add_common_bandwidth_package_ip_with_options(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['ClientToken'] = request.client_token
        query['IpInstanceId'] = request.ip_instance_id
        query['IpType'] = request.ip_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AddCommonBandwidthPackageIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddCommonBandwidthPackageIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_common_bandwidth_package_ip_with_options_async(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['ClientToken'] = request.client_token
        query['IpInstanceId'] = request.ip_instance_id
        query['IpType'] = request.ip_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AddCommonBandwidthPackageIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddCommonBandwidthPackageIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_common_bandwidth_package_ip(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpRequest,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_common_bandwidth_package_ip_with_options(request, runtime)

    async def add_common_bandwidth_package_ip_async(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpRequest,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_common_bandwidth_package_ip_with_options_async(request, runtime)

    def add_common_bandwidth_package_ips_with_options(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['ClientToken'] = request.client_token
        query['IpInstanceIds'] = request.ip_instance_ids
        query['IpType'] = request.ip_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AddCommonBandwidthPackageIps',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddCommonBandwidthPackageIpsResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_common_bandwidth_package_ips_with_options_async(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['ClientToken'] = request.client_token
        query['IpInstanceIds'] = request.ip_instance_ids
        query['IpType'] = request.ip_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AddCommonBandwidthPackageIps',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddCommonBandwidthPackageIpsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_common_bandwidth_package_ips(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpsRequest,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpsResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_common_bandwidth_package_ips_with_options(request, runtime)

    async def add_common_bandwidth_package_ips_async(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpsRequest,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_common_bandwidth_package_ips_with_options_async(request, runtime)

    def add_global_acceleration_instance_ip_with_options(
        self,
        request: vpc_20160428_models.AddGlobalAccelerationInstanceIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse:
        UtilClient.validate_model(request)
        query = {}
        query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        query['IpInstanceId'] = request.ip_instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AddGlobalAccelerationInstanceIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_global_acceleration_instance_ip_with_options_async(
        self,
        request: vpc_20160428_models.AddGlobalAccelerationInstanceIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse:
        UtilClient.validate_model(request)
        query = {}
        query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        query['IpInstanceId'] = request.ip_instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AddGlobalAccelerationInstanceIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_global_acceleration_instance_ip(
        self,
        request: vpc_20160428_models.AddGlobalAccelerationInstanceIpRequest,
    ) -> vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_global_acceleration_instance_ip_with_options(request, runtime)

    async def add_global_acceleration_instance_ip_async(
        self,
        request: vpc_20160428_models.AddGlobalAccelerationInstanceIpRequest,
    ) -> vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_global_acceleration_instance_ip_with_options_async(request, runtime)

    def add_ipv_6translator_acl_list_entry_with_options(
        self,
        request: vpc_20160428_models.AddIPv6TranslatorAclListEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclEntryComment'] = request.acl_entry_comment
        query['AclEntryIp'] = request.acl_entry_ip
        query['AclId'] = request.acl_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AddIPv6TranslatorAclListEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_ipv_6translator_acl_list_entry_with_options_async(
        self,
        request: vpc_20160428_models.AddIPv6TranslatorAclListEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclEntryComment'] = request.acl_entry_comment
        query['AclEntryIp'] = request.acl_entry_ip
        query['AclId'] = request.acl_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AddIPv6TranslatorAclListEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_ipv_6translator_acl_list_entry(
        self,
        request: vpc_20160428_models.AddIPv6TranslatorAclListEntryRequest,
    ) -> vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_ipv_6translator_acl_list_entry_with_options(request, runtime)

    async def add_ipv_6translator_acl_list_entry_async(
        self,
        request: vpc_20160428_models.AddIPv6TranslatorAclListEntryRequest,
    ) -> vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_ipv_6translator_acl_list_entry_with_options_async(request, runtime)

    def add_sources_to_traffic_mirror_session_with_options(
        self,
        request: vpc_20160428_models.AddSourcesToTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorSessionId'] = request.traffic_mirror_session_id
        query['TrafficMirrorSourceIds'] = request.traffic_mirror_source_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AddSourcesToTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_sources_to_traffic_mirror_session_with_options_async(
        self,
        request: vpc_20160428_models.AddSourcesToTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorSessionId'] = request.traffic_mirror_session_id
        query['TrafficMirrorSourceIds'] = request.traffic_mirror_source_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AddSourcesToTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_sources_to_traffic_mirror_session(
        self,
        request: vpc_20160428_models.AddSourcesToTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_sources_to_traffic_mirror_session_with_options(request, runtime)

    async def add_sources_to_traffic_mirror_session_async(
        self,
        request: vpc_20160428_models.AddSourcesToTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_sources_to_traffic_mirror_session_with_options_async(request, runtime)

    def allocate_eip_address_with_options(
        self,
        request: vpc_20160428_models.AllocateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ActivityId'] = request.activity_id
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['ISP'] = request.isp
        query['InstanceChargeType'] = request.instance_charge_type
        query['InternetChargeType'] = request.internet_charge_type
        query['Name'] = request.name
        query['Netmode'] = request.netmode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecurityProtectionTypes'] = request.security_protection_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AllocateEipAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_eip_address_with_options_async(
        self,
        request: vpc_20160428_models.AllocateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ActivityId'] = request.activity_id
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['ISP'] = request.isp
        query['InstanceChargeType'] = request.instance_charge_type
        query['InternetChargeType'] = request.internet_charge_type
        query['Name'] = request.name
        query['Netmode'] = request.netmode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecurityProtectionTypes'] = request.security_protection_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AllocateEipAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_eip_address(
        self,
        request: vpc_20160428_models.AllocateEipAddressRequest,
    ) -> vpc_20160428_models.AllocateEipAddressResponse:
        runtime = util_models.RuntimeOptions()
        return self.allocate_eip_address_with_options(request, runtime)

    async def allocate_eip_address_async(
        self,
        request: vpc_20160428_models.AllocateEipAddressRequest,
    ) -> vpc_20160428_models.AllocateEipAddressResponse:
        runtime = util_models.RuntimeOptions()
        return await self.allocate_eip_address_with_options_async(request, runtime)

    def allocate_eip_address_pro_with_options(
        self,
        request: vpc_20160428_models.AllocateEipAddressProRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipAddressProResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['ISP'] = request.isp
        query['InstanceChargeType'] = request.instance_charge_type
        query['InstanceId'] = request.instance_id
        query['InternetChargeType'] = request.internet_charge_type
        query['IpAddress'] = request.ip_address
        query['Netmode'] = request.netmode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecurityProtectionTypes'] = request.security_protection_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AllocateEipAddressPro',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipAddressProResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_eip_address_pro_with_options_async(
        self,
        request: vpc_20160428_models.AllocateEipAddressProRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipAddressProResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['ISP'] = request.isp
        query['InstanceChargeType'] = request.instance_charge_type
        query['InstanceId'] = request.instance_id
        query['InternetChargeType'] = request.internet_charge_type
        query['IpAddress'] = request.ip_address
        query['Netmode'] = request.netmode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecurityProtectionTypes'] = request.security_protection_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AllocateEipAddressPro',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipAddressProResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_eip_address_pro(
        self,
        request: vpc_20160428_models.AllocateEipAddressProRequest,
    ) -> vpc_20160428_models.AllocateEipAddressProResponse:
        runtime = util_models.RuntimeOptions()
        return self.allocate_eip_address_pro_with_options(request, runtime)

    async def allocate_eip_address_pro_async(
        self,
        request: vpc_20160428_models.AllocateEipAddressProRequest,
    ) -> vpc_20160428_models.AllocateEipAddressProResponse:
        runtime = util_models.RuntimeOptions()
        return await self.allocate_eip_address_pro_with_options_async(request, runtime)

    def allocate_eip_segment_address_with_options(
        self,
        request: vpc_20160428_models.AllocateEipSegmentAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipSegmentAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['EipMask'] = request.eip_mask
        query['InternetChargeType'] = request.internet_charge_type
        query['Isp'] = request.isp
        query['Netmode'] = request.netmode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AllocateEipSegmentAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipSegmentAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_eip_segment_address_with_options_async(
        self,
        request: vpc_20160428_models.AllocateEipSegmentAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipSegmentAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['EipMask'] = request.eip_mask
        query['InternetChargeType'] = request.internet_charge_type
        query['Isp'] = request.isp
        query['Netmode'] = request.netmode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AllocateEipSegmentAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipSegmentAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_eip_segment_address(
        self,
        request: vpc_20160428_models.AllocateEipSegmentAddressRequest,
    ) -> vpc_20160428_models.AllocateEipSegmentAddressResponse:
        runtime = util_models.RuntimeOptions()
        return self.allocate_eip_segment_address_with_options(request, runtime)

    async def allocate_eip_segment_address_async(
        self,
        request: vpc_20160428_models.AllocateEipSegmentAddressRequest,
    ) -> vpc_20160428_models.AllocateEipSegmentAddressResponse:
        runtime = util_models.RuntimeOptions()
        return await self.allocate_eip_segment_address_with_options_async(request, runtime)

    def allocate_ipv_6internet_bandwidth_with_options(
        self,
        request: vpc_20160428_models.AllocateIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateIpv6InternetBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['InternetChargeType'] = request.internet_charge_type
        query['Ipv6AddressId'] = request.ipv_6address_id
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AllocateIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateIpv6InternetBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_ipv_6internet_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.AllocateIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateIpv6InternetBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['InternetChargeType'] = request.internet_charge_type
        query['Ipv6AddressId'] = request.ipv_6address_id
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AllocateIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateIpv6InternetBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_ipv_6internet_bandwidth(
        self,
        request: vpc_20160428_models.AllocateIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.AllocateIpv6InternetBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return self.allocate_ipv_6internet_bandwidth_with_options(request, runtime)

    async def allocate_ipv_6internet_bandwidth_async(
        self,
        request: vpc_20160428_models.AllocateIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.AllocateIpv6InternetBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return await self.allocate_ipv_6internet_bandwidth_with_options_async(request, runtime)

    def apply_physical_connection_loawith_options(
        self,
        request: vpc_20160428_models.ApplyPhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ApplyPhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['CompanyName'] = request.company_name
        query['ConstructionTime'] = request.construction_time
        query['InstanceId'] = request.instance_id
        query['LineType'] = request.line_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PMInfo'] = request.pminfo
        query['PeerLocation'] = request.peer_location
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Si'] = request.si
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ApplyPhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ApplyPhysicalConnectionLOAResponse(),
            self.call_api(params, req, runtime)
        )

    async def apply_physical_connection_loawith_options_async(
        self,
        request: vpc_20160428_models.ApplyPhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ApplyPhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['CompanyName'] = request.company_name
        query['ConstructionTime'] = request.construction_time
        query['InstanceId'] = request.instance_id
        query['LineType'] = request.line_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PMInfo'] = request.pminfo
        query['PeerLocation'] = request.peer_location
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Si'] = request.si
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ApplyPhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ApplyPhysicalConnectionLOAResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def apply_physical_connection_loa(
        self,
        request: vpc_20160428_models.ApplyPhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.ApplyPhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return self.apply_physical_connection_loawith_options(request, runtime)

    async def apply_physical_connection_loa_async(
        self,
        request: vpc_20160428_models.ApplyPhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.ApplyPhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return await self.apply_physical_connection_loawith_options_async(request, runtime)

    def associate_eip_address_with_options(
        self,
        request: vpc_20160428_models.AssociateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateEipAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AllocationId'] = request.allocation_id
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['InstanceRegionId'] = request.instance_region_id
        query['InstanceType'] = request.instance_type
        query['Mode'] = request.mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PrivateIpAddress'] = request.private_ip_address
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateEipAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateEipAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_eip_address_with_options_async(
        self,
        request: vpc_20160428_models.AssociateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateEipAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AllocationId'] = request.allocation_id
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['InstanceRegionId'] = request.instance_region_id
        query['InstanceType'] = request.instance_type
        query['Mode'] = request.mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PrivateIpAddress'] = request.private_ip_address
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateEipAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateEipAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_eip_address(
        self,
        request: vpc_20160428_models.AssociateEipAddressRequest,
    ) -> vpc_20160428_models.AssociateEipAddressResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_eip_address_with_options(request, runtime)

    async def associate_eip_address_async(
        self,
        request: vpc_20160428_models.AssociateEipAddressRequest,
    ) -> vpc_20160428_models.AssociateEipAddressResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_eip_address_with_options_async(request, runtime)

    def associate_global_acceleration_instance_with_options(
        self,
        request: vpc_20160428_models.AssociateGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BackendServerId'] = request.backend_server_id
        query['BackendServerRegionId'] = request.backend_server_region_id
        query['BackendServerType'] = request.backend_server_type
        query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_global_acceleration_instance_with_options_async(
        self,
        request: vpc_20160428_models.AssociateGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BackendServerId'] = request.backend_server_id
        query['BackendServerRegionId'] = request.backend_server_region_id
        query['BackendServerType'] = request.backend_server_type
        query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_global_acceleration_instance(
        self,
        request: vpc_20160428_models.AssociateGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_global_acceleration_instance_with_options(request, runtime)

    async def associate_global_acceleration_instance_async(
        self,
        request: vpc_20160428_models.AssociateGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_global_acceleration_instance_with_options_async(request, runtime)

    def associate_ha_vip_with_options(
        self,
        request: vpc_20160428_models.AssociateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateHaVipResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['HaVipId'] = request.ha_vip_id
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_ha_vip_with_options_async(
        self,
        request: vpc_20160428_models.AssociateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateHaVipResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['HaVipId'] = request.ha_vip_id
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_ha_vip(
        self,
        request: vpc_20160428_models.AssociateHaVipRequest,
    ) -> vpc_20160428_models.AssociateHaVipResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_ha_vip_with_options(request, runtime)

    async def associate_ha_vip_async(
        self,
        request: vpc_20160428_models.AssociateHaVipRequest,
    ) -> vpc_20160428_models.AssociateHaVipResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_ha_vip_with_options_async(request, runtime)

    def associate_network_acl_with_options(
        self,
        request: vpc_20160428_models.AssociateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NetworkAclId'] = request.network_acl_id
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['Resource'] = request.resource
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateNetworkAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_network_acl_with_options_async(
        self,
        request: vpc_20160428_models.AssociateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NetworkAclId'] = request.network_acl_id
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['Resource'] = request.resource
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateNetworkAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_network_acl(
        self,
        request: vpc_20160428_models.AssociateNetworkAclRequest,
    ) -> vpc_20160428_models.AssociateNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_network_acl_with_options(request, runtime)

    async def associate_network_acl_async(
        self,
        request: vpc_20160428_models.AssociateNetworkAclRequest,
    ) -> vpc_20160428_models.AssociateNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_network_acl_with_options_async(request, runtime)

    def associate_physical_connection_to_virtual_border_router_with_options(
        self,
        request: vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CircuitCode'] = request.circuit_code
        query['ClientToken'] = request.client_token
        query['EnableIpv6'] = request.enable_ipv_6
        query['LocalGatewayIp'] = request.local_gateway_ip
        query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerGatewayIp'] = request.peer_gateway_ip
        query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        query['PeeringSubnetMask'] = request.peering_subnet_mask
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrId'] = request.vbr_id
        query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociatePhysicalConnectionToVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_physical_connection_to_virtual_border_router_with_options_async(
        self,
        request: vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CircuitCode'] = request.circuit_code
        query['ClientToken'] = request.client_token
        query['EnableIpv6'] = request.enable_ipv_6
        query['LocalGatewayIp'] = request.local_gateway_ip
        query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerGatewayIp'] = request.peer_gateway_ip
        query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        query['PeeringSubnetMask'] = request.peering_subnet_mask
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrId'] = request.vbr_id
        query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociatePhysicalConnectionToVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_physical_connection_to_virtual_border_router(
        self,
        request: vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_physical_connection_to_virtual_border_router_with_options(request, runtime)

    async def associate_physical_connection_to_virtual_border_router_async(
        self,
        request: vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_physical_connection_to_virtual_border_router_with_options_async(request, runtime)

    def associate_route_table_with_options(
        self,
        request: vpc_20160428_models.AssociateRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTableResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTableResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_route_table_with_options_async(
        self,
        request: vpc_20160428_models.AssociateRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTableResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTableResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_route_table(
        self,
        request: vpc_20160428_models.AssociateRouteTableRequest,
    ) -> vpc_20160428_models.AssociateRouteTableResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_route_table_with_options(request, runtime)

    async def associate_route_table_async(
        self,
        request: vpc_20160428_models.AssociateRouteTableRequest,
    ) -> vpc_20160428_models.AssociateRouteTableResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_route_table_with_options_async(request, runtime)

    def associate_route_table_with_gateway_with_options(
        self,
        request: vpc_20160428_models.AssociateRouteTableWithGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTableWithGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['GatewayId'] = request.gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateRouteTableWithGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTableWithGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_route_table_with_gateway_with_options_async(
        self,
        request: vpc_20160428_models.AssociateRouteTableWithGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTableWithGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['GatewayId'] = request.gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateRouteTableWithGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTableWithGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_route_table_with_gateway(
        self,
        request: vpc_20160428_models.AssociateRouteTableWithGatewayRequest,
    ) -> vpc_20160428_models.AssociateRouteTableWithGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_route_table_with_gateway_with_options(request, runtime)

    async def associate_route_table_with_gateway_async(
        self,
        request: vpc_20160428_models.AssociateRouteTableWithGatewayRequest,
    ) -> vpc_20160428_models.AssociateRouteTableWithGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_route_table_with_gateway_with_options_async(request, runtime)

    def associate_route_tables_with_vpc_gateway_endpoint_with_options(
        self,
        request: vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EndpointId'] = request.endpoint_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableIds'] = request.route_table_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateRouteTablesWithVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_route_tables_with_vpc_gateway_endpoint_with_options_async(
        self,
        request: vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EndpointId'] = request.endpoint_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableIds'] = request.route_table_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateRouteTablesWithVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_route_tables_with_vpc_gateway_endpoint(
        self,
        request: vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_route_tables_with_vpc_gateway_endpoint_with_options(request, runtime)

    async def associate_route_tables_with_vpc_gateway_endpoint_async(
        self,
        request: vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_route_tables_with_vpc_gateway_endpoint_with_options_async(request, runtime)

    def associate_vpc_cidr_block_with_options(
        self,
        request: vpc_20160428_models.AssociateVpcCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateVpcCidrBlockResponse:
        UtilClient.validate_model(request)
        query = {}
        query['IpVersion'] = request.ip_version
        query['Ipv6Isp'] = request.ipv_6isp
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecondaryCidrBlock'] = request.secondary_cidr_block
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateVpcCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateVpcCidrBlockResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_vpc_cidr_block_with_options_async(
        self,
        request: vpc_20160428_models.AssociateVpcCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateVpcCidrBlockResponse:
        UtilClient.validate_model(request)
        query = {}
        query['IpVersion'] = request.ip_version
        query['Ipv6Isp'] = request.ipv_6isp
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecondaryCidrBlock'] = request.secondary_cidr_block
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateVpcCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateVpcCidrBlockResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_vpc_cidr_block(
        self,
        request: vpc_20160428_models.AssociateVpcCidrBlockRequest,
    ) -> vpc_20160428_models.AssociateVpcCidrBlockResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_vpc_cidr_block_with_options(request, runtime)

    async def associate_vpc_cidr_block_async(
        self,
        request: vpc_20160428_models.AssociateVpcCidrBlockRequest,
    ) -> vpc_20160428_models.AssociateVpcCidrBlockResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_vpc_cidr_block_with_options_async(request, runtime)

    def associate_vpn_gateway_with_certificate_with_options(
        self,
        request: vpc_20160428_models.AssociateVpnGatewayWithCertificateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CertificateId'] = request.certificate_id
        query['CertificateType'] = request.certificate_type
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['RegionId'] = request.region_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateVpnGatewayWithCertificate',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_vpn_gateway_with_certificate_with_options_async(
        self,
        request: vpc_20160428_models.AssociateVpnGatewayWithCertificateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CertificateId'] = request.certificate_id
        query['CertificateType'] = request.certificate_type
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['RegionId'] = request.region_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AssociateVpnGatewayWithCertificate',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_vpn_gateway_with_certificate(
        self,
        request: vpc_20160428_models.AssociateVpnGatewayWithCertificateRequest,
    ) -> vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_vpn_gateway_with_certificate_with_options(request, runtime)

    async def associate_vpn_gateway_with_certificate_async(
        self,
        request: vpc_20160428_models.AssociateVpnGatewayWithCertificateRequest,
    ) -> vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_vpn_gateway_with_certificate_with_options_async(request, runtime)

    def attach_dhcp_options_set_to_vpc_with_options(
        self,
        request: vpc_20160428_models.AttachDhcpOptionsSetToVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AttachDhcpOptionsSetToVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_dhcp_options_set_to_vpc_with_options_async(
        self,
        request: vpc_20160428_models.AttachDhcpOptionsSetToVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AttachDhcpOptionsSetToVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_dhcp_options_set_to_vpc(
        self,
        request: vpc_20160428_models.AttachDhcpOptionsSetToVpcRequest,
    ) -> vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse:
        runtime = util_models.RuntimeOptions()
        return self.attach_dhcp_options_set_to_vpc_with_options(request, runtime)

    async def attach_dhcp_options_set_to_vpc_async(
        self,
        request: vpc_20160428_models.AttachDhcpOptionsSetToVpcRequest,
    ) -> vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse:
        runtime = util_models.RuntimeOptions()
        return await self.attach_dhcp_options_set_to_vpc_with_options_async(request, runtime)

    def attach_vbr_to_vpconn_with_options(
        self,
        request: vpc_20160428_models.AttachVbrToVpconnRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AttachVbrToVpconnResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['RegionId'] = request.region_id
        query['Token'] = request.token
        query['VbrId'] = request.vbr_id
        query['VpconnId'] = request.vpconn_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AttachVbrToVpconn',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AttachVbrToVpconnResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_vbr_to_vpconn_with_options_async(
        self,
        request: vpc_20160428_models.AttachVbrToVpconnRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AttachVbrToVpconnResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['RegionId'] = request.region_id
        query['Token'] = request.token
        query['VbrId'] = request.vbr_id
        query['VpconnId'] = request.vpconn_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='AttachVbrToVpconn',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AttachVbrToVpconnResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_vbr_to_vpconn(
        self,
        request: vpc_20160428_models.AttachVbrToVpconnRequest,
    ) -> vpc_20160428_models.AttachVbrToVpconnResponse:
        runtime = util_models.RuntimeOptions()
        return self.attach_vbr_to_vpconn_with_options(request, runtime)

    async def attach_vbr_to_vpconn_async(
        self,
        request: vpc_20160428_models.AttachVbrToVpconnRequest,
    ) -> vpc_20160428_models.AttachVbrToVpconnResponse:
        runtime = util_models.RuntimeOptions()
        return await self.attach_vbr_to_vpconn_with_options_async(request, runtime)

    def cancel_common_bandwidth_package_ip_bandwidth_with_options(
        self,
        request: vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['EipId'] = request.eip_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CancelCommonBandwidthPackageIpBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_common_bandwidth_package_ip_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['EipId'] = request.eip_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CancelCommonBandwidthPackageIpBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_common_bandwidth_package_ip_bandwidth(
        self,
        request: vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthRequest,
    ) -> vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return self.cancel_common_bandwidth_package_ip_bandwidth_with_options(request, runtime)

    async def cancel_common_bandwidth_package_ip_bandwidth_async(
        self,
        request: vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthRequest,
    ) -> vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return await self.cancel_common_bandwidth_package_ip_bandwidth_with_options_async(request, runtime)

    def cancel_express_cloud_connection_with_options(
        self,
        request: vpc_20160428_models.CancelExpressCloudConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelExpressCloudConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['EccId'] = request.ecc_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CancelExpressCloudConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelExpressCloudConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_express_cloud_connection_with_options_async(
        self,
        request: vpc_20160428_models.CancelExpressCloudConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelExpressCloudConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['EccId'] = request.ecc_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CancelExpressCloudConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelExpressCloudConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_express_cloud_connection(
        self,
        request: vpc_20160428_models.CancelExpressCloudConnectionRequest,
    ) -> vpc_20160428_models.CancelExpressCloudConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.cancel_express_cloud_connection_with_options(request, runtime)

    async def cancel_express_cloud_connection_async(
        self,
        request: vpc_20160428_models.CancelExpressCloudConnectionRequest,
    ) -> vpc_20160428_models.CancelExpressCloudConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.cancel_express_cloud_connection_with_options_async(request, runtime)

    def cancel_physical_connection_with_options(
        self,
        request: vpc_20160428_models.CancelPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CancelPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.CancelPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CancelPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_physical_connection(
        self,
        request: vpc_20160428_models.CancelPhysicalConnectionRequest,
    ) -> vpc_20160428_models.CancelPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.cancel_physical_connection_with_options(request, runtime)

    async def cancel_physical_connection_async(
        self,
        request: vpc_20160428_models.CancelPhysicalConnectionRequest,
    ) -> vpc_20160428_models.CancelPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.cancel_physical_connection_with_options_async(request, runtime)

    def complete_physical_connection_loawith_options(
        self,
        request: vpc_20160428_models.CompletePhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CompletePhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['LineCode'] = request.line_code
        query['LineLabel'] = request.line_label
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CompletePhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CompletePhysicalConnectionLOAResponse(),
            self.call_api(params, req, runtime)
        )

    async def complete_physical_connection_loawith_options_async(
        self,
        request: vpc_20160428_models.CompletePhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CompletePhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['LineCode'] = request.line_code
        query['LineLabel'] = request.line_label
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CompletePhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CompletePhysicalConnectionLOAResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def complete_physical_connection_loa(
        self,
        request: vpc_20160428_models.CompletePhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.CompletePhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return self.complete_physical_connection_loawith_options(request, runtime)

    async def complete_physical_connection_loa_async(
        self,
        request: vpc_20160428_models.CompletePhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.CompletePhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return await self.complete_physical_connection_loawith_options_async(request, runtime)

    def confirm_physical_connection_with_options(
        self,
        request: vpc_20160428_models.ConfirmPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConfirmPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ConfirmPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConfirmPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def confirm_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.ConfirmPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConfirmPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ConfirmPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConfirmPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def confirm_physical_connection(
        self,
        request: vpc_20160428_models.ConfirmPhysicalConnectionRequest,
    ) -> vpc_20160428_models.ConfirmPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.confirm_physical_connection_with_options(request, runtime)

    async def confirm_physical_connection_async(
        self,
        request: vpc_20160428_models.ConfirmPhysicalConnectionRequest,
    ) -> vpc_20160428_models.ConfirmPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.confirm_physical_connection_with_options_async(request, runtime)

    def connect_router_interface_with_options(
        self,
        request: vpc_20160428_models.ConnectRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConnectRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ConnectRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConnectRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def connect_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.ConnectRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConnectRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ConnectRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConnectRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def connect_router_interface(
        self,
        request: vpc_20160428_models.ConnectRouterInterfaceRequest,
    ) -> vpc_20160428_models.ConnectRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return self.connect_router_interface_with_options(request, runtime)

    async def connect_router_interface_async(
        self,
        request: vpc_20160428_models.ConnectRouterInterfaceRequest,
    ) -> vpc_20160428_models.ConnectRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.connect_router_interface_with_options_async(request, runtime)

    def convert_bandwidth_package_with_options(
        self,
        request: vpc_20160428_models.ConvertBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConvertBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['ClientToken'] = request.client_token
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ConvertBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConvertBandwidthPackageResponse(),
            self.call_api(params, req, runtime)
        )

    async def convert_bandwidth_package_with_options_async(
        self,
        request: vpc_20160428_models.ConvertBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConvertBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['ClientToken'] = request.client_token
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ConvertBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConvertBandwidthPackageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def convert_bandwidth_package(
        self,
        request: vpc_20160428_models.ConvertBandwidthPackageRequest,
    ) -> vpc_20160428_models.ConvertBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return self.convert_bandwidth_package_with_options(request, runtime)

    async def convert_bandwidth_package_async(
        self,
        request: vpc_20160428_models.ConvertBandwidthPackageRequest,
    ) -> vpc_20160428_models.ConvertBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.convert_bandwidth_package_with_options_async(request, runtime)

    def copy_network_acl_entries_with_options(
        self,
        request: vpc_20160428_models.CopyNetworkAclEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CopyNetworkAclEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NetworkAclId'] = request.network_acl_id
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SourceNetworkAclId'] = request.source_network_acl_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CopyNetworkAclEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CopyNetworkAclEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def copy_network_acl_entries_with_options_async(
        self,
        request: vpc_20160428_models.CopyNetworkAclEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CopyNetworkAclEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NetworkAclId'] = request.network_acl_id
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SourceNetworkAclId'] = request.source_network_acl_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CopyNetworkAclEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CopyNetworkAclEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def copy_network_acl_entries(
        self,
        request: vpc_20160428_models.CopyNetworkAclEntriesRequest,
    ) -> vpc_20160428_models.CopyNetworkAclEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.copy_network_acl_entries_with_options(request, runtime)

    async def copy_network_acl_entries_async(
        self,
        request: vpc_20160428_models.CopyNetworkAclEntriesRequest,
    ) -> vpc_20160428_models.CopyNetworkAclEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.copy_network_acl_entries_with_options_async(request, runtime)

    def create_bgp_group_with_options(
        self,
        request: vpc_20160428_models.CreateBgpGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateBgpGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AuthKey'] = request.auth_key
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['IpVersion'] = request.ip_version
        query['IsFakeAsn'] = request.is_fake_asn
        query['LocalAsn'] = request.local_asn
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerAsn'] = request.peer_asn
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateBgpGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateBgpGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_bgp_group_with_options_async(
        self,
        request: vpc_20160428_models.CreateBgpGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateBgpGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AuthKey'] = request.auth_key
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['IpVersion'] = request.ip_version
        query['IsFakeAsn'] = request.is_fake_asn
        query['LocalAsn'] = request.local_asn
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerAsn'] = request.peer_asn
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateBgpGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateBgpGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_bgp_group(
        self,
        request: vpc_20160428_models.CreateBgpGroupRequest,
    ) -> vpc_20160428_models.CreateBgpGroupResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_bgp_group_with_options(request, runtime)

    async def create_bgp_group_async(
        self,
        request: vpc_20160428_models.CreateBgpGroupRequest,
    ) -> vpc_20160428_models.CreateBgpGroupResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_bgp_group_with_options_async(request, runtime)

    def create_bgp_peer_with_options(
        self,
        request: vpc_20160428_models.CreateBgpPeerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateBgpPeerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BfdMultiHop'] = request.bfd_multi_hop
        query['BgpGroupId'] = request.bgp_group_id
        query['ClientToken'] = request.client_token
        query['EnableBfd'] = request.enable_bfd
        query['IpVersion'] = request.ip_version
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerIpAddress'] = request.peer_ip_address
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateBgpPeer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateBgpPeerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_bgp_peer_with_options_async(
        self,
        request: vpc_20160428_models.CreateBgpPeerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateBgpPeerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BfdMultiHop'] = request.bfd_multi_hop
        query['BgpGroupId'] = request.bgp_group_id
        query['ClientToken'] = request.client_token
        query['EnableBfd'] = request.enable_bfd
        query['IpVersion'] = request.ip_version
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerIpAddress'] = request.peer_ip_address
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateBgpPeer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateBgpPeerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_bgp_peer(
        self,
        request: vpc_20160428_models.CreateBgpPeerRequest,
    ) -> vpc_20160428_models.CreateBgpPeerResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_bgp_peer_with_options(request, runtime)

    async def create_bgp_peer_async(
        self,
        request: vpc_20160428_models.CreateBgpPeerRequest,
    ) -> vpc_20160428_models.CreateBgpPeerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_bgp_peer_with_options_async(request, runtime)

    def create_common_bandwidth_package_with_options(
        self,
        request: vpc_20160428_models.CreateCommonBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateCommonBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['ISP'] = request.isp
        query['InternetChargeType'] = request.internet_charge_type
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Ratio'] = request.ratio
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecurityProtectionTypes'] = request.security_protection_types
        query['Zone'] = request.zone
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateCommonBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateCommonBandwidthPackageResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_common_bandwidth_package_with_options_async(
        self,
        request: vpc_20160428_models.CreateCommonBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateCommonBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['ISP'] = request.isp
        query['InternetChargeType'] = request.internet_charge_type
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Ratio'] = request.ratio
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecurityProtectionTypes'] = request.security_protection_types
        query['Zone'] = request.zone
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateCommonBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateCommonBandwidthPackageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_common_bandwidth_package(
        self,
        request: vpc_20160428_models.CreateCommonBandwidthPackageRequest,
    ) -> vpc_20160428_models.CreateCommonBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_common_bandwidth_package_with_options(request, runtime)

    async def create_common_bandwidth_package_async(
        self,
        request: vpc_20160428_models.CreateCommonBandwidthPackageRequest,
    ) -> vpc_20160428_models.CreateCommonBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_common_bandwidth_package_with_options_async(request, runtime)

    def create_customer_gateway_with_options(
        self,
        request: vpc_20160428_models.CreateCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Asn'] = request.asn
        query['AuthKey'] = request.auth_key
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['IpAddress'] = request.ip_address
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateCustomerGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_customer_gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Asn'] = request.asn
        query['AuthKey'] = request.auth_key
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['IpAddress'] = request.ip_address
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateCustomerGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_customer_gateway(
        self,
        request: vpc_20160428_models.CreateCustomerGatewayRequest,
    ) -> vpc_20160428_models.CreateCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_customer_gateway_with_options(request, runtime)

    async def create_customer_gateway_async(
        self,
        request: vpc_20160428_models.CreateCustomerGatewayRequest,
    ) -> vpc_20160428_models.CreateCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_customer_gateway_with_options_async(request, runtime)

    def create_dhcp_options_set_with_options(
        self,
        request: vpc_20160428_models.CreateDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BootFileName'] = request.boot_file_name
        query['ClientToken'] = request.client_token
        query['DhcpOptionsSetDescription'] = request.dhcp_options_set_description
        query['DhcpOptionsSetName'] = request.dhcp_options_set_name
        query['DomainName'] = request.domain_name
        query['DomainNameServers'] = request.domain_name_servers
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TFTPServerName'] = request.tftpserver_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateDhcpOptionsSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dhcp_options_set_with_options_async(
        self,
        request: vpc_20160428_models.CreateDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BootFileName'] = request.boot_file_name
        query['ClientToken'] = request.client_token
        query['DhcpOptionsSetDescription'] = request.dhcp_options_set_description
        query['DhcpOptionsSetName'] = request.dhcp_options_set_name
        query['DomainName'] = request.domain_name
        query['DomainNameServers'] = request.domain_name_servers
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TFTPServerName'] = request.tftpserver_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateDhcpOptionsSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dhcp_options_set(
        self,
        request: vpc_20160428_models.CreateDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.CreateDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_dhcp_options_set_with_options(request, runtime)

    async def create_dhcp_options_set_async(
        self,
        request: vpc_20160428_models.CreateDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.CreateDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_dhcp_options_set_with_options_async(request, runtime)

    def create_express_cloud_connection_with_options(
        self,
        request: vpc_20160428_models.CreateExpressCloudConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateExpressCloudConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['ContactMail'] = request.contact_mail
        query['ContactTel'] = request.contact_tel
        query['Description'] = request.description
        query['IDCardNo'] = request.idcard_no
        query['IdcSP'] = request.idc_sp
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerCity'] = request.peer_city
        query['PeerLocation'] = request.peer_location
        query['PortType'] = request.port_type
        query['RedundantEccId'] = request.redundant_ecc_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateExpressCloudConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateExpressCloudConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_express_cloud_connection_with_options_async(
        self,
        request: vpc_20160428_models.CreateExpressCloudConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateExpressCloudConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['ContactMail'] = request.contact_mail
        query['ContactTel'] = request.contact_tel
        query['Description'] = request.description
        query['IDCardNo'] = request.idcard_no
        query['IdcSP'] = request.idc_sp
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerCity'] = request.peer_city
        query['PeerLocation'] = request.peer_location
        query['PortType'] = request.port_type
        query['RedundantEccId'] = request.redundant_ecc_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateExpressCloudConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateExpressCloudConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_express_cloud_connection(
        self,
        request: vpc_20160428_models.CreateExpressCloudConnectionRequest,
    ) -> vpc_20160428_models.CreateExpressCloudConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_express_cloud_connection_with_options(request, runtime)

    async def create_express_cloud_connection_async(
        self,
        request: vpc_20160428_models.CreateExpressCloudConnectionRequest,
    ) -> vpc_20160428_models.CreateExpressCloudConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_express_cloud_connection_with_options_async(request, runtime)

    def create_flow_log_with_options(
        self,
        request: vpc_20160428_models.CreateFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['FlowLogName'] = request.flow_log_name
        query['LogStoreName'] = request.log_store_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['ProjectName'] = request.project_name
        query['RegionId'] = request.region_id
        query['ResourceId'] = request.resource_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ResourceType'] = request.resource_type
        query['TrafficType'] = request.traffic_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateFlowLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_flow_log_with_options_async(
        self,
        request: vpc_20160428_models.CreateFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['FlowLogName'] = request.flow_log_name
        query['LogStoreName'] = request.log_store_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['ProjectName'] = request.project_name
        query['RegionId'] = request.region_id
        query['ResourceId'] = request.resource_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ResourceType'] = request.resource_type
        query['TrafficType'] = request.traffic_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateFlowLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_flow_log(
        self,
        request: vpc_20160428_models.CreateFlowLogRequest,
    ) -> vpc_20160428_models.CreateFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_flow_log_with_options(request, runtime)

    async def create_flow_log_async(
        self,
        request: vpc_20160428_models.CreateFlowLogRequest,
    ) -> vpc_20160428_models.CreateFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_flow_log_with_options_async(request, runtime)

    def create_forward_entry_with_options(
        self,
        request: vpc_20160428_models.CreateForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateForwardEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['ExternalIp'] = request.external_ip
        query['ExternalPort'] = request.external_port
        query['ForwardEntryName'] = request.forward_entry_name
        query['ForwardTableId'] = request.forward_table_id
        query['InternalIp'] = request.internal_ip
        query['InternalPort'] = request.internal_port
        query['IpProtocol'] = request.ip_protocol
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PortBreak'] = request.port_break
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_forward_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateForwardEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['ExternalIp'] = request.external_ip
        query['ExternalPort'] = request.external_port
        query['ForwardEntryName'] = request.forward_entry_name
        query['ForwardTableId'] = request.forward_table_id
        query['InternalIp'] = request.internal_ip
        query['InternalPort'] = request.internal_port
        query['IpProtocol'] = request.ip_protocol
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PortBreak'] = request.port_break
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_forward_entry(
        self,
        request: vpc_20160428_models.CreateForwardEntryRequest,
    ) -> vpc_20160428_models.CreateForwardEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_forward_entry_with_options(request, runtime)

    async def create_forward_entry_async(
        self,
        request: vpc_20160428_models.CreateForwardEntryRequest,
    ) -> vpc_20160428_models.CreateForwardEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_forward_entry_with_options_async(request, runtime)

    def create_full_nat_entry_with_options(
        self,
        request: vpc_20160428_models.CreateFullNatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateFullNatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AccessIp'] = request.access_ip
        query['AccessPort'] = request.access_port
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['FullNatEntryDescription'] = request.full_nat_entry_description
        query['FullNatEntryName'] = request.full_nat_entry_name
        query['FullNatTableId'] = request.full_nat_table_id
        query['IpProtocol'] = request.ip_protocol
        query['NatIp'] = request.nat_ip
        query['NatIpPort'] = request.nat_ip_port
        query['NetworkInterfaceId'] = request.network_interface_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateFullNatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateFullNatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_full_nat_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateFullNatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateFullNatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AccessIp'] = request.access_ip
        query['AccessPort'] = request.access_port
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['FullNatEntryDescription'] = request.full_nat_entry_description
        query['FullNatEntryName'] = request.full_nat_entry_name
        query['FullNatTableId'] = request.full_nat_table_id
        query['IpProtocol'] = request.ip_protocol
        query['NatIp'] = request.nat_ip
        query['NatIpPort'] = request.nat_ip_port
        query['NetworkInterfaceId'] = request.network_interface_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateFullNatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateFullNatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_full_nat_entry(
        self,
        request: vpc_20160428_models.CreateFullNatEntryRequest,
    ) -> vpc_20160428_models.CreateFullNatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_full_nat_entry_with_options(request, runtime)

    async def create_full_nat_entry_async(
        self,
        request: vpc_20160428_models.CreateFullNatEntryRequest,
    ) -> vpc_20160428_models.CreateFullNatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_full_nat_entry_with_options_async(request, runtime)

    def create_global_acceleration_instance_with_options(
        self,
        request: vpc_20160428_models.CreateGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['BandwidthType'] = request.bandwidth_type
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ServiceLocation'] = request.service_location
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateGlobalAccelerationInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_global_acceleration_instance_with_options_async(
        self,
        request: vpc_20160428_models.CreateGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['BandwidthType'] = request.bandwidth_type
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ServiceLocation'] = request.service_location
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateGlobalAccelerationInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_global_acceleration_instance(
        self,
        request: vpc_20160428_models.CreateGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.CreateGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_global_acceleration_instance_with_options(request, runtime)

    async def create_global_acceleration_instance_async(
        self,
        request: vpc_20160428_models.CreateGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.CreateGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_global_acceleration_instance_with_options_async(request, runtime)

    def create_ha_vip_with_options(
        self,
        request: vpc_20160428_models.CreateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateHaVipResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['IpAddress'] = request.ip_address
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ha_vip_with_options_async(
        self,
        request: vpc_20160428_models.CreateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateHaVipResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['IpAddress'] = request.ip_address
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ha_vip(
        self,
        request: vpc_20160428_models.CreateHaVipRequest,
    ) -> vpc_20160428_models.CreateHaVipResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ha_vip_with_options(request, runtime)

    async def create_ha_vip_async(
        self,
        request: vpc_20160428_models.CreateHaVipRequest,
    ) -> vpc_20160428_models.CreateHaVipResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ha_vip_with_options_async(request, runtime)

    def create_ipv_6translator_with_options(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['Duration'] = request.duration
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PayType'] = request.pay_type
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIPv6Translator',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6translator_with_options_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['Duration'] = request.duration
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PayType'] = request.pay_type
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIPv6Translator',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6translator(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6translator_with_options(request, runtime)

    async def create_ipv_6translator_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6translator_with_options_async(request, runtime)

    def create_ipv_6translator_acl_list_with_options(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorAclListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorAclListResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclName'] = request.acl_name
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIPv6TranslatorAclList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorAclListResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6translator_acl_list_with_options_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorAclListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorAclListResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclName'] = request.acl_name
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIPv6TranslatorAclList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorAclListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6translator_acl_list(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorAclListRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorAclListResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6translator_acl_list_with_options(request, runtime)

    async def create_ipv_6translator_acl_list_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorAclListRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorAclListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6translator_acl_list_with_options_async(request, runtime)

    def create_ipv_6translator_entry_with_options(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['AclStatus'] = request.acl_status
        query['AclType'] = request.acl_type
        query['AllocateIpv6Port'] = request.allocate_ipv_6port
        query['BackendIpv4Addr'] = request.backend_ipv_4addr
        query['BackendIpv4Port'] = request.backend_ipv_4port
        query['EntryBandwidth'] = request.entry_bandwidth
        query['EntryDescription'] = request.entry_description
        query['EntryName'] = request.entry_name
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TransProtocol'] = request.trans_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6translator_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['AclStatus'] = request.acl_status
        query['AclType'] = request.acl_type
        query['AllocateIpv6Port'] = request.allocate_ipv_6port
        query['BackendIpv4Addr'] = request.backend_ipv_4addr
        query['BackendIpv4Port'] = request.backend_ipv_4port
        query['EntryBandwidth'] = request.entry_bandwidth
        query['EntryDescription'] = request.entry_description
        query['EntryName'] = request.entry_name
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TransProtocol'] = request.trans_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6translator_entry(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6translator_entry_with_options(request, runtime)

    async def create_ipv_6translator_entry_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6translator_entry_with_options_async(request, runtime)

    def create_ipsec_server_with_options(
        self,
        request: vpc_20160428_models.CreateIpsecServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpsecServerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientIpPool'] = request.client_ip_pool
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EffectImmediately'] = request.effect_immediately
        query['IkeConfig'] = request.ike_config
        query['IpSecServerName'] = request.ip_sec_server_name
        query['IpsecConfig'] = request.ipsec_config
        query['LocalSubnet'] = request.local_subnet
        query['Psk'] = request.psk
        query['PskEnabled'] = request.psk_enabled
        query['RegionId'] = request.region_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIpsecServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpsecServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipsec_server_with_options_async(
        self,
        request: vpc_20160428_models.CreateIpsecServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpsecServerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientIpPool'] = request.client_ip_pool
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EffectImmediately'] = request.effect_immediately
        query['IkeConfig'] = request.ike_config
        query['IpSecServerName'] = request.ip_sec_server_name
        query['IpsecConfig'] = request.ipsec_config
        query['LocalSubnet'] = request.local_subnet
        query['Psk'] = request.psk
        query['PskEnabled'] = request.psk_enabled
        query['RegionId'] = request.region_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIpsecServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpsecServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipsec_server(
        self,
        request: vpc_20160428_models.CreateIpsecServerRequest,
    ) -> vpc_20160428_models.CreateIpsecServerResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipsec_server_with_options(request, runtime)

    async def create_ipsec_server_async(
        self,
        request: vpc_20160428_models.CreateIpsecServerRequest,
    ) -> vpc_20160428_models.CreateIpsecServerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipsec_server_with_options_async(request, runtime)

    def create_ipv_4gateway_with_options(
        self,
        request: vpc_20160428_models.CreateIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv4GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['Ipv4GatewayDescription'] = request.ipv_4gateway_description
        query['Ipv4GatewayName'] = request.ipv_4gateway_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv4GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_4gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv4GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['Ipv4GatewayDescription'] = request.ipv_4gateway_description
        query['Ipv4GatewayName'] = request.ipv_4gateway_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv4GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_4gateway(
        self,
        request: vpc_20160428_models.CreateIpv4GatewayRequest,
    ) -> vpc_20160428_models.CreateIpv4GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_4gateway_with_options(request, runtime)

    async def create_ipv_4gateway_async(
        self,
        request: vpc_20160428_models.CreateIpv4GatewayRequest,
    ) -> vpc_20160428_models.CreateIpv4GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_4gateway_with_options_async(request, runtime)

    def create_ipv_6egress_only_rule_with_options(
        self,
        request: vpc_20160428_models.CreateIpv6EgressOnlyRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIpv6EgressOnlyRule',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6egress_only_rule_with_options_async(
        self,
        request: vpc_20160428_models.CreateIpv6EgressOnlyRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIpv6EgressOnlyRule',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6egress_only_rule(
        self,
        request: vpc_20160428_models.CreateIpv6EgressOnlyRuleRequest,
    ) -> vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6egress_only_rule_with_options(request, runtime)

    async def create_ipv_6egress_only_rule_async(
        self,
        request: vpc_20160428_models.CreateIpv6EgressOnlyRuleRequest,
    ) -> vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6egress_only_rule_with_options_async(request, runtime)

    def create_ipv_6gateway_with_options(
        self,
        request: vpc_20160428_models.CreateIpv6GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv6GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Spec'] = request.spec
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIpv6Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv6GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateIpv6GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv6GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Spec'] = request.spec
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateIpv6Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv6GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6gateway(
        self,
        request: vpc_20160428_models.CreateIpv6GatewayRequest,
    ) -> vpc_20160428_models.CreateIpv6GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6gateway_with_options(request, runtime)

    async def create_ipv_6gateway_async(
        self,
        request: vpc_20160428_models.CreateIpv6GatewayRequest,
    ) -> vpc_20160428_models.CreateIpv6GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6gateway_with_options_async(request, runtime)

    def create_nat_gateway_with_options(
        self,
        request: vpc_20160428_models.CreateNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['Duration'] = request.duration
        query['IcmpReplyEnabled'] = request.icmp_reply_enabled
        query['InstanceChargeType'] = request.instance_charge_type
        query['InternetChargeType'] = request.internet_charge_type
        query['Name'] = request.name
        query['NatType'] = request.nat_type
        query['NetworkType'] = request.network_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecurityProtectionEnabled'] = request.security_protection_enabled
        query['Spec'] = request.spec
        query['VSwitchId'] = request.v_switch_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateNatGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['Duration'] = request.duration
        query['IcmpReplyEnabled'] = request.icmp_reply_enabled
        query['InstanceChargeType'] = request.instance_charge_type
        query['InternetChargeType'] = request.internet_charge_type
        query['Name'] = request.name
        query['NatType'] = request.nat_type
        query['NetworkType'] = request.network_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecurityProtectionEnabled'] = request.security_protection_enabled
        query['Spec'] = request.spec
        query['VSwitchId'] = request.v_switch_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateNatGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_gateway(
        self,
        request: vpc_20160428_models.CreateNatGatewayRequest,
    ) -> vpc_20160428_models.CreateNatGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_nat_gateway_with_options(request, runtime)

    async def create_nat_gateway_async(
        self,
        request: vpc_20160428_models.CreateNatGatewayRequest,
    ) -> vpc_20160428_models.CreateNatGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_gateway_with_options_async(request, runtime)

    def create_nat_ip_with_options(
        self,
        request: vpc_20160428_models.CreateNatIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatIpResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatIp'] = request.nat_ip
        query['NatIpCidr'] = request.nat_ip_cidr
        query['NatIpCidrId'] = request.nat_ip_cidr_id
        query['NatIpDescription'] = request.nat_ip_description
        query['NatIpName'] = request.nat_ip_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateNatIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_ip_with_options_async(
        self,
        request: vpc_20160428_models.CreateNatIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatIpResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatIp'] = request.nat_ip
        query['NatIpCidr'] = request.nat_ip_cidr
        query['NatIpCidrId'] = request.nat_ip_cidr_id
        query['NatIpDescription'] = request.nat_ip_description
        query['NatIpName'] = request.nat_ip_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateNatIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_ip(
        self,
        request: vpc_20160428_models.CreateNatIpRequest,
    ) -> vpc_20160428_models.CreateNatIpResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_nat_ip_with_options(request, runtime)

    async def create_nat_ip_async(
        self,
        request: vpc_20160428_models.CreateNatIpRequest,
    ) -> vpc_20160428_models.CreateNatIpResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_ip_with_options_async(request, runtime)

    def create_nat_ip_cidr_with_options(
        self,
        request: vpc_20160428_models.CreateNatIpCidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatIpCidrResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatIpCidr'] = request.nat_ip_cidr
        query['NatIpCidrDescription'] = request.nat_ip_cidr_description
        query['NatIpCidrName'] = request.nat_ip_cidr_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateNatIpCidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatIpCidrResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_ip_cidr_with_options_async(
        self,
        request: vpc_20160428_models.CreateNatIpCidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatIpCidrResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatIpCidr'] = request.nat_ip_cidr
        query['NatIpCidrDescription'] = request.nat_ip_cidr_description
        query['NatIpCidrName'] = request.nat_ip_cidr_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateNatIpCidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatIpCidrResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_ip_cidr(
        self,
        request: vpc_20160428_models.CreateNatIpCidrRequest,
    ) -> vpc_20160428_models.CreateNatIpCidrResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_nat_ip_cidr_with_options(request, runtime)

    async def create_nat_ip_cidr_async(
        self,
        request: vpc_20160428_models.CreateNatIpCidrRequest,
    ) -> vpc_20160428_models.CreateNatIpCidrResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_ip_cidr_with_options_async(request, runtime)

    def create_network_acl_with_options(
        self,
        request: vpc_20160428_models.CreateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['NetworkAclName'] = request.network_acl_name
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNetworkAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_network_acl_with_options_async(
        self,
        request: vpc_20160428_models.CreateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['NetworkAclName'] = request.network_acl_name
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNetworkAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_network_acl(
        self,
        request: vpc_20160428_models.CreateNetworkAclRequest,
    ) -> vpc_20160428_models.CreateNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_network_acl_with_options(request, runtime)

    async def create_network_acl_async(
        self,
        request: vpc_20160428_models.CreateNetworkAclRequest,
    ) -> vpc_20160428_models.CreateNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_network_acl_with_options_async(request, runtime)

    def create_physical_connection_with_options(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AccessPointId'] = request.access_point_id
        query['CircuitCode'] = request.circuit_code
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['LineOperator'] = request.line_operator
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerLocation'] = request.peer_location
        query['PortType'] = request.port_type
        query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Type'] = request.type
        query['bandwidth'] = request.bandwidth
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AccessPointId'] = request.access_point_id
        query['CircuitCode'] = request.circuit_code
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['LineOperator'] = request.line_operator
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerLocation'] = request.peer_location
        query['PortType'] = request.port_type
        query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Type'] = request.type
        query['bandwidth'] = request.bandwidth
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_physical_connection(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_physical_connection_with_options(request, runtime)

    async def create_physical_connection_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_physical_connection_with_options_async(request, runtime)

    def create_physical_connection_occupancy_order_with_options(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['ClientToken'] = request.client_token
        query['InstanceChargeType'] = request.instance_charge_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnectionOccupancyOrder',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_physical_connection_occupancy_order_with_options_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['ClientToken'] = request.client_token
        query['InstanceChargeType'] = request.instance_charge_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnectionOccupancyOrder',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_physical_connection_occupancy_order(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_physical_connection_occupancy_order_with_options(request, runtime)

    async def create_physical_connection_occupancy_order_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_physical_connection_occupancy_order_with_options_async(request, runtime)

    def create_physical_connection_setup_order_with_options(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionSetupOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AccessPointId'] = request.access_point_id
        query['AutoPay'] = request.auto_pay
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['LineOperator'] = request.line_operator
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PortType'] = request.port_type
        query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnectionSetupOrder',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_physical_connection_setup_order_with_options_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionSetupOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AccessPointId'] = request.access_point_id
        query['AutoPay'] = request.auto_pay
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['LineOperator'] = request.line_operator
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PortType'] = request.port_type
        query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnectionSetupOrder',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_physical_connection_setup_order(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionSetupOrderRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_physical_connection_setup_order_with_options(request, runtime)

    async def create_physical_connection_setup_order_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionSetupOrderRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_physical_connection_setup_order_with_options_async(request, runtime)

    def create_route_entry_with_options(
        self,
        request: vpc_20160428_models.CreateRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['DestinationCidrBlock'] = request.destination_cidr_block
        query['NextHopId'] = request.next_hop_id
        query['NextHopList'] = request.next_hop_list
        query['NextHopType'] = request.next_hop_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteEntryName'] = request.route_entry_name
        query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['DestinationCidrBlock'] = request.destination_cidr_block
        query['NextHopId'] = request.next_hop_id
        query['NextHopList'] = request.next_hop_list
        query['NextHopType'] = request.next_hop_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteEntryName'] = request.route_entry_name
        query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_route_entry(
        self,
        request: vpc_20160428_models.CreateRouteEntryRequest,
    ) -> vpc_20160428_models.CreateRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_route_entry_with_options(request, runtime)

    async def create_route_entry_async(
        self,
        request: vpc_20160428_models.CreateRouteEntryRequest,
    ) -> vpc_20160428_models.CreateRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_route_entry_with_options_async(request, runtime)

    def create_route_table_with_options(
        self,
        request: vpc_20160428_models.CreateRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteTableResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AssociateType'] = request.associate_type
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableName'] = request.route_table_name
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteTableResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_route_table_with_options_async(
        self,
        request: vpc_20160428_models.CreateRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteTableResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AssociateType'] = request.associate_type
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableName'] = request.route_table_name
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteTableResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_route_table(
        self,
        request: vpc_20160428_models.CreateRouteTableRequest,
    ) -> vpc_20160428_models.CreateRouteTableResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_route_table_with_options(request, runtime)

    async def create_route_table_async(
        self,
        request: vpc_20160428_models.CreateRouteTableRequest,
    ) -> vpc_20160428_models.CreateRouteTableResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_route_table_with_options_async(request, runtime)

    def create_router_interface_with_options(
        self,
        request: vpc_20160428_models.CreateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AccessPointId'] = request.access_point_id
        query['AutoPay'] = request.auto_pay
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['HealthCheckSourceIp'] = request.health_check_source_ip
        query['HealthCheckTargetIp'] = request.health_check_target_ip
        query['InstanceChargeType'] = request.instance_charge_type
        query['Name'] = request.name
        query['OppositeAccessPointId'] = request.opposite_access_point_id
        query['OppositeInterfaceId'] = request.opposite_interface_id
        query['OppositeInterfaceOwnerId'] = request.opposite_interface_owner_id
        query['OppositeRegionId'] = request.opposite_region_id
        query['OppositeRouterId'] = request.opposite_router_id
        query['OppositeRouterType'] = request.opposite_router_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Role'] = request.role
        query['RouterId'] = request.router_id
        query['RouterType'] = request.router_type
        query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.CreateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AccessPointId'] = request.access_point_id
        query['AutoPay'] = request.auto_pay
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['HealthCheckSourceIp'] = request.health_check_source_ip
        query['HealthCheckTargetIp'] = request.health_check_target_ip
        query['InstanceChargeType'] = request.instance_charge_type
        query['Name'] = request.name
        query['OppositeAccessPointId'] = request.opposite_access_point_id
        query['OppositeInterfaceId'] = request.opposite_interface_id
        query['OppositeInterfaceOwnerId'] = request.opposite_interface_owner_id
        query['OppositeRegionId'] = request.opposite_region_id
        query['OppositeRouterId'] = request.opposite_router_id
        query['OppositeRouterType'] = request.opposite_router_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Role'] = request.role
        query['RouterId'] = request.router_id
        query['RouterType'] = request.router_type
        query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_router_interface(
        self,
        request: vpc_20160428_models.CreateRouterInterfaceRequest,
    ) -> vpc_20160428_models.CreateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_router_interface_with_options(request, runtime)

    async def create_router_interface_async(
        self,
        request: vpc_20160428_models.CreateRouterInterfaceRequest,
    ) -> vpc_20160428_models.CreateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_router_interface_with_options_async(request, runtime)

    def create_snat_entry_with_options(
        self,
        request: vpc_20160428_models.CreateSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSnatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SnatEntryName'] = request.snat_entry_name
        query['SnatIp'] = request.snat_ip
        query['SnatTableId'] = request.snat_table_id
        query['SourceCIDR'] = request.source_cidr
        query['SourceVSwitchId'] = request.source_vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateSnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSnatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_snat_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSnatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SnatEntryName'] = request.snat_entry_name
        query['SnatIp'] = request.snat_ip
        query['SnatTableId'] = request.snat_table_id
        query['SourceCIDR'] = request.source_cidr
        query['SourceVSwitchId'] = request.source_vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateSnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSnatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_snat_entry(
        self,
        request: vpc_20160428_models.CreateSnatEntryRequest,
    ) -> vpc_20160428_models.CreateSnatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_snat_entry_with_options(request, runtime)

    async def create_snat_entry_async(
        self,
        request: vpc_20160428_models.CreateSnatEntryRequest,
    ) -> vpc_20160428_models.CreateSnatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_snat_entry_with_options_async(request, runtime)

    def create_ssl_vpn_client_cert_with_options(
        self,
        request: vpc_20160428_models.CreateSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSslVpnClientCertResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ssl_vpn_client_cert_with_options_async(
        self,
        request: vpc_20160428_models.CreateSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSslVpnClientCertResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ssl_vpn_client_cert(
        self,
        request: vpc_20160428_models.CreateSslVpnClientCertRequest,
    ) -> vpc_20160428_models.CreateSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ssl_vpn_client_cert_with_options(request, runtime)

    async def create_ssl_vpn_client_cert_async(
        self,
        request: vpc_20160428_models.CreateSslVpnClientCertRequest,
    ) -> vpc_20160428_models.CreateSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ssl_vpn_client_cert_with_options_async(request, runtime)

    def create_ssl_vpn_server_with_options(
        self,
        request: vpc_20160428_models.CreateSslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSslVpnServerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Cipher'] = request.cipher
        query['ClientIpPool'] = request.client_ip_pool
        query['ClientToken'] = request.client_token
        query['Compress'] = request.compress
        query['EnableMultiFactorAuth'] = request.enable_multi_factor_auth
        query['IDaaSInstanceId'] = request.idaa_sinstance_id
        query['IDaaSRegionId'] = request.idaa_sregion_id
        query['LocalSubnet'] = request.local_subnet
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Port'] = request.port
        query['Proto'] = request.proto
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateSslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSslVpnServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ssl_vpn_server_with_options_async(
        self,
        request: vpc_20160428_models.CreateSslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSslVpnServerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Cipher'] = request.cipher
        query['ClientIpPool'] = request.client_ip_pool
        query['ClientToken'] = request.client_token
        query['Compress'] = request.compress
        query['EnableMultiFactorAuth'] = request.enable_multi_factor_auth
        query['IDaaSInstanceId'] = request.idaa_sinstance_id
        query['IDaaSRegionId'] = request.idaa_sregion_id
        query['LocalSubnet'] = request.local_subnet
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Port'] = request.port
        query['Proto'] = request.proto
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateSslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSslVpnServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ssl_vpn_server(
        self,
        request: vpc_20160428_models.CreateSslVpnServerRequest,
    ) -> vpc_20160428_models.CreateSslVpnServerResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ssl_vpn_server_with_options(request, runtime)

    async def create_ssl_vpn_server_async(
        self,
        request: vpc_20160428_models.CreateSslVpnServerRequest,
    ) -> vpc_20160428_models.CreateSslVpnServerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ssl_vpn_server_with_options_async(request, runtime)

    def create_traffic_mirror_filter_with_options(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EgressRules'] = request.egress_rules
        query['IngressRules'] = request.ingress_rules
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterDescription'] = request.traffic_mirror_filter_description
        query['TrafficMirrorFilterName'] = request.traffic_mirror_filter_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorFilter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorFilterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_traffic_mirror_filter_with_options_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EgressRules'] = request.egress_rules
        query['IngressRules'] = request.ingress_rules
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterDescription'] = request.traffic_mirror_filter_description
        query['TrafficMirrorFilterName'] = request.traffic_mirror_filter_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorFilter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorFilterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_traffic_mirror_filter(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_traffic_mirror_filter_with_options(request, runtime)

    async def create_traffic_mirror_filter_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_traffic_mirror_filter_with_options_async(request, runtime)

    def create_traffic_mirror_filter_rules_with_options(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EgressRules'] = request.egress_rules
        query['IngressRules'] = request.ingress_rules
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorFilterRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_traffic_mirror_filter_rules_with_options_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EgressRules'] = request.egress_rules
        query['IngressRules'] = request.ingress_rules
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorFilterRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_traffic_mirror_filter_rules(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRulesRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_traffic_mirror_filter_rules_with_options(request, runtime)

    async def create_traffic_mirror_filter_rules_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRulesRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_traffic_mirror_filter_rules_with_options_async(request, runtime)

    def create_traffic_mirror_session_with_options(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorSessionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['Enabled'] = request.enabled
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PacketLength'] = request.packet_length
        query['Priority'] = request.priority
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        query['TrafficMirrorSessionDescription'] = request.traffic_mirror_session_description
        query['TrafficMirrorSessionName'] = request.traffic_mirror_session_name
        query['TrafficMirrorSourceIds'] = request.traffic_mirror_source_ids
        query['TrafficMirrorTargetId'] = request.traffic_mirror_target_id
        query['TrafficMirrorTargetType'] = request.traffic_mirror_target_type
        query['VirtualNetworkId'] = request.virtual_network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorSessionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_traffic_mirror_session_with_options_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorSessionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['Enabled'] = request.enabled
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PacketLength'] = request.packet_length
        query['Priority'] = request.priority
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        query['TrafficMirrorSessionDescription'] = request.traffic_mirror_session_description
        query['TrafficMirrorSessionName'] = request.traffic_mirror_session_name
        query['TrafficMirrorSourceIds'] = request.traffic_mirror_source_ids
        query['TrafficMirrorTargetId'] = request.traffic_mirror_target_id
        query['TrafficMirrorTargetType'] = request.traffic_mirror_target_type
        query['VirtualNetworkId'] = request.virtual_network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorSessionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_traffic_mirror_session(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorSessionResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_traffic_mirror_session_with_options(request, runtime)

    async def create_traffic_mirror_session_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorSessionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_traffic_mirror_session_with_options_async(request, runtime)

    def create_vswitch_with_options(
        self,
        request: vpc_20160428_models.CreateVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVSwitchResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CidrBlock'] = request.cidr_block
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VSwitchName'] = request.v_switch_name
        query['VpcId'] = request.vpc_id
        query['VpcIpv6CidrBlock'] = request.vpc_ipv_6cidr_block
        query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vswitch_with_options_async(
        self,
        request: vpc_20160428_models.CreateVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVSwitchResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CidrBlock'] = request.cidr_block
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VSwitchName'] = request.v_switch_name
        query['VpcId'] = request.vpc_id
        query['VpcIpv6CidrBlock'] = request.vpc_ipv_6cidr_block
        query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vswitch(
        self,
        request: vpc_20160428_models.CreateVSwitchRequest,
    ) -> vpc_20160428_models.CreateVSwitchResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vswitch_with_options(request, runtime)

    async def create_vswitch_async(
        self,
        request: vpc_20160428_models.CreateVSwitchRequest,
    ) -> vpc_20160428_models.CreateVSwitchResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vswitch_with_options_async(request, runtime)

    def create_vbr_ha_with_options(
        self,
        request: vpc_20160428_models.CreateVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['DryRun'] = request.dry_run
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerVbrId'] = request.peer_vbr_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVbrHaResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vbr_ha_with_options_async(
        self,
        request: vpc_20160428_models.CreateVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['DryRun'] = request.dry_run
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerVbrId'] = request.peer_vbr_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVbrHaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vbr_ha(
        self,
        request: vpc_20160428_models.CreateVbrHaRequest,
    ) -> vpc_20160428_models.CreateVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vbr_ha_with_options(request, runtime)

    async def create_vbr_ha_async(
        self,
        request: vpc_20160428_models.CreateVbrHaRequest,
    ) -> vpc_20160428_models.CreateVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vbr_ha_with_options_async(request, runtime)

    def create_virtual_border_router_with_options(
        self,
        request: vpc_20160428_models.CreateVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['CircuitCode'] = request.circuit_code
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['EnableIpv6'] = request.enable_ipv_6
        query['LocalGatewayIp'] = request.local_gateway_ip
        query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerGatewayIp'] = request.peer_gateway_ip
        query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        query['PeeringSubnetMask'] = request.peering_subnet_mask
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrOwnerId'] = request.vbr_owner_id
        query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_virtual_border_router_with_options_async(
        self,
        request: vpc_20160428_models.CreateVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['CircuitCode'] = request.circuit_code
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['EnableIpv6'] = request.enable_ipv_6
        query['LocalGatewayIp'] = request.local_gateway_ip
        query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerGatewayIp'] = request.peer_gateway_ip
        query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        query['PeeringSubnetMask'] = request.peering_subnet_mask
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrOwnerId'] = request.vbr_owner_id
        query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_virtual_border_router(
        self,
        request: vpc_20160428_models.CreateVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.CreateVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_virtual_border_router_with_options(request, runtime)

    async def create_virtual_border_router_async(
        self,
        request: vpc_20160428_models.CreateVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.CreateVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_virtual_border_router_with_options_async(request, runtime)

    def create_virtual_physical_connection_with_options(
        self,
        request: vpc_20160428_models.CreateVirtualPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVirtualPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['DryRun'] = request.dry_run
        query['Name'] = request.name
        query['OrderMode'] = request.order_mode
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['Spec'] = request.spec
        query['Token'] = request.token
        query['VlanId'] = request.vlan_id
        query['VpconnAliUid'] = request.vpconn_ali_uid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVirtualPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVirtualPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_virtual_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.CreateVirtualPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVirtualPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['DryRun'] = request.dry_run
        query['Name'] = request.name
        query['OrderMode'] = request.order_mode
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['Spec'] = request.spec
        query['Token'] = request.token
        query['VlanId'] = request.vlan_id
        query['VpconnAliUid'] = request.vpconn_ali_uid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVirtualPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVirtualPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_virtual_physical_connection(
        self,
        request: vpc_20160428_models.CreateVirtualPhysicalConnectionRequest,
    ) -> vpc_20160428_models.CreateVirtualPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_virtual_physical_connection_with_options(request, runtime)

    async def create_virtual_physical_connection_async(
        self,
        request: vpc_20160428_models.CreateVirtualPhysicalConnectionRequest,
    ) -> vpc_20160428_models.CreateVirtualPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_virtual_physical_connection_with_options_async(request, runtime)

    def create_vpc_with_options(
        self,
        request: vpc_20160428_models.CreateVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CidrBlock'] = request.cidr_block
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['DryRun'] = request.dry_run
        query['EnableIpv6'] = request.enable_ipv_6
        query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        query['Ipv6Isp'] = request.ipv_6isp
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['UserCidr'] = request.user_cidr
        query['VpcName'] = request.vpc_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CidrBlock'] = request.cidr_block
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['DryRun'] = request.dry_run
        query['EnableIpv6'] = request.enable_ipv_6
        query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        query['Ipv6Isp'] = request.ipv_6isp
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['UserCidr'] = request.user_cidr
        query['VpcName'] = request.vpc_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc(
        self,
        request: vpc_20160428_models.CreateVpcRequest,
    ) -> vpc_20160428_models.CreateVpcResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_with_options(request, runtime)

    async def create_vpc_async(
        self,
        request: vpc_20160428_models.CreateVpcRequest,
    ) -> vpc_20160428_models.CreateVpcResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_with_options_async(request, runtime)

    def create_vpc_gateway_endpoint_with_options(
        self,
        request: vpc_20160428_models.CreateVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EndpointDescription'] = request.endpoint_description
        query['EndpointName'] = request.endpoint_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PolicyDocument'] = request.policy_document
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ServiceName'] = request.service_name
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcGatewayEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_gateway_endpoint_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EndpointDescription'] = request.endpoint_description
        query['EndpointName'] = request.endpoint_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PolicyDocument'] = request.policy_document
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ServiceName'] = request.service_name
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcGatewayEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc_gateway_endpoint(
        self,
        request: vpc_20160428_models.CreateVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.CreateVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_gateway_endpoint_with_options(request, runtime)

    async def create_vpc_gateway_endpoint_async(
        self,
        request: vpc_20160428_models.CreateVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.CreateVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_gateway_endpoint_with_options_async(request, runtime)

    def create_vpconn_from_vbr_with_options(
        self,
        request: vpc_20160428_models.CreateVpconnFromVbrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpconnFromVbrResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['OrderMode'] = request.order_mode
        query['RegionId'] = request.region_id
        query['Token'] = request.token
        query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpconnFromVbr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpconnFromVbrResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpconn_from_vbr_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpconnFromVbrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpconnFromVbrResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['OrderMode'] = request.order_mode
        query['RegionId'] = request.region_id
        query['Token'] = request.token
        query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpconnFromVbr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpconnFromVbrResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpconn_from_vbr(
        self,
        request: vpc_20160428_models.CreateVpconnFromVbrRequest,
    ) -> vpc_20160428_models.CreateVpconnFromVbrResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpconn_from_vbr_with_options(request, runtime)

    async def create_vpconn_from_vbr_async(
        self,
        request: vpc_20160428_models.CreateVpconnFromVbrRequest,
    ) -> vpc_20160428_models.CreateVpconnFromVbrResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpconn_from_vbr_with_options_async(request, runtime)

    def create_vpn_connection_with_options(
        self,
        request: vpc_20160428_models.CreateVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoConfigRoute'] = request.auto_config_route
        query['BgpConfig'] = request.bgp_config
        query['ClientToken'] = request.client_token
        query['CustomerGatewayId'] = request.customer_gateway_id
        query['EffectImmediately'] = request.effect_immediately
        query['EnableDpd'] = request.enable_dpd
        query['EnableNatTraversal'] = request.enable_nat_traversal
        query['HealthCheckConfig'] = request.health_check_config
        query['IkeConfig'] = request.ike_config
        query['IpsecConfig'] = request.ipsec_config
        query['LocalSubnet'] = request.local_subnet
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RemoteCaCertificate'] = request.remote_ca_certificate
        query['RemoteSubnet'] = request.remote_subnet
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_connection_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoConfigRoute'] = request.auto_config_route
        query['BgpConfig'] = request.bgp_config
        query['ClientToken'] = request.client_token
        query['CustomerGatewayId'] = request.customer_gateway_id
        query['EffectImmediately'] = request.effect_immediately
        query['EnableDpd'] = request.enable_dpd
        query['EnableNatTraversal'] = request.enable_nat_traversal
        query['HealthCheckConfig'] = request.health_check_config
        query['IkeConfig'] = request.ike_config
        query['IpsecConfig'] = request.ipsec_config
        query['LocalSubnet'] = request.local_subnet
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RemoteCaCertificate'] = request.remote_ca_certificate
        query['RemoteSubnet'] = request.remote_subnet
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_connection(
        self,
        request: vpc_20160428_models.CreateVpnConnectionRequest,
    ) -> vpc_20160428_models.CreateVpnConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_connection_with_options(request, runtime)

    async def create_vpn_connection_async(
        self,
        request: vpc_20160428_models.CreateVpnConnectionRequest,
    ) -> vpc_20160428_models.CreateVpnConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_connection_with_options_async(request, runtime)

    def create_vpn_gateway_with_options(
        self,
        request: vpc_20160428_models.CreateVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['EnableIpsec'] = request.enable_ipsec
        query['EnableSsl'] = request.enable_ssl
        query['InstanceChargeType'] = request.instance_charge_type
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslConnections'] = request.ssl_connections
        query['VSwitchId'] = request.v_switch_id
        query['VpcId'] = request.vpc_id
        query['VpnType'] = request.vpn_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['EnableIpsec'] = request.enable_ipsec
        query['EnableSsl'] = request.enable_ssl
        query['InstanceChargeType'] = request.instance_charge_type
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslConnections'] = request.ssl_connections
        query['VSwitchId'] = request.v_switch_id
        query['VpcId'] = request.vpc_id
        query['VpnType'] = request.vpn_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_gateway(
        self,
        request: vpc_20160428_models.CreateVpnGatewayRequest,
    ) -> vpc_20160428_models.CreateVpnGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_gateway_with_options(request, runtime)

    async def create_vpn_gateway_async(
        self,
        request: vpc_20160428_models.CreateVpnGatewayRequest,
    ) -> vpc_20160428_models.CreateVpnGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_gateway_with_options_async(request, runtime)

    def create_vpn_pbr_route_entry_with_options(
        self,
        request: vpc_20160428_models.CreateVpnPbrRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnPbrRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['NextHop'] = request.next_hop
        query['OverlayMode'] = request.overlay_mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PublishVpc'] = request.publish_vpc
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['RouteSource'] = request.route_source
        query['VpnGatewayId'] = request.vpn_gateway_id
        query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpnPbrRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnPbrRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_pbr_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnPbrRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnPbrRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['NextHop'] = request.next_hop
        query['OverlayMode'] = request.overlay_mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PublishVpc'] = request.publish_vpc
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['RouteSource'] = request.route_source
        query['VpnGatewayId'] = request.vpn_gateway_id
        query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpnPbrRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnPbrRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_pbr_route_entry(
        self,
        request: vpc_20160428_models.CreateVpnPbrRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVpnPbrRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_pbr_route_entry_with_options(request, runtime)

    async def create_vpn_pbr_route_entry_async(
        self,
        request: vpc_20160428_models.CreateVpnPbrRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVpnPbrRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_pbr_route_entry_with_options_async(request, runtime)

    def create_vpn_route_entry_with_options(
        self,
        request: vpc_20160428_models.CreateVpnRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['NextHop'] = request.next_hop
        query['OverlayMode'] = request.overlay_mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PublishVpc'] = request.publish_vpc
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['VpnGatewayId'] = request.vpn_gateway_id
        query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpnRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['NextHop'] = request.next_hop
        query['OverlayMode'] = request.overlay_mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PublishVpc'] = request.publish_vpc
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['VpnGatewayId'] = request.vpn_gateway_id
        query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='CreateVpnRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_route_entry(
        self,
        request: vpc_20160428_models.CreateVpnRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVpnRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_route_entry_with_options(request, runtime)

    async def create_vpn_route_entry_async(
        self,
        request: vpc_20160428_models.CreateVpnRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVpnRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_route_entry_with_options_async(request, runtime)

    def deactivate_router_interface_with_options(
        self,
        request: vpc_20160428_models.DeactivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeactivateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeactivateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeactivateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def deactivate_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.DeactivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeactivateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeactivateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeactivateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deactivate_router_interface(
        self,
        request: vpc_20160428_models.DeactivateRouterInterfaceRequest,
    ) -> vpc_20160428_models.DeactivateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return self.deactivate_router_interface_with_options(request, runtime)

    async def deactivate_router_interface_async(
        self,
        request: vpc_20160428_models.DeactivateRouterInterfaceRequest,
    ) -> vpc_20160428_models.DeactivateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.deactivate_router_interface_with_options_async(request, runtime)

    def deactive_flow_log_with_options(
        self,
        request: vpc_20160428_models.DeactiveFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeactiveFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        query['FlowLogId'] = request.flow_log_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeactiveFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeactiveFlowLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def deactive_flow_log_with_options_async(
        self,
        request: vpc_20160428_models.DeactiveFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeactiveFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        query['FlowLogId'] = request.flow_log_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeactiveFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeactiveFlowLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deactive_flow_log(
        self,
        request: vpc_20160428_models.DeactiveFlowLogRequest,
    ) -> vpc_20160428_models.DeactiveFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return self.deactive_flow_log_with_options(request, runtime)

    async def deactive_flow_log_async(
        self,
        request: vpc_20160428_models.DeactiveFlowLogRequest,
    ) -> vpc_20160428_models.DeactiveFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return await self.deactive_flow_log_with_options_async(request, runtime)

    def delete_bgp_group_with_options(
        self,
        request: vpc_20160428_models.DeleteBgpGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BgpGroupId'] = request.bgp_group_id
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteBgpGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bgp_group_with_options_async(
        self,
        request: vpc_20160428_models.DeleteBgpGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BgpGroupId'] = request.bgp_group_id
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteBgpGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bgp_group(
        self,
        request: vpc_20160428_models.DeleteBgpGroupRequest,
    ) -> vpc_20160428_models.DeleteBgpGroupResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_bgp_group_with_options(request, runtime)

    async def delete_bgp_group_async(
        self,
        request: vpc_20160428_models.DeleteBgpGroupRequest,
    ) -> vpc_20160428_models.DeleteBgpGroupResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_bgp_group_with_options_async(request, runtime)

    def delete_bgp_network_with_options(
        self,
        request: vpc_20160428_models.DeleteBgpNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DstCidrBlock'] = request.dst_cidr_block
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteBgpNetwork',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bgp_network_with_options_async(
        self,
        request: vpc_20160428_models.DeleteBgpNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DstCidrBlock'] = request.dst_cidr_block
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteBgpNetwork',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bgp_network(
        self,
        request: vpc_20160428_models.DeleteBgpNetworkRequest,
    ) -> vpc_20160428_models.DeleteBgpNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_bgp_network_with_options(request, runtime)

    async def delete_bgp_network_async(
        self,
        request: vpc_20160428_models.DeleteBgpNetworkRequest,
    ) -> vpc_20160428_models.DeleteBgpNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_bgp_network_with_options_async(request, runtime)

    def delete_bgp_peer_with_options(
        self,
        request: vpc_20160428_models.DeleteBgpPeerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpPeerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BgpPeerId'] = request.bgp_peer_id
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteBgpPeer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpPeerResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bgp_peer_with_options_async(
        self,
        request: vpc_20160428_models.DeleteBgpPeerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpPeerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BgpPeerId'] = request.bgp_peer_id
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteBgpPeer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpPeerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bgp_peer(
        self,
        request: vpc_20160428_models.DeleteBgpPeerRequest,
    ) -> vpc_20160428_models.DeleteBgpPeerResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_bgp_peer_with_options(request, runtime)

    async def delete_bgp_peer_async(
        self,
        request: vpc_20160428_models.DeleteBgpPeerRequest,
    ) -> vpc_20160428_models.DeleteBgpPeerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_bgp_peer_with_options_async(request, runtime)

    def delete_common_bandwidth_package_with_options(
        self,
        request: vpc_20160428_models.DeleteCommonBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteCommonBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['Force'] = request.force
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteCommonBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteCommonBandwidthPackageResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_common_bandwidth_package_with_options_async(
        self,
        request: vpc_20160428_models.DeleteCommonBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteCommonBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['Force'] = request.force
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteCommonBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteCommonBandwidthPackageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_common_bandwidth_package(
        self,
        request: vpc_20160428_models.DeleteCommonBandwidthPackageRequest,
    ) -> vpc_20160428_models.DeleteCommonBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_common_bandwidth_package_with_options(request, runtime)

    async def delete_common_bandwidth_package_async(
        self,
        request: vpc_20160428_models.DeleteCommonBandwidthPackageRequest,
    ) -> vpc_20160428_models.DeleteCommonBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_common_bandwidth_package_with_options_async(request, runtime)

    def delete_customer_gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['CustomerGatewayId'] = request.customer_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteCustomerGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_customer_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['CustomerGatewayId'] = request.customer_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteCustomerGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_customer_gateway(
        self,
        request: vpc_20160428_models.DeleteCustomerGatewayRequest,
    ) -> vpc_20160428_models.DeleteCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_customer_gateway_with_options(request, runtime)

    async def delete_customer_gateway_async(
        self,
        request: vpc_20160428_models.DeleteCustomerGatewayRequest,
    ) -> vpc_20160428_models.DeleteCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_customer_gateway_with_options_async(request, runtime)

    def delete_dhcp_options_set_with_options(
        self,
        request: vpc_20160428_models.DeleteDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteDhcpOptionsSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dhcp_options_set_with_options_async(
        self,
        request: vpc_20160428_models.DeleteDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteDhcpOptionsSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dhcp_options_set(
        self,
        request: vpc_20160428_models.DeleteDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.DeleteDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_dhcp_options_set_with_options(request, runtime)

    async def delete_dhcp_options_set_async(
        self,
        request: vpc_20160428_models.DeleteDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.DeleteDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_dhcp_options_set_with_options_async(request, runtime)

    def delete_express_cloud_connection_with_options(
        self,
        request: vpc_20160428_models.DeleteExpressCloudConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteExpressCloudConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['EccId'] = request.ecc_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteExpressCloudConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteExpressCloudConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_express_cloud_connection_with_options_async(
        self,
        request: vpc_20160428_models.DeleteExpressCloudConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteExpressCloudConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['EccId'] = request.ecc_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteExpressCloudConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteExpressCloudConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_express_cloud_connection(
        self,
        request: vpc_20160428_models.DeleteExpressCloudConnectionRequest,
    ) -> vpc_20160428_models.DeleteExpressCloudConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_express_cloud_connection_with_options(request, runtime)

    async def delete_express_cloud_connection_async(
        self,
        request: vpc_20160428_models.DeleteExpressCloudConnectionRequest,
    ) -> vpc_20160428_models.DeleteExpressCloudConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_express_cloud_connection_with_options_async(request, runtime)

    def delete_express_connect_with_options(
        self,
        request: vpc_20160428_models.DeleteExpressConnectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteExpressConnectResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Force'] = request.force
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteExpressConnect',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteExpressConnectResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_express_connect_with_options_async(
        self,
        request: vpc_20160428_models.DeleteExpressConnectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteExpressConnectResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Force'] = request.force
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteExpressConnect',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteExpressConnectResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_express_connect(
        self,
        request: vpc_20160428_models.DeleteExpressConnectRequest,
    ) -> vpc_20160428_models.DeleteExpressConnectResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_express_connect_with_options(request, runtime)

    async def delete_express_connect_async(
        self,
        request: vpc_20160428_models.DeleteExpressConnectRequest,
    ) -> vpc_20160428_models.DeleteExpressConnectResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_express_connect_with_options_async(request, runtime)

    def delete_flow_log_with_options(
        self,
        request: vpc_20160428_models.DeleteFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        query['FlowLogId'] = request.flow_log_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteFlowLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_flow_log_with_options_async(
        self,
        request: vpc_20160428_models.DeleteFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        query['FlowLogId'] = request.flow_log_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteFlowLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_flow_log(
        self,
        request: vpc_20160428_models.DeleteFlowLogRequest,
    ) -> vpc_20160428_models.DeleteFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_flow_log_with_options(request, runtime)

    async def delete_flow_log_async(
        self,
        request: vpc_20160428_models.DeleteFlowLogRequest,
    ) -> vpc_20160428_models.DeleteFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_flow_log_with_options_async(request, runtime)

    def delete_forward_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteForwardEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['ForwardEntryId'] = request.forward_entry_id
        query['ForwardTableId'] = request.forward_table_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_forward_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteForwardEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['ForwardEntryId'] = request.forward_entry_id
        query['ForwardTableId'] = request.forward_table_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_forward_entry(
        self,
        request: vpc_20160428_models.DeleteForwardEntryRequest,
    ) -> vpc_20160428_models.DeleteForwardEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_forward_entry_with_options(request, runtime)

    async def delete_forward_entry_async(
        self,
        request: vpc_20160428_models.DeleteForwardEntryRequest,
    ) -> vpc_20160428_models.DeleteForwardEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_forward_entry_with_options_async(request, runtime)

    def delete_full_nat_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteFullNatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteFullNatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['FullNatEntryId'] = request.full_nat_entry_id
        query['FullNatTableId'] = request.full_nat_table_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteFullNatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteFullNatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_full_nat_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteFullNatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteFullNatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['FullNatEntryId'] = request.full_nat_entry_id
        query['FullNatTableId'] = request.full_nat_table_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteFullNatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteFullNatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_full_nat_entry(
        self,
        request: vpc_20160428_models.DeleteFullNatEntryRequest,
    ) -> vpc_20160428_models.DeleteFullNatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_full_nat_entry_with_options(request, runtime)

    async def delete_full_nat_entry_async(
        self,
        request: vpc_20160428_models.DeleteFullNatEntryRequest,
    ) -> vpc_20160428_models.DeleteFullNatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_full_nat_entry_with_options_async(request, runtime)

    def delete_global_acceleration_instance_with_options(
        self,
        request: vpc_20160428_models.DeleteGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_global_acceleration_instance_with_options_async(
        self,
        request: vpc_20160428_models.DeleteGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_global_acceleration_instance(
        self,
        request: vpc_20160428_models.DeleteGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_global_acceleration_instance_with_options(request, runtime)

    async def delete_global_acceleration_instance_async(
        self,
        request: vpc_20160428_models.DeleteGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_global_acceleration_instance_with_options_async(request, runtime)

    def delete_ha_vip_with_options(
        self,
        request: vpc_20160428_models.DeleteHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteHaVipResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['HaVipId'] = request.ha_vip_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ha_vip_with_options_async(
        self,
        request: vpc_20160428_models.DeleteHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteHaVipResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['HaVipId'] = request.ha_vip_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ha_vip(
        self,
        request: vpc_20160428_models.DeleteHaVipRequest,
    ) -> vpc_20160428_models.DeleteHaVipResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ha_vip_with_options(request, runtime)

    async def delete_ha_vip_async(
        self,
        request: vpc_20160428_models.DeleteHaVipRequest,
    ) -> vpc_20160428_models.DeleteHaVipResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ha_vip_with_options_async(request, runtime)

    def delete_ipv_6translator_with_options(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIPv6Translator',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6translator_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIPv6Translator',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6translator(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6translator_with_options(request, runtime)

    async def delete_ipv_6translator_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6translator_with_options_async(request, runtime)

    def delete_ipv_6translator_acl_list_with_options(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorAclListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorAclListResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIPv6TranslatorAclList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorAclListResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6translator_acl_list_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorAclListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorAclListResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIPv6TranslatorAclList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorAclListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6translator_acl_list(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorAclListRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorAclListResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6translator_acl_list_with_options(request, runtime)

    async def delete_ipv_6translator_acl_list_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorAclListRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorAclListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6translator_acl_list_with_options_async(request, runtime)

    def delete_ipv_6translator_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Ipv6TranslatorEntryId'] = request.ipv_6translator_entry_id
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6translator_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Ipv6TranslatorEntryId'] = request.ipv_6translator_entry_id
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6translator_entry(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6translator_entry_with_options(request, runtime)

    async def delete_ipv_6translator_entry_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6translator_entry_with_options_async(request, runtime)

    def delete_ipsec_server_with_options(
        self,
        request: vpc_20160428_models.DeleteIpsecServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpsecServerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['IpsecServerId'] = request.ipsec_server_id
        query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIpsecServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpsecServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipsec_server_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpsecServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpsecServerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['IpsecServerId'] = request.ipsec_server_id
        query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIpsecServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpsecServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipsec_server(
        self,
        request: vpc_20160428_models.DeleteIpsecServerRequest,
    ) -> vpc_20160428_models.DeleteIpsecServerResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipsec_server_with_options(request, runtime)

    async def delete_ipsec_server_async(
        self,
        request: vpc_20160428_models.DeleteIpsecServerRequest,
    ) -> vpc_20160428_models.DeleteIpsecServerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipsec_server_with_options_async(request, runtime)

    def delete_ipv_4gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv4GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['Ipv4GatewayId'] = request.ipv_4gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv4GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_4gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv4GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['Ipv4GatewayId'] = request.ipv_4gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv4GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_4gateway(
        self,
        request: vpc_20160428_models.DeleteIpv4GatewayRequest,
    ) -> vpc_20160428_models.DeleteIpv4GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_4gateway_with_options(request, runtime)

    async def delete_ipv_4gateway_async(
        self,
        request: vpc_20160428_models.DeleteIpv4GatewayRequest,
    ) -> vpc_20160428_models.DeleteIpv4GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_4gateway_with_options_async(request, runtime)

    def delete_ipv_6egress_only_rule_with_options(
        self,
        request: vpc_20160428_models.DeleteIpv6EgressOnlyRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Ipv6EgressOnlyRuleId'] = request.ipv_6egress_only_rule_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIpv6EgressOnlyRule',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6egress_only_rule_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpv6EgressOnlyRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Ipv6EgressOnlyRuleId'] = request.ipv_6egress_only_rule_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIpv6EgressOnlyRule',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6egress_only_rule(
        self,
        request: vpc_20160428_models.DeleteIpv6EgressOnlyRuleRequest,
    ) -> vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6egress_only_rule_with_options(request, runtime)

    async def delete_ipv_6egress_only_rule_async(
        self,
        request: vpc_20160428_models.DeleteIpv6EgressOnlyRuleRequest,
    ) -> vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6egress_only_rule_with_options_async(request, runtime)

    def delete_ipv_6gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteIpv6GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIpv6Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpv6GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIpv6Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6gateway(
        self,
        request: vpc_20160428_models.DeleteIpv6GatewayRequest,
    ) -> vpc_20160428_models.DeleteIpv6GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6gateway_with_options(request, runtime)

    async def delete_ipv_6gateway_async(
        self,
        request: vpc_20160428_models.DeleteIpv6GatewayRequest,
    ) -> vpc_20160428_models.DeleteIpv6GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6gateway_with_options_async(request, runtime)

    def delete_ipv_6internet_bandwidth_with_options(
        self,
        request: vpc_20160428_models.DeleteIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6InternetBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Ipv6AddressId'] = request.ipv_6address_id
        query['Ipv6InternetBandwidthId'] = request.ipv_6internet_bandwidth_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6InternetBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6internet_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6InternetBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Ipv6AddressId'] = request.ipv_6address_id
        query['Ipv6InternetBandwidthId'] = request.ipv_6internet_bandwidth_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6InternetBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6internet_bandwidth(
        self,
        request: vpc_20160428_models.DeleteIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.DeleteIpv6InternetBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6internet_bandwidth_with_options(request, runtime)

    async def delete_ipv_6internet_bandwidth_async(
        self,
        request: vpc_20160428_models.DeleteIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.DeleteIpv6InternetBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6internet_bandwidth_with_options_async(request, runtime)

    def delete_nat_gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Force'] = request.force
        query['NatGatewayId'] = request.nat_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteNatGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Force'] = request.force
        query['NatGatewayId'] = request.nat_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteNatGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_gateway(
        self,
        request: vpc_20160428_models.DeleteNatGatewayRequest,
    ) -> vpc_20160428_models.DeleteNatGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_gateway_with_options(request, runtime)

    async def delete_nat_gateway_async(
        self,
        request: vpc_20160428_models.DeleteNatGatewayRequest,
    ) -> vpc_20160428_models.DeleteNatGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_gateway_with_options_async(request, runtime)

    def delete_nat_ip_with_options(
        self,
        request: vpc_20160428_models.DeleteNatIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatIpResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['NatIpId'] = request.nat_ip_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteNatIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_ip_with_options_async(
        self,
        request: vpc_20160428_models.DeleteNatIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatIpResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['NatIpId'] = request.nat_ip_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteNatIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_ip(
        self,
        request: vpc_20160428_models.DeleteNatIpRequest,
    ) -> vpc_20160428_models.DeleteNatIpResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_ip_with_options(request, runtime)

    async def delete_nat_ip_async(
        self,
        request: vpc_20160428_models.DeleteNatIpRequest,
    ) -> vpc_20160428_models.DeleteNatIpResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_ip_with_options_async(request, runtime)

    def delete_nat_ip_cidr_with_options(
        self,
        request: vpc_20160428_models.DeleteNatIpCidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatIpCidrResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatIpCidr'] = request.nat_ip_cidr
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteNatIpCidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatIpCidrResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_ip_cidr_with_options_async(
        self,
        request: vpc_20160428_models.DeleteNatIpCidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatIpCidrResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatIpCidr'] = request.nat_ip_cidr
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteNatIpCidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatIpCidrResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_ip_cidr(
        self,
        request: vpc_20160428_models.DeleteNatIpCidrRequest,
    ) -> vpc_20160428_models.DeleteNatIpCidrResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_ip_cidr_with_options(request, runtime)

    async def delete_nat_ip_cidr_async(
        self,
        request: vpc_20160428_models.DeleteNatIpCidrRequest,
    ) -> vpc_20160428_models.DeleteNatIpCidrResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_ip_cidr_with_options_async(request, runtime)

    def delete_network_acl_with_options(
        self,
        request: vpc_20160428_models.DeleteNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NetworkAclId'] = request.network_acl_id
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNetworkAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_network_acl_with_options_async(
        self,
        request: vpc_20160428_models.DeleteNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NetworkAclId'] = request.network_acl_id
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNetworkAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_network_acl(
        self,
        request: vpc_20160428_models.DeleteNetworkAclRequest,
    ) -> vpc_20160428_models.DeleteNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_network_acl_with_options(request, runtime)

    async def delete_network_acl_async(
        self,
        request: vpc_20160428_models.DeleteNetworkAclRequest,
    ) -> vpc_20160428_models.DeleteNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_acl_with_options_async(request, runtime)

    def delete_physical_connection_with_options(
        self,
        request: vpc_20160428_models.DeletePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeletePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.DeletePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeletePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_physical_connection(
        self,
        request: vpc_20160428_models.DeletePhysicalConnectionRequest,
    ) -> vpc_20160428_models.DeletePhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_physical_connection_with_options(request, runtime)

    async def delete_physical_connection_async(
        self,
        request: vpc_20160428_models.DeletePhysicalConnectionRequest,
    ) -> vpc_20160428_models.DeletePhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_physical_connection_with_options_async(request, runtime)

    def delete_route_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DestinationCidrBlock'] = request.destination_cidr_block
        query['NextHopId'] = request.next_hop_id
        query['NextHopList'] = request.next_hop_list
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteEntryId'] = request.route_entry_id
        query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DestinationCidrBlock'] = request.destination_cidr_block
        query['NextHopId'] = request.next_hop_id
        query['NextHopList'] = request.next_hop_list
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteEntryId'] = request.route_entry_id
        query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_route_entry(
        self,
        request: vpc_20160428_models.DeleteRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_route_entry_with_options(request, runtime)

    async def delete_route_entry_async(
        self,
        request: vpc_20160428_models.DeleteRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_route_entry_with_options_async(request, runtime)

    def delete_route_table_with_options(
        self,
        request: vpc_20160428_models.DeleteRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteTableResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteTableResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_route_table_with_options_async(
        self,
        request: vpc_20160428_models.DeleteRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteTableResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteTableResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_route_table(
        self,
        request: vpc_20160428_models.DeleteRouteTableRequest,
    ) -> vpc_20160428_models.DeleteRouteTableResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_route_table_with_options(request, runtime)

    async def delete_route_table_async(
        self,
        request: vpc_20160428_models.DeleteRouteTableRequest,
    ) -> vpc_20160428_models.DeleteRouteTableResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_route_table_with_options_async(request, runtime)

    def delete_router_interface_with_options(
        self,
        request: vpc_20160428_models.DeleteRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.DeleteRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_router_interface(
        self,
        request: vpc_20160428_models.DeleteRouterInterfaceRequest,
    ) -> vpc_20160428_models.DeleteRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_router_interface_with_options(request, runtime)

    async def delete_router_interface_async(
        self,
        request: vpc_20160428_models.DeleteRouterInterfaceRequest,
    ) -> vpc_20160428_models.DeleteRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_router_interface_with_options_async(request, runtime)

    def delete_snat_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSnatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SnatEntryId'] = request.snat_entry_id
        query['SnatTableId'] = request.snat_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteSnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSnatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_snat_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSnatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SnatEntryId'] = request.snat_entry_id
        query['SnatTableId'] = request.snat_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteSnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSnatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_snat_entry(
        self,
        request: vpc_20160428_models.DeleteSnatEntryRequest,
    ) -> vpc_20160428_models.DeleteSnatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_snat_entry_with_options(request, runtime)

    async def delete_snat_entry_async(
        self,
        request: vpc_20160428_models.DeleteSnatEntryRequest,
    ) -> vpc_20160428_models.DeleteSnatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_snat_entry_with_options_async(request, runtime)

    def delete_ssl_vpn_client_cert_with_options(
        self,
        request: vpc_20160428_models.DeleteSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSslVpnClientCertResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ssl_vpn_client_cert_with_options_async(
        self,
        request: vpc_20160428_models.DeleteSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSslVpnClientCertResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ssl_vpn_client_cert(
        self,
        request: vpc_20160428_models.DeleteSslVpnClientCertRequest,
    ) -> vpc_20160428_models.DeleteSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ssl_vpn_client_cert_with_options(request, runtime)

    async def delete_ssl_vpn_client_cert_async(
        self,
        request: vpc_20160428_models.DeleteSslVpnClientCertRequest,
    ) -> vpc_20160428_models.DeleteSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ssl_vpn_client_cert_with_options_async(request, runtime)

    def delete_ssl_vpn_server_with_options(
        self,
        request: vpc_20160428_models.DeleteSslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSslVpnServerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteSslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSslVpnServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ssl_vpn_server_with_options_async(
        self,
        request: vpc_20160428_models.DeleteSslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSslVpnServerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteSslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSslVpnServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ssl_vpn_server(
        self,
        request: vpc_20160428_models.DeleteSslVpnServerRequest,
    ) -> vpc_20160428_models.DeleteSslVpnServerResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ssl_vpn_server_with_options(request, runtime)

    async def delete_ssl_vpn_server_async(
        self,
        request: vpc_20160428_models.DeleteSslVpnServerRequest,
    ) -> vpc_20160428_models.DeleteSslVpnServerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ssl_vpn_server_with_options_async(request, runtime)

    def delete_traffic_mirror_filter_with_options(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorFilter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorFilterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_traffic_mirror_filter_with_options_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorFilter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorFilterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_traffic_mirror_filter(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_traffic_mirror_filter_with_options(request, runtime)

    async def delete_traffic_mirror_filter_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_traffic_mirror_filter_with_options_async(request, runtime)

    def delete_traffic_mirror_filter_rules_with_options(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        query['TrafficMirrorFilterRuleIds'] = request.traffic_mirror_filter_rule_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorFilterRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_traffic_mirror_filter_rules_with_options_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        query['TrafficMirrorFilterRuleIds'] = request.traffic_mirror_filter_rule_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorFilterRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_traffic_mirror_filter_rules(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRulesRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_traffic_mirror_filter_rules_with_options(request, runtime)

    async def delete_traffic_mirror_filter_rules_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRulesRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_traffic_mirror_filter_rules_with_options_async(request, runtime)

    def delete_traffic_mirror_session_with_options(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorSessionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorSessionId'] = request.traffic_mirror_session_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorSessionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_traffic_mirror_session_with_options_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorSessionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorSessionId'] = request.traffic_mirror_session_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorSessionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_traffic_mirror_session(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorSessionResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_traffic_mirror_session_with_options(request, runtime)

    async def delete_traffic_mirror_session_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorSessionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_traffic_mirror_session_with_options_async(request, runtime)

    def delete_vswitch_with_options(
        self,
        request: vpc_20160428_models.DeleteVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVSwitchResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vswitch_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVSwitchResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vswitch(
        self,
        request: vpc_20160428_models.DeleteVSwitchRequest,
    ) -> vpc_20160428_models.DeleteVSwitchResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vswitch_with_options(request, runtime)

    async def delete_vswitch_async(
        self,
        request: vpc_20160428_models.DeleteVSwitchRequest,
    ) -> vpc_20160428_models.DeleteVSwitchResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vswitch_with_options_async(request, runtime)

    def delete_vbr_ha_with_options(
        self,
        request: vpc_20160428_models.DeleteVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVbrHaResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vbr_ha_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVbrHaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vbr_ha(
        self,
        request: vpc_20160428_models.DeleteVbrHaRequest,
    ) -> vpc_20160428_models.DeleteVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vbr_ha_with_options(request, runtime)

    async def delete_vbr_ha_async(
        self,
        request: vpc_20160428_models.DeleteVbrHaRequest,
    ) -> vpc_20160428_models.DeleteVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vbr_ha_with_options_async(request, runtime)

    def delete_virtual_border_router_with_options(
        self,
        request: vpc_20160428_models.DeleteVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_virtual_border_router_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_virtual_border_router(
        self,
        request: vpc_20160428_models.DeleteVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.DeleteVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_virtual_border_router_with_options(request, runtime)

    async def delete_virtual_border_router_async(
        self,
        request: vpc_20160428_models.DeleteVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.DeleteVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_virtual_border_router_with_options_async(request, runtime)

    def delete_vpc_with_options(
        self,
        request: vpc_20160428_models.DeleteVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc(
        self,
        request: vpc_20160428_models.DeleteVpcRequest,
    ) -> vpc_20160428_models.DeleteVpcResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_with_options(request, runtime)

    async def delete_vpc_async(
        self,
        request: vpc_20160428_models.DeleteVpcRequest,
    ) -> vpc_20160428_models.DeleteVpcResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_with_options_async(request, runtime)

    def delete_vpc_gateway_endpoint_with_options(
        self,
        request: vpc_20160428_models.DeleteVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EndpointId'] = request.endpoint_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcGatewayEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_gateway_endpoint_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EndpointId'] = request.endpoint_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcGatewayEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc_gateway_endpoint(
        self,
        request: vpc_20160428_models.DeleteVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.DeleteVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_gateway_endpoint_with_options(request, runtime)

    async def delete_vpc_gateway_endpoint_async(
        self,
        request: vpc_20160428_models.DeleteVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.DeleteVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_gateway_endpoint_with_options_async(request, runtime)

    def delete_vpn_connection_with_options(
        self,
        request: vpc_20160428_models.DeleteVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpn_connection_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpn_connection(
        self,
        request: vpc_20160428_models.DeleteVpnConnectionRequest,
    ) -> vpc_20160428_models.DeleteVpnConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpn_connection_with_options(request, runtime)

    async def delete_vpn_connection_async(
        self,
        request: vpc_20160428_models.DeleteVpnConnectionRequest,
    ) -> vpc_20160428_models.DeleteVpnConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpn_connection_with_options_async(request, runtime)

    def delete_vpn_gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpn_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpn_gateway(
        self,
        request: vpc_20160428_models.DeleteVpnGatewayRequest,
    ) -> vpc_20160428_models.DeleteVpnGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpn_gateway_with_options(request, runtime)

    async def delete_vpn_gateway_async(
        self,
        request: vpc_20160428_models.DeleteVpnGatewayRequest,
    ) -> vpc_20160428_models.DeleteVpnGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpn_gateway_with_options_async(request, runtime)

    def delete_vpn_pbr_route_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteVpnPbrRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnPbrRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NextHop'] = request.next_hop
        query['OverlayMode'] = request.overlay_mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['RouteSource'] = request.route_source
        query['VpnGatewayId'] = request.vpn_gateway_id
        query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVpnPbrRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnPbrRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpn_pbr_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpnPbrRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnPbrRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NextHop'] = request.next_hop
        query['OverlayMode'] = request.overlay_mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['RouteSource'] = request.route_source
        query['VpnGatewayId'] = request.vpn_gateway_id
        query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVpnPbrRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnPbrRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpn_pbr_route_entry(
        self,
        request: vpc_20160428_models.DeleteVpnPbrRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteVpnPbrRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpn_pbr_route_entry_with_options(request, runtime)

    async def delete_vpn_pbr_route_entry_async(
        self,
        request: vpc_20160428_models.DeleteVpnPbrRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteVpnPbrRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpn_pbr_route_entry_with_options_async(request, runtime)

    def delete_vpn_route_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteVpnRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NextHop'] = request.next_hop
        query['OverlayMode'] = request.overlay_mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['VpnGatewayId'] = request.vpn_gateway_id
        query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVpnRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpn_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpnRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NextHop'] = request.next_hop
        query['OverlayMode'] = request.overlay_mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['VpnGatewayId'] = request.vpn_gateway_id
        query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeleteVpnRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpn_route_entry(
        self,
        request: vpc_20160428_models.DeleteVpnRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteVpnRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpn_route_entry_with_options(request, runtime)

    async def delete_vpn_route_entry_async(
        self,
        request: vpc_20160428_models.DeleteVpnRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteVpnRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpn_route_entry_with_options_async(request, runtime)

    def deletion_protection_with_options(
        self,
        request: vpc_20160428_models.DeletionProtectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletionProtectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['OwnerId'] = request.owner_id
        query['ProtectionEnable'] = request.protection_enable
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeletionProtection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletionProtectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def deletion_protection_with_options_async(
        self,
        request: vpc_20160428_models.DeletionProtectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletionProtectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['OwnerId'] = request.owner_id
        query['ProtectionEnable'] = request.protection_enable
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DeletionProtection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletionProtectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deletion_protection(
        self,
        request: vpc_20160428_models.DeletionProtectionRequest,
    ) -> vpc_20160428_models.DeletionProtectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.deletion_protection_with_options(request, runtime)

    async def deletion_protection_async(
        self,
        request: vpc_20160428_models.DeletionProtectionRequest,
    ) -> vpc_20160428_models.DeletionProtectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.deletion_protection_with_options_async(request, runtime)

    def describe_access_points_with_options(
        self,
        request: vpc_20160428_models.DescribeAccessPointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeAccessPointsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeAccessPoints',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeAccessPointsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_access_points_with_options_async(
        self,
        request: vpc_20160428_models.DescribeAccessPointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeAccessPointsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeAccessPoints',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeAccessPointsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_access_points(
        self,
        request: vpc_20160428_models.DescribeAccessPointsRequest,
    ) -> vpc_20160428_models.DescribeAccessPointsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_access_points_with_options(request, runtime)

    async def describe_access_points_async(
        self,
        request: vpc_20160428_models.DescribeAccessPointsRequest,
    ) -> vpc_20160428_models.DescribeAccessPointsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_access_points_with_options_async(request, runtime)

    def describe_bgp_groups_with_options(
        self,
        request: vpc_20160428_models.DescribeBgpGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeBgpGroupsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BgpGroupId'] = request.bgp_group_id
        query['IsDefault'] = request.is_default
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeBgpGroups',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeBgpGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_bgp_groups_with_options_async(
        self,
        request: vpc_20160428_models.DescribeBgpGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeBgpGroupsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BgpGroupId'] = request.bgp_group_id
        query['IsDefault'] = request.is_default
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeBgpGroups',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeBgpGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_bgp_groups(
        self,
        request: vpc_20160428_models.DescribeBgpGroupsRequest,
    ) -> vpc_20160428_models.DescribeBgpGroupsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_bgp_groups_with_options(request, runtime)

    async def describe_bgp_groups_async(
        self,
        request: vpc_20160428_models.DescribeBgpGroupsRequest,
    ) -> vpc_20160428_models.DescribeBgpGroupsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_bgp_groups_with_options_async(request, runtime)

    def describe_bgp_networks_with_options(
        self,
        request: vpc_20160428_models.DescribeBgpNetworksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeBgpNetworksResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeBgpNetworks',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeBgpNetworksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_bgp_networks_with_options_async(
        self,
        request: vpc_20160428_models.DescribeBgpNetworksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeBgpNetworksResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeBgpNetworks',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeBgpNetworksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_bgp_networks(
        self,
        request: vpc_20160428_models.DescribeBgpNetworksRequest,
    ) -> vpc_20160428_models.DescribeBgpNetworksResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_bgp_networks_with_options(request, runtime)

    async def describe_bgp_networks_async(
        self,
        request: vpc_20160428_models.DescribeBgpNetworksRequest,
    ) -> vpc_20160428_models.DescribeBgpNetworksResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_bgp_networks_with_options_async(request, runtime)

    def describe_bgp_peers_with_options(
        self,
        request: vpc_20160428_models.DescribeBgpPeersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeBgpPeersResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BgpGroupId'] = request.bgp_group_id
        query['BgpPeerId'] = request.bgp_peer_id
        query['IsDefault'] = request.is_default
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeBgpPeers',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeBgpPeersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_bgp_peers_with_options_async(
        self,
        request: vpc_20160428_models.DescribeBgpPeersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeBgpPeersResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BgpGroupId'] = request.bgp_group_id
        query['BgpPeerId'] = request.bgp_peer_id
        query['IsDefault'] = request.is_default
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeBgpPeers',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeBgpPeersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_bgp_peers(
        self,
        request: vpc_20160428_models.DescribeBgpPeersRequest,
    ) -> vpc_20160428_models.DescribeBgpPeersResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_bgp_peers_with_options(request, runtime)

    async def describe_bgp_peers_async(
        self,
        request: vpc_20160428_models.DescribeBgpPeersRequest,
    ) -> vpc_20160428_models.DescribeBgpPeersResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_bgp_peers_with_options_async(request, runtime)

    def describe_common_bandwidth_packages_with_options(
        self,
        request: vpc_20160428_models.DescribeCommonBandwidthPackagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeCommonBandwidthPackagesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['DryRun'] = request.dry_run
        query['IncludeReservationData'] = request.include_reservation_data
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecurityProtectionEnabled'] = request.security_protection_enabled
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeCommonBandwidthPackages',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeCommonBandwidthPackagesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_common_bandwidth_packages_with_options_async(
        self,
        request: vpc_20160428_models.DescribeCommonBandwidthPackagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeCommonBandwidthPackagesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['DryRun'] = request.dry_run
        query['IncludeReservationData'] = request.include_reservation_data
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecurityProtectionEnabled'] = request.security_protection_enabled
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeCommonBandwidthPackages',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeCommonBandwidthPackagesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_common_bandwidth_packages(
        self,
        request: vpc_20160428_models.DescribeCommonBandwidthPackagesRequest,
    ) -> vpc_20160428_models.DescribeCommonBandwidthPackagesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_common_bandwidth_packages_with_options(request, runtime)

    async def describe_common_bandwidth_packages_async(
        self,
        request: vpc_20160428_models.DescribeCommonBandwidthPackagesRequest,
    ) -> vpc_20160428_models.DescribeCommonBandwidthPackagesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_common_bandwidth_packages_with_options_async(request, runtime)

    def describe_customer_gateway_with_options(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CustomerGatewayId'] = request.customer_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeCustomerGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_customer_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CustomerGatewayId'] = request.customer_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeCustomerGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_customer_gateway(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewayRequest,
    ) -> vpc_20160428_models.DescribeCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_customer_gateway_with_options(request, runtime)

    async def describe_customer_gateway_async(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewayRequest,
    ) -> vpc_20160428_models.DescribeCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_customer_gateway_with_options_async(request, runtime)

    def describe_customer_gateways_with_options(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeCustomerGatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CustomerGatewayId'] = request.customer_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeCustomerGateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeCustomerGatewaysResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_customer_gateways_with_options_async(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeCustomerGatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CustomerGatewayId'] = request.customer_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeCustomerGateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeCustomerGatewaysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_customer_gateways(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewaysRequest,
    ) -> vpc_20160428_models.DescribeCustomerGatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_customer_gateways_with_options(request, runtime)

    async def describe_customer_gateways_async(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewaysRequest,
    ) -> vpc_20160428_models.DescribeCustomerGatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_customer_gateways_with_options_async(request, runtime)

    def describe_eip_addresses_with_options(
        self,
        request: vpc_20160428_models.DescribeEipAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipAddressesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AllocationId'] = request.allocation_id
        query['AssociatedInstanceId'] = request.associated_instance_id
        query['AssociatedInstanceType'] = request.associated_instance_type
        query['ChargeType'] = request.charge_type
        query['DryRun'] = request.dry_run
        query['EipAddress'] = request.eip_address
        query['EipName'] = request.eip_name
        query['ISP'] = request.isp
        query['IncludeReservationData'] = request.include_reservation_data
        query['LockReason'] = request.lock_reason
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecurityProtectionEnabled'] = request.security_protection_enabled
        query['SegmentInstanceId'] = request.segment_instance_id
        query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeEipAddresses',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipAddressesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_eip_addresses_with_options_async(
        self,
        request: vpc_20160428_models.DescribeEipAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipAddressesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AllocationId'] = request.allocation_id
        query['AssociatedInstanceId'] = request.associated_instance_id
        query['AssociatedInstanceType'] = request.associated_instance_type
        query['ChargeType'] = request.charge_type
        query['DryRun'] = request.dry_run
        query['EipAddress'] = request.eip_address
        query['EipName'] = request.eip_name
        query['ISP'] = request.isp
        query['IncludeReservationData'] = request.include_reservation_data
        query['LockReason'] = request.lock_reason
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SecurityProtectionEnabled'] = request.security_protection_enabled
        query['SegmentInstanceId'] = request.segment_instance_id
        query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeEipAddresses',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipAddressesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_eip_addresses(
        self,
        request: vpc_20160428_models.DescribeEipAddressesRequest,
    ) -> vpc_20160428_models.DescribeEipAddressesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_eip_addresses_with_options(request, runtime)

    async def describe_eip_addresses_async(
        self,
        request: vpc_20160428_models.DescribeEipAddressesRequest,
    ) -> vpc_20160428_models.DescribeEipAddressesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_eip_addresses_with_options_async(request, runtime)

    def describe_eip_gateway_info_with_options(
        self,
        request: vpc_20160428_models.DescribeEipGatewayInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipGatewayInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        query['InstanceId'] = request.instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeEipGatewayInfo',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipGatewayInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_eip_gateway_info_with_options_async(
        self,
        request: vpc_20160428_models.DescribeEipGatewayInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipGatewayInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        query['InstanceId'] = request.instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeEipGatewayInfo',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipGatewayInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_eip_gateway_info(
        self,
        request: vpc_20160428_models.DescribeEipGatewayInfoRequest,
    ) -> vpc_20160428_models.DescribeEipGatewayInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_eip_gateway_info_with_options(request, runtime)

    async def describe_eip_gateway_info_async(
        self,
        request: vpc_20160428_models.DescribeEipGatewayInfoRequest,
    ) -> vpc_20160428_models.DescribeEipGatewayInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_eip_gateway_info_with_options_async(request, runtime)

    def describe_eip_monitor_data_with_options(
        self,
        request: vpc_20160428_models.DescribeEipMonitorDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipMonitorDataResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AllocationId'] = request.allocation_id
        query['EndTime'] = request.end_time
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeEipMonitorData',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipMonitorDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_eip_monitor_data_with_options_async(
        self,
        request: vpc_20160428_models.DescribeEipMonitorDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipMonitorDataResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AllocationId'] = request.allocation_id
        query['EndTime'] = request.end_time
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeEipMonitorData',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipMonitorDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_eip_monitor_data(
        self,
        request: vpc_20160428_models.DescribeEipMonitorDataRequest,
    ) -> vpc_20160428_models.DescribeEipMonitorDataResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_eip_monitor_data_with_options(request, runtime)

    async def describe_eip_monitor_data_async(
        self,
        request: vpc_20160428_models.DescribeEipMonitorDataRequest,
    ) -> vpc_20160428_models.DescribeEipMonitorDataResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_eip_monitor_data_with_options_async(request, runtime)

    def describe_eip_segment_with_options(
        self,
        request: vpc_20160428_models.DescribeEipSegmentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipSegmentResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SegmentInstanceId'] = request.segment_instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeEipSegment',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipSegmentResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_eip_segment_with_options_async(
        self,
        request: vpc_20160428_models.DescribeEipSegmentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipSegmentResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SegmentInstanceId'] = request.segment_instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeEipSegment',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipSegmentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_eip_segment(
        self,
        request: vpc_20160428_models.DescribeEipSegmentRequest,
    ) -> vpc_20160428_models.DescribeEipSegmentResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_eip_segment_with_options(request, runtime)

    async def describe_eip_segment_async(
        self,
        request: vpc_20160428_models.DescribeEipSegmentRequest,
    ) -> vpc_20160428_models.DescribeEipSegmentResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_eip_segment_with_options_async(request, runtime)

    def describe_express_cloud_connections_with_options(
        self,
        request: vpc_20160428_models.DescribeExpressCloudConnectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeExpressCloudConnectionsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Filter'] = request.filter
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeExpressCloudConnections',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeExpressCloudConnectionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_express_cloud_connections_with_options_async(
        self,
        request: vpc_20160428_models.DescribeExpressCloudConnectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeExpressCloudConnectionsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Filter'] = request.filter
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeExpressCloudConnections',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeExpressCloudConnectionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_express_cloud_connections(
        self,
        request: vpc_20160428_models.DescribeExpressCloudConnectionsRequest,
    ) -> vpc_20160428_models.DescribeExpressCloudConnectionsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_express_cloud_connections_with_options(request, runtime)

    async def describe_express_cloud_connections_async(
        self,
        request: vpc_20160428_models.DescribeExpressCloudConnectionsRequest,
    ) -> vpc_20160428_models.DescribeExpressCloudConnectionsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_express_cloud_connections_with_options_async(request, runtime)

    def describe_flow_logs_with_options(
        self,
        request: vpc_20160428_models.DescribeFlowLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeFlowLogsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['FlowLogId'] = request.flow_log_id
        query['FlowLogName'] = request.flow_log_name
        query['LogStoreName'] = request.log_store_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['ProjectName'] = request.project_name
        query['RegionId'] = request.region_id
        query['ResourceId'] = request.resource_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ResourceType'] = request.resource_type
        query['Status'] = request.status
        query['TrafficType'] = request.traffic_type
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeFlowLogs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeFlowLogsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_flow_logs_with_options_async(
        self,
        request: vpc_20160428_models.DescribeFlowLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeFlowLogsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['FlowLogId'] = request.flow_log_id
        query['FlowLogName'] = request.flow_log_name
        query['LogStoreName'] = request.log_store_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['ProjectName'] = request.project_name
        query['RegionId'] = request.region_id
        query['ResourceId'] = request.resource_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ResourceType'] = request.resource_type
        query['Status'] = request.status
        query['TrafficType'] = request.traffic_type
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeFlowLogs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeFlowLogsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_flow_logs(
        self,
        request: vpc_20160428_models.DescribeFlowLogsRequest,
    ) -> vpc_20160428_models.DescribeFlowLogsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_flow_logs_with_options(request, runtime)

    async def describe_flow_logs_async(
        self,
        request: vpc_20160428_models.DescribeFlowLogsRequest,
    ) -> vpc_20160428_models.DescribeFlowLogsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_flow_logs_with_options_async(request, runtime)

    def describe_forward_table_entries_with_options(
        self,
        request: vpc_20160428_models.DescribeForwardTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeForwardTableEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ExternalIp'] = request.external_ip
        query['ExternalPort'] = request.external_port
        query['ForwardEntryId'] = request.forward_entry_id
        query['ForwardEntryName'] = request.forward_entry_name
        query['ForwardTableId'] = request.forward_table_id
        query['InternalIp'] = request.internal_ip
        query['InternalPort'] = request.internal_port
        query['IpProtocol'] = request.ip_protocol
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeForwardTableEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeForwardTableEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_forward_table_entries_with_options_async(
        self,
        request: vpc_20160428_models.DescribeForwardTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeForwardTableEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ExternalIp'] = request.external_ip
        query['ExternalPort'] = request.external_port
        query['ForwardEntryId'] = request.forward_entry_id
        query['ForwardEntryName'] = request.forward_entry_name
        query['ForwardTableId'] = request.forward_table_id
        query['InternalIp'] = request.internal_ip
        query['InternalPort'] = request.internal_port
        query['IpProtocol'] = request.ip_protocol
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeForwardTableEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeForwardTableEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_forward_table_entries(
        self,
        request: vpc_20160428_models.DescribeForwardTableEntriesRequest,
    ) -> vpc_20160428_models.DescribeForwardTableEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_forward_table_entries_with_options(request, runtime)

    async def describe_forward_table_entries_async(
        self,
        request: vpc_20160428_models.DescribeForwardTableEntriesRequest,
    ) -> vpc_20160428_models.DescribeForwardTableEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_forward_table_entries_with_options_async(request, runtime)

    def describe_global_acceleration_instances_with_options(
        self,
        request: vpc_20160428_models.DescribeGlobalAccelerationInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeGlobalAccelerationInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthType'] = request.bandwidth_type
        query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        query['IncludeReservationData'] = request.include_reservation_data
        query['IpAddress'] = request.ip_address
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ServerId'] = request.server_id
        query['ServiceLocation'] = request.service_location
        query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeGlobalAccelerationInstances',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeGlobalAccelerationInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_global_acceleration_instances_with_options_async(
        self,
        request: vpc_20160428_models.DescribeGlobalAccelerationInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeGlobalAccelerationInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthType'] = request.bandwidth_type
        query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        query['IncludeReservationData'] = request.include_reservation_data
        query['IpAddress'] = request.ip_address
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ServerId'] = request.server_id
        query['ServiceLocation'] = request.service_location
        query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeGlobalAccelerationInstances',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeGlobalAccelerationInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_global_acceleration_instances(
        self,
        request: vpc_20160428_models.DescribeGlobalAccelerationInstancesRequest,
    ) -> vpc_20160428_models.DescribeGlobalAccelerationInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_global_acceleration_instances_with_options(request, runtime)

    async def describe_global_acceleration_instances_async(
        self,
        request: vpc_20160428_models.DescribeGlobalAccelerationInstancesRequest,
    ) -> vpc_20160428_models.DescribeGlobalAccelerationInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_global_acceleration_instances_with_options_async(request, runtime)

    def describe_grant_rules_to_cen_with_options(
        self,
        request: vpc_20160428_models.DescribeGrantRulesToCenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeGrantRulesToCenResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeGrantRulesToCen',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeGrantRulesToCenResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_grant_rules_to_cen_with_options_async(
        self,
        request: vpc_20160428_models.DescribeGrantRulesToCenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeGrantRulesToCenResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeGrantRulesToCen',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeGrantRulesToCenResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_grant_rules_to_cen(
        self,
        request: vpc_20160428_models.DescribeGrantRulesToCenRequest,
    ) -> vpc_20160428_models.DescribeGrantRulesToCenResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_grant_rules_to_cen_with_options(request, runtime)

    async def describe_grant_rules_to_cen_async(
        self,
        request: vpc_20160428_models.DescribeGrantRulesToCenRequest,
    ) -> vpc_20160428_models.DescribeGrantRulesToCenResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_grant_rules_to_cen_with_options_async(request, runtime)

    def describe_ha_vips_with_options(
        self,
        request: vpc_20160428_models.DescribeHaVipsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeHaVipsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Filter'] = request.filter
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeHaVips',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeHaVipsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ha_vips_with_options_async(
        self,
        request: vpc_20160428_models.DescribeHaVipsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeHaVipsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Filter'] = request.filter
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeHaVips',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeHaVipsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ha_vips(
        self,
        request: vpc_20160428_models.DescribeHaVipsRequest,
    ) -> vpc_20160428_models.DescribeHaVipsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ha_vips_with_options(request, runtime)

    async def describe_ha_vips_async(
        self,
        request: vpc_20160428_models.DescribeHaVipsRequest,
    ) -> vpc_20160428_models.DescribeHaVipsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ha_vips_with_options_async(request, runtime)

    def describe_high_definition_monitor_log_attribute_with_options(
        self,
        request: vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeHighDefinitionMonitorLogAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_high_definition_monitor_log_attribute_with_options_async(
        self,
        request: vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeHighDefinitionMonitorLogAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_high_definition_monitor_log_attribute(
        self,
        request: vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeRequest,
    ) -> vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_high_definition_monitor_log_attribute_with_options(request, runtime)

    async def describe_high_definition_monitor_log_attribute_async(
        self,
        request: vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeRequest,
    ) -> vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_high_definition_monitor_log_attribute_with_options_async(request, runtime)

    def describe_ipv_6translator_acl_list_attributes_with_options(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIPv6TranslatorAclListAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6translator_acl_list_attributes_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIPv6TranslatorAclListAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6translator_acl_list_attributes(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6translator_acl_list_attributes_with_options(request, runtime)

    async def describe_ipv_6translator_acl_list_attributes_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6translator_acl_list_attributes_with_options_async(request, runtime)

    def describe_ipv_6translator_acl_lists_with_options(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['AclName'] = request.acl_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIPv6TranslatorAclLists',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorAclListsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6translator_acl_lists_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['AclName'] = request.acl_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIPv6TranslatorAclLists',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorAclListsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6translator_acl_lists(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListsRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6translator_acl_lists_with_options(request, runtime)

    async def describe_ipv_6translator_acl_lists_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListsRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6translator_acl_lists_with_options_async(request, runtime)

    def describe_ipv_6translator_entries_with_options(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['AclStatus'] = request.acl_status
        query['AclType'] = request.acl_type
        query['AllocateIpv6Addr'] = request.allocate_ipv_6addr
        query['AllocateIpv6Port'] = request.allocate_ipv_6port
        query['BackendIpv4Addr'] = request.backend_ipv_4addr
        query['BackendIpv4Port'] = request.backend_ipv_4port
        query['ClientToken'] = request.client_token
        query['EntryName'] = request.entry_name
        query['Ipv6TranslatorEntryId'] = request.ipv_6translator_entry_id
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TransProtocol'] = request.trans_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIPv6TranslatorEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6translator_entries_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['AclStatus'] = request.acl_status
        query['AclType'] = request.acl_type
        query['AllocateIpv6Addr'] = request.allocate_ipv_6addr
        query['AllocateIpv6Port'] = request.allocate_ipv_6port
        query['BackendIpv4Addr'] = request.backend_ipv_4addr
        query['BackendIpv4Port'] = request.backend_ipv_4port
        query['ClientToken'] = request.client_token
        query['EntryName'] = request.entry_name
        query['Ipv6TranslatorEntryId'] = request.ipv_6translator_entry_id
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TransProtocol'] = request.trans_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIPv6TranslatorEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6translator_entries(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorEntriesRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6translator_entries_with_options(request, runtime)

    async def describe_ipv_6translator_entries_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorEntriesRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6translator_entries_with_options_async(request, runtime)

    def describe_ipv_6translators_with_options(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AllocateIpv4Addr'] = request.allocate_ipv_4addr
        query['AllocateIpv6Addr'] = request.allocate_ipv_6addr
        query['BusinessStatus'] = request.business_status
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['PayType'] = request.pay_type
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Spec'] = request.spec
        query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIPv6Translators',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6translators_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AllocateIpv4Addr'] = request.allocate_ipv_4addr
        query['AllocateIpv6Addr'] = request.allocate_ipv_6addr
        query['BusinessStatus'] = request.business_status
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['PayType'] = request.pay_type
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Spec'] = request.spec
        query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIPv6Translators',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6translators(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorsRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6translators_with_options(request, runtime)

    async def describe_ipv_6translators_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorsRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6translators_with_options_async(request, runtime)

    def describe_instance_auto_renew_attribute_with_options(
        self,
        request: vpc_20160428_models.DescribeInstanceAutoRenewAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeInstanceAutoRenewAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['RenewalStatus'] = request.renewal_status
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeInstanceAutoRenewAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeInstanceAutoRenewAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_auto_renew_attribute_with_options_async(
        self,
        request: vpc_20160428_models.DescribeInstanceAutoRenewAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeInstanceAutoRenewAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['RenewalStatus'] = request.renewal_status
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeInstanceAutoRenewAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeInstanceAutoRenewAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_auto_renew_attribute(
        self,
        request: vpc_20160428_models.DescribeInstanceAutoRenewAttributeRequest,
    ) -> vpc_20160428_models.DescribeInstanceAutoRenewAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_auto_renew_attribute_with_options(request, runtime)

    async def describe_instance_auto_renew_attribute_async(
        self,
        request: vpc_20160428_models.DescribeInstanceAutoRenewAttributeRequest,
    ) -> vpc_20160428_models.DescribeInstanceAutoRenewAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_auto_renew_attribute_with_options_async(request, runtime)

    def describe_ipv_6addresses_with_options(
        self,
        request: vpc_20160428_models.DescribeIpv6AddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6AddressesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AssociatedInstanceId'] = request.associated_instance_id
        query['AssociatedInstanceType'] = request.associated_instance_type
        query['Ipv6Address'] = request.ipv_6address
        query['Ipv6AddressId'] = request.ipv_6address_id
        query['Ipv6InternetBandwidthId'] = request.ipv_6internet_bandwidth_id
        query['Name'] = request.name
        query['NetworkType'] = request.network_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VSwitchId'] = request.v_switch_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIpv6Addresses',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6AddressesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6addresses_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIpv6AddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6AddressesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AssociatedInstanceId'] = request.associated_instance_id
        query['AssociatedInstanceType'] = request.associated_instance_type
        query['Ipv6Address'] = request.ipv_6address
        query['Ipv6AddressId'] = request.ipv_6address_id
        query['Ipv6InternetBandwidthId'] = request.ipv_6internet_bandwidth_id
        query['Name'] = request.name
        query['NetworkType'] = request.network_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VSwitchId'] = request.v_switch_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIpv6Addresses',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6AddressesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6addresses(
        self,
        request: vpc_20160428_models.DescribeIpv6AddressesRequest,
    ) -> vpc_20160428_models.DescribeIpv6AddressesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6addresses_with_options(request, runtime)

    async def describe_ipv_6addresses_async(
        self,
        request: vpc_20160428_models.DescribeIpv6AddressesRequest,
    ) -> vpc_20160428_models.DescribeIpv6AddressesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6addresses_with_options_async(request, runtime)

    def describe_ipv_6egress_only_rules_with_options(
        self,
        request: vpc_20160428_models.DescribeIpv6EgressOnlyRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6EgressOnlyRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['Ipv6EgressOnlyRuleId'] = request.ipv_6egress_only_rule_id
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIpv6EgressOnlyRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6EgressOnlyRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6egress_only_rules_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIpv6EgressOnlyRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6EgressOnlyRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['Ipv6EgressOnlyRuleId'] = request.ipv_6egress_only_rule_id
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIpv6EgressOnlyRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6EgressOnlyRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6egress_only_rules(
        self,
        request: vpc_20160428_models.DescribeIpv6EgressOnlyRulesRequest,
    ) -> vpc_20160428_models.DescribeIpv6EgressOnlyRulesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6egress_only_rules_with_options(request, runtime)

    async def describe_ipv_6egress_only_rules_async(
        self,
        request: vpc_20160428_models.DescribeIpv6EgressOnlyRulesRequest,
    ) -> vpc_20160428_models.DescribeIpv6EgressOnlyRulesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6egress_only_rules_with_options_async(request, runtime)

    def describe_ipv_6gateway_attribute_with_options(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6GatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIpv6GatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6GatewayAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6gateway_attribute_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6GatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIpv6GatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6GatewayAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6gateway_attribute(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewayAttributeRequest,
    ) -> vpc_20160428_models.DescribeIpv6GatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6gateway_attribute_with_options(request, runtime)

    async def describe_ipv_6gateway_attribute_async(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewayAttributeRequest,
    ) -> vpc_20160428_models.DescribeIpv6GatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6gateway_attribute_with_options_async(request, runtime)

    def describe_ipv_6gateways_with_options(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6GatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIpv6Gateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6GatewaysResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6gateways_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6GatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeIpv6Gateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6GatewaysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6gateways(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewaysRequest,
    ) -> vpc_20160428_models.DescribeIpv6GatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6gateways_with_options(request, runtime)

    async def describe_ipv_6gateways_async(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewaysRequest,
    ) -> vpc_20160428_models.DescribeIpv6GatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6gateways_with_options_async(request, runtime)

    def describe_nat_gateways_with_options(
        self,
        request: vpc_20160428_models.DescribeNatGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNatGatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['InstanceChargeType'] = request.instance_charge_type
        query['Name'] = request.name
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatType'] = request.nat_type
        query['NetworkType'] = request.network_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Spec'] = request.spec
        query['Status'] = request.status
        query['VpcId'] = request.vpc_id
        query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeNatGateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNatGatewaysResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_gateways_with_options_async(
        self,
        request: vpc_20160428_models.DescribeNatGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNatGatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['InstanceChargeType'] = request.instance_charge_type
        query['Name'] = request.name
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatType'] = request.nat_type
        query['NetworkType'] = request.network_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Spec'] = request.spec
        query['Status'] = request.status
        query['VpcId'] = request.vpc_id
        query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeNatGateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNatGatewaysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_gateways(
        self,
        request: vpc_20160428_models.DescribeNatGatewaysRequest,
    ) -> vpc_20160428_models.DescribeNatGatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_gateways_with_options(request, runtime)

    async def describe_nat_gateways_async(
        self,
        request: vpc_20160428_models.DescribeNatGatewaysRequest,
    ) -> vpc_20160428_models.DescribeNatGatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_gateways_with_options_async(request, runtime)

    def describe_network_acl_attributes_with_options(
        self,
        request: vpc_20160428_models.DescribeNetworkAclAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNetworkAclAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NetworkAclId'] = request.network_acl_id
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeNetworkAclAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNetworkAclAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_network_acl_attributes_with_options_async(
        self,
        request: vpc_20160428_models.DescribeNetworkAclAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNetworkAclAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NetworkAclId'] = request.network_acl_id
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeNetworkAclAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNetworkAclAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_network_acl_attributes(
        self,
        request: vpc_20160428_models.DescribeNetworkAclAttributesRequest,
    ) -> vpc_20160428_models.DescribeNetworkAclAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_network_acl_attributes_with_options(request, runtime)

    async def describe_network_acl_attributes_async(
        self,
        request: vpc_20160428_models.DescribeNetworkAclAttributesRequest,
    ) -> vpc_20160428_models.DescribeNetworkAclAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_network_acl_attributes_with_options_async(request, runtime)

    def describe_network_acls_with_options(
        self,
        request: vpc_20160428_models.DescribeNetworkAclsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNetworkAclsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NetworkAclId'] = request.network_acl_id
        query['NetworkAclName'] = request.network_acl_name
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceId'] = request.resource_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ResourceType'] = request.resource_type
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeNetworkAcls',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNetworkAclsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_network_acls_with_options_async(
        self,
        request: vpc_20160428_models.DescribeNetworkAclsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNetworkAclsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NetworkAclId'] = request.network_acl_id
        query['NetworkAclName'] = request.network_acl_name
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceId'] = request.resource_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ResourceType'] = request.resource_type
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeNetworkAcls',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNetworkAclsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_network_acls(
        self,
        request: vpc_20160428_models.DescribeNetworkAclsRequest,
    ) -> vpc_20160428_models.DescribeNetworkAclsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_network_acls_with_options(request, runtime)

    async def describe_network_acls_async(
        self,
        request: vpc_20160428_models.DescribeNetworkAclsRequest,
    ) -> vpc_20160428_models.DescribeNetworkAclsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_network_acls_with_options_async(request, runtime)

    def describe_new_project_eip_monitor_data_with_options(
        self,
        request: vpc_20160428_models.DescribeNewProjectEipMonitorDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNewProjectEipMonitorDataResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AllocationId'] = request.allocation_id
        query['EndTime'] = request.end_time
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeNewProjectEipMonitorData',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNewProjectEipMonitorDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_new_project_eip_monitor_data_with_options_async(
        self,
        request: vpc_20160428_models.DescribeNewProjectEipMonitorDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNewProjectEipMonitorDataResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AllocationId'] = request.allocation_id
        query['EndTime'] = request.end_time
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Period'] = request.period
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeNewProjectEipMonitorData',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNewProjectEipMonitorDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_new_project_eip_monitor_data(
        self,
        request: vpc_20160428_models.DescribeNewProjectEipMonitorDataRequest,
    ) -> vpc_20160428_models.DescribeNewProjectEipMonitorDataResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_new_project_eip_monitor_data_with_options(request, runtime)

    async def describe_new_project_eip_monitor_data_async(
        self,
        request: vpc_20160428_models.DescribeNewProjectEipMonitorDataRequest,
    ) -> vpc_20160428_models.DescribeNewProjectEipMonitorDataResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_new_project_eip_monitor_data_with_options_async(request, runtime)

    def describe_physical_connection_loawith_options(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribePhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribePhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribePhysicalConnectionLOAResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_physical_connection_loawith_options_async(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribePhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribePhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribePhysicalConnectionLOAResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_physical_connection_loa(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.DescribePhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_physical_connection_loawith_options(request, runtime)

    async def describe_physical_connection_loa_async(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.DescribePhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_physical_connection_loawith_options_async(request, runtime)

    def describe_physical_connections_with_options(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribePhysicalConnectionsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Filter'] = request.filter
        query['IncludeReservationData'] = request.include_reservation_data
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribePhysicalConnections',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribePhysicalConnectionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_physical_connections_with_options_async(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribePhysicalConnectionsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Filter'] = request.filter
        query['IncludeReservationData'] = request.include_reservation_data
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribePhysicalConnections',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribePhysicalConnectionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_physical_connections(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionsRequest,
    ) -> vpc_20160428_models.DescribePhysicalConnectionsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_physical_connections_with_options(request, runtime)

    async def describe_physical_connections_async(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionsRequest,
    ) -> vpc_20160428_models.DescribePhysicalConnectionsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_physical_connections_with_options_async(request, runtime)

    def describe_regions_with_options(
        self,
        request: vpc_20160428_models.DescribeRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRegionsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AcceptLanguage'] = request.accept_language
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeRegions',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRegionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_regions_with_options_async(
        self,
        request: vpc_20160428_models.DescribeRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRegionsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AcceptLanguage'] = request.accept_language
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeRegions',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRegionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_regions(
        self,
        request: vpc_20160428_models.DescribeRegionsRequest,
    ) -> vpc_20160428_models.DescribeRegionsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_regions_with_options(request, runtime)

    async def describe_regions_async(
        self,
        request: vpc_20160428_models.DescribeRegionsRequest,
    ) -> vpc_20160428_models.DescribeRegionsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_regions_with_options_async(request, runtime)

    def describe_route_entry_list_with_options(
        self,
        request: vpc_20160428_models.DescribeRouteEntryListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouteEntryListResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DestinationCidrBlock'] = request.destination_cidr_block
        query['IpVersion'] = request.ip_version
        query['MaxResult'] = request.max_result
        query['NextHopId'] = request.next_hop_id
        query['NextHopType'] = request.next_hop_type
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteEntryId'] = request.route_entry_id
        query['RouteEntryName'] = request.route_entry_name
        query['RouteEntryType'] = request.route_entry_type
        query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeRouteEntryList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouteEntryListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_route_entry_list_with_options_async(
        self,
        request: vpc_20160428_models.DescribeRouteEntryListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouteEntryListResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DestinationCidrBlock'] = request.destination_cidr_block
        query['IpVersion'] = request.ip_version
        query['MaxResult'] = request.max_result
        query['NextHopId'] = request.next_hop_id
        query['NextHopType'] = request.next_hop_type
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteEntryId'] = request.route_entry_id
        query['RouteEntryName'] = request.route_entry_name
        query['RouteEntryType'] = request.route_entry_type
        query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeRouteEntryList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouteEntryListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_route_entry_list(
        self,
        request: vpc_20160428_models.DescribeRouteEntryListRequest,
    ) -> vpc_20160428_models.DescribeRouteEntryListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_route_entry_list_with_options(request, runtime)

    async def describe_route_entry_list_async(
        self,
        request: vpc_20160428_models.DescribeRouteEntryListRequest,
    ) -> vpc_20160428_models.DescribeRouteEntryListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_route_entry_list_with_options_async(request, runtime)

    def describe_route_table_list_with_options(
        self,
        request: vpc_20160428_models.DescribeRouteTableListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouteTableListResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        query['RouteTableName'] = request.route_table_name
        query['RouterId'] = request.router_id
        query['RouterType'] = request.router_type
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeRouteTableList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouteTableListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_route_table_list_with_options_async(
        self,
        request: vpc_20160428_models.DescribeRouteTableListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouteTableListResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        query['RouteTableName'] = request.route_table_name
        query['RouterId'] = request.router_id
        query['RouterType'] = request.router_type
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeRouteTableList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouteTableListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_route_table_list(
        self,
        request: vpc_20160428_models.DescribeRouteTableListRequest,
    ) -> vpc_20160428_models.DescribeRouteTableListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_route_table_list_with_options(request, runtime)

    async def describe_route_table_list_async(
        self,
        request: vpc_20160428_models.DescribeRouteTableListRequest,
    ) -> vpc_20160428_models.DescribeRouteTableListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_route_table_list_with_options_async(request, runtime)

    def describe_route_tables_with_options(
        self,
        request: vpc_20160428_models.DescribeRouteTablesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouteTablesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        query['RouteTableName'] = request.route_table_name
        query['RouterId'] = request.router_id
        query['RouterType'] = request.router_type
        query['Type'] = request.type
        query['VRouterId'] = request.vrouter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeRouteTables',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouteTablesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_route_tables_with_options_async(
        self,
        request: vpc_20160428_models.DescribeRouteTablesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouteTablesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        query['RouteTableName'] = request.route_table_name
        query['RouterId'] = request.router_id
        query['RouterType'] = request.router_type
        query['Type'] = request.type
        query['VRouterId'] = request.vrouter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeRouteTables',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouteTablesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_route_tables(
        self,
        request: vpc_20160428_models.DescribeRouteTablesRequest,
    ) -> vpc_20160428_models.DescribeRouteTablesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_route_tables_with_options(request, runtime)

    async def describe_route_tables_async(
        self,
        request: vpc_20160428_models.DescribeRouteTablesRequest,
    ) -> vpc_20160428_models.DescribeRouteTablesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_route_tables_with_options_async(request, runtime)

    def describe_router_interface_attribute_with_options(
        self,
        request: vpc_20160428_models.DescribeRouterInterfaceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouterInterfaceAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['InstanceId'] = request.instance_id
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeRouterInterfaceAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouterInterfaceAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_router_interface_attribute_with_options_async(
        self,
        request: vpc_20160428_models.DescribeRouterInterfaceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouterInterfaceAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['InstanceId'] = request.instance_id
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeRouterInterfaceAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouterInterfaceAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_router_interface_attribute(
        self,
        request: vpc_20160428_models.DescribeRouterInterfaceAttributeRequest,
    ) -> vpc_20160428_models.DescribeRouterInterfaceAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_router_interface_attribute_with_options(request, runtime)

    async def describe_router_interface_attribute_async(
        self,
        request: vpc_20160428_models.DescribeRouterInterfaceAttributeRequest,
    ) -> vpc_20160428_models.DescribeRouterInterfaceAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_router_interface_attribute_with_options_async(request, runtime)

    def describe_router_interfaces_with_options(
        self,
        request: vpc_20160428_models.DescribeRouterInterfacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouterInterfacesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Filter'] = request.filter
        query['IncludeReservationData'] = request.include_reservation_data
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeRouterInterfaces',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouterInterfacesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_router_interfaces_with_options_async(
        self,
        request: vpc_20160428_models.DescribeRouterInterfacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouterInterfacesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Filter'] = request.filter
        query['IncludeReservationData'] = request.include_reservation_data
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeRouterInterfaces',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouterInterfacesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_router_interfaces(
        self,
        request: vpc_20160428_models.DescribeRouterInterfacesRequest,
    ) -> vpc_20160428_models.DescribeRouterInterfacesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_router_interfaces_with_options(request, runtime)

    async def describe_router_interfaces_async(
        self,
        request: vpc_20160428_models.DescribeRouterInterfacesRequest,
    ) -> vpc_20160428_models.DescribeRouterInterfacesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_router_interfaces_with_options_async(request, runtime)

    def describe_server_related_global_acceleration_instances_with_options(
        self,
        request: vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ServerId'] = request.server_id
        query['ServerType'] = request.server_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeServerRelatedGlobalAccelerationInstances',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_server_related_global_acceleration_instances_with_options_async(
        self,
        request: vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ServerId'] = request.server_id
        query['ServerType'] = request.server_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeServerRelatedGlobalAccelerationInstances',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_server_related_global_acceleration_instances(
        self,
        request: vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesRequest,
    ) -> vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_server_related_global_acceleration_instances_with_options(request, runtime)

    async def describe_server_related_global_acceleration_instances_async(
        self,
        request: vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesRequest,
    ) -> vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_server_related_global_acceleration_instances_with_options_async(request, runtime)

    def describe_snat_table_entries_with_options(
        self,
        request: vpc_20160428_models.DescribeSnatTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSnatTableEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SnatEntryId'] = request.snat_entry_id
        query['SnatEntryName'] = request.snat_entry_name
        query['SnatIp'] = request.snat_ip
        query['SnatTableId'] = request.snat_table_id
        query['SourceCIDR'] = request.source_cidr
        query['SourceVSwitchId'] = request.source_vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeSnatTableEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSnatTableEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_snat_table_entries_with_options_async(
        self,
        request: vpc_20160428_models.DescribeSnatTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSnatTableEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SnatEntryId'] = request.snat_entry_id
        query['SnatEntryName'] = request.snat_entry_name
        query['SnatIp'] = request.snat_ip
        query['SnatTableId'] = request.snat_table_id
        query['SourceCIDR'] = request.source_cidr
        query['SourceVSwitchId'] = request.source_vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeSnatTableEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSnatTableEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_snat_table_entries(
        self,
        request: vpc_20160428_models.DescribeSnatTableEntriesRequest,
    ) -> vpc_20160428_models.DescribeSnatTableEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_snat_table_entries_with_options(request, runtime)

    async def describe_snat_table_entries_async(
        self,
        request: vpc_20160428_models.DescribeSnatTableEntriesRequest,
    ) -> vpc_20160428_models.DescribeSnatTableEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_snat_table_entries_with_options_async(request, runtime)

    def describe_ssl_vpn_client_cert_with_options(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSslVpnClientCertResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ssl_vpn_client_cert_with_options_async(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSslVpnClientCertResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ssl_vpn_client_cert(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertRequest,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ssl_vpn_client_cert_with_options(request, runtime)

    async def describe_ssl_vpn_client_cert_async(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertRequest,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ssl_vpn_client_cert_with_options_async(request, runtime)

    def describe_ssl_vpn_client_certs_with_options(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeSslVpnClientCerts',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSslVpnClientCertsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ssl_vpn_client_certs_with_options_async(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeSslVpnClientCerts',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSslVpnClientCertsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ssl_vpn_client_certs(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertsRequest,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ssl_vpn_client_certs_with_options(request, runtime)

    async def describe_ssl_vpn_client_certs_async(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertsRequest,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ssl_vpn_client_certs_with_options_async(request, runtime)

    def describe_ssl_vpn_servers_with_options(
        self,
        request: vpc_20160428_models.DescribeSslVpnServersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSslVpnServersResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnServerId'] = request.ssl_vpn_server_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeSslVpnServers',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSslVpnServersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ssl_vpn_servers_with_options_async(
        self,
        request: vpc_20160428_models.DescribeSslVpnServersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSslVpnServersResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnServerId'] = request.ssl_vpn_server_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeSslVpnServers',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSslVpnServersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ssl_vpn_servers(
        self,
        request: vpc_20160428_models.DescribeSslVpnServersRequest,
    ) -> vpc_20160428_models.DescribeSslVpnServersResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ssl_vpn_servers_with_options(request, runtime)

    async def describe_ssl_vpn_servers_async(
        self,
        request: vpc_20160428_models.DescribeSslVpnServersRequest,
    ) -> vpc_20160428_models.DescribeSslVpnServersResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ssl_vpn_servers_with_options_async(request, runtime)

    def describe_vrouters_with_options(
        self,
        request: vpc_20160428_models.DescribeVRoutersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVRoutersResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VRouterId'] = request.vrouter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVRouters',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVRoutersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vrouters_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVRoutersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVRoutersResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VRouterId'] = request.vrouter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVRouters',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVRoutersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vrouters(
        self,
        request: vpc_20160428_models.DescribeVRoutersRequest,
    ) -> vpc_20160428_models.DescribeVRoutersResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vrouters_with_options(request, runtime)

    async def describe_vrouters_async(
        self,
        request: vpc_20160428_models.DescribeVRoutersRequest,
    ) -> vpc_20160428_models.DescribeVRoutersResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vrouters_with_options_async(request, runtime)

    def describe_vswitch_attributes_with_options(
        self,
        request: vpc_20160428_models.DescribeVSwitchAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVSwitchAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVSwitchAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVSwitchAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vswitch_attributes_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVSwitchAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVSwitchAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVSwitchAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVSwitchAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vswitch_attributes(
        self,
        request: vpc_20160428_models.DescribeVSwitchAttributesRequest,
    ) -> vpc_20160428_models.DescribeVSwitchAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vswitch_attributes_with_options(request, runtime)

    async def describe_vswitch_attributes_async(
        self,
        request: vpc_20160428_models.DescribeVSwitchAttributesRequest,
    ) -> vpc_20160428_models.DescribeVSwitchAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vswitch_attributes_with_options_async(request, runtime)

    def describe_vswitches_with_options(
        self,
        request: vpc_20160428_models.DescribeVSwitchesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVSwitchesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['IsDefault'] = request.is_default
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        query['VSwitchId'] = request.v_switch_id
        query['VSwitchName'] = request.v_switch_name
        query['VSwitchOwnerId'] = request.v_switch_owner_id
        query['VpcId'] = request.vpc_id
        query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVSwitches',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVSwitchesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vswitches_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVSwitchesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVSwitchesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['IsDefault'] = request.is_default
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        query['VSwitchId'] = request.v_switch_id
        query['VSwitchName'] = request.v_switch_name
        query['VSwitchOwnerId'] = request.v_switch_owner_id
        query['VpcId'] = request.vpc_id
        query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVSwitches',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVSwitchesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vswitches(
        self,
        request: vpc_20160428_models.DescribeVSwitchesRequest,
    ) -> vpc_20160428_models.DescribeVSwitchesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vswitches_with_options(request, runtime)

    async def describe_vswitches_async(
        self,
        request: vpc_20160428_models.DescribeVSwitchesRequest,
    ) -> vpc_20160428_models.DescribeVSwitchesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vswitches_with_options_async(request, runtime)

    def describe_vbr_ha_with_options(
        self,
        request: vpc_20160428_models.DescribeVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrHaId'] = request.vbr_ha_id
        query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVbrHaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vbr_ha_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrHaId'] = request.vbr_ha_id
        query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVbrHaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vbr_ha(
        self,
        request: vpc_20160428_models.DescribeVbrHaRequest,
    ) -> vpc_20160428_models.DescribeVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vbr_ha_with_options(request, runtime)

    async def describe_vbr_ha_async(
        self,
        request: vpc_20160428_models.DescribeVbrHaRequest,
    ) -> vpc_20160428_models.DescribeVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vbr_ha_with_options_async(request, runtime)

    def describe_virtual_border_routers_with_options(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Filter'] = request.filter
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVirtualBorderRouters',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVirtualBorderRoutersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_virtual_border_routers_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Filter'] = request.filter
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVirtualBorderRouters',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVirtualBorderRoutersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_virtual_border_routers(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersRequest,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_virtual_border_routers_with_options(request, runtime)

    async def describe_virtual_border_routers_async(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersRequest,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_virtual_border_routers_with_options_async(request, runtime)

    def describe_virtual_border_routers_for_physical_connection_with_options(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Filter'] = request.filter
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVirtualBorderRoutersForPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_virtual_border_routers_for_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Filter'] = request.filter
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVirtualBorderRoutersForPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_virtual_border_routers_for_physical_connection(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionRequest,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_virtual_border_routers_for_physical_connection_with_options(request, runtime)

    async def describe_virtual_border_routers_for_physical_connection_async(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionRequest,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_virtual_border_routers_for_physical_connection_with_options_async(request, runtime)

    def describe_vpc_attribute_with_options(
        self,
        request: vpc_20160428_models.DescribeVpcAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpcAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['IsDefault'] = request.is_default
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpcAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpcAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_attribute_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpcAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpcAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['IsDefault'] = request.is_default
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpcAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpcAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpc_attribute(
        self,
        request: vpc_20160428_models.DescribeVpcAttributeRequest,
    ) -> vpc_20160428_models.DescribeVpcAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpc_attribute_with_options(request, runtime)

    async def describe_vpc_attribute_async(
        self,
        request: vpc_20160428_models.DescribeVpcAttributeRequest,
    ) -> vpc_20160428_models.DescribeVpcAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpc_attribute_with_options_async(request, runtime)

    def describe_vpcs_with_options(
        self,
        request: vpc_20160428_models.DescribeVpcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpcsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        query['DryRun'] = request.dry_run
        query['IsDefault'] = request.is_default
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        query['VpcName'] = request.vpc_name
        query['VpcOwnerId'] = request.vpc_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpcs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpcsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpcs_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpcsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        query['DryRun'] = request.dry_run
        query['IsDefault'] = request.is_default
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceGroupId'] = request.resource_group_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        query['VpcName'] = request.vpc_name
        query['VpcOwnerId'] = request.vpc_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpcs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpcsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpcs(
        self,
        request: vpc_20160428_models.DescribeVpcsRequest,
    ) -> vpc_20160428_models.DescribeVpcsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpcs_with_options(request, runtime)

    async def describe_vpcs_async(
        self,
        request: vpc_20160428_models.DescribeVpcsRequest,
    ) -> vpc_20160428_models.DescribeVpcsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpcs_with_options_async(request, runtime)

    def describe_vpn_connection_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_connection_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_connection(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionRequest,
    ) -> vpc_20160428_models.DescribeVpnConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_connection_with_options(request, runtime)

    async def describe_vpn_connection_async(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionRequest,
    ) -> vpc_20160428_models.DescribeVpnConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_connection_with_options_async(request, runtime)

    def describe_vpn_connections_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnConnectionsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CustomerGatewayId'] = request.customer_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnConnectionId'] = request.vpn_connection_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnConnections',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnConnectionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_connections_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnConnectionsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CustomerGatewayId'] = request.customer_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnConnectionId'] = request.vpn_connection_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnConnections',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnConnectionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_connections(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionsRequest,
    ) -> vpc_20160428_models.DescribeVpnConnectionsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_connections_with_options(request, runtime)

    async def describe_vpn_connections_async(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionsRequest,
    ) -> vpc_20160428_models.DescribeVpnConnectionsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_connections_with_options_async(request, runtime)

    def describe_vpn_gateway_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['IncludeReservationData'] = request.include_reservation_data
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['IncludeReservationData'] = request.include_reservation_data
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_gateway(
        self,
        request: vpc_20160428_models.DescribeVpnGatewayRequest,
    ) -> vpc_20160428_models.DescribeVpnGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_gateway_with_options(request, runtime)

    async def describe_vpn_gateway_async(
        self,
        request: vpc_20160428_models.DescribeVpnGatewayRequest,
    ) -> vpc_20160428_models.DescribeVpnGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_gateway_with_options_async(request, runtime)

    def describe_vpn_gateways_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnGatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BusinessStatus'] = request.business_status
        query['IncludeReservationData'] = request.include_reservation_data
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Status'] = request.status
        query['Tag'] = request.tag
        query['VpcId'] = request.vpc_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnGateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnGatewaysResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_gateways_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnGatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BusinessStatus'] = request.business_status
        query['IncludeReservationData'] = request.include_reservation_data
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Status'] = request.status
        query['Tag'] = request.tag
        query['VpcId'] = request.vpc_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnGateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnGatewaysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_gateways(
        self,
        request: vpc_20160428_models.DescribeVpnGatewaysRequest,
    ) -> vpc_20160428_models.DescribeVpnGatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_gateways_with_options(request, runtime)

    async def describe_vpn_gateways_async(
        self,
        request: vpc_20160428_models.DescribeVpnGatewaysRequest,
    ) -> vpc_20160428_models.DescribeVpnGatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_gateways_with_options_async(request, runtime)

    def describe_vpn_pbr_route_entries_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnPbrRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnPbrRouteEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnPbrRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnPbrRouteEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_pbr_route_entries_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnPbrRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnPbrRouteEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnPbrRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnPbrRouteEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_pbr_route_entries(
        self,
        request: vpc_20160428_models.DescribeVpnPbrRouteEntriesRequest,
    ) -> vpc_20160428_models.DescribeVpnPbrRouteEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_pbr_route_entries_with_options(request, runtime)

    async def describe_vpn_pbr_route_entries_async(
        self,
        request: vpc_20160428_models.DescribeVpnPbrRouteEntriesRequest,
    ) -> vpc_20160428_models.DescribeVpnPbrRouteEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_pbr_route_entries_with_options_async(request, runtime)

    def describe_vpn_route_entries_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnRouteEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteEntryType'] = request.route_entry_type
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnRouteEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_route_entries_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnRouteEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteEntryType'] = request.route_entry_type
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnRouteEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_route_entries(
        self,
        request: vpc_20160428_models.DescribeVpnRouteEntriesRequest,
    ) -> vpc_20160428_models.DescribeVpnRouteEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_route_entries_with_options(request, runtime)

    async def describe_vpn_route_entries_async(
        self,
        request: vpc_20160428_models.DescribeVpnRouteEntriesRequest,
    ) -> vpc_20160428_models.DescribeVpnRouteEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_route_entries_with_options_async(request, runtime)

    def describe_vpn_ssl_server_logs_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnSslServerLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnSslServerLogsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['From'] = request.from_
        query['MinutePeriod'] = request.minute_period
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        query['To'] = request.to
        query['VpnSslServerId'] = request.vpn_ssl_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnSslServerLogs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnSslServerLogsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_ssl_server_logs_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnSslServerLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnSslServerLogsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['From'] = request.from_
        query['MinutePeriod'] = request.minute_period
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PageNumber'] = request.page_number
        query['PageSize'] = request.page_size
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        query['To'] = request.to
        query['VpnSslServerId'] = request.vpn_ssl_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeVpnSslServerLogs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnSslServerLogsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_ssl_server_logs(
        self,
        request: vpc_20160428_models.DescribeVpnSslServerLogsRequest,
    ) -> vpc_20160428_models.DescribeVpnSslServerLogsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_ssl_server_logs_with_options(request, runtime)

    async def describe_vpn_ssl_server_logs_async(
        self,
        request: vpc_20160428_models.DescribeVpnSslServerLogsRequest,
    ) -> vpc_20160428_models.DescribeVpnSslServerLogsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_ssl_server_logs_with_options_async(request, runtime)

    def describe_zones_with_options(
        self,
        request: vpc_20160428_models.DescribeZonesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeZonesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AcceptLanguage'] = request.accept_language
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ZoneType'] = request.zone_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeZones',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeZonesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_zones_with_options_async(
        self,
        request: vpc_20160428_models.DescribeZonesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeZonesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AcceptLanguage'] = request.accept_language
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ZoneType'] = request.zone_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DescribeZones',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeZonesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_zones(
        self,
        request: vpc_20160428_models.DescribeZonesRequest,
    ) -> vpc_20160428_models.DescribeZonesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_zones_with_options(request, runtime)

    async def describe_zones_async(
        self,
        request: vpc_20160428_models.DescribeZonesRequest,
    ) -> vpc_20160428_models.DescribeZonesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_zones_with_options_async(request, runtime)

    def detach_dhcp_options_set_from_vpc_with_options(
        self,
        request: vpc_20160428_models.DetachDhcpOptionsSetFromVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DetachDhcpOptionsSetFromVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DetachDhcpOptionsSetFromVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DetachDhcpOptionsSetFromVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def detach_dhcp_options_set_from_vpc_with_options_async(
        self,
        request: vpc_20160428_models.DetachDhcpOptionsSetFromVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DetachDhcpOptionsSetFromVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        query['DryRun'] = request.dry_run
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DetachDhcpOptionsSetFromVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DetachDhcpOptionsSetFromVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def detach_dhcp_options_set_from_vpc(
        self,
        request: vpc_20160428_models.DetachDhcpOptionsSetFromVpcRequest,
    ) -> vpc_20160428_models.DetachDhcpOptionsSetFromVpcResponse:
        runtime = util_models.RuntimeOptions()
        return self.detach_dhcp_options_set_from_vpc_with_options(request, runtime)

    async def detach_dhcp_options_set_from_vpc_async(
        self,
        request: vpc_20160428_models.DetachDhcpOptionsSetFromVpcRequest,
    ) -> vpc_20160428_models.DetachDhcpOptionsSetFromVpcResponse:
        runtime = util_models.RuntimeOptions()
        return await self.detach_dhcp_options_set_from_vpc_with_options_async(request, runtime)

    def disable_nat_gateway_ecs_metric_with_options(
        self,
        request: vpc_20160428_models.DisableNatGatewayEcsMetricRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DisableNatGatewayEcsMetricResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['NatGatewayId'] = request.nat_gateway_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DisableNatGatewayEcsMetric',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DisableNatGatewayEcsMetricResponse(),
            self.call_api(params, req, runtime)
        )

    async def disable_nat_gateway_ecs_metric_with_options_async(
        self,
        request: vpc_20160428_models.DisableNatGatewayEcsMetricRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DisableNatGatewayEcsMetricResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['NatGatewayId'] = request.nat_gateway_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DisableNatGatewayEcsMetric',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DisableNatGatewayEcsMetricResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def disable_nat_gateway_ecs_metric(
        self,
        request: vpc_20160428_models.DisableNatGatewayEcsMetricRequest,
    ) -> vpc_20160428_models.DisableNatGatewayEcsMetricResponse:
        runtime = util_models.RuntimeOptions()
        return self.disable_nat_gateway_ecs_metric_with_options(request, runtime)

    async def disable_nat_gateway_ecs_metric_async(
        self,
        request: vpc_20160428_models.DisableNatGatewayEcsMetricRequest,
    ) -> vpc_20160428_models.DisableNatGatewayEcsMetricResponse:
        runtime = util_models.RuntimeOptions()
        return await self.disable_nat_gateway_ecs_metric_with_options_async(request, runtime)

    def disable_vpc_classic_link_with_options(
        self,
        request: vpc_20160428_models.DisableVpcClassicLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DisableVpcClassicLinkResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DisableVpcClassicLink',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DisableVpcClassicLinkResponse(),
            self.call_api(params, req, runtime)
        )

    async def disable_vpc_classic_link_with_options_async(
        self,
        request: vpc_20160428_models.DisableVpcClassicLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DisableVpcClassicLinkResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DisableVpcClassicLink',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DisableVpcClassicLinkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def disable_vpc_classic_link(
        self,
        request: vpc_20160428_models.DisableVpcClassicLinkRequest,
    ) -> vpc_20160428_models.DisableVpcClassicLinkResponse:
        runtime = util_models.RuntimeOptions()
        return self.disable_vpc_classic_link_with_options(request, runtime)

    async def disable_vpc_classic_link_async(
        self,
        request: vpc_20160428_models.DisableVpcClassicLinkRequest,
    ) -> vpc_20160428_models.DisableVpcClassicLinkResponse:
        runtime = util_models.RuntimeOptions()
        return await self.disable_vpc_classic_link_with_options_async(request, runtime)

    def dissociate_route_table_from_gateway_with_options(
        self,
        request: vpc_20160428_models.DissociateRouteTableFromGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DissociateRouteTableFromGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['GatewayId'] = request.gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DissociateRouteTableFromGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DissociateRouteTableFromGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def dissociate_route_table_from_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DissociateRouteTableFromGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DissociateRouteTableFromGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['GatewayId'] = request.gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DissociateRouteTableFromGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DissociateRouteTableFromGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def dissociate_route_table_from_gateway(
        self,
        request: vpc_20160428_models.DissociateRouteTableFromGatewayRequest,
    ) -> vpc_20160428_models.DissociateRouteTableFromGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.dissociate_route_table_from_gateway_with_options(request, runtime)

    async def dissociate_route_table_from_gateway_async(
        self,
        request: vpc_20160428_models.DissociateRouteTableFromGatewayRequest,
    ) -> vpc_20160428_models.DissociateRouteTableFromGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.dissociate_route_table_from_gateway_with_options_async(request, runtime)

    def dissociate_route_tables_from_vpc_gateway_endpoint_with_options(
        self,
        request: vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EndpointId'] = request.endpoint_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableIds'] = request.route_table_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DissociateRouteTablesFromVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def dissociate_route_tables_from_vpc_gateway_endpoint_with_options_async(
        self,
        request: vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['EndpointId'] = request.endpoint_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableIds'] = request.route_table_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DissociateRouteTablesFromVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def dissociate_route_tables_from_vpc_gateway_endpoint(
        self,
        request: vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return self.dissociate_route_tables_from_vpc_gateway_endpoint_with_options(request, runtime)

    async def dissociate_route_tables_from_vpc_gateway_endpoint_async(
        self,
        request: vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return await self.dissociate_route_tables_from_vpc_gateway_endpoint_with_options_async(request, runtime)

    def dissociate_vpn_gateway_with_certificate_with_options(
        self,
        request: vpc_20160428_models.DissociateVpnGatewayWithCertificateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DissociateVpnGatewayWithCertificateResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CertificateId'] = request.certificate_id
        query['CertificateType'] = request.certificate_type
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['RegionId'] = request.region_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DissociateVpnGatewayWithCertificate',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DissociateVpnGatewayWithCertificateResponse(),
            self.call_api(params, req, runtime)
        )

    async def dissociate_vpn_gateway_with_certificate_with_options_async(
        self,
        request: vpc_20160428_models.DissociateVpnGatewayWithCertificateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DissociateVpnGatewayWithCertificateResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CertificateId'] = request.certificate_id
        query['CertificateType'] = request.certificate_type
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['RegionId'] = request.region_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DissociateVpnGatewayWithCertificate',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DissociateVpnGatewayWithCertificateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def dissociate_vpn_gateway_with_certificate(
        self,
        request: vpc_20160428_models.DissociateVpnGatewayWithCertificateRequest,
    ) -> vpc_20160428_models.DissociateVpnGatewayWithCertificateResponse:
        runtime = util_models.RuntimeOptions()
        return self.dissociate_vpn_gateway_with_certificate_with_options(request, runtime)

    async def dissociate_vpn_gateway_with_certificate_async(
        self,
        request: vpc_20160428_models.DissociateVpnGatewayWithCertificateRequest,
    ) -> vpc_20160428_models.DissociateVpnGatewayWithCertificateResponse:
        runtime = util_models.RuntimeOptions()
        return await self.dissociate_vpn_gateway_with_certificate_with_options_async(request, runtime)

    def download_vpn_connection_config_with_options(
        self,
        request: vpc_20160428_models.DownloadVpnConnectionConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DownloadVpnConnectionConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DownloadVpnConnectionConfig',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DownloadVpnConnectionConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def download_vpn_connection_config_with_options_async(
        self,
        request: vpc_20160428_models.DownloadVpnConnectionConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DownloadVpnConnectionConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='DownloadVpnConnectionConfig',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DownloadVpnConnectionConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def download_vpn_connection_config(
        self,
        request: vpc_20160428_models.DownloadVpnConnectionConfigRequest,
    ) -> vpc_20160428_models.DownloadVpnConnectionConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.download_vpn_connection_config_with_options(request, runtime)

    async def download_vpn_connection_config_async(
        self,
        request: vpc_20160428_models.DownloadVpnConnectionConfigRequest,
    ) -> vpc_20160428_models.DownloadVpnConnectionConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.download_vpn_connection_config_with_options_async(request, runtime)

    def enable_nat_gateway_ecs_metric_with_options(
        self,
        request: vpc_20160428_models.EnableNatGatewayEcsMetricRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnableNatGatewayEcsMetricResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['NatGatewayId'] = request.nat_gateway_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='EnableNatGatewayEcsMetric',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnableNatGatewayEcsMetricResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_nat_gateway_ecs_metric_with_options_async(
        self,
        request: vpc_20160428_models.EnableNatGatewayEcsMetricRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnableNatGatewayEcsMetricResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['NatGatewayId'] = request.nat_gateway_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='EnableNatGatewayEcsMetric',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnableNatGatewayEcsMetricResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_nat_gateway_ecs_metric(
        self,
        request: vpc_20160428_models.EnableNatGatewayEcsMetricRequest,
    ) -> vpc_20160428_models.EnableNatGatewayEcsMetricResponse:
        runtime = util_models.RuntimeOptions()
        return self.enable_nat_gateway_ecs_metric_with_options(request, runtime)

    async def enable_nat_gateway_ecs_metric_async(
        self,
        request: vpc_20160428_models.EnableNatGatewayEcsMetricRequest,
    ) -> vpc_20160428_models.EnableNatGatewayEcsMetricResponse:
        runtime = util_models.RuntimeOptions()
        return await self.enable_nat_gateway_ecs_metric_with_options_async(request, runtime)

    def enable_physical_connection_with_options(
        self,
        request: vpc_20160428_models.EnablePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnablePhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='EnablePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnablePhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.EnablePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnablePhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='EnablePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnablePhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_physical_connection(
        self,
        request: vpc_20160428_models.EnablePhysicalConnectionRequest,
    ) -> vpc_20160428_models.EnablePhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.enable_physical_connection_with_options(request, runtime)

    async def enable_physical_connection_async(
        self,
        request: vpc_20160428_models.EnablePhysicalConnectionRequest,
    ) -> vpc_20160428_models.EnablePhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.enable_physical_connection_with_options_async(request, runtime)

    def enable_vpc_classic_link_with_options(
        self,
        request: vpc_20160428_models.EnableVpcClassicLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnableVpcClassicLinkResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='EnableVpcClassicLink',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnableVpcClassicLinkResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_vpc_classic_link_with_options_async(
        self,
        request: vpc_20160428_models.EnableVpcClassicLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnableVpcClassicLinkResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='EnableVpcClassicLink',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnableVpcClassicLinkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_vpc_classic_link(
        self,
        request: vpc_20160428_models.EnableVpcClassicLinkRequest,
    ) -> vpc_20160428_models.EnableVpcClassicLinkResponse:
        runtime = util_models.RuntimeOptions()
        return self.enable_vpc_classic_link_with_options(request, runtime)

    async def enable_vpc_classic_link_async(
        self,
        request: vpc_20160428_models.EnableVpcClassicLinkRequest,
    ) -> vpc_20160428_models.EnableVpcClassicLinkResponse:
        runtime = util_models.RuntimeOptions()
        return await self.enable_vpc_classic_link_with_options_async(request, runtime)

    def enable_vpc_ipv_4gateway_with_options(
        self,
        request: vpc_20160428_models.EnableVpcIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnableVpcIpv4GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['Ipv4GatewayId'] = request.ipv_4gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableList'] = request.route_table_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='EnableVpcIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnableVpcIpv4GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_vpc_ipv_4gateway_with_options_async(
        self,
        request: vpc_20160428_models.EnableVpcIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnableVpcIpv4GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['Ipv4GatewayId'] = request.ipv_4gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableList'] = request.route_table_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='EnableVpcIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnableVpcIpv4GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_vpc_ipv_4gateway(
        self,
        request: vpc_20160428_models.EnableVpcIpv4GatewayRequest,
    ) -> vpc_20160428_models.EnableVpcIpv4GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.enable_vpc_ipv_4gateway_with_options(request, runtime)

    async def enable_vpc_ipv_4gateway_async(
        self,
        request: vpc_20160428_models.EnableVpcIpv4GatewayRequest,
    ) -> vpc_20160428_models.EnableVpcIpv4GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.enable_vpc_ipv_4gateway_with_options_async(request, runtime)

    def get_dhcp_options_set_with_options(
        self,
        request: vpc_20160428_models.GetDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetDhcpOptionsSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_dhcp_options_set_with_options_async(
        self,
        request: vpc_20160428_models.GetDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetDhcpOptionsSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_dhcp_options_set(
        self,
        request: vpc_20160428_models.GetDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.GetDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return self.get_dhcp_options_set_with_options(request, runtime)

    async def get_dhcp_options_set_async(
        self,
        request: vpc_20160428_models.GetDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.GetDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.get_dhcp_options_set_with_options_async(request, runtime)

    def get_ipv_4gateway_attribute_with_options(
        self,
        request: vpc_20160428_models.GetIpv4GatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetIpv4GatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Ipv4GatewayId'] = request.ipv_4gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetIpv4GatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetIpv4GatewayAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_ipv_4gateway_attribute_with_options_async(
        self,
        request: vpc_20160428_models.GetIpv4GatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetIpv4GatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Ipv4GatewayId'] = request.ipv_4gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetIpv4GatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetIpv4GatewayAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_ipv_4gateway_attribute(
        self,
        request: vpc_20160428_models.GetIpv4GatewayAttributeRequest,
    ) -> vpc_20160428_models.GetIpv4GatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.get_ipv_4gateway_attribute_with_options(request, runtime)

    async def get_ipv_4gateway_attribute_async(
        self,
        request: vpc_20160428_models.GetIpv4GatewayAttributeRequest,
    ) -> vpc_20160428_models.GetIpv4GatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.get_ipv_4gateway_attribute_with_options_async(request, runtime)

    def get_nat_gateway_attribute_with_options(
        self,
        request: vpc_20160428_models.GetNatGatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetNatGatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['NatGatewayId'] = request.nat_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetNatGatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetNatGatewayAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_nat_gateway_attribute_with_options_async(
        self,
        request: vpc_20160428_models.GetNatGatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetNatGatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['NatGatewayId'] = request.nat_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetNatGatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetNatGatewayAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_nat_gateway_attribute(
        self,
        request: vpc_20160428_models.GetNatGatewayAttributeRequest,
    ) -> vpc_20160428_models.GetNatGatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.get_nat_gateway_attribute_with_options(request, runtime)

    async def get_nat_gateway_attribute_async(
        self,
        request: vpc_20160428_models.GetNatGatewayAttributeRequest,
    ) -> vpc_20160428_models.GetNatGatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.get_nat_gateway_attribute_with_options_async(request, runtime)

    def get_nat_gateway_convert_status_with_options(
        self,
        request: vpc_20160428_models.GetNatGatewayConvertStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetNatGatewayConvertStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        query['NatGatewayId'] = request.nat_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetNatGatewayConvertStatus',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetNatGatewayConvertStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_nat_gateway_convert_status_with_options_async(
        self,
        request: vpc_20160428_models.GetNatGatewayConvertStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetNatGatewayConvertStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        query['NatGatewayId'] = request.nat_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetNatGatewayConvertStatus',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetNatGatewayConvertStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_nat_gateway_convert_status(
        self,
        request: vpc_20160428_models.GetNatGatewayConvertStatusRequest,
    ) -> vpc_20160428_models.GetNatGatewayConvertStatusResponse:
        runtime = util_models.RuntimeOptions()
        return self.get_nat_gateway_convert_status_with_options(request, runtime)

    async def get_nat_gateway_convert_status_async(
        self,
        request: vpc_20160428_models.GetNatGatewayConvertStatusRequest,
    ) -> vpc_20160428_models.GetNatGatewayConvertStatusResponse:
        runtime = util_models.RuntimeOptions()
        return await self.get_nat_gateway_convert_status_with_options_async(request, runtime)

    def get_physical_connection_service_status_with_options(
        self,
        request: vpc_20160428_models.GetPhysicalConnectionServiceStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetPhysicalConnectionServiceStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetPhysicalConnectionServiceStatus',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetPhysicalConnectionServiceStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_physical_connection_service_status_with_options_async(
        self,
        request: vpc_20160428_models.GetPhysicalConnectionServiceStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetPhysicalConnectionServiceStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetPhysicalConnectionServiceStatus',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetPhysicalConnectionServiceStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_physical_connection_service_status(
        self,
        request: vpc_20160428_models.GetPhysicalConnectionServiceStatusRequest,
    ) -> vpc_20160428_models.GetPhysicalConnectionServiceStatusResponse:
        runtime = util_models.RuntimeOptions()
        return self.get_physical_connection_service_status_with_options(request, runtime)

    async def get_physical_connection_service_status_async(
        self,
        request: vpc_20160428_models.GetPhysicalConnectionServiceStatusRequest,
    ) -> vpc_20160428_models.GetPhysicalConnectionServiceStatusResponse:
        runtime = util_models.RuntimeOptions()
        return await self.get_physical_connection_service_status_with_options_async(request, runtime)

    def get_traffic_mirror_service_status_with_options(
        self,
        request: vpc_20160428_models.GetTrafficMirrorServiceStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetTrafficMirrorServiceStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetTrafficMirrorServiceStatus',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetTrafficMirrorServiceStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_traffic_mirror_service_status_with_options_async(
        self,
        request: vpc_20160428_models.GetTrafficMirrorServiceStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetTrafficMirrorServiceStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetTrafficMirrorServiceStatus',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetTrafficMirrorServiceStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_traffic_mirror_service_status(
        self,
        request: vpc_20160428_models.GetTrafficMirrorServiceStatusRequest,
    ) -> vpc_20160428_models.GetTrafficMirrorServiceStatusResponse:
        runtime = util_models.RuntimeOptions()
        return self.get_traffic_mirror_service_status_with_options(request, runtime)

    async def get_traffic_mirror_service_status_async(
        self,
        request: vpc_20160428_models.GetTrafficMirrorServiceStatusRequest,
    ) -> vpc_20160428_models.GetTrafficMirrorServiceStatusResponse:
        runtime = util_models.RuntimeOptions()
        return await self.get_traffic_mirror_service_status_with_options_async(request, runtime)

    def get_vpc_gateway_endpoint_attribute_with_options(
        self,
        request: vpc_20160428_models.GetVpcGatewayEndpointAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetVpcGatewayEndpointAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['EndpointId'] = request.endpoint_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetVpcGatewayEndpointAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetVpcGatewayEndpointAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_vpc_gateway_endpoint_attribute_with_options_async(
        self,
        request: vpc_20160428_models.GetVpcGatewayEndpointAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetVpcGatewayEndpointAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['EndpointId'] = request.endpoint_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GetVpcGatewayEndpointAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetVpcGatewayEndpointAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_vpc_gateway_endpoint_attribute(
        self,
        request: vpc_20160428_models.GetVpcGatewayEndpointAttributeRequest,
    ) -> vpc_20160428_models.GetVpcGatewayEndpointAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.get_vpc_gateway_endpoint_attribute_with_options(request, runtime)

    async def get_vpc_gateway_endpoint_attribute_async(
        self,
        request: vpc_20160428_models.GetVpcGatewayEndpointAttributeRequest,
    ) -> vpc_20160428_models.GetVpcGatewayEndpointAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.get_vpc_gateway_endpoint_attribute_with_options_async(request, runtime)

    def grant_instance_to_cen_with_options(
        self,
        request: vpc_20160428_models.GrantInstanceToCenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GrantInstanceToCenResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CenId'] = request.cen_id
        query['CenOwnerId'] = request.cen_owner_id
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GrantInstanceToCen',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GrantInstanceToCenResponse(),
            self.call_api(params, req, runtime)
        )

    async def grant_instance_to_cen_with_options_async(
        self,
        request: vpc_20160428_models.GrantInstanceToCenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GrantInstanceToCenResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CenId'] = request.cen_id
        query['CenOwnerId'] = request.cen_owner_id
        query['ClientToken'] = request.client_token
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='GrantInstanceToCen',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GrantInstanceToCenResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def grant_instance_to_cen(
        self,
        request: vpc_20160428_models.GrantInstanceToCenRequest,
    ) -> vpc_20160428_models.GrantInstanceToCenResponse:
        runtime = util_models.RuntimeOptions()
        return self.grant_instance_to_cen_with_options(request, runtime)

    async def grant_instance_to_cen_async(
        self,
        request: vpc_20160428_models.GrantInstanceToCenRequest,
    ) -> vpc_20160428_models.GrantInstanceToCenResponse:
        runtime = util_models.RuntimeOptions()
        return await self.grant_instance_to_cen_with_options_async(request, runtime)

    def list_dhcp_options_sets_with_options(
        self,
        request: vpc_20160428_models.ListDhcpOptionsSetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListDhcpOptionsSetsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        query['DhcpOptionsSetName'] = request.dhcp_options_set_name
        query['DomainName'] = request.domain_name
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListDhcpOptionsSets',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListDhcpOptionsSetsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_dhcp_options_sets_with_options_async(
        self,
        request: vpc_20160428_models.ListDhcpOptionsSetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListDhcpOptionsSetsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        query['DhcpOptionsSetName'] = request.dhcp_options_set_name
        query['DomainName'] = request.domain_name
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListDhcpOptionsSets',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListDhcpOptionsSetsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_dhcp_options_sets(
        self,
        request: vpc_20160428_models.ListDhcpOptionsSetsRequest,
    ) -> vpc_20160428_models.ListDhcpOptionsSetsResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_dhcp_options_sets_with_options(request, runtime)

    async def list_dhcp_options_sets_async(
        self,
        request: vpc_20160428_models.ListDhcpOptionsSetsRequest,
    ) -> vpc_20160428_models.ListDhcpOptionsSetsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_dhcp_options_sets_with_options_async(request, runtime)

    def list_enhanhced_nat_gateway_available_zones_with_options(
        self,
        request: vpc_20160428_models.ListEnhanhcedNatGatewayAvailableZonesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListEnhanhcedNatGatewayAvailableZonesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListEnhanhcedNatGatewayAvailableZones',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListEnhanhcedNatGatewayAvailableZonesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_enhanhced_nat_gateway_available_zones_with_options_async(
        self,
        request: vpc_20160428_models.ListEnhanhcedNatGatewayAvailableZonesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListEnhanhcedNatGatewayAvailableZonesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListEnhanhcedNatGatewayAvailableZones',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListEnhanhcedNatGatewayAvailableZonesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_enhanhced_nat_gateway_available_zones(
        self,
        request: vpc_20160428_models.ListEnhanhcedNatGatewayAvailableZonesRequest,
    ) -> vpc_20160428_models.ListEnhanhcedNatGatewayAvailableZonesResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_enhanhced_nat_gateway_available_zones_with_options(request, runtime)

    async def list_enhanhced_nat_gateway_available_zones_async(
        self,
        request: vpc_20160428_models.ListEnhanhcedNatGatewayAvailableZonesRequest,
    ) -> vpc_20160428_models.ListEnhanhcedNatGatewayAvailableZonesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_enhanhced_nat_gateway_available_zones_with_options_async(request, runtime)

    def list_full_nat_entries_with_options(
        self,
        request: vpc_20160428_models.ListFullNatEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListFullNatEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['FullNatEntryId'] = request.full_nat_entry_id
        query['FullNatEntryNames'] = request.full_nat_entry_names
        query['FullNatTableId'] = request.full_nat_table_id
        query['IpProtocol'] = request.ip_protocol
        query['MaxResults'] = request.max_results
        query['NetworkInterfaceIds'] = request.network_interface_ids
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListFullNatEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListFullNatEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_full_nat_entries_with_options_async(
        self,
        request: vpc_20160428_models.ListFullNatEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListFullNatEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['FullNatEntryId'] = request.full_nat_entry_id
        query['FullNatEntryNames'] = request.full_nat_entry_names
        query['FullNatTableId'] = request.full_nat_table_id
        query['IpProtocol'] = request.ip_protocol
        query['MaxResults'] = request.max_results
        query['NetworkInterfaceIds'] = request.network_interface_ids
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListFullNatEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListFullNatEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_full_nat_entries(
        self,
        request: vpc_20160428_models.ListFullNatEntriesRequest,
    ) -> vpc_20160428_models.ListFullNatEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_full_nat_entries_with_options(request, runtime)

    async def list_full_nat_entries_async(
        self,
        request: vpc_20160428_models.ListFullNatEntriesRequest,
    ) -> vpc_20160428_models.ListFullNatEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_full_nat_entries_with_options_async(request, runtime)

    def list_gateway_route_table_entries_with_options(
        self,
        request: vpc_20160428_models.ListGatewayRouteTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListGatewayRouteTableEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DestinationCidrBlock'] = request.destination_cidr_block
        query['GatewayRouteTableId'] = request.gateway_route_table_id
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListGatewayRouteTableEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListGatewayRouteTableEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_route_table_entries_with_options_async(
        self,
        request: vpc_20160428_models.ListGatewayRouteTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListGatewayRouteTableEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DestinationCidrBlock'] = request.destination_cidr_block
        query['GatewayRouteTableId'] = request.gateway_route_table_id
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListGatewayRouteTableEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListGatewayRouteTableEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway_route_table_entries(
        self,
        request: vpc_20160428_models.ListGatewayRouteTableEntriesRequest,
    ) -> vpc_20160428_models.ListGatewayRouteTableEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_route_table_entries_with_options(request, runtime)

    async def list_gateway_route_table_entries_async(
        self,
        request: vpc_20160428_models.ListGatewayRouteTableEntriesRequest,
    ) -> vpc_20160428_models.ListGatewayRouteTableEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_route_table_entries_with_options_async(request, runtime)

    def list_ipsec_servers_with_options(
        self,
        request: vpc_20160428_models.ListIpsecServersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListIpsecServersResponse:
        UtilClient.validate_model(request)
        query = {}
        query['IpsecServerId'] = request.ipsec_server_id
        query['IpsecServerName'] = request.ipsec_server_name
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['RegionId'] = request.region_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListIpsecServers',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListIpsecServersResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_ipsec_servers_with_options_async(
        self,
        request: vpc_20160428_models.ListIpsecServersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListIpsecServersResponse:
        UtilClient.validate_model(request)
        query = {}
        query['IpsecServerId'] = request.ipsec_server_id
        query['IpsecServerName'] = request.ipsec_server_name
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['RegionId'] = request.region_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListIpsecServers',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListIpsecServersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_ipsec_servers(
        self,
        request: vpc_20160428_models.ListIpsecServersRequest,
    ) -> vpc_20160428_models.ListIpsecServersResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_ipsec_servers_with_options(request, runtime)

    async def list_ipsec_servers_async(
        self,
        request: vpc_20160428_models.ListIpsecServersRequest,
    ) -> vpc_20160428_models.ListIpsecServersResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_ipsec_servers_with_options_async(request, runtime)

    def list_ipv_4gateways_with_options(
        self,
        request: vpc_20160428_models.ListIpv4GatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListIpv4GatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Ipv4GatewayId'] = request.ipv_4gateway_id
        query['Ipv4GatewayName'] = request.ipv_4gateway_name
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListIpv4Gateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListIpv4GatewaysResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_ipv_4gateways_with_options_async(
        self,
        request: vpc_20160428_models.ListIpv4GatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListIpv4GatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Ipv4GatewayId'] = request.ipv_4gateway_id
        query['Ipv4GatewayName'] = request.ipv_4gateway_name
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListIpv4Gateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListIpv4GatewaysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_ipv_4gateways(
        self,
        request: vpc_20160428_models.ListIpv4GatewaysRequest,
    ) -> vpc_20160428_models.ListIpv4GatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_ipv_4gateways_with_options(request, runtime)

    async def list_ipv_4gateways_async(
        self,
        request: vpc_20160428_models.ListIpv4GatewaysRequest,
    ) -> vpc_20160428_models.ListIpv4GatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_ipv_4gateways_with_options_async(request, runtime)

    def list_nat_gateway_ecs_metric_with_options(
        self,
        request: vpc_20160428_models.ListNatGatewayEcsMetricRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListNatGatewayEcsMetricResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['MaxResults'] = request.max_results
        query['NatGatewayId'] = request.nat_gateway_id
        query['NextToken'] = request.next_token
        query['OrderKey'] = request.order_key
        query['OrderType'] = request.order_type
        query['PrivateIpAddress'] = request.private_ip_address
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['TimePoint'] = request.time_point
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListNatGatewayEcsMetric',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListNatGatewayEcsMetricResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_nat_gateway_ecs_metric_with_options_async(
        self,
        request: vpc_20160428_models.ListNatGatewayEcsMetricRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListNatGatewayEcsMetricResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['MaxResults'] = request.max_results
        query['NatGatewayId'] = request.nat_gateway_id
        query['NextToken'] = request.next_token
        query['OrderKey'] = request.order_key
        query['OrderType'] = request.order_type
        query['PrivateIpAddress'] = request.private_ip_address
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['TimePoint'] = request.time_point
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListNatGatewayEcsMetric',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListNatGatewayEcsMetricResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_nat_gateway_ecs_metric(
        self,
        request: vpc_20160428_models.ListNatGatewayEcsMetricRequest,
    ) -> vpc_20160428_models.ListNatGatewayEcsMetricResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_nat_gateway_ecs_metric_with_options(request, runtime)

    async def list_nat_gateway_ecs_metric_async(
        self,
        request: vpc_20160428_models.ListNatGatewayEcsMetricRequest,
    ) -> vpc_20160428_models.ListNatGatewayEcsMetricResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_nat_gateway_ecs_metric_with_options_async(request, runtime)

    def list_nat_ip_cidrs_with_options(
        self,
        request: vpc_20160428_models.ListNatIpCidrsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListNatIpCidrsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['MaxResults'] = request.max_results
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatIpCidr'] = request.nat_ip_cidr
        query['NatIpCidrName'] = request.nat_ip_cidr_name
        query['NatIpCidrStatus'] = request.nat_ip_cidr_status
        query['NatIpCidrs'] = request.nat_ip_cidrs
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListNatIpCidrs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListNatIpCidrsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_nat_ip_cidrs_with_options_async(
        self,
        request: vpc_20160428_models.ListNatIpCidrsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListNatIpCidrsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['MaxResults'] = request.max_results
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatIpCidr'] = request.nat_ip_cidr
        query['NatIpCidrName'] = request.nat_ip_cidr_name
        query['NatIpCidrStatus'] = request.nat_ip_cidr_status
        query['NatIpCidrs'] = request.nat_ip_cidrs
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListNatIpCidrs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListNatIpCidrsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_nat_ip_cidrs(
        self,
        request: vpc_20160428_models.ListNatIpCidrsRequest,
    ) -> vpc_20160428_models.ListNatIpCidrsResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_nat_ip_cidrs_with_options(request, runtime)

    async def list_nat_ip_cidrs_async(
        self,
        request: vpc_20160428_models.ListNatIpCidrsRequest,
    ) -> vpc_20160428_models.ListNatIpCidrsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_nat_ip_cidrs_with_options_async(request, runtime)

    def list_nat_ips_with_options(
        self,
        request: vpc_20160428_models.ListNatIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListNatIpsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['MaxResults'] = request.max_results
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatIpCidr'] = request.nat_ip_cidr
        query['NatIpIds'] = request.nat_ip_ids
        query['NatIpName'] = request.nat_ip_name
        query['NatIpStatus'] = request.nat_ip_status
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListNatIps',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListNatIpsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_nat_ips_with_options_async(
        self,
        request: vpc_20160428_models.ListNatIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListNatIpsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['MaxResults'] = request.max_results
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatIpCidr'] = request.nat_ip_cidr
        query['NatIpIds'] = request.nat_ip_ids
        query['NatIpName'] = request.nat_ip_name
        query['NatIpStatus'] = request.nat_ip_status
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListNatIps',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListNatIpsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_nat_ips(
        self,
        request: vpc_20160428_models.ListNatIpsRequest,
    ) -> vpc_20160428_models.ListNatIpsResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_nat_ips_with_options(request, runtime)

    async def list_nat_ips_async(
        self,
        request: vpc_20160428_models.ListNatIpsRequest,
    ) -> vpc_20160428_models.ListNatIpsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_nat_ips_with_options_async(request, runtime)

    def list_physical_connection_features_with_options(
        self,
        request: vpc_20160428_models.ListPhysicalConnectionFeaturesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListPhysicalConnectionFeaturesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListPhysicalConnectionFeatures',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListPhysicalConnectionFeaturesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_physical_connection_features_with_options_async(
        self,
        request: vpc_20160428_models.ListPhysicalConnectionFeaturesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListPhysicalConnectionFeaturesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListPhysicalConnectionFeatures',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListPhysicalConnectionFeaturesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_physical_connection_features(
        self,
        request: vpc_20160428_models.ListPhysicalConnectionFeaturesRequest,
    ) -> vpc_20160428_models.ListPhysicalConnectionFeaturesResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_physical_connection_features_with_options(request, runtime)

    async def list_physical_connection_features_async(
        self,
        request: vpc_20160428_models.ListPhysicalConnectionFeaturesRequest,
    ) -> vpc_20160428_models.ListPhysicalConnectionFeaturesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_physical_connection_features_with_options_async(request, runtime)

    def list_prefix_lists_with_options(
        self,
        request: vpc_20160428_models.ListPrefixListsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListPrefixListsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PrefixListIds'] = request.prefix_list_ids
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListPrefixLists',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListPrefixListsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_prefix_lists_with_options_async(
        self,
        request: vpc_20160428_models.ListPrefixListsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListPrefixListsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PrefixListIds'] = request.prefix_list_ids
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListPrefixLists',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListPrefixListsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_prefix_lists(
        self,
        request: vpc_20160428_models.ListPrefixListsRequest,
    ) -> vpc_20160428_models.ListPrefixListsResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_prefix_lists_with_options(request, runtime)

    async def list_prefix_lists_async(
        self,
        request: vpc_20160428_models.ListPrefixListsRequest,
    ) -> vpc_20160428_models.ListPrefixListsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_prefix_lists_with_options_async(request, runtime)

    def list_tag_resources_with_options(
        self,
        request: vpc_20160428_models.ListTagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListTagResourcesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceId'] = request.resource_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ResourceType'] = request.resource_type
        query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListTagResources',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListTagResourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_tag_resources_with_options_async(
        self,
        request: vpc_20160428_models.ListTagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListTagResourcesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceId'] = request.resource_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ResourceType'] = request.resource_type
        query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListTagResources',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListTagResourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_tag_resources(
        self,
        request: vpc_20160428_models.ListTagResourcesRequest,
    ) -> vpc_20160428_models.ListTagResourcesResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_tag_resources_with_options(request, runtime)

    async def list_tag_resources_async(
        self,
        request: vpc_20160428_models.ListTagResourcesRequest,
    ) -> vpc_20160428_models.ListTagResourcesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_tag_resources_with_options_async(request, runtime)

    def list_traffic_mirror_filters_with_options(
        self,
        request: vpc_20160428_models.ListTrafficMirrorFiltersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListTrafficMirrorFiltersResponse:
        UtilClient.validate_model(request)
        query = {}
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterIds'] = request.traffic_mirror_filter_ids
        query['TrafficMirrorFilterName'] = request.traffic_mirror_filter_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListTrafficMirrorFilters',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListTrafficMirrorFiltersResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_traffic_mirror_filters_with_options_async(
        self,
        request: vpc_20160428_models.ListTrafficMirrorFiltersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListTrafficMirrorFiltersResponse:
        UtilClient.validate_model(request)
        query = {}
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterIds'] = request.traffic_mirror_filter_ids
        query['TrafficMirrorFilterName'] = request.traffic_mirror_filter_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListTrafficMirrorFilters',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListTrafficMirrorFiltersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_traffic_mirror_filters(
        self,
        request: vpc_20160428_models.ListTrafficMirrorFiltersRequest,
    ) -> vpc_20160428_models.ListTrafficMirrorFiltersResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_traffic_mirror_filters_with_options(request, runtime)

    async def list_traffic_mirror_filters_async(
        self,
        request: vpc_20160428_models.ListTrafficMirrorFiltersRequest,
    ) -> vpc_20160428_models.ListTrafficMirrorFiltersResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_traffic_mirror_filters_with_options_async(request, runtime)

    def list_traffic_mirror_sessions_with_options(
        self,
        request: vpc_20160428_models.ListTrafficMirrorSessionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListTrafficMirrorSessionsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Enabled'] = request.enabled
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Priority'] = request.priority
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        query['TrafficMirrorSessionIds'] = request.traffic_mirror_session_ids
        query['TrafficMirrorSessionName'] = request.traffic_mirror_session_name
        query['TrafficMirrorSourceId'] = request.traffic_mirror_source_id
        query['TrafficMirrorTargetId'] = request.traffic_mirror_target_id
        query['VirtualNetworkId'] = request.virtual_network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListTrafficMirrorSessions',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListTrafficMirrorSessionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_traffic_mirror_sessions_with_options_async(
        self,
        request: vpc_20160428_models.ListTrafficMirrorSessionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListTrafficMirrorSessionsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Enabled'] = request.enabled
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Priority'] = request.priority
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        query['TrafficMirrorSessionIds'] = request.traffic_mirror_session_ids
        query['TrafficMirrorSessionName'] = request.traffic_mirror_session_name
        query['TrafficMirrorSourceId'] = request.traffic_mirror_source_id
        query['TrafficMirrorTargetId'] = request.traffic_mirror_target_id
        query['VirtualNetworkId'] = request.virtual_network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListTrafficMirrorSessions',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListTrafficMirrorSessionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_traffic_mirror_sessions(
        self,
        request: vpc_20160428_models.ListTrafficMirrorSessionsRequest,
    ) -> vpc_20160428_models.ListTrafficMirrorSessionsResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_traffic_mirror_sessions_with_options(request, runtime)

    async def list_traffic_mirror_sessions_async(
        self,
        request: vpc_20160428_models.ListTrafficMirrorSessionsRequest,
    ) -> vpc_20160428_models.ListTrafficMirrorSessionsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_traffic_mirror_sessions_with_options_async(request, runtime)

    def list_virtual_physical_connections_with_options(
        self,
        request: vpc_20160428_models.ListVirtualPhysicalConnectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListVirtualPhysicalConnectionsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['IsConfirmed'] = request.is_confirmed
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['VirtualPhysicalConnectionAliUids'] = request.virtual_physical_connection_ali_uids
        query['VirtualPhysicalConnectionBusinessStatus'] = request.virtual_physical_connection_business_status
        query['VirtualPhysicalConnectionIds'] = request.virtual_physical_connection_ids
        query['VirtualPhysicalConnectionStatuses'] = request.virtual_physical_connection_statuses
        query['VlanIds'] = request.vlan_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListVirtualPhysicalConnections',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListVirtualPhysicalConnectionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_virtual_physical_connections_with_options_async(
        self,
        request: vpc_20160428_models.ListVirtualPhysicalConnectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListVirtualPhysicalConnectionsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['IsConfirmed'] = request.is_confirmed
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['RegionId'] = request.region_id
        query['VirtualPhysicalConnectionAliUids'] = request.virtual_physical_connection_ali_uids
        query['VirtualPhysicalConnectionBusinessStatus'] = request.virtual_physical_connection_business_status
        query['VirtualPhysicalConnectionIds'] = request.virtual_physical_connection_ids
        query['VirtualPhysicalConnectionStatuses'] = request.virtual_physical_connection_statuses
        query['VlanIds'] = request.vlan_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListVirtualPhysicalConnections',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListVirtualPhysicalConnectionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_virtual_physical_connections(
        self,
        request: vpc_20160428_models.ListVirtualPhysicalConnectionsRequest,
    ) -> vpc_20160428_models.ListVirtualPhysicalConnectionsResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_virtual_physical_connections_with_options(request, runtime)

    async def list_virtual_physical_connections_async(
        self,
        request: vpc_20160428_models.ListVirtualPhysicalConnectionsRequest,
    ) -> vpc_20160428_models.ListVirtualPhysicalConnectionsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_virtual_physical_connections_with_options_async(request, runtime)

    def list_vpc_endpoint_services_by_end_user_with_options(
        self,
        request: vpc_20160428_models.ListVpcEndpointServicesByEndUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListVpcEndpointServicesByEndUserResponse:
        UtilClient.validate_model(request)
        query = {}
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListVpcEndpointServicesByEndUser',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListVpcEndpointServicesByEndUserResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_vpc_endpoint_services_by_end_user_with_options_async(
        self,
        request: vpc_20160428_models.ListVpcEndpointServicesByEndUserRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListVpcEndpointServicesByEndUserResponse:
        UtilClient.validate_model(request)
        query = {}
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListVpcEndpointServicesByEndUser',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListVpcEndpointServicesByEndUserResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_vpc_endpoint_services_by_end_user(
        self,
        request: vpc_20160428_models.ListVpcEndpointServicesByEndUserRequest,
    ) -> vpc_20160428_models.ListVpcEndpointServicesByEndUserResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_vpc_endpoint_services_by_end_user_with_options(request, runtime)

    async def list_vpc_endpoint_services_by_end_user_async(
        self,
        request: vpc_20160428_models.ListVpcEndpointServicesByEndUserRequest,
    ) -> vpc_20160428_models.ListVpcEndpointServicesByEndUserResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_vpc_endpoint_services_by_end_user_with_options_async(request, runtime)

    def list_vpc_gateway_endpoints_with_options(
        self,
        request: vpc_20160428_models.ListVpcGatewayEndpointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListVpcGatewayEndpointsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['EndpointId'] = request.endpoint_id
        query['EndpointName'] = request.endpoint_name
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListVpcGatewayEndpoints',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListVpcGatewayEndpointsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_vpc_gateway_endpoints_with_options_async(
        self,
        request: vpc_20160428_models.ListVpcGatewayEndpointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListVpcGatewayEndpointsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['EndpointId'] = request.endpoint_id
        query['EndpointName'] = request.endpoint_name
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListVpcGatewayEndpoints',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListVpcGatewayEndpointsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_vpc_gateway_endpoints(
        self,
        request: vpc_20160428_models.ListVpcGatewayEndpointsRequest,
    ) -> vpc_20160428_models.ListVpcGatewayEndpointsResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_vpc_gateway_endpoints_with_options(request, runtime)

    async def list_vpc_gateway_endpoints_async(
        self,
        request: vpc_20160428_models.ListVpcGatewayEndpointsRequest,
    ) -> vpc_20160428_models.ListVpcGatewayEndpointsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_vpc_gateway_endpoints_with_options_async(request, runtime)

    def list_vpn_certificate_associations_with_options(
        self,
        request: vpc_20160428_models.ListVpnCertificateAssociationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListVpnCertificateAssociationsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CertificateId'] = request.certificate_id
        query['CertificateType'] = request.certificate_type
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['RegionId'] = request.region_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListVpnCertificateAssociations',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListVpnCertificateAssociationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_vpn_certificate_associations_with_options_async(
        self,
        request: vpc_20160428_models.ListVpnCertificateAssociationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ListVpnCertificateAssociationsResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CertificateId'] = request.certificate_id
        query['CertificateType'] = request.certificate_type
        query['MaxResults'] = request.max_results
        query['NextToken'] = request.next_token
        query['RegionId'] = request.region_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ListVpnCertificateAssociations',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ListVpnCertificateAssociationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_vpn_certificate_associations(
        self,
        request: vpc_20160428_models.ListVpnCertificateAssociationsRequest,
    ) -> vpc_20160428_models.ListVpnCertificateAssociationsResponse:
        runtime = util_models.RuntimeOptions()
        return self.list_vpn_certificate_associations_with_options(request, runtime)

    async def list_vpn_certificate_associations_async(
        self,
        request: vpc_20160428_models.ListVpnCertificateAssociationsRequest,
    ) -> vpc_20160428_models.ListVpnCertificateAssociationsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.list_vpn_certificate_associations_with_options_async(request, runtime)

    def modify_bgp_group_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyBgpGroupAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyBgpGroupAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AuthKey'] = request.auth_key
        query['BgpGroupId'] = request.bgp_group_id
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['IsFakeAsn'] = request.is_fake_asn
        query['LocalAsn'] = request.local_asn
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerAsn'] = request.peer_asn
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyBgpGroupAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyBgpGroupAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_bgp_group_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyBgpGroupAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyBgpGroupAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AuthKey'] = request.auth_key
        query['BgpGroupId'] = request.bgp_group_id
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['IsFakeAsn'] = request.is_fake_asn
        query['LocalAsn'] = request.local_asn
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerAsn'] = request.peer_asn
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyBgpGroupAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyBgpGroupAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_bgp_group_attribute(
        self,
        request: vpc_20160428_models.ModifyBgpGroupAttributeRequest,
    ) -> vpc_20160428_models.ModifyBgpGroupAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_bgp_group_attribute_with_options(request, runtime)

    async def modify_bgp_group_attribute_async(
        self,
        request: vpc_20160428_models.ModifyBgpGroupAttributeRequest,
    ) -> vpc_20160428_models.ModifyBgpGroupAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_bgp_group_attribute_with_options_async(request, runtime)

    def modify_bgp_peer_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyBgpPeerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyBgpPeerAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BfdMultiHop'] = request.bfd_multi_hop
        query['BgpGroupId'] = request.bgp_group_id
        query['BgpPeerId'] = request.bgp_peer_id
        query['ClientToken'] = request.client_token
        query['EnableBfd'] = request.enable_bfd
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerIpAddress'] = request.peer_ip_address
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyBgpPeerAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyBgpPeerAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_bgp_peer_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyBgpPeerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyBgpPeerAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BfdMultiHop'] = request.bfd_multi_hop
        query['BgpGroupId'] = request.bgp_group_id
        query['BgpPeerId'] = request.bgp_peer_id
        query['ClientToken'] = request.client_token
        query['EnableBfd'] = request.enable_bfd
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerIpAddress'] = request.peer_ip_address
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyBgpPeerAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyBgpPeerAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_bgp_peer_attribute(
        self,
        request: vpc_20160428_models.ModifyBgpPeerAttributeRequest,
    ) -> vpc_20160428_models.ModifyBgpPeerAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_bgp_peer_attribute_with_options(request, runtime)

    async def modify_bgp_peer_attribute_async(
        self,
        request: vpc_20160428_models.ModifyBgpPeerAttributeRequest,
    ) -> vpc_20160428_models.ModifyBgpPeerAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_bgp_peer_attribute_with_options_async(request, runtime)

    def modify_common_bandwidth_package_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['Description'] = request.description
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyCommonBandwidthPackageAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyCommonBandwidthPackageAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_common_bandwidth_package_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['Description'] = request.description
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyCommonBandwidthPackageAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyCommonBandwidthPackageAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_common_bandwidth_package_attribute(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageAttributeRequest,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_common_bandwidth_package_attribute_with_options(request, runtime)

    async def modify_common_bandwidth_package_attribute_async(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageAttributeRequest,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_common_bandwidth_package_attribute_with_options_async(request, runtime)

    def modify_common_bandwidth_package_internet_charge_type_with_options(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageInternetChargeTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageInternetChargeTypeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['InstanceChargeType'] = request.instance_charge_type
        query['InternetChargeType'] = request.internet_charge_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Ratio'] = request.ratio
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyCommonBandwidthPackageInternetChargeType',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyCommonBandwidthPackageInternetChargeTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_common_bandwidth_package_internet_charge_type_with_options_async(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageInternetChargeTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageInternetChargeTypeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['InstanceChargeType'] = request.instance_charge_type
        query['InternetChargeType'] = request.internet_charge_type
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Ratio'] = request.ratio
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyCommonBandwidthPackageInternetChargeType',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyCommonBandwidthPackageInternetChargeTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_common_bandwidth_package_internet_charge_type(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageInternetChargeTypeRequest,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageInternetChargeTypeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_common_bandwidth_package_internet_charge_type_with_options(request, runtime)

    async def modify_common_bandwidth_package_internet_charge_type_async(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageInternetChargeTypeRequest,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageInternetChargeTypeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_common_bandwidth_package_internet_charge_type_with_options_async(request, runtime)

    def modify_common_bandwidth_package_ip_bandwidth_with_options(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageIpBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageIpBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['EipId'] = request.eip_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyCommonBandwidthPackageIpBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyCommonBandwidthPackageIpBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_common_bandwidth_package_ip_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageIpBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageIpBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['EipId'] = request.eip_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyCommonBandwidthPackageIpBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyCommonBandwidthPackageIpBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_common_bandwidth_package_ip_bandwidth(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageIpBandwidthRequest,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageIpBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_common_bandwidth_package_ip_bandwidth_with_options(request, runtime)

    async def modify_common_bandwidth_package_ip_bandwidth_async(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageIpBandwidthRequest,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageIpBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_common_bandwidth_package_ip_bandwidth_with_options_async(request, runtime)

    def modify_common_bandwidth_package_pay_type_with_options(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackagePayTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackagePayTypeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['Duration'] = request.duration
        query['KbpsBandwidth'] = request.kbps_bandwidth
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PayType'] = request.pay_type
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceBid'] = request.resource_bid
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ResourceUid'] = request.resource_uid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyCommonBandwidthPackagePayType',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyCommonBandwidthPackagePayTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_common_bandwidth_package_pay_type_with_options_async(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackagePayTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackagePayTypeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['Duration'] = request.duration
        query['KbpsBandwidth'] = request.kbps_bandwidth
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PayType'] = request.pay_type
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['ResourceBid'] = request.resource_bid
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ResourceUid'] = request.resource_uid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyCommonBandwidthPackagePayType',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyCommonBandwidthPackagePayTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_common_bandwidth_package_pay_type(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackagePayTypeRequest,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackagePayTypeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_common_bandwidth_package_pay_type_with_options(request, runtime)

    async def modify_common_bandwidth_package_pay_type_async(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackagePayTypeRequest,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackagePayTypeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_common_bandwidth_package_pay_type_with_options_async(request, runtime)

    def modify_common_bandwidth_package_spec_with_options(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageSpecResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyCommonBandwidthPackageSpec',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyCommonBandwidthPackageSpecResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_common_bandwidth_package_spec_with_options_async(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageSpecResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['BandwidthPackageId'] = request.bandwidth_package_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyCommonBandwidthPackageSpec',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyCommonBandwidthPackageSpecResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_common_bandwidth_package_spec(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageSpecRequest,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageSpecResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_common_bandwidth_package_spec_with_options(request, runtime)

    async def modify_common_bandwidth_package_spec_async(
        self,
        request: vpc_20160428_models.ModifyCommonBandwidthPackageSpecRequest,
    ) -> vpc_20160428_models.ModifyCommonBandwidthPackageSpecResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_common_bandwidth_package_spec_with_options_async(request, runtime)

    def modify_customer_gateway_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyCustomerGatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyCustomerGatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AuthKey'] = request.auth_key
        query['ClientToken'] = request.client_token
        query['CustomerGatewayId'] = request.customer_gateway_id
        query['Description'] = request.description
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyCustomerGatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyCustomerGatewayAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_customer_gateway_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyCustomerGatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyCustomerGatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AuthKey'] = request.auth_key
        query['ClientToken'] = request.client_token
        query['CustomerGatewayId'] = request.customer_gateway_id
        query['Description'] = request.description
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyCustomerGatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyCustomerGatewayAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_customer_gateway_attribute(
        self,
        request: vpc_20160428_models.ModifyCustomerGatewayAttributeRequest,
    ) -> vpc_20160428_models.ModifyCustomerGatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_customer_gateway_attribute_with_options(request, runtime)

    async def modify_customer_gateway_attribute_async(
        self,
        request: vpc_20160428_models.ModifyCustomerGatewayAttributeRequest,
    ) -> vpc_20160428_models.ModifyCustomerGatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_customer_gateway_attribute_with_options_async(request, runtime)

    def modify_eip_address_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyEipAddressAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyEipAddressAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AllocationId'] = request.allocation_id
        query['Bandwidth'] = request.bandwidth
        query['Description'] = request.description
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyEipAddressAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyEipAddressAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_eip_address_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyEipAddressAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyEipAddressAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AllocationId'] = request.allocation_id
        query['Bandwidth'] = request.bandwidth
        query['Description'] = request.description
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyEipAddressAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyEipAddressAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_eip_address_attribute(
        self,
        request: vpc_20160428_models.ModifyEipAddressAttributeRequest,
    ) -> vpc_20160428_models.ModifyEipAddressAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_eip_address_attribute_with_options(request, runtime)

    async def modify_eip_address_attribute_async(
        self,
        request: vpc_20160428_models.ModifyEipAddressAttributeRequest,
    ) -> vpc_20160428_models.ModifyEipAddressAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_eip_address_attribute_with_options_async(request, runtime)

    def modify_express_cloud_connection_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyExpressCloudConnectionAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyExpressCloudConnectionAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BgpAs'] = request.bgp_as
        query['CeIp'] = request.ce_ip
        query['Description'] = request.description
        query['EccId'] = request.ecc_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeIp'] = request.pe_ip
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyExpressCloudConnectionAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyExpressCloudConnectionAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_express_cloud_connection_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyExpressCloudConnectionAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyExpressCloudConnectionAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['BgpAs'] = request.bgp_as
        query['CeIp'] = request.ce_ip
        query['Description'] = request.description
        query['EccId'] = request.ecc_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeIp'] = request.pe_ip
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyExpressCloudConnectionAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyExpressCloudConnectionAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_express_cloud_connection_attribute(
        self,
        request: vpc_20160428_models.ModifyExpressCloudConnectionAttributeRequest,
    ) -> vpc_20160428_models.ModifyExpressCloudConnectionAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_express_cloud_connection_attribute_with_options(request, runtime)

    async def modify_express_cloud_connection_attribute_async(
        self,
        request: vpc_20160428_models.ModifyExpressCloudConnectionAttributeRequest,
    ) -> vpc_20160428_models.ModifyExpressCloudConnectionAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_express_cloud_connection_attribute_with_options_async(request, runtime)

    def modify_express_cloud_connection_bandwidth_with_options(
        self,
        request: vpc_20160428_models.ModifyExpressCloudConnectionBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyExpressCloudConnectionBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['EccId'] = request.ecc_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyExpressCloudConnectionBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyExpressCloudConnectionBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_express_cloud_connection_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.ModifyExpressCloudConnectionBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyExpressCloudConnectionBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['EccId'] = request.ecc_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyExpressCloudConnectionBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyExpressCloudConnectionBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_express_cloud_connection_bandwidth(
        self,
        request: vpc_20160428_models.ModifyExpressCloudConnectionBandwidthRequest,
    ) -> vpc_20160428_models.ModifyExpressCloudConnectionBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_express_cloud_connection_bandwidth_with_options(request, runtime)

    async def modify_express_cloud_connection_bandwidth_async(
        self,
        request: vpc_20160428_models.ModifyExpressCloudConnectionBandwidthRequest,
    ) -> vpc_20160428_models.ModifyExpressCloudConnectionBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_express_cloud_connection_bandwidth_with_options_async(request, runtime)

    def modify_flow_log_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyFlowLogAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyFlowLogAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['FlowLogId'] = request.flow_log_id
        query['FlowLogName'] = request.flow_log_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyFlowLogAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyFlowLogAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_flow_log_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyFlowLogAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyFlowLogAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['FlowLogId'] = request.flow_log_id
        query['FlowLogName'] = request.flow_log_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyFlowLogAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyFlowLogAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_flow_log_attribute(
        self,
        request: vpc_20160428_models.ModifyFlowLogAttributeRequest,
    ) -> vpc_20160428_models.ModifyFlowLogAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_flow_log_attribute_with_options(request, runtime)

    async def modify_flow_log_attribute_async(
        self,
        request: vpc_20160428_models.ModifyFlowLogAttributeRequest,
    ) -> vpc_20160428_models.ModifyFlowLogAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_flow_log_attribute_with_options_async(request, runtime)

    def modify_forward_entry_with_options(
        self,
        request: vpc_20160428_models.ModifyForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyForwardEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['ExternalIp'] = request.external_ip
        query['ExternalPort'] = request.external_port
        query['ForwardEntryId'] = request.forward_entry_id
        query['ForwardEntryName'] = request.forward_entry_name
        query['ForwardTableId'] = request.forward_table_id
        query['InternalIp'] = request.internal_ip
        query['InternalPort'] = request.internal_port
        query['IpProtocol'] = request.ip_protocol
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PortBreak'] = request.port_break
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_forward_entry_with_options_async(
        self,
        request: vpc_20160428_models.ModifyForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyForwardEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['ExternalIp'] = request.external_ip
        query['ExternalPort'] = request.external_port
        query['ForwardEntryId'] = request.forward_entry_id
        query['ForwardEntryName'] = request.forward_entry_name
        query['ForwardTableId'] = request.forward_table_id
        query['InternalIp'] = request.internal_ip
        query['InternalPort'] = request.internal_port
        query['IpProtocol'] = request.ip_protocol
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PortBreak'] = request.port_break
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_forward_entry(
        self,
        request: vpc_20160428_models.ModifyForwardEntryRequest,
    ) -> vpc_20160428_models.ModifyForwardEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_forward_entry_with_options(request, runtime)

    async def modify_forward_entry_async(
        self,
        request: vpc_20160428_models.ModifyForwardEntryRequest,
    ) -> vpc_20160428_models.ModifyForwardEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_forward_entry_with_options_async(request, runtime)

    def modify_full_nat_entry_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyFullNatEntryAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyFullNatEntryAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AccessIp'] = request.access_ip
        query['AccessPort'] = request.access_port
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['FullNatEntryDescription'] = request.full_nat_entry_description
        query['FullNatEntryId'] = request.full_nat_entry_id
        query['FullNatEntryName'] = request.full_nat_entry_name
        query['FullNatTableId'] = request.full_nat_table_id
        query['IpProtocol'] = request.ip_protocol
        query['NatIp'] = request.nat_ip
        query['NatIpPort'] = request.nat_ip_port
        query['NetworkInterfaceId'] = request.network_interface_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyFullNatEntryAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyFullNatEntryAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_full_nat_entry_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyFullNatEntryAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyFullNatEntryAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AccessIp'] = request.access_ip
        query['AccessPort'] = request.access_port
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['FullNatEntryDescription'] = request.full_nat_entry_description
        query['FullNatEntryId'] = request.full_nat_entry_id
        query['FullNatEntryName'] = request.full_nat_entry_name
        query['FullNatTableId'] = request.full_nat_table_id
        query['IpProtocol'] = request.ip_protocol
        query['NatIp'] = request.nat_ip
        query['NatIpPort'] = request.nat_ip_port
        query['NetworkInterfaceId'] = request.network_interface_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyFullNatEntryAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyFullNatEntryAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_full_nat_entry_attribute(
        self,
        request: vpc_20160428_models.ModifyFullNatEntryAttributeRequest,
    ) -> vpc_20160428_models.ModifyFullNatEntryAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_full_nat_entry_attribute_with_options(request, runtime)

    async def modify_full_nat_entry_attribute_async(
        self,
        request: vpc_20160428_models.ModifyFullNatEntryAttributeRequest,
    ) -> vpc_20160428_models.ModifyFullNatEntryAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_full_nat_entry_attribute_with_options_async(request, runtime)

    def modify_global_acceleration_instance_attributes_with_options(
        self,
        request: vpc_20160428_models.ModifyGlobalAccelerationInstanceAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyGlobalAccelerationInstanceAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyGlobalAccelerationInstanceAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyGlobalAccelerationInstanceAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_global_acceleration_instance_attributes_with_options_async(
        self,
        request: vpc_20160428_models.ModifyGlobalAccelerationInstanceAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyGlobalAccelerationInstanceAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyGlobalAccelerationInstanceAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyGlobalAccelerationInstanceAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_global_acceleration_instance_attributes(
        self,
        request: vpc_20160428_models.ModifyGlobalAccelerationInstanceAttributesRequest,
    ) -> vpc_20160428_models.ModifyGlobalAccelerationInstanceAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_global_acceleration_instance_attributes_with_options(request, runtime)

    async def modify_global_acceleration_instance_attributes_async(
        self,
        request: vpc_20160428_models.ModifyGlobalAccelerationInstanceAttributesRequest,
    ) -> vpc_20160428_models.ModifyGlobalAccelerationInstanceAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_global_acceleration_instance_attributes_with_options_async(request, runtime)

    def modify_global_acceleration_instance_spec_with_options(
        self,
        request: vpc_20160428_models.ModifyGlobalAccelerationInstanceSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyGlobalAccelerationInstanceSpecResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyGlobalAccelerationInstanceSpec',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyGlobalAccelerationInstanceSpecResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_global_acceleration_instance_spec_with_options_async(
        self,
        request: vpc_20160428_models.ModifyGlobalAccelerationInstanceSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyGlobalAccelerationInstanceSpecResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyGlobalAccelerationInstanceSpec',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyGlobalAccelerationInstanceSpecResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_global_acceleration_instance_spec(
        self,
        request: vpc_20160428_models.ModifyGlobalAccelerationInstanceSpecRequest,
    ) -> vpc_20160428_models.ModifyGlobalAccelerationInstanceSpecResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_global_acceleration_instance_spec_with_options(request, runtime)

    async def modify_global_acceleration_instance_spec_async(
        self,
        request: vpc_20160428_models.ModifyGlobalAccelerationInstanceSpecRequest,
    ) -> vpc_20160428_models.ModifyGlobalAccelerationInstanceSpecResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_global_acceleration_instance_spec_with_options_async(request, runtime)

    def modify_ha_vip_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyHaVipAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyHaVipAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['HaVipId'] = request.ha_vip_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyHaVipAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyHaVipAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ha_vip_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyHaVipAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyHaVipAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['HaVipId'] = request.ha_vip_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyHaVipAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyHaVipAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ha_vip_attribute(
        self,
        request: vpc_20160428_models.ModifyHaVipAttributeRequest,
    ) -> vpc_20160428_models.ModifyHaVipAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_ha_vip_attribute_with_options(request, runtime)

    async def modify_ha_vip_attribute_async(
        self,
        request: vpc_20160428_models.ModifyHaVipAttributeRequest,
    ) -> vpc_20160428_models.ModifyHaVipAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_ha_vip_attribute_with_options_async(request, runtime)

    def modify_ipv_6translator_acl_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorAclAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorAclAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['AclName'] = request.acl_name
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIPv6TranslatorAclAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIPv6TranslatorAclAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ipv_6translator_acl_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorAclAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorAclAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['AclName'] = request.acl_name
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIPv6TranslatorAclAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIPv6TranslatorAclAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ipv_6translator_acl_attribute(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorAclAttributeRequest,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorAclAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_ipv_6translator_acl_attribute_with_options(request, runtime)

    async def modify_ipv_6translator_acl_attribute_async(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorAclAttributeRequest,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorAclAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_ipv_6translator_acl_attribute_with_options_async(request, runtime)

    def modify_ipv_6translator_acl_list_entry_with_options(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorAclListEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorAclListEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclEntryComment'] = request.acl_entry_comment
        query['AclEntryId'] = request.acl_entry_id
        query['AclId'] = request.acl_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIPv6TranslatorAclListEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIPv6TranslatorAclListEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ipv_6translator_acl_list_entry_with_options_async(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorAclListEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorAclListEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclEntryComment'] = request.acl_entry_comment
        query['AclEntryId'] = request.acl_entry_id
        query['AclId'] = request.acl_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIPv6TranslatorAclListEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIPv6TranslatorAclListEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ipv_6translator_acl_list_entry(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorAclListEntryRequest,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorAclListEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_ipv_6translator_acl_list_entry_with_options(request, runtime)

    async def modify_ipv_6translator_acl_list_entry_async(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorAclListEntryRequest,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorAclListEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_ipv_6translator_acl_list_entry_with_options_async(request, runtime)

    def modify_ipv_6translator_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIPv6TranslatorAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIPv6TranslatorAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ipv_6translator_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIPv6TranslatorAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIPv6TranslatorAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ipv_6translator_attribute(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorAttributeRequest,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_ipv_6translator_attribute_with_options(request, runtime)

    async def modify_ipv_6translator_attribute_async(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorAttributeRequest,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_ipv_6translator_attribute_with_options_async(request, runtime)

    def modify_ipv_6translator_bandwidth_with_options(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIPv6TranslatorBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIPv6TranslatorBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ipv_6translator_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['Ipv6TranslatorId'] = request.ipv_6translator_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIPv6TranslatorBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIPv6TranslatorBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ipv_6translator_bandwidth(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorBandwidthRequest,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_ipv_6translator_bandwidth_with_options(request, runtime)

    async def modify_ipv_6translator_bandwidth_async(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorBandwidthRequest,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_ipv_6translator_bandwidth_with_options_async(request, runtime)

    def modify_ipv_6translator_entry_with_options(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['AclStatus'] = request.acl_status
        query['AclType'] = request.acl_type
        query['AllocateIpv6Port'] = request.allocate_ipv_6port
        query['BackendIpv4Addr'] = request.backend_ipv_4addr
        query['BackendIpv4Port'] = request.backend_ipv_4port
        query['EntryBandwidth'] = request.entry_bandwidth
        query['EntryDescription'] = request.entry_description
        query['EntryName'] = request.entry_name
        query['Ipv6TranslatorEntryId'] = request.ipv_6translator_entry_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TransProtocol'] = request.trans_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIPv6TranslatorEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ipv_6translator_entry_with_options_async(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AclId'] = request.acl_id
        query['AclStatus'] = request.acl_status
        query['AclType'] = request.acl_type
        query['AllocateIpv6Port'] = request.allocate_ipv_6port
        query['BackendIpv4Addr'] = request.backend_ipv_4addr
        query['BackendIpv4Port'] = request.backend_ipv_4port
        query['EntryBandwidth'] = request.entry_bandwidth
        query['EntryDescription'] = request.entry_description
        query['EntryName'] = request.entry_name
        query['Ipv6TranslatorEntryId'] = request.ipv_6translator_entry_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['TransProtocol'] = request.trans_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIPv6TranslatorEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ipv_6translator_entry(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_ipv_6translator_entry_with_options(request, runtime)

    async def modify_ipv_6translator_entry_async(
        self,
        request: vpc_20160428_models.ModifyIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.ModifyIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_ipv_6translator_entry_with_options_async(request, runtime)

    def modify_instance_auto_renewal_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyInstanceAutoRenewalAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyInstanceAutoRenewalAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Duration'] = request.duration
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['OwnerId'] = request.owner_id
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['RenewalStatus'] = request.renewal_status
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyInstanceAutoRenewalAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyInstanceAutoRenewalAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_instance_auto_renewal_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyInstanceAutoRenewalAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyInstanceAutoRenewalAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Duration'] = request.duration
        query['InstanceId'] = request.instance_id
        query['InstanceType'] = request.instance_type
        query['OwnerId'] = request.owner_id
        query['PricingCycle'] = request.pricing_cycle
        query['RegionId'] = request.region_id
        query['RenewalStatus'] = request.renewal_status
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyInstanceAutoRenewalAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyInstanceAutoRenewalAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_instance_auto_renewal_attribute(
        self,
        request: vpc_20160428_models.ModifyInstanceAutoRenewalAttributeRequest,
    ) -> vpc_20160428_models.ModifyInstanceAutoRenewalAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_instance_auto_renewal_attribute_with_options(request, runtime)

    async def modify_instance_auto_renewal_attribute_async(
        self,
        request: vpc_20160428_models.ModifyInstanceAutoRenewalAttributeRequest,
    ) -> vpc_20160428_models.ModifyInstanceAutoRenewalAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_instance_auto_renewal_attribute_with_options_async(request, runtime)

    def modify_ipv_6address_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyIpv6AddressAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIpv6AddressAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['Ipv6AddressId'] = request.ipv_6address_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIpv6AddressAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIpv6AddressAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ipv_6address_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyIpv6AddressAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIpv6AddressAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['Ipv6AddressId'] = request.ipv_6address_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIpv6AddressAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIpv6AddressAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ipv_6address_attribute(
        self,
        request: vpc_20160428_models.ModifyIpv6AddressAttributeRequest,
    ) -> vpc_20160428_models.ModifyIpv6AddressAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_ipv_6address_attribute_with_options(request, runtime)

    async def modify_ipv_6address_attribute_async(
        self,
        request: vpc_20160428_models.ModifyIpv6AddressAttributeRequest,
    ) -> vpc_20160428_models.ModifyIpv6AddressAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_ipv_6address_attribute_with_options_async(request, runtime)

    def modify_ipv_6gateway_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyIpv6GatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIpv6GatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIpv6GatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIpv6GatewayAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ipv_6gateway_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyIpv6GatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIpv6GatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIpv6GatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIpv6GatewayAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ipv_6gateway_attribute(
        self,
        request: vpc_20160428_models.ModifyIpv6GatewayAttributeRequest,
    ) -> vpc_20160428_models.ModifyIpv6GatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_ipv_6gateway_attribute_with_options(request, runtime)

    async def modify_ipv_6gateway_attribute_async(
        self,
        request: vpc_20160428_models.ModifyIpv6GatewayAttributeRequest,
    ) -> vpc_20160428_models.ModifyIpv6GatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_ipv_6gateway_attribute_with_options_async(request, runtime)

    def modify_ipv_6gateway_spec_with_options(
        self,
        request: vpc_20160428_models.ModifyIpv6GatewaySpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIpv6GatewaySpecResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIpv6GatewaySpec',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIpv6GatewaySpecResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ipv_6gateway_spec_with_options_async(
        self,
        request: vpc_20160428_models.ModifyIpv6GatewaySpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIpv6GatewaySpecResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Ipv6GatewayId'] = request.ipv_6gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIpv6GatewaySpec',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIpv6GatewaySpecResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ipv_6gateway_spec(
        self,
        request: vpc_20160428_models.ModifyIpv6GatewaySpecRequest,
    ) -> vpc_20160428_models.ModifyIpv6GatewaySpecResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_ipv_6gateway_spec_with_options(request, runtime)

    async def modify_ipv_6gateway_spec_async(
        self,
        request: vpc_20160428_models.ModifyIpv6GatewaySpecRequest,
    ) -> vpc_20160428_models.ModifyIpv6GatewaySpecResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_ipv_6gateway_spec_with_options_async(request, runtime)

    def modify_ipv_6internet_bandwidth_with_options(
        self,
        request: vpc_20160428_models.ModifyIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIpv6InternetBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['Ipv6AddressId'] = request.ipv_6address_id
        query['Ipv6InternetBandwidthId'] = request.ipv_6internet_bandwidth_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIpv6InternetBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ipv_6internet_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.ModifyIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyIpv6InternetBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Bandwidth'] = request.bandwidth
        query['ClientToken'] = request.client_token
        query['Ipv6AddressId'] = request.ipv_6address_id
        query['Ipv6InternetBandwidthId'] = request.ipv_6internet_bandwidth_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyIpv6InternetBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ipv_6internet_bandwidth(
        self,
        request: vpc_20160428_models.ModifyIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.ModifyIpv6InternetBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_ipv_6internet_bandwidth_with_options(request, runtime)

    async def modify_ipv_6internet_bandwidth_async(
        self,
        request: vpc_20160428_models.ModifyIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.ModifyIpv6InternetBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_ipv_6internet_bandwidth_with_options_async(request, runtime)

    def modify_nat_gateway_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyNatGatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyNatGatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['IcmpReplyEnabled'] = request.icmp_reply_enabled
        query['Name'] = request.name
        query['NatGatewayId'] = request.nat_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyNatGatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyNatGatewayAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_nat_gateway_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyNatGatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyNatGatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['IcmpReplyEnabled'] = request.icmp_reply_enabled
        query['Name'] = request.name
        query['NatGatewayId'] = request.nat_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyNatGatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyNatGatewayAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_nat_gateway_attribute(
        self,
        request: vpc_20160428_models.ModifyNatGatewayAttributeRequest,
    ) -> vpc_20160428_models.ModifyNatGatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_nat_gateway_attribute_with_options(request, runtime)

    async def modify_nat_gateway_attribute_async(
        self,
        request: vpc_20160428_models.ModifyNatGatewayAttributeRequest,
    ) -> vpc_20160428_models.ModifyNatGatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_nat_gateway_attribute_with_options_async(request, runtime)

    def modify_nat_gateway_spec_with_options(
        self,
        request: vpc_20160428_models.ModifyNatGatewaySpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyNatGatewaySpecResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['ClientToken'] = request.client_token
        query['NatGatewayId'] = request.nat_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyNatGatewaySpec',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyNatGatewaySpecResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_nat_gateway_spec_with_options_async(
        self,
        request: vpc_20160428_models.ModifyNatGatewaySpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyNatGatewaySpecResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPay'] = request.auto_pay
        query['ClientToken'] = request.client_token
        query['NatGatewayId'] = request.nat_gateway_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyNatGatewaySpec',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyNatGatewaySpecResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_nat_gateway_spec(
        self,
        request: vpc_20160428_models.ModifyNatGatewaySpecRequest,
    ) -> vpc_20160428_models.ModifyNatGatewaySpecResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_nat_gateway_spec_with_options(request, runtime)

    async def modify_nat_gateway_spec_async(
        self,
        request: vpc_20160428_models.ModifyNatGatewaySpecRequest,
    ) -> vpc_20160428_models.ModifyNatGatewaySpecResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_nat_gateway_spec_with_options_async(request, runtime)

    def modify_nat_ip_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyNatIpAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyNatIpAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['NatIpDescription'] = request.nat_ip_description
        query['NatIpId'] = request.nat_ip_id
        query['NatIpName'] = request.nat_ip_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyNatIpAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyNatIpAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_nat_ip_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyNatIpAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyNatIpAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['NatIpDescription'] = request.nat_ip_description
        query['NatIpId'] = request.nat_ip_id
        query['NatIpName'] = request.nat_ip_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyNatIpAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyNatIpAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_nat_ip_attribute(
        self,
        request: vpc_20160428_models.ModifyNatIpAttributeRequest,
    ) -> vpc_20160428_models.ModifyNatIpAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_nat_ip_attribute_with_options(request, runtime)

    async def modify_nat_ip_attribute_async(
        self,
        request: vpc_20160428_models.ModifyNatIpAttributeRequest,
    ) -> vpc_20160428_models.ModifyNatIpAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_nat_ip_attribute_with_options_async(request, runtime)

    def modify_nat_ip_cidr_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyNatIpCidrAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyNatIpCidrAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatIpCidr'] = request.nat_ip_cidr
        query['NatIpCidrDescription'] = request.nat_ip_cidr_description
        query['NatIpCidrName'] = request.nat_ip_cidr_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyNatIpCidrAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyNatIpCidrAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_nat_ip_cidr_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyNatIpCidrAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyNatIpCidrAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['DryRun'] = request.dry_run
        query['NatGatewayId'] = request.nat_gateway_id
        query['NatIpCidr'] = request.nat_ip_cidr
        query['NatIpCidrDescription'] = request.nat_ip_cidr_description
        query['NatIpCidrName'] = request.nat_ip_cidr_name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyNatIpCidrAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyNatIpCidrAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_nat_ip_cidr_attribute(
        self,
        request: vpc_20160428_models.ModifyNatIpCidrAttributeRequest,
    ) -> vpc_20160428_models.ModifyNatIpCidrAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_nat_ip_cidr_attribute_with_options(request, runtime)

    async def modify_nat_ip_cidr_attribute_async(
        self,
        request: vpc_20160428_models.ModifyNatIpCidrAttributeRequest,
    ) -> vpc_20160428_models.ModifyNatIpCidrAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_nat_ip_cidr_attribute_with_options_async(request, runtime)

    def modify_network_acl_attributes_with_options(
        self,
        request: vpc_20160428_models.ModifyNetworkAclAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyNetworkAclAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['NetworkAclId'] = request.network_acl_id
        query['NetworkAclName'] = request.network_acl_name
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyNetworkAclAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyNetworkAclAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_network_acl_attributes_with_options_async(
        self,
        request: vpc_20160428_models.ModifyNetworkAclAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyNetworkAclAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['NetworkAclId'] = request.network_acl_id
        query['NetworkAclName'] = request.network_acl_name
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyNetworkAclAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyNetworkAclAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_network_acl_attributes(
        self,
        request: vpc_20160428_models.ModifyNetworkAclAttributesRequest,
    ) -> vpc_20160428_models.ModifyNetworkAclAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_network_acl_attributes_with_options(request, runtime)

    async def modify_network_acl_attributes_async(
        self,
        request: vpc_20160428_models.ModifyNetworkAclAttributesRequest,
    ) -> vpc_20160428_models.ModifyNetworkAclAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_network_acl_attributes_with_options_async(request, runtime)

    def modify_physical_connection_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyPhysicalConnectionAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyPhysicalConnectionAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CircuitCode'] = request.circuit_code
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['LineOperator'] = request.line_operator
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerLocation'] = request.peer_location
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['PortType'] = request.port_type
        query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['bandwidth'] = request.bandwidth
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyPhysicalConnectionAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyPhysicalConnectionAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_physical_connection_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyPhysicalConnectionAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyPhysicalConnectionAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CircuitCode'] = request.circuit_code
        query['ClientToken'] = request.client_token
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['LineOperator'] = request.line_operator
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerLocation'] = request.peer_location
        query['PhysicalConnectionId'] = request.physical_connection_id
        query['PortType'] = request.port_type
        query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['bandwidth'] = request.bandwidth
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyPhysicalConnectionAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyPhysicalConnectionAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_physical_connection_attribute(
        self,
        request: vpc_20160428_models.ModifyPhysicalConnectionAttributeRequest,
    ) -> vpc_20160428_models.ModifyPhysicalConnectionAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_physical_connection_attribute_with_options(request, runtime)

    async def modify_physical_connection_attribute_async(
        self,
        request: vpc_20160428_models.ModifyPhysicalConnectionAttributeRequest,
    ) -> vpc_20160428_models.ModifyPhysicalConnectionAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_physical_connection_attribute_with_options_async(request, runtime)

    def modify_route_entry_with_options(
        self,
        request: vpc_20160428_models.ModifyRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteEntryId'] = request.route_entry_id
        query['RouteEntryName'] = request.route_entry_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.ModifyRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteEntryId'] = request.route_entry_id
        query['RouteEntryName'] = request.route_entry_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_route_entry(
        self,
        request: vpc_20160428_models.ModifyRouteEntryRequest,
    ) -> vpc_20160428_models.ModifyRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_route_entry_with_options(request, runtime)

    async def modify_route_entry_async(
        self,
        request: vpc_20160428_models.ModifyRouteEntryRequest,
    ) -> vpc_20160428_models.ModifyRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_route_entry_with_options_async(request, runtime)

    def modify_route_table_attributes_with_options(
        self,
        request: vpc_20160428_models.ModifyRouteTableAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyRouteTableAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        query['RouteTableName'] = request.route_table_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyRouteTableAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyRouteTableAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_route_table_attributes_with_options_async(
        self,
        request: vpc_20160428_models.ModifyRouteTableAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyRouteTableAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteTableId'] = request.route_table_id
        query['RouteTableName'] = request.route_table_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyRouteTableAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyRouteTableAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_route_table_attributes(
        self,
        request: vpc_20160428_models.ModifyRouteTableAttributesRequest,
    ) -> vpc_20160428_models.ModifyRouteTableAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_route_table_attributes_with_options(request, runtime)

    async def modify_route_table_attributes_async(
        self,
        request: vpc_20160428_models.ModifyRouteTableAttributesRequest,
    ) -> vpc_20160428_models.ModifyRouteTableAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_route_table_attributes_with_options_async(request, runtime)

    def modify_router_interface_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyRouterInterfaceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyRouterInterfaceAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DeleteHealthCheckIp'] = request.delete_health_check_ip
        query['Description'] = request.description
        query['HcRate'] = request.hc_rate
        query['HcThreshold'] = request.hc_threshold
        query['HealthCheckSourceIp'] = request.health_check_source_ip
        query['HealthCheckTargetIp'] = request.health_check_target_ip
        query['Name'] = request.name
        query['OppositeInterfaceId'] = request.opposite_interface_id
        query['OppositeInterfaceOwnerId'] = request.opposite_interface_owner_id
        query['OppositeRouterId'] = request.opposite_router_id
        query['OppositeRouterType'] = request.opposite_router_type
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyRouterInterfaceAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyRouterInterfaceAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_router_interface_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyRouterInterfaceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyRouterInterfaceAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DeleteHealthCheckIp'] = request.delete_health_check_ip
        query['Description'] = request.description
        query['HcRate'] = request.hc_rate
        query['HcThreshold'] = request.hc_threshold
        query['HealthCheckSourceIp'] = request.health_check_source_ip
        query['HealthCheckTargetIp'] = request.health_check_target_ip
        query['Name'] = request.name
        query['OppositeInterfaceId'] = request.opposite_interface_id
        query['OppositeInterfaceOwnerId'] = request.opposite_interface_owner_id
        query['OppositeRouterId'] = request.opposite_router_id
        query['OppositeRouterType'] = request.opposite_router_type
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyRouterInterfaceAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyRouterInterfaceAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_router_interface_attribute(
        self,
        request: vpc_20160428_models.ModifyRouterInterfaceAttributeRequest,
    ) -> vpc_20160428_models.ModifyRouterInterfaceAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_router_interface_attribute_with_options(request, runtime)

    async def modify_router_interface_attribute_async(
        self,
        request: vpc_20160428_models.ModifyRouterInterfaceAttributeRequest,
    ) -> vpc_20160428_models.ModifyRouterInterfaceAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_router_interface_attribute_with_options_async(request, runtime)

    def modify_router_interface_spec_with_options(
        self,
        request: vpc_20160428_models.ModifyRouterInterfaceSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyRouterInterfaceSpecResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyRouterInterfaceSpec',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyRouterInterfaceSpecResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_router_interface_spec_with_options_async(
        self,
        request: vpc_20160428_models.ModifyRouterInterfaceSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyRouterInterfaceSpecResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouterInterfaceId'] = request.router_interface_id
        query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyRouterInterfaceSpec',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyRouterInterfaceSpecResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_router_interface_spec(
        self,
        request: vpc_20160428_models.ModifyRouterInterfaceSpecRequest,
    ) -> vpc_20160428_models.ModifyRouterInterfaceSpecResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_router_interface_spec_with_options(request, runtime)

    async def modify_router_interface_spec_async(
        self,
        request: vpc_20160428_models.ModifyRouterInterfaceSpecRequest,
    ) -> vpc_20160428_models.ModifyRouterInterfaceSpecResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_router_interface_spec_with_options_async(request, runtime)

    def modify_snat_entry_with_options(
        self,
        request: vpc_20160428_models.ModifySnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifySnatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SnatEntryId'] = request.snat_entry_id
        query['SnatEntryName'] = request.snat_entry_name
        query['SnatIp'] = request.snat_ip
        query['SnatTableId'] = request.snat_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifySnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifySnatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_snat_entry_with_options_async(
        self,
        request: vpc_20160428_models.ModifySnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifySnatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SnatEntryId'] = request.snat_entry_id
        query['SnatEntryName'] = request.snat_entry_name
        query['SnatIp'] = request.snat_ip
        query['SnatTableId'] = request.snat_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifySnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifySnatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_snat_entry(
        self,
        request: vpc_20160428_models.ModifySnatEntryRequest,
    ) -> vpc_20160428_models.ModifySnatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_snat_entry_with_options(request, runtime)

    async def modify_snat_entry_async(
        self,
        request: vpc_20160428_models.ModifySnatEntryRequest,
    ) -> vpc_20160428_models.ModifySnatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_snat_entry_with_options_async(request, runtime)

    def modify_ssl_vpn_client_cert_with_options(
        self,
        request: vpc_20160428_models.ModifySslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifySslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifySslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifySslVpnClientCertResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ssl_vpn_client_cert_with_options_async(
        self,
        request: vpc_20160428_models.ModifySslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifySslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifySslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifySslVpnClientCertResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ssl_vpn_client_cert(
        self,
        request: vpc_20160428_models.ModifySslVpnClientCertRequest,
    ) -> vpc_20160428_models.ModifySslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_ssl_vpn_client_cert_with_options(request, runtime)

    async def modify_ssl_vpn_client_cert_async(
        self,
        request: vpc_20160428_models.ModifySslVpnClientCertRequest,
    ) -> vpc_20160428_models.ModifySslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_ssl_vpn_client_cert_with_options_async(request, runtime)

    def modify_ssl_vpn_server_with_options(
        self,
        request: vpc_20160428_models.ModifySslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifySslVpnServerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Cipher'] = request.cipher
        query['ClientIpPool'] = request.client_ip_pool
        query['ClientToken'] = request.client_token
        query['Compress'] = request.compress
        query['EnableMultiFactorAuth'] = request.enable_multi_factor_auth
        query['IDaaSInstanceId'] = request.idaa_sinstance_id
        query['IDaaSRegionId'] = request.idaa_sregion_id
        query['LocalSubnet'] = request.local_subnet
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Port'] = request.port
        query['Proto'] = request.proto
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifySslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifySslVpnServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ssl_vpn_server_with_options_async(
        self,
        request: vpc_20160428_models.ModifySslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifySslVpnServerResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Cipher'] = request.cipher
        query['ClientIpPool'] = request.client_ip_pool
        query['ClientToken'] = request.client_token
        query['Compress'] = request.compress
        query['EnableMultiFactorAuth'] = request.enable_multi_factor_auth
        query['IDaaSInstanceId'] = request.idaa_sinstance_id
        query['IDaaSRegionId'] = request.idaa_sregion_id
        query['LocalSubnet'] = request.local_subnet
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['Port'] = request.port
        query['Proto'] = request.proto
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifySslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifySslVpnServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ssl_vpn_server(
        self,
        request: vpc_20160428_models.ModifySslVpnServerRequest,
    ) -> vpc_20160428_models.ModifySslVpnServerResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_ssl_vpn_server_with_options(request, runtime)

    async def modify_ssl_vpn_server_async(
        self,
        request: vpc_20160428_models.ModifySslVpnServerRequest,
    ) -> vpc_20160428_models.ModifySslVpnServerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_ssl_vpn_server_with_options_async(request, runtime)

    def modify_vrouter_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyVRouterAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVRouterAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VRouterId'] = request.vrouter_id
        query['VRouterName'] = request.vrouter_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVRouterAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVRouterAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_vrouter_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyVRouterAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVRouterAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VRouterId'] = request.vrouter_id
        query['VRouterName'] = request.vrouter_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVRouterAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVRouterAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_vrouter_attribute(
        self,
        request: vpc_20160428_models.ModifyVRouterAttributeRequest,
    ) -> vpc_20160428_models.ModifyVRouterAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_vrouter_attribute_with_options(request, runtime)

    async def modify_vrouter_attribute_async(
        self,
        request: vpc_20160428_models.ModifyVRouterAttributeRequest,
    ) -> vpc_20160428_models.ModifyVRouterAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_vrouter_attribute_with_options_async(request, runtime)

    def modify_vswitch_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyVSwitchAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVSwitchAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['EnableIPv6'] = request.enable_ipv_6
        query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VSwitchId'] = request.v_switch_id
        query['VSwitchName'] = request.v_switch_name
        query['VpcIpv6CidrBlock'] = request.vpc_ipv_6cidr_block
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVSwitchAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVSwitchAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_vswitch_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyVSwitchAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVSwitchAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['Description'] = request.description
        query['EnableIPv6'] = request.enable_ipv_6
        query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VSwitchId'] = request.v_switch_id
        query['VSwitchName'] = request.v_switch_name
        query['VpcIpv6CidrBlock'] = request.vpc_ipv_6cidr_block
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVSwitchAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVSwitchAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_vswitch_attribute(
        self,
        request: vpc_20160428_models.ModifyVSwitchAttributeRequest,
    ) -> vpc_20160428_models.ModifyVSwitchAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_vswitch_attribute_with_options(request, runtime)

    async def modify_vswitch_attribute_async(
        self,
        request: vpc_20160428_models.ModifyVSwitchAttributeRequest,
    ) -> vpc_20160428_models.ModifyVSwitchAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_vswitch_attribute_with_options_async(request, runtime)

    def modify_virtual_border_router_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyVirtualBorderRouterAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVirtualBorderRouterAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AssociatedPhysicalConnections'] = request.associated_physical_connections
        query['Bandwidth'] = request.bandwidth
        query['CircuitCode'] = request.circuit_code
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['DetectMultiplier'] = request.detect_multiplier
        query['EnableIpv6'] = request.enable_ipv_6
        query['LocalGatewayIp'] = request.local_gateway_ip
        query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        query['MinRxInterval'] = request.min_rx_interval
        query['MinTxInterval'] = request.min_tx_interval
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerGatewayIp'] = request.peer_gateway_ip
        query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        query['PeeringSubnetMask'] = request.peering_subnet_mask
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrId'] = request.vbr_id
        query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVirtualBorderRouterAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVirtualBorderRouterAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_virtual_border_router_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyVirtualBorderRouterAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVirtualBorderRouterAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AssociatedPhysicalConnections'] = request.associated_physical_connections
        query['Bandwidth'] = request.bandwidth
        query['CircuitCode'] = request.circuit_code
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['DetectMultiplier'] = request.detect_multiplier
        query['EnableIpv6'] = request.enable_ipv_6
        query['LocalGatewayIp'] = request.local_gateway_ip
        query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        query['MinRxInterval'] = request.min_rx_interval
        query['MinTxInterval'] = request.min_tx_interval
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PeerGatewayIp'] = request.peer_gateway_ip
        query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        query['PeeringSubnetMask'] = request.peering_subnet_mask
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrId'] = request.vbr_id
        query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVirtualBorderRouterAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVirtualBorderRouterAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_virtual_border_router_attribute(
        self,
        request: vpc_20160428_models.ModifyVirtualBorderRouterAttributeRequest,
    ) -> vpc_20160428_models.ModifyVirtualBorderRouterAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_virtual_border_router_attribute_with_options(request, runtime)

    async def modify_virtual_border_router_attribute_async(
        self,
        request: vpc_20160428_models.ModifyVirtualBorderRouterAttributeRequest,
    ) -> vpc_20160428_models.ModifyVirtualBorderRouterAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_virtual_border_router_attribute_with_options_async(request, runtime)

    def modify_vpc_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyVpcAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVpcAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CidrBlock'] = request.cidr_block
        query['Description'] = request.description
        query['EnableIPv6'] = request.enable_ipv_6
        query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        query['Ipv6Isp'] = request.ipv_6isp
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        query['VpcName'] = request.vpc_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVpcAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVpcAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_vpc_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyVpcAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVpcAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['CidrBlock'] = request.cidr_block
        query['Description'] = request.description
        query['EnableIPv6'] = request.enable_ipv_6
        query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        query['Ipv6Isp'] = request.ipv_6isp
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpcId'] = request.vpc_id
        query['VpcName'] = request.vpc_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVpcAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVpcAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_vpc_attribute(
        self,
        request: vpc_20160428_models.ModifyVpcAttributeRequest,
    ) -> vpc_20160428_models.ModifyVpcAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_vpc_attribute_with_options(request, runtime)

    async def modify_vpc_attribute_async(
        self,
        request: vpc_20160428_models.ModifyVpcAttributeRequest,
    ) -> vpc_20160428_models.ModifyVpcAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_vpc_attribute_with_options_async(request, runtime)

    def modify_vpn_connection_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyVpnConnectionAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVpnConnectionAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoConfigRoute'] = request.auto_config_route
        query['BgpConfig'] = request.bgp_config
        query['ClientToken'] = request.client_token
        query['EffectImmediately'] = request.effect_immediately
        query['EnableDpd'] = request.enable_dpd
        query['EnableNatTraversal'] = request.enable_nat_traversal
        query['HealthCheckConfig'] = request.health_check_config
        query['IkeConfig'] = request.ike_config
        query['IpsecConfig'] = request.ipsec_config
        query['LocalSubnet'] = request.local_subnet
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RemoteCaCertificate'] = request.remote_ca_certificate
        query['RemoteSubnet'] = request.remote_subnet
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVpnConnectionAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVpnConnectionAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_vpn_connection_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyVpnConnectionAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVpnConnectionAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoConfigRoute'] = request.auto_config_route
        query['BgpConfig'] = request.bgp_config
        query['ClientToken'] = request.client_token
        query['EffectImmediately'] = request.effect_immediately
        query['EnableDpd'] = request.enable_dpd
        query['EnableNatTraversal'] = request.enable_nat_traversal
        query['HealthCheckConfig'] = request.health_check_config
        query['IkeConfig'] = request.ike_config
        query['IpsecConfig'] = request.ipsec_config
        query['LocalSubnet'] = request.local_subnet
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['RemoteCaCertificate'] = request.remote_ca_certificate
        query['RemoteSubnet'] = request.remote_subnet
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVpnConnectionAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVpnConnectionAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_vpn_connection_attribute(
        self,
        request: vpc_20160428_models.ModifyVpnConnectionAttributeRequest,
    ) -> vpc_20160428_models.ModifyVpnConnectionAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_vpn_connection_attribute_with_options(request, runtime)

    async def modify_vpn_connection_attribute_async(
        self,
        request: vpc_20160428_models.ModifyVpnConnectionAttributeRequest,
    ) -> vpc_20160428_models.ModifyVpnConnectionAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_vpn_connection_attribute_with_options_async(request, runtime)

    def modify_vpn_gateway_attribute_with_options(
        self,
        request: vpc_20160428_models.ModifyVpnGatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVpnGatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPropagate'] = request.auto_propagate
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVpnGatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVpnGatewayAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_vpn_gateway_attribute_with_options_async(
        self,
        request: vpc_20160428_models.ModifyVpnGatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVpnGatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        query['AutoPropagate'] = request.auto_propagate
        query['ClientToken'] = request.client_token
        query['Description'] = request.description
        query['Name'] = request.name
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVpnGatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVpnGatewayAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_vpn_gateway_attribute(
        self,
        request: vpc_20160428_models.ModifyVpnGatewayAttributeRequest,
    ) -> vpc_20160428_models.ModifyVpnGatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_vpn_gateway_attribute_with_options(request, runtime)

    async def modify_vpn_gateway_attribute_async(
        self,
        request: vpc_20160428_models.ModifyVpnGatewayAttributeRequest,
    ) -> vpc_20160428_models.ModifyVpnGatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_vpn_gateway_attribute_with_options_async(request, runtime)

    def modify_vpn_pbr_route_entry_weight_with_options(
        self,
        request: vpc_20160428_models.ModifyVpnPbrRouteEntryWeightRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVpnPbrRouteEntryWeightResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NewWeight'] = request.new_weight
        query['NextHop'] = request.next_hop
        query['OverlayMode'] = request.overlay_mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['RouteSource'] = request.route_source
        query['VpnGatewayId'] = request.vpn_gateway_id
        query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVpnPbrRouteEntryWeight',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVpnPbrRouteEntryWeightResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_vpn_pbr_route_entry_weight_with_options_async(
        self,
        request: vpc_20160428_models.ModifyVpnPbrRouteEntryWeightRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVpnPbrRouteEntryWeightResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NewWeight'] = request.new_weight
        query['NextHop'] = request.next_hop
        query['OverlayMode'] = request.overlay_mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['RouteSource'] = request.route_source
        query['VpnGatewayId'] = request.vpn_gateway_id
        query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVpnPbrRouteEntryWeight',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVpnPbrRouteEntryWeightResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_vpn_pbr_route_entry_weight(
        self,
        request: vpc_20160428_models.ModifyVpnPbrRouteEntryWeightRequest,
    ) -> vpc_20160428_models.ModifyVpnPbrRouteEntryWeightResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_vpn_pbr_route_entry_weight_with_options(request, runtime)

    async def modify_vpn_pbr_route_entry_weight_async(
        self,
        request: vpc_20160428_models.ModifyVpnPbrRouteEntryWeightRequest,
    ) -> vpc_20160428_models.ModifyVpnPbrRouteEntryWeightResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_vpn_pbr_route_entry_weight_with_options_async(request, runtime)

    def modify_vpn_route_entry_weight_with_options(
        self,
        request: vpc_20160428_models.ModifyVpnRouteEntryWeightRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVpnRouteEntryWeightResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NewWeight'] = request.new_weight
        query['NextHop'] = request.next_hop
        query['OverlayMode'] = request.overlay_mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['VpnGatewayId'] = request.vpn_gateway_id
        query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVpnRouteEntryWeight',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVpnRouteEntryWeightResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_vpn_route_entry_weight_with_options_async(
        self,
        request: vpc_20160428_models.ModifyVpnRouteEntryWeightRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ModifyVpnRouteEntryWeightResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NewWeight'] = request.new_weight
        query['NextHop'] = request.next_hop
        query['OverlayMode'] = request.overlay_mode
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['VpnGatewayId'] = request.vpn_gateway_id
        query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='ModifyVpnRouteEntryWeight',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ModifyVpnRouteEntryWeightResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_vpn_route_entry_weight(
        self,
        request: vpc_20160428_models.ModifyVpnRouteEntryWeightRequest,
    ) -> vpc_20160428_models.ModifyVpnRouteEntryWeightResponse:
        runtime = util_models.RuntimeOptions()
        return self.modify_vpn_route_entry_weight_with_options(request, runtime)

    async def modify_vpn_route_entry_weight_async(
        self,
        request: vpc_20160428_models.ModifyVpnRouteEntryWeightRequest,
    ) -> vpc_20160428_models.ModifyVpnRouteEntryWeightResponse:
        runtime = util_models.RuntimeOptions()
        return await self.modify_vpn_route_entry_weight_with_options_async(request, runtime)

    def move_resource_group_with_options(
        self,
        request: vpc_20160428_models.MoveResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.MoveResourceGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        query['NewResourceGroupId'] = request.new_resource_group_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceId'] = request.resource_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='MoveResourceGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.MoveResourceGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def move_resource_group_with_options_async(
        self,
        request: vpc_20160428_models.MoveResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.MoveResourceGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        query['NewResourceGroupId'] = request.new_resource_group_id
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceId'] = request.resource_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='MoveResourceGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.MoveResourceGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def move_resource_group(
        self,
        request: vpc_20160428_models.MoveResourceGroupRequest,
    ) -> vpc_20160428_models.MoveResourceGroupResponse:
        runtime = util_models.RuntimeOptions()
        return self.move_resource_group_with_options(request, runtime)

    async def move_resource_group_async(
        self,
        request: vpc_20160428_models.MoveResourceGroupRequest,
    ) -> vpc_20160428_models.MoveResourceGroupResponse:
        runtime = util_models.RuntimeOptions()
        return await self.move_resource_group_with_options_async(request, runtime)

    def open_physical_connection_service_with_options(
        self,
        request: vpc_20160428_models.OpenPhysicalConnectionServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.OpenPhysicalConnectionServiceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='OpenPhysicalConnectionService',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.OpenPhysicalConnectionServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def open_physical_connection_service_with_options_async(
        self,
        request: vpc_20160428_models.OpenPhysicalConnectionServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.OpenPhysicalConnectionServiceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='OpenPhysicalConnectionService',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.OpenPhysicalConnectionServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def open_physical_connection_service(
        self,
        request: vpc_20160428_models.OpenPhysicalConnectionServiceRequest,
    ) -> vpc_20160428_models.OpenPhysicalConnectionServiceResponse:
        runtime = util_models.RuntimeOptions()
        return self.open_physical_connection_service_with_options(request, runtime)

    async def open_physical_connection_service_async(
        self,
        request: vpc_20160428_models.OpenPhysicalConnectionServiceRequest,
    ) -> vpc_20160428_models.OpenPhysicalConnectionServiceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.open_physical_connection_service_with_options_async(request, runtime)

    def open_traffic_mirror_service_with_options(
        self,
        request: vpc_20160428_models.OpenTrafficMirrorServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.OpenTrafficMirrorServiceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='OpenTrafficMirrorService',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.OpenTrafficMirrorServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def open_traffic_mirror_service_with_options_async(
        self,
        request: vpc_20160428_models.OpenTrafficMirrorServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.OpenTrafficMirrorServiceResponse:
        UtilClient.validate_model(request)
        query = {}
        query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='OpenTrafficMirrorService',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.OpenTrafficMirrorServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def open_traffic_mirror_service(
        self,
        request: vpc_20160428_models.OpenTrafficMirrorServiceRequest,
    ) -> vpc_20160428_models.OpenTrafficMirrorServiceResponse:
        runtime = util_models.RuntimeOptions()
        return self.open_traffic_mirror_service_with_options(request, runtime)

    async def open_traffic_mirror_service_async(
        self,
        request: vpc_20160428_models.OpenTrafficMirrorServiceRequest,
    ) -> vpc_20160428_models.OpenTrafficMirrorServiceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.open_traffic_mirror_service_with_options_async(request, runtime)

    def publish_vpn_route_entry_with_options(
        self,
        request: vpc_20160428_models.PublishVpnRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.PublishVpnRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NextHop'] = request.next_hop
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PublishVpc'] = request.publish_vpc
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['RouteType'] = request.route_type
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='PublishVpnRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.PublishVpnRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def publish_vpn_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.PublishVpnRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.PublishVpnRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['NextHop'] = request.next_hop
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['PublishVpc'] = request.publish_vpc
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['RouteDest'] = request.route_dest
        query['RouteType'] = request.route_type
        query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='PublishVpnRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.PublishVpnRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def publish_vpn_route_entry(
        self,
        request: vpc_20160428_models.PublishVpnRouteEntryRequest,
    ) -> vpc_20160428_models.PublishVpnRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.publish_vpn_route_entry_with_options(request, runtime)

    async def publish_vpn_route_entry_async(
        self,
        request: vpc_20160428_models.PublishVpnRouteEntryRequest,
    ) -> vpc_20160428_models.PublishVpnRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.publish_vpn_route_entry_with_options_async(request, runtime)

    def recover_physical_connection_with_options(
        self,
        request: vpc_20160428_models.RecoverPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.RecoverPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['InstanceId'] = request.instance_id
        query['RegionId'] = request.region_id
        query['Token'] = request.token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='RecoverPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.RecoverPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def recover_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.RecoverPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.RecoverPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        query['DryRun'] = request.dry_run
        query['InstanceId'] = request.instance_id
        query['RegionId'] = request.region_id
        query['Token'] = request.token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='RecoverPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.RecoverPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def recover_physical_connection(
        self,
        request: vpc_20160428_models.RecoverPhysicalConnectionRequest,
    ) -> vpc_20160428_models.RecoverPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.recover_physical_connection_with_options(request, runtime)

    async def recover_physical_connection_async(
        self,
        request: vpc_20160428_models.RecoverPhysicalConnectionRequest,
    ) -> vpc_20160428_models.RecoverPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.recover_physical_connection_with_options_async(request, runtime)

    def recover_virtual_border_router_with_options(
        self,
        request: vpc_20160428_models.RecoverVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.RecoverVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=UtilClient.to_map(request)
        )
        params = open_api_models.Params(
            action='RecoverVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='json',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.RecoverVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def recover_virtual_border_router_with_options_async(
        self,
        request: vpc_20160428_models.RecoverVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.RecoverVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        query['ClientToken'] = request.client_token
        query['OwnerAccount'] = request.owner_account
        query['OwnerId'] = request.owner_id
        query['RegionId'] = request.region_id
        query['ResourceOwnerAccount'] = request.resource_owner_account
        query['ResourceOwnerId'] = request.resource_owner_id
        query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApi