# studio_wrapper.py

import enum
from typing import Any
import nanosurf.lib.spm.studio.wrapper as wrap

g_cmd_tree_hash = 'c2a63bf288b75e44404c9e8c91497e6a'
g_compiler_version = '2.0'

class RootTestTabel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.test.tabel'


class RootTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.test'
        self.tabel = RootTestTabel(self._context)

    @property
    def num_f(self) -> float:
        return float(self._context.get('root.test.num_f'))

    @num_f.setter
    def num_f(self, new_val:float):
        self._context.set('root.test.num_f', float(new_val))

    @property
    def num_i(self) -> int:
        return int(self._context.get('root.test.num_i'))

    @num_i.setter
    def num_i(self, new_val:int):
        self._context.set('root.test.num_i', int(new_val))

    def func(self, *args) -> Any:
        return self._context.call('root.test.func', *args)

    @property
    def str(self) -> str:
        return str(self._context.get('root.test.str'))

    @str.setter
    def str(self, new_val:str):
        self._context.set('root.test.str', str(new_val))

    @property
    def bool(self) -> bool:
        return bool(self._context.get('root.test.bool'))

    @bool.setter
    def bool(self, new_val:bool):
        self._context.set('root.test.bool', bool(new_val))


class RootUtil(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.util'

    def make_property(self, *args) -> Any:
        return self._context.call('root.util.make_property', *args)

    def deep_copy(self, *args) -> Any:
        return self._context.call('root.util.deep_copy', *args)

    def list_table_tables(self, *args) -> Any:
        return self._context.call('root.util.list_table_tables', *args)

    def num_table_invert(self, *args) -> Any:
        return self._context.call('root.util.num_table_invert', *args)

    def table_append(self, *args) -> Any:
        return self._context.call('root.util.table_append', *args)

    def prequire(self, *args) -> Any:
        return self._context.call('root.util.prequire', *args)

    def to_string(self, *args) -> Any:
        return self._context.call('root.util.to_string', *args)

    def filter_string_array_begin(self, *args) -> Any:
        return self._context.call('root.util.filter_string_array_begin', *args)

    def list_table_vars(self, *args) -> Any:
        return self._context.call('root.util.list_table_vars', *args)

    def list_table_elements(self, *args) -> Any:
        return self._context.call('root.util.list_table_elements', *args)

    def to_snake_case(self, *args) -> Any:
        return self._context.call('root.util.to_snake_case', *args)

    def list_table_functions(self, *args) -> Any:
        return self._context.call('root.util.list_table_functions', *args)

    def list_table_all(self, *args) -> Any:
        return self._context.call('root.util.list_table_all', *args)

    def deep_compare(self, *args) -> Any:
        return self._context.call('root.util.deep_compare', *args)

    def array_concat(self, *args) -> Any:
        return self._context.call('root.util.array_concat', *args)


class RootSession(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.session'

    def select_main(self, *args) -> Any:
        return self._context.call('root.session.select_main', *args)

    def select(self, *args) -> Any:
        return self._context.call('root.session.select', *args)

    @property
    def name(self) -> str:
        return str(self._context.get('root.session.name'))

    @name.setter
    def name(self, new_val:str):
        self._context.set('root.session.name', str(new_val))

    def list(self, *args) -> Any:
        return self._context.call('root.session.list', *args)

    @property
    def current_connection(self) -> str:
        return str(self._context.get('root.session.current_connection'))

    @current_connection.setter
    def current_connection(self, new_val:str):
        self._context.set('root.session.current_connection', str(new_val))


class RootCoreConverter_channel_correction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.converter_channel_correction'


class RootCoreCore_environment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_environment'


class RootCoreDirect_motor_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.direct_motor_control'


class RootCoreOscilloscope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.oscilloscope'


class RootCoreScan_head_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.scan_head_calibration'


class RootCoreAcquisition(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.acquisition'

    def write_data(self, *args) -> Any:
        return self._context.call('root.core.acquisition.write_data', *args)

    def erase_lu_data_buffer(self, *args) -> Any:
        return self._context.call('root.core.acquisition.erase_lu_data_buffer', *args)

    def lu_data_buffer_timestamp(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_timestamp', *args)

    def lu_data_buffer_channel_count(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_channel_count', *args)

    def lu_data_buffer_channel_data(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_channel_data', *args)

    def reserve_lu_data_buffer(self, *args) -> Any:
        return self._context.call('root.core.acquisition.reserve_lu_data_buffer', *args)

    def lu_data_buffer_state(self, *args) -> Any:
        return self._context.call('root.core.acquisition.lu_data_buffer_state', *args)

    def trim_sampler_buffer(self, *args) -> Any:
        return self._context.call('root.core.acquisition.trim_sampler_buffer', *args)

    def synchronize_lu_data_buffer(self, *args) -> Any:
        return self._context.call('root.core.acquisition.synchronize_lu_data_buffer', *args)


class RootCoreSignal_store(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_store'

    def get_signal_calibration_min_max(self, *args) -> Any:
        return self._context.call('root.core.signal_store.get_signal_calibration_min_max', *args)


class RootCoreImaging(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.imaging'


class RootCoreThermal_tuneSignalNew_average(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_average'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_average.connect_extended', *args)


class RootCoreThermal_tuneSignalProcedure_info(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.procedure_info'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.procedure_info.connect_extended', *args)


class RootCoreThermal_tuneSignalNew_frequency_list(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_frequency_list'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_frequency_list.connect_extended', *args)


class RootCoreThermal_tuneSignalProgress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.progress'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.progress.connect_extended', *args)


class RootCoreThermal_tuneSignalData_invalidated(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.data_invalidated'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.data_invalidated.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.data_invalidated.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.data_invalidated.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.data_invalidated.connect_extended', *args)


class RootCoreThermal_tuneSignalNew_fit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.new_fit'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.new_fit.connect_extended', *args)


class RootCoreThermal_tuneSignalEnded(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.ended'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.ended.connect_extended', *args)


class RootCoreThermal_tuneSignalStarted(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal.started'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.signal.started.connect_extended', *args)


class RootCoreThermal_tuneSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.signal'
        self.started = RootCoreThermal_tuneSignalStarted(self._context)
        self.ended = RootCoreThermal_tuneSignalEnded(self._context)
        self.new_fit = RootCoreThermal_tuneSignalNew_fit(self._context)
        self.data_invalidated = RootCoreThermal_tuneSignalData_invalidated(self._context)
        self.progress = RootCoreThermal_tuneSignalProgress(self._context)
        self.new_frequency_list = RootCoreThermal_tuneSignalNew_frequency_list(self._context)
        self.procedure_info = RootCoreThermal_tuneSignalProcedure_info(self._context)
        self.new_average = RootCoreThermal_tuneSignalNew_average(self._context)


class RootCoreThermal_tunePropertyMeasurement_environment(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Air = 0
        Liquid = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.measurement_environment'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreThermal_tunePropertyMeasurement_environment.ValueEnum(self._context.get('root.core.thermal_tune.property.measurement_environment.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.thermal_tune.property.measurement_environment.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.thermal_tune.property.measurement_environment.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.thermal_tune.property.measurement_environment.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.thermal_tune.property.measurement_environment.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.thermal_tune.property.measurement_environment.enum', list(new_val))


class RootCoreThermal_tunePropertyFit_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.fit_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.fit_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.fit_frequency_lower_bound.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.fit_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.fit_frequency_lower_bound.unit', str(new_val))


class RootCoreThermal_tunePropertyTemperature(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.temperature'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.temperature.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.temperature.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.temperature.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.temperature.unit', str(new_val))


class RootCoreThermal_tunePropertyIterations(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.iterations'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.thermal_tune.property.iterations.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.thermal_tune.property.iterations.value', int(new_val))


class RootCoreThermal_tunePropertyResolution(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.resolution'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.resolution.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.resolution.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.resolution.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.resolution.unit', str(new_val))


class RootCoreThermal_tunePropertyFit_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.fit_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.fit_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.fit_frequency_upper_bound.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.fit_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.fit_frequency_upper_bound.unit', str(new_val))


class RootCoreThermal_tunePropertyMax_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property.max_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.thermal_tune.property.max_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.thermal_tune.property.max_frequency.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.thermal_tune.property.max_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.thermal_tune.property.max_frequency.unit', str(new_val))


class RootCoreThermal_tuneProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune.property'
        self.max_frequency = RootCoreThermal_tunePropertyMax_frequency(self._context)
        self.fit_frequency_upper_bound = RootCoreThermal_tunePropertyFit_frequency_upper_bound(self._context)
        self.resolution = RootCoreThermal_tunePropertyResolution(self._context)
        self.iterations = RootCoreThermal_tunePropertyIterations(self._context)
        self.temperature = RootCoreThermal_tunePropertyTemperature(self._context)
        self.fit_frequency_lower_bound = RootCoreThermal_tunePropertyFit_frequency_lower_bound(self._context)
        self.measurement_environment = RootCoreThermal_tunePropertyMeasurement_environment(self._context)


class RootCoreThermal_tune(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.thermal_tune'
        self.property = RootCoreThermal_tuneProperty(self._context)
        self.signal = RootCoreThermal_tuneSignal(self._context)

    def start(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.start', *args)

    def calculate_cantilever_calibration(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.calculate_cantilever_calibration', *args)

    def set_thermal_tune_parameters(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.set_thermal_tune_parameters', *args)

    def add_raw_data_to_fft_average_buffer(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.add_raw_data_to_fft_average_buffer', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.abort', *args)

    def create_fit_from_fft_average_buffer(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.create_fit_from_fft_average_buffer', *args)

    def generate_frequency_list(self, *args) -> Any:
        return self._context.call('root.core.thermal_tune.generate_frequency_list', *args)


class RootCoreApproachSignalApproach_or_withdraw_done(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.signal.approach_or_withdraw_done'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach.signal.approach_or_withdraw_done.connect_extended', *args)


class RootCoreApproachSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.signal'
        self.approach_or_withdraw_done = RootCoreApproachSignalApproach_or_withdraw_done(self._context)


class RootCoreApproachPropertyStep_by_step_slope(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_slope'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_by_step_slope.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_by_step_slope.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_slope.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_slope.unit', str(new_val))


class RootCoreApproachPropertyStep_by_step_coarse_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_coarse_step_size_percentage'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_coarse_step_size_percentage.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_coarse_step_size_percentage.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_coarse_step_size_percentage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_coarse_step_size_percentage.unit', str(new_val))


class RootCoreApproachPropertyStep_by_step_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_by_step_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_by_step_time.value', float(new_val))


class RootCoreApproachPropertyStep_by_step_fine_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_fine_step_size_percentage'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_fine_step_size_percentage.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_fine_step_size_percentage.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.step_by_step_fine_step_size_percentage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.step_by_step_fine_step_size_percentage.unit', str(new_val))


class RootCoreApproachPropertyMotor_source(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Internal = 0
        External = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.motor_source'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreApproachPropertyMotor_source.ValueEnum(self._context.get('root.core.approach.property.motor_source.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.approach.property.motor_source.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.approach.property.motor_source.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.approach.property.motor_source.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.motor_source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.motor_source.enum', list(new_val))


class RootCoreApproachPropertyApproach_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.approach_pos.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.approach_pos.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_pos.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.approach_pos.unit', str(new_val))


class RootCoreApproachPropertyStep_by_step_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Tip_Position_Ignored = 2
        Not_Controlled = 1
        Position_Controlled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_by_step_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreApproachPropertyStep_by_step_mode.ValueEnum(self._context.get('root.core.approach.property.step_by_step_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.approach.property.step_by_step_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.approach.property.step_by_step_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.approach.property.step_by_step_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.step_by_step_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.step_by_step_mode.enum', list(new_val))


class RootCoreApproachPropertyApproach_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_steps'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.approach_steps.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.approach_steps.value', int(new_val))


class RootCoreApproachPropertyStep_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.step_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.step_period.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.step_period.value', float(new_val))


class RootCoreApproachPropertyWithdraw_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.withdraw_steps'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.approach.property.withdraw_steps.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.approach.property.withdraw_steps.value', int(new_val))


class RootCoreApproachPropertyApproach_result(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_result'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_result.value'))

    @value.setter
    def value(self, new_val:str):
        self._context.set('root.core.approach.property.approach_result.value', str(new_val))


class RootCoreApproachPropertyApproach_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Continuous = 0
        Step_by_Step = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreApproachPropertyApproach_mode.ValueEnum(self._context.get('root.core.approach.property.approach_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.approach.property.approach_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.approach.property.approach_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.approach.property.approach_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.approach.property.approach_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.approach.property.approach_mode.enum', list(new_val))


class RootCoreApproachPropertyApproach_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.approach_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.approach_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.approach_speed.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.approach_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.approach_speed.unit', str(new_val))


class RootCoreApproachPropertyDeflection_offset_voltage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property.deflection_offset_voltage'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach.property.deflection_offset_voltage.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach.property.deflection_offset_voltage.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach.property.deflection_offset_voltage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach.property.deflection_offset_voltage.unit', str(new_val))


class RootCoreApproachProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach.property'
        self.deflection_offset_voltage = RootCoreApproachPropertyDeflection_offset_voltage(self._context)
        self.approach_speed = RootCoreApproachPropertyApproach_speed(self._context)
        self.approach_mode = RootCoreApproachPropertyApproach_mode(self._context)
        self.approach_result = RootCoreApproachPropertyApproach_result(self._context)
        self.withdraw_steps = RootCoreApproachPropertyWithdraw_steps(self._context)
        self.step_period = RootCoreApproachPropertyStep_period(self._context)
        self.approach_steps = RootCoreApproachPropertyApproach_steps(self._context)
        self.step_by_step_mode = RootCoreApproachPropertyStep_by_step_mode(self._context)
        self.approach_pos = RootCoreApproachPropertyApproach_pos(self._context)
        self.motor_source = RootCoreApproachPropertyMotor_source(self._context)
        self.step_by_step_fine_step_size_percentage = RootCoreApproachPropertyStep_by_step_fine_step_size_percentage(self._context)
        self.step_by_step_time = RootCoreApproachPropertyStep_by_step_time(self._context)
        self.step_by_step_coarse_step_size_percentage = RootCoreApproachPropertyStep_by_step_coarse_step_size_percentage(self._context)
        self.step_by_step_slope = RootCoreApproachPropertyStep_by_step_slope(self._context)


class RootCoreApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach'
        self.property = RootCoreApproachProperty(self._context)
        self.signal = RootCoreApproachSignal(self._context)

    def withdraw(self, *args) -> Any:
        return self._context.call('root.core.approach.withdraw', *args)

    def approach(self, *args) -> Any:
        return self._context.call('root.core.approach.approach', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.approach.abort', *args)


class RootCoreOrtPropertyBaseline_window_begin(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_window_begin'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_window_begin.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_window_begin.value', float(new_val))


class RootCoreOrtPropertyBaseline_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_frequency.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_frequency.unit', str(new_val))


class RootCoreOrtPropertyBaseline_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_value.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_value.unit', str(new_val))


class RootCoreOrtPropertyBaseline_window_end(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_window_end'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_window_end.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_window_end.value', float(new_val))


class RootCoreOrtPropertyAdhesion_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.adhesion_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.adhesion_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.adhesion_position.value', float(new_val))


class RootCoreOrtPropertyAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.amplitude_reduction.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.amplitude_reduction.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.amplitude_reduction.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.amplitude_reduction.unit', str(new_val))


class RootCoreOrtPropertySamples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.samples_per_period'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.samples_per_period.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.samples_per_period.value', int(new_val))


class RootCoreOrtPropertyAdhesion_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.adhesion_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.adhesion_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.adhesion_value.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.adhesion_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.adhesion_value.unit', str(new_val))


class RootCoreOrtPropertyExcitation_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.excitation_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.ort.property.excitation_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.ort.property.excitation_enabled.value', bool(new_val))


class RootCoreOrtPropertyFeedback_amplitude_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.feedback_amplitude_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.feedback_amplitude_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.feedback_amplitude_position.value', float(new_val))


class RootCoreOrtPropertyInput_select(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Fast_In_User = 2
        Fast_In_Deflection = 0
        Hi_Res_In_User1 = 3
        Hi_Res_In_Deflection = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.input_select'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreOrtPropertyInput_select.ValueEnum(self._context.get('root.core.ort.property.input_select.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.ort.property.input_select.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.ort.property.input_select.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.ort.property.input_select.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.ort.property.input_select.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.ort.property.input_select.enum', list(new_val))


class RootCoreOrtPropertyAverage_periods(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.average_periods'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.average_periods.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.average_periods.value', int(new_val))


class RootCoreOrtPropertyFree_wave_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.free_wave_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.free_wave_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.free_wave_delay.value', float(new_val))


class RootCoreOrtPropertyCantilever_samples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.cantilever_samples_per_period'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.ort.property.cantilever_samples_per_period.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.ort.property.cantilever_samples_per_period.value', int(new_val))


class RootCoreOrtPropertyBaseline_controller_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_controller_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.ort.property.baseline_controller_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.ort.property.baseline_controller_enabled.value', bool(new_val))


class RootCoreOrtPropertyBaseline_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property.baseline_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.ort.property.baseline_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.ort.property.baseline_amplitude.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.ort.property.baseline_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.ort.property.baseline_amplitude.unit', str(new_val))


class RootCoreOrtProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort.property'
        self.baseline_amplitude = RootCoreOrtPropertyBaseline_amplitude(self._context)
        self.baseline_controller_enabled = RootCoreOrtPropertyBaseline_controller_enabled(self._context)
        self.cantilever_samples_per_period = RootCoreOrtPropertyCantilever_samples_per_period(self._context)
        self.free_wave_delay = RootCoreOrtPropertyFree_wave_delay(self._context)
        self.average_periods = RootCoreOrtPropertyAverage_periods(self._context)
        self.input_select = RootCoreOrtPropertyInput_select(self._context)
        self.feedback_amplitude_position = RootCoreOrtPropertyFeedback_amplitude_position(self._context)
        self.excitation_enabled = RootCoreOrtPropertyExcitation_enabled(self._context)
        self.adhesion_value = RootCoreOrtPropertyAdhesion_value(self._context)
        self.samples_per_period = RootCoreOrtPropertySamples_per_period(self._context)
        self.amplitude_reduction = RootCoreOrtPropertyAmplitude_reduction(self._context)
        self.adhesion_position = RootCoreOrtPropertyAdhesion_position(self._context)
        self.baseline_window_end = RootCoreOrtPropertyBaseline_window_end(self._context)
        self.baseline_value = RootCoreOrtPropertyBaseline_value(self._context)
        self.baseline_frequency = RootCoreOrtPropertyBaseline_frequency(self._context)
        self.baseline_window_begin = RootCoreOrtPropertyBaseline_window_begin(self._context)


class RootCoreOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.ort'
        self.property = RootCoreOrtProperty(self._context)

    def select_input(self, *args) -> Any:
        return self._context.call('root.core.ort.select_input', *args)

    def apply_samples_values(self, *args) -> Any:
        return self._context.call('root.core.ort.apply_samples_values', *args)

    def apply_samples_per_period(self, *args) -> Any:
        return self._context.call('root.core.ort.apply_samples_per_period', *args)

    def update_free_wave(self, *args) -> Any:
        return self._context.call('root.core.ort.update_free_wave', *args)

    def is_averaging(self, *args) -> Any:
        return self._context.call('root.core.ort.is_averaging', *args)

    def excitation_amplitude(self, *args) -> Any:
        return self._context.call('root.core.ort.excitation_amplitude', *args)


class RootCoreCore_options(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_options'


class RootCoreComp_dc(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.comp_dc'


class RootCoreSpectroscopyPropertyFeedback_active(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.feedback_active'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.spectroscopy.property.feedback_active.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.spectroscopy.property.feedback_active.value', bool(new_val))


class RootCoreSpectroscopyPropertyForward_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_pause_time.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_time.unit', str(new_val))


class RootCoreSpectroscopyPropertySpec_end_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Keep_Last_Z_Position = 0
        Z_Controller_Active = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.spec_end_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertySpec_end_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.spec_end_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.spec_end_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.spec_end_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.spec_end_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.xy_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.xy_move_speed.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.xy_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.xy_move_speed.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_value.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_value.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Z_On = 1
        Z_Off = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyBackward_pause_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.backward_pause_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_pause_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_pause_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_pause_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_pause_time.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_time.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_time.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_time.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_pause_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_pause_sampling_rate.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_sampling_rate.unit', str(new_val))


class RootCoreSpectroscopyPropertyModulation_relative_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.modulation_relative_value'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.spectroscopy.property.modulation_relative_value.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.spectroscopy.property.modulation_relative_value.value', bool(new_val))


class RootCoreSpectroscopyPropertyAuto_recalibrate_probe_interval(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.auto_recalibrate_probe_interval'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.auto_recalibrate_probe_interval.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.auto_recalibrate_probe_interval.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.auto_recalibrate_probe_interval.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.auto_recalibrate_probe_interval.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_pause_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_pause_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_pause_sampling_rate.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_sampling_rate.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Fixed_Length = 0
        Stop_by_Value = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyBackward_modulation_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_modulation_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_modulation_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyRepetition_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.repetition_count'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.repetition_count.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.repetition_count.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.repetition_count.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.repetition_count.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_datapoints.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_datapoints.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_move_speed.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_move_speed.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_datapoints.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_datapoints.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_time.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_time.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Fixed_Length = 0
        Stop_by_Value = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyForward_modulation_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_modulation_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_modulation_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_stop_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Is_Less_Than = 0
        Is_Greater_Than = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_stop_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyBackward_modulation_stop_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_value.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_stop_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_stop_value.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_move_speed.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_move_speed.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_sampling_rate.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_sampling_rate.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_modulation_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_modulation_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.backward_modulation_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.backward_modulation_range.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_modulation_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_modulation_range.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_pause_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Z_On = 1
        Z_Off = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyForward_pause_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.forward_pause_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_pause_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_pause_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_pause_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertyForward_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_sampling_rate.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_sampling_rate.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.forward_modulation_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.forward_modulation_range.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_modulation_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_modulation_range.unit', str(new_val))


class RootCoreSpectroscopyPropertyModulation_output(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        External_Z = 2
        Tip_Voltage = 1
        Position_Z = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.modulation_output'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyModulation_output.ValueEnum(self._context.get('root.core.spectroscopy.property.modulation_output.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.modulation_output.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.modulation_output.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.modulation_output.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.modulation_output.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.modulation_output.enum', list(new_val))


class RootCoreSpectroscopyPropertyForward_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_pause_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_pause_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_pause_datapoints.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.forward_pause_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.forward_pause_datapoints.unit', str(new_val))


class RootCoreSpectroscopyPropertyStart_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.start_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.start_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.start_offset.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.start_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.start_offset.unit', str(new_val))


class RootCoreSpectroscopyPropertyBackward_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.backward_pause_datapoints'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.backward_pause_datapoints.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.backward_pause_datapoints.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.backward_pause_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.backward_pause_datapoints.unit', str(new_val))


class RootCoreSpectroscopyPropertyForward_modulation_stop_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Is_Less_Than = 0
        Is_Greater_Than = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.forward_modulation_stop_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreSpectroscopyPropertyForward_modulation_stop_mode.ValueEnum(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.spectroscopy.property.forward_modulation_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.spectroscopy.property.forward_modulation_stop_mode.enum', list(new_val))


class RootCoreSpectroscopyPropertySample_mask(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.sample_mask'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.spectroscopy.property.sample_mask.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.spectroscopy.property.sample_mask.value', int(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.sample_mask.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.sample_mask.unit', str(new_val))


class RootCoreSpectroscopyPropertyStart_offste_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property.start_offste_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.spectroscopy.property.start_offste_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.spectroscopy.property.start_offste_move_speed.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.spectroscopy.property.start_offste_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.spectroscopy.property.start_offste_move_speed.unit', str(new_val))


class RootCoreSpectroscopyProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.property'
        self.start_offste_move_speed = RootCoreSpectroscopyPropertyStart_offste_move_speed(self._context)
        self.sample_mask = RootCoreSpectroscopyPropertySample_mask(self._context)
        self.forward_modulation_stop_mode = RootCoreSpectroscopyPropertyForward_modulation_stop_mode(self._context)
        self.backward_pause_datapoints = RootCoreSpectroscopyPropertyBackward_pause_datapoints(self._context)
        self.start_offset = RootCoreSpectroscopyPropertyStart_offset(self._context)
        self.forward_pause_datapoints = RootCoreSpectroscopyPropertyForward_pause_datapoints(self._context)
        self.modulation_output = RootCoreSpectroscopyPropertyModulation_output(self._context)
        self.forward_modulation_range = RootCoreSpectroscopyPropertyForward_modulation_range(self._context)
        self.forward_sampling_rate = RootCoreSpectroscopyPropertyForward_sampling_rate(self._context)
        self.forward_pause_mode = RootCoreSpectroscopyPropertyForward_pause_mode(self._context)
        self.backward_modulation_range = RootCoreSpectroscopyPropertyBackward_modulation_range(self._context)
        self.backward_sampling_rate = RootCoreSpectroscopyPropertyBackward_sampling_rate(self._context)
        self.forward_move_speed = RootCoreSpectroscopyPropertyForward_move_speed(self._context)
        self.backward_modulation_stop_value = RootCoreSpectroscopyPropertyBackward_modulation_stop_value(self._context)
        self.backward_modulation_stop_mode = RootCoreSpectroscopyPropertyBackward_modulation_stop_mode(self._context)
        self.forward_modulation_mode = RootCoreSpectroscopyPropertyForward_modulation_mode(self._context)
        self.forward_modulation_time = RootCoreSpectroscopyPropertyForward_modulation_time(self._context)
        self.backward_datapoints = RootCoreSpectroscopyPropertyBackward_datapoints(self._context)
        self.backward_move_speed = RootCoreSpectroscopyPropertyBackward_move_speed(self._context)
        self.forward_datapoints = RootCoreSpectroscopyPropertyForward_datapoints(self._context)
        self.repetition_count = RootCoreSpectroscopyPropertyRepetition_count(self._context)
        self.backward_modulation_mode = RootCoreSpectroscopyPropertyBackward_modulation_mode(self._context)
        self.forward_pause_sampling_rate = RootCoreSpectroscopyPropertyForward_pause_sampling_rate(self._context)
        self.auto_recalibrate_probe_interval = RootCoreSpectroscopyPropertyAuto_recalibrate_probe_interval(self._context)
        self.modulation_relative_value = RootCoreSpectroscopyPropertyModulation_relative_value(self._context)
        self.backward_pause_sampling_rate = RootCoreSpectroscopyPropertyBackward_pause_sampling_rate(self._context)
        self.backward_modulation_time = RootCoreSpectroscopyPropertyBackward_modulation_time(self._context)
        self.backward_pause_time = RootCoreSpectroscopyPropertyBackward_pause_time(self._context)
        self.backward_pause_mode = RootCoreSpectroscopyPropertyBackward_pause_mode(self._context)
        self.forward_modulation_stop_value = RootCoreSpectroscopyPropertyForward_modulation_stop_value(self._context)
        self.xy_move_speed = RootCoreSpectroscopyPropertyXy_move_speed(self._context)
        self.spec_end_mode = RootCoreSpectroscopyPropertySpec_end_mode(self._context)
        self.forward_pause_time = RootCoreSpectroscopyPropertyForward_pause_time(self._context)
        self.feedback_active = RootCoreSpectroscopyPropertyFeedback_active(self._context)


class RootCoreSpectroscopySignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy.signal'


class RootCoreSpectroscopy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.spectroscopy'
        self.signal = RootCoreSpectroscopySignal(self._context)
        self.property = RootCoreSpectroscopyProperty(self._context)

    def start(self, *args) -> Any:
        return self._context.call('root.core.spectroscopy.start', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.spectroscopy.abort', *args)


class RootCoreZ_controllerPropertyActual_feedback_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.actual_feedback_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.actual_feedback_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.actual_feedback_value.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.actual_feedback_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.actual_feedback_value.unit', str(new_val))


class RootCoreZ_controllerPropertyD_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.d_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.d_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.d_gain.value', int(new_val))


class RootCoreZ_controllerPropertySetpoint(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.setpoint'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.setpoint.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.setpoint.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.setpoint.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.setpoint.unit', str(new_val))


class RootCoreZ_controllerPropertyI_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.i_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.i_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.i_gain.value', int(new_val))


class RootCoreZ_controllerPropertyMin_z_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.min_z_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.min_z_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.min_z_value.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.min_z_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.min_z_value.unit', str(new_val))


class RootCoreZ_controllerPropertyP_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.p_gain'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.z_controller.property.p_gain.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.z_controller.property.p_gain.value', int(new_val))


class RootCoreZ_controllerPropertyActual_tip_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.actual_tip_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.actual_tip_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.actual_tip_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.actual_tip_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.actual_tip_position.unit', str(new_val))


class RootCoreZ_controllerPropertyIdle_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Keep_Last_Z_Position = 2
        Retract_Tip = 1
        Absolute_Z_Position = 3
        Enable_Z_Controller = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.idle_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreZ_controllerPropertyIdle_mode.ValueEnum(self._context.get('root.core.z_controller.property.idle_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.z_controller.property.idle_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.z_controller.property.idle_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.z_controller.property.idle_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.idle_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.idle_mode.enum', list(new_val))


class RootCoreZ_controllerPropertyAbsolute_idle_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.absolute_idle_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.z_controller.property.absolute_idle_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.z_controller.property.absolute_idle_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.z_controller.property.absolute_idle_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.z_controller.property.absolute_idle_position.unit', str(new_val))


class RootCoreZ_controllerPropertyFeedback_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        negative = 1
        invalid = 2
        positive = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.feedback_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreZ_controllerPropertyFeedback_polarity.ValueEnum(self._context.get('root.core.z_controller.property.feedback_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.z_controller.property.feedback_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.z_controller.property.feedback_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.z_controller.property.feedback_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.feedback_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.feedback_polarity.enum', list(new_val))


class RootCoreZ_controllerPropertyFeedback(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Deflection = 0
        Dynamic_Mode_Amplitude_Reduction = 2
        WaveMode_Amplitude_Reduction = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.feedback'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreZ_controllerPropertyFeedback.ValueEnum(self._context.get('root.core.z_controller.property.feedback.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.z_controller.property.feedback.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.z_controller.property.feedback.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.z_controller.property.feedback.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.feedback.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.feedback.enum', list(new_val))


class RootCoreZ_controllerPropertyBase_work_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Control_Z_by_Z_Sensor = 0
        Control_Z_by_Measurement_Mode = 2
        Drive_Z = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property.base_work_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreZ_controllerPropertyBase_work_mode.ValueEnum(self._context.get('root.core.z_controller.property.base_work_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.z_controller.property.base_work_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.z_controller.property.base_work_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.z_controller.property.base_work_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.z_controller.property.base_work_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.z_controller.property.base_work_mode.enum', list(new_val))


class RootCoreZ_controllerProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.property'
        self.base_work_mode = RootCoreZ_controllerPropertyBase_work_mode(self._context)
        self.feedback = RootCoreZ_controllerPropertyFeedback(self._context)
        self.feedback_polarity = RootCoreZ_controllerPropertyFeedback_polarity(self._context)
        self.absolute_idle_position = RootCoreZ_controllerPropertyAbsolute_idle_position(self._context)
        self.idle_mode = RootCoreZ_controllerPropertyIdle_mode(self._context)
        self.actual_tip_position = RootCoreZ_controllerPropertyActual_tip_position(self._context)
        self.p_gain = RootCoreZ_controllerPropertyP_gain(self._context)
        self.min_z_value = RootCoreZ_controllerPropertyMin_z_value(self._context)
        self.i_gain = RootCoreZ_controllerPropertyI_gain(self._context)
        self.setpoint = RootCoreZ_controllerPropertySetpoint(self._context)
        self.d_gain = RootCoreZ_controllerPropertyD_gain(self._context)
        self.actual_feedback_value = RootCoreZ_controllerPropertyActual_feedback_value(self._context)


class RootCoreZ_controllerSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller.signal'


class RootCoreZ_controller(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.z_controller'
        self.signal = RootCoreZ_controllerSignal(self._context)
        self.property = RootCoreZ_controllerProperty(self._context)

    def tip_position_lower_limit(self, *args) -> Any:
        return self._context.call('root.core.z_controller.tip_position_lower_limit', *args)

    def retract_tip(self, *args) -> Any:
        return self._context.call('root.core.z_controller.retract_tip', *args)

    def setpoint_limits_from_calibration(self, *args) -> Any:
        return self._context.call('root.core.z_controller.setpoint_limits_from_calibration', *args)

    def setpoint_upper_limit(self, *args) -> Any:
        return self._context.call('root.core.z_controller.setpoint_upper_limit', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_pte_aligned(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_pte_aligned'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_pte_aligned.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_search_step_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_search_step_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_search_step_finished.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalCenter_detector_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.center_detector_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.center_detector_finished.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalMotor_move_started(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.motor_move_started'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_started.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalMotor_move_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.motor_move_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.motor_move_finished.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalProcedure_info(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.procedure_info'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.procedure_info.connect_extended', *args)


class RootCoreLaser_align_drive_implSignalAuto_align_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal.auto_align_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.signal.auto_align_finished.connect_extended', *args)


class RootCoreLaser_align_drive_implSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.signal'
        self.auto_align_finished = RootCoreLaser_align_drive_implSignalAuto_align_finished(self._context)
        self.procedure_info = RootCoreLaser_align_drive_implSignalProcedure_info(self._context)
        self.motor_move_finished = RootCoreLaser_align_drive_implSignalMotor_move_finished(self._context)
        self.motor_move_started = RootCoreLaser_align_drive_implSignalMotor_move_started(self._context)
        self.center_detector_finished = RootCoreLaser_align_drive_implSignalCenter_detector_finished(self._context)
        self.auto_align_search_step_finished = RootCoreLaser_align_drive_implSignalAuto_align_search_step_finished(self._context)
        self.auto_align_pte_aligned = RootCoreLaser_align_drive_implSignalAuto_align_pte_aligned(self._context)


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_amplitude.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_readout_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_readout_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_y_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyScan_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.scan_mode'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.scan_mode.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.scan_mode.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_focus(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_focus.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_laser_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_laser_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_laser_motors.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_enabled.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_beam_shifter(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_beam_shifter.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_beam_shifter_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_beam_shifter_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_beam_shifter_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertySensor_status(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Low = 1
        Fail = 4
        Undefined = 0
        Ok = 2
        High = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.sensor_status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreLaser_align_drive_implPropertySensor_status.ValueEnum(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.laser_align_drive_impl.property.sensor_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.laser_align_drive_impl.property.sensor_status.enum', list(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_y_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_x_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_readout_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_readout_enabled'
        self._lua_value_type = wrap.LuaType('bool')

    @property
    def value(self) -> bool:
        return bool(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_enabled.value'))

    @value.setter
    def value(self, new_val:bool):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_enabled.value', bool(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_readout_power(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_readout_power'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_power.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_power.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_readout_power.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_readout_power.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_photodetector_x_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_clean_drive_power(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_clean_drive_power'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_power.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_power.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_clean_drive_power.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_clean_drive_power.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_speed_max_laser_motors.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_y_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_clean_drive_y_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Calibration_Error = 1
        No_Error = 0
        Sensor_Signal_Failed = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_offset_calibration_status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status.ValueEnum(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_offset_calibration_status.enum', list(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_focus_z_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_focus_z_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_focus_z_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyLaser_spot_intensity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.laser_spot_intensity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.laser_spot_intensity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.laser_spot_intensity.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.laser_spot_intensity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.laser_spot_intensity.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyMotor_laser_readout_x_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.motor_laser_readout_x_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.motor_laser_readout_x_position.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_lateral(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_lateral'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.deflection_lateral.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_lateral.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.deflection_lateral.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_lateral.unit', str(new_val))


class RootCoreLaser_align_drive_implPropertyDeflection_normal(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property.deflection_normal'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.laser_align_drive_impl.property.deflection_normal.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_normal.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.laser_align_drive_impl.property.deflection_normal.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.laser_align_drive_impl.property.deflection_normal.unit', str(new_val))


class RootCoreLaser_align_drive_implProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl.property'
        self.deflection_normal = RootCoreLaser_align_drive_implPropertyDeflection_normal(self._context)
        self.deflection_lateral = RootCoreLaser_align_drive_implPropertyDeflection_lateral(self._context)
        self.motor_laser_readout_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_readout_x_position(self._context)
        self.laser_spot_intensity = RootCoreLaser_align_drive_implPropertyLaser_spot_intensity(self._context)
        self.motor_laser_focus_z_position = RootCoreLaser_align_drive_implPropertyMotor_laser_focus_z_position(self._context)
        self.deflection_offset_calibration_status = RootCoreLaser_align_drive_implPropertyDeflection_offset_calibration_status(self._context)
        self.motor_laser_clean_drive_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_y_position(self._context)
        self.motor_speed_max_laser_motors = RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_motors(self._context)
        self.laser_clean_drive_power = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_power(self._context)
        self.motor_laser_photodetector_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_x_position(self._context)
        self.laser_readout_power = RootCoreLaser_align_drive_implPropertyLaser_readout_power(self._context)
        self.laser_readout_enabled = RootCoreLaser_align_drive_implPropertyLaser_readout_enabled(self._context)
        self.motor_laser_clean_drive_x_position = RootCoreLaser_align_drive_implPropertyMotor_laser_clean_drive_x_position(self._context)
        self.motor_laser_photodetector_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_photodetector_y_position(self._context)
        self.sensor_status = RootCoreLaser_align_drive_implPropertySensor_status(self._context)
        self.motor_beam_shifter_position = RootCoreLaser_align_drive_implPropertyMotor_beam_shifter_position(self._context)
        self.motor_speed_max_beam_shifter = RootCoreLaser_align_drive_implPropertyMotor_speed_max_beam_shifter(self._context)
        self.laser_clean_drive_enabled = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_enabled(self._context)
        self.motor_speed_laser_motors = RootCoreLaser_align_drive_implPropertyMotor_speed_laser_motors(self._context)
        self.motor_speed_max_laser_focus = RootCoreLaser_align_drive_implPropertyMotor_speed_max_laser_focus(self._context)
        self.scan_mode = RootCoreLaser_align_drive_implPropertyScan_mode(self._context)
        self.motor_laser_readout_y_position = RootCoreLaser_align_drive_implPropertyMotor_laser_readout_y_position(self._context)
        self.laser_clean_drive_amplitude = RootCoreLaser_align_drive_implPropertyLaser_clean_drive_amplitude(self._context)


class RootCoreLaser_align_drive_impl(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.laser_align_drive_impl'
        self.property = RootCoreLaser_align_drive_implProperty(self._context)
        self.signal = RootCoreLaser_align_drive_implSignal(self._context)

    def stop_updating_detector_status(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.stop_updating_detector_status', *args)

    def start_move_to_optical_center(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_move_to_optical_center', *args)

    def auto_align(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.auto_align', *args)

    def move_motors_by_step(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.move_motors_by_step', *args)

    def zero_position(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.zero_position', *args)

    def stop_motors(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.stop_motors', *args)

    def start_updating_detector_status(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_updating_detector_status', *args)

    def start_moving_motors(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_moving_motors', *args)

    def center_detector(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.center_detector', *args)

    def abort_auto_align(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.abort_auto_align', *args)

    def start_search_algorithm(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_search_algorithm', *args)

    def reference_motor(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.reference_motor', *args)

    def start_optimizing(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.start_optimizing', *args)

    def abort_center_detector(self, *args) -> Any:
        return self._context.call('root.core.laser_align_drive_impl.abort_center_detector', *args)


class RootCoreApproach_motors_driveSignalMotor_move_finished(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal.motor_move_finished'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_finished.connect_extended', *args)


class RootCoreApproach_motors_driveSignalMotor_move_started(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal.motor_move_started'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.signal.motor_move_started.connect_extended', *args)


class RootCoreApproach_motors_driveSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.signal'
        self.motor_move_started = RootCoreApproach_motors_driveSignalMotor_move_started(self._context)
        self.motor_move_finished = RootCoreApproach_motors_driveSignalMotor_move_finished(self._context)


class RootCoreApproach_motors_drivePropertyMotor_speed_advance_retract(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed_advance_retract'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed_advance_retract.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_advance_retract.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed_advance_retract.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_advance_retract.unit', str(new_val))


class RootCoreApproach_motors_drivePropertyMotor_speed_approach_motors(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed_approach_motors'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed_approach_motors.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_approach_motors.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed_approach_motors.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed_approach_motors.unit', str(new_val))


class RootCoreApproach_motors_drivePropertyMotor_right_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_right_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_right_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_right_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_right_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_right_position.unit', str(new_val))


class RootCoreApproach_motors_drivePropertyRelative_tip_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.relative_tip_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.relative_tip_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.relative_tip_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.relative_tip_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.relative_tip_position.unit', str(new_val))


class RootCoreApproach_motors_drivePropertyMotor_front_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_front_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_front_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_front_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_front_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_front_position.unit', str(new_val))


class RootCoreApproach_motors_drivePropertyMotor_left_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_left_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_left_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_left_position.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_left_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_left_position.unit', str(new_val))


class RootCoreApproach_motors_drivePropertyMotor_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property.motor_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.approach_motors_drive.property.motor_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.approach_motors_drive.property.motor_speed.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.approach_motors_drive.property.motor_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.approach_motors_drive.property.motor_speed.unit', str(new_val))


class RootCoreApproach_motors_driveProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive.property'
        self.motor_speed = RootCoreApproach_motors_drivePropertyMotor_speed(self._context)
        self.motor_left_position = RootCoreApproach_motors_drivePropertyMotor_left_position(self._context)
        self.motor_front_position = RootCoreApproach_motors_drivePropertyMotor_front_position(self._context)
        self.relative_tip_position = RootCoreApproach_motors_drivePropertyRelative_tip_position(self._context)
        self.motor_right_position = RootCoreApproach_motors_drivePropertyMotor_right_position(self._context)
        self.motor_speed_approach_motors = RootCoreApproach_motors_drivePropertyMotor_speed_approach_motors(self._context)
        self.motor_speed_advance_retract = RootCoreApproach_motors_drivePropertyMotor_speed_advance_retract(self._context)


class RootCoreApproach_motors_drive(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.approach_motors_drive'
        self.property = RootCoreApproach_motors_driveProperty(self._context)
        self.signal = RootCoreApproach_motors_driveSignal(self._context)

    def stop_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.stop_motors', *args)

    def start_moving_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.start_moving_motors', *args)

    def move_motors_by_step(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.move_motors_by_step', *args)

    def zero_position(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.zero_position', *args)

    def reference_motors(self, *args) -> Any:
        return self._context.call('root.core.approach_motors_drive.reference_motors', *args)


class RootCoreCore_cantileverPropertySelected_cantilever_spring_constant(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property.selected_cantilever_spring_constant'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.core_cantilever.property.selected_cantilever_spring_constant.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_spring_constant.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.core_cantilever.property.selected_cantilever_spring_constant.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_spring_constant.unit', str(new_val))


class RootCoreCore_cantileverPropertySelected_cantilever_deflection_sensitivity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.core_cantilever.property.selected_cantilever_deflection_sensitivity.unit', str(new_val))


class RootCoreCore_cantileverProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever.property'
        self.selected_cantilever_deflection_sensitivity = RootCoreCore_cantileverPropertySelected_cantilever_deflection_sensitivity(self._context)
        self.selected_cantilever_spring_constant = RootCoreCore_cantileverPropertySelected_cantilever_spring_constant(self._context)


class RootCoreCore_cantilever(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_cantilever'
        self.property = RootCoreCore_cantileverProperty(self._context)

    def select_cantilever(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.select_cantilever', *args)

    def selected_cantilever(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.selected_cantilever', *args)

    def apply(self, *args) -> Any:
        return self._context.call('root.core.core_cantilever.apply', *args)


class RootCoreFrequency_sweepSignalNew_fit_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.new_fit_data'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_fit_data.connect_extended', *args)


class RootCoreFrequency_sweepSignalNew_sweep_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.new_sweep_data'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.new_sweep_data.connect_extended', *args)


class RootCoreFrequency_sweepSignalProcess_sweep_data(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.process_sweep_data'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.process_sweep_data.connect_extended', *args)


class RootCoreFrequency_sweepSignalSho_fit_failed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sho_fit_failed'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sho_fit_failed.connect_extended', *args)


class RootCoreFrequency_sweepSignalData_invalidated(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.data_invalidated'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.data_invalidated.connect_extended', *args)


class RootCoreFrequency_sweepSignalSweep_progress(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sweep_progress'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_progress.connect_extended', *args)


class RootCoreFrequency_sweepSignalSweep_ended(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal.sweep_ended'

    def empty(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.empty', *args)

    def connect(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.connect', *args)

    def call(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.call', *args)

    def connect_extended(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.signal.sweep_ended.connect_extended', *args)


class RootCoreFrequency_sweepSignal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.signal'
        self.sweep_ended = RootCoreFrequency_sweepSignalSweep_ended(self._context)
        self.sweep_progress = RootCoreFrequency_sweepSignalSweep_progress(self._context)
        self.data_invalidated = RootCoreFrequency_sweepSignalData_invalidated(self._context)
        self.sho_fit_failed = RootCoreFrequency_sweepSignalSho_fit_failed(self._context)
        self.process_sweep_data = RootCoreFrequency_sweepSignalProcess_sweep_data(self._context)
        self.new_sweep_data = RootCoreFrequency_sweepSignalNew_sweep_data(self._context)
        self.new_fit_data = RootCoreFrequency_sweepSignalNew_fit_data(self._context)


class RootCoreFrequency_sweepPropertyFrequency_selection_criteria(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Below_Peak = 0
        Above_Peak = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.frequency_selection_criteria'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreFrequency_sweepPropertyFrequency_selection_criteria.ValueEnum(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.frequency_selection_criteria.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.frequency_selection_criteria.enum', list(new_val))


class RootCoreFrequency_sweepPropertyNew_spring_constant(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.new_spring_constant'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.new_spring_constant.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.new_spring_constant.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.new_spring_constant.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.new_spring_constant.unit', str(new_val))


class RootCoreFrequency_sweepPropertyAmplitude_unit(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Volts_V_ = 1
        Meters_m_ = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.amplitude_unit'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreFrequency_sweepPropertyAmplitude_unit.ValueEnum(self._context.get('root.core.frequency_sweep.property.amplitude_unit.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.amplitude_unit.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.amplitude_unit.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.amplitude_unit.enum', list(new_val))


class RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        num_360_Hz = 5
        num_12_kHz = 10
        num_180_Hz = 4
        num_230_kHz = 14
        num_500_kHz = 15
        num_1500_Hz = 7
        num_750_Hz = 6
        num_100_kHz = 13
        num_3_kHz = 8
        num_23_kHz = 11
        num_45_kHz = 12
        num_6_kHz = 9
        num_90_Hz = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.analyzer_demodulator_bandwidth'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth.ValueEnum(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.analyzer_demodulator_bandwidth.enum', list(new_val))


class RootCoreFrequency_sweepPropertySweep_data_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_data_points'
        self._lua_value_type = wrap.LuaType('int')

    @property
    def value(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.sweep_data_points.value'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.sweep_data_points.value', int(new_val))


class RootCoreFrequency_sweepPropertyAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.amplitude_reduction.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.amplitude_reduction.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.amplitude_reduction.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.amplitude_reduction.unit', str(new_val))


class RootCoreFrequency_sweepPropertyNew_excitation_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.new_excitation_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.new_excitation_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.new_excitation_frequency.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.new_excitation_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.new_excitation_frequency.unit', str(new_val))


class RootCoreFrequency_sweepPropertySweep_free_vibration_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_free_vibration_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_free_vibration_amplitude.unit', str(new_val))


class RootCoreFrequency_sweepPropertySweep_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_lower_bound.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_lower_bound.unit', str(new_val))


class RootCoreFrequency_sweepPropertyFit_frequency_lower_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.fit_frequency_lower_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.fit_frequency_lower_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_lower_bound.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.fit_frequency_lower_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_lower_bound.unit', str(new_val))


class RootCoreFrequency_sweepPropertyTemperature(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.temperature'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.temperature.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.temperature.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.temperature.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.temperature.unit', str(new_val))


class RootCoreFrequency_sweepPropertySweep_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_upper_bound.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_frequency_upper_bound.unit', str(new_val))


class RootCoreFrequency_sweepPropertySweep_excitation_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.sweep_excitation_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.sweep_excitation_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.sweep_excitation_amplitude.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.sweep_excitation_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.sweep_excitation_amplitude.unit', str(new_val))


class RootCoreFrequency_sweepPropertyFit_frequency_upper_bound(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.fit_frequency_upper_bound'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def value(self) -> float:
        return float(self._context.get('root.core.frequency_sweep.property.fit_frequency_upper_bound.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_upper_bound.value', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.core.frequency_sweep.property.fit_frequency_upper_bound.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.core.frequency_sweep.property.fit_frequency_upper_bound.unit', str(new_val))


class RootCoreFrequency_sweepPropertyMeasurement_environment(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        Air = 0
        Liquid = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property.measurement_environment'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootCoreFrequency_sweepPropertyMeasurement_environment.ValueEnum(self._context.get('root.core.frequency_sweep.property.measurement_environment.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.core.frequency_sweep.property.measurement_environment.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.core.frequency_sweep.property.measurement_environment.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.core.frequency_sweep.property.measurement_environment.enum', list(new_val))


class RootCoreFrequency_sweepProperty(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep.property'
        self.measurement_environment = RootCoreFrequency_sweepPropertyMeasurement_environment(self._context)
        self.fit_frequency_upper_bound = RootCoreFrequency_sweepPropertyFit_frequency_upper_bound(self._context)
        self.sweep_excitation_amplitude = RootCoreFrequency_sweepPropertySweep_excitation_amplitude(self._context)
        self.sweep_frequency_upper_bound = RootCoreFrequency_sweepPropertySweep_frequency_upper_bound(self._context)
        self.temperature = RootCoreFrequency_sweepPropertyTemperature(self._context)
        self.fit_frequency_lower_bound = RootCoreFrequency_sweepPropertyFit_frequency_lower_bound(self._context)
        self.sweep_frequency_lower_bound = RootCoreFrequency_sweepPropertySweep_frequency_lower_bound(self._context)
        self.sweep_free_vibration_amplitude = RootCoreFrequency_sweepPropertySweep_free_vibration_amplitude(self._context)
        self.new_excitation_frequency = RootCoreFrequency_sweepPropertyNew_excitation_frequency(self._context)
        self.amplitude_reduction = RootCoreFrequency_sweepPropertyAmplitude_reduction(self._context)
        self.sweep_data_points = RootCoreFrequency_sweepPropertySweep_data_points(self._context)
        self.analyzer_demodulator_bandwidth = RootCoreFrequency_sweepPropertyAnalyzer_demodulator_bandwidth(self._context)
        self.amplitude_unit = RootCoreFrequency_sweepPropertyAmplitude_unit(self._context)
        self.new_spring_constant = RootCoreFrequency_sweepPropertyNew_spring_constant(self._context)
        self.frequency_selection_criteria = RootCoreFrequency_sweepPropertyFrequency_selection_criteria(self._context)


class RootCoreFrequency_sweep(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.frequency_sweep'
        self.property = RootCoreFrequency_sweepProperty(self._context)
        self.signal = RootCoreFrequency_sweepSignal(self._context)

    def start(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.start', *args)

    def do_sho_fit(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.do_sho_fit', *args)

    def invalidate_sweep_and_fit_data(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.invalidate_sweep_and_fit_data', *args)

    def abort(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.abort', *args)

    def convert_and_emit_sweep_data(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.convert_and_emit_sweep_data', *args)

    def set_sweep_parameters(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.set_sweep_parameters', *args)

    def calculate_spring_constant(self, *args) -> Any:
        return self._context.call('root.core.frequency_sweep.calculate_spring_constant', *args)


class RootCoreCore_monitoring(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.core_monitoring'


class RootCoreSignal_analyzer1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_analyzer1'


class RootCoreHv_amp_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.hv_amp_control'


class RootCorePosition_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.position_control'


class RootCoreSignal_registration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core.signal_registration'


class RootCore(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.core'
        self.signal_registration = RootCoreSignal_registration(self._context)
        self.position_control = RootCorePosition_control(self._context)
        self.hv_amp_control = RootCoreHv_amp_control(self._context)
        self.signal_analyzer1 = RootCoreSignal_analyzer1(self._context)
        self.core_monitoring = RootCoreCore_monitoring(self._context)
        self.frequency_sweep = RootCoreFrequency_sweep(self._context)
        self.core_cantilever = RootCoreCore_cantilever(self._context)
        self.approach_motors_drive = RootCoreApproach_motors_drive(self._context)
        self.laser_align_drive_impl = RootCoreLaser_align_drive_impl(self._context)
        self.z_controller = RootCoreZ_controller(self._context)
        self.spectroscopy = RootCoreSpectroscopy(self._context)
        self.comp_dc = RootCoreComp_dc(self._context)
        self.core_options = RootCoreCore_options(self._context)
        self.ort = RootCoreOrt(self._context)
        self.approach = RootCoreApproach(self._context)
        self.thermal_tune = RootCoreThermal_tune(self._context)
        self.imaging = RootCoreImaging(self._context)
        self.signal_store = RootCoreSignal_store(self._context)
        self.acquisition = RootCoreAcquisition(self._context)
        self.scan_head_calibration = RootCoreScan_head_calibration(self._context)
        self.oscilloscope = RootCoreOscilloscope(self._context)
        self.direct_motor_control = RootCoreDirect_motor_control(self._context)
        self.core_environment = RootCoreCore_environment(self._context)
        self.converter_channel_correction = RootCoreConverter_channel_correction(self._context)


class RootLuApproachInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.busy'


class RootLuApproachInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.trigger'

    def start_adjust_tip_pos(self) -> None:
        return self._context.call('root.lu.approach.instance.trigger.start_adjust_tip_pos')

    def start_approach_afm(self) -> None:
        return self._context.call('root.lu.approach.instance.trigger.start_approach_afm')

    def start_pre_approach(self) -> None:
        return self._context.call('root.lu.approach.instance.trigger.start_pre_approach')

    def start_approach_steps(self) -> None:
        return self._context.call('root.lu.approach.instance.trigger.start_approach_steps')

    def start_approach_motor(self) -> None:
        return self._context.call('root.lu.approach.instance.trigger.start_approach_motor')

    def user_done(self) -> None:
        return self._context.call('root.lu.approach.instance.trigger.user_done')

    def user_abort(self) -> None:
        return self._context.call('root.lu.approach.instance.trigger.user_abort')


class RootLuApproachInstanceAttributeRelease_tip(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.release_tip'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.release_tip.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.release_tip.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.release_tip.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.release_tip.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.release_tip.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.release_tip.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.release_tip.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.release_tip.value', float(new_val))


class RootLuApproachInstanceAttributeStep_by_step_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_by_step_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_by_step_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.step_by_step_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_by_step_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_time.value', float(new_val))


class RootLuApproachInstanceAttributeStep_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_period.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_period.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_period.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_period.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.step_period.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.step_period.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_period.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_period.value', float(new_val))


class RootLuApproachInstanceAttributeStep_by_step_fine_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_fine_step_size_percentage.value', float(new_val))


class RootLuApproachInstanceAttributeCurrent_z_stage_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.current_z_stage_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.current_z_stage_pos.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.current_z_stage_pos.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.current_z_stage_pos.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.current_z_stage_pos.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.current_z_stage_pos.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.current_z_stage_pos.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.current_z_stage_pos.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.current_z_stage_pos.value', float(new_val))


class RootLuApproachInstanceAttributeApproach_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.approach_pos.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.approach_pos.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.approach_pos.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.approach_pos.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.approach_pos.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.approach_pos.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.approach_pos.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.approach_pos.value', float(new_val))


class RootLuApproachInstanceAttributeRetract_tip(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.retract_tip'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.retract_tip.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.retract_tip.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.retract_tip.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.retract_tip.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.retract_tip.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.retract_tip.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.retract_tip.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.retract_tip.value', float(new_val))


class RootLuApproachInstanceAttributeStep_by_step_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        tip_position_ignored = 2
        position_controlled = 0
        not_controlled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuApproachInstanceAttributeStep_by_step_mode.ValueEnum(self._context.get('root.lu.approach.instance.attribute.step_by_step_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.step_by_step_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.approach.instance.attribute.step_by_step_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_mode.enum', list(new_val))


class RootLuApproachInstanceAttributeAfm_approach_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        continuous = 0
        step_by_step = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.afm_approach_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuApproachInstanceAttributeAfm_approach_mode.ValueEnum(self._context.get('root.lu.approach.instance.attribute.afm_approach_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.approach.instance.attribute.afm_approach_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.afm_approach_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.afm_approach_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.approach.instance.attribute.afm_approach_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.approach.instance.attribute.afm_approach_mode.enum', list(new_val))


class RootLuApproachInstanceAttributeWithdraw_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.withdraw_steps'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.withdraw_steps.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.withdraw_steps.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.withdraw_steps.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.withdraw_steps.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.withdraw_steps.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.withdraw_steps.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.withdraw_steps.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.withdraw_steps.value', float(new_val))


class RootLuApproachInstanceAttributeApproach_result(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        timeout = 9
        limit_switch_error = 4
        user_abort = 5
        park_position = 8
        tip_pos_adjust_failed = 7
        end_of_travel = 2
        tip_pos_adjust_done = 6
        sensor_error = 3
        no_error = 0
        approach_done = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_result'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuApproachInstanceAttributeApproach_result.ValueEnum(self._context.get('root.lu.approach.instance.attribute.approach_result.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.approach.instance.attribute.approach_result.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_result.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_result.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.approach.instance.attribute.approach_result.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.approach.instance.attribute.approach_result.enum', list(new_val))


class RootLuApproachInstanceAttributeApproach_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.approach_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.approach_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.approach_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.approach_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.approach_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.approach_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.approach_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.approach_speed.value', float(new_val))


class RootLuApproachInstanceAttributeApproach_pos_error(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_pos_error'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.approach_pos_error.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.approach_pos_error.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.approach_pos_error.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.approach_pos_error.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.approach_pos_error.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.approach_pos_error.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.approach_pos_error.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.approach_pos_error.value', float(new_val))


class RootLuApproachInstanceAttributeStep_by_step_slope(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_slope'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_by_step_slope.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_slope.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_by_step_slope.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_slope.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.step_by_step_slope.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_slope.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_by_step_slope.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_slope.value', float(new_val))


class RootLuApproachInstanceAttributeApproach_status(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        max_out = 13
        user_abort = 12
        limit_failed = 10
        home_position_reached = 6
        cancel_dialog = 17
        approach_done = 3
        process_dialog = 16
        timeout = 18
        init_done = 14
        calibration_failed = 11
        approach_aborted = 4
        sensor_failed = 9
        move_toward = 8
        approaching = 2
        move_to_home_position = 5
        adjusting_tip_pos = 15
        move_away = 7
        idle = 0
        initializing = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuApproachInstanceAttributeApproach_status.ValueEnum(self._context.get('root.lu.approach.instance.attribute.approach_status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.approach.instance.attribute.approach_status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.approach_status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.approach_status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.approach.instance.attribute.approach_status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.approach.instance.attribute.approach_status.enum', list(new_val))


class RootLuApproachInstanceAttributeEnable_pre_approach_xycl_calibration(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.enable_pre_approach_xycl_calibration.value', float(new_val))


class RootLuApproachInstanceAttributeStepper_direction(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        forward = 0
        backward = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.stepper_direction'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuApproachInstanceAttributeStepper_direction.ValueEnum(self._context.get('root.lu.approach.instance.attribute.stepper_direction.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.approach.instance.attribute.stepper_direction.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.stepper_direction.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.stepper_direction.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.approach.instance.attribute.stepper_direction.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.approach.instance.attribute.stepper_direction.enum', list(new_val))


class RootLuApproachInstanceAttributeApproach_steps(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.approach_steps'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.approach_steps.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.approach_steps.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.approach_steps.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.approach_steps.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.approach_steps.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.approach_steps.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.approach_steps.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.approach_steps.value', float(new_val))


class RootLuApproachInstanceAttributeStep_by_step_coarse_step_size_percentage(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.approach.instance.attribute.step_by_step_coarse_step_size_percentage.value', float(new_val))


class RootLuApproachInstanceAttributeMotor_source(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        internal = 0
        external = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute.motor_source'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuApproachInstanceAttributeMotor_source.ValueEnum(self._context.get('root.lu.approach.instance.attribute.motor_source.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.approach.instance.attribute.motor_source.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.approach.instance.attribute.motor_source.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.approach.instance.attribute.motor_source.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.approach.instance.attribute.motor_source.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.approach.instance.attribute.motor_source.enum', list(new_val))


class RootLuApproachInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance.attribute'
        self.motor_source = RootLuApproachInstanceAttributeMotor_source(self._context)
        self.step_by_step_coarse_step_size_percentage = RootLuApproachInstanceAttributeStep_by_step_coarse_step_size_percentage(self._context)
        self.approach_steps = RootLuApproachInstanceAttributeApproach_steps(self._context)
        self.stepper_direction = RootLuApproachInstanceAttributeStepper_direction(self._context)
        self.enable_pre_approach_xycl_calibration = RootLuApproachInstanceAttributeEnable_pre_approach_xycl_calibration(self._context)
        self.approach_status = RootLuApproachInstanceAttributeApproach_status(self._context)
        self.step_by_step_slope = RootLuApproachInstanceAttributeStep_by_step_slope(self._context)
        self.approach_pos_error = RootLuApproachInstanceAttributeApproach_pos_error(self._context)
        self.approach_speed = RootLuApproachInstanceAttributeApproach_speed(self._context)
        self.approach_result = RootLuApproachInstanceAttributeApproach_result(self._context)
        self.withdraw_steps = RootLuApproachInstanceAttributeWithdraw_steps(self._context)
        self.afm_approach_mode = RootLuApproachInstanceAttributeAfm_approach_mode(self._context)
        self.step_by_step_mode = RootLuApproachInstanceAttributeStep_by_step_mode(self._context)
        self.retract_tip = RootLuApproachInstanceAttributeRetract_tip(self._context)
        self.approach_pos = RootLuApproachInstanceAttributeApproach_pos(self._context)
        self.current_z_stage_pos = RootLuApproachInstanceAttributeCurrent_z_stage_pos(self._context)
        self.step_by_step_fine_step_size_percentage = RootLuApproachInstanceAttributeStep_by_step_fine_step_size_percentage(self._context)
        self.step_period = RootLuApproachInstanceAttributeStep_period(self._context)
        self.step_by_step_time = RootLuApproachInstanceAttributeStep_by_step_time(self._context)
        self.release_tip = RootLuApproachInstanceAttributeRelease_tip(self._context)


class RootLuApproachInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach.instance'
        self.attribute = RootLuApproachInstanceAttribute(self._context)
        self.trigger = RootLuApproachInstanceTrigger(self._context)
        self.busy = RootLuApproachInstanceBusy(self._context)


class RootLuApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.approach'
        self.instance = RootLuApproachInstance(self._context)


class RootLuSystemInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.busy'


class RootLuSystemInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger'

    def exit_spec(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.exit_spec')

    def entry_scan(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.entry_scan')

    def start_system_startup(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.start_system_startup')

    def motor_step(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.motor_step')

    def entry_approach(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.entry_approach')

    def exit_approach(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.exit_approach')

    def exit_idle(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.exit_idle')

    def entry_macro_cmd(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.entry_macro_cmd')

    def force_motor_pos_update(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.force_motor_pos_update')

    def exit_macro_cmd(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.exit_macro_cmd')

    def exit_litho(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.exit_litho')

    def entry_litho(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.entry_litho')

    def entry_idle(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.entry_idle')

    def entry_uncal(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.entry_uncal')

    def exit_uncal(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.exit_uncal')

    def motor_set_pos_zero(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.motor_set_pos_zero')

    def motor_reference(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.motor_reference')

    def motor_stop(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.motor_stop')

    def offset_xyz(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.offset_xyz')

    def motor_reference_and_move_back(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.motor_reference_and_move_back')

    def motor_move(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.motor_move')

    def level_scanhead(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.level_scanhead')

    def entry_spec(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.entry_spec')

    def exit_scan(self) -> None:
        return self._context.call('root.lu.system.instance.trigger.exit_scan')


class RootLuSystemInstanceAttributeOperating_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fm_dynamic_afm = 11
        static_afm = 2
        resistivity_map = 6
        const_phase = 7
        lateral_force = 9
        phase_contrast = 4
        user_defined = 10
        force_modulation = 5
        stm = 1
        undefined = 0
        dynamic_afm = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.operating_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSystemInstanceAttributeOperating_mode.ValueEnum(self._context.get('root.lu.system.instance.attribute.operating_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.system.instance.attribute.operating_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.operating_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.system.instance.attribute.operating_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.system.instance.attribute.operating_mode.enum', list(new_val))


class RootLuSystemInstanceAttributeMotor_step_size(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_step_size'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.motor_step_size.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.motor_step_size.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.motor_step_size.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.motor_step_size.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.system.instance.attribute.motor_step_size.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.system.instance.attribute.motor_step_size.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.motor_step_size.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.motor_step_size.value', float(new_val))


class RootLuSystemInstanceAttributeIdle_position_xy_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        image_center = 0
        keep_last_xy_pos = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_xy_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSystemInstanceAttributeIdle_position_xy_mode.ValueEnum(self._context.get('root.lu.system.instance.attribute.idle_position_xy_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.system.instance.attribute.idle_position_xy_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_xy_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_xy_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.system.instance.attribute.idle_position_xy_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.system.instance.attribute.idle_position_xy_mode.enum', list(new_val))


class RootLuSystemInstanceAttributeMotor_move_speed_factor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_move_speed_factor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.motor_move_speed_factor.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.motor_move_speed_factor.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.motor_move_speed_factor.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.motor_move_speed_factor.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.system.instance.attribute.motor_move_speed_factor.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.system.instance.attribute.motor_move_speed_factor.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.motor_move_speed_factor.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.motor_move_speed_factor.value', float(new_val))


class RootLuSystemInstanceAttributeSystem_state(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        internal = 7
        uncal = 0
        macro_cmd = 6
        idle = 1
        scan = 3
        litho = 5
        approach = 2
        spec = 4

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.system_state'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSystemInstanceAttributeSystem_state.ValueEnum(self._context.get('root.lu.system.instance.attribute.system_state.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.system.instance.attribute.system_state.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.system.instance.attribute.system_state.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.system.instance.attribute.system_state.enum', list(new_val))


class RootLuSystemInstanceAttributeMemory_available(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.memory_available'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.memory_available.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.memory_available.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.memory_available.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.memory_available.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.system.instance.attribute.memory_available.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.system.instance.attribute.memory_available.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.memory_available.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.memory_available.value', float(new_val))


class RootLuSystemInstanceAttributeZ_axis_ctrl_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position_drive = 1
        position_sensing = 2
        undefined = 0
        position_control = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.z_axis_ctrl_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSystemInstanceAttributeZ_axis_ctrl_mode.ValueEnum(self._context.get('root.lu.system.instance.attribute.z_axis_ctrl_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.system.instance.attribute.z_axis_ctrl_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.z_axis_ctrl_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.z_axis_ctrl_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.system.instance.attribute.z_axis_ctrl_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.system.instance.attribute.z_axis_ctrl_mode.enum', list(new_val))


class RootLuSystemInstanceAttributeMemory_block_available(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.memory_block_available'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.memory_block_available.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.memory_block_available.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.memory_block_available.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.memory_block_available.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.system.instance.attribute.memory_block_available.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.system.instance.attribute.memory_block_available.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.memory_block_available.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.memory_block_available.value', float(new_val))


class RootLuSystemInstanceAttributeHi_res_ch4_input(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.hi_res_ch4_input'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.hi_res_ch4_input.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.hi_res_ch4_input.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.hi_res_ch4_input.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.hi_res_ch4_input.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.system.instance.attribute.hi_res_ch4_input.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.system.instance.attribute.hi_res_ch4_input.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.hi_res_ch4_input.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.hi_res_ch4_input.value', float(new_val))


class RootLuSystemInstanceAttributeMeasurement_environment(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        air = 0
        liquid = 1
        vacuum = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.measurement_environment'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSystemInstanceAttributeMeasurement_environment.ValueEnum(self._context.get('root.lu.system.instance.attribute.measurement_environment.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.system.instance.attribute.measurement_environment.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.measurement_environment.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.measurement_environment.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.system.instance.attribute.measurement_environment.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.system.instance.attribute.measurement_environment.enum', list(new_val))


class RootLuSystemInstanceAttributeIdle_position_z_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        z_controller_active = 0
        retract_tip = 1
        absolute_z_pos = 3
        keep_last_z_pos = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_z_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSystemInstanceAttributeIdle_position_z_mode.ValueEnum(self._context.get('root.lu.system.instance.attribute.idle_position_z_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.system.instance.attribute.idle_position_z_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_z_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_z_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.system.instance.attribute.idle_position_z_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.system.instance.attribute.idle_position_z_mode.enum', list(new_val))


class RootLuSystemInstanceAttributeIdle_position_z(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_z'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.idle_position_z.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.idle_position_z.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.idle_position_z.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.idle_position_z.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.system.instance.attribute.idle_position_z.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.system.instance.attribute.idle_position_z.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.idle_position_z.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.idle_position_z.value', float(new_val))


class RootLuSystemInstanceAttributeOp_mode_kpfm_enabled(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        disabled = 0
        enabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.op_mode_kpfm_enabled'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSystemInstanceAttributeOp_mode_kpfm_enabled.ValueEnum(self._context.get('root.lu.system.instance.attribute.op_mode_kpfm_enabled.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.system.instance.attribute.op_mode_kpfm_enabled.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.op_mode_kpfm_enabled.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.op_mode_kpfm_enabled.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.system.instance.attribute.op_mode_kpfm_enabled.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.system.instance.attribute.op_mode_kpfm_enabled.enum', list(new_val))


class RootLuSystemInstanceAttributeMotor_selection(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        motor_photodiode_lateral = 9
        motor_c = 3
        motor_b = 2
        motor_lens_gimbal = 11
        motor_beam_deflection_x = 7
        motor_beam_deflection_y = 8
        motor_approach = 0
        motor_a = 1
        motor_ptex = 5
        motor_ptey = 6
        motor_photodiode_normal = 10
        motor_focus = 4

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_selection'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSystemInstanceAttributeMotor_selection.ValueEnum(self._context.get('root.lu.system.instance.attribute.motor_selection.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.system.instance.attribute.motor_selection.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.system.instance.attribute.motor_selection.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum', list(new_val))


class RootLuSystemInstanceAttributeHi_res_ch5_input(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.hi_res_ch5_input'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.hi_res_ch5_input.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.hi_res_ch5_input.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.hi_res_ch5_input.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.hi_res_ch5_input.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.system.instance.attribute.hi_res_ch5_input.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.system.instance.attribute.hi_res_ch5_input.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.hi_res_ch5_input.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.hi_res_ch5_input.value', float(new_val))


class RootLuSystemInstanceAttributeMotor_move_direction(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_move_direction'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSystemInstanceAttributeMotor_move_direction.ValueEnum(self._context.get('root.lu.system.instance.attribute.motor_move_direction.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.system.instance.attribute.motor_move_direction.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_move_direction.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_move_direction.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.system.instance.attribute.motor_move_direction.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.system.instance.attribute.motor_move_direction.enum', list(new_val))


class RootLuSystemInstanceAttributeIdle_external_z(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_external_z'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.idle_external_z.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.idle_external_z.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.idle_external_z.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.idle_external_z.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.system.instance.attribute.idle_external_z.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.system.instance.attribute.idle_external_z.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.system.instance.attribute.idle_external_z.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.system.instance.attribute.idle_external_z.value', float(new_val))


class RootLuSystemInstanceAttributeIdle_external_z_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        z_controller_active = 0
        retract_tip = 1
        absolute_z_pos = 3
        keep_last_z_pos = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_external_z_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSystemInstanceAttributeIdle_external_z_mode.ValueEnum(self._context.get('root.lu.system.instance.attribute.idle_external_z_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.system.instance.attribute.idle_external_z_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_external_z_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_external_z_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.system.instance.attribute.idle_external_z_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.system.instance.attribute.idle_external_z_mode.enum', list(new_val))


class RootLuSystemInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute'
        self.idle_external_z_mode = RootLuSystemInstanceAttributeIdle_external_z_mode(self._context)
        self.idle_external_z = RootLuSystemInstanceAttributeIdle_external_z(self._context)
        self.motor_move_direction = RootLuSystemInstanceAttributeMotor_move_direction(self._context)
        self.hi_res_ch5_input = RootLuSystemInstanceAttributeHi_res_ch5_input(self._context)
        self.motor_selection = RootLuSystemInstanceAttributeMotor_selection(self._context)
        self.op_mode_kpfm_enabled = RootLuSystemInstanceAttributeOp_mode_kpfm_enabled(self._context)
        self.idle_position_z = RootLuSystemInstanceAttributeIdle_position_z(self._context)
        self.idle_position_z_mode = RootLuSystemInstanceAttributeIdle_position_z_mode(self._context)
        self.measurement_environment = RootLuSystemInstanceAttributeMeasurement_environment(self._context)
        self.hi_res_ch4_input = RootLuSystemInstanceAttributeHi_res_ch4_input(self._context)
        self.memory_block_available = RootLuSystemInstanceAttributeMemory_block_available(self._context)
        self.z_axis_ctrl_mode = RootLuSystemInstanceAttributeZ_axis_ctrl_mode(self._context)
        self.memory_available = RootLuSystemInstanceAttributeMemory_available(self._context)
        self.system_state = RootLuSystemInstanceAttributeSystem_state(self._context)
        self.motor_move_speed_factor = RootLuSystemInstanceAttributeMotor_move_speed_factor(self._context)
        self.idle_position_xy_mode = RootLuSystemInstanceAttributeIdle_position_xy_mode(self._context)
        self.motor_step_size = RootLuSystemInstanceAttributeMotor_step_size(self._context)
        self.operating_mode = RootLuSystemInstanceAttributeOperating_mode(self._context)


class RootLuSystemInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance'
        self.attribute = RootLuSystemInstanceAttribute(self._context)
        self.trigger = RootLuSystemInstanceTrigger(self._context)
        self.busy = RootLuSystemInstanceBusy(self._context)


class RootLuSystem(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system'
        self.instance = RootLuSystemInstance(self._context)


class RootLuAuto_alignmentInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.busy'


class RootLuAuto_alignmentInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.trigger'

    def start_optimization(self) -> None:
        return self._context.call('root.lu.auto_alignment.instance.trigger.start_optimization')

    def start_move_to_optical_center(self) -> None:
        return self._context.call('root.lu.auto_alignment.instance.trigger.start_move_to_optical_center')

    def start_search_algorithm(self) -> None:
        return self._context.call('root.lu.auto_alignment.instance.trigger.start_search_algorithm')

    def start_align(self) -> None:
        return self._context.call('root.lu.auto_alignment.instance.trigger.start_align')

    def user_abort(self) -> None:
        return self._context.call('root.lu.auto_alignment.instance.trigger.user_abort')


class RootLuAuto_alignmentInstanceAttributePte_optical_center_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.pte_optical_center_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.auto_alignment.instance.attribute.pte_optical_center_x.value', float(new_val))


class RootLuAuto_alignmentInstanceAttributeComponent_state(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        coarse_positioning_x = 4
        idle_not_positioned = 0
        searching = 3
        idle_positioned = 1
        optimizing = 6
        configuring = 2
        coarse_positioning_y = 5

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.component_state'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAuto_alignmentInstanceAttributeComponent_state.ValueEnum(self._context.get('root.lu.auto_alignment.instance.attribute.component_state.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.auto_alignment.instance.attribute.component_state.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.auto_alignment.instance.attribute.component_state.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.auto_alignment.instance.attribute.component_state.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.auto_alignment.instance.attribute.component_state.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.auto_alignment.instance.attribute.component_state.enum', list(new_val))


class RootLuAuto_alignmentInstanceAttributeReadout_optical_center_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.readout_optical_center_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.auto_alignment.instance.attribute.readout_optical_center_y.value', float(new_val))


class RootLuAuto_alignmentInstanceAttributeAlign_state(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        failed = 2
        running = 1
        aligned_successfully = 3
        idle = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.align_state'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAuto_alignmentInstanceAttributeAlign_state.ValueEnum(self._context.get('root.lu.auto_alignment.instance.attribute.align_state.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.auto_alignment.instance.attribute.align_state.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.auto_alignment.instance.attribute.align_state.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.auto_alignment.instance.attribute.align_state.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.auto_alignment.instance.attribute.align_state.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.auto_alignment.instance.attribute.align_state.enum', list(new_val))


class RootLuAuto_alignmentInstanceAttributeReadout_optical_center_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.readout_optical_center_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.auto_alignment.instance.attribute.readout_optical_center_x.value', float(new_val))


class RootLuAuto_alignmentInstanceAttributeSearch_algorithm(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        bottom_to_top_stepped = 2
        cantilever_between_two_reflecting_edges = 3
        rhombus_spiral = 1
        minimalistic = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.search_algorithm'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAuto_alignmentInstanceAttributeSearch_algorithm.ValueEnum(self._context.get('root.lu.auto_alignment.instance.attribute.search_algorithm.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.auto_alignment.instance.attribute.search_algorithm.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.auto_alignment.instance.attribute.search_algorithm.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.auto_alignment.instance.attribute.search_algorithm.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.auto_alignment.instance.attribute.search_algorithm.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.auto_alignment.instance.attribute.search_algorithm.enum', list(new_val))


class RootLuAuto_alignmentInstanceAttributePte_optical_center_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.pte_optical_center_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.auto_alignment.instance.attribute.pte_optical_center_y.value', float(new_val))


class RootLuAuto_alignmentInstanceAttributeCurrent_optic_component(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        focus = 3
        all = 0
        readout = 1
        detector = 5
        pte = 2
        beam_shifter = 4

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute.current_optic_component'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAuto_alignmentInstanceAttributeCurrent_optic_component.ValueEnum(self._context.get('root.lu.auto_alignment.instance.attribute.current_optic_component.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.auto_alignment.instance.attribute.current_optic_component.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.auto_alignment.instance.attribute.current_optic_component.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.auto_alignment.instance.attribute.current_optic_component.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.auto_alignment.instance.attribute.current_optic_component.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.auto_alignment.instance.attribute.current_optic_component.enum', list(new_val))


class RootLuAuto_alignmentInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance.attribute'
        self.current_optic_component = RootLuAuto_alignmentInstanceAttributeCurrent_optic_component(self._context)
        self.pte_optical_center_y = RootLuAuto_alignmentInstanceAttributePte_optical_center_y(self._context)
        self.search_algorithm = RootLuAuto_alignmentInstanceAttributeSearch_algorithm(self._context)
        self.readout_optical_center_x = RootLuAuto_alignmentInstanceAttributeReadout_optical_center_x(self._context)
        self.align_state = RootLuAuto_alignmentInstanceAttributeAlign_state(self._context)
        self.readout_optical_center_y = RootLuAuto_alignmentInstanceAttributeReadout_optical_center_y(self._context)
        self.component_state = RootLuAuto_alignmentInstanceAttributeComponent_state(self._context)
        self.pte_optical_center_x = RootLuAuto_alignmentInstanceAttributePte_optical_center_x(self._context)


class RootLuAuto_alignmentInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment.instance'
        self.attribute = RootLuAuto_alignmentInstanceAttribute(self._context)
        self.trigger = RootLuAuto_alignmentInstanceTrigger(self._context)
        self.busy = RootLuAuto_alignmentInstanceBusy(self._context)


class RootLuAuto_alignment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.auto_alignment'
        self.instance = RootLuAuto_alignmentInstance(self._context)


class RootLuEvent_managerInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.busy'

    @property
    def is_busy(self) -> bool:
        return bool(self._context.call('root.lu.event_manager.instance.busy.is_busy'))


class RootLuEvent_managerInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.event_manager.instance.trigger.start')

    def soft_event2_falling_edge(self) -> None:
        return self._context.call('root.lu.event_manager.instance.trigger.soft_event2_falling_edge')

    def soft_event1_rising_edge(self) -> None:
        return self._context.call('root.lu.event_manager.instance.trigger.soft_event1_rising_edge')

    def abort(self) -> None:
        return self._context.call('root.lu.event_manager.instance.trigger.abort')

    def stop(self) -> None:
        return self._context.call('root.lu.event_manager.instance.trigger.stop')

    def soft_event0_falling_edge(self) -> None:
        return self._context.call('root.lu.event_manager.instance.trigger.soft_event0_falling_edge')

    def user_abort(self) -> None:
        return self._context.call('root.lu.event_manager.instance.trigger.user_abort')

    def soft_event2_rising_edge(self) -> None:
        return self._context.call('root.lu.event_manager.instance.trigger.soft_event2_rising_edge')

    def soft_event1_falling_edge(self) -> None:
        return self._context.call('root.lu.event_manager.instance.trigger.soft_event1_falling_edge')

    def soft_event0_rising_edge(self) -> None:
        return self._context.call('root.lu.event_manager.instance.trigger.soft_event0_rising_edge')


class RootLuEvent_managerInstanceAttributeStop_event_mask(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        soft_event1_true = 33554432
        ramp_gen_maxz_done = 128
        ramp_gen_alternatez_done = 256
        z_ctrl_reached_min_z_true = 524288
        ramp_gen_test_done = 8192
        soft_event0_true = 16777216
        and_mask0_true = 268435456
        z_ctrl_reached_max_z_true = 1048576
        user_abort_event_true = 134217728
        all = -196609
        z_ctrl_reached_error_limit_true = 262144
        soft_event2_true = 67108864
        mem_sig_gen_done = 4096
        unused_done = 4
        comparator2_true = 1073741824
        ramp_gen_tipvoltage_done = 512
        timer_dbg1_done = 32768
        timer_proc0_done = 2048
        ramp_gen_positionx_done = 8
        ramp_gen_positiony_done = 16
        data_sampling_done = 2
        data_capture_done = 1
        ramp_gen_user4_done = 16384
        ramp_gen_approach_done = 1024
        ramp_gen_planez_done = 32
        ext_event1_true = 8388608
        comparator1_true = 536870912
        none = 0
        ramp_gen_ctrlz_done = 64
        ext_event0_true = 4194304
        comparator3_true = -2147483648

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.stop_event_mask'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuEvent_managerInstanceAttributeStop_event_mask.ValueEnum(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum', list(new_val))


class RootLuEvent_managerInstanceAttributeEvent_vector_snapshot(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        soft_event1_true = 33554432
        ramp_gen_maxz_done = 128
        ramp_gen_alternatez_done = 256
        z_ctrl_reached_min_z_true = 524288
        ramp_gen_test_done = 8192
        soft_event0_true = 16777216
        and_mask0_true = 268435456
        z_ctrl_reached_max_z_true = 1048576
        user_abort_event_true = 134217728
        all = -196609
        z_ctrl_reached_error_limit_true = 262144
        soft_event2_true = 67108864
        mem_sig_gen_done = 4096
        unused_done = 4
        comparator2_true = 1073741824
        ramp_gen_tipvoltage_done = 512
        timer_dbg1_done = 32768
        timer_proc0_done = 2048
        ramp_gen_positionx_done = 8
        ramp_gen_positiony_done = 16
        data_sampling_done = 2
        data_capture_done = 1
        ramp_gen_user4_done = 16384
        ramp_gen_approach_done = 1024
        ramp_gen_planez_done = 32
        ext_event1_true = 8388608
        comparator1_true = 536870912
        none = 0
        ramp_gen_ctrlz_done = 64
        ext_event0_true = 4194304
        comparator3_true = -2147483648

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.event_vector_snapshot'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuEvent_managerInstanceAttributeEvent_vector_snapshot.ValueEnum(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum', list(new_val))


class RootLuEvent_managerInstanceAttributeAnd_mask0(wrap.CmdTreeProp):

    class ValueMask(enum.IntEnum):
        soft_event1_true = 33554432
        ramp_gen_maxz_done = 128
        ramp_gen_alternatez_done = 256
        z_ctrl_reached_min_z_true = 524288
        ramp_gen_test_done = 8192
        soft_event0_true = 16777216
        and_mask0_true = 268435456
        z_ctrl_reached_max_z_true = 1048576
        user_abort_event_true = 134217728
        all = 4294770687.0
        z_ctrl_reached_error_limit_true = 262144
        soft_event2_true = 67108864
        mem_sig_gen_done = 4096
        unused_done = 4
        comparator2_true = 1073741824
        ramp_gen_tipvoltage_done = 512
        timer_dbg1_done = 32768
        timer_proc0_done = 2048
        ramp_gen_positionx_done = 8
        ramp_gen_positiony_done = 16
        data_sampling_done = 2
        data_capture_done = 1
        ramp_gen_user4_done = 16384
        ramp_gen_approach_done = 1024
        ramp_gen_planez_done = 32
        ext_event1_true = 8388608
        comparator1_true = 536870912
        none = 0
        ramp_gen_ctrlz_done = 64
        ext_event0_true = 4194304
        comparator3_true = 2147483648.0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.and_mask0'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.unit', str(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum', list(new_val))

    @property
    def value(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.value_raw'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.value_raw', int(new_val))


class RootLuEvent_managerInstanceAttributeStart_mask(wrap.CmdTreeProp):

    class ValueMask(enum.IntEnum):
        ramp_gen_positiony = 16
        ramp_gen_planez = 32
        data_sampling = 2
        ramp_gen_ctrlz = 64
        data_capture = 1
        all = 65535
        ramp_gen_alternatez = 256
        ramp_gen_test = 8192
        ramp_gen_approach = 1024
        mem_sig_gen = 4096
        ramp_gen_maxz = 128
        none = 0
        ramp_gen_user4 = 16384
        unused = 4
        ramp_gen_tipvoltage = 512
        timer_dbg1 = 32768
        timer_proc0 = 2048
        ramp_gen_positionx = 8

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.start_mask'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.value_raw'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.value_raw', int(new_val))

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum', list(new_val))


class RootLuEvent_managerInstanceAttributeAbort_event_mask(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        soft_event1_true = 33554432
        ramp_gen_maxz_done = 128
        ramp_gen_alternatez_done = 256
        z_ctrl_reached_min_z_true = 524288
        ramp_gen_test_done = 8192
        soft_event0_true = 16777216
        and_mask0_true = 268435456
        z_ctrl_reached_max_z_true = 1048576
        user_abort_event_true = 134217728
        all = -196609
        z_ctrl_reached_error_limit_true = 262144
        soft_event2_true = 67108864
        mem_sig_gen_done = 4096
        unused_done = 4
        comparator2_true = 1073741824
        ramp_gen_tipvoltage_done = 512
        timer_dbg1_done = 32768
        timer_proc0_done = 2048
        ramp_gen_positionx_done = 8
        ramp_gen_positiony_done = 16
        data_sampling_done = 2
        data_capture_done = 1
        ramp_gen_user4_done = 16384
        ramp_gen_approach_done = 1024
        ramp_gen_planez_done = 32
        ext_event1_true = 8388608
        comparator1_true = 536870912
        none = 0
        ramp_gen_ctrlz_done = 64
        ext_event0_true = 4194304
        comparator3_true = -2147483648

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.abort_event_mask'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuEvent_managerInstanceAttributeAbort_event_mask.ValueEnum(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum', list(new_val))


class RootLuEvent_managerInstanceAttributeObject_idle(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.object_idle'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.object_idle.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.object_idle.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.object_idle.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.object_idle.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.event_manager.instance.attribute.object_idle.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.event_manager.instance.attribute.object_idle.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.object_idle.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.object_idle.value', float(new_val))


class RootLuEvent_managerInstanceAttributeObject_queue_size(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.object_queue_size'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.object_queue_size.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.object_queue_size.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.object_queue_size.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.object_queue_size.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.event_manager.instance.attribute.object_queue_size.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.event_manager.instance.attribute.object_queue_size.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.object_queue_size.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.object_queue_size.value', float(new_val))


class RootLuEvent_managerInstanceAttributeEvent_vector(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        soft_event1_true = 33554432
        ramp_gen_maxz_done = 128
        ramp_gen_alternatez_done = 256
        z_ctrl_reached_min_z_true = 524288
        ramp_gen_test_done = 8192
        soft_event0_true = 16777216
        and_mask0_true = 268435456
        z_ctrl_reached_max_z_true = 1048576
        user_abort_event_true = 134217728
        all = -196609
        z_ctrl_reached_error_limit_true = 262144
        soft_event2_true = 67108864
        mem_sig_gen_done = 4096
        unused_done = 4
        comparator2_true = 1073741824
        ramp_gen_tipvoltage_done = 512
        timer_dbg1_done = 32768
        timer_proc0_done = 2048
        ramp_gen_positionx_done = 8
        ramp_gen_positiony_done = 16
        data_sampling_done = 2
        data_capture_done = 1
        ramp_gen_user4_done = 16384
        ramp_gen_approach_done = 1024
        ramp_gen_planez_done = 32
        ext_event1_true = 8388608
        comparator1_true = 536870912
        none = 0
        ramp_gen_ctrlz_done = 64
        ext_event0_true = 4194304
        comparator3_true = -2147483648

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.event_vector'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuEvent_managerInstanceAttributeEvent_vector.ValueEnum(self._context.get('root.lu.event_manager.instance.attribute.event_vector.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum', list(new_val))


class RootLuEvent_managerInstanceAttributeStop_mask(wrap.CmdTreeProp):

    class ValueMask(enum.IntEnum):
        ramp_gen_positiony = 16
        ramp_gen_planez = 32
        data_sampling = 2
        ramp_gen_ctrlz = 64
        data_capture = 1
        all = 65535
        ramp_gen_alternatez = 256
        ramp_gen_test = 8192
        ramp_gen_approach = 1024
        mem_sig_gen = 4096
        ramp_gen_maxz = 128
        none = 0
        ramp_gen_user4 = 16384
        unused = 4
        ramp_gen_tipvoltage = 512
        timer_dbg1 = 32768
        timer_proc0 = 2048
        ramp_gen_positionx = 8

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.stop_mask'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.value_raw'))

    @value.setter
    def value(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.value_raw', int(new_val))

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum', list(new_val))


class RootLuEvent_managerInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute'
        self.stop_mask = RootLuEvent_managerInstanceAttributeStop_mask(self._context)
        self.event_vector = RootLuEvent_managerInstanceAttributeEvent_vector(self._context)
        self.object_queue_size = RootLuEvent_managerInstanceAttributeObject_queue_size(self._context)
        self.object_idle = RootLuEvent_managerInstanceAttributeObject_idle(self._context)
        self.abort_event_mask = RootLuEvent_managerInstanceAttributeAbort_event_mask(self._context)
        self.start_mask = RootLuEvent_managerInstanceAttributeStart_mask(self._context)
        self.and_mask0 = RootLuEvent_managerInstanceAttributeAnd_mask0(self._context)
        self.event_vector_snapshot = RootLuEvent_managerInstanceAttributeEvent_vector_snapshot(self._context)
        self.stop_event_mask = RootLuEvent_managerInstanceAttributeStop_event_mask(self._context)


class RootLuEvent_managerInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance'
        self.attribute = RootLuEvent_managerInstanceAttribute(self._context)
        self.trigger = RootLuEvent_managerInstanceTrigger(self._context)
        self.busy = RootLuEvent_managerInstanceBusy(self._context)


class RootLuEvent_manager(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager'
        self.instance = RootLuEvent_managerInstance(self._context)


class RootLuLithoInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.busy'


class RootLuLithoInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.trigger'

    def next_cmd_item(self) -> None:
        return self._context.call('root.lu.litho.instance.trigger.next_cmd_item')

    def user_abort(self) -> None:
        return self._context.call('root.lu.litho.instance.trigger.user_abort')

    def move_to_abs_xy_pos(self) -> None:
        return self._context.call('root.lu.litho.instance.trigger.move_to_abs_xy_pos')

    def end_sequence(self) -> None:
        return self._context.call('root.lu.litho.instance.trigger.end_sequence')

    def start_sequence(self) -> None:
        return self._context.call('root.lu.litho.instance.trigger.start_sequence')

    def first_cmd_item(self) -> None:
        return self._context.call('root.lu.litho.instance.trigger.first_cmd_item')

    def move_to_z(self) -> None:
        return self._context.call('root.lu.litho.instance.trigger.move_to_z')

    def make_pause(self) -> None:
        return self._context.call('root.lu.litho.instance.trigger.make_pause')


class RootLuLithoInstanceAttributeZ_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.z_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.z_move_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.z_move_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.z_move_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.z_move_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.litho.instance.attribute.z_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.litho.instance.attribute.z_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.z_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.z_move_speed.value', float(new_val))


class RootLuLithoInstanceAttributeAbsolute_y_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.absolute_y_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.absolute_y_pos.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.absolute_y_pos.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.absolute_y_pos.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.absolute_y_pos.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.litho.instance.attribute.absolute_y_pos.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.litho.instance.attribute.absolute_y_pos.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.absolute_y_pos.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.absolute_y_pos.value', float(new_val))


class RootLuLithoInstanceAttributePause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.pause_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.pause_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.pause_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.pause_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.litho.instance.attribute.pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.litho.instance.attribute.pause_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.pause_time.value', float(new_val))


class RootLuLithoInstanceAttributeXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.xy_move_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.xy_move_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.xy_move_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.xy_move_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.litho.instance.attribute.xy_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.litho.instance.attribute.xy_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.xy_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.xy_move_speed.value', float(new_val))


class RootLuLithoInstanceAttributeOp_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        user = 0
        static_afm = 2
        z_modulation = 4
        stm = 1
        dynamic_afm = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.op_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuLithoInstanceAttributeOp_mode.ValueEnum(self._context.get('root.lu.litho.instance.attribute.op_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.litho.instance.attribute.op_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.litho.instance.attribute.op_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.litho.instance.attribute.op_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.litho.instance.attribute.op_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.litho.instance.attribute.op_mode.enum', list(new_val))


class RootLuLithoInstanceAttributeMove_z_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.move_z_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.move_z_pos.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.move_z_pos.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.move_z_pos.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.move_z_pos.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.litho.instance.attribute.move_z_pos.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.litho.instance.attribute.move_z_pos.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.move_z_pos.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.move_z_pos.value', float(new_val))


class RootLuLithoInstanceAttributeMod_rel_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.mod_rel_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.mod_rel_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.mod_rel_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.mod_rel_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.mod_rel_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.litho.instance.attribute.mod_rel_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.litho.instance.attribute.mod_rel_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.mod_rel_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.mod_rel_value.value', float(new_val))


class RootLuLithoInstanceAttributeAbsolute_x_pos(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.absolute_x_pos'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.absolute_x_pos.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.absolute_x_pos.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.absolute_x_pos.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.absolute_x_pos.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.litho.instance.attribute.absolute_x_pos.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.litho.instance.attribute.absolute_x_pos.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.litho.instance.attribute.absolute_x_pos.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.litho.instance.attribute.absolute_x_pos.value', float(new_val))


class RootLuLithoInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute'
        self.absolute_x_pos = RootLuLithoInstanceAttributeAbsolute_x_pos(self._context)
        self.mod_rel_value = RootLuLithoInstanceAttributeMod_rel_value(self._context)
        self.move_z_pos = RootLuLithoInstanceAttributeMove_z_pos(self._context)
        self.op_mode = RootLuLithoInstanceAttributeOp_mode(self._context)
        self.xy_move_speed = RootLuLithoInstanceAttributeXy_move_speed(self._context)
        self.pause_time = RootLuLithoInstanceAttributePause_time(self._context)
        self.absolute_y_pos = RootLuLithoInstanceAttributeAbsolute_y_pos(self._context)
        self.z_move_speed = RootLuLithoInstanceAttributeZ_move_speed(self._context)


class RootLuLithoInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance'
        self.attribute = RootLuLithoInstanceAttribute(self._context)
        self.trigger = RootLuLithoInstanceTrigger(self._context)
        self.busy = RootLuLithoInstanceBusy(self._context)


class RootLuLitho(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho'
        self.instance = RootLuLithoInstance(self._context)


class RootLuOscilloscopeInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.busy'

    @property
    def is_busy(self) -> bool:
        return bool(self._context.call('root.lu.oscilloscope.instance.busy.is_busy'))


class RootLuOscilloscopeInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.oscilloscope.instance.trigger.start')

    def toggle_debug_logging(self) -> None:
        return self._context.call('root.lu.oscilloscope.instance.trigger.toggle_debug_logging')

    def stop(self) -> None:
        return self._context.call('root.lu.oscilloscope.instance.trigger.stop')

    def abort(self) -> None:
        return self._context.call('root.lu.oscilloscope.instance.trigger.abort')


class RootLuOscilloscopeInstanceAttributeHi_res_input_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.hi_res_input_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.hi_res_input_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.hi_res_input_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.hi_res_input_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.hi_res_input_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.oscilloscope.instance.attribute.hi_res_input_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.oscilloscope.instance.attribute.hi_res_input_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.oscilloscope.instance.attribute.hi_res_input_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.oscilloscope.instance.attribute.hi_res_input_vec.vector', list(new_val))


class RootLuOscilloscopeInstanceAttributeFast_input_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.fast_input_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.fast_input_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.fast_input_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.fast_input_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.fast_input_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.oscilloscope.instance.attribute.fast_input_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.oscilloscope.instance.attribute.fast_input_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.oscilloscope.instance.attribute.fast_input_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.oscilloscope.instance.attribute.fast_input_vec.vector', list(new_val))


class RootLuOscilloscopeInstanceAttributeCapture_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.capture_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.capture_period.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_period.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.capture_period.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_period.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.oscilloscope.instance.attribute.capture_period.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_period.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.capture_period.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_period.value', float(new_val))


class RootLuOscilloscopeInstanceAttributeCapture_duration(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.capture_duration'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.capture_duration.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_duration.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.capture_duration.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_duration.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.oscilloscope.instance.attribute.capture_duration.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_duration.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.oscilloscope.instance.attribute.capture_duration.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.oscilloscope.instance.attribute.capture_duration.value', float(new_val))


class RootLuOscilloscopeInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute'
        self.capture_duration = RootLuOscilloscopeInstanceAttributeCapture_duration(self._context)
        self.capture_period = RootLuOscilloscopeInstanceAttributeCapture_period(self._context)
        self.fast_input_vec = RootLuOscilloscopeInstanceAttributeFast_input_vec(self._context)
        self.hi_res_input_vec = RootLuOscilloscopeInstanceAttributeHi_res_input_vec(self._context)


class RootLuOscilloscopeInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance'
        self.attribute = RootLuOscilloscopeInstanceAttribute(self._context)
        self.trigger = RootLuOscilloscopeInstanceTrigger(self._context)
        self.busy = RootLuOscilloscopeInstanceBusy(self._context)


class RootLuOscilloscope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope'
        self.instance = RootLuOscilloscopeInstance(self._context)


class RootLuData_acquisitionInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.busy'

    @property
    def is_sampling(self) -> bool:
        return bool(self._context.call('root.lu.data_acquisition.instance.busy.is_sampling'))

    @property
    def is_capturing(self) -> bool:
        return bool(self._context.call('root.lu.data_acquisition.instance.busy.is_capturing'))


class RootLuData_acquisitionInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.trigger'

    def background_capture_start(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.background_capture_start')

    def sampler_prepare(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.sampler_prepare')

    def capture_start(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.capture_start')

    def background_sampler_start(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.background_sampler_start')

    def capture_start_data_simulation(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.capture_start_data_simulation')

    def capture_trim_data_storage(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.capture_trim_data_storage')

    def capture_prepare(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.capture_prepare')

    def abort_all(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.abort_all')

    def sampler_start_data_simulation(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.sampler_start_data_simulation')

    def sampler_start(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.sampler_start')

    def sampler_init_phase_mode(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.sampler_init_phase_mode')

    def sampler_trim_data_storage(self) -> None:
        return self._context.call('root.lu.data_acquisition.instance.trigger.sampler_trim_data_storage')


class RootLuData_acquisitionInstanceAttributeActive_sampler_set(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.active_sampler_set'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.active_sampler_set.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.active_sampler_set.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.active_sampler_set.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.active_sampler_set.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.active_sampler_set.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.active_sampler_set.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.active_sampler_set.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.active_sampler_set.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_datapoints.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeNumber_of_sampler_sets(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.number_of_sampler_sets'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.number_of_sampler_sets.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.number_of_sampler_sets.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.number_of_sampler_sets.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.number_of_sampler_sets.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.number_of_sampler_sets.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.number_of_sampler_sets.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.number_of_sampler_sets.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.number_of_sampler_sets.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_channel_mask(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_channel_mask'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_channel_mask.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_channel_mask.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_channel_mask.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_channel_mask.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_channel_mask.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_channel_mask.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_channel_mask.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_channel_mask.value', float(new_val))


class RootLuData_acquisitionInstanceAttributePhase_mode_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_mode_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_mode_enabled.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_mode_enabled.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_mode_enabled.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_mode_enabled.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.phase_mode_enabled.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_mode_enabled.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_mode_enabled.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_mode_enabled.value', float(new_val))


class RootLuData_acquisitionInstanceAttributePhase_sampler_data_rate_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_data_rate_vec.vector', list(new_val))


class RootLuData_acquisitionInstanceAttributePhase_sampler_end_datapoint_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_sampler_end_datapoint_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_end_datapoint_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_end_datapoint_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_end_datapoint_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_end_datapoint_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_end_datapoint_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_end_datapoint_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_end_datapoint_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_end_datapoint_vec.vector', list(new_val))


class RootLuData_acquisitionInstanceAttributePhase_sampler_group_id(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_sampler_group_id'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_group_id.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_group_id.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_group_id.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_group_id.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_group_id.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_group_id.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_sampler_group_id.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_sampler_group_id.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_auto_set_filter_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_auto_set_filter_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_auto_set_filter_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_auto_set_filter_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_auto_set_filter_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_auto_set_filter_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_auto_set_filter_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_auto_set_filter_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_auto_set_filter_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_auto_set_filter_mode.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_data_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_data_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_data_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_data_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_data_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_data_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_data_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_data_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_data_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_data_rate.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_channel_mask(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_channel_mask'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_channel_mask.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_channel_mask.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_channel_mask.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_channel_mask.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_channel_mask.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_channel_mask.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_channel_mask.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_channel_mask.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_channel_mask(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_channel_mask'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_channel_mask.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_channel_mask.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_channel_mask.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_channel_mask.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_channel_mask.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_channel_mask.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_channel_mask.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_channel_mask.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_filter_size(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_size'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_size.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_size.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_size.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_size.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_size.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_size.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_size.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_size.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_filter_type(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        window_hamming = 1
        window_rectangular = 0
        window_nuttall = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_type'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_filter_type.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_type.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_type.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_type.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_type.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_type.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_filter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        filter_userdefined = 0
        low_pass_2_k_hz = 5
        low_pass_50_hz = 15
        low_pass_20_k_hz = 8
        low_pass_500_hz = 3
        low_pass_10_hz = 13
        low_pass_50_k_hz = 9
        low_pass_200_hz = 2
        low_pass_100_k_hz = 10
        low_pass_5_k_hz = 6
        low_pass_5_hz = 12
        low_pass_20_hz = 14
        low_pass_100_hz = 1
        low_pass_1_k_hz = 4
        low_pass_10_k_hz = 7

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_filter_mode.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_mode.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch2_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch2_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch2_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch1_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch1_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch1_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch0_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        ort_free_wave = 6
        ort_excitation = 5
        analyzer2_reference = 4
        ctrl_z_out = 7
        analyzer1_reference = 3
        in_deflection = 0
        ctrl_w_out = 8
        in2 = 1
        in_user = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeCapture_fast_ch0_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch0_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch2_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch2_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch2_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch1_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch1_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch1_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch3_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch3_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch3_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch4_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch4_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch4_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch7_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch7_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch7_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch4_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch4_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch4_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch_input_vec(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.vector', list(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch_input_vec.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch7_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch7_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch7_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeNumber_of_capture_sets(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.number_of_capture_sets'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.number_of_capture_sets.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_group_id(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_group_id.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeActive_capture_set(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.active_capture_set'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.active_capture_set.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.active_capture_set.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.active_capture_set.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.active_capture_set.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.active_capture_set.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.active_capture_set.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.active_capture_set.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.active_capture_set.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_datapoints'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_datapoints.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_datapoints.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_datapoints.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_datapoints.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_datapoints.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_datapoints.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_datapoints.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch0_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch0_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch0_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_trigger_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        internal_timer = 0
        external_trigger = 1
        num_trigger_modes = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_trigger_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_trigger_mode.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_trigger_mode.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_group_id(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_group_id'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_group_id.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_group_id.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_group_id.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_group_id.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_group_id.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_group_id.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_group_id.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_group_id.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_group_id(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_group_id'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_group_id.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_group_id.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_group_id.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_group_id.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_group_id.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_group_id.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_group_id.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_group_id.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch6_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch6_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch6_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch6_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch6_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch6_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch5_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch5_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_hi_res_ch5_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch5_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch5_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch5_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributePhase_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.phase_count'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_count.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_count.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_count.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_count.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.phase_count.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_count.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.phase_count.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.phase_count.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch1_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        ort_free_wave = 6
        ort_excitation = 5
        analyzer2_reference = 4
        ctrl_z_out = 7
        analyzer1_reference = 3
        in_deflection = 0
        ctrl_w_out = 8
        in2 = 1
        in_user = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeCapture_fast_ch1_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch1_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch0_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch0_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch0_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch_input_vec(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.vector', list(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch_input_vec.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeSampler_filter_cutoff(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.sampler_filter_cutoff'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_cutoff.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_cutoff.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_cutoff.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_cutoff.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_cutoff.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_cutoff.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.sampler_filter_cutoff.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.sampler_filter_cutoff.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_datapoints'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_datapoints.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_datapoints.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_datapoints.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_datapoints.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_datapoints.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_datapoints.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_datapoints.value', float(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch3_input(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        memory_gen_drive_z = 56
        ramp_gen_ctrl_z = 37
        ctrl_z_sum = 40
        ctrl_user1_out = 44
        analyzer1_ctrl_delta_f = 21
        ort_baseline = 46
        analyzer1_y = 19
        analyzer2_phase = 23
        analyzer1_reference = 63
        ctrl_z_pid_command = 39
        analyzer2_ctrl_delta_f = 27
        analyzer2_x = 24
        analyzer1_phase = 17
        in_position_y = 3
        ctrl_user2_out = 45
        ramp_gen_alternate_z = 29
        in_detector_sum = 10
        ramp_gen_test = 32
        ramp_gen_approach = 33
        ctrl_z_nominal = 15
        in_position_x = 2
        analyzer2_amplitude = 22
        memory_gen_out7 = 57
        memory_gen_out8 = 58
        ramp_gen_position_y = 35
        analyzer2_y = 25
        ctrl_y_out = 42
        static = 30
        analyzer1_ctrl_amplitude = 20
        ramp_gen_max_z = 38
        memory_gen_position_x = 51
        fast_in2 = 61
        in6 = 11
        analyzer2_ctrl_amplitude = 26
        in_user3 = 7
        ctrl_z_out = 14
        memory_gen_position_y = 53
        in_tip_current = 9
        ort_amplitude_reduction = 48
        analyzer1_x = 18
        in_user4 = 8
        ramp_gen_user4 = 59
        ort_adhesion_value = 49
        ramp_gen_tip_voltage = 28
        ramp_gen_position_x = 34
        ramp_gen_plane_z = 36
        in_deflection = 0
        ort_free_wave = 66
        ort_excitation = 65
        memory_gen_position_z = 55
        ort_baseline_corrected = 47
        in_lateral = 1
        fast_in_deflection = 60
        memory_gen_drive_x = 52
        in_user2 = 6
        in_user1 = 5
        in_position_z = 4
        analyzer2_reference = 64
        analyzer1_amplitude = 16
        ort_adhesion_position = 50
        gen_test_dynamic = 31
        ctrl_z_error = 13
        memory_gen_drive_y = 54
        fast_in_user = 62
        ctrl_z_in = 12
        ctrl_x_out = 41
        ctrl_w_out = 43

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch3_input.ValueEnum(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_hi_res_ch3_input.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_ch_input_vec(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        ort_free_wave = 6
        ort_excitation = 5
        analyzer2_reference = 4
        ctrl_z_out = 7
        analyzer1_reference = 3
        in_deflection = 0
        ctrl_w_out = 8
        in2 = 1
        in_user = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.vector', list(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_ch_input_vec.enum', list(new_val))


class RootLuData_acquisitionInstanceAttributeCapture_fast_sampling_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute.capture_fast_sampling_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_sampling_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_sampling_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_sampling_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_sampling_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_sampling_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_sampling_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.data_acquisition.instance.attribute.capture_fast_sampling_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.data_acquisition.instance.attribute.capture_fast_sampling_rate.value', float(new_val))


class RootLuData_acquisitionInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance.attribute'
        self.capture_fast_sampling_rate = RootLuData_acquisitionInstanceAttributeCapture_fast_sampling_rate(self._context)
        self.capture_fast_ch_input_vec = RootLuData_acquisitionInstanceAttributeCapture_fast_ch_input_vec(self._context)
        self.capture_hi_res_ch3_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch3_input(self._context)
        self.capture_fast_datapoints = RootLuData_acquisitionInstanceAttributeCapture_fast_datapoints(self._context)
        self.sampler_filter_cutoff = RootLuData_acquisitionInstanceAttributeSampler_filter_cutoff(self._context)
        self.capture_hi_res_ch_input_vec = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch_input_vec(self._context)
        self.capture_hi_res_ch0_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch0_input(self._context)
        self.capture_fast_ch1_input = RootLuData_acquisitionInstanceAttributeCapture_fast_ch1_input(self._context)
        self.phase_count = RootLuData_acquisitionInstanceAttributePhase_count(self._context)
        self.capture_hi_res_ch5_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch5_input(self._context)
        self.sampler_hi_res_ch5_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch5_input(self._context)
        self.capture_hi_res_ch6_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch6_input(self._context)
        self.sampler_hi_res_ch6_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch6_input(self._context)
        self.capture_fast_group_id = RootLuData_acquisitionInstanceAttributeCapture_fast_group_id(self._context)
        self.sampler_group_id = RootLuData_acquisitionInstanceAttributeSampler_group_id(self._context)
        self.sampler_trigger_mode = RootLuData_acquisitionInstanceAttributeSampler_trigger_mode(self._context)
        self.sampler_hi_res_ch0_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch0_input(self._context)
        self.sampler_datapoints = RootLuData_acquisitionInstanceAttributeSampler_datapoints(self._context)
        self.active_capture_set = RootLuData_acquisitionInstanceAttributeActive_capture_set(self._context)
        self.capture_hi_res_group_id = RootLuData_acquisitionInstanceAttributeCapture_hi_res_group_id(self._context)
        self.number_of_capture_sets = RootLuData_acquisitionInstanceAttributeNumber_of_capture_sets(self._context)
        self.capture_hi_res_ch7_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch7_input(self._context)
        self.sampler_hi_res_ch_input_vec = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch_input_vec(self._context)
        self.capture_hi_res_ch4_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch4_input(self._context)
        self.sampler_hi_res_ch7_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch7_input(self._context)
        self.sampler_hi_res_ch4_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch4_input(self._context)
        self.sampler_hi_res_ch3_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch3_input(self._context)
        self.capture_hi_res_ch1_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch1_input(self._context)
        self.sampler_hi_res_ch2_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch2_input(self._context)
        self.capture_fast_ch0_input = RootLuData_acquisitionInstanceAttributeCapture_fast_ch0_input(self._context)
        self.sampler_hi_res_ch1_input = RootLuData_acquisitionInstanceAttributeSampler_hi_res_ch1_input(self._context)
        self.capture_hi_res_ch2_input = RootLuData_acquisitionInstanceAttributeCapture_hi_res_ch2_input(self._context)
        self.sampler_filter_mode = RootLuData_acquisitionInstanceAttributeSampler_filter_mode(self._context)
        self.sampler_filter_type = RootLuData_acquisitionInstanceAttributeSampler_filter_type(self._context)
        self.sampler_filter_size = RootLuData_acquisitionInstanceAttributeSampler_filter_size(self._context)
        self.capture_hi_res_channel_mask = RootLuData_acquisitionInstanceAttributeCapture_hi_res_channel_mask(self._context)
        self.sampler_channel_mask = RootLuData_acquisitionInstanceAttributeSampler_channel_mask(self._context)
        self.sampler_data_rate = RootLuData_acquisitionInstanceAttributeSampler_data_rate(self._context)
        self.sampler_auto_set_filter_mode = RootLuData_acquisitionInstanceAttributeSampler_auto_set_filter_mode(self._context)
        self.phase_sampler_group_id = RootLuData_acquisitionInstanceAttributePhase_sampler_group_id(self._context)
        self.phase_sampler_end_datapoint_vec = RootLuData_acquisitionInstanceAttributePhase_sampler_end_datapoint_vec(self._context)
        self.phase_sampler_data_rate_vec = RootLuData_acquisitionInstanceAttributePhase_sampler_data_rate_vec(self._context)
        self.phase_mode_enabled = RootLuData_acquisitionInstanceAttributePhase_mode_enabled(self._context)
        self.capture_fast_channel_mask = RootLuData_acquisitionInstanceAttributeCapture_fast_channel_mask(self._context)
        self.number_of_sampler_sets = RootLuData_acquisitionInstanceAttributeNumber_of_sampler_sets(self._context)
        self.capture_hi_res_datapoints = RootLuData_acquisitionInstanceAttributeCapture_hi_res_datapoints(self._context)
        self.active_sampler_set = RootLuData_acquisitionInstanceAttributeActive_sampler_set(self._context)


class RootLuData_acquisitionInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition.instance'
        self.attribute = RootLuData_acquisitionInstanceAttribute(self._context)
        self.trigger = RootLuData_acquisitionInstanceTrigger(self._context)
        self.busy = RootLuData_acquisitionInstanceBusy(self._context)


class RootLuData_acquisition(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.data_acquisition'
        self.instance = RootLuData_acquisitionInstance(self._context)


class RootLuIsostageInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.busy'


class RootLuIsostageInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.trigger'

    def test_connection(self) -> None:
        return self._context.call('root.lu.isostage.instance.trigger.test_connection')

    def setup_event_counter(self) -> None:
        return self._context.call('root.lu.isostage.instance.trigger.setup_event_counter')

    def clear_event_counter(self) -> None:
        return self._context.call('root.lu.isostage.instance.trigger.clear_event_counter')

    def update_settings(self) -> None:
        return self._context.call('root.lu.isostage.instance.trigger.update_settings')


class RootLuIsostageInstanceAttributeIsolation_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        active = 0
        off_or_defined_by_user_switch = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.isolation_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuIsostageInstanceAttributeIsolation_mode.ValueEnum(self._context.get('root.lu.isostage.instance.attribute.isolation_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.isostage.instance.attribute.isolation_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.isostage.instance.attribute.isolation_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.isostage.instance.attribute.isolation_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.isostage.instance.attribute.isolation_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.isostage.instance.attribute.isolation_mode.enum', list(new_val))


class RootLuIsostageInstanceAttributeIs_connected(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.is_connected'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.isostage.instance.attribute.is_connected.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.isostage.instance.attribute.is_connected.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.isostage.instance.attribute.is_connected.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.isostage.instance.attribute.is_connected.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.isostage.instance.attribute.is_connected.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.isostage.instance.attribute.is_connected.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.isostage.instance.attribute.is_connected.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.isostage.instance.attribute.is_connected.value', float(new_val))


class RootLuIsostageInstanceAttributeEvent_counter(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.event_counter'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.isostage.instance.attribute.event_counter.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.isostage.instance.attribute.event_counter.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.isostage.instance.attribute.event_counter.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.isostage.instance.attribute.event_counter.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.isostage.instance.attribute.event_counter.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.isostage.instance.attribute.event_counter.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.isostage.instance.attribute.event_counter.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.isostage.instance.attribute.event_counter.value', float(new_val))


class RootLuIsostageInstanceAttributeOverload_sensitivity(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.overload_sensitivity'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.isostage.instance.attribute.overload_sensitivity.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.isostage.instance.attribute.overload_sensitivity.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.isostage.instance.attribute.overload_sensitivity.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.isostage.instance.attribute.overload_sensitivity.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.isostage.instance.attribute.overload_sensitivity.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.isostage.instance.attribute.overload_sensitivity.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.isostage.instance.attribute.overload_sensitivity.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.isostage.instance.attribute.overload_sensitivity.value', float(new_val))


class RootLuIsostageInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute'
        self.overload_sensitivity = RootLuIsostageInstanceAttributeOverload_sensitivity(self._context)
        self.event_counter = RootLuIsostageInstanceAttributeEvent_counter(self._context)
        self.is_connected = RootLuIsostageInstanceAttributeIs_connected(self._context)
        self.isolation_mode = RootLuIsostageInstanceAttributeIsolation_mode(self._context)


class RootLuIsostageInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance'
        self.attribute = RootLuIsostageInstanceAttribute(self._context)
        self.trigger = RootLuIsostageInstanceTrigger(self._context)
        self.busy = RootLuIsostageInstanceBusy(self._context)


class RootLuIsostage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage'
        self.instance = RootLuIsostageInstance(self._context)


class RootLuSpecInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.busy'


class RootLuSpecInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.spec.instance.trigger.start')

    def pause(self) -> None:
        return self._context.call('root.lu.spec.instance.trigger.pause')

    def resume_last_point(self) -> None:
        return self._context.call('root.lu.spec.instance.trigger.resume_last_point')

    def resume_next_point(self) -> None:
        return self._context.call('root.lu.spec.instance.trigger.resume_next_point')

    def user_abort(self) -> None:
        return self._context.call('root.lu.spec.instance.trigger.user_abort')


class RootLuSpecInstanceAttributeBwd_mod_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_mod_range.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_range.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_mod_range.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_range.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.bwd_mod_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_range.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_mod_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_range.value', float(new_val))


class RootLuSpecInstanceAttributeBwd_mod_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_mod_stop_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_stop_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_mod_stop_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_stop_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.bwd_mod_stop_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_stop_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_mod_stop_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_stop_value.value', float(new_val))


class RootLuSpecInstanceAttributeSpec_end_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        z_controller_active = 1
        keep_last_z_pos = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_end_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSpecInstanceAttributeSpec_end_mode.ValueEnum(self._context.get('root.lu.spec.instance.attribute.spec_end_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.spec.instance.attribute.spec_end_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.spec_end_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.spec_end_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.spec.instance.attribute.spec_end_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.spec.instance.attribute.spec_end_mode.enum', list(new_val))


class RootLuSpecInstanceAttributePhase_bwd_pause_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_bwd_pause_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_bwd_pause_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_bwd_pause_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_bwd_pause_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_bwd_pause_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.phase_bwd_pause_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.phase_bwd_pause_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_bwd_pause_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_bwd_pause_rate.value', float(new_val))


class RootLuSpecInstanceAttributeFwd_mod_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_mod_range.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_range.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_mod_range.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_range.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.fwd_mod_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_range.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_mod_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_range.value', float(new_val))


class RootLuSpecInstanceAttributeFwd_mod_stop_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_stop_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_mod_stop_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_stop_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_mod_stop_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_stop_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.fwd_mod_stop_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_stop_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_mod_stop_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_stop_value.value', float(new_val))


class RootLuSpecInstanceAttributeFwd_pause_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        z_off = 0
        z_on = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSpecInstanceAttributeFwd_pause_mode.ValueEnum(self._context.get('root.lu.spec.instance.attribute.fwd_pause_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_pause_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.spec.instance.attribute.fwd_pause_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_mode.enum', list(new_val))


class RootLuSpecInstanceAttributeModulation_output(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        tip_voltage = 1
        external_z = 2
        position_z = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.modulation_output'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSpecInstanceAttributeModulation_output.ValueEnum(self._context.get('root.lu.spec.instance.attribute.modulation_output.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.spec.instance.attribute.modulation_output.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.modulation_output.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.modulation_output.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.spec.instance.attribute.modulation_output.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.spec.instance.attribute.modulation_output.enum', list(new_val))


class RootLuSpecInstanceAttributeFwd_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_datapoints'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_datapoints.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_datapoints.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_datapoints.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_datapoints.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.fwd_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.fwd_datapoints.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_datapoints.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_datapoints.value', float(new_val))


class RootLuSpecInstanceAttributeBwd_mod_stop_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        is_greater_than = 1
        is_less_than = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_stop_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSpecInstanceAttributeBwd_mod_stop_mode.ValueEnum(self._context.get('root.lu.spec.instance.attribute.bwd_mod_stop_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_stop_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_mod_stop_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_stop_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.spec.instance.attribute.bwd_mod_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_stop_mode.enum', list(new_val))


class RootLuSpecInstanceAttributeAuto_recalibrate_probe_interval(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.auto_recalibrate_probe_interval'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.auto_recalibrate_probe_interval.value', float(new_val))


class RootLuSpecInstanceAttributeFwd_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_move_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_move_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_move_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_move_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.fwd_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.fwd_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_move_speed.value', float(new_val))


class RootLuSpecInstanceAttributeBwd_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_datapoints'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_datapoints.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_datapoints.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_datapoints.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_datapoints.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.bwd_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.bwd_datapoints.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_datapoints.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_datapoints.value', float(new_val))


class RootLuSpecInstanceAttributeFwd_mod_stop_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        is_greater_than = 1
        is_less_than = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_stop_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSpecInstanceAttributeFwd_mod_stop_mode.ValueEnum(self._context.get('root.lu.spec.instance.attribute.fwd_mod_stop_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_stop_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_mod_stop_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_stop_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.spec.instance.attribute.fwd_mod_stop_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_stop_mode.enum', list(new_val))


class RootLuSpecInstanceAttributePhase_bwd_mod_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_bwd_mod_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_bwd_mod_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_bwd_mod_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_bwd_mod_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_bwd_mod_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.phase_bwd_mod_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.phase_bwd_mod_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_bwd_mod_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_bwd_mod_rate.value', float(new_val))


class RootLuSpecInstanceAttributePhase_data_group_id(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_data_group_id'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_data_group_id.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_data_group_id.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_data_group_id.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_data_group_id.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.phase_data_group_id.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.phase_data_group_id.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_data_group_id.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_data_group_id.value', float(new_val))


class RootLuSpecInstanceAttributePhase_sample_mask(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_sample_mask'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_sample_mask.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_sample_mask.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_sample_mask.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_sample_mask.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.phase_sample_mask.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.phase_sample_mask.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_sample_mask.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_sample_mask.value', float(new_val))


class RootLuSpecInstanceAttributeRepetition_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.repetition_count'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.repetition_count.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.repetition_count.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.repetition_count.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.repetition_count.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.repetition_count.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.repetition_count.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.repetition_count.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.repetition_count.value', float(new_val))


class RootLuSpecInstanceAttributeFeedback_active(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.feedback_active'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.feedback_active.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.feedback_active.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.feedback_active.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.feedback_active.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.feedback_active.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.feedback_active.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.feedback_active.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.feedback_active.value', float(new_val))


class RootLuSpecInstanceAttributeXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.xy_move_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.xy_move_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.xy_move_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.xy_move_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.xy_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.xy_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.xy_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.xy_move_speed.value', float(new_val))


class RootLuSpecInstanceAttributeSpec_map_configuration_blob_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_map_configuration_blob_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.spec.instance.attribute.spec_map_configuration_blob_vec.vector', list(new_val))


class RootLuSpecInstanceAttributeStart_offset_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.start_offset_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.start_offset_move_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.start_offset_move_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.start_offset_move_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.start_offset_move_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.start_offset_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.start_offset_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.start_offset_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.start_offset_move_speed.value', float(new_val))


class RootLuSpecInstanceAttributePhase_fwd_mod_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_fwd_mod_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_fwd_mod_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_fwd_mod_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_fwd_mod_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_fwd_mod_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.phase_fwd_mod_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.phase_fwd_mod_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_fwd_mod_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_fwd_mod_rate.value', float(new_val))


class RootLuSpecInstanceAttributeBwd_mod_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stop_by_value = 1
        fixed_length = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSpecInstanceAttributeBwd_mod_mode.ValueEnum(self._context.get('root.lu.spec.instance.attribute.bwd_mod_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_mod_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.spec.instance.attribute.bwd_mod_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_mode.enum', list(new_val))


class RootLuSpecInstanceAttributeDeflection_force_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.deflection_force_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.deflection_force_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.deflection_force_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.deflection_force_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.deflection_force_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.deflection_force_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.deflection_force_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.deflection_force_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.deflection_force_offset.value', float(new_val))


class RootLuSpecInstanceAttributeBwd_mod_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_mod_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_mod_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.bwd_mod_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_mod_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_time.value', float(new_val))


class RootLuSpecInstanceAttributeFwd_mod_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        stop_by_value = 1
        fixed_length = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSpecInstanceAttributeFwd_mod_mode.ValueEnum(self._context.get('root.lu.spec.instance.attribute.fwd_mod_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_mod_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.spec.instance.attribute.fwd_mod_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_mode.enum', list(new_val))


class RootLuSpecInstanceAttributeRepetition_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        position = 1
        list = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.repetition_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSpecInstanceAttributeRepetition_mode.ValueEnum(self._context.get('root.lu.spec.instance.attribute.repetition_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.spec.instance.attribute.repetition_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.repetition_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.repetition_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.spec.instance.attribute.repetition_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.spec.instance.attribute.repetition_mode.enum', list(new_val))


class RootLuSpecInstanceAttributeFwd_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_datapoints'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_pause_datapoints.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_datapoints.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_pause_datapoints.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_datapoints.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.fwd_pause_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_datapoints.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_pause_datapoints.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_datapoints.value', float(new_val))


class RootLuSpecInstanceAttributePhase_fwd_pause_rate(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_fwd_pause_rate'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_fwd_pause_rate.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_fwd_pause_rate.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_fwd_pause_rate.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_fwd_pause_rate.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.phase_fwd_pause_rate.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.phase_fwd_pause_rate.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.phase_fwd_pause_rate.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.phase_fwd_pause_rate.value', float(new_val))


class RootLuSpecInstanceAttributeBwd_pause_datapoints(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_datapoints'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_pause_datapoints.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_datapoints.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_pause_datapoints.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_datapoints.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.bwd_pause_datapoints.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_datapoints.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_pause_datapoints.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_datapoints.value', float(new_val))


class RootLuSpecInstanceAttributeStart_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.start_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.start_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.start_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.start_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.start_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.start_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.start_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.start_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.start_offset.value', float(new_val))


class RootLuSpecInstanceAttributeBwd_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_pause_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_pause_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.bwd_pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_time.value', float(new_val))


class RootLuSpecInstanceAttributeBwd_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_move_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_move_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_move_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_move_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.bwd_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.bwd_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.bwd_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.bwd_move_speed.value', float(new_val))


class RootLuSpecInstanceAttributeCurrent_repetition(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.current_repetition'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.current_repetition.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.current_repetition.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.current_repetition.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.current_repetition.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.current_repetition.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.current_repetition.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.current_repetition.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.current_repetition.value', float(new_val))


class RootLuSpecInstanceAttributeFwd_mod_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_mod_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_mod_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.fwd_mod_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_mod_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_time.value', float(new_val))


class RootLuSpecInstanceAttributeFwd_pause_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_pause_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_pause_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.fwd_pause_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.fwd_pause_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_time.value', float(new_val))


class RootLuSpecInstanceAttributeBwd_pause_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        z_off = 0
        z_on = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuSpecInstanceAttributeBwd_pause_mode.ValueEnum(self._context.get('root.lu.spec.instance.attribute.bwd_pause_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_pause_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.spec.instance.attribute.bwd_pause_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_mode.enum', list(new_val))


class RootLuSpecInstanceAttributePoint_coords_blob_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.point_coords_blob_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.point_coords_blob_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.point_coords_blob_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.point_coords_blob_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.point_coords_blob_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.point_coords_blob_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.point_coords_blob_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.spec.instance.attribute.point_coords_blob_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.spec.instance.attribute.point_coords_blob_vec.vector', list(new_val))


class RootLuSpecInstanceAttributeMod_rel_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.mod_rel_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.mod_rel_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.mod_rel_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.mod_rel_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.mod_rel_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.mod_rel_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.mod_rel_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.mod_rel_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.mod_rel_value.value', float(new_val))


class RootLuSpecInstanceAttributeSpec_map_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_map_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.spec_map_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.spec_map_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.spec_map_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.spec_map_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.spec.instance.attribute.spec_map_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.spec.instance.attribute.spec_map_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.spec.instance.attribute.spec_map_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.spec.instance.attribute.spec_map_mode.value', float(new_val))


class RootLuSpecInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute'
        self.spec_map_mode = RootLuSpecInstanceAttributeSpec_map_mode(self._context)
        self.mod_rel_value = RootLuSpecInstanceAttributeMod_rel_value(self._context)
        self.point_coords_blob_vec = RootLuSpecInstanceAttributePoint_coords_blob_vec(self._context)
        self.bwd_pause_mode = RootLuSpecInstanceAttributeBwd_pause_mode(self._context)
        self.fwd_pause_time = RootLuSpecInstanceAttributeFwd_pause_time(self._context)
        self.fwd_mod_time = RootLuSpecInstanceAttributeFwd_mod_time(self._context)
        self.current_repetition = RootLuSpecInstanceAttributeCurrent_repetition(self._context)
        self.bwd_move_speed = RootLuSpecInstanceAttributeBwd_move_speed(self._context)
        self.bwd_pause_time = RootLuSpecInstanceAttributeBwd_pause_time(self._context)
        self.start_offset = RootLuSpecInstanceAttributeStart_offset(self._context)
        self.bwd_pause_datapoints = RootLuSpecInstanceAttributeBwd_pause_datapoints(self._context)
        self.phase_fwd_pause_rate = RootLuSpecInstanceAttributePhase_fwd_pause_rate(self._context)
        self.fwd_pause_datapoints = RootLuSpecInstanceAttributeFwd_pause_datapoints(self._context)
        self.repetition_mode = RootLuSpecInstanceAttributeRepetition_mode(self._context)
        self.fwd_mod_mode = RootLuSpecInstanceAttributeFwd_mod_mode(self._context)
        self.bwd_mod_time = RootLuSpecInstanceAttributeBwd_mod_time(self._context)
        self.deflection_force_offset = RootLuSpecInstanceAttributeDeflection_force_offset(self._context)
        self.bwd_mod_mode = RootLuSpecInstanceAttributeBwd_mod_mode(self._context)
        self.phase_fwd_mod_rate = RootLuSpecInstanceAttributePhase_fwd_mod_rate(self._context)
        self.start_offset_move_speed = RootLuSpecInstanceAttributeStart_offset_move_speed(self._context)
        self.spec_map_configuration_blob_vec = RootLuSpecInstanceAttributeSpec_map_configuration_blob_vec(self._context)
        self.xy_move_speed = RootLuSpecInstanceAttributeXy_move_speed(self._context)
        self.feedback_active = RootLuSpecInstanceAttributeFeedback_active(self._context)
        self.repetition_count = RootLuSpecInstanceAttributeRepetition_count(self._context)
        self.phase_sample_mask = RootLuSpecInstanceAttributePhase_sample_mask(self._context)
        self.phase_data_group_id = RootLuSpecInstanceAttributePhase_data_group_id(self._context)
        self.phase_bwd_mod_rate = RootLuSpecInstanceAttributePhase_bwd_mod_rate(self._context)
        self.fwd_mod_stop_mode = RootLuSpecInstanceAttributeFwd_mod_stop_mode(self._context)
        self.bwd_datapoints = RootLuSpecInstanceAttributeBwd_datapoints(self._context)
        self.fwd_move_speed = RootLuSpecInstanceAttributeFwd_move_speed(self._context)
        self.auto_recalibrate_probe_interval = RootLuSpecInstanceAttributeAuto_recalibrate_probe_interval(self._context)
        self.bwd_mod_stop_mode = RootLuSpecInstanceAttributeBwd_mod_stop_mode(self._context)
        self.fwd_datapoints = RootLuSpecInstanceAttributeFwd_datapoints(self._context)
        self.modulation_output = RootLuSpecInstanceAttributeModulation_output(self._context)
        self.fwd_pause_mode = RootLuSpecInstanceAttributeFwd_pause_mode(self._context)
        self.fwd_mod_stop_value = RootLuSpecInstanceAttributeFwd_mod_stop_value(self._context)
        self.fwd_mod_range = RootLuSpecInstanceAttributeFwd_mod_range(self._context)
        self.phase_bwd_pause_rate = RootLuSpecInstanceAttributePhase_bwd_pause_rate(self._context)
        self.spec_end_mode = RootLuSpecInstanceAttributeSpec_end_mode(self._context)
        self.bwd_mod_stop_value = RootLuSpecInstanceAttributeBwd_mod_stop_value(self._context)
        self.bwd_mod_range = RootLuSpecInstanceAttributeBwd_mod_range(self._context)


class RootLuSpecInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance'
        self.attribute = RootLuSpecInstanceAttribute(self._context)
        self.trigger = RootLuSpecInstanceTrigger(self._context)
        self.busy = RootLuSpecInstanceBusy(self._context)


class RootLuSpec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec'
        self.instance = RootLuSpecInstance(self._context)


class RootLuAnalog_hi_res_inUser3Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.busy'


class RootLuAnalog_hi_res_inUser3Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.trigger'


class RootLuAnalog_hi_res_inUser3AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.input_gain'


class RootLuAnalog_hi_res_inUser3AttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.current_input_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.current_input_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.current_input_value.value', float(new_val))


class RootLuAnalog_hi_res_inUser3AttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_filter = 0
        low_pass_filter = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser3AttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inUser3AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser3AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inUser3AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inUser3AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        self = 3
        position_z = 2
        position_x = 0
        position_y = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inUser3AttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.input_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.input_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.input_offset.value', float(new_val))


class RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inUser3AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_inUser3AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_inUser3Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inUser3AttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inUser3AttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inUser3AttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inUser3AttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inUser3AttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inUser3AttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inUser3AttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inUser3AttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inUser3AttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inUser3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3'
        self.attribute = RootLuAnalog_hi_res_inUser3Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inUser3Trigger(self._context)
        self.busy = RootLuAnalog_hi_res_inUser3Busy(self._context)


class RootLuAnalog_hi_res_inUser1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.busy'


class RootLuAnalog_hi_res_inUser1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.trigger'


class RootLuAnalog_hi_res_inUser1AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.input_gain'


class RootLuAnalog_hi_res_inUser1AttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.current_input_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.current_input_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.current_input_value.value', float(new_val))


class RootLuAnalog_hi_res_inUser1AttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_filter = 0
        low_pass_filter = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser1AttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inUser1AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser1AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inUser1AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inUser1AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        self = 3
        position_z = 2
        position_x = 0
        position_y = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inUser1AttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.input_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.input_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.input_offset.value', float(new_val))


class RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inUser1AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_inUser1AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_inUser1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inUser1AttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inUser1AttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inUser1AttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inUser1AttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inUser1AttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inUser1AttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inUser1AttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inUser1AttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inUser1AttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inUser1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1'
        self.attribute = RootLuAnalog_hi_res_inUser1Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inUser1Trigger(self._context)
        self.busy = RootLuAnalog_hi_res_inUser1Busy(self._context)


class RootLuAnalog_hi_res_inTip_currentBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.busy'


class RootLuAnalog_hi_res_inTip_currentTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.trigger'


class RootLuAnalog_hi_res_inTip_currentAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.input_gain'


class RootLuAnalog_hi_res_inTip_currentAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.current_input_value.value', float(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_filter = 0
        low_pass_filter = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inTip_currentAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inTip_currentAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        self = 3
        position_z = 2
        position_x = 0
        position_y = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.input_offset.value', float(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_inTip_currentAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inTip_currentAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inTip_currentAttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inTip_currentAttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inTip_currentAttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inTip_currentAttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inTip_currentAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inTip_currentAttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inTip_currentAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inTip_currentAttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inTip_current(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current'
        self.attribute = RootLuAnalog_hi_res_inTip_currentAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inTip_currentTrigger(self._context)
        self.busy = RootLuAnalog_hi_res_inTip_currentBusy(self._context)


class RootLuAnalog_hi_res_inDetector_sumBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.busy'


class RootLuAnalog_hi_res_inDetector_sumTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.trigger'


class RootLuAnalog_hi_res_inDetector_sumAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.input_gain'


class RootLuAnalog_hi_res_inDetector_sumAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value.value', float(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_filter = 0
        low_pass_filter = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inDetector_sumAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inDetector_sumAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        self = 3
        position_z = 2
        position_x = 0
        position_y = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.input_offset.value', float(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inDetector_sumAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inDetector_sumAttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inDetector_sumAttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inDetector_sumAttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inDetector_sumAttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inDetector_sumAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inDetector_sumAttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inDetector_sumAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inDetector_sumAttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inDetector_sum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum'
        self.attribute = RootLuAnalog_hi_res_inDetector_sumAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inDetector_sumTrigger(self._context)
        self.busy = RootLuAnalog_hi_res_inDetector_sumBusy(self._context)


class RootLuAnalog_hi_res_inMain2AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.input_gain'


class RootLuAnalog_hi_res_inMain2AttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.current_input_value'


class RootLuAnalog_hi_res_inMain2AttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inMain2AttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inMain2AttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inMain2AttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum'

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum.positive', int(new_val))

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum.negative', int(new_val))


class RootLuAnalog_hi_res_inMain2AttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inMain2AttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inMain2AttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inMain2AttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.calib_offset'


class RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum'

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))


class RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inMain2AttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.input_offset'


class RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inMain2AttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.filter_number'


class RootLuAnalog_hi_res_inMain2AttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.calib_gain'


class RootLuAnalog_hi_res_inMain2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inMain2AttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inMain2AttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inMain2AttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inMain2AttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inMain2AttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inMain2AttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inMain2AttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inMain2AttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inMain2AttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inMain2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.trigger'


class RootLuAnalog_hi_res_inMain2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2'
        self.trigger = RootLuAnalog_hi_res_inMain2Trigger(self._context)
        self.attribute = RootLuAnalog_hi_res_inMain2Attribute(self._context)


class RootLuAnalog_hi_res_inLateralBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.busy'


class RootLuAnalog_hi_res_inLateralTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.trigger'


class RootLuAnalog_hi_res_inLateralAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.input_gain'


class RootLuAnalog_hi_res_inLateralAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.current_input_value.value', float(new_val))


class RootLuAnalog_hi_res_inLateralAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_filter = 0
        low_pass_filter = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inLateralAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inLateralAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inLateralAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inLateralAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inLateralAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        self = 3
        position_z = 2
        position_x = 0
        position_y = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inLateralAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.input_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.input_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.input_offset.value', float(new_val))


class RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inLateralAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_inLateralAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_inLateralAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inLateralAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inLateralAttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inLateralAttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inLateralAttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inLateralAttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inLateralAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inLateralAttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inLateralAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inLateralAttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inLateral(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral'
        self.attribute = RootLuAnalog_hi_res_inLateralAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inLateralTrigger(self._context)
        self.busy = RootLuAnalog_hi_res_inLateralBusy(self._context)


class RootLuAnalog_hi_res_inUser2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.busy'


class RootLuAnalog_hi_res_inUser2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.trigger'


class RootLuAnalog_hi_res_inUser2AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.input_gain'


class RootLuAnalog_hi_res_inUser2AttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.current_input_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.current_input_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.current_input_value.value', float(new_val))


class RootLuAnalog_hi_res_inUser2AttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_filter = 0
        low_pass_filter = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser2AttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inUser2AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser2AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inUser2AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inUser2AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        self = 3
        position_z = 2
        position_x = 0
        position_y = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inUser2AttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.input_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.input_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.input_offset.value', float(new_val))


class RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inUser2AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_inUser2AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_inUser2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inUser2AttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inUser2AttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inUser2AttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inUser2AttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inUser2AttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inUser2AttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inUser2AttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inUser2AttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inUser2AttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inUser2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2'
        self.attribute = RootLuAnalog_hi_res_inUser2Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inUser2Trigger(self._context)
        self.busy = RootLuAnalog_hi_res_inUser2Busy(self._context)


class RootLuAnalog_hi_res_inPosition_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.busy'


class RootLuAnalog_hi_res_inPosition_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.trigger'


class RootLuAnalog_hi_res_inPosition_zAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.input_gain'


class RootLuAnalog_hi_res_inPosition_zAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.current_input_value.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_filter = 0
        low_pass_filter = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_zAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_zAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        self = 3
        position_z = 2
        position_x = 0
        position_y = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.input_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.input_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.input_offset.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inPosition_zAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inPosition_zAttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inPosition_zAttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inPosition_zAttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inPosition_zAttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inPosition_zAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inPosition_zAttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inPosition_zAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inPosition_zAttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inPosition_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z'
        self.attribute = RootLuAnalog_hi_res_inPosition_zAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inPosition_zTrigger(self._context)
        self.busy = RootLuAnalog_hi_res_inPosition_zBusy(self._context)


class RootLuAnalog_hi_res_inPosition_yBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.busy'


class RootLuAnalog_hi_res_inPosition_yTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.trigger'


class RootLuAnalog_hi_res_inPosition_yAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.input_gain'


class RootLuAnalog_hi_res_inPosition_yAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.current_input_value.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_filter = 0
        low_pass_filter = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_yAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_yAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        self = 3
        position_z = 2
        position_x = 0
        position_y = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.input_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.input_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.input_offset.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_yAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inPosition_yAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inPosition_yAttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inPosition_yAttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inPosition_yAttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inPosition_yAttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inPosition_yAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inPosition_yAttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inPosition_yAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inPosition_yAttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inPosition_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y'
        self.attribute = RootLuAnalog_hi_res_inPosition_yAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inPosition_yTrigger(self._context)
        self.busy = RootLuAnalog_hi_res_inPosition_yBusy(self._context)


class RootLuAnalog_hi_res_inPosition_xBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.busy'


class RootLuAnalog_hi_res_inPosition_xTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.trigger'


class RootLuAnalog_hi_res_inPosition_xAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.input_gain'


class RootLuAnalog_hi_res_inPosition_xAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.current_input_value.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_filter = 0
        low_pass_filter = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_xAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_xAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        self = 3
        position_z = 2
        position_x = 0
        position_y = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.input_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.input_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.input_offset.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_inPosition_xAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inPosition_xAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inPosition_xAttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inPosition_xAttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inPosition_xAttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inPosition_xAttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inPosition_xAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inPosition_xAttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inPosition_xAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inPosition_xAttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inPosition_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x'
        self.attribute = RootLuAnalog_hi_res_inPosition_xAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inPosition_xTrigger(self._context)
        self.busy = RootLuAnalog_hi_res_inPosition_xBusy(self._context)


class RootLuAnalog_hi_res_inUser4Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.busy'


class RootLuAnalog_hi_res_inUser4Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.trigger'


class RootLuAnalog_hi_res_inUser4AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.input_gain'


class RootLuAnalog_hi_res_inUser4AttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.current_input_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.current_input_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.current_input_value.value', float(new_val))


class RootLuAnalog_hi_res_inUser4AttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_filter = 0
        low_pass_filter = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser4AttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inUser4AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser4AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inUser4AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inUser4AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        self = 3
        position_z = 2
        position_x = 0
        position_y = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inUser4AttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.input_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.input_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.input_offset.value', float(new_val))


class RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inUser4AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_inUser4AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_inUser4Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inUser4AttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inUser4AttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inUser4AttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inUser4AttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inUser4AttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inUser4AttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inUser4AttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inUser4AttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inUser4AttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inUser4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4'
        self.attribute = RootLuAnalog_hi_res_inUser4Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inUser4Trigger(self._context)
        self.busy = RootLuAnalog_hi_res_inUser4Busy(self._context)


class RootLuAnalog_hi_res_inDeflectionBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.busy'


class RootLuAnalog_hi_res_inDeflectionTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.trigger'


class RootLuAnalog_hi_res_inDeflectionAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.input_gain'


class RootLuAnalog_hi_res_inDeflectionAttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.current_input_value.value', float(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_filter = 0
        low_pass_filter = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inDeflectionAttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inDeflectionAttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        self = 3
        position_z = 2
        position_x = 0
        position_y = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.input_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.input_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.input_offset.value', float(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_inDeflectionAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inDeflectionAttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inDeflectionAttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inDeflectionAttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inDeflectionAttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inDeflectionAttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inDeflectionAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inDeflectionAttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inDeflectionAttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inDeflectionAttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inDeflection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection'
        self.attribute = RootLuAnalog_hi_res_inDeflectionAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inDeflectionTrigger(self._context)
        self.busy = RootLuAnalog_hi_res_inDeflectionBusy(self._context)


class RootLuAnalog_hi_res_inIn6Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.busy'


class RootLuAnalog_hi_res_inIn6Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.trigger'


class RootLuAnalog_hi_res_inIn6AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.input_gain'


class RootLuAnalog_hi_res_inIn6AttributeCurrent_input_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.current_input_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.current_input_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.current_input_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.current_input_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.current_input_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.current_input_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.current_input_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.current_input_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.current_input_value.value', float(new_val))


class RootLuAnalog_hi_res_inIn6AttributeFilter_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no_filter = 0
        low_pass_filter = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.filter_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inIn6AttributeFilter_mode.ValueEnum(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_mode.enum', list(new_val))


class RootLuAnalog_hi_res_inIn6AttributeCalib_polarity(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        positive = 0
        negative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.calib_polarity'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inIn6AttributeCalib_polarity.ValueEnum(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.enum', list(new_val))


class RootLuAnalog_hi_res_inIn6AttributeFilter_coeff_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inIn6AttributeCalib_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.calib_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_offset.value', float(new_val))


class RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_id(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        self = 3
        position_z = 2
        position_x = 0
        position_y = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_id.ValueEnum(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum', list(new_val))


class RootLuAnalog_hi_res_inIn6AttributeInput_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.input_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.input_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.input_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.input_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.input_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.input_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.input_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.input_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.input_offset.value', float(new_val))


class RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec.vector', list(new_val))


class RootLuAnalog_hi_res_inIn6AttributeFilter_number(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.filter_number'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_number.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_number.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_number.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_number.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_number.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_number.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_number.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_number.value', float(new_val))


class RootLuAnalog_hi_res_inIn6AttributeCalib_gain(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.calib_gain'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_gain.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_gain.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_gain.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_gain.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_gain.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_gain.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_gain.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_gain.value', float(new_val))


class RootLuAnalog_hi_res_inIn6Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute'
        self.calib_gain = RootLuAnalog_hi_res_inIn6AttributeCalib_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inIn6AttributeFilter_number(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.input_offset = RootLuAnalog_hi_res_inIn6AttributeInput_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_id(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inIn6AttributeCalib_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inIn6AttributeFilter_coeff_vec(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inIn6AttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inIn6AttributeFilter_mode(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inIn6AttributeCurrent_input_value(self._context)
        self.input_gain = RootLuAnalog_hi_res_inIn6AttributeInput_gain(self._context)


class RootLuAnalog_hi_res_inIn6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6'
        self.attribute = RootLuAnalog_hi_res_inIn6Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inIn6Trigger(self._context)
        self.busy = RootLuAnalog_hi_res_inIn6Busy(self._context)


class RootLuAnalog_hi_res_in(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in'
        self.in6 = RootLuAnalog_hi_res_inIn6(self._context)
        self.deflection = RootLuAnalog_hi_res_inDeflection(self._context)
        self.user4 = RootLuAnalog_hi_res_inUser4(self._context)
        self.position_x = RootLuAnalog_hi_res_inPosition_x(self._context)
        self.position_y = RootLuAnalog_hi_res_inPosition_y(self._context)
        self.position_z = RootLuAnalog_hi_res_inPosition_z(self._context)
        self.user2 = RootLuAnalog_hi_res_inUser2(self._context)
        self.lateral = RootLuAnalog_hi_res_inLateral(self._context)
        self.main2 = RootLuAnalog_hi_res_inMain2(self._context)
        self.detector_sum = RootLuAnalog_hi_res_inDetector_sum(self._context)
        self.tip_current = RootLuAnalog_hi_res_inTip_current(self._context)
        self.user1 = RootLuAnalog_hi_res_inUser1(self._context)
        self.user3 = RootLuAnalog_hi_res_inUser3(self._context)


class RootLuOrtInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.busy'

    @property
    def is_averaging(self) -> bool:
        return bool(self._context.call('root.lu.ort.instance.busy.is_averaging'))


class RootLuOrtInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.trigger'

    def apply_samples_values(self) -> None:
        return self._context.call('root.lu.ort.instance.trigger.apply_samples_values')

    def apply_samples_per_period(self) -> None:
        return self._context.call('root.lu.ort.instance.trigger.apply_samples_per_period')

    def update_free_wave(self) -> None:
        return self._context.call('root.lu.ort.instance.trigger.update_free_wave')

    def average_stop(self) -> None:
        return self._context.call('root.lu.ort.instance.trigger.average_stop')

    def process_averaged_samples(self) -> None:
        return self._context.call('root.lu.ort.instance.trigger.process_averaged_samples')

    def average_start(self) -> None:
        return self._context.call('root.lu.ort.instance.trigger.average_start')


class RootLuOrtInstanceAttributeBaseline_window_begin(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_window_begin'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_window_begin.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_begin.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_window_begin.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_begin.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.baseline_window_begin.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_begin.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_window_begin.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_begin.value', float(new_val))


class RootLuOrtInstanceAttributeBaseline_frequency(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_frequency'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_frequency.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_frequency.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_frequency.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_frequency.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.baseline_frequency.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.baseline_frequency.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_frequency.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_frequency.value', float(new_val))


class RootLuOrtInstanceAttributeBaseline_controller_state(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        disabled = 0
        enabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_controller_state'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuOrtInstanceAttributeBaseline_controller_state.ValueEnum(self._context.get('root.lu.ort.instance.attribute.baseline_controller_state.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ort.instance.attribute.baseline_controller_state.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.baseline_controller_state.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.baseline_controller_state.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ort.instance.attribute.baseline_controller_state.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ort.instance.attribute.baseline_controller_state.enum', list(new_val))


class RootLuOrtInstanceAttributeCantilever_samples_per_period(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        disabled = 0
        enabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.cantilever_samples_per_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.unit', str(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.enum', list(new_val))

    @property
    def value(self) -> ValueEnum:
        return RootLuOrtInstanceAttributeCantilever_samples_per_period.ValueEnum(self._context.get('root.lu.ort.instance.attribute.cantilever_samples_per_period.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ort.instance.attribute.cantilever_samples_per_period.value_raw', new_val.value)


class RootLuOrtInstanceAttributeExcitation_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.excitation_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.excitation_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.excitation_amplitude.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.excitation_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.excitation_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.excitation_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.excitation_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.excitation_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.excitation_amplitude.value', float(new_val))


class RootLuOrtInstanceAttributeAmplitude_reduction(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.amplitude_reduction'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.amplitude_reduction.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.amplitude_reduction.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.amplitude_reduction.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.amplitude_reduction.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.amplitude_reduction.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.amplitude_reduction.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.amplitude_reduction.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.amplitude_reduction.value', float(new_val))


class RootLuOrtInstanceAttributeSamples_per_period(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.samples_per_period'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.samples_per_period.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.samples_per_period.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.samples_per_period.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.samples_per_period.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.samples_per_period.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.samples_per_period.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.samples_per_period.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.samples_per_period.value', float(new_val))


class RootLuOrtInstanceAttributeBaseline_window_end(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_window_end'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_window_end.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_end.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_window_end.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_end.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.baseline_window_end.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_end.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_window_end.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_window_end.value', float(new_val))


class RootLuOrtInstanceAttributeFree_wave_delay(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.free_wave_delay'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.free_wave_delay.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.free_wave_delay.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.free_wave_delay.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.free_wave_delay.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.free_wave_delay.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.free_wave_delay.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.free_wave_delay.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.free_wave_delay.value', float(new_val))


class RootLuOrtInstanceAttributeFree_wave_output_state(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        disabled = 0
        enabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.free_wave_output_state'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuOrtInstanceAttributeFree_wave_output_state.ValueEnum(self._context.get('root.lu.ort.instance.attribute.free_wave_output_state.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ort.instance.attribute.free_wave_output_state.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.free_wave_output_state.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.free_wave_output_state.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ort.instance.attribute.free_wave_output_state.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ort.instance.attribute.free_wave_output_state.enum', list(new_val))


class RootLuOrtInstanceAttributeInput_select(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fast_in_user = 2
        hi_res_in_deflection = 1
        fast_in_deflection = 0
        hi_res_in_user1 = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.input_select'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuOrtInstanceAttributeInput_select.ValueEnum(self._context.get('root.lu.ort.instance.attribute.input_select.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ort.instance.attribute.input_select.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ort.instance.attribute.input_select.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ort.instance.attribute.input_select.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ort.instance.attribute.input_select.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ort.instance.attribute.input_select.enum', list(new_val))


class RootLuOrtInstanceAttributeAverage_periods(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.average_periods'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.average_periods.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.average_periods.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.average_periods.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.average_periods.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.average_periods.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.average_periods.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.average_periods.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.average_periods.value', float(new_val))


class RootLuOrtInstanceAttributeMin_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.min_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.min_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.min_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.min_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.min_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.min_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.min_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.min_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.min_value.value', float(new_val))


class RootLuOrtInstanceAttributeMin_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.min_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.min_position.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.min_position.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.min_position.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.min_position.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.min_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.min_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.min_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.min_position.value', float(new_val))


class RootLuOrtInstanceAttributeFeedback_amplitude_position(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.feedback_amplitude_position'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.feedback_amplitude_position.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.feedback_amplitude_position.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.feedback_amplitude_position.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.feedback_amplitude_position.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.feedback_amplitude_position.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.feedback_amplitude_position.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.feedback_amplitude_position.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.feedback_amplitude_position.value', float(new_val))


class RootLuOrtInstanceAttributeBaseline_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute.baseline_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_amplitude.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ort.instance.attribute.baseline_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ort.instance.attribute.baseline_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ort.instance.attribute.baseline_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ort.instance.attribute.baseline_amplitude.value', float(new_val))


class RootLuOrtInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance.attribute'
        self.baseline_amplitude = RootLuOrtInstanceAttributeBaseline_amplitude(self._context)
        self.feedback_amplitude_position = RootLuOrtInstanceAttributeFeedback_amplitude_position(self._context)
        self.min_position = RootLuOrtInstanceAttributeMin_position(self._context)
        self.min_value = RootLuOrtInstanceAttributeMin_value(self._context)
        self.average_periods = RootLuOrtInstanceAttributeAverage_periods(self._context)
        self.input_select = RootLuOrtInstanceAttributeInput_select(self._context)
        self.free_wave_output_state = RootLuOrtInstanceAttributeFree_wave_output_state(self._context)
        self.free_wave_delay = RootLuOrtInstanceAttributeFree_wave_delay(self._context)
        self.baseline_window_end = RootLuOrtInstanceAttributeBaseline_window_end(self._context)
        self.samples_per_period = RootLuOrtInstanceAttributeSamples_per_period(self._context)
        self.amplitude_reduction = RootLuOrtInstanceAttributeAmplitude_reduction(self._context)
        self.excitation_amplitude = RootLuOrtInstanceAttributeExcitation_amplitude(self._context)
        self.cantilever_samples_per_period = RootLuOrtInstanceAttributeCantilever_samples_per_period(self._context)
        self.baseline_controller_state = RootLuOrtInstanceAttributeBaseline_controller_state(self._context)
        self.baseline_frequency = RootLuOrtInstanceAttributeBaseline_frequency(self._context)
        self.baseline_window_begin = RootLuOrtInstanceAttributeBaseline_window_begin(self._context)


class RootLuOrtInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort.instance'
        self.attribute = RootLuOrtInstanceAttribute(self._context)
        self.trigger = RootLuOrtInstanceTrigger(self._context)
        self.busy = RootLuOrtInstanceBusy(self._context)


class RootLuOrt(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ort'
        self.instance = RootLuOrtInstance(self._context)


class RootLuRescanInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.busy'


class RootLuRescanInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.trigger'


class RootLuRescanInstanceAttributeLine_repetition_max_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.line_repetition_max_count'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max_count.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max_count.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max_count.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max_count.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max_count.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max_count.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max_count.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max_count.value', float(new_val))


class RootLuRescanInstanceAttributeEnable(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.enable'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.enable.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.enable.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.enable.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.enable.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.rescan.instance.attribute.enable.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.rescan.instance.attribute.enable.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.enable.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.enable.value', float(new_val))


class RootLuRescanInstanceAttributeLine_repetition_max(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.line_repetition_max'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_max.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_max.value', float(new_val))


class RootLuRescanInstanceAttributeLine_repetition_count(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute.line_repetition_count'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_count.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_count.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_count.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_count.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.rescan.instance.attribute.line_repetition_count.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_count.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.rescan.instance.attribute.line_repetition_count.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.rescan.instance.attribute.line_repetition_count.value', float(new_val))


class RootLuRescanInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance.attribute'
        self.line_repetition_count = RootLuRescanInstanceAttributeLine_repetition_count(self._context)
        self.line_repetition_max = RootLuRescanInstanceAttributeLine_repetition_max(self._context)
        self.enable = RootLuRescanInstanceAttributeEnable(self._context)
        self.line_repetition_max_count = RootLuRescanInstanceAttributeLine_repetition_max_count(self._context)


class RootLuRescanInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan.instance'
        self.attribute = RootLuRescanInstanceAttribute(self._context)
        self.trigger = RootLuRescanInstanceTrigger(self._context)
        self.busy = RootLuRescanInstanceBusy(self._context)


class RootLuRescan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.rescan'
        self.instance = RootLuRescanInstance(self._context)


class RootLuScanInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.busy'


class RootLuScanInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.trigger'

    def do_set_xy_sensor_data_acquisition(self) -> None:
        return self._context.call('root.lu.scan.instance.trigger.do_set_xy_sensor_data_acquisition')

    def start_move_to_start(self) -> None:
        return self._context.call('root.lu.scan.instance.trigger.start_move_to_start')

    def offset_xyz(self) -> None:
        return self._context.call('root.lu.scan.instance.trigger.offset_xyz')

    def start_do_frame(self) -> None:
        return self._context.call('root.lu.scan.instance.trigger.start_do_frame')

    def start_move_to_start_and_do_frame_quick(self) -> None:
        return self._context.call('root.lu.scan.instance.trigger.start_move_to_start_and_do_frame_quick')

    def start_move_to_start_and_do_frame(self) -> None:
        return self._context.call('root.lu.scan.instance.trigger.start_move_to_start_and_do_frame')

    def user_abort(self) -> None:
        return self._context.call('root.lu.scan.instance.trigger.user_abort')


class RootLuScanInstanceAttributeFast_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.fast_points'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.fast_points.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.fast_points.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.fast_points.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.fast_points.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.fast_points.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.fast_points.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.fast_points.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.fast_points.value', float(new_val))


class RootLuScanInstanceAttributeFirst_line_repetition(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.first_line_repetition'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.first_line_repetition.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.first_line_repetition.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.first_line_repetition.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.first_line_repetition.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.first_line_repetition.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.first_line_repetition.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.first_line_repetition.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.first_line_repetition.value', float(new_val))


class RootLuScanInstanceAttributeReadjust_lift_height(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.readjust_lift_height'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.readjust_lift_height.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.readjust_lift_height.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.readjust_lift_height.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.readjust_lift_height.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.readjust_lift_height.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.readjust_lift_height.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.readjust_lift_height.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.readjust_lift_height.value', float(new_val))


class RootLuScanInstanceAttributeXy_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.xy_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.xy_move_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.xy_move_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.xy_move_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.xy_move_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.xy_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.xy_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.xy_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.xy_move_speed.value', float(new_val))


class RootLuScanInstanceAttributeLine_z_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.line_z_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.line_z_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.line_z_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.line_z_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.line_z_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.line_z_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.line_z_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.line_z_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.line_z_offset.value', float(new_val))


class RootLuScanInstanceAttributeSnd_scan_dynamic_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude.value', float(new_val))


class RootLuScanInstanceAttributeSnd_scan_enable_dark_mode(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_enable_dark_mode'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_enable_dark_mode.value', float(new_val))


class RootLuScanInstanceAttributeSnd_scan_enable_kpfm(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_enable_kpfm'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_enable_kpfm.value', float(new_val))


class RootLuScanInstanceAttributeContour_data_channel(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.contour_data_channel'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.contour_data_channel.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.contour_data_channel.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.contour_data_channel.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.contour_data_channel.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.contour_data_channel.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.contour_data_channel.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.contour_data_channel.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.contour_data_channel.value', float(new_val))


class RootLuScanInstanceAttributeSlow_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.slow_points'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.slow_points.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.slow_points.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.slow_points.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.slow_points.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.slow_points.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.slow_points.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.slow_points.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.slow_points.value', float(new_val))


class RootLuScanInstanceAttributeOverscan_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.overscan_points'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.overscan_points.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.overscan_points.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.overscan_points.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.overscan_points.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.overscan_points.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.overscan_points.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.overscan_points.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.overscan_points.value', float(new_val))


class RootLuScanInstanceAttributeX_rotation(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.x_rotation'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.x_rotation.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.x_rotation.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.x_rotation.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.x_rotation.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.x_rotation.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.x_rotation.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.x_rotation.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.x_rotation.value', float(new_val))


class RootLuScanInstanceAttributeContour_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.contour_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.contour_enabled.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.contour_enabled.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.contour_enabled.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.contour_enabled.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.contour_enabled.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.contour_enabled.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.contour_enabled.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.contour_enabled.value', float(new_val))


class RootLuScanInstanceAttributeSnd_scan_force_modulation_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude.value', float(new_val))


class RootLuScanInstanceAttributeSnd_scan_force_modulation_amplitude_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_force_modulation_amplitude_enabled.value', float(new_val))


class RootLuScanInstanceAttributeSlow_increment(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.slow_increment'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.slow_increment.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.slow_increment.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.slow_increment.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.slow_increment.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.slow_increment.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.slow_increment.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.slow_increment.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.slow_increment.value', float(new_val))


class RootLuScanInstanceAttributeZ_move_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.z_move_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.z_move_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.z_move_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.z_move_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.z_move_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.z_move_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.z_move_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.z_move_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.z_move_speed.value', float(new_val))


class RootLuScanInstanceAttributeSlow_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.slow_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.slow_range.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.slow_range.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.slow_range.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.slow_range.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.slow_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.slow_range.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.slow_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.slow_range.value', float(new_val))


class RootLuScanInstanceAttributeZ_rotation(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.z_rotation'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.z_rotation.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.z_rotation.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.z_rotation.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.z_rotation.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.z_rotation.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.z_rotation.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.z_rotation.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.z_rotation.value', float(new_val))


class RootLuScanInstanceAttributeAuto_readjust_probe_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.auto_readjust_probe_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.auto_readjust_probe_enabled.value', float(new_val))


class RootLuScanInstanceAttributeX_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.x_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.x_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.x_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.x_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.x_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.x_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.x_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.x_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.x_offset.value', float(new_val))


class RootLuScanInstanceAttributeZ_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.z_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.z_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.z_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.z_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.z_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.z_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.z_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.z_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.z_offset.value', float(new_val))


class RootLuScanInstanceAttributeY_offset(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.y_offset'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.y_offset.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.y_offset.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.y_offset.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.y_offset.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.y_offset.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.y_offset.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.y_offset.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.y_offset.value', float(new_val))


class RootLuScanInstanceAttributeSnd_scan_dynamic_amplitude_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_dynamic_amplitude_enabled.value', float(new_val))


class RootLuScanInstanceAttributeLine_scanning(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        dual_scan = 1
        standard = 0
        snd_scan_only = 3
        interlaced = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.line_scanning'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanInstanceAttributeLine_scanning.ValueEnum(self._context.get('root.lu.scan.instance.attribute.line_scanning.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scan.instance.attribute.line_scanning.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scan.instance.attribute.line_scanning.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scan.instance.attribute.line_scanning.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scan.instance.attribute.line_scanning.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scan.instance.attribute.line_scanning.enum', list(new_val))


class RootLuScanInstanceAttributeTime_per_line(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.time_per_line'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.time_per_line.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.time_per_line.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.time_per_line.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.time_per_line.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.time_per_line.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.time_per_line.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.time_per_line.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.time_per_line.value', float(new_val))


class RootLuScanInstanceAttributeFast_range(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.fast_range'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.fast_range.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.fast_range.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.fast_range.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.fast_range.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.fast_range.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.fast_range.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.fast_range.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.fast_range.value', float(new_val))


class RootLuScanInstanceAttributeSnd_scan_snd_lock_in_excitation_amplitude_enabled(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude_enabled.value', float(new_val))


class RootLuScanInstanceAttributeBackward_fast_points(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.backward_fast_points'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.backward_fast_points.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.backward_fast_points.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.backward_fast_points.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.backward_fast_points.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.backward_fast_points.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.backward_fast_points.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.backward_fast_points.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.backward_fast_points.value', float(new_val))


class RootLuScanInstanceAttributeSnd_scan_snd_lock_in_excitation_amplitude(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.snd_scan_snd_lock_in_excitation_amplitude.value', float(new_val))


class RootLuScanInstanceAttributeLinearization_enable(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        disabled = 0
        enabled = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.linearization_enable'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanInstanceAttributeLinearization_enable.ValueEnum(self._context.get('root.lu.scan.instance.attribute.linearization_enable.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scan.instance.attribute.linearization_enable.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scan.instance.attribute.linearization_enable.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scan.instance.attribute.linearization_enable.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scan.instance.attribute.linearization_enable.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scan.instance.attribute.linearization_enable.enum', list(new_val))


class RootLuScanInstanceAttributeMove_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        lifted = 1
        controlled = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.move_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanInstanceAttributeMove_mode.ValueEnum(self._context.get('root.lu.scan.instance.attribute.move_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scan.instance.attribute.move_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scan.instance.attribute.move_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scan.instance.attribute.move_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scan.instance.attribute.move_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scan.instance.attribute.move_mode.enum', list(new_val))


class RootLuScanInstanceAttributeScan_direction_slow_axis(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        upward = 1
        downward = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.scan_direction_slow_axis'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanInstanceAttributeScan_direction_slow_axis.ValueEnum(self._context.get('root.lu.scan.instance.attribute.scan_direction_slow_axis.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scan.instance.attribute.scan_direction_slow_axis.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scan.instance.attribute.scan_direction_slow_axis.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scan.instance.attribute.scan_direction_slow_axis.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scan.instance.attribute.scan_direction_slow_axis.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scan.instance.attribute.scan_direction_slow_axis.enum', list(new_val))


class RootLuScanInstanceAttributeSlow_axis_move_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        continuous = 2
        stepwise = 0
        serpentine = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.slow_axis_move_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanInstanceAttributeSlow_axis_move_mode.ValueEnum(self._context.get('root.lu.scan.instance.attribute.slow_axis_move_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scan.instance.attribute.slow_axis_move_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scan.instance.attribute.slow_axis_move_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scan.instance.attribute.slow_axis_move_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scan.instance.attribute.slow_axis_move_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scan.instance.attribute.slow_axis_move_mode.enum', list(new_val))


class RootLuScanInstanceAttributeY_rotation(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.y_rotation'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.y_rotation.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.y_rotation.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.y_rotation.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.y_rotation.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scan.instance.attribute.y_rotation.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scan.instance.attribute.y_rotation.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scan.instance.attribute.y_rotation.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scan.instance.attribute.y_rotation.value', float(new_val))


class RootLuScanInstanceAttributeGenerator(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        linear_line = 0
        generic_frame = 2
        generic_frame_fast = 3
        generic_line = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute.generator'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanInstanceAttributeGenerator.ValueEnum(self._context.get('root.lu.scan.instance.attribute.generator.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scan.instance.attribute.generator.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scan.instance.attribute.generator.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scan.instance.attribute.generator.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scan.instance.attribute.generator.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scan.instance.attribute.generator.enum', list(new_val))


class RootLuScanInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance.attribute'
        self.generator = RootLuScanInstanceAttributeGenerator(self._context)
        self.y_rotation = RootLuScanInstanceAttributeY_rotation(self._context)
        self.slow_axis_move_mode = RootLuScanInstanceAttributeSlow_axis_move_mode(self._context)
        self.scan_direction_slow_axis = RootLuScanInstanceAttributeScan_direction_slow_axis(self._context)
        self.move_mode = RootLuScanInstanceAttributeMove_mode(self._context)
        self.linearization_enable = RootLuScanInstanceAttributeLinearization_enable(self._context)
        self.snd_scan_snd_lock_in_excitation_amplitude = RootLuScanInstanceAttributeSnd_scan_snd_lock_in_excitation_amplitude(self._context)
        self.backward_fast_points = RootLuScanInstanceAttributeBackward_fast_points(self._context)
        self.snd_scan_snd_lock_in_excitation_amplitude_enabled = RootLuScanInstanceAttributeSnd_scan_snd_lock_in_excitation_amplitude_enabled(self._context)
        self.fast_range = RootLuScanInstanceAttributeFast_range(self._context)
        self.time_per_line = RootLuScanInstanceAttributeTime_per_line(self._context)
        self.line_scanning = RootLuScanInstanceAttributeLine_scanning(self._context)
        self.snd_scan_dynamic_amplitude_enabled = RootLuScanInstanceAttributeSnd_scan_dynamic_amplitude_enabled(self._context)
        self.y_offset = RootLuScanInstanceAttributeY_offset(self._context)
        self.z_offset = RootLuScanInstanceAttributeZ_offset(self._context)
        self.x_offset = RootLuScanInstanceAttributeX_offset(self._context)
        self.auto_readjust_probe_enabled = RootLuScanInstanceAttributeAuto_readjust_probe_enabled(self._context)
        self.z_rotation = RootLuScanInstanceAttributeZ_rotation(self._context)
        self.slow_range = RootLuScanInstanceAttributeSlow_range(self._context)
        self.z_move_speed = RootLuScanInstanceAttributeZ_move_speed(self._context)
        self.slow_increment = RootLuScanInstanceAttributeSlow_increment(self._context)
        self.snd_scan_force_modulation_amplitude_enabled = RootLuScanInstanceAttributeSnd_scan_force_modulation_amplitude_enabled(self._context)
        self.snd_scan_force_modulation_amplitude = RootLuScanInstanceAttributeSnd_scan_force_modulation_amplitude(self._context)
        self.contour_enabled = RootLuScanInstanceAttributeContour_enabled(self._context)
        self.x_rotation = RootLuScanInstanceAttributeX_rotation(self._context)
        self.overscan_points = RootLuScanInstanceAttributeOverscan_points(self._context)
        self.slow_points = RootLuScanInstanceAttributeSlow_points(self._context)
        self.contour_data_channel = RootLuScanInstanceAttributeContour_data_channel(self._context)
        self.snd_scan_enable_kpfm = RootLuScanInstanceAttributeSnd_scan_enable_kpfm(self._context)
        self.snd_scan_enable_dark_mode = RootLuScanInstanceAttributeSnd_scan_enable_dark_mode(self._context)
        self.snd_scan_dynamic_amplitude = RootLuScanInstanceAttributeSnd_scan_dynamic_amplitude(self._context)
        self.line_z_offset = RootLuScanInstanceAttributeLine_z_offset(self._context)
        self.xy_move_speed = RootLuScanInstanceAttributeXy_move_speed(self._context)
        self.readjust_lift_height = RootLuScanInstanceAttributeReadjust_lift_height(self._context)
        self.first_line_repetition = RootLuScanInstanceAttributeFirst_line_repetition(self._context)
        self.fast_points = RootLuScanInstanceAttributeFast_points(self._context)


class RootLuScanInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan.instance'
        self.attribute = RootLuScanInstanceAttribute(self._context)
        self.trigger = RootLuScanInstanceTrigger(self._context)
        self.busy = RootLuScanInstanceBusy(self._context)


class RootLuScan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scan'
        self.instance = RootLuScanInstance(self._context)


class RootLuScanheadInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.busy'


class RootLuScanheadInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger'

    def enable_pte_laser(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.enable_pte_laser')

    def apply_tilt_mode(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.apply_tilt_mode')

    def disable_piezo_electric_excitation(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.disable_piezo_electric_excitation')

    def disable_readout_laser(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.disable_readout_laser')

    def enable_readout_laser(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.enable_readout_laser')

    def disable_electro_thermal_excitation(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.disable_electro_thermal_excitation')

    def enable_electro_thermal_excitation(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.enable_electro_thermal_excitation')

    def enable_piezo_electric_excitation(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.enable_piezo_electric_excitation')

    def disable_pte_laser(self) -> None:
        return self._context.call('root.lu.scanhead.instance.trigger.disable_pte_laser')


class RootLuScanheadInstanceAttributePte_laser_setpoint(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.pte_laser_setpoint'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_setpoint.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_setpoint.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_setpoint.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_setpoint.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_setpoint.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_setpoint.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_setpoint.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_setpoint.value', float(new_val))


class RootLuScanheadInstanceAttributePte_laser_power_monitor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.pte_laser_power_monitor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.pte_laser_power_monitor.value', float(new_val))


class RootLuScanheadInstanceAttributeHas_z_sensor(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no = 0
        yes = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_z_sensor'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanheadInstanceAttributeHas_z_sensor.ValueEnum(self._context.get('root.lu.scanhead.instance.attribute.has_z_sensor.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scanhead.instance.attribute.has_z_sensor.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.has_z_sensor.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.has_z_sensor.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scanhead.instance.attribute.has_z_sensor.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scanhead.instance.attribute.has_z_sensor.enum', list(new_val))


class RootLuScanheadInstanceAttributeTilt_angle_y(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_angle_y'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_y.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_y.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_y.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_y.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_y.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_y.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_y.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_y.value', float(new_val))


class RootLuScanheadInstanceAttributeTilt_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        measured = 1
        override = 0

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanheadInstanceAttributeTilt_mode.ValueEnum(self._context.get('root.lu.scanhead.instance.attribute.tilt_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.tilt_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scanhead.instance.attribute.tilt_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_mode.enum', list(new_val))


class RootLuScanheadInstanceAttributeReadout_laser_power_monitor(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.readout_laser_power_monitor'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_power_monitor.value', float(new_val))


class RootLuScanheadInstanceAttributeReadout_laser_setpoint(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.readout_laser_setpoint'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_setpoint.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_setpoint.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_setpoint.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_setpoint.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_setpoint.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_setpoint.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.readout_laser_setpoint.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.readout_laser_setpoint.value', float(new_val))


class RootLuScanheadInstanceAttributeType(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        semafm = 16
        arac = 17
        dummy3 = 3
        nanite_afm = 12
        p6_mount = 21
        not_connected = 0
        e_afm = 9
        dummy10 = 10
        afsem = 13
        unknown = 1
        e_stm = 2
        core_afm = 19
        lens_afm = 15
        dummy4 = 4
        dummy6 = 6
        dummy5 = 5
        dummy8 = 8
        dummy7 = 7
        cytomass = 20
        dummy11 = 11
        flex_afm = 14
        p6 = 18

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.type'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanheadInstanceAttributeType.ValueEnum(self._context.get('root.lu.scanhead.instance.attribute.type.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scanhead.instance.attribute.type.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scanhead.instance.attribute.type.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum', list(new_val))


class RootLuScanheadInstanceAttributeTilt_angle_x(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_angle_x'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_x.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_x.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_x.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_x.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_x.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_x.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.scanhead.instance.attribute.tilt_angle_x.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_angle_x.value', float(new_val))


class RootLuScanheadInstanceAttributeFast_in2_channel(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        addon_in = 1
        friction_channel = 0
        pte_monitor = 2

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.fast_in2_channel'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanheadInstanceAttributeFast_in2_channel.ValueEnum(self._context.get('root.lu.scanhead.instance.attribute.fast_in2_channel.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scanhead.instance.attribute.fast_in2_channel.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.fast_in2_channel.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.fast_in2_channel.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scanhead.instance.attribute.fast_in2_channel.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scanhead.instance.attribute.fast_in2_channel.enum', list(new_val))


class RootLuScanheadInstanceAttributeHas_xy_sensor(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        no = 0
        yes = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_xy_sensor'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuScanheadInstanceAttributeHas_xy_sensor.ValueEnum(self._context.get('root.lu.scanhead.instance.attribute.has_xy_sensor.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.scanhead.instance.attribute.has_xy_sensor.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.has_xy_sensor.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.has_xy_sensor.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.scanhead.instance.attribute.has_xy_sensor.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.scanhead.instance.attribute.has_xy_sensor.enum', list(new_val))


class RootLuScanheadInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute'
        self.has_xy_sensor = RootLuScanheadInstanceAttributeHas_xy_sensor(self._context)
        self.fast_in2_channel = RootLuScanheadInstanceAttributeFast_in2_channel(self._context)
        self.tilt_angle_x = RootLuScanheadInstanceAttributeTilt_angle_x(self._context)
        self.type = RootLuScanheadInstanceAttributeType(self._context)
        self.readout_laser_setpoint = RootLuScanheadInstanceAttributeReadout_laser_setpoint(self._context)
        self.readout_laser_power_monitor = RootLuScanheadInstanceAttributeReadout_laser_power_monitor(self._context)
        self.tilt_mode = RootLuScanheadInstanceAttributeTilt_mode(self._context)
        self.tilt_angle_y = RootLuScanheadInstanceAttributeTilt_angle_y(self._context)
        self.has_z_sensor = RootLuScanheadInstanceAttributeHas_z_sensor(self._context)
        self.pte_laser_power_monitor = RootLuScanheadInstanceAttributePte_laser_power_monitor(self._context)
        self.pte_laser_setpoint = RootLuScanheadInstanceAttributePte_laser_setpoint(self._context)


class RootLuScanheadInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance'
        self.attribute = RootLuScanheadInstanceAttribute(self._context)
        self.trigger = RootLuScanheadInstanceTrigger(self._context)
        self.busy = RootLuScanheadInstanceBusy(self._context)


class RootLuScanhead(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead'
        self.instance = RootLuScanheadInstance(self._context)


class RootLuSequencerInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.busy'

    @property
    def is_running(self) -> bool:
        return bool(self._context.call('root.lu.sequencer.instance.busy.is_running'))


class RootLuSequencerInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.sequencer.instance.trigger.start')

    def step(self) -> None:
        return self._context.call('root.lu.sequencer.instance.trigger.step')

    def abort(self) -> None:
        return self._context.call('root.lu.sequencer.instance.trigger.abort')


class RootLuSequencerInstanceAttributeInstruction_pointer(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute.instruction_pointer'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.instruction_pointer.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.instruction_pointer.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.instruction_pointer.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.instruction_pointer.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.sequencer.instance.attribute.instruction_pointer.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.sequencer.instance.attribute.instruction_pointer.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.instruction_pointer.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.instruction_pointer.value', float(new_val))


class RootLuSequencerInstanceAttributeMemory_vec(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute.memory_vec'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.memory_vec.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.memory_vec.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.memory_vec.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.memory_vec.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.sequencer.instance.attribute.memory_vec.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.sequencer.instance.attribute.memory_vec.unit', str(new_val))

    @property
    def value(self) -> list:
        return list(self._context.get('root.lu.sequencer.instance.attribute.memory_vec.vector'))

    @value.setter
    def value(self, new_val:list):
        self._context.set('root.lu.sequencer.instance.attribute.memory_vec.vector', list(new_val))


class RootLuSequencerInstanceAttributeStatus(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute.status'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.status.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.status.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.status.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.status.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.sequencer.instance.attribute.status.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.sequencer.instance.attribute.status.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.sequencer.instance.attribute.status.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.sequencer.instance.attribute.status.value', float(new_val))


class RootLuSequencerInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute'
        self.status = RootLuSequencerInstanceAttributeStatus(self._context)
        self.memory_vec = RootLuSequencerInstanceAttributeMemory_vec(self._context)
        self.instruction_pointer = RootLuSequencerInstanceAttributeInstruction_pointer(self._context)


class RootLuSequencerInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance'
        self.attribute = RootLuSequencerInstanceAttribute(self._context)
        self.trigger = RootLuSequencerInstanceTrigger(self._context)
        self.busy = RootLuSequencerInstanceBusy(self._context)


class RootLuSequencer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer'
        self.instance = RootLuSequencerInstance(self._context)


class RootLuRamp_generatorVirtual0Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.virtual0.busy.is_moving'))


class RootLuRamp_generatorVirtual0Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual0.trigger.abort')


class RootLuRamp_generatorVirtual0AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual0AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual0AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        is_moving = 0
        reached_lower_limit = 2
        stopped_by_external_event = 4
        reached_endposition = 1
        reached_upper_limit = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual0AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum', list(new_val))


class RootLuRamp_generatorVirtual0AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorVirtual0AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual0AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual0Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute'
        self.end_value_mode = RootLuRamp_generatorVirtual0AttributeEnd_value_mode(self._context)
        self.moving_time = RootLuRamp_generatorVirtual0AttributeMoving_time(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual0AttributeLower_limit(self._context)
        self.current_value = RootLuRamp_generatorVirtual0AttributeCurrent_value(self._context)
        self.end_value_relative = RootLuRamp_generatorVirtual0AttributeEnd_value_relative(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual0AttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual0AttributeUpper_limit(self._context)
        self.status = RootLuRamp_generatorVirtual0AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual0AttributeMoving_mode(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual0AttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorVirtual0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0'
        self.attribute = RootLuRamp_generatorVirtual0Attribute(self._context)
        self.trigger = RootLuRamp_generatorVirtual0Trigger(self._context)
        self.busy = RootLuRamp_generatorVirtual0Busy(self._context)


class RootLuRamp_generatorUser1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.user1.busy.is_moving'))


class RootLuRamp_generatorUser1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.user1.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.user1.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.user1.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.user1.trigger.abort')


class RootLuRamp_generatorUser1AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorUser1AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser1AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorUser1AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        is_moving = 0
        reached_lower_limit = 2
        stopped_by_external_event = 4
        reached_endposition = 1
        reached_upper_limit = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser1AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.user1.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum', list(new_val))


class RootLuRamp_generatorUser1AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorUser1AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorUser1AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorUser1AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorUser1AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorUser1AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user1.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user1.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorUser1AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser1AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorUser1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute'
        self.end_value_mode = RootLuRamp_generatorUser1AttributeEnd_value_mode(self._context)
        self.moving_time = RootLuRamp_generatorUser1AttributeMoving_time(self._context)
        self.lower_limit = RootLuRamp_generatorUser1AttributeLower_limit(self._context)
        self.current_value = RootLuRamp_generatorUser1AttributeCurrent_value(self._context)
        self.end_value_relative = RootLuRamp_generatorUser1AttributeEnd_value_relative(self._context)
        self.moving_speed = RootLuRamp_generatorUser1AttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorUser1AttributeUpper_limit(self._context)
        self.status = RootLuRamp_generatorUser1AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorUser1AttributeMoving_mode(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser1AttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorUser1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1'
        self.attribute = RootLuRamp_generatorUser1Attribute(self._context)
        self.trigger = RootLuRamp_generatorUser1Trigger(self._context)
        self.busy = RootLuRamp_generatorUser1Busy(self._context)


class RootLuRamp_generatorUser4Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.user4.busy.is_moving'))


class RootLuRamp_generatorUser4Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.user4.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.user4.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.user4.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.user4.trigger.abort')


class RootLuRamp_generatorUser4AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorUser4AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser4AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorUser4AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        is_moving = 0
        reached_lower_limit = 2
        stopped_by_external_event = 4
        reached_endposition = 1
        reached_upper_limit = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser4AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.user4.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum', list(new_val))


class RootLuRamp_generatorUser4AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorUser4AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorUser4AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorUser4AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorUser4AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorUser4AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.user4.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.user4.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorUser4AttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('str')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorUser4AttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorUser4Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute'
        self.end_value_mode = RootLuRamp_generatorUser4AttributeEnd_value_mode(self._context)
        self.moving_time = RootLuRamp_generatorUser4AttributeMoving_time(self._context)
        self.lower_limit = RootLuRamp_generatorUser4AttributeLower_limit(self._context)
        self.current_value = RootLuRamp_generatorUser4AttributeCurrent_value(self._context)
        self.end_value_relative = RootLuRamp_generatorUser4AttributeEnd_value_relative(self._context)
        self.moving_speed = RootLuRamp_generatorUser4AttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorUser4AttributeUpper_limit(self._context)
        self.status = RootLuRamp_generatorUser4AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorUser4AttributeMoving_mode(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser4AttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorUser4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4'
        self.attribute = RootLuRamp_generatorUser4Attribute(self._context)
        self.trigger = RootLuRamp_generatorUser4Trigger(self._context)
        self.busy = RootLuRamp_generatorUser4Busy(self._context)


class RootLuRamp_generatorPosition_xBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.position_x.busy.is_moving'))


class RootLuRamp_generatorPosition_xTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.position_x.trigger.abort')


class RootLuRamp_generatorPosition_xAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_xAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorPosition_xAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        is_moving = 0
        reached_lower_limit = 2
        stopped_by_external_event = 4
        reached_endposition = 1
        reached_upper_limit = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_xAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.position_x.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum', list(new_val))


class RootLuRamp_generatorPosition_xAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorPosition_xAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorPosition_xAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorPosition_xAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute'
        self.end_value_mode = RootLuRamp_generatorPosition_xAttributeEnd_value_mode(self._context)
        self.moving_time = RootLuRamp_generatorPosition_xAttributeMoving_time(self._context)
        self.lower_limit = RootLuRamp_generatorPosition_xAttributeLower_limit(self._context)
        self.current_value = RootLuRamp_generatorPosition_xAttributeCurrent_value(self._context)
        self.end_value_relative = RootLuRamp_generatorPosition_xAttributeEnd_value_relative(self._context)
        self.moving_speed = RootLuRamp_generatorPosition_xAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_xAttributeUpper_limit(self._context)
        self.status = RootLuRamp_generatorPosition_xAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_xAttributeMoving_mode(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_xAttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorPosition_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x'
        self.attribute = RootLuRamp_generatorPosition_xAttribute(self._context)
        self.trigger = RootLuRamp_generatorPosition_xTrigger(self._context)
        self.busy = RootLuRamp_generatorPosition_xBusy(self._context)


class RootLuRamp_generatorCtrl_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.ctrl_z.busy.is_moving'))


class RootLuRamp_generatorCtrl_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.ctrl_z.trigger.abort')


class RootLuRamp_generatorCtrl_zAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorCtrl_zAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorCtrl_zAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        is_moving = 0
        reached_lower_limit = 2
        stopped_by_external_event = 4
        reached_endposition = 1
        reached_upper_limit = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorCtrl_zAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum', list(new_val))


class RootLuRamp_generatorCtrl_zAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorCtrl_zAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorCtrl_zAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorCtrl_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute'
        self.end_value_mode = RootLuRamp_generatorCtrl_zAttributeEnd_value_mode(self._context)
        self.moving_time = RootLuRamp_generatorCtrl_zAttributeMoving_time(self._context)
        self.lower_limit = RootLuRamp_generatorCtrl_zAttributeLower_limit(self._context)
        self.current_value = RootLuRamp_generatorCtrl_zAttributeCurrent_value(self._context)
        self.end_value_relative = RootLuRamp_generatorCtrl_zAttributeEnd_value_relative(self._context)
        self.moving_speed = RootLuRamp_generatorCtrl_zAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorCtrl_zAttributeUpper_limit(self._context)
        self.status = RootLuRamp_generatorCtrl_zAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorCtrl_zAttributeMoving_mode(self._context)
        self.end_value_absolute = RootLuRamp_generatorCtrl_zAttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorCtrl_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z'
        self.attribute = RootLuRamp_generatorCtrl_zAttribute(self._context)
        self.trigger = RootLuRamp_generatorCtrl_zTrigger(self._context)
        self.busy = RootLuRamp_generatorCtrl_zBusy(self._context)


class RootLuRamp_generatorTip_voltageBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.tip_voltage.busy.is_moving'))


class RootLuRamp_generatorTip_voltageTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.tip_voltage.trigger.abort')


class RootLuRamp_generatorTip_voltageAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTip_voltageAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorTip_voltageAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        is_moving = 0
        reached_lower_limit = 2
        stopped_by_external_event = 4
        reached_endposition = 1
        reached_upper_limit = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTip_voltageAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum', list(new_val))


class RootLuRamp_generatorTip_voltageAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorTip_voltageAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorTip_voltageAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorTip_voltageAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute'
        self.end_value_mode = RootLuRamp_generatorTip_voltageAttributeEnd_value_mode(self._context)
        self.moving_time = RootLuRamp_generatorTip_voltageAttributeMoving_time(self._context)
        self.lower_limit = RootLuRamp_generatorTip_voltageAttributeLower_limit(self._context)
        self.current_value = RootLuRamp_generatorTip_voltageAttributeCurrent_value(self._context)
        self.end_value_relative = RootLuRamp_generatorTip_voltageAttributeEnd_value_relative(self._context)
        self.moving_speed = RootLuRamp_generatorTip_voltageAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorTip_voltageAttributeUpper_limit(self._context)
        self.status = RootLuRamp_generatorTip_voltageAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorTip_voltageAttributeMoving_mode(self._context)
        self.end_value_absolute = RootLuRamp_generatorTip_voltageAttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorTip_voltage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage'
        self.attribute = RootLuRamp_generatorTip_voltageAttribute(self._context)
        self.trigger = RootLuRamp_generatorTip_voltageTrigger(self._context)
        self.busy = RootLuRamp_generatorTip_voltageBusy(self._context)


class RootLuRamp_generatorApproachBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.approach.busy.is_moving'))


class RootLuRamp_generatorApproachTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.approach.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.approach.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.approach.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.approach.trigger.abort')


class RootLuRamp_generatorApproachAttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorApproachAttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorApproachAttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorApproachAttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        is_moving = 0
        reached_lower_limit = 2
        stopped_by_external_event = 4
        reached_endposition = 1
        reached_upper_limit = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorApproachAttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.approach.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum', list(new_val))


class RootLuRamp_generatorApproachAttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorApproachAttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorApproachAttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorApproachAttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorApproachAttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorApproachAttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.approach.attribute.moving_time.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_time.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.approach.attribute.moving_time.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_time.value', float(new_val))


class RootLuRamp_generatorApproachAttributeEnd_value_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        move_to_absolute = 0
        move_relative = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorApproachAttributeEnd_value_mode.ValueEnum(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.enum', list(new_val))


class RootLuRamp_generatorApproachAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute'
        self.end_value_mode = RootLuRamp_generatorApproachAttributeEnd_value_mode(self._context)
        self.moving_time = RootLuRamp_generatorApproachAttributeMoving_time(self._context)
        self.lower_limit = RootLuRamp_generatorApproachAttributeLower_limit(self._context)
        self.current_value = RootLuRamp_generatorApproachAttributeCurrent_value(self._context)
        self.end_value_relative = RootLuRamp_generatorApproachAttributeEnd_value_relative(self._context)
        self.moving_speed = RootLuRamp_generatorApproachAttributeMoving_speed(self._context)
        self.upper_limit = RootLuRamp_generatorApproachAttributeUpper_limit(self._context)
        self.status = RootLuRamp_generatorApproachAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorApproachAttributeMoving_mode(self._context)
        self.end_value_absolute = RootLuRamp_generatorApproachAttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach'
        self.attribute = RootLuRamp_generatorApproachAttribute(self._context)
        self.trigger = RootLuRamp_generatorApproachTrigger(self._context)
        self.busy = RootLuRamp_generatorApproachBusy(self._context)


class RootLuRamp_generatorVirtual1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.busy'

    @property
    def is_moving(self) -> bool:
        return bool(self._context.call('root.lu.ramp_generator.virtual1.busy.is_moving'))


class RootLuRamp_generatorVirtual1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger'

    def start(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.start')

    def stop(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.stop')

    def prepare(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.prepare')

    def abort(self) -> None:
        return self._context.call('root.lu.ramp_generator.virtual1.trigger.abort')


class RootLuRamp_generatorVirtual1AttributeEnd_value_absolute(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_absolute'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_absolute.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeMoving_mode(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        fix_time = 0
        fix_speed = 1

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_mode'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual1AttributeMoving_mode.ValueEnum(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum', list(new_val))


class RootLuRamp_generatorVirtual1AttributeStatus(wrap.CmdTreeProp):

    class ValueEnum(enum.Enum):
        is_moving = 0
        reached_lower_limit = 2
        stopped_by_external_event = 4
        reached_endposition = 1
        reached_upper_limit = 3

    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.status'
        self._lua_value_type = wrap.LuaType('list')

    @property
    def value(self) -> ValueEnum:
        return RootLuRamp_generatorVirtual1AttributeStatus.ValueEnum(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.value_raw'))

    @value.setter
    def value(self, new_val:ValueEnum):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.value_raw', new_val.value)

    @property
    def value_raw(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.value_raw'))

    @value_raw.setter
    def value_raw(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.value_raw', int(new_val))

    @property
    def enum(self) -> list:
        return list(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum'))

    @enum.setter
    def enum(self, new_val:list):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum', list(new_val))


class RootLuRamp_generatorVirtual1AttributeUpper_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.upper_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.upper_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.upper_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.upper_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.upper_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.upper_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.upper_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.upper_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.upper_limit.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeMoving_speed(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_speed'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_speed.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_speed.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_speed.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_speed.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_speed.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_speed.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_speed.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_speed.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeEnd_value_relative(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_relative'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_relative.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_relative.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_relative.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_relative.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_relative.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_relative.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_relative.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_relative.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeCurrent_value(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.current_value'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.current_value.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.current_value.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.current_value.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.current_value.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.current_value.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.current_value.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.current_value.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.current_value.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeLower_limit(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.lower_limit'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.lower_limit.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.lower_limit.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.lower_limit.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.lower_limit.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator.virtual1.attribute.lower_limit.unit'))

    @unit.setter
    def unit(self, new_val:str):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.lower_limit.unit', str(new_val))

    @property
    def value(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.lower_limit.value'))

    @value.setter
    def value(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.lower_limit.value', float(new_val))


class RootLuRamp_generatorVirtual1AttributeMoving_time(wrap.CmdTreeProp):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_time'
        self._lua_value_type = wrap.LuaType('float')

    @property
    def min(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_time.min'))

    @min.setter
    def min(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_time.min', float(new_val))

    @property
    def max(self) -> float:
        return float(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_time.max'))

    @max.setter
    def max(self, new_val:float):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_time.max', float(new_val))

    @property
    def unit(self) -> str:
        return str(self._context.get('root.lu.ramp_generator