# studio_wrapper.py

import enum
from typing import Any
import nanosurf.lib.spm.studio.wrapper as wrap

g_cmd_tree_hash = 'e4f686ead150a3611dcbc3fc9a3dfce4'
g_compiler_version = '2.0'

class RootSession(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.session'

    def select_main(self, *args) -> Any:
        return self._context.call('root.session.select_main', *args)

    def select(self, *args) -> Any:
        return self._context.call('root.session.select', *args)

    @property
    def current_connection(self) -> str:
        return str(self._context.get('root.session.current_connection'))

    @current_connection.setter
    def current_connection(self, new_val:str):
        self._context.set('root.session.current_connection', str(new_val))

    def list(self, *args) -> Any:
        return self._context.call('root.session.list', *args)

    @property
    def name(self) -> str:
        return str(self._context.get('root.session.name'))

    @name.setter
    def name(self, new_val:str):
        self._context.set('root.session.name', str(new_val))


class RootTestTabel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.test.tabel'


class RootTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.test'
        self.tabel = RootTestTabel(self._context)

    def func(self, *args) -> Any:
        return self._context.call('root.test.func', *args)

    @property
    def num_f(self) -> float:
        return float(self._context.get('root.test.num_f'))

    @num_f.setter
    def num_f(self, new_val:float):
        self._context.set('root.test.num_f', float(new_val))

    @property
    def num_i(self) -> int:
        return int(self._context.get('root.test.num_i'))

    @num_i.setter
    def num_i(self, new_val:int):
        self._context.set('root.test.num_i', int(new_val))

    @property
    def str(self) -> str:
        return str(self._context.get('root.test.str'))

    @str.setter
    def str(self, new_val:str):
        self._context.set('root.test.str', str(new_val))

    @property
    def bool(self) -> bool:
        return bool(self._context.get('root.test.bool'))

    @bool.setter
    def bool(self, new_val:bool):
        self._context.set('root.test.bool', bool(new_val))


class RootUtil(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.util'

    def list_table_tables(self, *args) -> Any:
        return self._context.call('root.util.list_table_tables', *args)

    def list_table_vars(self, *args) -> Any:
        return self._context.call('root.util.list_table_vars', *args)

    def list_table_functions(self, *args) -> Any:
        return self._context.call('root.util.list_table_functions', *args)

    def table_append(self, *args) -> Any:
        return self._context.call('root.util.table_append', *args)

    def deep_copy(self, *args) -> Any:
        return self._context.call('root.util.deep_copy', *args)

    def list_table_all(self, *args) -> Any:
        return self._context.call('root.util.list_table_all', *args)

    def list_table_elements(self, *args) -> Any:
        return self._context.call('root.util.list_table_elements', *args)

    def deep_compare(self, *args) -> Any:
        return self._context.call('root.util.deep_compare', *args)

    def prequire(self, *args) -> Any:
        return self._context.call('root.util.prequire', *args)

    def num_table_invert(self, *args) -> Any:
        return self._context.call('root.util.num_table_invert', *args)

    def filter_string_array_begin(self, *args) -> Any:
        return self._context.call('root.util.filter_string_array_begin', *args)

    def make_property(self, *args) -> Any:
        return self._context.call('root.util.make_property', *args)

    def to_string(self, *args) -> Any:
        return self._context.call('root.util.to_string', *args)

    def array_concat(self, *args) -> Any:
        return self._context.call('root.util.array_concat', *args)

    def to_snake_case(self, *args) -> Any:
        return self._context.call('root.util.to_snake_case', *args)


class RootLuCantilever_propertiesInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.trigger'


class RootLuCantilever_propertiesInstanceAttributeShapeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.shape.enum'

    @property
    def rectangular(self) -> int:
        return int(self._context.get('root.lu.cantilever_properties.instance.attribute.shape.enum.rectangular'))

    @rectangular.setter
    def rectangular(self, new_val:int):
        self._context.set('root.lu.cantilever_properties.instance.attribute.shape.enum.rectangular', int(new_val))

    @property
    def triangular(self) -> int:
        return int(self._context.get('root.lu.cantilever_properties.instance.attribute.shape.enum.triangular'))

    @triangular.setter
    def triangular(self, new_val:int):
        self._context.set('root.lu.cantilever_properties.instance.attribute.shape.enum.triangular', int(new_val))


class RootLuCantilever_propertiesInstanceAttributeShape(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.shape'
        self.enum = RootLuCantilever_propertiesInstanceAttributeShapeEnum(self._context)


class RootLuCantilever_propertiesInstanceAttributeTip_half_angle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.tip_half_angle'


class RootLuCantilever_propertiesInstanceAttributeResonance_frequency(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.resonance_frequency'


class RootLuCantilever_propertiesInstanceAttributeQ_factor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.q_factor'


class RootLuCantilever_propertiesInstanceAttributeTip_radius(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.tip_radius'


class RootLuCantilever_propertiesInstanceAttributeSpring_constant(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.spring_constant'


class RootLuCantilever_propertiesInstanceAttributeLength(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.length'


class RootLuCantilever_propertiesInstanceAttributeWidth(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.width'


class RootLuCantilever_propertiesInstanceAttributeAlign_strategyEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.align_strategy.enum'

    @property
    def standard(self) -> int:
        return int(self._context.get('root.lu.cantilever_properties.instance.attribute.align_strategy.enum.standard'))

    @standard.setter
    def standard(self, new_val:int):
        self._context.set('root.lu.cantilever_properties.instance.attribute.align_strategy.enum.standard', int(new_val))

    @property
    def search_for_reflecting_edges(self) -> int:
        return int(self._context.get('root.lu.cantilever_properties.instance.attribute.align_strategy.enum.search_for_reflecting_edges'))

    @search_for_reflecting_edges.setter
    def search_for_reflecting_edges(self, new_val:int):
        self._context.set('root.lu.cantilever_properties.instance.attribute.align_strategy.enum.search_for_reflecting_edges', int(new_val))


class RootLuCantilever_propertiesInstanceAttributeAlign_strategy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.align_strategy'
        self.enum = RootLuCantilever_propertiesInstanceAttributeAlign_strategyEnum(self._context)


class RootLuCantilever_propertiesInstanceAttributeDeflection_sensitivity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute.deflection_sensitivity'


class RootLuCantilever_propertiesInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance.attribute'
        self.deflection_sensitivity = RootLuCantilever_propertiesInstanceAttributeDeflection_sensitivity(self._context)
        self.align_strategy = RootLuCantilever_propertiesInstanceAttributeAlign_strategy(self._context)
        self.width = RootLuCantilever_propertiesInstanceAttributeWidth(self._context)
        self.length = RootLuCantilever_propertiesInstanceAttributeLength(self._context)
        self.spring_constant = RootLuCantilever_propertiesInstanceAttributeSpring_constant(self._context)
        self.tip_radius = RootLuCantilever_propertiesInstanceAttributeTip_radius(self._context)
        self.q_factor = RootLuCantilever_propertiesInstanceAttributeQ_factor(self._context)
        self.resonance_frequency = RootLuCantilever_propertiesInstanceAttributeResonance_frequency(self._context)
        self.tip_half_angle = RootLuCantilever_propertiesInstanceAttributeTip_half_angle(self._context)
        self.shape = RootLuCantilever_propertiesInstanceAttributeShape(self._context)


class RootLuCantilever_propertiesInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties.instance'
        self.attribute = RootLuCantilever_propertiesInstanceAttribute(self._context)
        self.trigger = RootLuCantilever_propertiesInstanceTrigger(self._context)


class RootLuCantilever_properties(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.cantilever_properties'
        self.instance = RootLuCantilever_propertiesInstance(self._context)


class RootLuFrequency_sweep_genInstanceTriggerStart_set_reference_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.trigger.start_set_reference_amplitude'


class RootLuFrequency_sweep_genInstanceTriggerStart_set_sensor_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.trigger.start_set_sensor_amplitude'


class RootLuFrequency_sweep_genInstanceTriggerStart_frequency_sweep(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.trigger.start_frequency_sweep'


class RootLuFrequency_sweep_genInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.trigger.user_abort'


class RootLuFrequency_sweep_genInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.trigger'
        self.user_abort = RootLuFrequency_sweep_genInstanceTriggerUser_abort(self._context)
        self.start_frequency_sweep = RootLuFrequency_sweep_genInstanceTriggerStart_frequency_sweep(self._context)
        self.start_set_sensor_amplitude = RootLuFrequency_sweep_genInstanceTriggerStart_set_sensor_amplitude(self._context)
        self.start_set_reference_amplitude = RootLuFrequency_sweep_genInstanceTriggerStart_set_reference_amplitude(self._context)


class RootLuFrequency_sweep_genInstanceAttributeSweep_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.sweep_amplitude'


class RootLuFrequency_sweep_genInstanceAttributeStart_frequency(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.start_frequency'


class RootLuFrequency_sweep_genInstanceAttributeSettle_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.settle_time'


class RootLuFrequency_sweep_genInstanceAttributeLu_sig_analyzer_inst_noEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no.enum'

    @property
    def inst1(self) -> int:
        return int(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no.enum.inst1'))

    @inst1.setter
    def inst1(self, new_val:int):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no.enum.inst1', int(new_val))

    @property
    def inst2(self) -> int:
        return int(self._context.get('root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no.enum.inst2'))

    @inst2.setter
    def inst2(self, new_val:int):
        self._context.set('root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no.enum.inst2', int(new_val))


class RootLuFrequency_sweep_genInstanceAttributeLu_sig_analyzer_inst_no(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.lu_sig_analyzer_inst_no'
        self.enum = RootLuFrequency_sweep_genInstanceAttributeLu_sig_analyzer_inst_noEnum(self._context)


class RootLuFrequency_sweep_genInstanceAttributeSensor_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.sensor_amplitude'


class RootLuFrequency_sweep_genInstanceAttributeData_group_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.data_group_id'


class RootLuFrequency_sweep_genInstanceAttributeReference_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.reference_amplitude'


class RootLuFrequency_sweep_genInstanceAttributeEnd_frequency(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.end_frequency'


class RootLuFrequency_sweep_genInstanceAttributeStep_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.step_time'


class RootLuFrequency_sweep_genInstanceAttributeData_points(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute.data_points'


class RootLuFrequency_sweep_genInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance.attribute'
        self.data_points = RootLuFrequency_sweep_genInstanceAttributeData_points(self._context)
        self.step_time = RootLuFrequency_sweep_genInstanceAttributeStep_time(self._context)
        self.end_frequency = RootLuFrequency_sweep_genInstanceAttributeEnd_frequency(self._context)
        self.reference_amplitude = RootLuFrequency_sweep_genInstanceAttributeReference_amplitude(self._context)
        self.data_group_id = RootLuFrequency_sweep_genInstanceAttributeData_group_id(self._context)
        self.sensor_amplitude = RootLuFrequency_sweep_genInstanceAttributeSensor_amplitude(self._context)
        self.lu_sig_analyzer_inst_no = RootLuFrequency_sweep_genInstanceAttributeLu_sig_analyzer_inst_no(self._context)
        self.settle_time = RootLuFrequency_sweep_genInstanceAttributeSettle_time(self._context)
        self.start_frequency = RootLuFrequency_sweep_genInstanceAttributeStart_frequency(self._context)
        self.sweep_amplitude = RootLuFrequency_sweep_genInstanceAttributeSweep_amplitude(self._context)


class RootLuFrequency_sweep_genInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen.instance'
        self.attribute = RootLuFrequency_sweep_genInstanceAttribute(self._context)
        self.trigger = RootLuFrequency_sweep_genInstanceTrigger(self._context)


class RootLuFrequency_sweep_gen(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.frequency_sweep_gen'
        self.instance = RootLuFrequency_sweep_genInstance(self._context)


class RootLuEvent_managerInstanceTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.stop'


class RootLuEvent_managerInstanceTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.abort'


class RootLuEvent_managerInstanceTriggerSoft_event2_rising_edge(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.soft_event2_rising_edge'


class RootLuEvent_managerInstanceTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.start'


class RootLuEvent_managerInstanceTriggerSoft_event1_falling_edge(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.soft_event1_falling_edge'


class RootLuEvent_managerInstanceTriggerSoft_event0_falling_edge(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.soft_event0_falling_edge'


class RootLuEvent_managerInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.user_abort'


class RootLuEvent_managerInstanceTriggerSoft_event2_falling_edge(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.soft_event2_falling_edge'


class RootLuEvent_managerInstanceTriggerSoft_event0_rising_edge(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.soft_event0_rising_edge'


class RootLuEvent_managerInstanceTriggerSoft_event1_rising_edge(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger.soft_event1_rising_edge'


class RootLuEvent_managerInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.trigger'
        self.soft_event1_rising_edge = RootLuEvent_managerInstanceTriggerSoft_event1_rising_edge(self._context)
        self.soft_event0_rising_edge = RootLuEvent_managerInstanceTriggerSoft_event0_rising_edge(self._context)
        self.soft_event2_falling_edge = RootLuEvent_managerInstanceTriggerSoft_event2_falling_edge(self._context)
        self.user_abort = RootLuEvent_managerInstanceTriggerUser_abort(self._context)
        self.soft_event0_falling_edge = RootLuEvent_managerInstanceTriggerSoft_event0_falling_edge(self._context)
        self.soft_event1_falling_edge = RootLuEvent_managerInstanceTriggerSoft_event1_falling_edge(self._context)
        self.start = RootLuEvent_managerInstanceTriggerStart(self._context)
        self.soft_event2_rising_edge = RootLuEvent_managerInstanceTriggerSoft_event2_rising_edge(self._context)
        self.abort = RootLuEvent_managerInstanceTriggerAbort(self._context)
        self.stop = RootLuEvent_managerInstanceTriggerStop(self._context)


class RootLuEvent_managerInstanceAttributeStop_maskEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.stop_mask.enum'

    @property
    def ramp_gen_planez(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_planez'))

    @ramp_gen_planez.setter
    def ramp_gen_planez(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_planez', int(new_val))

    @property
    def data_sampling(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.data_sampling'))

    @data_sampling.setter
    def data_sampling(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.data_sampling', int(new_val))

    @property
    def ramp_gen_positionx(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_positionx'))

    @ramp_gen_positionx.setter
    def ramp_gen_positionx(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_positionx', int(new_val))

    @property
    def mem_sig_gen(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.mem_sig_gen'))

    @mem_sig_gen.setter
    def mem_sig_gen(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.mem_sig_gen', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_approach', int(new_val))

    @property
    def all(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.all'))

    @all.setter
    def all(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.all', int(new_val))

    @property
    def ramp_gen_positiony(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_positiony'))

    @ramp_gen_positiony.setter
    def ramp_gen_positiony(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_positiony', int(new_val))

    @property
    def ramp_gen_tipvoltage(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_tipvoltage'))

    @ramp_gen_tipvoltage.setter
    def ramp_gen_tipvoltage(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_tipvoltage', int(new_val))

    @property
    def ramp_gen_maxz(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_maxz'))

    @ramp_gen_maxz.setter
    def ramp_gen_maxz(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_maxz', int(new_val))

    @property
    def ramp_gen_alternatez(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_alternatez'))

    @ramp_gen_alternatez.setter
    def ramp_gen_alternatez(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_alternatez', int(new_val))

    @property
    def unused(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.unused'))

    @unused.setter
    def unused(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.unused', int(new_val))

    @property
    def timer_proc0(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.timer_proc0'))

    @timer_proc0.setter
    def timer_proc0(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.timer_proc0', int(new_val))

    @property
    def timer_dbg1(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.timer_dbg1'))

    @timer_dbg1.setter
    def timer_dbg1(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.timer_dbg1', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.none', int(new_val))

    @property
    def ramp_gen_ctrlz(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_ctrlz'))

    @ramp_gen_ctrlz.setter
    def ramp_gen_ctrlz(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_ctrlz', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_test', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.ramp_gen_user4', int(new_val))

    @property
    def data_capture(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_mask.enum.data_capture'))

    @data_capture.setter
    def data_capture(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_mask.enum.data_capture', int(new_val))


class RootLuEvent_managerInstanceAttributeStop_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.stop_mask'
        self.enum = RootLuEvent_managerInstanceAttributeStop_maskEnum(self._context)


class RootLuEvent_managerInstanceAttributeEvent_vector_snapshotEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.event_vector_snapshot.enum'

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_approach_done', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.soft_event2_true', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.comparator1_true', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.timer_dbg1_done', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.and_mask0_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.user_abort_event_true', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_test_done', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.data_sampling_done', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_planez_done', int(new_val))

    @property
    def unused_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.unused_done'))

    @unused_done.setter
    def unused_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.unused_done', int(new_val))

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.comparator2_true', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def all(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.all'))

    @all.setter
    def all(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.all', float(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.soft_event1_true', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.soft_event0_true', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ext_event1_true', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_user4_done', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.timer_proc0_done', int(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.data_capture_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.none', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.ext_event0_true', int(new_val))

    @property
    def comparator3_true(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector_snapshot.enum.comparator3_true', float(new_val))


class RootLuEvent_managerInstanceAttributeEvent_vector_snapshot(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.event_vector_snapshot'
        self.enum = RootLuEvent_managerInstanceAttributeEvent_vector_snapshotEnum(self._context)


class RootLuEvent_managerInstanceAttributeAnd_mask0Enum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.and_mask0.enum'

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_approach_done', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.soft_event2_true', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.comparator1_true', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.timer_dbg1_done', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.and_mask0_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.user_abort_event_true', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_test_done', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.data_sampling_done', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_planez_done', int(new_val))

    @property
    def unused_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.unused_done'))

    @unused_done.setter
    def unused_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.unused_done', int(new_val))

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.comparator2_true', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def all(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.all'))

    @all.setter
    def all(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.all', float(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.soft_event1_true', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.soft_event0_true', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ext_event1_true', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_user4_done', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.timer_proc0_done', int(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.data_capture_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.none', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.ext_event0_true', int(new_val))

    @property
    def comparator3_true(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.and_mask0.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.and_mask0.enum.comparator3_true', float(new_val))


class RootLuEvent_managerInstanceAttributeAnd_mask0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.and_mask0'
        self.enum = RootLuEvent_managerInstanceAttributeAnd_mask0Enum(self._context)


class RootLuEvent_managerInstanceAttributeStop_event_maskEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.stop_event_mask.enum'

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_approach_done', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.soft_event2_true', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.comparator1_true', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.timer_dbg1_done', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.and_mask0_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.user_abort_event_true', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_test_done', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.data_sampling_done', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_planez_done', int(new_val))

    @property
    def unused_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.unused_done'))

    @unused_done.setter
    def unused_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.unused_done', int(new_val))

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.comparator2_true', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def all(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.all'))

    @all.setter
    def all(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.all', float(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.soft_event1_true', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.soft_event0_true', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ext_event1_true', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_user4_done', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.timer_proc0_done', int(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.data_capture_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.none', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.ext_event0_true', int(new_val))

    @property
    def comparator3_true(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.stop_event_mask.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.stop_event_mask.enum.comparator3_true', float(new_val))


class RootLuEvent_managerInstanceAttributeStop_event_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.stop_event_mask'
        self.enum = RootLuEvent_managerInstanceAttributeStop_event_maskEnum(self._context)


class RootLuEvent_managerInstanceAttributeEvent_vectorEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.event_vector.enum'

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_approach_done', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.soft_event2_true', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.comparator1_true', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.timer_dbg1_done', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.and_mask0_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.user_abort_event_true', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_test_done', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.data_sampling_done', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_planez_done', int(new_val))

    @property
    def unused_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.unused_done'))

    @unused_done.setter
    def unused_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.unused_done', int(new_val))

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.comparator2_true', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def all(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.all'))

    @all.setter
    def all(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.all', float(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.soft_event1_true', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.soft_event0_true', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ext_event1_true', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_user4_done', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.timer_proc0_done', int(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.data_capture_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.none', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.ext_event0_true', int(new_val))

    @property
    def comparator3_true(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.event_vector.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.event_vector.enum.comparator3_true', float(new_val))


class RootLuEvent_managerInstanceAttributeEvent_vector(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.event_vector'
        self.enum = RootLuEvent_managerInstanceAttributeEvent_vectorEnum(self._context)


class RootLuEvent_managerInstanceAttributeStart_maskEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.start_mask.enum'

    @property
    def ramp_gen_planez(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_planez'))

    @ramp_gen_planez.setter
    def ramp_gen_planez(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_planez', int(new_val))

    @property
    def data_sampling(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.data_sampling'))

    @data_sampling.setter
    def data_sampling(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.data_sampling', int(new_val))

    @property
    def ramp_gen_positionx(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_positionx'))

    @ramp_gen_positionx.setter
    def ramp_gen_positionx(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_positionx', int(new_val))

    @property
    def mem_sig_gen(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.mem_sig_gen'))

    @mem_sig_gen.setter
    def mem_sig_gen(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.mem_sig_gen', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_approach', int(new_val))

    @property
    def all(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.all'))

    @all.setter
    def all(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.all', int(new_val))

    @property
    def ramp_gen_positiony(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_positiony'))

    @ramp_gen_positiony.setter
    def ramp_gen_positiony(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_positiony', int(new_val))

    @property
    def ramp_gen_tipvoltage(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_tipvoltage'))

    @ramp_gen_tipvoltage.setter
    def ramp_gen_tipvoltage(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_tipvoltage', int(new_val))

    @property
    def ramp_gen_maxz(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_maxz'))

    @ramp_gen_maxz.setter
    def ramp_gen_maxz(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_maxz', int(new_val))

    @property
    def ramp_gen_alternatez(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_alternatez'))

    @ramp_gen_alternatez.setter
    def ramp_gen_alternatez(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_alternatez', int(new_val))

    @property
    def unused(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.unused'))

    @unused.setter
    def unused(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.unused', int(new_val))

    @property
    def timer_proc0(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.timer_proc0'))

    @timer_proc0.setter
    def timer_proc0(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.timer_proc0', int(new_val))

    @property
    def timer_dbg1(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.timer_dbg1'))

    @timer_dbg1.setter
    def timer_dbg1(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.timer_dbg1', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.none', int(new_val))

    @property
    def ramp_gen_ctrlz(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_ctrlz'))

    @ramp_gen_ctrlz.setter
    def ramp_gen_ctrlz(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_ctrlz', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_test', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.ramp_gen_user4', int(new_val))

    @property
    def data_capture(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.start_mask.enum.data_capture'))

    @data_capture.setter
    def data_capture(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.start_mask.enum.data_capture', int(new_val))


class RootLuEvent_managerInstanceAttributeStart_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.start_mask'
        self.enum = RootLuEvent_managerInstanceAttributeStart_maskEnum(self._context)


class RootLuEvent_managerInstanceAttributeObject_idle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.object_idle'


class RootLuEvent_managerInstanceAttributeObject_queue_size(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.object_queue_size'


class RootLuEvent_managerInstanceAttributeAbort_event_maskEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.abort_event_mask.enum'

    @property
    def ramp_gen_approach_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_approach_done'))

    @ramp_gen_approach_done.setter
    def ramp_gen_approach_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_approach_done', int(new_val))

    @property
    def soft_event2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.soft_event2_true'))

    @soft_event2_true.setter
    def soft_event2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.soft_event2_true', int(new_val))

    @property
    def z_ctrl_reached_min_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.z_ctrl_reached_min_z_true'))

    @z_ctrl_reached_min_z_true.setter
    def z_ctrl_reached_min_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.z_ctrl_reached_min_z_true', int(new_val))

    @property
    def comparator1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.comparator1_true'))

    @comparator1_true.setter
    def comparator1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.comparator1_true', int(new_val))

    @property
    def timer_dbg1_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.timer_dbg1_done'))

    @timer_dbg1_done.setter
    def timer_dbg1_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.timer_dbg1_done', int(new_val))

    @property
    def z_ctrl_reached_error_limit_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.z_ctrl_reached_error_limit_true'))

    @z_ctrl_reached_error_limit_true.setter
    def z_ctrl_reached_error_limit_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.z_ctrl_reached_error_limit_true', int(new_val))

    @property
    def and_mask0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.and_mask0_true'))

    @and_mask0_true.setter
    def and_mask0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.and_mask0_true', int(new_val))

    @property
    def user_abort_event_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.user_abort_event_true'))

    @user_abort_event_true.setter
    def user_abort_event_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.user_abort_event_true', int(new_val))

    @property
    def ramp_gen_test_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_test_done'))

    @ramp_gen_test_done.setter
    def ramp_gen_test_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_test_done', int(new_val))

    @property
    def data_sampling_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.data_sampling_done'))

    @data_sampling_done.setter
    def data_sampling_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.data_sampling_done', int(new_val))

    @property
    def ramp_gen_positiony_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_positiony_done'))

    @ramp_gen_positiony_done.setter
    def ramp_gen_positiony_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_positiony_done', int(new_val))

    @property
    def ramp_gen_planez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_planez_done'))

    @ramp_gen_planez_done.setter
    def ramp_gen_planez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_planez_done', int(new_val))

    @property
    def unused_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.unused_done'))

    @unused_done.setter
    def unused_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.unused_done', int(new_val))

    @property
    def comparator2_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.comparator2_true'))

    @comparator2_true.setter
    def comparator2_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.comparator2_true', int(new_val))

    @property
    def ramp_gen_ctrlz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_ctrlz_done'))

    @ramp_gen_ctrlz_done.setter
    def ramp_gen_ctrlz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_ctrlz_done', int(new_val))

    @property
    def all(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.all'))

    @all.setter
    def all(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.all', float(new_val))

    @property
    def ramp_gen_maxz_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_maxz_done'))

    @ramp_gen_maxz_done.setter
    def ramp_gen_maxz_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_maxz_done', int(new_val))

    @property
    def z_ctrl_reached_max_z_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.z_ctrl_reached_max_z_true'))

    @z_ctrl_reached_max_z_true.setter
    def z_ctrl_reached_max_z_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.z_ctrl_reached_max_z_true', int(new_val))

    @property
    def soft_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.soft_event1_true'))

    @soft_event1_true.setter
    def soft_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.soft_event1_true', int(new_val))

    @property
    def soft_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.soft_event0_true'))

    @soft_event0_true.setter
    def soft_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.soft_event0_true', int(new_val))

    @property
    def ext_event1_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ext_event1_true'))

    @ext_event1_true.setter
    def ext_event1_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ext_event1_true', int(new_val))

    @property
    def mem_sig_gen_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.mem_sig_gen_done'))

    @mem_sig_gen_done.setter
    def mem_sig_gen_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.mem_sig_gen_done', int(new_val))

    @property
    def ramp_gen_user4_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_user4_done'))

    @ramp_gen_user4_done.setter
    def ramp_gen_user4_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_user4_done', int(new_val))

    @property
    def ramp_gen_tipvoltage_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_tipvoltage_done'))

    @ramp_gen_tipvoltage_done.setter
    def ramp_gen_tipvoltage_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_tipvoltage_done', int(new_val))

    @property
    def ramp_gen_alternatez_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_alternatez_done'))

    @ramp_gen_alternatez_done.setter
    def ramp_gen_alternatez_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_alternatez_done', int(new_val))

    @property
    def timer_proc0_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.timer_proc0_done'))

    @timer_proc0_done.setter
    def timer_proc0_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.timer_proc0_done', int(new_val))

    @property
    def data_capture_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.data_capture_done'))

    @data_capture_done.setter
    def data_capture_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.data_capture_done', int(new_val))

    @property
    def ramp_gen_positionx_done(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_positionx_done'))

    @ramp_gen_positionx_done.setter
    def ramp_gen_positionx_done(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ramp_gen_positionx_done', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.none', int(new_val))

    @property
    def ext_event0_true(self) -> int:
        return int(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ext_event0_true'))

    @ext_event0_true.setter
    def ext_event0_true(self, new_val:int):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.ext_event0_true', int(new_val))

    @property
    def comparator3_true(self) -> float:
        return float(self._context.get('root.lu.event_manager.instance.attribute.abort_event_mask.enum.comparator3_true'))

    @comparator3_true.setter
    def comparator3_true(self, new_val:float):
        self._context.set('root.lu.event_manager.instance.attribute.abort_event_mask.enum.comparator3_true', float(new_val))


class RootLuEvent_managerInstanceAttributeAbort_event_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute.abort_event_mask'
        self.enum = RootLuEvent_managerInstanceAttributeAbort_event_maskEnum(self._context)


class RootLuEvent_managerInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.attribute'
        self.abort_event_mask = RootLuEvent_managerInstanceAttributeAbort_event_mask(self._context)
        self.object_queue_size = RootLuEvent_managerInstanceAttributeObject_queue_size(self._context)
        self.object_idle = RootLuEvent_managerInstanceAttributeObject_idle(self._context)
        self.start_mask = RootLuEvent_managerInstanceAttributeStart_mask(self._context)
        self.event_vector = RootLuEvent_managerInstanceAttributeEvent_vector(self._context)
        self.stop_event_mask = RootLuEvent_managerInstanceAttributeStop_event_mask(self._context)
        self.and_mask0 = RootLuEvent_managerInstanceAttributeAnd_mask0(self._context)
        self.event_vector_snapshot = RootLuEvent_managerInstanceAttributeEvent_vector_snapshot(self._context)
        self.stop_mask = RootLuEvent_managerInstanceAttributeStop_mask(self._context)


class RootLuEvent_managerInstanceBusyIs_busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.busy.is_busy'


class RootLuEvent_managerInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance.busy'
        self.is_busy = RootLuEvent_managerInstanceBusyIs_busy(self._context)


class RootLuEvent_managerInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager.instance'
        self.busy = RootLuEvent_managerInstanceBusy(self._context)
        self.attribute = RootLuEvent_managerInstanceAttribute(self._context)
        self.trigger = RootLuEvent_managerInstanceTrigger(self._context)


class RootLuEvent_manager(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.event_manager'
        self.instance = RootLuEvent_managerInstance(self._context)


class RootLuMainboard_relaysInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.trigger'


class RootLuMainboard_relaysInstanceAttributeSet_state_maskEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.attribute.set_state_mask.enum'

    @property
    def all(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.all'))

    @all.setter
    def all(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.all', int(new_val))

    @property
    def dummy0(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.dummy0'))

    @dummy0.setter
    def dummy0(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.dummy0', int(new_val))

    @property
    def hires_in_user4(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user4'))

    @hires_in_user4.setter
    def hires_in_user4(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user4', int(new_val))

    @property
    def hires_out_user1(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user1'))

    @hires_out_user1.setter
    def hires_out_user1(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user1', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.none', int(new_val))

    @property
    def hires_in_user2(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user2'))

    @hires_in_user2.setter
    def hires_in_user2(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user2', int(new_val))

    @property
    def hires_out_user4(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user4'))

    @hires_out_user4.setter
    def hires_out_user4(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user4', int(new_val))

    @property
    def hires_out_user3(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user3'))

    @hires_out_user3.setter
    def hires_out_user3(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user3', int(new_val))

    @property
    def hires_out_user2(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user2'))

    @hires_out_user2.setter
    def hires_out_user2(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_out_user2', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.fast_in_user', int(new_val))

    @property
    def hires_in_user1(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user1'))

    @hires_in_user1.setter
    def hires_in_user1(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user1', int(new_val))

    @property
    def fast_out_user(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.fast_out_user'))

    @fast_out_user.setter
    def fast_out_user(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.fast_out_user', int(new_val))

    @property
    def hires_in_user3(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user3'))

    @hires_in_user3.setter
    def hires_in_user3(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hires_in_user3', int(new_val))

    @property
    def hi_res_in6(self) -> int:
        return int(self._context.get('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hi_res_in6'))

    @hi_res_in6.setter
    def hi_res_in6(self, new_val:int):
        self._context.set('root.lu.mainboard_relays.instance.attribute.set_state_mask.enum.hi_res_in6', int(new_val))


class RootLuMainboard_relaysInstanceAttributeSet_state_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.attribute.set_state_mask'
        self.enum = RootLuMainboard_relaysInstanceAttributeSet_state_maskEnum(self._context)


class RootLuMainboard_relaysInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance.attribute'
        self.set_state_mask = RootLuMainboard_relaysInstanceAttributeSet_state_mask(self._context)


class RootLuMainboard_relaysInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays.instance'
        self.attribute = RootLuMainboard_relaysInstanceAttribute(self._context)
        self.trigger = RootLuMainboard_relaysInstanceTrigger(self._context)


class RootLuMainboard_relays(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.mainboard_relays'
        self.instance = RootLuMainboard_relaysInstance(self._context)


class RootLuOscilloscopeInstanceTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger.stop'


class RootLuOscilloscopeInstanceTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger.abort'


class RootLuOscilloscopeInstanceTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger.start'


class RootLuOscilloscopeInstanceTriggerToggle_debug_logging(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger.toggle_debug_logging'


class RootLuOscilloscopeInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.trigger'
        self.toggle_debug_logging = RootLuOscilloscopeInstanceTriggerToggle_debug_logging(self._context)
        self.start = RootLuOscilloscopeInstanceTriggerStart(self._context)
        self.abort = RootLuOscilloscopeInstanceTriggerAbort(self._context)
        self.stop = RootLuOscilloscopeInstanceTriggerStop(self._context)


class RootLuOscilloscopeInstanceAttributeCapture_period(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.capture_period'


class RootLuOscilloscopeInstanceAttributeCapture_duration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.capture_duration'


class RootLuOscilloscopeInstanceAttributeHi_res_input_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.hi_res_input_vec'


class RootLuOscilloscopeInstanceAttributeFast_input_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute.fast_input_vec'


class RootLuOscilloscopeInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.attribute'
        self.fast_input_vec = RootLuOscilloscopeInstanceAttributeFast_input_vec(self._context)
        self.hi_res_input_vec = RootLuOscilloscopeInstanceAttributeHi_res_input_vec(self._context)
        self.capture_duration = RootLuOscilloscopeInstanceAttributeCapture_duration(self._context)
        self.capture_period = RootLuOscilloscopeInstanceAttributeCapture_period(self._context)


class RootLuOscilloscopeInstanceBusyIs_busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.busy.is_busy'


class RootLuOscilloscopeInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance.busy'
        self.is_busy = RootLuOscilloscopeInstanceBusyIs_busy(self._context)


class RootLuOscilloscopeInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope.instance'
        self.busy = RootLuOscilloscopeInstanceBusy(self._context)
        self.attribute = RootLuOscilloscopeInstanceAttribute(self._context)
        self.trigger = RootLuOscilloscopeInstanceTrigger(self._context)


class RootLuOscilloscope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.oscilloscope'
        self.instance = RootLuOscilloscopeInstance(self._context)


class RootLuPid_controllerPid_wTriggerCalibrate_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.trigger.calibrate_offset'


class RootLuPid_controllerPid_wTriggerDrive_to_zero_volt_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.trigger.drive_to_zero_volt_position'


class RootLuPid_controllerPid_wTriggerClear_pid_accu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.trigger.clear_pid_accu'


class RootLuPid_controllerPid_wTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.trigger'
        self.clear_pid_accu = RootLuPid_controllerPid_wTriggerClear_pid_accu(self._context)
        self.drive_to_zero_volt_position = RootLuPid_controllerPid_wTriggerDrive_to_zero_volt_position(self._context)
        self.calibrate_offset = RootLuPid_controllerPid_wTriggerCalibrate_offset(self._context)


class RootLuPid_controllerPid_wAttributeMin_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.min_value'


class RootLuPid_controllerPid_wAttributeFeedback_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.feedback_mode'


class RootLuPid_controllerPid_wAttributeMedian_filter_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.median_filter_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.median_filter_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.median_filter_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.median_filter_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.median_filter_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_wAttributeMedian_filter_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.median_filter_enable'
        self.enum = RootLuPid_controllerPid_wAttributeMedian_filter_enableEnum(self._context)


class RootLuPid_controllerPid_wAttributeSet_point_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.set_point_gain'


class RootLuPid_controllerPid_wAttributeD_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.d_gain'


class RootLuPid_controllerPid_wAttributeReached_max(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.reached_max'


class RootLuPid_controllerPid_wAttributeI_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.i_gain'


class RootLuPid_controllerPid_wAttributeP_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.p_gain'


class RootLuPid_controllerPid_wAttributeReached_err_lim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.reached_err_lim'


class RootLuPid_controllerPid_wAttributeInput_actualEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.input_actual.enum'

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_amplitude', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_x', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in6', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_w_out', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_z_in', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_position_z', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_reference', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_deflection', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_y', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_position_x', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_free_wave', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_user1', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_z_pid_command', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_x_out', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_user2_out', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.fast_in_deflection', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_user2', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_position_y', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_position_z', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_z_nominal', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_adhesion_position', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_baseline_corrected', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_user3', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_amplitude', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_z_error', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_amplitude_reduction', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_test', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.static', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_position_y', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_y_out', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_position_x', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.gen_test_dynamic', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_plane_z', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_max_z', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.fast_in2', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_phase', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_excitation', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_baseline', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_user4', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_out8', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ctrl_z_out', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_out7', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_drive_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.memory_gen_drive_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ort_adhesion_value', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_detector_sum', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_tip_current', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.ramp_gen_position_x', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.fast_in_user', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.in_position_y', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_actual.enum.analyzer2_y', int(new_val))


class RootLuPid_controllerPid_wAttributeInput_actual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.input_actual'
        self.enum = RootLuPid_controllerPid_wAttributeInput_actualEnum(self._context)


class RootLuPid_controllerPid_wAttributeError_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.error_limit'


class RootLuPid_controllerPid_wAttributeMemory_signal_gen_position_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_wAttributeMemory_signal_gen_position_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.memory_signal_gen_position_enable'
        self.enum = RootLuPid_controllerPid_wAttributeMemory_signal_gen_position_enableEnum(self._context)


class RootLuPid_controllerPid_wAttributeSelect_output(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.select_output'


class RootLuPid_controllerPid_wAttributeReached_min(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.reached_min'


class RootLuPid_controllerPid_wAttributeMemory_signal_gen_drive_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_wAttributeMemory_signal_gen_drive_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.memory_signal_gen_drive_enable'
        self.enum = RootLuPid_controllerPid_wAttributeMemory_signal_gen_drive_enableEnum(self._context)


class RootLuPid_controllerPid_wAttributeSet_point_modulation_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_wAttributeSet_point_modulation_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.set_point_modulation_enable'
        self.enum = RootLuPid_controllerPid_wAttributeSet_point_modulation_enableEnum(self._context)


class RootLuPid_controllerPid_wAttributeSlope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.slope'


class RootLuPid_controllerPid_wAttributePolarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.polarity'


class RootLuPid_controllerPid_wAttributeOffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.offset'


class RootLuPid_controllerPid_wAttributeInput_set_pointEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.input_set_point.enum'

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_amplitude', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_x', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in6', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_w_out', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_z_in', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_position_z', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_reference', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_deflection', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_y', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_position_x', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_free_wave', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_user1', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_z_pid_command', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_x_out', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_user2_out', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.fast_in_deflection', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_user2', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_position_y', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_position_z', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_z_nominal', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_adhesion_position', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_baseline_corrected', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_user3', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_amplitude', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_z_error', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_amplitude_reduction', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_test', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.static', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_position_y', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_y_out', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_position_x', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.gen_test_dynamic', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_plane_z', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_max_z', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.fast_in2', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_phase', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_excitation', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_baseline', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_user4', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_out8', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ctrl_z_out', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_out7', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_drive_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.memory_gen_drive_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ort_adhesion_value', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_detector_sum', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_tip_current', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.ramp_gen_position_x', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.fast_in_user', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.in_position_y', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_w.attribute.input_set_point.enum.analyzer2_y', int(new_val))


class RootLuPid_controllerPid_wAttributeInput_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.input_set_point'
        self.enum = RootLuPid_controllerPid_wAttributeInput_set_pointEnum(self._context)


class RootLuPid_controllerPid_wAttributeMax_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.max_value'


class RootLuPid_controllerPid_wAttributeCompare_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute.compare_mode'


class RootLuPid_controllerPid_wAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w.attribute'
        self.compare_mode = RootLuPid_controllerPid_wAttributeCompare_mode(self._context)
        self.max_value = RootLuPid_controllerPid_wAttributeMax_value(self._context)
        self.input_set_point = RootLuPid_controllerPid_wAttributeInput_set_point(self._context)
        self.offset = RootLuPid_controllerPid_wAttributeOffset(self._context)
        self.polarity = RootLuPid_controllerPid_wAttributePolarity(self._context)
        self.slope = RootLuPid_controllerPid_wAttributeSlope(self._context)
        self.set_point_modulation_enable = RootLuPid_controllerPid_wAttributeSet_point_modulation_enable(self._context)
        self.memory_signal_gen_drive_enable = RootLuPid_controllerPid_wAttributeMemory_signal_gen_drive_enable(self._context)
        self.reached_min = RootLuPid_controllerPid_wAttributeReached_min(self._context)
        self.select_output = RootLuPid_controllerPid_wAttributeSelect_output(self._context)
        self.memory_signal_gen_position_enable = RootLuPid_controllerPid_wAttributeMemory_signal_gen_position_enable(self._context)
        self.error_limit = RootLuPid_controllerPid_wAttributeError_limit(self._context)
        self.input_actual = RootLuPid_controllerPid_wAttributeInput_actual(self._context)
        self.reached_err_lim = RootLuPid_controllerPid_wAttributeReached_err_lim(self._context)
        self.p_gain = RootLuPid_controllerPid_wAttributeP_gain(self._context)
        self.i_gain = RootLuPid_controllerPid_wAttributeI_gain(self._context)
        self.reached_max = RootLuPid_controllerPid_wAttributeReached_max(self._context)
        self.d_gain = RootLuPid_controllerPid_wAttributeD_gain(self._context)
        self.set_point_gain = RootLuPid_controllerPid_wAttributeSet_point_gain(self._context)
        self.median_filter_enable = RootLuPid_controllerPid_wAttributeMedian_filter_enable(self._context)
        self.feedback_mode = RootLuPid_controllerPid_wAttributeFeedback_mode(self._context)
        self.min_value = RootLuPid_controllerPid_wAttributeMin_value(self._context)


class RootLuPid_controllerPid_w(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_w'
        self.attribute = RootLuPid_controllerPid_wAttribute(self._context)
        self.trigger = RootLuPid_controllerPid_wTrigger(self._context)


class RootLuPid_controllerPid_user2TriggerCalibrate_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.trigger.calibrate_offset'


class RootLuPid_controllerPid_user2TriggerDrive_to_zero_volt_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.trigger.drive_to_zero_volt_position'


class RootLuPid_controllerPid_user2TriggerClear_pid_accu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.trigger.clear_pid_accu'


class RootLuPid_controllerPid_user2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.trigger'
        self.clear_pid_accu = RootLuPid_controllerPid_user2TriggerClear_pid_accu(self._context)
        self.drive_to_zero_volt_position = RootLuPid_controllerPid_user2TriggerDrive_to_zero_volt_position(self._context)
        self.calibrate_offset = RootLuPid_controllerPid_user2TriggerCalibrate_offset(self._context)


class RootLuPid_controllerPid_user2AttributeMin_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.min_value'


class RootLuPid_controllerPid_user2AttributeFeedback_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.feedback_mode'


class RootLuPid_controllerPid_user2AttributeMedian_filter_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.median_filter_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.median_filter_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.median_filter_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.median_filter_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.median_filter_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_user2AttributeMedian_filter_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.median_filter_enable'
        self.enum = RootLuPid_controllerPid_user2AttributeMedian_filter_enableEnum(self._context)


class RootLuPid_controllerPid_user2AttributeSet_point_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.set_point_gain'


class RootLuPid_controllerPid_user2AttributeD_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.d_gain'


class RootLuPid_controllerPid_user2AttributeReached_max(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.reached_max'


class RootLuPid_controllerPid_user2AttributeI_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.i_gain'


class RootLuPid_controllerPid_user2AttributeP_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.p_gain'


class RootLuPid_controllerPid_user2AttributeReached_err_lim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.reached_err_lim'


class RootLuPid_controllerPid_user2AttributeInput_actualEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.input_actual.enum'

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_amplitude', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_x', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in6', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_w_out', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_z_in', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_position_z', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_reference', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_deflection', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_y', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_position_x', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_free_wave', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_user1', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_z_pid_command', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_x_out', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_user2_out', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.fast_in_deflection', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_user2', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_position_y', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_position_z', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_z_nominal', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_adhesion_position', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_baseline_corrected', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_user3', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_amplitude', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_z_error', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_amplitude_reduction', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_test', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.static', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_position_y', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_y_out', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_position_x', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.gen_test_dynamic', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_plane_z', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_max_z', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.fast_in2', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_phase', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_excitation', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_baseline', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_user4', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_out8', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ctrl_z_out', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_out7', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_drive_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.memory_gen_drive_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ort_adhesion_value', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_detector_sum', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_tip_current', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.ramp_gen_position_x', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.fast_in_user', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.in_position_y', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_actual.enum.analyzer2_y', int(new_val))


class RootLuPid_controllerPid_user2AttributeInput_actual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.input_actual'
        self.enum = RootLuPid_controllerPid_user2AttributeInput_actualEnum(self._context)


class RootLuPid_controllerPid_user2AttributeError_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.error_limit'


class RootLuPid_controllerPid_user2AttributeMemory_signal_gen_position_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_user2AttributeMemory_signal_gen_position_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_position_enable'
        self.enum = RootLuPid_controllerPid_user2AttributeMemory_signal_gen_position_enableEnum(self._context)


class RootLuPid_controllerPid_user2AttributeSelect_output(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.select_output'


class RootLuPid_controllerPid_user2AttributeReached_min(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.reached_min'


class RootLuPid_controllerPid_user2AttributeMemory_signal_gen_drive_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_user2AttributeMemory_signal_gen_drive_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.memory_signal_gen_drive_enable'
        self.enum = RootLuPid_controllerPid_user2AttributeMemory_signal_gen_drive_enableEnum(self._context)


class RootLuPid_controllerPid_user2AttributeSet_point_modulation_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_user2AttributeSet_point_modulation_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.set_point_modulation_enable'
        self.enum = RootLuPid_controllerPid_user2AttributeSet_point_modulation_enableEnum(self._context)


class RootLuPid_controllerPid_user2AttributeSlope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.slope'


class RootLuPid_controllerPid_user2AttributePolarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.polarity'


class RootLuPid_controllerPid_user2AttributeOffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.offset'


class RootLuPid_controllerPid_user2AttributeInput_set_pointEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.input_set_point.enum'

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_amplitude', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_x', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in6', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_w_out', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_z_in', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_position_z', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_reference', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_deflection', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_y', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_position_x', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_free_wave', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_user1', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_z_pid_command', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_x_out', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_user2_out', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.fast_in_deflection', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_user2', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_position_y', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_position_z', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_z_nominal', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_adhesion_position', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_baseline_corrected', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_user3', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_amplitude', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_z_error', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_amplitude_reduction', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_test', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.static', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_position_y', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_y_out', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_position_x', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.gen_test_dynamic', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_plane_z', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_max_z', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.fast_in2', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_phase', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_excitation', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_baseline', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_user4', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_out8', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ctrl_z_out', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_out7', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_drive_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.memory_gen_drive_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ort_adhesion_value', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_detector_sum', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_tip_current', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.ramp_gen_position_x', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.fast_in_user', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.in_position_y', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user2.attribute.input_set_point.enum.analyzer2_y', int(new_val))


class RootLuPid_controllerPid_user2AttributeInput_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.input_set_point'
        self.enum = RootLuPid_controllerPid_user2AttributeInput_set_pointEnum(self._context)


class RootLuPid_controllerPid_user2AttributeMax_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.max_value'


class RootLuPid_controllerPid_user2AttributeCompare_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute.compare_mode'


class RootLuPid_controllerPid_user2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2.attribute'
        self.compare_mode = RootLuPid_controllerPid_user2AttributeCompare_mode(self._context)
        self.max_value = RootLuPid_controllerPid_user2AttributeMax_value(self._context)
        self.input_set_point = RootLuPid_controllerPid_user2AttributeInput_set_point(self._context)
        self.offset = RootLuPid_controllerPid_user2AttributeOffset(self._context)
        self.polarity = RootLuPid_controllerPid_user2AttributePolarity(self._context)
        self.slope = RootLuPid_controllerPid_user2AttributeSlope(self._context)
        self.set_point_modulation_enable = RootLuPid_controllerPid_user2AttributeSet_point_modulation_enable(self._context)
        self.memory_signal_gen_drive_enable = RootLuPid_controllerPid_user2AttributeMemory_signal_gen_drive_enable(self._context)
        self.reached_min = RootLuPid_controllerPid_user2AttributeReached_min(self._context)
        self.select_output = RootLuPid_controllerPid_user2AttributeSelect_output(self._context)
        self.memory_signal_gen_position_enable = RootLuPid_controllerPid_user2AttributeMemory_signal_gen_position_enable(self._context)
        self.error_limit = RootLuPid_controllerPid_user2AttributeError_limit(self._context)
        self.input_actual = RootLuPid_controllerPid_user2AttributeInput_actual(self._context)
        self.reached_err_lim = RootLuPid_controllerPid_user2AttributeReached_err_lim(self._context)
        self.p_gain = RootLuPid_controllerPid_user2AttributeP_gain(self._context)
        self.i_gain = RootLuPid_controllerPid_user2AttributeI_gain(self._context)
        self.reached_max = RootLuPid_controllerPid_user2AttributeReached_max(self._context)
        self.d_gain = RootLuPid_controllerPid_user2AttributeD_gain(self._context)
        self.set_point_gain = RootLuPid_controllerPid_user2AttributeSet_point_gain(self._context)
        self.median_filter_enable = RootLuPid_controllerPid_user2AttributeMedian_filter_enable(self._context)
        self.feedback_mode = RootLuPid_controllerPid_user2AttributeFeedback_mode(self._context)
        self.min_value = RootLuPid_controllerPid_user2AttributeMin_value(self._context)


class RootLuPid_controllerPid_user2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user2'
        self.attribute = RootLuPid_controllerPid_user2Attribute(self._context)
        self.trigger = RootLuPid_controllerPid_user2Trigger(self._context)


class RootLuPid_controllerPid_yTriggerCalibrate_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.trigger.calibrate_offset'


class RootLuPid_controllerPid_yTriggerDrive_to_zero_volt_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.trigger.drive_to_zero_volt_position'


class RootLuPid_controllerPid_yTriggerClear_pid_accu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.trigger.clear_pid_accu'


class RootLuPid_controllerPid_yTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.trigger'
        self.clear_pid_accu = RootLuPid_controllerPid_yTriggerClear_pid_accu(self._context)
        self.drive_to_zero_volt_position = RootLuPid_controllerPid_yTriggerDrive_to_zero_volt_position(self._context)
        self.calibrate_offset = RootLuPid_controllerPid_yTriggerCalibrate_offset(self._context)


class RootLuPid_controllerPid_yAttributeMin_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.min_value'


class RootLuPid_controllerPid_yAttributeFeedback_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.feedback_mode'


class RootLuPid_controllerPid_yAttributeMedian_filter_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.median_filter_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.median_filter_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.median_filter_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.median_filter_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.median_filter_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_yAttributeMedian_filter_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.median_filter_enable'
        self.enum = RootLuPid_controllerPid_yAttributeMedian_filter_enableEnum(self._context)


class RootLuPid_controllerPid_yAttributeSet_point_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.set_point_gain'


class RootLuPid_controllerPid_yAttributeD_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.d_gain'


class RootLuPid_controllerPid_yAttributeReached_max(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.reached_max'


class RootLuPid_controllerPid_yAttributeI_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.i_gain'


class RootLuPid_controllerPid_yAttributeP_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.p_gain'


class RootLuPid_controllerPid_yAttributeReached_err_lim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.reached_err_lim'


class RootLuPid_controllerPid_yAttributeInput_actualEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.input_actual.enum'

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_amplitude', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_x', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in6', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_w_out', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_z_in', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_position_z', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_reference', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_deflection', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_y', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_position_x', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_free_wave', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_user1', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_z_pid_command', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_x_out', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_user2_out', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.fast_in_deflection', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_user2', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_position_y', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_position_z', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_z_nominal', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_adhesion_position', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_baseline_corrected', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_user3', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_amplitude', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_z_error', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_amplitude_reduction', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_test', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.static', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_position_y', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_y_out', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_position_x', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.gen_test_dynamic', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_plane_z', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_max_z', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.fast_in2', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_phase', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_excitation', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_baseline', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_user4', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_out8', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ctrl_z_out', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_out7', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_drive_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.memory_gen_drive_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ort_adhesion_value', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_detector_sum', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_tip_current', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.ramp_gen_position_x', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.fast_in_user', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.in_position_y', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_actual.enum.analyzer2_y', int(new_val))


class RootLuPid_controllerPid_yAttributeInput_actual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.input_actual'
        self.enum = RootLuPid_controllerPid_yAttributeInput_actualEnum(self._context)


class RootLuPid_controllerPid_yAttributeError_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.error_limit'


class RootLuPid_controllerPid_yAttributeMemory_signal_gen_position_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_yAttributeMemory_signal_gen_position_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.memory_signal_gen_position_enable'
        self.enum = RootLuPid_controllerPid_yAttributeMemory_signal_gen_position_enableEnum(self._context)


class RootLuPid_controllerPid_yAttributeSelect_output(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.select_output'


class RootLuPid_controllerPid_yAttributeReached_min(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.reached_min'


class RootLuPid_controllerPid_yAttributeMemory_signal_gen_drive_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_yAttributeMemory_signal_gen_drive_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.memory_signal_gen_drive_enable'
        self.enum = RootLuPid_controllerPid_yAttributeMemory_signal_gen_drive_enableEnum(self._context)


class RootLuPid_controllerPid_yAttributeSet_point_modulation_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_yAttributeSet_point_modulation_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.set_point_modulation_enable'
        self.enum = RootLuPid_controllerPid_yAttributeSet_point_modulation_enableEnum(self._context)


class RootLuPid_controllerPid_yAttributeSlope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.slope'


class RootLuPid_controllerPid_yAttributePolarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.polarity'


class RootLuPid_controllerPid_yAttributeOffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.offset'


class RootLuPid_controllerPid_yAttributeInput_set_pointEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.input_set_point.enum'

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_amplitude', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_x', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in6', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_w_out', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_z_in', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_position_z', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_reference', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_deflection', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_y', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_position_x', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_free_wave', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_user1', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_z_pid_command', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_x_out', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_user2_out', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.fast_in_deflection', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_user2', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_position_y', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_position_z', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_z_nominal', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_adhesion_position', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_baseline_corrected', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_user3', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_amplitude', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_z_error', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_amplitude_reduction', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_test', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.static', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_position_y', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_y_out', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_position_x', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.gen_test_dynamic', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_plane_z', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_max_z', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.fast_in2', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_phase', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_excitation', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_baseline', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_user4', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_out8', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ctrl_z_out', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_out7', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_drive_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.memory_gen_drive_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ort_adhesion_value', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_detector_sum', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_tip_current', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.ramp_gen_position_x', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.fast_in_user', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.in_position_y', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_y.attribute.input_set_point.enum.analyzer2_y', int(new_val))


class RootLuPid_controllerPid_yAttributeInput_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.input_set_point'
        self.enum = RootLuPid_controllerPid_yAttributeInput_set_pointEnum(self._context)


class RootLuPid_controllerPid_yAttributeMax_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.max_value'


class RootLuPid_controllerPid_yAttributeCompare_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute.compare_mode'


class RootLuPid_controllerPid_yAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y.attribute'
        self.compare_mode = RootLuPid_controllerPid_yAttributeCompare_mode(self._context)
        self.max_value = RootLuPid_controllerPid_yAttributeMax_value(self._context)
        self.input_set_point = RootLuPid_controllerPid_yAttributeInput_set_point(self._context)
        self.offset = RootLuPid_controllerPid_yAttributeOffset(self._context)
        self.polarity = RootLuPid_controllerPid_yAttributePolarity(self._context)
        self.slope = RootLuPid_controllerPid_yAttributeSlope(self._context)
        self.set_point_modulation_enable = RootLuPid_controllerPid_yAttributeSet_point_modulation_enable(self._context)
        self.memory_signal_gen_drive_enable = RootLuPid_controllerPid_yAttributeMemory_signal_gen_drive_enable(self._context)
        self.reached_min = RootLuPid_controllerPid_yAttributeReached_min(self._context)
        self.select_output = RootLuPid_controllerPid_yAttributeSelect_output(self._context)
        self.memory_signal_gen_position_enable = RootLuPid_controllerPid_yAttributeMemory_signal_gen_position_enable(self._context)
        self.error_limit = RootLuPid_controllerPid_yAttributeError_limit(self._context)
        self.input_actual = RootLuPid_controllerPid_yAttributeInput_actual(self._context)
        self.reached_err_lim = RootLuPid_controllerPid_yAttributeReached_err_lim(self._context)
        self.p_gain = RootLuPid_controllerPid_yAttributeP_gain(self._context)
        self.i_gain = RootLuPid_controllerPid_yAttributeI_gain(self._context)
        self.reached_max = RootLuPid_controllerPid_yAttributeReached_max(self._context)
        self.d_gain = RootLuPid_controllerPid_yAttributeD_gain(self._context)
        self.set_point_gain = RootLuPid_controllerPid_yAttributeSet_point_gain(self._context)
        self.median_filter_enable = RootLuPid_controllerPid_yAttributeMedian_filter_enable(self._context)
        self.feedback_mode = RootLuPid_controllerPid_yAttributeFeedback_mode(self._context)
        self.min_value = RootLuPid_controllerPid_yAttributeMin_value(self._context)


class RootLuPid_controllerPid_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_y'
        self.attribute = RootLuPid_controllerPid_yAttribute(self._context)
        self.trigger = RootLuPid_controllerPid_yTrigger(self._context)


class RootLuPid_controllerPid_xTriggerCalibrate_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.trigger.calibrate_offset'


class RootLuPid_controllerPid_xTriggerDrive_to_zero_volt_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.trigger.drive_to_zero_volt_position'


class RootLuPid_controllerPid_xTriggerClear_pid_accu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.trigger.clear_pid_accu'


class RootLuPid_controllerPid_xTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.trigger'
        self.clear_pid_accu = RootLuPid_controllerPid_xTriggerClear_pid_accu(self._context)
        self.drive_to_zero_volt_position = RootLuPid_controllerPid_xTriggerDrive_to_zero_volt_position(self._context)
        self.calibrate_offset = RootLuPid_controllerPid_xTriggerCalibrate_offset(self._context)


class RootLuPid_controllerPid_xAttributeMin_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.min_value'


class RootLuPid_controllerPid_xAttributeFeedback_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.feedback_mode'


class RootLuPid_controllerPid_xAttributeMedian_filter_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.median_filter_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.median_filter_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.median_filter_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.median_filter_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.median_filter_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_xAttributeMedian_filter_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.median_filter_enable'
        self.enum = RootLuPid_controllerPid_xAttributeMedian_filter_enableEnum(self._context)


class RootLuPid_controllerPid_xAttributeSet_point_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.set_point_gain'


class RootLuPid_controllerPid_xAttributeD_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.d_gain'


class RootLuPid_controllerPid_xAttributeReached_max(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.reached_max'


class RootLuPid_controllerPid_xAttributeI_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.i_gain'


class RootLuPid_controllerPid_xAttributeP_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.p_gain'


class RootLuPid_controllerPid_xAttributeReached_err_lim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.reached_err_lim'


class RootLuPid_controllerPid_xAttributeInput_actualEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.input_actual.enum'

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_amplitude', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_x', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in6', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_w_out', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_z_in', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_position_z', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_reference', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_deflection', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_y', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_position_x', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_free_wave', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_user1', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_z_pid_command', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_x_out', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_user2_out', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.fast_in_deflection', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_user2', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_position_y', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_position_z', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_z_nominal', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_adhesion_position', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_baseline_corrected', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_user3', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_amplitude', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_z_error', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_amplitude_reduction', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_test', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.static', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_position_y', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_y_out', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_position_x', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.gen_test_dynamic', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_plane_z', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_max_z', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.fast_in2', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_phase', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_excitation', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_baseline', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_user4', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_out8', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ctrl_z_out', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_out7', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_drive_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.memory_gen_drive_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ort_adhesion_value', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_detector_sum', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_tip_current', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.ramp_gen_position_x', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.fast_in_user', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.in_position_y', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_actual.enum.analyzer2_y', int(new_val))


class RootLuPid_controllerPid_xAttributeInput_actual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.input_actual'
        self.enum = RootLuPid_controllerPid_xAttributeInput_actualEnum(self._context)


class RootLuPid_controllerPid_xAttributeError_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.error_limit'


class RootLuPid_controllerPid_xAttributeMemory_signal_gen_position_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_xAttributeMemory_signal_gen_position_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.memory_signal_gen_position_enable'
        self.enum = RootLuPid_controllerPid_xAttributeMemory_signal_gen_position_enableEnum(self._context)


class RootLuPid_controllerPid_xAttributeSelect_output(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.select_output'


class RootLuPid_controllerPid_xAttributeReached_min(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.reached_min'


class RootLuPid_controllerPid_xAttributeMemory_signal_gen_drive_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_xAttributeMemory_signal_gen_drive_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.memory_signal_gen_drive_enable'
        self.enum = RootLuPid_controllerPid_xAttributeMemory_signal_gen_drive_enableEnum(self._context)


class RootLuPid_controllerPid_xAttributeSet_point_modulation_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_xAttributeSet_point_modulation_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.set_point_modulation_enable'
        self.enum = RootLuPid_controllerPid_xAttributeSet_point_modulation_enableEnum(self._context)


class RootLuPid_controllerPid_xAttributeSlope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.slope'


class RootLuPid_controllerPid_xAttributePolarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.polarity'


class RootLuPid_controllerPid_xAttributeOffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.offset'


class RootLuPid_controllerPid_xAttributeInput_set_pointEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.input_set_point.enum'

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_amplitude', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_x', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in6', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_w_out', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_z_in', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_position_z', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_reference', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_deflection', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_y', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_position_x', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_free_wave', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_user1', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_z_pid_command', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_x_out', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_user2_out', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.fast_in_deflection', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_user2', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_position_y', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_position_z', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_z_nominal', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_adhesion_position', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_baseline_corrected', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_user3', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_amplitude', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_z_error', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_amplitude_reduction', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_test', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.static', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_position_y', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_y_out', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_position_x', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.gen_test_dynamic', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_plane_z', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_max_z', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.fast_in2', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_phase', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_excitation', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_baseline', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_user4', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_out8', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ctrl_z_out', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_out7', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_drive_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.memory_gen_drive_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ort_adhesion_value', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_detector_sum', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_tip_current', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.ramp_gen_position_x', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.fast_in_user', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.in_position_y', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_x.attribute.input_set_point.enum.analyzer2_y', int(new_val))


class RootLuPid_controllerPid_xAttributeInput_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.input_set_point'
        self.enum = RootLuPid_controllerPid_xAttributeInput_set_pointEnum(self._context)


class RootLuPid_controllerPid_xAttributeMax_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.max_value'


class RootLuPid_controllerPid_xAttributeCompare_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute.compare_mode'


class RootLuPid_controllerPid_xAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x.attribute'
        self.compare_mode = RootLuPid_controllerPid_xAttributeCompare_mode(self._context)
        self.max_value = RootLuPid_controllerPid_xAttributeMax_value(self._context)
        self.input_set_point = RootLuPid_controllerPid_xAttributeInput_set_point(self._context)
        self.offset = RootLuPid_controllerPid_xAttributeOffset(self._context)
        self.polarity = RootLuPid_controllerPid_xAttributePolarity(self._context)
        self.slope = RootLuPid_controllerPid_xAttributeSlope(self._context)
        self.set_point_modulation_enable = RootLuPid_controllerPid_xAttributeSet_point_modulation_enable(self._context)
        self.memory_signal_gen_drive_enable = RootLuPid_controllerPid_xAttributeMemory_signal_gen_drive_enable(self._context)
        self.reached_min = RootLuPid_controllerPid_xAttributeReached_min(self._context)
        self.select_output = RootLuPid_controllerPid_xAttributeSelect_output(self._context)
        self.memory_signal_gen_position_enable = RootLuPid_controllerPid_xAttributeMemory_signal_gen_position_enable(self._context)
        self.error_limit = RootLuPid_controllerPid_xAttributeError_limit(self._context)
        self.input_actual = RootLuPid_controllerPid_xAttributeInput_actual(self._context)
        self.reached_err_lim = RootLuPid_controllerPid_xAttributeReached_err_lim(self._context)
        self.p_gain = RootLuPid_controllerPid_xAttributeP_gain(self._context)
        self.i_gain = RootLuPid_controllerPid_xAttributeI_gain(self._context)
        self.reached_max = RootLuPid_controllerPid_xAttributeReached_max(self._context)
        self.d_gain = RootLuPid_controllerPid_xAttributeD_gain(self._context)
        self.set_point_gain = RootLuPid_controllerPid_xAttributeSet_point_gain(self._context)
        self.median_filter_enable = RootLuPid_controllerPid_xAttributeMedian_filter_enable(self._context)
        self.feedback_mode = RootLuPid_controllerPid_xAttributeFeedback_mode(self._context)
        self.min_value = RootLuPid_controllerPid_xAttributeMin_value(self._context)


class RootLuPid_controllerPid_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_x'
        self.attribute = RootLuPid_controllerPid_xAttribute(self._context)
        self.trigger = RootLuPid_controllerPid_xTrigger(self._context)


class RootLuPid_controllerPid_user1TriggerCalibrate_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.trigger.calibrate_offset'


class RootLuPid_controllerPid_user1TriggerDrive_to_zero_volt_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.trigger.drive_to_zero_volt_position'


class RootLuPid_controllerPid_user1TriggerClear_pid_accu(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.trigger.clear_pid_accu'


class RootLuPid_controllerPid_user1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.trigger'
        self.clear_pid_accu = RootLuPid_controllerPid_user1TriggerClear_pid_accu(self._context)
        self.drive_to_zero_volt_position = RootLuPid_controllerPid_user1TriggerDrive_to_zero_volt_position(self._context)
        self.calibrate_offset = RootLuPid_controllerPid_user1TriggerCalibrate_offset(self._context)


class RootLuPid_controllerPid_user1AttributeMin_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.min_value'


class RootLuPid_controllerPid_user1AttributeFeedback_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.feedback_mode'


class RootLuPid_controllerPid_user1AttributeMedian_filter_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.median_filter_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.median_filter_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.median_filter_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.median_filter_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.median_filter_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_user1AttributeMedian_filter_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.median_filter_enable'
        self.enum = RootLuPid_controllerPid_user1AttributeMedian_filter_enableEnum(self._context)


class RootLuPid_controllerPid_user1AttributeSet_point_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.set_point_gain'


class RootLuPid_controllerPid_user1AttributeD_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.d_gain'


class RootLuPid_controllerPid_user1AttributeReached_max(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.reached_max'


class RootLuPid_controllerPid_user1AttributeI_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.i_gain'


class RootLuPid_controllerPid_user1AttributeP_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.p_gain'


class RootLuPid_controllerPid_user1AttributeReached_err_lim(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.reached_err_lim'


class RootLuPid_controllerPid_user1AttributeInput_actualEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.input_actual.enum'

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_amplitude', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_x', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in6', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_w_out', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_z_in', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_position_z', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_reference', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_deflection', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_y', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_position_x', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_free_wave', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_user1', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_z_pid_command', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_x_out', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_user2_out', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.fast_in_deflection', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_user2', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_position_y', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_position_z', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_z_nominal', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_adhesion_position', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_baseline_corrected', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_user3', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_amplitude', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_z_error', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_amplitude_reduction', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_test', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.static', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_position_y', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_y_out', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_position_x', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.gen_test_dynamic', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_plane_z', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_max_z', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.fast_in2', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_phase', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_excitation', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_baseline', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_user4', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_out8', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ctrl_z_out', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_out7', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_drive_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.memory_gen_drive_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ort_adhesion_value', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_detector_sum', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_tip_current', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.ramp_gen_position_x', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.fast_in_user', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.in_position_y', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_actual.enum.analyzer2_y', int(new_val))


class RootLuPid_controllerPid_user1AttributeInput_actual(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.input_actual'
        self.enum = RootLuPid_controllerPid_user1AttributeInput_actualEnum(self._context)


class RootLuPid_controllerPid_user1AttributeError_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.error_limit'


class RootLuPid_controllerPid_user1AttributeMemory_signal_gen_position_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_user1AttributeMemory_signal_gen_position_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_position_enable'
        self.enum = RootLuPid_controllerPid_user1AttributeMemory_signal_gen_position_enableEnum(self._context)


class RootLuPid_controllerPid_user1AttributeSelect_output(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.select_output'


class RootLuPid_controllerPid_user1AttributeReached_min(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.reached_min'


class RootLuPid_controllerPid_user1AttributeMemory_signal_gen_drive_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_user1AttributeMemory_signal_gen_drive_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.memory_signal_gen_drive_enable'
        self.enum = RootLuPid_controllerPid_user1AttributeMemory_signal_gen_drive_enableEnum(self._context)


class RootLuPid_controllerPid_user1AttributeSet_point_modulation_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable.enum.enabled', int(new_val))


class RootLuPid_controllerPid_user1AttributeSet_point_modulation_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.set_point_modulation_enable'
        self.enum = RootLuPid_controllerPid_user1AttributeSet_point_modulation_enableEnum(self._context)


class RootLuPid_controllerPid_user1AttributeSlope(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.slope'


class RootLuPid_controllerPid_user1AttributePolarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.polarity'


class RootLuPid_controllerPid_user1AttributeOffset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.offset'


class RootLuPid_controllerPid_user1AttributeInput_set_pointEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.input_set_point.enum'

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_amplitude', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_x', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in6', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_w_out', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_z_in', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_position_z', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_reference', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_deflection', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_y', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_position_x', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_free_wave', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_user1', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_z_pid_command', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_x_out', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_user2_out', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.fast_in_deflection', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_user2', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_position_y', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_position_z', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_z_nominal', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_adhesion_position', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_baseline_corrected', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_user3', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_amplitude', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_z_error', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_amplitude_reduction', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_test', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.static', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_position_y', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_y_out', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_position_x', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.gen_test_dynamic', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_plane_z', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_max_z', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.fast_in2', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_phase', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_excitation', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_baseline', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_user4', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_out8', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ctrl_z_out', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_out7', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_drive_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.memory_gen_drive_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ort_adhesion_value', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_detector_sum', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_tip_current', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.ramp_gen_position_x', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.fast_in_user', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.in_position_y', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.pid_controller.pid_user1.attribute.input_set_point.enum.analyzer2_y', int(new_val))


class RootLuPid_controllerPid_user1AttributeInput_set_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.input_set_point'
        self.enum = RootLuPid_controllerPid_user1AttributeInput_set_pointEnum(self._context)


class RootLuPid_controllerPid_user1AttributeMax_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.max_value'


class RootLuPid_controllerPid_user1AttributeCompare_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute.compare_mode'


class RootLuPid_controllerPid_user1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1.attribute'
        self.compare_mode = RootLuPid_controllerPid_user1AttributeCompare_mode(self._context)
        self.max_value = RootLuPid_controllerPid_user1AttributeMax_value(self._context)
        self.input_set_point = RootLuPid_controllerPid_user1AttributeInput_set_point(self._context)
        self.offset = RootLuPid_controllerPid_user1AttributeOffset(self._context)
        self.polarity = RootLuPid_controllerPid_user1AttributePolarity(self._context)
        self.slope = RootLuPid_controllerPid_user1AttributeSlope(self._context)
        self.set_point_modulation_enable = RootLuPid_controllerPid_user1AttributeSet_point_modulation_enable(self._context)
        self.memory_signal_gen_drive_enable = RootLuPid_controllerPid_user1AttributeMemory_signal_gen_drive_enable(self._context)
        self.reached_min = RootLuPid_controllerPid_user1AttributeReached_min(self._context)
        self.select_output = RootLuPid_controllerPid_user1AttributeSelect_output(self._context)
        self.memory_signal_gen_position_enable = RootLuPid_controllerPid_user1AttributeMemory_signal_gen_position_enable(self._context)
        self.error_limit = RootLuPid_controllerPid_user1AttributeError_limit(self._context)
        self.input_actual = RootLuPid_controllerPid_user1AttributeInput_actual(self._context)
        self.reached_err_lim = RootLuPid_controllerPid_user1AttributeReached_err_lim(self._context)
        self.p_gain = RootLuPid_controllerPid_user1AttributeP_gain(self._context)
        self.i_gain = RootLuPid_controllerPid_user1AttributeI_gain(self._context)
        self.reached_max = RootLuPid_controllerPid_user1AttributeReached_max(self._context)
        self.d_gain = RootLuPid_controllerPid_user1AttributeD_gain(self._context)
        self.set_point_gain = RootLuPid_controllerPid_user1AttributeSet_point_gain(self._context)
        self.median_filter_enable = RootLuPid_controllerPid_user1AttributeMedian_filter_enable(self._context)
        self.feedback_mode = RootLuPid_controllerPid_user1AttributeFeedback_mode(self._context)
        self.min_value = RootLuPid_controllerPid_user1AttributeMin_value(self._context)


class RootLuPid_controllerPid_user1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller.pid_user1'
        self.attribute = RootLuPid_controllerPid_user1Attribute(self._context)
        self.trigger = RootLuPid_controllerPid_user1Trigger(self._context)


class RootLuPid_controller(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.pid_controller'
        self.pid_user1 = RootLuPid_controllerPid_user1(self._context)
        self.pid_x = RootLuPid_controllerPid_x(self._context)
        self.pid_y = RootLuPid_controllerPid_y(self._context)
        self.pid_user2 = RootLuPid_controllerPid_user2(self._context)
        self.pid_w = RootLuPid_controllerPid_w(self._context)


class RootLuScanheadInstanceTriggerDisable_pte_laser(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.disable_pte_laser'


class RootLuScanheadInstanceTriggerDisable_readout_laser(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.disable_readout_laser'


class RootLuScanheadInstanceTriggerEnable_electro_thermal_excitation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.enable_electro_thermal_excitation'


class RootLuScanheadInstanceTriggerDisable_electro_thermal_excitation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.disable_electro_thermal_excitation'


class RootLuScanheadInstanceTriggerEnable_piezo_electric_excitation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.enable_piezo_electric_excitation'


class RootLuScanheadInstanceTriggerEnable_pte_laser(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.enable_pte_laser'


class RootLuScanheadInstanceTriggerDisable_piezo_electric_excitation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.disable_piezo_electric_excitation'


class RootLuScanheadInstanceTriggerApply_tilt_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.apply_tilt_mode'


class RootLuScanheadInstanceTriggerEnable_readout_laser(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger.enable_readout_laser'


class RootLuScanheadInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.trigger'
        self.enable_readout_laser = RootLuScanheadInstanceTriggerEnable_readout_laser(self._context)
        self.apply_tilt_mode = RootLuScanheadInstanceTriggerApply_tilt_mode(self._context)
        self.disable_piezo_electric_excitation = RootLuScanheadInstanceTriggerDisable_piezo_electric_excitation(self._context)
        self.enable_pte_laser = RootLuScanheadInstanceTriggerEnable_pte_laser(self._context)
        self.enable_piezo_electric_excitation = RootLuScanheadInstanceTriggerEnable_piezo_electric_excitation(self._context)
        self.disable_electro_thermal_excitation = RootLuScanheadInstanceTriggerDisable_electro_thermal_excitation(self._context)
        self.enable_electro_thermal_excitation = RootLuScanheadInstanceTriggerEnable_electro_thermal_excitation(self._context)
        self.disable_readout_laser = RootLuScanheadInstanceTriggerDisable_readout_laser(self._context)
        self.disable_pte_laser = RootLuScanheadInstanceTriggerDisable_pte_laser(self._context)


class RootLuScanheadInstanceAttributeFast_in2_channelEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.fast_in2_channel.enum'

    @property
    def friction_channel(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.fast_in2_channel.enum.friction_channel'))

    @friction_channel.setter
    def friction_channel(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.fast_in2_channel.enum.friction_channel', int(new_val))

    @property
    def addon_in(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.fast_in2_channel.enum.addon_in'))

    @addon_in.setter
    def addon_in(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.fast_in2_channel.enum.addon_in', int(new_val))

    @property
    def pte_monitor(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.fast_in2_channel.enum.pte_monitor'))

    @pte_monitor.setter
    def pte_monitor(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.fast_in2_channel.enum.pte_monitor', int(new_val))


class RootLuScanheadInstanceAttributeFast_in2_channel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.fast_in2_channel'
        self.enum = RootLuScanheadInstanceAttributeFast_in2_channelEnum(self._context)


class RootLuScanheadInstanceAttributeHas_z_sensorEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_z_sensor.enum'

    @property
    def no(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.has_z_sensor.enum.no'))

    @no.setter
    def no(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.has_z_sensor.enum.no', int(new_val))

    @property
    def yes(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.has_z_sensor.enum.yes'))

    @yes.setter
    def yes(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.has_z_sensor.enum.yes', int(new_val))


class RootLuScanheadInstanceAttributeHas_z_sensor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_z_sensor'
        self.enum = RootLuScanheadInstanceAttributeHas_z_sensorEnum(self._context)


class RootLuScanheadInstanceAttributeTilt_angle_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_angle_x'


class RootLuScanheadInstanceAttributeReadout_laser_power_monitor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.readout_laser_power_monitor'


class RootLuScanheadInstanceAttributeTilt_angle_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_angle_y'


class RootLuScanheadInstanceAttributeTilt_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_mode.enum'

    @property
    def measured(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.tilt_mode.enum.measured'))

    @measured.setter
    def measured(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_mode.enum.measured', int(new_val))

    @property
    def override(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.tilt_mode.enum.override'))

    @override.setter
    def override(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.tilt_mode.enum.override', int(new_val))


class RootLuScanheadInstanceAttributeTilt_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.tilt_mode'
        self.enum = RootLuScanheadInstanceAttributeTilt_modeEnum(self._context)


class RootLuScanheadInstanceAttributePte_laser_setpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.pte_laser_setpoint'


class RootLuScanheadInstanceAttributeHas_xy_sensorEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_xy_sensor.enum'

    @property
    def no(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.has_xy_sensor.enum.no'))

    @no.setter
    def no(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.has_xy_sensor.enum.no', int(new_val))

    @property
    def yes(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.has_xy_sensor.enum.yes'))

    @yes.setter
    def yes(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.has_xy_sensor.enum.yes', int(new_val))


class RootLuScanheadInstanceAttributeHas_xy_sensor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.has_xy_sensor'
        self.enum = RootLuScanheadInstanceAttributeHas_xy_sensorEnum(self._context)


class RootLuScanheadInstanceAttributeReadout_laser_setpoint(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.readout_laser_setpoint'


class RootLuScanheadInstanceAttributePte_laser_power_monitor(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.pte_laser_power_monitor'


class RootLuScanheadInstanceAttributeTypeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.type.enum'

    @property
    def cytomass(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.cytomass'))

    @cytomass.setter
    def cytomass(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.cytomass', int(new_val))

    @property
    def dummy11(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy11'))

    @dummy11.setter
    def dummy11(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy11', int(new_val))

    @property
    def arac(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.arac'))

    @arac.setter
    def arac(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.arac', int(new_val))

    @property
    def dummy4(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy4'))

    @dummy4.setter
    def dummy4(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy4', int(new_val))

    @property
    def dummy8(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy8'))

    @dummy8.setter
    def dummy8(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy8', int(new_val))

    @property
    def nanite_afm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.nanite_afm'))

    @nanite_afm.setter
    def nanite_afm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.nanite_afm', int(new_val))

    @property
    def afsem(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.afsem'))

    @afsem.setter
    def afsem(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.afsem', int(new_val))

    @property
    def semafm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.semafm'))

    @semafm.setter
    def semafm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.semafm', int(new_val))

    @property
    def unknown(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.unknown'))

    @unknown.setter
    def unknown(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.unknown', int(new_val))

    @property
    def dummy7(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy7'))

    @dummy7.setter
    def dummy7(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy7', int(new_val))

    @property
    def core_afm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.core_afm'))

    @core_afm.setter
    def core_afm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.core_afm', int(new_val))

    @property
    def flex_afm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.flex_afm'))

    @flex_afm.setter
    def flex_afm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.flex_afm', int(new_val))

    @property
    def p6(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.p6'))

    @p6.setter
    def p6(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.p6', int(new_val))

    @property
    def dummy3(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy3'))

    @dummy3.setter
    def dummy3(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy3', int(new_val))

    @property
    def not_connected(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.not_connected'))

    @not_connected.setter
    def not_connected(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.not_connected', int(new_val))

    @property
    def dummy5(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy5'))

    @dummy5.setter
    def dummy5(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy5', int(new_val))

    @property
    def dummy6(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy6'))

    @dummy6.setter
    def dummy6(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy6', int(new_val))

    @property
    def lens_afm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.lens_afm'))

    @lens_afm.setter
    def lens_afm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.lens_afm', int(new_val))

    @property
    def p6_mount(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.p6_mount'))

    @p6_mount.setter
    def p6_mount(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.p6_mount', int(new_val))

    @property
    def dummy10(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.dummy10'))

    @dummy10.setter
    def dummy10(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.dummy10', int(new_val))

    @property
    def e_stm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.e_stm'))

    @e_stm.setter
    def e_stm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.e_stm', int(new_val))

    @property
    def e_afm(self) -> int:
        return int(self._context.get('root.lu.scanhead.instance.attribute.type.enum.e_afm'))

    @e_afm.setter
    def e_afm(self, new_val:int):
        self._context.set('root.lu.scanhead.instance.attribute.type.enum.e_afm', int(new_val))


class RootLuScanheadInstanceAttributeType(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute.type'
        self.enum = RootLuScanheadInstanceAttributeTypeEnum(self._context)


class RootLuScanheadInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance.attribute'
        self.type = RootLuScanheadInstanceAttributeType(self._context)
        self.pte_laser_power_monitor = RootLuScanheadInstanceAttributePte_laser_power_monitor(self._context)
        self.readout_laser_setpoint = RootLuScanheadInstanceAttributeReadout_laser_setpoint(self._context)
        self.has_xy_sensor = RootLuScanheadInstanceAttributeHas_xy_sensor(self._context)
        self.pte_laser_setpoint = RootLuScanheadInstanceAttributePte_laser_setpoint(self._context)
        self.tilt_mode = RootLuScanheadInstanceAttributeTilt_mode(self._context)
        self.tilt_angle_y = RootLuScanheadInstanceAttributeTilt_angle_y(self._context)
        self.readout_laser_power_monitor = RootLuScanheadInstanceAttributeReadout_laser_power_monitor(self._context)
        self.tilt_angle_x = RootLuScanheadInstanceAttributeTilt_angle_x(self._context)
        self.has_z_sensor = RootLuScanheadInstanceAttributeHas_z_sensor(self._context)
        self.fast_in2_channel = RootLuScanheadInstanceAttributeFast_in2_channel(self._context)


class RootLuScanheadInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead.instance'
        self.attribute = RootLuScanheadInstanceAttribute(self._context)
        self.trigger = RootLuScanheadInstanceTrigger(self._context)


class RootLuScanhead(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.scanhead'
        self.instance = RootLuScanheadInstance(self._context)


class RootLuSequencerInstanceTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.trigger.start'


class RootLuSequencerInstanceTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.trigger.abort'


class RootLuSequencerInstanceTriggerStep(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.trigger.step'


class RootLuSequencerInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.trigger'
        self.step = RootLuSequencerInstanceTriggerStep(self._context)
        self.abort = RootLuSequencerInstanceTriggerAbort(self._context)
        self.start = RootLuSequencerInstanceTriggerStart(self._context)


class RootLuSequencerInstanceAttributeMemory_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute.memory_vec'


class RootLuSequencerInstanceAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute.status'


class RootLuSequencerInstanceAttributeInstruction_pointer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute.instruction_pointer'


class RootLuSequencerInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.attribute'
        self.instruction_pointer = RootLuSequencerInstanceAttributeInstruction_pointer(self._context)
        self.status = RootLuSequencerInstanceAttributeStatus(self._context)
        self.memory_vec = RootLuSequencerInstanceAttributeMemory_vec(self._context)


class RootLuSequencerInstanceBusyIs_running(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.busy.is_running'


class RootLuSequencerInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance.busy'
        self.is_running = RootLuSequencerInstanceBusyIs_running(self._context)


class RootLuSequencerInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer.instance'
        self.busy = RootLuSequencerInstanceBusy(self._context)
        self.attribute = RootLuSequencerInstanceAttribute(self._context)
        self.trigger = RootLuSequencerInstanceTrigger(self._context)


class RootLuSequencer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sequencer'
        self.instance = RootLuSequencerInstance(self._context)


class RootLuHv_amplifierInstanceTriggerStart_switch_to_target_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.start_switch_to_target_mode'


class RootLuHv_amplifierInstanceTriggerDisable_power(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.disable_power'


class RootLuHv_amplifierInstanceTriggerEnable_power(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.enable_power'


class RootLuHv_amplifierInstanceTriggerEnable_module(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.enable_module'


class RootLuHv_amplifierInstanceTriggerDepreciated_6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.depreciated_6'


class RootLuHv_amplifierInstanceTriggerDisable_z_modulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.disable_z_modulation'


class RootLuHv_amplifierInstanceTriggerDisable_module(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.disable_module'


class RootLuHv_amplifierInstanceTriggerEnable_z_modulation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.enable_z_modulation'


class RootLuHv_amplifierInstanceTriggerSwitch_to_target_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger.switch_to_target_mode'


class RootLuHv_amplifierInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.trigger'
        self.switch_to_target_mode = RootLuHv_amplifierInstanceTriggerSwitch_to_target_mode(self._context)
        self.enable_z_modulation = RootLuHv_amplifierInstanceTriggerEnable_z_modulation(self._context)
        self.disable_module = RootLuHv_amplifierInstanceTriggerDisable_module(self._context)
        self.disable_z_modulation = RootLuHv_amplifierInstanceTriggerDisable_z_modulation(self._context)
        self.depreciated_6 = RootLuHv_amplifierInstanceTriggerDepreciated_6(self._context)
        self.enable_module = RootLuHv_amplifierInstanceTriggerEnable_module(self._context)
        self.enable_power = RootLuHv_amplifierInstanceTriggerEnable_power(self._context)
        self.disable_power = RootLuHv_amplifierInstanceTriggerDisable_power(self._context)
        self.start_switch_to_target_mode = RootLuHv_amplifierInstanceTriggerStart_switch_to_target_mode(self._context)


class RootLuHv_amplifierInstanceAttributeMode_targetEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.mode_target.enum'

    @property
    def off(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.mode_target.enum.off'))

    @off.setter
    def off(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.mode_target.enum.off', int(new_val))

    @property
    def hv(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.mode_target.enum.hv'))

    @hv.setter
    def hv(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.mode_target.enum.hv', int(new_val))

    @property
    def lv(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.mode_target.enum.lv'))

    @lv.setter
    def lv(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.mode_target.enum.lv', int(new_val))


class RootLuHv_amplifierInstanceAttributeMode_target(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.mode_target'
        self.enum = RootLuHv_amplifierInstanceAttributeMode_targetEnum(self._context)


class RootLuHv_amplifierInstanceAttributeOutput_discharge_delay(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.output_discharge_delay'


class RootLuHv_amplifierInstanceAttributeInterlock_open_cx_cable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.interlock_open_cx_cable'


class RootLuHv_amplifierInstanceAttributeLast_mode_switch_retvalEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum'

    @property
    def mode_not_supported(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum.mode_not_supported'))

    @mode_not_supported.setter
    def mode_not_supported(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum.mode_not_supported', int(new_val))

    @property
    def interlock_open(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum.interlock_open'))

    @interlock_open.setter
    def interlock_open(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum.interlock_open', int(new_val))

    @property
    def ok(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum.ok'))

    @ok.setter
    def ok(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval.enum.ok', int(new_val))


class RootLuHv_amplifierInstanceAttributeLast_mode_switch_retval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.last_mode_switch_retval'
        self.enum = RootLuHv_amplifierInstanceAttributeLast_mode_switch_retvalEnum(self._context)


class RootLuHv_amplifierInstanceAttributeTemperature(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.temperature'


class RootLuHv_amplifierInstanceAttributeZ_modulation_enabled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.z_modulation_enabled'


class RootLuHv_amplifierInstanceAttributeInterlock_open_hv_cable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.interlock_open_hv_cable'


class RootLuHv_amplifierInstanceAttributeMode_currentEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.mode_current.enum'

    @property
    def off(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.mode_current.enum.off'))

    @off.setter
    def off(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.mode_current.enum.off', int(new_val))

    @property
    def hv(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.mode_current.enum.hv'))

    @hv.setter
    def hv(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.mode_current.enum.hv', int(new_val))

    @property
    def lv(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.mode_current.enum.lv'))

    @lv.setter
    def lv(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.mode_current.enum.lv', int(new_val))


class RootLuHv_amplifierInstanceAttributeMode_current(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.mode_current'
        self.enum = RootLuHv_amplifierInstanceAttributeMode_currentEnum(self._context)


class RootLuHv_amplifierInstanceAttributeHv_module_enabled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.hv_module_enabled'


class RootLuHv_amplifierInstanceAttributePower_enabled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.power_enabled'


class RootLuHv_amplifierInstanceAttributeInterlock_open_user(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.interlock_open_user'


class RootLuHv_amplifierInstanceAttributeTypeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.type.enum'

    @property
    def hv500(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.type.enum.hv500'))

    @hv500.setter
    def hv500(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.type.enum.hv500', int(new_val))

    @property
    def a201(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.type.enum.a201'))

    @a201.setter
    def a201(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.type.enum.a201', int(new_val))

    @property
    def not_connected(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.type.enum.not_connected'))

    @not_connected.setter
    def not_connected(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.type.enum.not_connected', int(new_val))

    @property
    def unknown(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.type.enum.unknown'))

    @unknown.setter
    def unknown(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.type.enum.unknown', int(new_val))

    @property
    def hv180(self) -> int:
        return int(self._context.get('root.lu.hv_amplifier.instance.attribute.type.enum.hv180'))

    @hv180.setter
    def hv180(self, new_val:int):
        self._context.set('root.lu.hv_amplifier.instance.attribute.type.enum.hv180', int(new_val))


class RootLuHv_amplifierInstanceAttributeType(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute.type'
        self.enum = RootLuHv_amplifierInstanceAttributeTypeEnum(self._context)


class RootLuHv_amplifierInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance.attribute'
        self.type = RootLuHv_amplifierInstanceAttributeType(self._context)
        self.interlock_open_user = RootLuHv_amplifierInstanceAttributeInterlock_open_user(self._context)
        self.power_enabled = RootLuHv_amplifierInstanceAttributePower_enabled(self._context)
        self.hv_module_enabled = RootLuHv_amplifierInstanceAttributeHv_module_enabled(self._context)
        self.mode_current = RootLuHv_amplifierInstanceAttributeMode_current(self._context)
        self.interlock_open_hv_cable = RootLuHv_amplifierInstanceAttributeInterlock_open_hv_cable(self._context)
        self.z_modulation_enabled = RootLuHv_amplifierInstanceAttributeZ_modulation_enabled(self._context)
        self.temperature = RootLuHv_amplifierInstanceAttributeTemperature(self._context)
        self.last_mode_switch_retval = RootLuHv_amplifierInstanceAttributeLast_mode_switch_retval(self._context)
        self.interlock_open_cx_cable = RootLuHv_amplifierInstanceAttributeInterlock_open_cx_cable(self._context)
        self.output_discharge_delay = RootLuHv_amplifierInstanceAttributeOutput_discharge_delay(self._context)
        self.mode_target = RootLuHv_amplifierInstanceAttributeMode_target(self._context)


class RootLuHv_amplifierInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier.instance'
        self.attribute = RootLuHv_amplifierInstanceAttribute(self._context)
        self.trigger = RootLuHv_amplifierInstanceTrigger(self._context)


class RootLuHv_amplifier(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.hv_amplifier'
        self.instance = RootLuHv_amplifierInstance(self._context)


class RootLuSensor_controlInstanceTriggerDeflection_offset_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.deflection_offset_calibration'


class RootLuSensor_controlInstanceTriggerStart_deflection_offset_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_deflection_offset_calibration'


class RootLuSensor_controlInstanceTriggerStart_detector_auto_adjustment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_detector_auto_adjustment'


class RootLuSensor_controlInstanceTriggerStart_set_dynamic_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_set_dynamic_amplitude'


class RootLuSensor_controlInstanceTriggerStart_sensor_calibration(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_sensor_calibration'


class RootLuSensor_controlInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.user_abort'


class RootLuSensor_controlInstanceTriggerDeflection_offset_calibration_with_retract(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.deflection_offset_calibration_with_retract'


class RootLuSensor_controlInstanceTriggerStart_update_laser_spot_on_detector_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.start_update_laser_spot_on_detector_status'


class RootLuSensor_controlInstanceTriggerUpdate_laser_spot_on_detector_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger.update_laser_spot_on_detector_status'


class RootLuSensor_controlInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.trigger'
        self.update_laser_spot_on_detector_status = RootLuSensor_controlInstanceTriggerUpdate_laser_spot_on_detector_status(self._context)
        self.start_update_laser_spot_on_detector_status = RootLuSensor_controlInstanceTriggerStart_update_laser_spot_on_detector_status(self._context)
        self.deflection_offset_calibration_with_retract = RootLuSensor_controlInstanceTriggerDeflection_offset_calibration_with_retract(self._context)
        self.user_abort = RootLuSensor_controlInstanceTriggerUser_abort(self._context)
        self.start_sensor_calibration = RootLuSensor_controlInstanceTriggerStart_sensor_calibration(self._context)
        self.start_set_dynamic_amplitude = RootLuSensor_controlInstanceTriggerStart_set_dynamic_amplitude(self._context)
        self.start_detector_auto_adjustment = RootLuSensor_controlInstanceTriggerStart_detector_auto_adjustment(self._context)
        self.start_deflection_offset_calibration = RootLuSensor_controlInstanceTriggerStart_deflection_offset_calibration(self._context)
        self.deflection_offset_calibration = RootLuSensor_controlInstanceTriggerDeflection_offset_calibration(self._context)


class RootLuSensor_controlInstanceAttributeDetector_adjustment_tolerance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_adjustment_tolerance'


class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum'

    @property
    def fix_from_attr(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum.fix_from_attr'))

    @fix_from_attr.setter
    def fix_from_attr(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum.fix_from_attr', int(new_val))

    @property
    def auto_from_head_typ(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum.auto_from_head_typ'))

    @auto_from_head_typ.setter
    def auto_from_head_typ(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode.enum.auto_from_head_typ', int(new_val))


class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain_mode'
        self.enum = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_modeEnum(self._context)


class RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum'

    @property
    def running(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.running'))

    @running.setter
    def running(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.running', int(new_val))

    @property
    def idle(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.idle'))

    @idle.setter
    def idle(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.idle', int(new_val))

    @property
    def failed(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.failed'))

    @failed.setter
    def failed(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status.enum.failed', int(new_val))


class RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_auto_adjustment_status'
        self.enum = RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_statusEnum(self._context)


class RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum'

    @property
    def calibration_error(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.calibration_error'))

    @calibration_error.setter
    def calibration_error(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.calibration_error', int(new_val))

    @property
    def no_error(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.no_error'))

    @no_error.setter
    def no_error(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.no_error', int(new_val))

    @property
    def sensor_signal_failed(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.sensor_signal_failed'))

    @sensor_signal_failed.setter
    def sensor_signal_failed(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status.enum.sensor_signal_failed', int(new_val))


class RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.deflection_offset_calibration_status'
        self.enum = RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_statusEnum(self._context)


class RootLuSensor_controlInstanceAttributeSensor_amplitude(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.sensor_amplitude'


class RootLuSensor_controlInstanceAttributeOffset_calib_i_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_i_gain'


class RootLuSensor_controlInstanceAttributeDetector_adjustment_duration_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.detector_adjustment_duration_limit'


class RootLuSensor_controlInstanceAttributeOffset_calib_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_mode.enum'

    @property
    def auto_calibrate_z_ctrl_input(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.auto_calibrate_z_ctrl_input'))

    @auto_calibrate_z_ctrl_input.setter
    def auto_calibrate_z_ctrl_input(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.auto_calibrate_z_ctrl_input', int(new_val))

    @property
    def no_auto_calibration(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.no_auto_calibration'))

    @no_auto_calibration.setter
    def no_auto_calibration(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.no_auto_calibration', int(new_val))

    @property
    def auto_calibrate_deflection(self) -> int:
        return int(self._context.get('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.auto_calibrate_deflection'))

    @auto_calibrate_deflection.setter
    def auto_calibrate_deflection(self, new_val:int):
        self._context.set('root.lu.sensor_control.instance.attribute.offset_calib_mode.enum.auto_calibrate_deflection', int(new_val))


class RootLuSensor_controlInstanceAttributeOffset_calib_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.offset_calib_mode'
        self.enum = RootLuSensor_controlInstanceAttributeOffset_calib_modeEnum(self._context)


class RootLuSensor_controlInstanceAttributeEnable10_hz_update_laser_spot_on_detector_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute.enable10_hz_update_laser_spot_on_detector_status'


class RootLuSensor_controlInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance.attribute'
        self.enable10_hz_update_laser_spot_on_detector_status = RootLuSensor_controlInstanceAttributeEnable10_hz_update_laser_spot_on_detector_status(self._context)
        self.offset_calib_mode = RootLuSensor_controlInstanceAttributeOffset_calib_mode(self._context)
        self.detector_adjustment_duration_limit = RootLuSensor_controlInstanceAttributeDetector_adjustment_duration_limit(self._context)
        self.offset_calib_i_gain = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain(self._context)
        self.sensor_amplitude = RootLuSensor_controlInstanceAttributeSensor_amplitude(self._context)
        self.deflection_offset_calibration_status = RootLuSensor_controlInstanceAttributeDeflection_offset_calibration_status(self._context)
        self.detector_auto_adjustment_status = RootLuSensor_controlInstanceAttributeDetector_auto_adjustment_status(self._context)
        self.offset_calib_i_gain_mode = RootLuSensor_controlInstanceAttributeOffset_calib_i_gain_mode(self._context)
        self.detector_adjustment_tolerance = RootLuSensor_controlInstanceAttributeDetector_adjustment_tolerance(self._context)


class RootLuSensor_controlInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control.instance'
        self.attribute = RootLuSensor_controlInstanceAttribute(self._context)
        self.trigger = RootLuSensor_controlInstanceTrigger(self._context)


class RootLuSensor_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.sensor_control'
        self.instance = RootLuSensor_controlInstance(self._context)


class RootLuThermal_tuningInstanceTriggerStart_block(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning.instance.trigger.start_block'


class RootLuThermal_tuningInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning.instance.trigger.user_abort'


class RootLuThermal_tuningInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning.instance.trigger'
        self.user_abort = RootLuThermal_tuningInstanceTriggerUser_abort(self._context)
        self.start_block = RootLuThermal_tuningInstanceTriggerStart_block(self._context)


class RootLuThermal_tuningInstanceAttributeBuffer_group_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning.instance.attribute.buffer_group_id'


class RootLuThermal_tuningInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning.instance.attribute'
        self.buffer_group_id = RootLuThermal_tuningInstanceAttributeBuffer_group_id(self._context)


class RootLuThermal_tuningInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning.instance'
        self.attribute = RootLuThermal_tuningInstanceAttribute(self._context)
        self.trigger = RootLuThermal_tuningInstanceTrigger(self._context)


class RootLuThermal_tuning(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.thermal_tuning'
        self.instance = RootLuThermal_tuningInstance(self._context)


class RootLuPosition_controlInstanceTriggerMove_to_target_fix_speed_xyz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.move_to_target_fix_speed_xyz'


class RootLuPosition_controlInstanceTriggerMove_to_target_fix_time_xyz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.move_to_target_fix_time_xyz'


class RootLuPosition_controlInstanceTriggerMove_to_target_fix_speed_xy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.move_to_target_fix_speed_xy'


class RootLuPosition_controlInstanceTriggerStart_calib_xy_sensor_zero_to_center_of_ramp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.start_calib_xy_sensor_zero_to_center_of_ramp'


class RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_speed_xyz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.start_move_to_target_fix_speed_xyz'


class RootLuPosition_controlInstanceTriggerStart_switch_to_target_scan_axis_range_select(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.start_switch_to_target_scan_axis_range_select'


class RootLuPosition_controlInstanceTriggerCalib_xy_sensor_zero_to_center_of_ramp(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.calib_xy_sensor_zero_to_center_of_ramp'


class RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_speed_xy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.start_move_to_target_fix_speed_xy'


class RootLuPosition_controlInstanceTriggerSwitch_to_target_scan_axis_range_select(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.switch_to_target_scan_axis_range_select'


class RootLuPosition_controlInstanceTriggerMove_to_target_fix_time_xy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.move_to_target_fix_time_xy'


class RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_time_xy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.start_move_to_target_fix_time_xy'


class RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_time_xyz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger.start_move_to_target_fix_time_xyz'


class RootLuPosition_controlInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.trigger'
        self.start_move_to_target_fix_time_xyz = RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_time_xyz(self._context)
        self.start_move_to_target_fix_time_xy = RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_time_xy(self._context)
        self.move_to_target_fix_time_xy = RootLuPosition_controlInstanceTriggerMove_to_target_fix_time_xy(self._context)
        self.switch_to_target_scan_axis_range_select = RootLuPosition_controlInstanceTriggerSwitch_to_target_scan_axis_range_select(self._context)
        self.start_move_to_target_fix_speed_xy = RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_speed_xy(self._context)
        self.calib_xy_sensor_zero_to_center_of_ramp = RootLuPosition_controlInstanceTriggerCalib_xy_sensor_zero_to_center_of_ramp(self._context)
        self.start_switch_to_target_scan_axis_range_select = RootLuPosition_controlInstanceTriggerStart_switch_to_target_scan_axis_range_select(self._context)
        self.start_move_to_target_fix_speed_xyz = RootLuPosition_controlInstanceTriggerStart_move_to_target_fix_speed_xyz(self._context)
        self.start_calib_xy_sensor_zero_to_center_of_ramp = RootLuPosition_controlInstanceTriggerStart_calib_xy_sensor_zero_to_center_of_ramp(self._context)
        self.move_to_target_fix_speed_xy = RootLuPosition_controlInstanceTriggerMove_to_target_fix_speed_xy(self._context)
        self.move_to_target_fix_time_xyz = RootLuPosition_controlInstanceTriggerMove_to_target_fix_time_xyz(self._context)
        self.move_to_target_fix_speed_xyz = RootLuPosition_controlInstanceTriggerMove_to_target_fix_speed_xyz(self._context)


class RootLuPosition_controlInstanceAttributeCurrent_scan_axis_range_selectEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum'

    @property
    def full_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum.full_range'))

    @full_range.setter
    def full_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum.full_range', int(new_val))

    @property
    def off(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum.off'))

    @off.setter
    def off(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum.off', int(new_val))

    @property
    def reduced_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum.reduced_range'))

    @reduced_range.setter
    def reduced_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.current_scan_axis_range_select.enum.reduced_range', int(new_val))


class RootLuPosition_controlInstanceAttributeCurrent_scan_axis_range_select(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_scan_axis_range_select'
        self.enum = RootLuPosition_controlInstanceAttributeCurrent_scan_axis_range_selectEnum(self._context)


class RootLuPosition_controlInstanceAttributeRamp_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.ramp_time'


class RootLuPosition_controlInstanceAttributeLast_move_stop_eventEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.last_move_stop_event.enum'

    @property
    def timer_expired(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.timer_expired'))

    @timer_expired.setter
    def timer_expired(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.timer_expired', int(new_val))

    @property
    def out_of_bound_lower_limit(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_lower_limit'))

    @out_of_bound_lower_limit.setter
    def out_of_bound_lower_limit(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_lower_limit', int(new_val))

    @property
    def setpoint_reached(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.setpoint_reached'))

    @setpoint_reached.setter
    def setpoint_reached(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.setpoint_reached', int(new_val))

    @property
    def user_abort(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.user_abort'))

    @user_abort.setter
    def user_abort(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.user_abort', int(new_val))

    @property
    def position_reached(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.position_reached'))

    @position_reached.setter
    def position_reached(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.position_reached', int(new_val))

    @property
    def out_of_data(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_data'))

    @out_of_data.setter
    def out_of_data(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_data', int(new_val))

    @property
    def out_of_bound_upper_limit(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_upper_limit'))

    @out_of_bound_upper_limit.setter
    def out_of_bound_upper_limit(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_upper_limit', int(new_val))

    @property
    def out_of_bound_min(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_min'))

    @out_of_bound_min.setter
    def out_of_bound_min(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_min', int(new_val))

    @property
    def finish(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.finish'))

    @finish.setter
    def finish(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.finish', int(new_val))

    @property
    def out_of_bound_max(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_max'))

    @out_of_bound_max.setter
    def out_of_bound_max(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_move_stop_event.enum.out_of_bound_max', int(new_val))


class RootLuPosition_controlInstanceAttributeLast_move_stop_event(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.last_move_stop_event'
        self.enum = RootLuPosition_controlInstanceAttributeLast_move_stop_eventEnum(self._context)


class RootLuPosition_controlInstanceAttributePid_controller_settings_yEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.pid_controller_settings_y.enum'

    @property
    def p_gain(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.pid_controller_settings_y.enum.p_gain'))

    @p_gain.setter
    def p_gain(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.pid_controller_settings_y.enum.p_gain', int(new_val))

    @property
    def i_gain(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.pid_controller_settings_y.enum.i_gain'))

    @i_gain.setter
    def i_gain(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.pid_controller_settings_y.enum.i_gain', int(new_val))

    @property
    def d_gain(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.pid_controller_settings_y.enum.d_gain'))

    @d_gain.setter
    def d_gain(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.pid_controller_settings_y.enum.d_gain', int(new_val))


class RootLuPosition_controlInstanceAttributePid_controller_settings_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.pid_controller_settings_y'
        self.enum = RootLuPosition_controlInstanceAttributePid_controller_settings_yEnum(self._context)


class RootLuPosition_controlInstanceAttributeCurrent_pos_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_pos_z'


class RootLuPosition_controlInstanceAttributeScan_correction_x_rotation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.scan_correction_x_rotation'


class RootLuPosition_controlInstanceAttributeTarget_move_pos_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_move_pos_y'


class RootLuPosition_controlInstanceAttributeTarget_move_pos_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_move_pos_z'


class RootLuPosition_controlInstanceAttributeTarget_moving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_moving_time'


class RootLuPosition_controlInstanceAttributeTarget_move_pos_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_move_pos_x'


class RootLuPosition_controlInstanceAttributeAxis_scale_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.axis_scale_z'


class RootLuPosition_controlInstanceAttributeIs_xy_closed_loop_possibleEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum'

    @property
    def not_possible_wrong_scan_axis_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible_wrong_scan_axis_range'))

    @not_possible_wrong_scan_axis_range.setter
    def not_possible_wrong_scan_axis_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible_wrong_scan_axis_range', int(new_val))

    @property
    def possible(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.possible'))

    @possible.setter
    def possible(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.possible', int(new_val))

    @property
    def not_possible_no_scan_head(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible_no_scan_head'))

    @not_possible_no_scan_head.setter
    def not_possible_no_scan_head(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible_no_scan_head', int(new_val))

    @property
    def not_possible(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible'))

    @not_possible.setter
    def not_possible(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible', int(new_val))

    @property
    def not_possible_no_sensor(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible_no_sensor'))

    @not_possible_no_sensor.setter
    def not_possible_no_sensor(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.is_xy_closed_loop_possible.enum.not_possible_no_sensor', int(new_val))


class RootLuPosition_controlInstanceAttributeIs_xy_closed_loop_possible(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.is_xy_closed_loop_possible'
        self.enum = RootLuPosition_controlInstanceAttributeIs_xy_closed_loop_possibleEnum(self._context)


class RootLuPosition_controlInstanceAttributeTarget_scan_axis_range_selectEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum'

    @property
    def full_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum.full_range'))

    @full_range.setter
    def full_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum.full_range', int(new_val))

    @property
    def off(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum.off'))

    @off.setter
    def off(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum.off', int(new_val))

    @property
    def reduced_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum.reduced_range'))

    @reduced_range.setter
    def reduced_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.target_scan_axis_range_select.enum.reduced_range', int(new_val))


class RootLuPosition_controlInstanceAttributeTarget_scan_axis_range_select(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_scan_axis_range_select'
        self.enum = RootLuPosition_controlInstanceAttributeTarget_scan_axis_range_selectEnum(self._context)


class RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_keep_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.xy_closed_loop_speed_keep_pos'


class RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode.enum'

    @property
    def moving(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode.enum.moving'))

    @moving.setter
    def moving(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode.enum.moving', int(new_val))

    @property
    def keep_position(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode.enum.keep_position'))

    @keep_position.setter
    def keep_position(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode.enum.keep_position', int(new_val))


class RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.xy_closed_loop_speed_mode'
        self.enum = RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_modeEnum(self._context)


class RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.xy_closed_loop_speed_moving'


class RootLuPosition_controlInstanceAttributeTarget_moving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.target_moving_speed'


class RootLuPosition_controlInstanceAttributeEnable_xy_closed_loop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.enable_xy_closed_loop'


class RootLuPosition_controlInstanceAttributeCurrent_pos_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_pos_y'


class RootLuPosition_controlInstanceAttributeAxis_scale_xylv(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.axis_scale_xylv'


class RootLuPosition_controlInstanceAttributeAxis_scale_xy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.axis_scale_xy'


class RootLuPosition_controlInstanceAttributeCurrent_pos_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.current_pos_x'


class RootLuPosition_controlInstanceAttributeAxis_scale_zlv(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.axis_scale_zlv'


class RootLuPosition_controlInstanceAttributeRamp_count(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.ramp_count'


class RootLuPosition_controlInstanceAttributePid_controller_settings_xEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.pid_controller_settings_x.enum'

    @property
    def p_gain(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.pid_controller_settings_x.enum.p_gain'))

    @p_gain.setter
    def p_gain(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.pid_controller_settings_x.enum.p_gain', int(new_val))

    @property
    def i_gain(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.pid_controller_settings_x.enum.i_gain'))

    @i_gain.setter
    def i_gain(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.pid_controller_settings_x.enum.i_gain', int(new_val))

    @property
    def d_gain(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.pid_controller_settings_x.enum.d_gain'))

    @d_gain.setter
    def d_gain(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.pid_controller_settings_x.enum.d_gain', int(new_val))


class RootLuPosition_controlInstanceAttributePid_controller_settings_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.pid_controller_settings_x'
        self.enum = RootLuPosition_controlInstanceAttributePid_controller_settings_xEnum(self._context)


class RootLuPosition_controlInstanceAttributeScan_correction_y_rotation(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.scan_correction_y_rotation'


class RootLuPosition_controlInstanceAttributeLast_scan_axis_range_select_switch_resultEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum'

    @property
    def full_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum.full_range'))

    @full_range.setter
    def full_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum.full_range', int(new_val))

    @property
    def off(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum.off'))

    @off.setter
    def off(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum.off', int(new_val))

    @property
    def reduced_range(self) -> int:
        return int(self._context.get('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum.reduced_range'))

    @reduced_range.setter
    def reduced_range(self, new_val:int):
        self._context.set('root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result.enum.reduced_range', int(new_val))


class RootLuPosition_controlInstanceAttributeLast_scan_axis_range_select_switch_result(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute.last_scan_axis_range_select_switch_result'
        self.enum = RootLuPosition_controlInstanceAttributeLast_scan_axis_range_select_switch_resultEnum(self._context)


class RootLuPosition_controlInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.attribute'
        self.last_scan_axis_range_select_switch_result = RootLuPosition_controlInstanceAttributeLast_scan_axis_range_select_switch_result(self._context)
        self.scan_correction_y_rotation = RootLuPosition_controlInstanceAttributeScan_correction_y_rotation(self._context)
        self.pid_controller_settings_x = RootLuPosition_controlInstanceAttributePid_controller_settings_x(self._context)
        self.ramp_count = RootLuPosition_controlInstanceAttributeRamp_count(self._context)
        self.axis_scale_zlv = RootLuPosition_controlInstanceAttributeAxis_scale_zlv(self._context)
        self.current_pos_x = RootLuPosition_controlInstanceAttributeCurrent_pos_x(self._context)
        self.axis_scale_xy = RootLuPosition_controlInstanceAttributeAxis_scale_xy(self._context)
        self.axis_scale_xylv = RootLuPosition_controlInstanceAttributeAxis_scale_xylv(self._context)
        self.current_pos_y = RootLuPosition_controlInstanceAttributeCurrent_pos_y(self._context)
        self.enable_xy_closed_loop = RootLuPosition_controlInstanceAttributeEnable_xy_closed_loop(self._context)
        self.target_moving_speed = RootLuPosition_controlInstanceAttributeTarget_moving_speed(self._context)
        self.xy_closed_loop_speed_moving = RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_moving(self._context)
        self.xy_closed_loop_speed_mode = RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_mode(self._context)
        self.xy_closed_loop_speed_keep_pos = RootLuPosition_controlInstanceAttributeXy_closed_loop_speed_keep_pos(self._context)
        self.target_scan_axis_range_select = RootLuPosition_controlInstanceAttributeTarget_scan_axis_range_select(self._context)
        self.is_xy_closed_loop_possible = RootLuPosition_controlInstanceAttributeIs_xy_closed_loop_possible(self._context)
        self.axis_scale_z = RootLuPosition_controlInstanceAttributeAxis_scale_z(self._context)
        self.target_move_pos_x = RootLuPosition_controlInstanceAttributeTarget_move_pos_x(self._context)
        self.target_moving_time = RootLuPosition_controlInstanceAttributeTarget_moving_time(self._context)
        self.target_move_pos_z = RootLuPosition_controlInstanceAttributeTarget_move_pos_z(self._context)
        self.target_move_pos_y = RootLuPosition_controlInstanceAttributeTarget_move_pos_y(self._context)
        self.scan_correction_x_rotation = RootLuPosition_controlInstanceAttributeScan_correction_x_rotation(self._context)
        self.current_pos_z = RootLuPosition_controlInstanceAttributeCurrent_pos_z(self._context)
        self.pid_controller_settings_y = RootLuPosition_controlInstanceAttributePid_controller_settings_y(self._context)
        self.last_move_stop_event = RootLuPosition_controlInstanceAttributeLast_move_stop_event(self._context)
        self.ramp_time = RootLuPosition_controlInstanceAttributeRamp_time(self._context)
        self.current_scan_axis_range_select = RootLuPosition_controlInstanceAttributeCurrent_scan_axis_range_select(self._context)


class RootLuPosition_controlInstanceBusyIs_busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.busy.is_busy'


class RootLuPosition_controlInstanceBusyIs_range_switching(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.busy.is_range_switching'


class RootLuPosition_controlInstanceBusyIs_calibrating(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.busy.is_calibrating'


class RootLuPosition_controlInstanceBusyIs_tip_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.busy.is_tip_moving'


class RootLuPosition_controlInstanceBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance.busy'
        self.is_tip_moving = RootLuPosition_controlInstanceBusyIs_tip_moving(self._context)
        self.is_calibrating = RootLuPosition_controlInstanceBusyIs_calibrating(self._context)
        self.is_range_switching = RootLuPosition_controlInstanceBusyIs_range_switching(self._context)
        self.is_busy = RootLuPosition_controlInstanceBusyIs_busy(self._context)


class RootLuPosition_controlInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control.instance'
        self.busy = RootLuPosition_controlInstanceBusy(self._context)
        self.attribute = RootLuPosition_controlInstanceAttribute(self._context)
        self.trigger = RootLuPosition_controlInstanceTrigger(self._context)


class RootLuPosition_control(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.position_control'
        self.instance = RootLuPosition_controlInstance(self._context)


class RootLuSpecInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger.user_abort'


class RootLuSpecInstanceTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger.start'


class RootLuSpecInstanceTriggerResume_last_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger.resume_last_point'


class RootLuSpecInstanceTriggerPause(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger.pause'


class RootLuSpecInstanceTriggerResume_next_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger.resume_next_point'


class RootLuSpecInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.trigger'
        self.resume_next_point = RootLuSpecInstanceTriggerResume_next_point(self._context)
        self.pause = RootLuSpecInstanceTriggerPause(self._context)
        self.resume_last_point = RootLuSpecInstanceTriggerResume_last_point(self._context)
        self.start = RootLuSpecInstanceTriggerStart(self._context)
        self.user_abort = RootLuSpecInstanceTriggerUser_abort(self._context)


class RootLuSpecInstanceAttributeFwd_pause_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_mode.enum'

    @property
    def z_on(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_pause_mode.enum.z_on'))

    @z_on.setter
    def z_on(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_mode.enum.z_on', int(new_val))

    @property
    def z_off(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_pause_mode.enum.z_off'))

    @z_off.setter
    def z_off(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_pause_mode.enum.z_off', int(new_val))


class RootLuSpecInstanceAttributeFwd_pause_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_mode'
        self.enum = RootLuSpecInstanceAttributeFwd_pause_modeEnum(self._context)


class RootLuSpecInstanceAttributeSpec_end_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_end_mode.enum'

    @property
    def z_controller_active(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.spec_end_mode.enum.z_controller_active'))

    @z_controller_active.setter
    def z_controller_active(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.spec_end_mode.enum.z_controller_active', int(new_val))

    @property
    def keep_last_z_pos(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.spec_end_mode.enum.keep_last_z_pos'))

    @keep_last_z_pos.setter
    def keep_last_z_pos(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.spec_end_mode.enum.keep_last_z_pos', int(new_val))


class RootLuSpecInstanceAttributeSpec_end_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_end_mode'
        self.enum = RootLuSpecInstanceAttributeSpec_end_modeEnum(self._context)


class RootLuSpecInstanceAttributePhase_bwd_mod_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_bwd_mod_rate'


class RootLuSpecInstanceAttributePhase_bwd_pause_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_bwd_pause_rate'


class RootLuSpecInstanceAttributePhase_data_group_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_data_group_id'


class RootLuSpecInstanceAttributePhase_sample_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_sample_mask'


class RootLuSpecInstanceAttributePoint_coords_blob_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.point_coords_blob_vec'


class RootLuSpecInstanceAttributeRepetition_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.repetition_mode.enum'

    @property
    def position(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.repetition_mode.enum.position'))

    @position.setter
    def position(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.repetition_mode.enum.position', int(new_val))

    @property
    def list(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.repetition_mode.enum.list'))

    @list.setter
    def list(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.repetition_mode.enum.list', int(new_val))


class RootLuSpecInstanceAttributeRepetition_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.repetition_mode'
        self.enum = RootLuSpecInstanceAttributeRepetition_modeEnum(self._context)


class RootLuSpecInstanceAttributeMod_rel_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.mod_rel_value'


class RootLuSpecInstanceAttributeSpec_map_configuration_blob_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_map_configuration_blob_vec'


class RootLuSpecInstanceAttributeBwd_pause_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_mode.enum'

    @property
    def z_on(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_pause_mode.enum.z_on'))

    @z_on.setter
    def z_on(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_mode.enum.z_on', int(new_val))

    @property
    def z_off(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_pause_mode.enum.z_off'))

    @z_off.setter
    def z_off(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_pause_mode.enum.z_off', int(new_val))


class RootLuSpecInstanceAttributeBwd_pause_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_mode'
        self.enum = RootLuSpecInstanceAttributeBwd_pause_modeEnum(self._context)


class RootLuSpecInstanceAttributeBwd_mod_range(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_range'


class RootLuSpecInstanceAttributeStart_offset_move_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.start_offset_move_speed'


class RootLuSpecInstanceAttributeSpec_map_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.spec_map_mode'


class RootLuSpecInstanceAttributeXy_move_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.xy_move_speed'


class RootLuSpecInstanceAttributeFwd_mod_range(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_range'


class RootLuSpecInstanceAttributeModulation_outputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.modulation_output.enum'

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.modulation_output.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.modulation_output.enum.position_z', int(new_val))

    @property
    def external_z(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.modulation_output.enum.external_z'))

    @external_z.setter
    def external_z(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.modulation_output.enum.external_z', int(new_val))

    @property
    def tip_voltage(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.modulation_output.enum.tip_voltage'))

    @tip_voltage.setter
    def tip_voltage(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.modulation_output.enum.tip_voltage', int(new_val))


class RootLuSpecInstanceAttributeModulation_output(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.modulation_output'
        self.enum = RootLuSpecInstanceAttributeModulation_outputEnum(self._context)


class RootLuSpecInstanceAttributeFwd_mod_stop_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_stop_mode.enum'

    @property
    def is_less_than(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_mod_stop_mode.enum.is_less_than'))

    @is_less_than.setter
    def is_less_than(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_stop_mode.enum.is_less_than', int(new_val))

    @property
    def is_greater_than(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_mod_stop_mode.enum.is_greater_than'))

    @is_greater_than.setter
    def is_greater_than(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_stop_mode.enum.is_greater_than', int(new_val))


class RootLuSpecInstanceAttributeFwd_mod_stop_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_stop_mode'
        self.enum = RootLuSpecInstanceAttributeFwd_mod_stop_modeEnum(self._context)


class RootLuSpecInstanceAttributeBwd_pause_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_datapoints'


class RootLuSpecInstanceAttributeAuto_recalibrate_probe_interval(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.auto_recalibrate_probe_interval'


class RootLuSpecInstanceAttributeBwd_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_datapoints'


class RootLuSpecInstanceAttributeRepetition_count(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.repetition_count'


class RootLuSpecInstanceAttributeDeflection_force_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.deflection_force_offset'


class RootLuSpecInstanceAttributeBwd_mod_stop_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_stop_mode.enum'

    @property
    def is_less_than(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_mod_stop_mode.enum.is_less_than'))

    @is_less_than.setter
    def is_less_than(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_stop_mode.enum.is_less_than', int(new_val))

    @property
    def is_greater_than(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_mod_stop_mode.enum.is_greater_than'))

    @is_greater_than.setter
    def is_greater_than(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_stop_mode.enum.is_greater_than', int(new_val))


class RootLuSpecInstanceAttributeBwd_mod_stop_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_stop_mode'
        self.enum = RootLuSpecInstanceAttributeBwd_mod_stop_modeEnum(self._context)


class RootLuSpecInstanceAttributeBwd_pause_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_pause_time'


class RootLuSpecInstanceAttributeBwd_mod_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_mode.enum'

    @property
    def fixed_length(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_mod_mode.enum.fixed_length'))

    @fixed_length.setter
    def fixed_length(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_mode.enum.fixed_length', int(new_val))

    @property
    def stop_by_value(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.bwd_mod_mode.enum.stop_by_value'))

    @stop_by_value.setter
    def stop_by_value(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.bwd_mod_mode.enum.stop_by_value', int(new_val))


class RootLuSpecInstanceAttributeBwd_mod_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_mode'
        self.enum = RootLuSpecInstanceAttributeBwd_mod_modeEnum(self._context)


class RootLuSpecInstanceAttributeFwd_mod_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_mode.enum'

    @property
    def fixed_length(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_mod_mode.enum.fixed_length'))

    @fixed_length.setter
    def fixed_length(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_mode.enum.fixed_length', int(new_val))

    @property
    def stop_by_value(self) -> int:
        return int(self._context.get('root.lu.spec.instance.attribute.fwd_mod_mode.enum.stop_by_value'))

    @stop_by_value.setter
    def stop_by_value(self, new_val:int):
        self._context.set('root.lu.spec.instance.attribute.fwd_mod_mode.enum.stop_by_value', int(new_val))


class RootLuSpecInstanceAttributeFwd_mod_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_mode'
        self.enum = RootLuSpecInstanceAttributeFwd_mod_modeEnum(self._context)


class RootLuSpecInstanceAttributeFeedback_active(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.feedback_active'


class RootLuSpecInstanceAttributeFwd_pause_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_datapoints'


class RootLuSpecInstanceAttributeStart_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.start_offset'


class RootLuSpecInstanceAttributeFwd_datapoints(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_datapoints'


class RootLuSpecInstanceAttributePhase_fwd_pause_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_fwd_pause_rate'


class RootLuSpecInstanceAttributePhase_fwd_mod_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.phase_fwd_mod_rate'


class RootLuSpecInstanceAttributeCurrent_repetition(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.current_repetition'


class RootLuSpecInstanceAttributeBwd_mod_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_time'


class RootLuSpecInstanceAttributeFwd_move_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_move_speed'


class RootLuSpecInstanceAttributeFwd_mod_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_time'


class RootLuSpecInstanceAttributeFwd_mod_stop_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_mod_stop_value'


class RootLuSpecInstanceAttributeBwd_move_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_move_speed'


class RootLuSpecInstanceAttributeFwd_pause_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.fwd_pause_time'


class RootLuSpecInstanceAttributeBwd_mod_stop_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute.bwd_mod_stop_value'


class RootLuSpecInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance.attribute'
        self.bwd_mod_stop_value = RootLuSpecInstanceAttributeBwd_mod_stop_value(self._context)
        self.fwd_pause_time = RootLuSpecInstanceAttributeFwd_pause_time(self._context)
        self.bwd_move_speed = RootLuSpecInstanceAttributeBwd_move_speed(self._context)
        self.fwd_mod_stop_value = RootLuSpecInstanceAttributeFwd_mod_stop_value(self._context)
        self.fwd_mod_time = RootLuSpecInstanceAttributeFwd_mod_time(self._context)
        self.fwd_move_speed = RootLuSpecInstanceAttributeFwd_move_speed(self._context)
        self.bwd_mod_time = RootLuSpecInstanceAttributeBwd_mod_time(self._context)
        self.current_repetition = RootLuSpecInstanceAttributeCurrent_repetition(self._context)
        self.phase_fwd_mod_rate = RootLuSpecInstanceAttributePhase_fwd_mod_rate(self._context)
        self.phase_fwd_pause_rate = RootLuSpecInstanceAttributePhase_fwd_pause_rate(self._context)
        self.fwd_datapoints = RootLuSpecInstanceAttributeFwd_datapoints(self._context)
        self.start_offset = RootLuSpecInstanceAttributeStart_offset(self._context)
        self.fwd_pause_datapoints = RootLuSpecInstanceAttributeFwd_pause_datapoints(self._context)
        self.feedback_active = RootLuSpecInstanceAttributeFeedback_active(self._context)
        self.fwd_mod_mode = RootLuSpecInstanceAttributeFwd_mod_mode(self._context)
        self.bwd_mod_mode = RootLuSpecInstanceAttributeBwd_mod_mode(self._context)
        self.bwd_pause_time = RootLuSpecInstanceAttributeBwd_pause_time(self._context)
        self.bwd_mod_stop_mode = RootLuSpecInstanceAttributeBwd_mod_stop_mode(self._context)
        self.deflection_force_offset = RootLuSpecInstanceAttributeDeflection_force_offset(self._context)
        self.repetition_count = RootLuSpecInstanceAttributeRepetition_count(self._context)
        self.bwd_datapoints = RootLuSpecInstanceAttributeBwd_datapoints(self._context)
        self.auto_recalibrate_probe_interval = RootLuSpecInstanceAttributeAuto_recalibrate_probe_interval(self._context)
        self.bwd_pause_datapoints = RootLuSpecInstanceAttributeBwd_pause_datapoints(self._context)
        self.fwd_mod_stop_mode = RootLuSpecInstanceAttributeFwd_mod_stop_mode(self._context)
        self.modulation_output = RootLuSpecInstanceAttributeModulation_output(self._context)
        self.fwd_mod_range = RootLuSpecInstanceAttributeFwd_mod_range(self._context)
        self.xy_move_speed = RootLuSpecInstanceAttributeXy_move_speed(self._context)
        self.spec_map_mode = RootLuSpecInstanceAttributeSpec_map_mode(self._context)
        self.start_offset_move_speed = RootLuSpecInstanceAttributeStart_offset_move_speed(self._context)
        self.bwd_mod_range = RootLuSpecInstanceAttributeBwd_mod_range(self._context)
        self.bwd_pause_mode = RootLuSpecInstanceAttributeBwd_pause_mode(self._context)
        self.spec_map_configuration_blob_vec = RootLuSpecInstanceAttributeSpec_map_configuration_blob_vec(self._context)
        self.mod_rel_value = RootLuSpecInstanceAttributeMod_rel_value(self._context)
        self.repetition_mode = RootLuSpecInstanceAttributeRepetition_mode(self._context)
        self.point_coords_blob_vec = RootLuSpecInstanceAttributePoint_coords_blob_vec(self._context)
        self.phase_sample_mask = RootLuSpecInstanceAttributePhase_sample_mask(self._context)
        self.phase_data_group_id = RootLuSpecInstanceAttributePhase_data_group_id(self._context)
        self.phase_bwd_pause_rate = RootLuSpecInstanceAttributePhase_bwd_pause_rate(self._context)
        self.phase_bwd_mod_rate = RootLuSpecInstanceAttributePhase_bwd_mod_rate(self._context)
        self.spec_end_mode = RootLuSpecInstanceAttributeSpec_end_mode(self._context)
        self.fwd_pause_mode = RootLuSpecInstanceAttributeFwd_pause_mode(self._context)


class RootLuSpecInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec.instance'
        self.attribute = RootLuSpecInstanceAttribute(self._context)
        self.trigger = RootLuSpecInstanceTrigger(self._context)


class RootLuSpec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.spec'
        self.instance = RootLuSpecInstance(self._context)


class RootLuTimerDbg1TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.trigger.stop'


class RootLuTimerDbg1TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.trigger.abort'


class RootLuTimerDbg1TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.trigger.start'


class RootLuTimerDbg1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.trigger'
        self.start = RootLuTimerDbg1TriggerStart(self._context)
        self.abort = RootLuTimerDbg1TriggerAbort(self._context)
        self.stop = RootLuTimerDbg1TriggerStop(self._context)


class RootLuTimerDbg1AttributeCurrent_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.current_time'


class RootLuTimerDbg1AttributeDelay_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.delay_time'


class RootLuTimerDbg1AttributeCounter_max(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.counter_max'


class RootLuTimerDbg1AttributeCounter_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.counter_value'


class RootLuTimerDbg1AttributeModeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.mode.enum'

    @property
    def event_counter(self) -> int:
        return int(self._context.get('root.lu.timer.dbg1.attribute.mode.enum.event_counter'))

    @event_counter.setter
    def event_counter(self, new_val:int):
        self._context.set('root.lu.timer.dbg1.attribute.mode.enum.event_counter', int(new_val))

    @property
    def delay_timer(self) -> int:
        return int(self._context.get('root.lu.timer.dbg1.attribute.mode.enum.delay_timer'))

    @delay_timer.setter
    def delay_timer(self, new_val:int):
        self._context.set('root.lu.timer.dbg1.attribute.mode.enum.delay_timer', int(new_val))


class RootLuTimerDbg1AttributeMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.mode'
        self.enum = RootLuTimerDbg1AttributeModeEnum(self._context)


class RootLuTimerDbg1AttributeCounter_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.counter_input.enum'

    @property
    def digital_sync1(self) -> int:
        return int(self._context.get('root.lu.timer.dbg1.attribute.counter_input.enum.digital_sync1'))

    @digital_sync1.setter
    def digital_sync1(self, new_val:int):
        self._context.set('root.lu.timer.dbg1.attribute.counter_input.enum.digital_sync1', int(new_val))

    @property
    def digital_sync2(self) -> int:
        return int(self._context.get('root.lu.timer.dbg1.attribute.counter_input.enum.digital_sync2'))

    @digital_sync2.setter
    def digital_sync2(self, new_val:int):
        self._context.set('root.lu.timer.dbg1.attribute.counter_input.enum.digital_sync2', int(new_val))


class RootLuTimerDbg1AttributeCounter_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute.counter_input'
        self.enum = RootLuTimerDbg1AttributeCounter_inputEnum(self._context)


class RootLuTimerDbg1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.attribute'
        self.counter_input = RootLuTimerDbg1AttributeCounter_input(self._context)
        self.mode = RootLuTimerDbg1AttributeMode(self._context)
        self.counter_value = RootLuTimerDbg1AttributeCounter_value(self._context)
        self.counter_max = RootLuTimerDbg1AttributeCounter_max(self._context)
        self.delay_time = RootLuTimerDbg1AttributeDelay_time(self._context)
        self.current_time = RootLuTimerDbg1AttributeCurrent_time(self._context)


class RootLuTimerDbg1BusyIs_busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.busy.is_busy'


class RootLuTimerDbg1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1.busy'
        self.is_busy = RootLuTimerDbg1BusyIs_busy(self._context)


class RootLuTimerDbg1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.dbg1'
        self.busy = RootLuTimerDbg1Busy(self._context)
        self.attribute = RootLuTimerDbg1Attribute(self._context)
        self.trigger = RootLuTimerDbg1Trigger(self._context)


class RootLuTimerProc0TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.trigger.stop'


class RootLuTimerProc0TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.trigger.abort'


class RootLuTimerProc0TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.trigger.start'


class RootLuTimerProc0Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.trigger'
        self.start = RootLuTimerProc0TriggerStart(self._context)
        self.abort = RootLuTimerProc0TriggerAbort(self._context)
        self.stop = RootLuTimerProc0TriggerStop(self._context)


class RootLuTimerProc0AttributeCurrent_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.current_time'


class RootLuTimerProc0AttributeDelay_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.delay_time'


class RootLuTimerProc0AttributeCounter_max(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.counter_max'


class RootLuTimerProc0AttributeCounter_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.counter_value'


class RootLuTimerProc0AttributeModeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.mode.enum'

    @property
    def event_counter(self) -> int:
        return int(self._context.get('root.lu.timer.proc0.attribute.mode.enum.event_counter'))

    @event_counter.setter
    def event_counter(self, new_val:int):
        self._context.set('root.lu.timer.proc0.attribute.mode.enum.event_counter', int(new_val))

    @property
    def delay_timer(self) -> int:
        return int(self._context.get('root.lu.timer.proc0.attribute.mode.enum.delay_timer'))

    @delay_timer.setter
    def delay_timer(self, new_val:int):
        self._context.set('root.lu.timer.proc0.attribute.mode.enum.delay_timer', int(new_val))


class RootLuTimerProc0AttributeMode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.mode'
        self.enum = RootLuTimerProc0AttributeModeEnum(self._context)


class RootLuTimerProc0AttributeCounter_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.counter_input.enum'

    @property
    def digital_sync1(self) -> int:
        return int(self._context.get('root.lu.timer.proc0.attribute.counter_input.enum.digital_sync1'))

    @digital_sync1.setter
    def digital_sync1(self, new_val:int):
        self._context.set('root.lu.timer.proc0.attribute.counter_input.enum.digital_sync1', int(new_val))

    @property
    def digital_sync2(self) -> int:
        return int(self._context.get('root.lu.timer.proc0.attribute.counter_input.enum.digital_sync2'))

    @digital_sync2.setter
    def digital_sync2(self, new_val:int):
        self._context.set('root.lu.timer.proc0.attribute.counter_input.enum.digital_sync2', int(new_val))


class RootLuTimerProc0AttributeCounter_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute.counter_input'
        self.enum = RootLuTimerProc0AttributeCounter_inputEnum(self._context)


class RootLuTimerProc0Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.attribute'
        self.counter_input = RootLuTimerProc0AttributeCounter_input(self._context)
        self.mode = RootLuTimerProc0AttributeMode(self._context)
        self.counter_value = RootLuTimerProc0AttributeCounter_value(self._context)
        self.counter_max = RootLuTimerProc0AttributeCounter_max(self._context)
        self.delay_time = RootLuTimerProc0AttributeDelay_time(self._context)
        self.current_time = RootLuTimerProc0AttributeCurrent_time(self._context)


class RootLuTimerProc0BusyIs_busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.busy.is_busy'


class RootLuTimerProc0Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0.busy'
        self.is_busy = RootLuTimerProc0BusyIs_busy(self._context)


class RootLuTimerProc0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer.proc0'
        self.busy = RootLuTimerProc0Busy(self._context)
        self.attribute = RootLuTimerProc0Attribute(self._context)
        self.trigger = RootLuTimerProc0Trigger(self._context)


class RootLuTimer(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.timer'
        self.proc0 = RootLuTimerProc0(self._context)
        self.dbg1 = RootLuTimerDbg1(self._context)


class RootLuZ_controller_exInstanceTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.trigger.stop'


class RootLuZ_controller_exInstanceTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.trigger.abort'


class RootLuZ_controller_exInstanceTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.trigger.start'


class RootLuZ_controller_exInstanceTriggerStart_simple(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.trigger.start_simple'


class RootLuZ_controller_exInstanceTriggerInit_phase_move(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.trigger.init_phase_move'


class RootLuZ_controller_exInstanceTriggerUpdate_base_line_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.trigger.update_base_line_pos'


class RootLuZ_controller_exInstanceTriggerSwitch_to_target_output_channel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.trigger.switch_to_target_output_channel'


class RootLuZ_controller_exInstanceTriggerWait_for_z_controller_adjust(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.trigger.wait_for_z_controller_adjust'


class RootLuZ_controller_exInstanceTriggerApply_max_z_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.trigger.apply_max_z_value'


class RootLuZ_controller_exInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.trigger'
        self.apply_max_z_value = RootLuZ_controller_exInstanceTriggerApply_max_z_value(self._context)
        self.wait_for_z_controller_adjust = RootLuZ_controller_exInstanceTriggerWait_for_z_controller_adjust(self._context)
        self.switch_to_target_output_channel = RootLuZ_controller_exInstanceTriggerSwitch_to_target_output_channel(self._context)
        self.update_base_line_pos = RootLuZ_controller_exInstanceTriggerUpdate_base_line_pos(self._context)
        self.init_phase_move = RootLuZ_controller_exInstanceTriggerInit_phase_move(self._context)
        self.start_simple = RootLuZ_controller_exInstanceTriggerStart_simple(self._context)
        self.start = RootLuZ_controller_exInstanceTriggerStart(self._context)
        self.abort = RootLuZ_controller_exInstanceTriggerAbort(self._context)
        self.stop = RootLuZ_controller_exInstanceTriggerStop(self._context)


class RootLuZ_controller_exInstanceAttributeCtrl_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.ctrl_input.enum'

    @property
    def ctrl_user1_out(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_user1_out'))

    @ctrl_user1_out.setter
    def ctrl_user1_out(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_user1_out', int(new_val))

    @property
    def analyzer1_amplitude(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_amplitude'))

    @analyzer1_amplitude.setter
    def analyzer1_amplitude(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_amplitude', int(new_val))

    @property
    def analyzer1_x(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_x'))

    @analyzer1_x.setter
    def analyzer1_x(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_x', int(new_val))

    @property
    def in6(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in6'))

    @in6.setter
    def in6(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in6', int(new_val))

    @property
    def ctrl_w_out(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_w_out'))

    @ctrl_w_out.setter
    def ctrl_w_out(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_w_out', int(new_val))

    @property
    def ctrl_z_in(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_z_in'))

    @ctrl_z_in.setter
    def ctrl_z_in(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_z_in', int(new_val))

    @property
    def in_position_z(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_position_z'))

    @in_position_z.setter
    def in_position_z(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_position_z', int(new_val))

    @property
    def ctrl_z_sum(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_z_sum'))

    @ctrl_z_sum.setter
    def ctrl_z_sum(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_z_sum', int(new_val))

    @property
    def analyzer2_x(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_x'))

    @analyzer2_x.setter
    def analyzer2_x(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_x', int(new_val))

    @property
    def analyzer1_reference(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_reference'))

    @analyzer1_reference.setter
    def analyzer1_reference(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_reference', int(new_val))

    @property
    def in_deflection(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_deflection'))

    @in_deflection.setter
    def in_deflection(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_deflection', int(new_val))

    @property
    def analyzer1_y(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_y'))

    @analyzer1_y.setter
    def analyzer1_y(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_y', int(new_val))

    @property
    def memory_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_position_x'))

    @memory_gen_position_x.setter
    def memory_gen_position_x(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_position_x', int(new_val))

    @property
    def ort_free_wave(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_free_wave'))

    @ort_free_wave.setter
    def ort_free_wave(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_free_wave', int(new_val))

    @property
    def in_user1(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_user1'))

    @in_user1.setter
    def in_user1(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_user1', int(new_val))

    @property
    def ctrl_z_pid_command(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_z_pid_command'))

    @ctrl_z_pid_command.setter
    def ctrl_z_pid_command(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_z_pid_command', int(new_val))

    @property
    def ctrl_x_out(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_x_out'))

    @ctrl_x_out.setter
    def ctrl_x_out(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_x_out', int(new_val))

    @property
    def ctrl_user2_out(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_user2_out'))

    @ctrl_user2_out.setter
    def ctrl_user2_out(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_user2_out', int(new_val))

    @property
    def fast_in_deflection(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.fast_in_deflection'))

    @fast_in_deflection.setter
    def fast_in_deflection(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.fast_in_deflection', int(new_val))

    @property
    def analyzer2_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_ctrl_delta_f'))

    @analyzer2_ctrl_delta_f.setter
    def analyzer2_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_ctrl_delta_f', int(new_val))

    @property
    def in_user2(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_user2'))

    @in_user2.setter
    def in_user2(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_user2', int(new_val))

    @property
    def ramp_gen_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_tip_voltage'))

    @ramp_gen_tip_voltage.setter
    def ramp_gen_tip_voltage(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_tip_voltage', int(new_val))

    @property
    def in_lateral(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_lateral'))

    @in_lateral.setter
    def in_lateral(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_lateral', int(new_val))

    @property
    def ramp_gen_user4(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_user4'))

    @ramp_gen_user4.setter
    def ramp_gen_user4(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_user4', int(new_val))

    @property
    def memory_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_position_y'))

    @memory_gen_position_y.setter
    def memory_gen_position_y(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_position_y', int(new_val))

    @property
    def memory_gen_position_z(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_position_z'))

    @memory_gen_position_z.setter
    def memory_gen_position_z(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_position_z', int(new_val))

    @property
    def ctrl_z_nominal(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_z_nominal'))

    @ctrl_z_nominal.setter
    def ctrl_z_nominal(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_z_nominal', int(new_val))

    @property
    def ort_adhesion_position(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_adhesion_position'))

    @ort_adhesion_position.setter
    def ort_adhesion_position(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_adhesion_position', int(new_val))

    @property
    def ort_baseline_corrected(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_baseline_corrected'))

    @ort_baseline_corrected.setter
    def ort_baseline_corrected(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_baseline_corrected', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_user3', int(new_val))

    @property
    def analyzer2_amplitude(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_amplitude'))

    @analyzer2_amplitude.setter
    def analyzer2_amplitude(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_amplitude', int(new_val))

    @property
    def analyzer1_phase(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_phase'))

    @analyzer1_phase.setter
    def analyzer1_phase(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_phase', int(new_val))

    @property
    def ctrl_z_error(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_z_error'))

    @ctrl_z_error.setter
    def ctrl_z_error(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_z_error', int(new_val))

    @property
    def ort_amplitude_reduction(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_amplitude_reduction'))

    @ort_amplitude_reduction.setter
    def ort_amplitude_reduction(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_amplitude_reduction', int(new_val))

    @property
    def ramp_gen_test(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_test'))

    @ramp_gen_test.setter
    def ramp_gen_test(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_test', int(new_val))

    @property
    def analyzer1_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_ctrl_amplitude'))

    @analyzer1_ctrl_amplitude.setter
    def analyzer1_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_ctrl_amplitude', int(new_val))

    @property
    def ramp_gen_alternate_z(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_alternate_z'))

    @ramp_gen_alternate_z.setter
    def ramp_gen_alternate_z(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_alternate_z', int(new_val))

    @property
    def static(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.static'))

    @static.setter
    def static(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.static', int(new_val))

    @property
    def ramp_gen_position_y(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_position_y'))

    @ramp_gen_position_y.setter
    def ramp_gen_position_y(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_position_y', int(new_val))

    @property
    def ctrl_y_out(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_y_out'))

    @ctrl_y_out.setter
    def ctrl_y_out(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_y_out', int(new_val))

    @property
    def in_position_x(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_position_x'))

    @in_position_x.setter
    def in_position_x(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_position_x', int(new_val))

    @property
    def analyzer2_ctrl_amplitude(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_ctrl_amplitude'))

    @analyzer2_ctrl_amplitude.setter
    def analyzer2_ctrl_amplitude(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_ctrl_amplitude', int(new_val))

    @property
    def gen_test_dynamic(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.gen_test_dynamic'))

    @gen_test_dynamic.setter
    def gen_test_dynamic(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.gen_test_dynamic', int(new_val))

    @property
    def ramp_gen_plane_z(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_plane_z'))

    @ramp_gen_plane_z.setter
    def ramp_gen_plane_z(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_plane_z', int(new_val))

    @property
    def ramp_gen_max_z(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_max_z'))

    @ramp_gen_max_z.setter
    def ramp_gen_max_z(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_max_z', int(new_val))

    @property
    def fast_in2(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.fast_in2'))

    @fast_in2.setter
    def fast_in2(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.fast_in2', int(new_val))

    @property
    def ramp_gen_ctrl_z(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_ctrl_z'))

    @ramp_gen_ctrl_z.setter
    def ramp_gen_ctrl_z(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_ctrl_z', int(new_val))

    @property
    def analyzer2_phase(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_phase'))

    @analyzer2_phase.setter
    def analyzer2_phase(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_phase', int(new_val))

    @property
    def ort_excitation(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_excitation'))

    @ort_excitation.setter
    def ort_excitation(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_excitation', int(new_val))

    @property
    def ramp_gen_approach(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_approach'))

    @ramp_gen_approach.setter
    def ramp_gen_approach(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_approach', int(new_val))

    @property
    def ort_baseline(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_baseline'))

    @ort_baseline.setter
    def ort_baseline(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_baseline', int(new_val))

    @property
    def in_user4(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_user4'))

    @in_user4.setter
    def in_user4(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_user4', int(new_val))

    @property
    def memory_gen_drive_x(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_drive_x'))

    @memory_gen_drive_x.setter
    def memory_gen_drive_x(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_drive_x', int(new_val))

    @property
    def memory_gen_out8(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_out8'))

    @memory_gen_out8.setter
    def memory_gen_out8(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_out8', int(new_val))

    @property
    def ctrl_z_out(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_z_out'))

    @ctrl_z_out.setter
    def ctrl_z_out(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ctrl_z_out', int(new_val))

    @property
    def memory_gen_out7(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_out7'))

    @memory_gen_out7.setter
    def memory_gen_out7(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_out7', int(new_val))

    @property
    def memory_gen_drive_z(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_drive_z'))

    @memory_gen_drive_z.setter
    def memory_gen_drive_z(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_drive_z', int(new_val))

    @property
    def memory_gen_drive_y(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_drive_y'))

    @memory_gen_drive_y.setter
    def memory_gen_drive_y(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.memory_gen_drive_y', int(new_val))

    @property
    def ort_adhesion_value(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_adhesion_value'))

    @ort_adhesion_value.setter
    def ort_adhesion_value(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ort_adhesion_value', int(new_val))

    @property
    def in_detector_sum(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_detector_sum'))

    @in_detector_sum.setter
    def in_detector_sum(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_detector_sum', int(new_val))

    @property
    def in_tip_current(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_tip_current'))

    @in_tip_current.setter
    def in_tip_current(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_tip_current', int(new_val))

    @property
    def ramp_gen_position_x(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_position_x'))

    @ramp_gen_position_x.setter
    def ramp_gen_position_x(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.ramp_gen_position_x', int(new_val))

    @property
    def fast_in_user(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.fast_in_user'))

    @fast_in_user.setter
    def fast_in_user(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.fast_in_user', int(new_val))

    @property
    def in_position_y(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_position_y'))

    @in_position_y.setter
    def in_position_y(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.in_position_y', int(new_val))

    @property
    def analyzer2_reference(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_reference'))

    @analyzer2_reference.setter
    def analyzer2_reference(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_reference', int(new_val))

    @property
    def analyzer1_ctrl_delta_f(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_ctrl_delta_f'))

    @analyzer1_ctrl_delta_f.setter
    def analyzer1_ctrl_delta_f(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer1_ctrl_delta_f', int(new_val))

    @property
    def analyzer2_y(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_y'))

    @analyzer2_y.setter
    def analyzer2_y(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.ctrl_input.enum.analyzer2_y', int(new_val))


class RootLuZ_controller_exInstanceAttributeCtrl_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.ctrl_input'
        self.enum = RootLuZ_controller_exInstanceAttributeCtrl_inputEnum(self._context)


class RootLuZ_controller_exInstanceAttributeCurrent_input_filtered_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_input_filtered_value'


class RootLuZ_controller_exInstanceAttributeDdc_filter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.ddc_filter_number'


class RootLuZ_controller_exInstanceAttributeOutput_compare_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.output_compare_mode.enum'

    @property
    def equal_or_lower_than(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.output_compare_mode.enum.equal_or_lower_than'))

    @equal_or_lower_than.setter
    def equal_or_lower_than(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.output_compare_mode.enum.equal_or_lower_than', int(new_val))

    @property
    def equal_or_higher_than(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.output_compare_mode.enum.equal_or_higher_than'))

    @equal_or_higher_than.setter
    def equal_or_higher_than(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.output_compare_mode.enum.equal_or_higher_than', int(new_val))


class RootLuZ_controller_exInstanceAttributeOutput_compare_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.output_compare_mode'
        self.enum = RootLuZ_controller_exInstanceAttributeOutput_compare_modeEnum(self._context)


class RootLuZ_controller_exInstanceAttributeFeedback_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.feedback_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.feedback_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.feedback_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.feedback_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.feedback_polarity.enum.positive', int(new_val))


class RootLuZ_controller_exInstanceAttributeFeedback_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.feedback_polarity'
        self.enum = RootLuZ_controller_exInstanceAttributeFeedback_polarityEnum(self._context)


class RootLuZ_controller_exInstanceAttributeMax_z_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.max_z_value'


class RootLuZ_controller_exInstanceAttributePhase_move_speed_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_speed_vec'


class RootLuZ_controller_exInstanceAttributeDdc_filter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.ddc_filter_coeff_vec'


class RootLuZ_controller_exInstanceAttributeClosed_loop_p_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.closed_loop_p_gain'


class RootLuZ_controller_exInstanceAttributeMemory_signal_gen_drive_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.memory_signal_gen_drive_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.memory_signal_gen_drive_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.memory_signal_gen_drive_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.memory_signal_gen_drive_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.memory_signal_gen_drive_enable.enum.enabled', int(new_val))


class RootLuZ_controller_exInstanceAttributeMemory_signal_gen_drive_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.memory_signal_gen_drive_enable'
        self.enum = RootLuZ_controller_exInstanceAttributeMemory_signal_gen_drive_enableEnum(self._context)


class RootLuZ_controller_exInstanceAttributeOutput_compare_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.output_compare_value'


class RootLuZ_controller_exInstanceAttributeOutput_modulation_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.output_modulation_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.output_modulation_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.output_modulation_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.output_modulation_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.output_modulation_enable.enum.enabled', int(new_val))


class RootLuZ_controller_exInstanceAttributeOutput_modulation_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.output_modulation_enable'
        self.enum = RootLuZ_controller_exInstanceAttributeOutput_modulation_enableEnum(self._context)


class RootLuZ_controller_exInstanceAttributeCurrent_status_flags(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_status_flags'


class RootLuZ_controller_exInstanceAttributePhase_init_phase_count(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_init_phase_count'


class RootLuZ_controller_exInstanceAttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.filter_coeff_vec'


class RootLuZ_controller_exInstanceAttributePhase_move_end_mode_vecEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec.enum.move_relative', int(new_val))

    @property
    def pause(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec.enum.pause'))

    @pause.setter
    def pause(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec.enum.pause', int(new_val))


class RootLuZ_controller_exInstanceAttributePhase_move_end_mode_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_end_mode_vec'
        self.enum = RootLuZ_controller_exInstanceAttributePhase_move_end_mode_vecEnum(self._context)


class RootLuZ_controller_exInstanceAttributeCurrent_output_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_output_value'


class RootLuZ_controller_exInstanceAttributeCurrent_sum_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_sum_value'


class RootLuZ_controller_exInstanceAttributeMax_z_value_change_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.max_z_value_change_speed'


class RootLuZ_controller_exInstanceAttributePhase_work_mode_vecEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec.enum'

    @property
    def z_drive(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec.enum.z_drive'))

    @z_drive.setter
    def z_drive(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec.enum.z_drive', int(new_val))

    @property
    def z_feedback(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec.enum.z_feedback'))

    @z_feedback.setter
    def z_feedback(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec.enum.z_feedback', int(new_val))

    @property
    def z_closed_loop(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec.enum.z_closed_loop'))

    @z_closed_loop.setter
    def z_closed_loop(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec.enum.z_closed_loop', int(new_val))


class RootLuZ_controller_exInstanceAttributePhase_work_mode_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_work_mode_vec'
        self.enum = RootLuZ_controller_exInstanceAttributePhase_work_mode_vecEnum(self._context)


class RootLuZ_controller_exInstanceAttributeMin_z_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.min_z_value'


class RootLuZ_controller_exInstanceAttributePhase_real_end_pos_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_real_end_pos_vec'


class RootLuZ_controller_exInstanceAttributePhase_move_time_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_time_vec'


class RootLuZ_controller_exInstanceAttributeCurrent_error_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_error_value'


class RootLuZ_controller_exInstanceAttributePhase_move_value_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_value_vec'


class RootLuZ_controller_exInstanceAttributeTarget_output_channelEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.target_output_channel.enum'

    @property
    def out_position_z(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.target_output_channel.enum.out_position_z'))

    @out_position_z.setter
    def out_position_z(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.target_output_channel.enum.out_position_z', int(new_val))

    @property
    def out_external_z(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.target_output_channel.enum.out_external_z'))

    @out_external_z.setter
    def out_external_z(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.target_output_channel.enum.out_external_z', int(new_val))


class RootLuZ_controller_exInstanceAttributeTarget_output_channel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.target_output_channel'
        self.enum = RootLuZ_controller_exInstanceAttributeTarget_output_channelEnum(self._context)


class RootLuZ_controller_exInstanceAttributeCurrent_output_channel(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_output_channel'


class RootLuZ_controller_exInstanceAttributeSet_point_modulation_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.set_point_modulation_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.set_point_modulation_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.set_point_modulation_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.set_point_modulation_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.set_point_modulation_enable.enum.enabled', int(new_val))


class RootLuZ_controller_exInstanceAttributeSet_point_modulation_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.set_point_modulation_enable'
        self.enum = RootLuZ_controller_exInstanceAttributeSet_point_modulation_enableEnum(self._context)


class RootLuZ_controller_exInstanceAttributeProportional_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.proportional_gain'


class RootLuZ_controller_exInstanceAttributeZ_controller_adjust_timed_out(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.z_controller_adjust_timed_out'


class RootLuZ_controller_exInstanceAttributeInput_compare_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.input_compare_mode.enum'

    @property
    def equal_or_lower_than(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.input_compare_mode.enum.equal_or_lower_than'))

    @equal_or_lower_than.setter
    def equal_or_lower_than(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.input_compare_mode.enum.equal_or_lower_than', int(new_val))

    @property
    def equal_or_higher_than(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.input_compare_mode.enum.equal_or_higher_than'))

    @equal_or_higher_than.setter
    def equal_or_higher_than(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.input_compare_mode.enum.equal_or_higher_than', int(new_val))


class RootLuZ_controller_exInstanceAttributeInput_compare_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.input_compare_mode'
        self.enum = RootLuZ_controller_exInstanceAttributeInput_compare_modeEnum(self._context)


class RootLuZ_controller_exInstanceAttributeBase_work_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.base_work_mode.enum'

    @property
    def z_drive(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.base_work_mode.enum.z_drive'))

    @z_drive.setter
    def z_drive(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.base_work_mode.enum.z_drive', int(new_val))

    @property
    def z_feedback(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.base_work_mode.enum.z_feedback'))

    @z_feedback.setter
    def z_feedback(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.base_work_mode.enum.z_feedback', int(new_val))

    @property
    def z_closed_loop(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.base_work_mode.enum.z_closed_loop'))

    @z_closed_loop.setter
    def z_closed_loop(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.base_work_mode.enum.z_closed_loop', int(new_val))


class RootLuZ_controller_exInstanceAttributeBase_work_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.base_work_mode'
        self.enum = RootLuZ_controller_exInstanceAttributeBase_work_modeEnum(self._context)


class RootLuZ_controller_exInstanceAttributeMax_z_current_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.max_z_current_value'


class RootLuZ_controller_exInstanceAttributeClosed_loop_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.closed_loop_polarity'


class RootLuZ_controller_exInstanceAttributeClosed_loop_i_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.closed_loop_i_gain'


class RootLuZ_controller_exInstanceAttributeBase_line_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.base_line_pos'


class RootLuZ_controller_exInstanceAttributeIntegral_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.integral_gain'


class RootLuZ_controller_exInstanceAttributeMemory_signal_gen_position_enableEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.memory_signal_gen_position_enable.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.memory_signal_gen_position_enable.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.memory_signal_gen_position_enable.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.memory_signal_gen_position_enable.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.memory_signal_gen_position_enable.enum.enabled', int(new_val))


class RootLuZ_controller_exInstanceAttributeMemory_signal_gen_position_enable(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.memory_signal_gen_position_enable'
        self.enum = RootLuZ_controller_exInstanceAttributeMemory_signal_gen_position_enableEnum(self._context)


class RootLuZ_controller_exInstanceAttributeCurrent_feedback_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_feedback_status.enum'

    @property
    def in_range(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.current_feedback_status.enum.in_range'))

    @in_range.setter
    def in_range(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.current_feedback_status.enum.in_range', int(new_val))

    @property
    def max_extended(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.current_feedback_status.enum.max_extended'))

    @max_extended.setter
    def max_extended(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.current_feedback_status.enum.max_extended', int(new_val))

    @property
    def max_retracted(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.current_feedback_status.enum.max_retracted'))

    @max_retracted.setter
    def max_retracted(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.current_feedback_status.enum.max_retracted', int(new_val))


class RootLuZ_controller_exInstanceAttributeCurrent_feedback_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_feedback_status'
        self.enum = RootLuZ_controller_exInstanceAttributeCurrent_feedback_statusEnum(self._context)


class RootLuZ_controller_exInstanceAttributeClosed_loop_d_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.closed_loop_d_gain'


class RootLuZ_controller_exInstanceAttributeSet_point(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.set_point'


class RootLuZ_controller_exInstanceAttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_input_value'


class RootLuZ_controller_exInstanceAttributeDdc_filter_rate(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.ddc_filter_rate'


class RootLuZ_controller_exInstanceAttributeCurrent_pid_command_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_pid_command_value'


class RootLuZ_controller_exInstanceAttributePhase_count(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_count'


class RootLuZ_controller_exInstanceAttributeCurrent_phase(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_phase'


class RootLuZ_controller_exInstanceAttributeCurrent_limited_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.current_limited_value'


class RootLuZ_controller_exInstanceAttributeInput_compare_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.input_compare_value'


class RootLuZ_controller_exInstanceAttributeNumber_of_pid_gain_sets(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.number_of_pid_gain_sets'


class RootLuZ_controller_exInstanceAttributePhase_move_mode_vecEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_mode_vec.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.phase_move_mode_vec.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.phase_move_mode_vec.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.phase_move_mode_vec.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.phase_move_mode_vec.enum.fix_time', int(new_val))


class RootLuZ_controller_exInstanceAttributePhase_move_mode_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_mode_vec'
        self.enum = RootLuZ_controller_exInstanceAttributePhase_move_mode_vecEnum(self._context)


class RootLuZ_controller_exInstanceAttributeDifferential_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.differential_gain'


class RootLuZ_controller_exInstanceAttributeActive_pid_gain_setEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.active_pid_gain_set.enum'

    @property
    def user(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.active_pid_gain_set.enum.user'))

    @user.setter
    def user(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.active_pid_gain_set.enum.user', int(new_val))

    @property
    def out_position_z(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.active_pid_gain_set.enum.out_position_z'))

    @out_position_z.setter
    def out_position_z(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.active_pid_gain_set.enum.out_position_z', int(new_val))

    @property
    def out_external_z(self) -> int:
        return int(self._context.get('root.lu.z_controller_ex.instance.attribute.active_pid_gain_set.enum.out_external_z'))

    @out_external_z.setter
    def out_external_z(self, new_val:int):
        self._context.set('root.lu.z_controller_ex.instance.attribute.active_pid_gain_set.enum.out_external_z', int(new_val))


class RootLuZ_controller_exInstanceAttributeActive_pid_gain_set(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.active_pid_gain_set'
        self.enum = RootLuZ_controller_exInstanceAttributeActive_pid_gain_setEnum(self._context)


class RootLuZ_controller_exInstanceAttributePhase_pause_time_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_pause_time_vec'


class RootLuZ_controller_exInstanceAttributePhase_move_stop_by_value_active_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute.phase_move_stop_by_value_active_vec'


class RootLuZ_controller_exInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance.attribute'
        self.phase_move_stop_by_value_active_vec = RootLuZ_controller_exInstanceAttributePhase_move_stop_by_value_active_vec(self._context)
        self.phase_pause_time_vec = RootLuZ_controller_exInstanceAttributePhase_pause_time_vec(self._context)
        self.active_pid_gain_set = RootLuZ_controller_exInstanceAttributeActive_pid_gain_set(self._context)
        self.differential_gain = RootLuZ_controller_exInstanceAttributeDifferential_gain(self._context)
        self.phase_move_mode_vec = RootLuZ_controller_exInstanceAttributePhase_move_mode_vec(self._context)
        self.number_of_pid_gain_sets = RootLuZ_controller_exInstanceAttributeNumber_of_pid_gain_sets(self._context)
        self.input_compare_value = RootLuZ_controller_exInstanceAttributeInput_compare_value(self._context)
        self.current_limited_value = RootLuZ_controller_exInstanceAttributeCurrent_limited_value(self._context)
        self.current_phase = RootLuZ_controller_exInstanceAttributeCurrent_phase(self._context)
        self.phase_count = RootLuZ_controller_exInstanceAttributePhase_count(self._context)
        self.current_pid_command_value = RootLuZ_controller_exInstanceAttributeCurrent_pid_command_value(self._context)
        self.ddc_filter_rate = RootLuZ_controller_exInstanceAttributeDdc_filter_rate(self._context)
        self.current_input_value = RootLuZ_controller_exInstanceAttributeCurrent_input_value(self._context)
        self.set_point = RootLuZ_controller_exInstanceAttributeSet_point(self._context)
        self.closed_loop_d_gain = RootLuZ_controller_exInstanceAttributeClosed_loop_d_gain(self._context)
        self.current_feedback_status = RootLuZ_controller_exInstanceAttributeCurrent_feedback_status(self._context)
        self.memory_signal_gen_position_enable = RootLuZ_controller_exInstanceAttributeMemory_signal_gen_position_enable(self._context)
        self.integral_gain = RootLuZ_controller_exInstanceAttributeIntegral_gain(self._context)
        self.base_line_pos = RootLuZ_controller_exInstanceAttributeBase_line_pos(self._context)
        self.closed_loop_i_gain = RootLuZ_controller_exInstanceAttributeClosed_loop_i_gain(self._context)
        self.closed_loop_polarity = RootLuZ_controller_exInstanceAttributeClosed_loop_polarity(self._context)
        self.max_z_current_value = RootLuZ_controller_exInstanceAttributeMax_z_current_value(self._context)
        self.base_work_mode = RootLuZ_controller_exInstanceAttributeBase_work_mode(self._context)
        self.input_compare_mode = RootLuZ_controller_exInstanceAttributeInput_compare_mode(self._context)
        self.z_controller_adjust_timed_out = RootLuZ_controller_exInstanceAttributeZ_controller_adjust_timed_out(self._context)
        self.proportional_gain = RootLuZ_controller_exInstanceAttributeProportional_gain(self._context)
        self.set_point_modulation_enable = RootLuZ_controller_exInstanceAttributeSet_point_modulation_enable(self._context)
        self.current_output_channel = RootLuZ_controller_exInstanceAttributeCurrent_output_channel(self._context)
        self.target_output_channel = RootLuZ_controller_exInstanceAttributeTarget_output_channel(self._context)
        self.phase_move_value_vec = RootLuZ_controller_exInstanceAttributePhase_move_value_vec(self._context)
        self.current_error_value = RootLuZ_controller_exInstanceAttributeCurrent_error_value(self._context)
        self.phase_move_time_vec = RootLuZ_controller_exInstanceAttributePhase_move_time_vec(self._context)
        self.phase_real_end_pos_vec = RootLuZ_controller_exInstanceAttributePhase_real_end_pos_vec(self._context)
        self.min_z_value = RootLuZ_controller_exInstanceAttributeMin_z_value(self._context)
        self.phase_work_mode_vec = RootLuZ_controller_exInstanceAttributePhase_work_mode_vec(self._context)
        self.max_z_value_change_speed = RootLuZ_controller_exInstanceAttributeMax_z_value_change_speed(self._context)
        self.current_sum_value = RootLuZ_controller_exInstanceAttributeCurrent_sum_value(self._context)
        self.current_output_value = RootLuZ_controller_exInstanceAttributeCurrent_output_value(self._context)
        self.phase_move_end_mode_vec = RootLuZ_controller_exInstanceAttributePhase_move_end_mode_vec(self._context)
        self.filter_coeff_vec = RootLuZ_controller_exInstanceAttributeFilter_coeff_vec(self._context)
        self.phase_init_phase_count = RootLuZ_controller_exInstanceAttributePhase_init_phase_count(self._context)
        self.current_status_flags = RootLuZ_controller_exInstanceAttributeCurrent_status_flags(self._context)
        self.output_modulation_enable = RootLuZ_controller_exInstanceAttributeOutput_modulation_enable(self._context)
        self.output_compare_value = RootLuZ_controller_exInstanceAttributeOutput_compare_value(self._context)
        self.memory_signal_gen_drive_enable = RootLuZ_controller_exInstanceAttributeMemory_signal_gen_drive_enable(self._context)
        self.closed_loop_p_gain = RootLuZ_controller_exInstanceAttributeClosed_loop_p_gain(self._context)
        self.ddc_filter_coeff_vec = RootLuZ_controller_exInstanceAttributeDdc_filter_coeff_vec(self._context)
        self.phase_move_speed_vec = RootLuZ_controller_exInstanceAttributePhase_move_speed_vec(self._context)
        self.max_z_value = RootLuZ_controller_exInstanceAttributeMax_z_value(self._context)
        self.feedback_polarity = RootLuZ_controller_exInstanceAttributeFeedback_polarity(self._context)
        self.output_compare_mode = RootLuZ_controller_exInstanceAttributeOutput_compare_mode(self._context)
        self.ddc_filter_number = RootLuZ_controller_exInstanceAttributeDdc_filter_number(self._context)
        self.current_input_filtered_value = RootLuZ_controller_exInstanceAttributeCurrent_input_filtered_value(self._context)
        self.ctrl_input = RootLuZ_controller_exInstanceAttributeCtrl_input(self._context)


class RootLuZ_controller_exInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex.instance'
        self.attribute = RootLuZ_controller_exInstanceAttribute(self._context)
        self.trigger = RootLuZ_controller_exInstanceTrigger(self._context)


class RootLuZ_controller_ex(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.z_controller_ex'
        self.instance = RootLuZ_controller_exInstance(self._context)


class RootLuSystem_infraInstanceTriggerDetect_scan_head_arrival_removal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.trigger.detect_scan_head_arrival_removal'


class RootLuSystem_infraInstanceTriggerSwitch_clock_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.trigger.switch_clock_source'


class RootLuSystem_infraInstanceTriggerDetect_limit_switch_status_info_change(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.trigger.detect_limit_switch_status_info_change'


class RootLuSystem_infraInstanceTriggerDetect_scan_head_lever_change(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.trigger.detect_scan_head_lever_change'


class RootLuSystem_infraInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.trigger'
        self.detect_scan_head_lever_change = RootLuSystem_infraInstanceTriggerDetect_scan_head_lever_change(self._context)
        self.detect_limit_switch_status_info_change = RootLuSystem_infraInstanceTriggerDetect_limit_switch_status_info_change(self._context)
        self.switch_clock_source = RootLuSystem_infraInstanceTriggerSwitch_clock_source(self._context)
        self.detect_scan_head_arrival_removal = RootLuSystem_infraInstanceTriggerDetect_scan_head_arrival_removal(self._context)


class RootLuSystem_infraInstanceAttributeCurrent_scanhead_tilt_positionEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum'

    @property
    def open_pos(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum.open_pos'))

    @open_pos.setter
    def open_pos(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum.open_pos', int(new_val))

    @property
    def working_pos(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum.working_pos'))

    @working_pos.setter
    def working_pos(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum.working_pos', int(new_val))

    @property
    def undefined(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum.undefined'))

    @undefined.setter
    def undefined(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_scanhead_tilt_position.enum.undefined', int(new_val))


class RootLuSystem_infraInstanceAttributeCurrent_scanhead_tilt_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_scanhead_tilt_position'
        self.enum = RootLuSystem_infraInstanceAttributeCurrent_scanhead_tilt_positionEnum(self._context)


class RootLuSystem_infraInstanceAttributeLaser_power_lock(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.laser_power_lock'


class RootLuSystem_infraInstanceAttributeMain_in1_couplingEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in1_coupling.enum'

    @property
    def dc_coupling(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in1_coupling.enum.dc_coupling'))

    @dc_coupling.setter
    def dc_coupling(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in1_coupling.enum.dc_coupling', int(new_val))

    @property
    def ac_coupling(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in1_coupling.enum.ac_coupling'))

    @ac_coupling.setter
    def ac_coupling(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in1_coupling.enum.ac_coupling', int(new_val))


class RootLuSystem_infraInstanceAttributeMain_in1_coupling(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in1_coupling'
        self.enum = RootLuSystem_infraInstanceAttributeMain_in1_couplingEnum(self._context)


class RootLuSystem_infraInstanceAttributeAfm_sensor_status_normalized(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_status_normalized'


class RootLuSystem_infraInstanceAttributeMain_in1_gainEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in1_gain.enum'

    @property
    def gain16(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in1_gain.enum.gain16'))

    @gain16.setter
    def gain16(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in1_gain.enum.gain16', int(new_val))

    @property
    def gain1(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in1_gain.enum.gain1'))

    @gain1.setter
    def gain1(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in1_gain.enum.gain1', int(new_val))

    @property
    def gain4(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in1_gain.enum.gain4'))

    @gain4.setter
    def gain4(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in1_gain.enum.gain4', int(new_val))


class RootLuSystem_infraInstanceAttributeMain_in1_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in1_gain'
        self.enum = RootLuSystem_infraInstanceAttributeMain_in1_gainEnum(self._context)


class RootLuSystem_infraInstanceAttributeLaser_power_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.laser_power_absolute'


class RootLuSystem_infraInstanceAttributeExtra_in1_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.extra_in1_input'


class RootLuSystem_infraInstanceAttributeInterface_box_typeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.interface_box_type.enum'

    @property
    def i100_integrated(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.i100_integrated'))

    @i100_integrated.setter
    def i100_integrated(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.i100_integrated', int(new_val))

    @property
    def icxp6(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxp6'))

    @icxp6.setter
    def icxp6(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxp6', int(new_val))

    @property
    def icxcytomass(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxcytomass'))

    @icxcytomass.setter
    def icxcytomass(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxcytomass', int(new_val))

    @property
    def i100_afsem(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.i100_afsem'))

    @i100_afsem.setter
    def i100_afsem(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.i100_afsem', int(new_val))

    @property
    def i100(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.i100'))

    @i100.setter
    def i100(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.i100', int(new_val))

    @property
    def icxarac(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxarac'))

    @icxarac.setter
    def icxarac(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxarac', int(new_val))

    @property
    def not_connected(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.not_connected'))

    @not_connected.setter
    def not_connected(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.not_connected', int(new_val))

    @property
    def unknown(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.unknown'))

    @unknown.setter
    def unknown(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.unknown', int(new_val))

    @property
    def icxflex(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxflex'))

    @icxflex.setter
    def icxflex(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.interface_box_type.enum.icxflex', int(new_val))


class RootLuSystem_infraInstanceAttributeInterface_box_type(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.interface_box_type'
        self.enum = RootLuSystem_infraInstanceAttributeInterface_box_typeEnum(self._context)


class RootLuSystem_infraInstanceAttributeMain_in2_couplingEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_coupling.enum'

    @property
    def dc_coupling(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_coupling.enum.dc_coupling'))

    @dc_coupling.setter
    def dc_coupling(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_coupling.enum.dc_coupling', int(new_val))

    @property
    def ac_coupling(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_coupling.enum.ac_coupling'))

    @ac_coupling.setter
    def ac_coupling(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_coupling.enum.ac_coupling', int(new_val))


class RootLuSystem_infraInstanceAttributeMain_in2_coupling(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_coupling'
        self.enum = RootLuSystem_infraInstanceAttributeMain_in2_couplingEnum(self._context)


class RootLuSystem_infraInstanceAttributeHas_video_source_detection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.has_video_source_detection'


class RootLuSystem_infraInstanceAttributeApproach_motor_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_status.enum'

    @property
    def dummy_0(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_status.enum.dummy_0'))

    @dummy_0.setter
    def dummy_0(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_status.enum.dummy_0', int(new_val))

    @property
    def not_connected(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_status.enum.not_connected'))

    @not_connected.setter
    def not_connected(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_status.enum.not_connected', int(new_val))

    @property
    def in_range(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_status.enum.in_range'))

    @in_range.setter
    def in_range(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_status.enum.in_range', int(new_val))

    @property
    def min_in(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_status.enum.min_in'))

    @min_in.setter
    def min_in(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_status.enum.min_in', int(new_val))

    @property
    def max_out(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_status.enum.max_out'))

    @max_out.setter
    def max_out(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_status.enum.max_out', int(new_val))

    @property
    def error(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_status.enum.error'))

    @error.setter
    def error(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_status.enum.error', int(new_val))


class RootLuSystem_infraInstanceAttributeApproach_motor_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_status'
        self.enum = RootLuSystem_infraInstanceAttributeApproach_motor_statusEnum(self._context)


class RootLuSystem_infraInstanceAttributeSensor_value_normalized(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.sensor_value_normalized'


class RootLuSystem_infraInstanceAttributeController_typeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.controller_type.enum'

    @property
    def c3000_i(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.controller_type.enum.c3000_i'))

    @c3000_i.setter
    def c3000_i(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.controller_type.enum.c3000_i', int(new_val))

    @property
    def c3000(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.controller_type.enum.c3000'))

    @c3000.setter
    def c3000(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.controller_type.enum.c3000', int(new_val))

    @property
    def core_afm(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.controller_type.enum.core_afm'))

    @core_afm.setter
    def core_afm(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.controller_type.enum.core_afm', int(new_val))

    @property
    def cx(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.controller_type.enum.cx'))

    @cx.setter
    def cx(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.controller_type.enum.cx', int(new_val))

    @property
    def unknown(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.controller_type.enum.unknown'))

    @unknown.setter
    def unknown(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.controller_type.enum.unknown', int(new_val))


class RootLuSystem_infraInstanceAttributeController_type(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.controller_type'
        self.enum = RootLuSystem_infraInstanceAttributeController_typeEnum(self._context)


class RootLuSystem_infraInstanceAttributeTarget_clock_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.target_clock_source.enum'

    @property
    def internal(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.target_clock_source.enum.internal'))

    @internal.setter
    def internal(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.target_clock_source.enum.internal', int(new_val))

    @property
    def external(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.target_clock_source.enum.external'))

    @external.setter
    def external(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.target_clock_source.enum.external', int(new_val))


class RootLuSystem_infraInstanceAttributeTarget_clock_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.target_clock_source'
        self.enum = RootLuSystem_infraInstanceAttributeTarget_clock_sourceEnum(self._context)


class RootLuSystem_infraInstanceAttributeControl_laser_power(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.control_laser_power'


class RootLuSystem_infraInstanceAttributeTip_current_or_in_user3_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum'

    @property
    def ana_gnd(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum.ana_gnd'))

    @ana_gnd.setter
    def ana_gnd(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum.ana_gnd', int(new_val))

    @property
    def tip_current(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum.tip_current'))

    @tip_current.setter
    def tip_current(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum.tip_current', int(new_val))

    @property
    def in_user3(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum.in_user3'))

    @in_user3.setter
    def in_user3(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input.enum.in_user3', int(new_val))


class RootLuSystem_infraInstanceAttributeTip_current_or_in_user3_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.tip_current_or_in_user3_input'
        self.enum = RootLuSystem_infraInstanceAttributeTip_current_or_in_user3_inputEnum(self._context)


class RootLuSystem_infraInstanceAttributeApproach_motor_status_normalized(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_status_normalized'


class RootLuSystem_infraInstanceAttributeDepreciated_1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.depreciated_1'


class RootLuSystem_infraInstanceAttributeTip_signal_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.tip_signal_mode.enum'

    @property
    def current_sense_input(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.tip_signal_mode.enum.current_sense_input'))

    @current_sense_input.setter
    def current_sense_input(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.tip_signal_mode.enum.current_sense_input', int(new_val))

    @property
    def voltage_output(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.tip_signal_mode.enum.voltage_output'))

    @voltage_output.setter
    def voltage_output(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.tip_signal_mode.enum.voltage_output', int(new_val))

    @property
    def external_feedthrough(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.tip_signal_mode.enum.external_feedthrough'))

    @external_feedthrough.setter
    def external_feedthrough(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.tip_signal_mode.enum.external_feedthrough', int(new_val))


class RootLuSystem_infraInstanceAttributeTip_signal_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.tip_signal_mode'
        self.enum = RootLuSystem_infraInstanceAttributeTip_signal_modeEnum(self._context)


class RootLuSystem_infraInstanceAttributeAfm_sensor_statusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_status.enum'

    @property
    def low(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.low'))

    @low.setter
    def low(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.low', int(new_val))

    @property
    def fail(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.fail'))

    @fail.setter
    def fail(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.fail', int(new_val))

    @property
    def high(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.high'))

    @high.setter
    def high(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.high', int(new_val))

    @property
    def ok(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.ok'))

    @ok.setter
    def ok(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.ok', int(new_val))

    @property
    def undefined(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.undefined'))

    @undefined.setter
    def undefined(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_status.enum.undefined', int(new_val))


class RootLuSystem_infraInstanceAttributeAfm_sensor_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_status'
        self.enum = RootLuSystem_infraInstanceAttributeAfm_sensor_statusEnum(self._context)


class RootLuSystem_infraInstanceAttributeApproach_motor_position(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_position'


class RootLuSystem_infraInstanceAttributeCurrent_video_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_video_source.enum'

    @property
    def top_view(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_video_source.enum.top_view'))

    @top_view.setter
    def top_view(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_video_source.enum.top_view', int(new_val))

    @property
    def side_view(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_video_source.enum.side_view'))

    @side_view.setter
    def side_view(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_video_source.enum.side_view', int(new_val))

    @property
    def undefined(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_video_source.enum.undefined'))

    @undefined.setter
    def undefined(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_video_source.enum.undefined', int(new_val))


class RootLuSystem_infraInstanceAttributeCurrent_video_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_video_source'
        self.enum = RootLuSystem_infraInstanceAttributeCurrent_video_sourceEnum(self._context)


class RootLuSystem_infraInstanceAttributeAfm_sensor_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_mode.enum'

    @property
    def laser_drive(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.laser_drive'))

    @laser_drive.setter
    def laser_drive(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.laser_drive', int(new_val))

    @property
    def detector_intensity(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.detector_intensity'))

    @detector_intensity.setter
    def detector_intensity(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.detector_intensity', int(new_val))

    @property
    def laser_power(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.laser_power'))

    @laser_power.setter
    def laser_power(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.laser_power', int(new_val))

    @property
    def undefined(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.undefined'))

    @undefined.setter
    def undefined(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.afm_sensor_mode.enum.undefined', int(new_val))


class RootLuSystem_infraInstanceAttributeAfm_sensor_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.afm_sensor_mode'
        self.enum = RootLuSystem_infraInstanceAttributeAfm_sensor_modeEnum(self._context)


class RootLuSystem_infraInstanceAttributeFast_out2_output_maskEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum'

    @property
    def all(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.all'))

    @all.setter
    def all(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.all', int(new_val))

    @property
    def tip_voltage_or_user_out_a(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.tip_voltage_or_user_out_a'))

    @tip_voltage_or_user_out_a.setter
    def tip_voltage_or_user_out_a(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.tip_voltage_or_user_out_a', int(new_val))

    @property
    def user_out_b(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.user_out_b'))

    @user_out_b.setter
    def user_out_b(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.user_out_b', int(new_val))

    @property
    def none(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.none'))

    @none.setter
    def none(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.none', int(new_val))

    @property
    def monitor2(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.monitor2'))

    @monitor2.setter
    def monitor2(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.monitor2', int(new_val))

    @property
    def user_out1(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.user_out1'))

    @user_out1.setter
    def user_out1(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.user_out1', int(new_val))

    @property
    def monitor1(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.monitor1'))

    @monitor1.setter
    def monitor1(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.fast_out2_output_mask.enum.monitor1', int(new_val))


class RootLuSystem_infraInstanceAttributeFast_out2_output_mask(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.fast_out2_output_mask'
        self.enum = RootLuSystem_infraInstanceAttributeFast_out2_output_maskEnum(self._context)


class RootLuSystem_infraInstanceAttributeDepreciated_2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.depreciated_2'


class RootLuSystem_infraInstanceAttributeScan_head_type(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.scan_head_type'


class RootLuSystem_infraInstanceAttributeDepreciated_0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.depreciated_0'


class RootLuSystem_infraInstanceAttributeHas_scanhead_tilt_detection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.has_scanhead_tilt_detection'


class RootLuSystem_infraInstanceAttributeMain_in2_inputEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_input.enum'

    @property
    def tip_current(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.tip_current'))

    @tip_current.setter
    def tip_current(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.tip_current', int(new_val))

    @property
    def deflection(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.deflection'))

    @deflection.setter
    def deflection(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.deflection', int(new_val))

    @property
    def lateral(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.lateral'))

    @lateral.setter
    def lateral(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.lateral', int(new_val))

    @property
    def user3(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.user3'))

    @user3.setter
    def user3(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.user3', int(new_val))

    @property
    def test_ana_gnd(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.test_ana_gnd'))

    @test_ana_gnd.setter
    def test_ana_gnd(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.test_ana_gnd', int(new_val))

    @property
    def test_tip_voltage(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.test_tip_voltage'))

    @test_tip_voltage.setter
    def test_tip_voltage(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.test_tip_voltage', int(new_val))

    @property
    def user1(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.user1'))

    @user1.setter
    def user1(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.user1', int(new_val))

    @property
    def test_ref(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.test_ref'))

    @test_ref.setter
    def test_ref(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.test_ref', int(new_val))

    @property
    def user2(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_input.enum.user2'))

    @user2.setter
    def user2(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_input.enum.user2', int(new_val))


class RootLuSystem_infraInstanceAttributeMain_in2_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_input'
        self.enum = RootLuSystem_infraInstanceAttributeMain_in2_inputEnum(self._context)


class RootLuSystem_infraInstanceAttributeApproach_motor_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_mode.enum'

    @property
    def position_sensor(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_mode.enum.position_sensor'))

    @position_sensor.setter
    def position_sensor(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_mode.enum.position_sensor', int(new_val))

    @property
    def limit_switches(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_mode.enum.limit_switches'))

    @limit_switches.setter
    def limit_switches(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_mode.enum.limit_switches', int(new_val))

    @property
    def undefined(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.approach_motor_mode.enum.undefined'))

    @undefined.setter
    def undefined(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.approach_motor_mode.enum.undefined', int(new_val))


class RootLuSystem_infraInstanceAttributeApproach_motor_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.approach_motor_mode'
        self.enum = RootLuSystem_infraInstanceAttributeApproach_motor_modeEnum(self._context)


class RootLuSystem_infraInstanceAttributeSensor_light(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.sensor_light'


class RootLuSystem_infraInstanceAttributeEnable10_hz_update_sensor_status(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.enable10_hz_update_sensor_status'


class RootLuSystem_infraInstanceAttributeMain_in2_gainEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_gain.enum'

    @property
    def gain16(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_gain.enum.gain16'))

    @gain16.setter
    def gain16(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_gain.enum.gain16', int(new_val))

    @property
    def gain1(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_gain.enum.gain1'))

    @gain1.setter
    def gain1(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_gain.enum.gain1', int(new_val))

    @property
    def gain4(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.main_in2_gain.enum.gain4'))

    @gain4.setter
    def gain4(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.main_in2_gain.enum.gain4', int(new_val))


class RootLuSystem_infraInstanceAttributeMain_in2_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.main_in2_gain'
        self.enum = RootLuSystem_infraInstanceAttributeMain_in2_gainEnum(self._context)


class RootLuSystem_infraInstanceAttributeCurrent_clock_sourceEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_clock_source.enum'

    @property
    def internal(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_clock_source.enum.internal'))

    @internal.setter
    def internal(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_clock_source.enum.internal', int(new_val))

    @property
    def external(self) -> int:
        return int(self._context.get('root.lu.system_infra.instance.attribute.current_clock_source.enum.external'))

    @external.setter
    def external(self, new_val:int):
        self._context.set('root.lu.system_infra.instance.attribute.current_clock_source.enum.external', int(new_val))


class RootLuSystem_infraInstanceAttributeCurrent_clock_source(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.current_clock_source'
        self.enum = RootLuSystem_infraInstanceAttributeCurrent_clock_sourceEnum(self._context)


class RootLuSystem_infraInstanceAttributeController_temperature(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.controller_temperature'


class RootLuSystem_infraInstanceAttributeFriction_normalized(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.friction_normalized'


class RootLuSystem_infraInstanceAttributeLaser_power_current(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.laser_power_current'


class RootLuSystem_infraInstanceAttributeDeflection_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute.deflection_offset'


class RootLuSystem_infraInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance.attribute'
        self.deflection_offset = RootLuSystem_infraInstanceAttributeDeflection_offset(self._context)
        self.laser_power_current = RootLuSystem_infraInstanceAttributeLaser_power_current(self._context)
        self.friction_normalized = RootLuSystem_infraInstanceAttributeFriction_normalized(self._context)
        self.controller_temperature = RootLuSystem_infraInstanceAttributeController_temperature(self._context)
        self.current_clock_source = RootLuSystem_infraInstanceAttributeCurrent_clock_source(self._context)
        self.main_in2_gain = RootLuSystem_infraInstanceAttributeMain_in2_gain(self._context)
        self.enable10_hz_update_sensor_status = RootLuSystem_infraInstanceAttributeEnable10_hz_update_sensor_status(self._context)
        self.sensor_light = RootLuSystem_infraInstanceAttributeSensor_light(self._context)
        self.approach_motor_mode = RootLuSystem_infraInstanceAttributeApproach_motor_mode(self._context)
        self.main_in2_input = RootLuSystem_infraInstanceAttributeMain_in2_input(self._context)
        self.has_scanhead_tilt_detection = RootLuSystem_infraInstanceAttributeHas_scanhead_tilt_detection(self._context)
        self.depreciated_0 = RootLuSystem_infraInstanceAttributeDepreciated_0(self._context)
        self.scan_head_type = RootLuSystem_infraInstanceAttributeScan_head_type(self._context)
        self.depreciated_2 = RootLuSystem_infraInstanceAttributeDepreciated_2(self._context)
        self.fast_out2_output_mask = RootLuSystem_infraInstanceAttributeFast_out2_output_mask(self._context)
        self.afm_sensor_mode = RootLuSystem_infraInstanceAttributeAfm_sensor_mode(self._context)
        self.current_video_source = RootLuSystem_infraInstanceAttributeCurrent_video_source(self._context)
        self.approach_motor_position = RootLuSystem_infraInstanceAttributeApproach_motor_position(self._context)
        self.afm_sensor_status = RootLuSystem_infraInstanceAttributeAfm_sensor_status(self._context)
        self.tip_signal_mode = RootLuSystem_infraInstanceAttributeTip_signal_mode(self._context)
        self.depreciated_1 = RootLuSystem_infraInstanceAttributeDepreciated_1(self._context)
        self.approach_motor_status_normalized = RootLuSystem_infraInstanceAttributeApproach_motor_status_normalized(self._context)
        self.tip_current_or_in_user3_input = RootLuSystem_infraInstanceAttributeTip_current_or_in_user3_input(self._context)
        self.control_laser_power = RootLuSystem_infraInstanceAttributeControl_laser_power(self._context)
        self.target_clock_source = RootLuSystem_infraInstanceAttributeTarget_clock_source(self._context)
        self.controller_type = RootLuSystem_infraInstanceAttributeController_type(self._context)
        self.sensor_value_normalized = RootLuSystem_infraInstanceAttributeSensor_value_normalized(self._context)
        self.approach_motor_status = RootLuSystem_infraInstanceAttributeApproach_motor_status(self._context)
        self.has_video_source_detection = RootLuSystem_infraInstanceAttributeHas_video_source_detection(self._context)
        self.main_in2_coupling = RootLuSystem_infraInstanceAttributeMain_in2_coupling(self._context)
        self.interface_box_type = RootLuSystem_infraInstanceAttributeInterface_box_type(self._context)
        self.extra_in1_input = RootLuSystem_infraInstanceAttributeExtra_in1_input(self._context)
        self.laser_power_absolute = RootLuSystem_infraInstanceAttributeLaser_power_absolute(self._context)
        self.main_in1_gain = RootLuSystem_infraInstanceAttributeMain_in1_gain(self._context)
        self.afm_sensor_status_normalized = RootLuSystem_infraInstanceAttributeAfm_sensor_status_normalized(self._context)
        self.main_in1_coupling = RootLuSystem_infraInstanceAttributeMain_in1_coupling(self._context)
        self.laser_power_lock = RootLuSystem_infraInstanceAttributeLaser_power_lock(self._context)
        self.current_scanhead_tilt_position = RootLuSystem_infraInstanceAttributeCurrent_scanhead_tilt_position(self._context)


class RootLuSystem_infraInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra.instance'
        self.attribute = RootLuSystem_infraInstanceAttribute(self._context)
        self.trigger = RootLuSystem_infraInstanceTrigger(self._context)


class RootLuSystem_infra(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system_infra'
        self.instance = RootLuSystem_infraInstance(self._context)


class RootLuAnalog_hi_res_inUser2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.trigger'


class RootLuAnalog_hi_res_inUser2AttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.current_input_value'


class RootLuAnalog_hi_res_inUser2AttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.calib_gain'


class RootLuAnalog_hi_res_inUser2AttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inUser2AttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inUser2AttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inUser2AttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inUser2AttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inUser2AttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inUser2AttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.filter_number'


class RootLuAnalog_hi_res_inUser2AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.input_gain'


class RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inUser2AttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.calib_offset'


class RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inUser2AttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inUser2AttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute.input_offset'


class RootLuAnalog_hi_res_inUser2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2.attribute'
        self.input_offset = RootLuAnalog_hi_res_inUser2AttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inUser2AttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inUser2AttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inUser2AttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inUser2AttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inUser2AttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inUser2AttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inUser2AttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inUser2AttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inUser2AttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inUser2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user2'
        self.attribute = RootLuAnalog_hi_res_inUser2Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inUser2Trigger(self._context)


class RootLuAnalog_hi_res_inPosition_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.trigger'


class RootLuAnalog_hi_res_inPosition_zAttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.current_input_value'


class RootLuAnalog_hi_res_inPosition_zAttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.calib_gain'


class RootLuAnalog_hi_res_inPosition_zAttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inPosition_zAttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inPosition_zAttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inPosition_zAttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inPosition_zAttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.filter_number'


class RootLuAnalog_hi_res_inPosition_zAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.input_gain'


class RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inPosition_zAttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.calib_offset'


class RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inPosition_zAttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inPosition_zAttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute.input_offset'


class RootLuAnalog_hi_res_inPosition_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z.attribute'
        self.input_offset = RootLuAnalog_hi_res_inPosition_zAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inPosition_zAttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inPosition_zAttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inPosition_zAttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inPosition_zAttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inPosition_zAttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inPosition_zAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inPosition_zAttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inPosition_zAttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inPosition_zAttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inPosition_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_z'
        self.attribute = RootLuAnalog_hi_res_inPosition_zAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inPosition_zTrigger(self._context)


class RootLuAnalog_hi_res_inUser1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.trigger'


class RootLuAnalog_hi_res_inUser1AttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.current_input_value'


class RootLuAnalog_hi_res_inUser1AttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.calib_gain'


class RootLuAnalog_hi_res_inUser1AttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inUser1AttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inUser1AttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inUser1AttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inUser1AttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inUser1AttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inUser1AttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.filter_number'


class RootLuAnalog_hi_res_inUser1AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.input_gain'


class RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inUser1AttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.calib_offset'


class RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inUser1AttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inUser1AttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute.input_offset'


class RootLuAnalog_hi_res_inUser1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1.attribute'
        self.input_offset = RootLuAnalog_hi_res_inUser1AttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inUser1AttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inUser1AttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inUser1AttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inUser1AttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inUser1AttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inUser1AttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inUser1AttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inUser1AttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inUser1AttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inUser1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user1'
        self.attribute = RootLuAnalog_hi_res_inUser1Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inUser1Trigger(self._context)


class RootLuAnalog_hi_res_inPosition_xTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.trigger'


class RootLuAnalog_hi_res_inPosition_xAttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.current_input_value'


class RootLuAnalog_hi_res_inPosition_xAttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.calib_gain'


class RootLuAnalog_hi_res_inPosition_xAttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inPosition_xAttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inPosition_xAttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inPosition_xAttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inPosition_xAttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.filter_number'


class RootLuAnalog_hi_res_inPosition_xAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.input_gain'


class RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inPosition_xAttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.calib_offset'


class RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inPosition_xAttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inPosition_xAttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute.input_offset'


class RootLuAnalog_hi_res_inPosition_xAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x.attribute'
        self.input_offset = RootLuAnalog_hi_res_inPosition_xAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inPosition_xAttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inPosition_xAttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inPosition_xAttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inPosition_xAttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inPosition_xAttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inPosition_xAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inPosition_xAttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inPosition_xAttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inPosition_xAttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inPosition_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_x'
        self.attribute = RootLuAnalog_hi_res_inPosition_xAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inPosition_xTrigger(self._context)


class RootLuAnalog_hi_res_inTip_currentTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.trigger'


class RootLuAnalog_hi_res_inTip_currentAttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.current_input_value'


class RootLuAnalog_hi_res_inTip_currentAttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.calib_gain'


class RootLuAnalog_hi_res_inTip_currentAttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inTip_currentAttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inTip_currentAttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inTip_currentAttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inTip_currentAttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.filter_number'


class RootLuAnalog_hi_res_inTip_currentAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.input_gain'


class RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inTip_currentAttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.calib_offset'


class RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inTip_currentAttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inTip_currentAttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute.input_offset'


class RootLuAnalog_hi_res_inTip_currentAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current.attribute'
        self.input_offset = RootLuAnalog_hi_res_inTip_currentAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inTip_currentAttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inTip_currentAttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inTip_currentAttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inTip_currentAttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inTip_currentAttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inTip_currentAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inTip_currentAttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inTip_currentAttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inTip_currentAttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inTip_current(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.tip_current'
        self.attribute = RootLuAnalog_hi_res_inTip_currentAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inTip_currentTrigger(self._context)


class RootLuAnalog_hi_res_inUser3Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.trigger'


class RootLuAnalog_hi_res_inUser3AttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.current_input_value'


class RootLuAnalog_hi_res_inUser3AttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.calib_gain'


class RootLuAnalog_hi_res_inUser3AttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inUser3AttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inUser3AttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inUser3AttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inUser3AttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inUser3AttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inUser3AttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.filter_number'


class RootLuAnalog_hi_res_inUser3AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.input_gain'


class RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inUser3AttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.calib_offset'


class RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inUser3AttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inUser3AttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute.input_offset'


class RootLuAnalog_hi_res_inUser3Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3.attribute'
        self.input_offset = RootLuAnalog_hi_res_inUser3AttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inUser3AttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inUser3AttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inUser3AttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inUser3AttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inUser3AttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inUser3AttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inUser3AttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inUser3AttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inUser3AttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inUser3(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user3'
        self.attribute = RootLuAnalog_hi_res_inUser3Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inUser3Trigger(self._context)


class RootLuAnalog_hi_res_inIn6Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.trigger'


class RootLuAnalog_hi_res_inIn6AttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.current_input_value'


class RootLuAnalog_hi_res_inIn6AttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.calib_gain'


class RootLuAnalog_hi_res_inIn6AttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inIn6AttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inIn6AttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inIn6AttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inIn6AttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inIn6AttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inIn6AttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.filter_number'


class RootLuAnalog_hi_res_inIn6AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.input_gain'


class RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inIn6AttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.calib_offset'


class RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inIn6AttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inIn6AttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute.input_offset'


class RootLuAnalog_hi_res_inIn6Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6.attribute'
        self.input_offset = RootLuAnalog_hi_res_inIn6AttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inIn6AttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inIn6AttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inIn6AttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inIn6AttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inIn6AttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inIn6AttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inIn6AttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inIn6AttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inIn6AttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inIn6(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.in6'
        self.attribute = RootLuAnalog_hi_res_inIn6Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inIn6Trigger(self._context)


class RootLuAnalog_hi_res_inDetector_sumTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.trigger'


class RootLuAnalog_hi_res_inDetector_sumAttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.current_input_value'


class RootLuAnalog_hi_res_inDetector_sumAttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.calib_gain'


class RootLuAnalog_hi_res_inDetector_sumAttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inDetector_sumAttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inDetector_sumAttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inDetector_sumAttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inDetector_sumAttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.filter_number'


class RootLuAnalog_hi_res_inDetector_sumAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.input_gain'


class RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inDetector_sumAttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.calib_offset'


class RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inDetector_sumAttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inDetector_sumAttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute.input_offset'


class RootLuAnalog_hi_res_inDetector_sumAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum.attribute'
        self.input_offset = RootLuAnalog_hi_res_inDetector_sumAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inDetector_sumAttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inDetector_sumAttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inDetector_sumAttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inDetector_sumAttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inDetector_sumAttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inDetector_sumAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inDetector_sumAttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inDetector_sumAttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inDetector_sumAttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inDetector_sum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.detector_sum'
        self.attribute = RootLuAnalog_hi_res_inDetector_sumAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inDetector_sumTrigger(self._context)


class RootLuAnalog_hi_res_inLateralTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.trigger'


class RootLuAnalog_hi_res_inLateralAttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.current_input_value'


class RootLuAnalog_hi_res_inLateralAttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.calib_gain'


class RootLuAnalog_hi_res_inLateralAttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inLateralAttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inLateralAttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inLateralAttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inLateralAttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inLateralAttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inLateralAttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.filter_number'


class RootLuAnalog_hi_res_inLateralAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.input_gain'


class RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inLateralAttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.calib_offset'


class RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inLateralAttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inLateralAttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute.input_offset'


class RootLuAnalog_hi_res_inLateralAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral.attribute'
        self.input_offset = RootLuAnalog_hi_res_inLateralAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inLateralAttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inLateralAttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inLateralAttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inLateralAttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inLateralAttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inLateralAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inLateralAttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inLateralAttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inLateralAttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inLateral(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.lateral'
        self.attribute = RootLuAnalog_hi_res_inLateralAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inLateralTrigger(self._context)


class RootLuAnalog_hi_res_inUser4Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.trigger'


class RootLuAnalog_hi_res_inUser4AttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.current_input_value'


class RootLuAnalog_hi_res_inUser4AttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.calib_gain'


class RootLuAnalog_hi_res_inUser4AttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inUser4AttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inUser4AttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inUser4AttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inUser4AttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inUser4AttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inUser4AttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.filter_number'


class RootLuAnalog_hi_res_inUser4AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.input_gain'


class RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inUser4AttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.calib_offset'


class RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inUser4AttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inUser4AttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute.input_offset'


class RootLuAnalog_hi_res_inUser4Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4.attribute'
        self.input_offset = RootLuAnalog_hi_res_inUser4AttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inUser4AttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inUser4AttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inUser4AttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inUser4AttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inUser4AttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inUser4AttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inUser4AttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inUser4AttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inUser4AttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inUser4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.user4'
        self.attribute = RootLuAnalog_hi_res_inUser4Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inUser4Trigger(self._context)


class RootLuAnalog_hi_res_inDeflectionTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.trigger'


class RootLuAnalog_hi_res_inDeflectionAttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.current_input_value'


class RootLuAnalog_hi_res_inDeflectionAttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.calib_gain'


class RootLuAnalog_hi_res_inDeflectionAttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inDeflectionAttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inDeflectionAttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inDeflectionAttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inDeflectionAttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.filter_number'


class RootLuAnalog_hi_res_inDeflectionAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.input_gain'


class RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inDeflectionAttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.calib_offset'


class RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inDeflectionAttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inDeflectionAttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute.input_offset'


class RootLuAnalog_hi_res_inDeflectionAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection.attribute'
        self.input_offset = RootLuAnalog_hi_res_inDeflectionAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inDeflectionAttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inDeflectionAttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inDeflectionAttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inDeflectionAttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inDeflectionAttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inDeflectionAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inDeflectionAttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inDeflectionAttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inDeflectionAttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inDeflection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.deflection'
        self.attribute = RootLuAnalog_hi_res_inDeflectionAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inDeflectionTrigger(self._context)


class RootLuAnalog_hi_res_inPosition_yTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.trigger'


class RootLuAnalog_hi_res_inPosition_yAttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.current_input_value'


class RootLuAnalog_hi_res_inPosition_yAttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.calib_gain'


class RootLuAnalog_hi_res_inPosition_yAttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inPosition_yAttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inPosition_yAttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inPosition_yAttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inPosition_yAttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.filter_number'


class RootLuAnalog_hi_res_inPosition_yAttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.input_gain'


class RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inPosition_yAttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.calib_offset'


class RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inPosition_yAttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inPosition_yAttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute.input_offset'


class RootLuAnalog_hi_res_inPosition_yAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y.attribute'
        self.input_offset = RootLuAnalog_hi_res_inPosition_yAttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inPosition_yAttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inPosition_yAttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inPosition_yAttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inPosition_yAttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inPosition_yAttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inPosition_yAttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inPosition_yAttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inPosition_yAttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inPosition_yAttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inPosition_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.position_y'
        self.attribute = RootLuAnalog_hi_res_inPosition_yAttribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inPosition_yTrigger(self._context)


class RootLuAnalog_hi_res_inMain2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.trigger'


class RootLuAnalog_hi_res_inMain2AttributeCurrent_input_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.current_input_value'


class RootLuAnalog_hi_res_inMain2AttributeCalib_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.calib_gain'


class RootLuAnalog_hi_res_inMain2AttributeFilter_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum'

    @property
    def no_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum.no_filter'))

    @no_filter.setter
    def no_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum.no_filter', int(new_val))

    @property
    def low_pass_filter(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum.low_pass_filter'))

    @low_pass_filter.setter
    def low_pass_filter(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.filter_mode.enum.low_pass_filter', int(new_val))


class RootLuAnalog_hi_res_inMain2AttributeFilter_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.filter_mode'
        self.enum = RootLuAnalog_hi_res_inMain2AttributeFilter_modeEnum(self._context)


class RootLuAnalog_hi_res_inMain2AttributeCalib_polarityEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.calib_polarity.enum.positive', int(new_val))


class RootLuAnalog_hi_res_inMain2AttributeCalib_polarity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.calib_polarity'
        self.enum = RootLuAnalog_hi_res_inMain2AttributeCalib_polarityEnum(self._context)


class RootLuAnalog_hi_res_inMain2AttributeFilter_number(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.filter_number'


class RootLuAnalog_hi_res_inMain2AttributeInput_gain(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.input_gain'


class RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_idEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum'

    @property
    def position_x(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_x'))

    @position_x.setter
    def position_x(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_x', int(new_val))

    @property
    def position_y(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_y'))

    @position_y.setter
    def position_y(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_y', int(new_val))

    @property
    def self(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.self'))

    @self.setter
    def self(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.self', int(new_val))

    @property
    def position_z(self) -> int:
        return int(self._context.get('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_z'))

    @position_z.setter
    def position_z(self, new_val:int):
        self._context.set('root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id.enum.position_z', int(new_val))


class RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_id(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_id'
        self.enum = RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_idEnum(self._context)


class RootLuAnalog_hi_res_inMain2AttributeCalib_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.calib_offset'


class RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_coefficient_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.cross_coupling_axis_coefficient_vec'


class RootLuAnalog_hi_res_inMain2AttributeFilter_coeff_vec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.filter_coeff_vec'


class RootLuAnalog_hi_res_inMain2AttributeInput_offset(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute.input_offset'


class RootLuAnalog_hi_res_inMain2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2.attribute'
        self.input_offset = RootLuAnalog_hi_res_inMain2AttributeInput_offset(self._context)
        self.filter_coeff_vec = RootLuAnalog_hi_res_inMain2AttributeFilter_coeff_vec(self._context)
        self.cross_coupling_axis_coefficient_vec = RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_coefficient_vec(self._context)
        self.calib_offset = RootLuAnalog_hi_res_inMain2AttributeCalib_offset(self._context)
        self.cross_coupling_axis_id = RootLuAnalog_hi_res_inMain2AttributeCross_coupling_axis_id(self._context)
        self.input_gain = RootLuAnalog_hi_res_inMain2AttributeInput_gain(self._context)
        self.filter_number = RootLuAnalog_hi_res_inMain2AttributeFilter_number(self._context)
        self.calib_polarity = RootLuAnalog_hi_res_inMain2AttributeCalib_polarity(self._context)
        self.filter_mode = RootLuAnalog_hi_res_inMain2AttributeFilter_mode(self._context)
        self.calib_gain = RootLuAnalog_hi_res_inMain2AttributeCalib_gain(self._context)
        self.current_input_value = RootLuAnalog_hi_res_inMain2AttributeCurrent_input_value(self._context)


class RootLuAnalog_hi_res_inMain2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in.main2'
        self.attribute = RootLuAnalog_hi_res_inMain2Attribute(self._context)
        self.trigger = RootLuAnalog_hi_res_inMain2Trigger(self._context)


class RootLuAnalog_hi_res_in(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.analog_hi_res_in'
        self.main2 = RootLuAnalog_hi_res_inMain2(self._context)
        self.position_y = RootLuAnalog_hi_res_inPosition_y(self._context)
        self.deflection = RootLuAnalog_hi_res_inDeflection(self._context)
        self.user4 = RootLuAnalog_hi_res_inUser4(self._context)
        self.lateral = RootLuAnalog_hi_res_inLateral(self._context)
        self.detector_sum = RootLuAnalog_hi_res_inDetector_sum(self._context)
        self.in6 = RootLuAnalog_hi_res_inIn6(self._context)
        self.user3 = RootLuAnalog_hi_res_inUser3(self._context)
        self.tip_current = RootLuAnalog_hi_res_inTip_current(self._context)
        self.position_x = RootLuAnalog_hi_res_inPosition_x(self._context)
        self.user1 = RootLuAnalog_hi_res_inUser1(self._context)
        self.position_z = RootLuAnalog_hi_res_inPosition_z(self._context)
        self.user2 = RootLuAnalog_hi_res_inUser2(self._context)


class RootLuRamp_generatorUser2TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger.stop'


class RootLuRamp_generatorUser2TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger.abort'


class RootLuRamp_generatorUser2TriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger.prepare'


class RootLuRamp_generatorUser2TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger.start'


class RootLuRamp_generatorUser2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.trigger'
        self.start = RootLuRamp_generatorUser2TriggerStart(self._context)
        self.prepare = RootLuRamp_generatorUser2TriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorUser2TriggerAbort(self._context)
        self.stop = RootLuRamp_generatorUser2TriggerStop(self._context)


class RootLuRamp_generatorUser2AttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_absolute'


class RootLuRamp_generatorUser2AttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_speed'


class RootLuRamp_generatorUser2AttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.upper_limit'


class RootLuRamp_generatorUser2AttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_time'


class RootLuRamp_generatorUser2AttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorUser2AttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.moving_mode'
        self.enum = RootLuRamp_generatorUser2AttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorUser2AttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorUser2AttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.status'
        self.enum = RootLuRamp_generatorUser2AttributeStatusEnum(self._context)


class RootLuRamp_generatorUser2AttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.current_value'


class RootLuRamp_generatorUser2AttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user2.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user2.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorUser2AttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorUser2AttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorUser2AttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.lower_limit'


class RootLuRamp_generatorUser2AttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute.end_value_relative'


class RootLuRamp_generatorUser2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.attribute'
        self.end_value_relative = RootLuRamp_generatorUser2AttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorUser2AttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorUser2AttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorUser2AttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorUser2AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorUser2AttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorUser2AttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorUser2AttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorUser2AttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser2AttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorUser2BusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.busy.is_moving'


class RootLuRamp_generatorUser2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2.busy'
        self.is_moving = RootLuRamp_generatorUser2BusyIs_moving(self._context)


class RootLuRamp_generatorUser2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user2'
        self.busy = RootLuRamp_generatorUser2Busy(self._context)
        self.attribute = RootLuRamp_generatorUser2Attribute(self._context)
        self.trigger = RootLuRamp_generatorUser2Trigger(self._context)


class RootLuRamp_generatorTestTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger.stop'


class RootLuRamp_generatorTestTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger.abort'


class RootLuRamp_generatorTestTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger.prepare'


class RootLuRamp_generatorTestTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger.start'


class RootLuRamp_generatorTestTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.trigger'
        self.start = RootLuRamp_generatorTestTriggerStart(self._context)
        self.prepare = RootLuRamp_generatorTestTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorTestTriggerAbort(self._context)
        self.stop = RootLuRamp_generatorTestTriggerStop(self._context)


class RootLuRamp_generatorTestAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_absolute'


class RootLuRamp_generatorTestAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_speed'


class RootLuRamp_generatorTestAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.upper_limit'


class RootLuRamp_generatorTestAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_time'


class RootLuRamp_generatorTestAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorTestAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.moving_mode'
        self.enum = RootLuRamp_generatorTestAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorTestAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorTestAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.status'
        self.enum = RootLuRamp_generatorTestAttributeStatusEnum(self._context)


class RootLuRamp_generatorTestAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.current_value'


class RootLuRamp_generatorTestAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.test.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.test.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorTestAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorTestAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorTestAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.lower_limit'


class RootLuRamp_generatorTestAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute.end_value_relative'


class RootLuRamp_generatorTestAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.attribute'
        self.end_value_relative = RootLuRamp_generatorTestAttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorTestAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorTestAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorTestAttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorTestAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorTestAttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorTestAttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorTestAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorTestAttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorTestAttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorTestBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.busy.is_moving'


class RootLuRamp_generatorTestBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test.busy'
        self.is_moving = RootLuRamp_generatorTestBusyIs_moving(self._context)


class RootLuRamp_generatorTest(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.test'
        self.busy = RootLuRamp_generatorTestBusy(self._context)
        self.attribute = RootLuRamp_generatorTestAttribute(self._context)
        self.trigger = RootLuRamp_generatorTestTrigger(self._context)


class RootLuRamp_generatorUser1TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger.stop'


class RootLuRamp_generatorUser1TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger.abort'


class RootLuRamp_generatorUser1TriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger.prepare'


class RootLuRamp_generatorUser1TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger.start'


class RootLuRamp_generatorUser1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.trigger'
        self.start = RootLuRamp_generatorUser1TriggerStart(self._context)
        self.prepare = RootLuRamp_generatorUser1TriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorUser1TriggerAbort(self._context)
        self.stop = RootLuRamp_generatorUser1TriggerStop(self._context)


class RootLuRamp_generatorUser1AttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_absolute'


class RootLuRamp_generatorUser1AttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_speed'


class RootLuRamp_generatorUser1AttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.upper_limit'


class RootLuRamp_generatorUser1AttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_time'


class RootLuRamp_generatorUser1AttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorUser1AttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.moving_mode'
        self.enum = RootLuRamp_generatorUser1AttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorUser1AttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorUser1AttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.status'
        self.enum = RootLuRamp_generatorUser1AttributeStatusEnum(self._context)


class RootLuRamp_generatorUser1AttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.current_value'


class RootLuRamp_generatorUser1AttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user1.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user1.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorUser1AttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorUser1AttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorUser1AttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.lower_limit'


class RootLuRamp_generatorUser1AttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute.end_value_relative'


class RootLuRamp_generatorUser1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.attribute'
        self.end_value_relative = RootLuRamp_generatorUser1AttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorUser1AttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorUser1AttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorUser1AttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorUser1AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorUser1AttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorUser1AttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorUser1AttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorUser1AttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser1AttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorUser1BusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.busy.is_moving'


class RootLuRamp_generatorUser1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1.busy'
        self.is_moving = RootLuRamp_generatorUser1BusyIs_moving(self._context)


class RootLuRamp_generatorUser1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user1'
        self.busy = RootLuRamp_generatorUser1Busy(self._context)
        self.attribute = RootLuRamp_generatorUser1Attribute(self._context)
        self.trigger = RootLuRamp_generatorUser1Trigger(self._context)


class RootLuRamp_generatorPosition_xTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger.stop'


class RootLuRamp_generatorPosition_xTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger.abort'


class RootLuRamp_generatorPosition_xTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger.prepare'


class RootLuRamp_generatorPosition_xTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger.start'


class RootLuRamp_generatorPosition_xTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.trigger'
        self.start = RootLuRamp_generatorPosition_xTriggerStart(self._context)
        self.prepare = RootLuRamp_generatorPosition_xTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorPosition_xTriggerAbort(self._context)
        self.stop = RootLuRamp_generatorPosition_xTriggerStop(self._context)


class RootLuRamp_generatorPosition_xAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_absolute'


class RootLuRamp_generatorPosition_xAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_speed'


class RootLuRamp_generatorPosition_xAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.upper_limit'


class RootLuRamp_generatorPosition_xAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_time'


class RootLuRamp_generatorPosition_xAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorPosition_xAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.moving_mode'
        self.enum = RootLuRamp_generatorPosition_xAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorPosition_xAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorPosition_xAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.status'
        self.enum = RootLuRamp_generatorPosition_xAttributeStatusEnum(self._context)


class RootLuRamp_generatorPosition_xAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.current_value'


class RootLuRamp_generatorPosition_xAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_x.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorPosition_xAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorPosition_xAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorPosition_xAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.lower_limit'


class RootLuRamp_generatorPosition_xAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute.end_value_relative'


class RootLuRamp_generatorPosition_xAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.attribute'
        self.end_value_relative = RootLuRamp_generatorPosition_xAttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorPosition_xAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorPosition_xAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorPosition_xAttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorPosition_xAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_xAttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorPosition_xAttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_xAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorPosition_xAttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_xAttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorPosition_xBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.busy.is_moving'


class RootLuRamp_generatorPosition_xBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x.busy'
        self.is_moving = RootLuRamp_generatorPosition_xBusyIs_moving(self._context)


class RootLuRamp_generatorPosition_x(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_x'
        self.busy = RootLuRamp_generatorPosition_xBusy(self._context)
        self.attribute = RootLuRamp_generatorPosition_xAttribute(self._context)
        self.trigger = RootLuRamp_generatorPosition_xTrigger(self._context)


class RootLuRamp_generatorApproachTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger.stop'


class RootLuRamp_generatorApproachTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger.abort'


class RootLuRamp_generatorApproachTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger.prepare'


class RootLuRamp_generatorApproachTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger.start'


class RootLuRamp_generatorApproachTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.trigger'
        self.start = RootLuRamp_generatorApproachTriggerStart(self._context)
        self.prepare = RootLuRamp_generatorApproachTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorApproachTriggerAbort(self._context)
        self.stop = RootLuRamp_generatorApproachTriggerStop(self._context)


class RootLuRamp_generatorApproachAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_absolute'


class RootLuRamp_generatorApproachAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_speed'


class RootLuRamp_generatorApproachAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.upper_limit'


class RootLuRamp_generatorApproachAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_time'


class RootLuRamp_generatorApproachAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorApproachAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.moving_mode'
        self.enum = RootLuRamp_generatorApproachAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorApproachAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorApproachAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.status'
        self.enum = RootLuRamp_generatorApproachAttributeStatusEnum(self._context)


class RootLuRamp_generatorApproachAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.current_value'


class RootLuRamp_generatorApproachAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.approach.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.approach.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorApproachAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorApproachAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorApproachAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.lower_limit'


class RootLuRamp_generatorApproachAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute.end_value_relative'


class RootLuRamp_generatorApproachAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.attribute'
        self.end_value_relative = RootLuRamp_generatorApproachAttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorApproachAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorApproachAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorApproachAttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorApproachAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorApproachAttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorApproachAttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorApproachAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorApproachAttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorApproachAttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorApproachBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.busy.is_moving'


class RootLuRamp_generatorApproachBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach.busy'
        self.is_moving = RootLuRamp_generatorApproachBusyIs_moving(self._context)


class RootLuRamp_generatorApproach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.approach'
        self.busy = RootLuRamp_generatorApproachBusy(self._context)
        self.attribute = RootLuRamp_generatorApproachAttribute(self._context)
        self.trigger = RootLuRamp_generatorApproachTrigger(self._context)


class RootLuRamp_generatorTip_voltageTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger.stop'


class RootLuRamp_generatorTip_voltageTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger.abort'


class RootLuRamp_generatorTip_voltageTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger.prepare'


class RootLuRamp_generatorTip_voltageTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger.start'


class RootLuRamp_generatorTip_voltageTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.trigger'
        self.start = RootLuRamp_generatorTip_voltageTriggerStart(self._context)
        self.prepare = RootLuRamp_generatorTip_voltageTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorTip_voltageTriggerAbort(self._context)
        self.stop = RootLuRamp_generatorTip_voltageTriggerStop(self._context)


class RootLuRamp_generatorTip_voltageAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_absolute'


class RootLuRamp_generatorTip_voltageAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_speed'


class RootLuRamp_generatorTip_voltageAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.upper_limit'


class RootLuRamp_generatorTip_voltageAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_time'


class RootLuRamp_generatorTip_voltageAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorTip_voltageAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.moving_mode'
        self.enum = RootLuRamp_generatorTip_voltageAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorTip_voltageAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorTip_voltageAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.status'
        self.enum = RootLuRamp_generatorTip_voltageAttributeStatusEnum(self._context)


class RootLuRamp_generatorTip_voltageAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.current_value'


class RootLuRamp_generatorTip_voltageAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.tip_voltage.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorTip_voltageAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorTip_voltageAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorTip_voltageAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.lower_limit'


class RootLuRamp_generatorTip_voltageAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute.end_value_relative'


class RootLuRamp_generatorTip_voltageAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.attribute'
        self.end_value_relative = RootLuRamp_generatorTip_voltageAttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorTip_voltageAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorTip_voltageAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorTip_voltageAttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorTip_voltageAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorTip_voltageAttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorTip_voltageAttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorTip_voltageAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorTip_voltageAttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorTip_voltageAttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorTip_voltageBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.busy.is_moving'


class RootLuRamp_generatorTip_voltageBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage.busy'
        self.is_moving = RootLuRamp_generatorTip_voltageBusyIs_moving(self._context)


class RootLuRamp_generatorTip_voltage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.tip_voltage'
        self.busy = RootLuRamp_generatorTip_voltageBusy(self._context)
        self.attribute = RootLuRamp_generatorTip_voltageAttribute(self._context)
        self.trigger = RootLuRamp_generatorTip_voltageTrigger(self._context)


class RootLuRamp_generatorPlane_zTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger.stop'


class RootLuRamp_generatorPlane_zTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger.abort'


class RootLuRamp_generatorPlane_zTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger.prepare'


class RootLuRamp_generatorPlane_zTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger.start'


class RootLuRamp_generatorPlane_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.trigger'
        self.start = RootLuRamp_generatorPlane_zTriggerStart(self._context)
        self.prepare = RootLuRamp_generatorPlane_zTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorPlane_zTriggerAbort(self._context)
        self.stop = RootLuRamp_generatorPlane_zTriggerStop(self._context)


class RootLuRamp_generatorPlane_zAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_absolute'


class RootLuRamp_generatorPlane_zAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_speed'


class RootLuRamp_generatorPlane_zAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.upper_limit'


class RootLuRamp_generatorPlane_zAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_time'


class RootLuRamp_generatorPlane_zAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorPlane_zAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.moving_mode'
        self.enum = RootLuRamp_generatorPlane_zAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorPlane_zAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorPlane_zAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.status'
        self.enum = RootLuRamp_generatorPlane_zAttributeStatusEnum(self._context)


class RootLuRamp_generatorPlane_zAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.current_value'


class RootLuRamp_generatorPlane_zAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.plane_z.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorPlane_zAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorPlane_zAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorPlane_zAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.lower_limit'


class RootLuRamp_generatorPlane_zAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute.end_value_relative'


class RootLuRamp_generatorPlane_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.attribute'
        self.end_value_relative = RootLuRamp_generatorPlane_zAttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorPlane_zAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorPlane_zAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorPlane_zAttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorPlane_zAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorPlane_zAttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorPlane_zAttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorPlane_zAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorPlane_zAttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorPlane_zAttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorPlane_zBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.busy.is_moving'


class RootLuRamp_generatorPlane_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z.busy'
        self.is_moving = RootLuRamp_generatorPlane_zBusyIs_moving(self._context)


class RootLuRamp_generatorPlane_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.plane_z'
        self.busy = RootLuRamp_generatorPlane_zBusy(self._context)
        self.attribute = RootLuRamp_generatorPlane_zAttribute(self._context)
        self.trigger = RootLuRamp_generatorPlane_zTrigger(self._context)


class RootLuRamp_generatorUser4TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger.stop'


class RootLuRamp_generatorUser4TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger.abort'


class RootLuRamp_generatorUser4TriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger.prepare'


class RootLuRamp_generatorUser4TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger.start'


class RootLuRamp_generatorUser4Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.trigger'
        self.start = RootLuRamp_generatorUser4TriggerStart(self._context)
        self.prepare = RootLuRamp_generatorUser4TriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorUser4TriggerAbort(self._context)
        self.stop = RootLuRamp_generatorUser4TriggerStop(self._context)


class RootLuRamp_generatorUser4AttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_absolute'


class RootLuRamp_generatorUser4AttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_speed'


class RootLuRamp_generatorUser4AttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.upper_limit'


class RootLuRamp_generatorUser4AttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_time'


class RootLuRamp_generatorUser4AttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorUser4AttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.moving_mode'
        self.enum = RootLuRamp_generatorUser4AttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorUser4AttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorUser4AttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.status'
        self.enum = RootLuRamp_generatorUser4AttributeStatusEnum(self._context)


class RootLuRamp_generatorUser4AttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.current_value'


class RootLuRamp_generatorUser4AttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.user4.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.user4.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorUser4AttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorUser4AttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorUser4AttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.lower_limit'


class RootLuRamp_generatorUser4AttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute.end_value_relative'


class RootLuRamp_generatorUser4Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.attribute'
        self.end_value_relative = RootLuRamp_generatorUser4AttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorUser4AttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorUser4AttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorUser4AttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorUser4AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorUser4AttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorUser4AttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorUser4AttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorUser4AttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorUser4AttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorUser4BusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.busy.is_moving'


class RootLuRamp_generatorUser4Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4.busy'
        self.is_moving = RootLuRamp_generatorUser4BusyIs_moving(self._context)


class RootLuRamp_generatorUser4(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.user4'
        self.busy = RootLuRamp_generatorUser4Busy(self._context)
        self.attribute = RootLuRamp_generatorUser4Attribute(self._context)
        self.trigger = RootLuRamp_generatorUser4Trigger(self._context)


class RootLuRamp_generatorVirtual2TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger.stop'


class RootLuRamp_generatorVirtual2TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger.abort'


class RootLuRamp_generatorVirtual2TriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger.prepare'


class RootLuRamp_generatorVirtual2TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger.start'


class RootLuRamp_generatorVirtual2Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.trigger'
        self.start = RootLuRamp_generatorVirtual2TriggerStart(self._context)
        self.prepare = RootLuRamp_generatorVirtual2TriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorVirtual2TriggerAbort(self._context)
        self.stop = RootLuRamp_generatorVirtual2TriggerStop(self._context)


class RootLuRamp_generatorVirtual2AttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_absolute'


class RootLuRamp_generatorVirtual2AttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_speed'


class RootLuRamp_generatorVirtual2AttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.upper_limit'


class RootLuRamp_generatorVirtual2AttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_time'


class RootLuRamp_generatorVirtual2AttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorVirtual2AttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.moving_mode'
        self.enum = RootLuRamp_generatorVirtual2AttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorVirtual2AttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorVirtual2AttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.status'
        self.enum = RootLuRamp_generatorVirtual2AttributeStatusEnum(self._context)


class RootLuRamp_generatorVirtual2AttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.current_value'


class RootLuRamp_generatorVirtual2AttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual2.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorVirtual2AttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorVirtual2AttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorVirtual2AttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.lower_limit'


class RootLuRamp_generatorVirtual2AttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute.end_value_relative'


class RootLuRamp_generatorVirtual2Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.attribute'
        self.end_value_relative = RootLuRamp_generatorVirtual2AttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual2AttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual2AttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorVirtual2AttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorVirtual2AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual2AttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorVirtual2AttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual2AttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual2AttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual2AttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorVirtual2BusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.busy.is_moving'


class RootLuRamp_generatorVirtual2Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2.busy'
        self.is_moving = RootLuRamp_generatorVirtual2BusyIs_moving(self._context)


class RootLuRamp_generatorVirtual2(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual2'
        self.busy = RootLuRamp_generatorVirtual2Busy(self._context)
        self.attribute = RootLuRamp_generatorVirtual2Attribute(self._context)
        self.trigger = RootLuRamp_generatorVirtual2Trigger(self._context)


class RootLuRamp_generatorAlternate_zTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger.stop'


class RootLuRamp_generatorAlternate_zTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger.abort'


class RootLuRamp_generatorAlternate_zTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger.prepare'


class RootLuRamp_generatorAlternate_zTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger.start'


class RootLuRamp_generatorAlternate_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.trigger'
        self.start = RootLuRamp_generatorAlternate_zTriggerStart(self._context)
        self.prepare = RootLuRamp_generatorAlternate_zTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorAlternate_zTriggerAbort(self._context)
        self.stop = RootLuRamp_generatorAlternate_zTriggerStop(self._context)


class RootLuRamp_generatorAlternate_zAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_absolute'


class RootLuRamp_generatorAlternate_zAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_speed'


class RootLuRamp_generatorAlternate_zAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.upper_limit'


class RootLuRamp_generatorAlternate_zAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_time'


class RootLuRamp_generatorAlternate_zAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorAlternate_zAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.moving_mode'
        self.enum = RootLuRamp_generatorAlternate_zAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorAlternate_zAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorAlternate_zAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.status'
        self.enum = RootLuRamp_generatorAlternate_zAttributeStatusEnum(self._context)


class RootLuRamp_generatorAlternate_zAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.current_value'


class RootLuRamp_generatorAlternate_zAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.alternate_z.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorAlternate_zAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorAlternate_zAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorAlternate_zAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.lower_limit'


class RootLuRamp_generatorAlternate_zAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute.end_value_relative'


class RootLuRamp_generatorAlternate_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.attribute'
        self.end_value_relative = RootLuRamp_generatorAlternate_zAttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorAlternate_zAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorAlternate_zAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorAlternate_zAttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorAlternate_zAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorAlternate_zAttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorAlternate_zAttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorAlternate_zAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorAlternate_zAttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorAlternate_zAttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorAlternate_zBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.busy.is_moving'


class RootLuRamp_generatorAlternate_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z.busy'
        self.is_moving = RootLuRamp_generatorAlternate_zBusyIs_moving(self._context)


class RootLuRamp_generatorAlternate_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.alternate_z'
        self.busy = RootLuRamp_generatorAlternate_zBusy(self._context)
        self.attribute = RootLuRamp_generatorAlternate_zAttribute(self._context)
        self.trigger = RootLuRamp_generatorAlternate_zTrigger(self._context)


class RootLuRamp_generatorVirtual0TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger.stop'


class RootLuRamp_generatorVirtual0TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger.abort'


class RootLuRamp_generatorVirtual0TriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger.prepare'


class RootLuRamp_generatorVirtual0TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger.start'


class RootLuRamp_generatorVirtual0Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.trigger'
        self.start = RootLuRamp_generatorVirtual0TriggerStart(self._context)
        self.prepare = RootLuRamp_generatorVirtual0TriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorVirtual0TriggerAbort(self._context)
        self.stop = RootLuRamp_generatorVirtual0TriggerStop(self._context)


class RootLuRamp_generatorVirtual0AttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_absolute'


class RootLuRamp_generatorVirtual0AttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_speed'


class RootLuRamp_generatorVirtual0AttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.upper_limit'


class RootLuRamp_generatorVirtual0AttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_time'


class RootLuRamp_generatorVirtual0AttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorVirtual0AttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.moving_mode'
        self.enum = RootLuRamp_generatorVirtual0AttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorVirtual0AttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorVirtual0AttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.status'
        self.enum = RootLuRamp_generatorVirtual0AttributeStatusEnum(self._context)


class RootLuRamp_generatorVirtual0AttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.current_value'


class RootLuRamp_generatorVirtual0AttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual0.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorVirtual0AttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorVirtual0AttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorVirtual0AttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.lower_limit'


class RootLuRamp_generatorVirtual0AttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute.end_value_relative'


class RootLuRamp_generatorVirtual0Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.attribute'
        self.end_value_relative = RootLuRamp_generatorVirtual0AttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual0AttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual0AttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorVirtual0AttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorVirtual0AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual0AttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorVirtual0AttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual0AttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual0AttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual0AttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorVirtual0BusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.busy.is_moving'


class RootLuRamp_generatorVirtual0Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0.busy'
        self.is_moving = RootLuRamp_generatorVirtual0BusyIs_moving(self._context)


class RootLuRamp_generatorVirtual0(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual0'
        self.busy = RootLuRamp_generatorVirtual0Busy(self._context)
        self.attribute = RootLuRamp_generatorVirtual0Attribute(self._context)
        self.trigger = RootLuRamp_generatorVirtual0Trigger(self._context)


class RootLuRamp_generatorVirtual1TriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger.stop'


class RootLuRamp_generatorVirtual1TriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger.abort'


class RootLuRamp_generatorVirtual1TriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger.prepare'


class RootLuRamp_generatorVirtual1TriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger.start'


class RootLuRamp_generatorVirtual1Trigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.trigger'
        self.start = RootLuRamp_generatorVirtual1TriggerStart(self._context)
        self.prepare = RootLuRamp_generatorVirtual1TriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorVirtual1TriggerAbort(self._context)
        self.stop = RootLuRamp_generatorVirtual1TriggerStop(self._context)


class RootLuRamp_generatorVirtual1AttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_absolute'


class RootLuRamp_generatorVirtual1AttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_speed'


class RootLuRamp_generatorVirtual1AttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.upper_limit'


class RootLuRamp_generatorVirtual1AttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_time'


class RootLuRamp_generatorVirtual1AttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorVirtual1AttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.moving_mode'
        self.enum = RootLuRamp_generatorVirtual1AttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorVirtual1AttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorVirtual1AttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.status'
        self.enum = RootLuRamp_generatorVirtual1AttributeStatusEnum(self._context)


class RootLuRamp_generatorVirtual1AttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.current_value'


class RootLuRamp_generatorVirtual1AttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.virtual1.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorVirtual1AttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorVirtual1AttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorVirtual1AttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.lower_limit'


class RootLuRamp_generatorVirtual1AttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute.end_value_relative'


class RootLuRamp_generatorVirtual1Attribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.attribute'
        self.end_value_relative = RootLuRamp_generatorVirtual1AttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorVirtual1AttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorVirtual1AttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorVirtual1AttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorVirtual1AttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorVirtual1AttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorVirtual1AttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorVirtual1AttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorVirtual1AttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorVirtual1AttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorVirtual1BusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.busy.is_moving'


class RootLuRamp_generatorVirtual1Busy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1.busy'
        self.is_moving = RootLuRamp_generatorVirtual1BusyIs_moving(self._context)


class RootLuRamp_generatorVirtual1(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.virtual1'
        self.busy = RootLuRamp_generatorVirtual1Busy(self._context)
        self.attribute = RootLuRamp_generatorVirtual1Attribute(self._context)
        self.trigger = RootLuRamp_generatorVirtual1Trigger(self._context)


class RootLuRamp_generatorPosition_yTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger.stop'


class RootLuRamp_generatorPosition_yTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger.abort'


class RootLuRamp_generatorPosition_yTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger.prepare'


class RootLuRamp_generatorPosition_yTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger.start'


class RootLuRamp_generatorPosition_yTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.trigger'
        self.start = RootLuRamp_generatorPosition_yTriggerStart(self._context)
        self.prepare = RootLuRamp_generatorPosition_yTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorPosition_yTriggerAbort(self._context)
        self.stop = RootLuRamp_generatorPosition_yTriggerStop(self._context)


class RootLuRamp_generatorPosition_yAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_absolute'


class RootLuRamp_generatorPosition_yAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_speed'


class RootLuRamp_generatorPosition_yAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.upper_limit'


class RootLuRamp_generatorPosition_yAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_time'


class RootLuRamp_generatorPosition_yAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorPosition_yAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.moving_mode'
        self.enum = RootLuRamp_generatorPosition_yAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorPosition_yAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorPosition_yAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.status'
        self.enum = RootLuRamp_generatorPosition_yAttributeStatusEnum(self._context)


class RootLuRamp_generatorPosition_yAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.current_value'


class RootLuRamp_generatorPosition_yAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.position_y.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.position_y.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorPosition_yAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorPosition_yAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorPosition_yAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.lower_limit'


class RootLuRamp_generatorPosition_yAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute.end_value_relative'


class RootLuRamp_generatorPosition_yAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.attribute'
        self.end_value_relative = RootLuRamp_generatorPosition_yAttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorPosition_yAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorPosition_yAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorPosition_yAttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorPosition_yAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorPosition_yAttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorPosition_yAttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorPosition_yAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorPosition_yAttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorPosition_yAttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorPosition_yBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.busy.is_moving'


class RootLuRamp_generatorPosition_yBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y.busy'
        self.is_moving = RootLuRamp_generatorPosition_yBusyIs_moving(self._context)


class RootLuRamp_generatorPosition_y(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.position_y'
        self.busy = RootLuRamp_generatorPosition_yBusy(self._context)
        self.attribute = RootLuRamp_generatorPosition_yAttribute(self._context)
        self.trigger = RootLuRamp_generatorPosition_yTrigger(self._context)


class RootLuRamp_generatorCtrl_zTriggerStop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger.stop'


class RootLuRamp_generatorCtrl_zTriggerAbort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger.abort'


class RootLuRamp_generatorCtrl_zTriggerPrepare(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger.prepare'


class RootLuRamp_generatorCtrl_zTriggerStart(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger.start'


class RootLuRamp_generatorCtrl_zTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.trigger'
        self.start = RootLuRamp_generatorCtrl_zTriggerStart(self._context)
        self.prepare = RootLuRamp_generatorCtrl_zTriggerPrepare(self._context)
        self.abort = RootLuRamp_generatorCtrl_zTriggerAbort(self._context)
        self.stop = RootLuRamp_generatorCtrl_zTriggerStop(self._context)


class RootLuRamp_generatorCtrl_zAttributeEnd_value_absolute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_absolute'


class RootLuRamp_generatorCtrl_zAttributeMoving_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_speed'


class RootLuRamp_generatorCtrl_zAttributeUpper_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.upper_limit'


class RootLuRamp_generatorCtrl_zAttributeMoving_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_time'


class RootLuRamp_generatorCtrl_zAttributeMoving_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum'

    @property
    def fix_speed(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum.fix_speed'))

    @fix_speed.setter
    def fix_speed(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum.fix_speed', int(new_val))

    @property
    def fix_time(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum.fix_time'))

    @fix_time.setter
    def fix_time(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.moving_mode.enum.fix_time', int(new_val))


class RootLuRamp_generatorCtrl_zAttributeMoving_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.moving_mode'
        self.enum = RootLuRamp_generatorCtrl_zAttributeMoving_modeEnum(self._context)


class RootLuRamp_generatorCtrl_zAttributeStatusEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.status.enum'

    @property
    def stopped_by_external_event(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum.stopped_by_external_event'))

    @stopped_by_external_event.setter
    def stopped_by_external_event(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum.stopped_by_external_event', int(new_val))

    @property
    def reached_upper_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum.reached_upper_limit'))

    @reached_upper_limit.setter
    def reached_upper_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum.reached_upper_limit', int(new_val))

    @property
    def reached_endposition(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum.reached_endposition'))

    @reached_endposition.setter
    def reached_endposition(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum.reached_endposition', int(new_val))

    @property
    def reached_lower_limit(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum.reached_lower_limit'))

    @reached_lower_limit.setter
    def reached_lower_limit(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum.reached_lower_limit', int(new_val))

    @property
    def is_moving(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.status.enum.is_moving'))

    @is_moving.setter
    def is_moving(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.status.enum.is_moving', int(new_val))


class RootLuRamp_generatorCtrl_zAttributeStatus(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.status'
        self.enum = RootLuRamp_generatorCtrl_zAttributeStatusEnum(self._context)


class RootLuRamp_generatorCtrl_zAttributeCurrent_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.current_value'


class RootLuRamp_generatorCtrl_zAttributeEnd_value_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum'

    @property
    def move_to_absolute(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum.move_to_absolute'))

    @move_to_absolute.setter
    def move_to_absolute(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum.move_to_absolute', int(new_val))

    @property
    def move_relative(self) -> int:
        return int(self._context.get('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum.move_relative'))

    @move_relative.setter
    def move_relative(self, new_val:int):
        self._context.set('root.lu.ramp_generator.ctrl_z.attribute.end_value_mode.enum.move_relative', int(new_val))


class RootLuRamp_generatorCtrl_zAttributeEnd_value_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_mode'
        self.enum = RootLuRamp_generatorCtrl_zAttributeEnd_value_modeEnum(self._context)


class RootLuRamp_generatorCtrl_zAttributeLower_limit(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.lower_limit'


class RootLuRamp_generatorCtrl_zAttributeEnd_value_relative(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute.end_value_relative'


class RootLuRamp_generatorCtrl_zAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.attribute'
        self.end_value_relative = RootLuRamp_generatorCtrl_zAttributeEnd_value_relative(self._context)
        self.lower_limit = RootLuRamp_generatorCtrl_zAttributeLower_limit(self._context)
        self.end_value_mode = RootLuRamp_generatorCtrl_zAttributeEnd_value_mode(self._context)
        self.current_value = RootLuRamp_generatorCtrl_zAttributeCurrent_value(self._context)
        self.status = RootLuRamp_generatorCtrl_zAttributeStatus(self._context)
        self.moving_mode = RootLuRamp_generatorCtrl_zAttributeMoving_mode(self._context)
        self.moving_time = RootLuRamp_generatorCtrl_zAttributeMoving_time(self._context)
        self.upper_limit = RootLuRamp_generatorCtrl_zAttributeUpper_limit(self._context)
        self.moving_speed = RootLuRamp_generatorCtrl_zAttributeMoving_speed(self._context)
        self.end_value_absolute = RootLuRamp_generatorCtrl_zAttributeEnd_value_absolute(self._context)


class RootLuRamp_generatorCtrl_zBusyIs_moving(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.busy.is_moving'


class RootLuRamp_generatorCtrl_zBusy(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z.busy'
        self.is_moving = RootLuRamp_generatorCtrl_zBusyIs_moving(self._context)


class RootLuRamp_generatorCtrl_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator.ctrl_z'
        self.busy = RootLuRamp_generatorCtrl_zBusy(self._context)
        self.attribute = RootLuRamp_generatorCtrl_zAttribute(self._context)
        self.trigger = RootLuRamp_generatorCtrl_zTrigger(self._context)


class RootLuRamp_generator(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.ramp_generator'
        self.ctrl_z = RootLuRamp_generatorCtrl_z(self._context)
        self.position_y = RootLuRamp_generatorPosition_y(self._context)
        self.virtual1 = RootLuRamp_generatorVirtual1(self._context)
        self.virtual0 = RootLuRamp_generatorVirtual0(self._context)
        self.alternate_z = RootLuRamp_generatorAlternate_z(self._context)
        self.virtual2 = RootLuRamp_generatorVirtual2(self._context)
        self.user4 = RootLuRamp_generatorUser4(self._context)
        self.plane_z = RootLuRamp_generatorPlane_z(self._context)
        self.tip_voltage = RootLuRamp_generatorTip_voltage(self._context)
        self.approach = RootLuRamp_generatorApproach(self._context)
        self.position_x = RootLuRamp_generatorPosition_x(self._context)
        self.user1 = RootLuRamp_generatorUser1(self._context)
        self.test = RootLuRamp_generatorTest(self._context)
        self.user2 = RootLuRamp_generatorUser2(self._context)


class RootLuLithoInstanceTriggerMake_pause(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.trigger.make_pause'


class RootLuLithoInstanceTriggerFirst_cmd_item(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.trigger.first_cmd_item'


class RootLuLithoInstanceTriggerUser_abort(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.trigger.user_abort'


class RootLuLithoInstanceTriggerNext_cmd_item(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.trigger.next_cmd_item'


class RootLuLithoInstanceTriggerStart_sequence(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.trigger.start_sequence'


class RootLuLithoInstanceTriggerEnd_sequence(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.trigger.end_sequence'


class RootLuLithoInstanceTriggerMove_to_abs_xy_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.trigger.move_to_abs_xy_pos'


class RootLuLithoInstanceTriggerMove_to_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.trigger.move_to_z'


class RootLuLithoInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.trigger'
        self.move_to_z = RootLuLithoInstanceTriggerMove_to_z(self._context)
        self.move_to_abs_xy_pos = RootLuLithoInstanceTriggerMove_to_abs_xy_pos(self._context)
        self.end_sequence = RootLuLithoInstanceTriggerEnd_sequence(self._context)
        self.start_sequence = RootLuLithoInstanceTriggerStart_sequence(self._context)
        self.next_cmd_item = RootLuLithoInstanceTriggerNext_cmd_item(self._context)
        self.user_abort = RootLuLithoInstanceTriggerUser_abort(self._context)
        self.first_cmd_item = RootLuLithoInstanceTriggerFirst_cmd_item(self._context)
        self.make_pause = RootLuLithoInstanceTriggerMake_pause(self._context)


class RootLuLithoInstanceAttributeOp_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.op_mode.enum'

    @property
    def user(self) -> int:
        return int(self._context.get('root.lu.litho.instance.attribute.op_mode.enum.user'))

    @user.setter
    def user(self, new_val:int):
        self._context.set('root.lu.litho.instance.attribute.op_mode.enum.user', int(new_val))

    @property
    def dynamic_afm(self) -> int:
        return int(self._context.get('root.lu.litho.instance.attribute.op_mode.enum.dynamic_afm'))

    @dynamic_afm.setter
    def dynamic_afm(self, new_val:int):
        self._context.set('root.lu.litho.instance.attribute.op_mode.enum.dynamic_afm', int(new_val))

    @property
    def static_afm(self) -> int:
        return int(self._context.get('root.lu.litho.instance.attribute.op_mode.enum.static_afm'))

    @static_afm.setter
    def static_afm(self, new_val:int):
        self._context.set('root.lu.litho.instance.attribute.op_mode.enum.static_afm', int(new_val))

    @property
    def z_modulation(self) -> int:
        return int(self._context.get('root.lu.litho.instance.attribute.op_mode.enum.z_modulation'))

    @z_modulation.setter
    def z_modulation(self, new_val:int):
        self._context.set('root.lu.litho.instance.attribute.op_mode.enum.z_modulation', int(new_val))

    @property
    def stm(self) -> int:
        return int(self._context.get('root.lu.litho.instance.attribute.op_mode.enum.stm'))

    @stm.setter
    def stm(self, new_val:int):
        self._context.set('root.lu.litho.instance.attribute.op_mode.enum.stm', int(new_val))


class RootLuLithoInstanceAttributeOp_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.op_mode'
        self.enum = RootLuLithoInstanceAttributeOp_modeEnum(self._context)


class RootLuLithoInstanceAttributeAbsolute_y_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.absolute_y_pos'


class RootLuLithoInstanceAttributeZ_move_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.z_move_speed'


class RootLuLithoInstanceAttributeMod_rel_value(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.mod_rel_value'


class RootLuLithoInstanceAttributeMove_z_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.move_z_pos'


class RootLuLithoInstanceAttributeXy_move_speed(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.xy_move_speed'


class RootLuLithoInstanceAttributeAbsolute_x_pos(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.absolute_x_pos'


class RootLuLithoInstanceAttributePause_time(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute.pause_time'


class RootLuLithoInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance.attribute'
        self.pause_time = RootLuLithoInstanceAttributePause_time(self._context)
        self.absolute_x_pos = RootLuLithoInstanceAttributeAbsolute_x_pos(self._context)
        self.xy_move_speed = RootLuLithoInstanceAttributeXy_move_speed(self._context)
        self.move_z_pos = RootLuLithoInstanceAttributeMove_z_pos(self._context)
        self.mod_rel_value = RootLuLithoInstanceAttributeMod_rel_value(self._context)
        self.z_move_speed = RootLuLithoInstanceAttributeZ_move_speed(self._context)
        self.absolute_y_pos = RootLuLithoInstanceAttributeAbsolute_y_pos(self._context)
        self.op_mode = RootLuLithoInstanceAttributeOp_mode(self._context)


class RootLuLithoInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho.instance'
        self.attribute = RootLuLithoInstanceAttribute(self._context)
        self.trigger = RootLuLithoInstanceTrigger(self._context)


class RootLuLitho(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.litho'
        self.instance = RootLuLithoInstance(self._context)


class RootLuIsostageInstanceTriggerUpdate_settings(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.trigger.update_settings'


class RootLuIsostageInstanceTriggerClear_event_counter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.trigger.clear_event_counter'


class RootLuIsostageInstanceTriggerTest_connection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.trigger.test_connection'


class RootLuIsostageInstanceTriggerSetup_event_counter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.trigger.setup_event_counter'


class RootLuIsostageInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.trigger'
        self.setup_event_counter = RootLuIsostageInstanceTriggerSetup_event_counter(self._context)
        self.test_connection = RootLuIsostageInstanceTriggerTest_connection(self._context)
        self.clear_event_counter = RootLuIsostageInstanceTriggerClear_event_counter(self._context)
        self.update_settings = RootLuIsostageInstanceTriggerUpdate_settings(self._context)


class RootLuIsostageInstanceAttributeEvent_counter(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.event_counter'


class RootLuIsostageInstanceAttributeIs_connected(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.is_connected'


class RootLuIsostageInstanceAttributeOverload_sensitivity(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.overload_sensitivity'


class RootLuIsostageInstanceAttributeIsolation_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.isolation_mode.enum'

    @property
    def off_or_defined_by_user_switch(self) -> int:
        return int(self._context.get('root.lu.isostage.instance.attribute.isolation_mode.enum.off_or_defined_by_user_switch'))

    @off_or_defined_by_user_switch.setter
    def off_or_defined_by_user_switch(self, new_val:int):
        self._context.set('root.lu.isostage.instance.attribute.isolation_mode.enum.off_or_defined_by_user_switch', int(new_val))

    @property
    def active(self) -> int:
        return int(self._context.get('root.lu.isostage.instance.attribute.isolation_mode.enum.active'))

    @active.setter
    def active(self, new_val:int):
        self._context.set('root.lu.isostage.instance.attribute.isolation_mode.enum.active', int(new_val))


class RootLuIsostageInstanceAttributeIsolation_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute.isolation_mode'
        self.enum = RootLuIsostageInstanceAttributeIsolation_modeEnum(self._context)


class RootLuIsostageInstanceAttribute(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance.attribute'
        self.isolation_mode = RootLuIsostageInstanceAttributeIsolation_mode(self._context)
        self.overload_sensitivity = RootLuIsostageInstanceAttributeOverload_sensitivity(self._context)
        self.is_connected = RootLuIsostageInstanceAttributeIs_connected(self._context)
        self.event_counter = RootLuIsostageInstanceAttributeEvent_counter(self._context)


class RootLuIsostageInstance(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage.instance'
        self.attribute = RootLuIsostageInstanceAttribute(self._context)
        self.trigger = RootLuIsostageInstanceTrigger(self._context)


class RootLuIsostage(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.isostage'
        self.instance = RootLuIsostageInstance(self._context)


class RootLuSystemInstanceTriggerExit_approach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_approach'


class RootLuSystemInstanceTriggerEntry_idle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_idle'


class RootLuSystemInstanceTriggerExit_scan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_scan'


class RootLuSystemInstanceTriggerMotor_move(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.motor_move'


class RootLuSystemInstanceTriggerExit_uncal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_uncal'


class RootLuSystemInstanceTriggerExit_macro_cmd(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_macro_cmd'


class RootLuSystemInstanceTriggerEntry_approach(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_approach'


class RootLuSystemInstanceTriggerMotor_reference_and_move_back(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.motor_reference_and_move_back'


class RootLuSystemInstanceTriggerMotor_reference(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.motor_reference'


class RootLuSystemInstanceTriggerMotor_set_pos_zero(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.motor_set_pos_zero'


class RootLuSystemInstanceTriggerMotor_step(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.motor_step'


class RootLuSystemInstanceTriggerMotor_stop(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.motor_stop'


class RootLuSystemInstanceTriggerStart_system_startup(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.start_system_startup'


class RootLuSystemInstanceTriggerForce_motor_pos_update(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.force_motor_pos_update'


class RootLuSystemInstanceTriggerExit_idle(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_idle'


class RootLuSystemInstanceTriggerLevel_scanhead(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.level_scanhead'


class RootLuSystemInstanceTriggerEntry_scan(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_scan'


class RootLuSystemInstanceTriggerEntry_uncal(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_uncal'


class RootLuSystemInstanceTriggerEntry_macro_cmd(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_macro_cmd'


class RootLuSystemInstanceTriggerEntry_litho(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_litho'


class RootLuSystemInstanceTriggerExit_litho(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_litho'


class RootLuSystemInstanceTriggerExit_spec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.exit_spec'


class RootLuSystemInstanceTriggerOffset_xyz(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.offset_xyz'


class RootLuSystemInstanceTriggerEntry_spec(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger.entry_spec'


class RootLuSystemInstanceTrigger(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.trigger'
        self.entry_spec = RootLuSystemInstanceTriggerEntry_spec(self._context)
        self.offset_xyz = RootLuSystemInstanceTriggerOffset_xyz(self._context)
        self.exit_spec = RootLuSystemInstanceTriggerExit_spec(self._context)
        self.exit_litho = RootLuSystemInstanceTriggerExit_litho(self._context)
        self.entry_litho = RootLuSystemInstanceTriggerEntry_litho(self._context)
        self.entry_macro_cmd = RootLuSystemInstanceTriggerEntry_macro_cmd(self._context)
        self.entry_uncal = RootLuSystemInstanceTriggerEntry_uncal(self._context)
        self.entry_scan = RootLuSystemInstanceTriggerEntry_scan(self._context)
        self.level_scanhead = RootLuSystemInstanceTriggerLevel_scanhead(self._context)
        self.exit_idle = RootLuSystemInstanceTriggerExit_idle(self._context)
        self.force_motor_pos_update = RootLuSystemInstanceTriggerForce_motor_pos_update(self._context)
        self.start_system_startup = RootLuSystemInstanceTriggerStart_system_startup(self._context)
        self.motor_stop = RootLuSystemInstanceTriggerMotor_stop(self._context)
        self.motor_step = RootLuSystemInstanceTriggerMotor_step(self._context)
        self.motor_set_pos_zero = RootLuSystemInstanceTriggerMotor_set_pos_zero(self._context)
        self.motor_reference = RootLuSystemInstanceTriggerMotor_reference(self._context)
        self.motor_reference_and_move_back = RootLuSystemInstanceTriggerMotor_reference_and_move_back(self._context)
        self.entry_approach = RootLuSystemInstanceTriggerEntry_approach(self._context)
        self.exit_macro_cmd = RootLuSystemInstanceTriggerExit_macro_cmd(self._context)
        self.exit_uncal = RootLuSystemInstanceTriggerExit_uncal(self._context)
        self.motor_move = RootLuSystemInstanceTriggerMotor_move(self._context)
        self.exit_scan = RootLuSystemInstanceTriggerExit_scan(self._context)
        self.entry_idle = RootLuSystemInstanceTriggerEntry_idle(self._context)
        self.exit_approach = RootLuSystemInstanceTriggerExit_approach(self._context)


class RootLuSystemInstanceAttributeIdle_external_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_external_z'


class RootLuSystemInstanceAttributeMotor_selectionEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_selection.enum'

    @property
    def motor_b(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_b'))

    @motor_b.setter
    def motor_b(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_b', int(new_val))

    @property
    def motor_focus(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_focus'))

    @motor_focus.setter
    def motor_focus(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_focus', int(new_val))

    @property
    def motor_a(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_a'))

    @motor_a.setter
    def motor_a(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_a', int(new_val))

    @property
    def motor_approach(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_approach'))

    @motor_approach.setter
    def motor_approach(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_approach', int(new_val))

    @property
    def motor_photodiode_lateral(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_photodiode_lateral'))

    @motor_photodiode_lateral.setter
    def motor_photodiode_lateral(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_photodiode_lateral', int(new_val))

    @property
    def motor_c(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_c'))

    @motor_c.setter
    def motor_c(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_c', int(new_val))

    @property
    def motor_beam_deflection_y(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_beam_deflection_y'))

    @motor_beam_deflection_y.setter
    def motor_beam_deflection_y(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_beam_deflection_y', int(new_val))

    @property
    def motor_ptey(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_ptey'))

    @motor_ptey.setter
    def motor_ptey(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_ptey', int(new_val))

    @property
    def motor_beam_deflection_x(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_beam_deflection_x'))

    @motor_beam_deflection_x.setter
    def motor_beam_deflection_x(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_beam_deflection_x', int(new_val))

    @property
    def motor_lens_gimbal(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_lens_gimbal'))

    @motor_lens_gimbal.setter
    def motor_lens_gimbal(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_lens_gimbal', int(new_val))

    @property
    def motor_ptex(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_ptex'))

    @motor_ptex.setter
    def motor_ptex(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_ptex', int(new_val))

    @property
    def motor_photodiode_normal(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_selection.enum.motor_photodiode_normal'))

    @motor_photodiode_normal.setter
    def motor_photodiode_normal(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_selection.enum.motor_photodiode_normal', int(new_val))


class RootLuSystemInstanceAttributeMotor_selection(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_selection'
        self.enum = RootLuSystemInstanceAttributeMotor_selectionEnum(self._context)


class RootLuSystemInstanceAttributeSystem_stateEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.system_state.enum'

    @property
    def scan(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.scan'))

    @scan.setter
    def scan(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.scan', int(new_val))

    @property
    def litho(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.litho'))

    @litho.setter
    def litho(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.litho', int(new_val))

    @property
    def spec(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.spec'))

    @spec.setter
    def spec(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.spec', int(new_val))

    @property
    def approach(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.approach'))

    @approach.setter
    def approach(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.approach', int(new_val))

    @property
    def uncal(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.uncal'))

    @uncal.setter
    def uncal(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.uncal', int(new_val))

    @property
    def macro_cmd(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.macro_cmd'))

    @macro_cmd.setter
    def macro_cmd(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.macro_cmd', int(new_val))

    @property
    def internal(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.internal'))

    @internal.setter
    def internal(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.internal', int(new_val))

    @property
    def idle(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.system_state.enum.idle'))

    @idle.setter
    def idle(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.system_state.enum.idle', int(new_val))


class RootLuSystemInstanceAttributeSystem_state(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.system_state'
        self.enum = RootLuSystemInstanceAttributeSystem_stateEnum(self._context)


class RootLuSystemInstanceAttributeIdle_position_xy_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_xy_mode.enum'

    @property
    def image_center(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_xy_mode.enum.image_center'))

    @image_center.setter
    def image_center(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_xy_mode.enum.image_center', int(new_val))

    @property
    def keep_last_xy_pos(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_xy_mode.enum.keep_last_xy_pos'))

    @keep_last_xy_pos.setter
    def keep_last_xy_pos(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_xy_mode.enum.keep_last_xy_pos', int(new_val))


class RootLuSystemInstanceAttributeIdle_position_xy_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_xy_mode'
        self.enum = RootLuSystemInstanceAttributeIdle_position_xy_modeEnum(self._context)


class RootLuSystemInstanceAttributeMemory_block_available(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.memory_block_available'


class RootLuSystemInstanceAttributeHi_res_ch5_input(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.hi_res_ch5_input'


class RootLuSystemInstanceAttributeMotor_step_size(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_step_size'


class RootLuSystemInstanceAttributeIdle_position_z_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_z_mode.enum'

    @property
    def z_controller_active(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_z_mode.enum.z_controller_active'))

    @z_controller_active.setter
    def z_controller_active(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_z_mode.enum.z_controller_active', int(new_val))

    @property
    def keep_last_z_pos(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_z_mode.enum.keep_last_z_pos'))

    @keep_last_z_pos.setter
    def keep_last_z_pos(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_z_mode.enum.keep_last_z_pos', int(new_val))

    @property
    def retract_tip(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_z_mode.enum.retract_tip'))

    @retract_tip.setter
    def retract_tip(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_z_mode.enum.retract_tip', int(new_val))

    @property
    def absolute_z_pos(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_position_z_mode.enum.absolute_z_pos'))

    @absolute_z_pos.setter
    def absolute_z_pos(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_position_z_mode.enum.absolute_z_pos', int(new_val))


class RootLuSystemInstanceAttributeIdle_position_z_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_z_mode'
        self.enum = RootLuSystemInstanceAttributeIdle_position_z_modeEnum(self._context)


class RootLuSystemInstanceAttributeOp_mode_kpfm_enabledEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.op_mode_kpfm_enabled.enum'

    @property
    def disabled(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.op_mode_kpfm_enabled.enum.disabled'))

    @disabled.setter
    def disabled(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.op_mode_kpfm_enabled.enum.disabled', int(new_val))

    @property
    def enabled(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.op_mode_kpfm_enabled.enum.enabled'))

    @enabled.setter
    def enabled(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.op_mode_kpfm_enabled.enum.enabled', int(new_val))


class RootLuSystemInstanceAttributeOp_mode_kpfm_enabled(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.op_mode_kpfm_enabled'
        self.enum = RootLuSystemInstanceAttributeOp_mode_kpfm_enabledEnum(self._context)


class RootLuSystemInstanceAttributeMotor_move_directionEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_move_direction.enum'

    @property
    def negative(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_move_direction.enum.negative'))

    @negative.setter
    def negative(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_move_direction.enum.negative', int(new_val))

    @property
    def positive(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.motor_move_direction.enum.positive'))

    @positive.setter
    def positive(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.motor_move_direction.enum.positive', int(new_val))


class RootLuSystemInstanceAttributeMotor_move_direction(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.motor_move_direction'
        self.enum = RootLuSystemInstanceAttributeMotor_move_directionEnum(self._context)


class RootLuSystemInstanceAttributeMeasurement_environmentEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.measurement_environment.enum'

    @property
    def vacuum(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.measurement_environment.enum.vacuum'))

    @vacuum.setter
    def vacuum(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.measurement_environment.enum.vacuum', int(new_val))

    @property
    def air(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.measurement_environment.enum.air'))

    @air.setter
    def air(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.measurement_environment.enum.air', int(new_val))

    @property
    def liquid(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.measurement_environment.enum.liquid'))

    @liquid.setter
    def liquid(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.measurement_environment.enum.liquid', int(new_val))


class RootLuSystemInstanceAttributeMeasurement_environment(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.measurement_environment'
        self.enum = RootLuSystemInstanceAttributeMeasurement_environmentEnum(self._context)


class RootLuSystemInstanceAttributeIdle_position_z(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_position_z'


class RootLuSystemInstanceAttributeIdle_external_z_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_external_z_mode.enum'

    @property
    def z_controller_active(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_external_z_mode.enum.z_controller_active'))

    @z_controller_active.setter
    def z_controller_active(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_external_z_mode.enum.z_controller_active', int(new_val))

    @property
    def keep_last_z_pos(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_external_z_mode.enum.keep_last_z_pos'))

    @keep_last_z_pos.setter
    def keep_last_z_pos(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_external_z_mode.enum.keep_last_z_pos', int(new_val))

    @property
    def retract_tip(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_external_z_mode.enum.retract_tip'))

    @retract_tip.setter
    def retract_tip(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_external_z_mode.enum.retract_tip', int(new_val))

    @property
    def absolute_z_pos(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.idle_external_z_mode.enum.absolute_z_pos'))

    @absolute_z_pos.setter
    def absolute_z_pos(self, new_val:int):
        self._context.set('root.lu.system.instance.attribute.idle_external_z_mode.enum.absolute_z_pos', int(new_val))


class RootLuSystemInstanceAttributeIdle_external_z_mode(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.idle_external_z_mode'
        self.enum = RootLuSystemInstanceAttributeIdle_external_z_modeEnum(self._context)


class RootLuSystemInstanceAttributeOperating_modeEnum(wrap.CmdTreeNode):
    def __init__(self, context: 'StudioScriptContext'):
        super().__init__()
        self._context = context
        self._lua_tree_name = 'root.lu.system.instance.attribute.operating_mode.enum'

    @property
    def resistivity_map(self) -> int:
        return int(self._context.get('root.lu.system.instance.attribute.operating_mode.e