# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr
from synctera_client.models.event_type1 import EventType1

class Webhook(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    description: Optional[StrictStr] = Field(None, description="A description of what the webhook is used for")
    enabled_events: List[EventType1] = Field(..., description="A list of the events that will trigger the webhook")
    id: Optional[StrictStr] = Field(None, description="The unique ID of the webhook")
    is_enabled: StrictBool = Field(..., description="Set the webhook to be enabled or disabled")
    last_updated: Optional[datetime] = Field(None, description="Timestamp that this webhook was created or the last time any field was changed")
    metadata: Optional[constr(strict=True, max_length=1024)] = Field(None, description="Additional information stored to the webhook")
    url: constr(strict=True, max_length=1000) = Field(..., description="URL that the webhook will send request to")
    __properties = ["description", "enabled_events", "id", "is_enabled", "last_updated", "metadata", "url"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Webhook:
        """Create an instance of Webhook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "id",
                            "last_updated",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in enabled_events (list)
        _items = []
        if self.enabled_events:
            for _item in self.enabled_events:
                if _item:
                    _items.append(_item.to_dict())
            _dict['enabled_events'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Webhook:
        """Create an instance of Webhook from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Webhook.parse_obj(obj)

        _obj = Webhook.parse_obj({
            "description": obj.get("description"),
            "enabled_events": [EventType1.from_dict(_item) for _item in obj.get("enabled_events")] if obj.get("enabled_events") is not None else None,
            "id": obj.get("id"),
            "is_enabled": obj.get("is_enabled"),
            "last_updated": obj.get("last_updated"),
            "metadata": obj.get("metadata"),
            "url": obj.get("url")
        })
        return _obj

