# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class WatchlistSubscription(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    auto_renew: Optional[StrictBool] = Field(None, description="Whether this subscription should automatically renew when the subscription period is over (default: vendor-dependent). ")
    created: Optional[datetime] = Field(None, description="When this subscription was created")
    customer_consent: StrictBool = Field(..., description="Whether this customer has consented to being enrolled for watchlist monitoring ")
    id: Optional[StrictStr] = Field(None, description="Unique identifier for this subscription")
    period_end: Optional[date] = Field(None, description="The date when monitoring of this individual should end.")
    period_start: Optional[date] = Field(None, description="The date when monitoring of this individual should begin (default: today).")
    provider_subscription_id: Optional[StrictStr] = Field(None, description="External provider subscription id")
    status: Optional[StrictStr] = None
    __properties = ["auto_renew", "created", "customer_consent", "id", "period_end", "period_start", "provider_subscription_id", "status"]

    @validator('status')
    def status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('ACTIVE', 'INACTIVE'):
            raise ValueError("must validate the enum values ('ACTIVE', 'INACTIVE')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WatchlistSubscription:
        """Create an instance of WatchlistSubscription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WatchlistSubscription:
        """Create an instance of WatchlistSubscription from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return WatchlistSubscription.parse_obj(obj)

        _obj = WatchlistSubscription.parse_obj({
            "auto_renew": obj.get("auto_renew"),
            "created": obj.get("created"),
            "customer_consent": obj.get("customer_consent"),
            "id": obj.get("id"),
            "period_end": obj.get("period_end"),
            "period_start": obj.get("period_start"),
            "provider_subscription_id": obj.get("provider_subscription_id"),
            "status": obj.get("status")
        })
        return _obj

