# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, validator
from synctera_client.models.vendor_info import VendorInfo

class WatchlistAlert(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    created: Optional[datetime] = Field(None, description="When this alert was created")
    id: Optional[StrictStr] = Field(None, description="Unique identifier for this alert")
    provider_info: Optional[Dict[str, Any]] = Field(None, description="The information provided to Synctera that triggered this alert, as an arbitrary JSON object. Interpretation of this object is up to the client. ")
    provider_subject_id: Optional[StrictStr] = Field(None, description="The id of the provider subject for this alert")
    provider_subscription_id: Optional[StrictStr] = Field(None, description="The id of the provider subscription for this alert")
    provider_watchlist_name: Optional[StrictStr] = Field(None, description="The name of the provider for this alert")
    status: StrictStr = Field(..., description="The status of this alert")
    urls: Optional[List[StrictStr]] = Field(None, description="Where to get more information about this alert (according to our third-party data provider). ")
    vendor_info: Optional[VendorInfo] = None
    __properties = ["created", "id", "provider_info", "provider_subject_id", "provider_subscription_id", "provider_watchlist_name", "status", "urls", "vendor_info"]

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('ACTIVE', 'SUPPRESSED'):
            raise ValueError("must validate the enum values ('ACTIVE', 'SUPPRESSED')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WatchlistAlert:
        """Create an instance of WatchlistAlert from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of vendor_info
        if self.vendor_info:
            _dict['vendor_info'] = self.vendor_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WatchlistAlert:
        """Create an instance of WatchlistAlert from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return WatchlistAlert.parse_obj(obj)

        _obj = WatchlistAlert.parse_obj({
            "created": obj.get("created"),
            "id": obj.get("id"),
            "provider_info": obj.get("provider_info"),
            "provider_subject_id": obj.get("provider_subject_id"),
            "provider_subscription_id": obj.get("provider_subscription_id"),
            "provider_watchlist_name": obj.get("provider_watchlist_name"),
            "status": obj.get("status"),
            "urls": obj.get("urls"),
            "vendor_info": VendorInfo.from_dict(obj.get("vendor_info")) if obj.get("vendor_info") is not None else None
        })
        return _obj

