# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class WaitlistAllOf(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    creation_time: Optional[datetime] = Field(None, description="Creation time")
    id: Optional[StrictStr] = Field(None, description="Waitlist ID")
    last_updated_time: Optional[datetime] = Field(None, description="Most recent updated time")
    num_admitted: Optional[StrictInt] = Field(None, description="Current number of prospects in this waitlist with a status of admitted")
    num_created: Optional[StrictInt] = Field(None, description="Current number of prospects in this waitlist with a status of created")
    num_prospects: Optional[StrictInt] = Field(None, description="Current number of prospects in this waitlist, in any state")
    num_verified: Optional[StrictInt] = Field(None, description="Current number of prospects in this waitlist with a status of verified")
    num_withdrawn: Optional[StrictInt] = Field(None, description="Current number of prospects in this waitlist with a status of withdrawn")
    __properties = ["creation_time", "id", "last_updated_time", "num_admitted", "num_created", "num_prospects", "num_verified", "num_withdrawn"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WaitlistAllOf:
        """Create an instance of WaitlistAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_updated_time",
                            "num_admitted",
                            "num_created",
                            "num_prospects",
                            "num_verified",
                            "num_withdrawn",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WaitlistAllOf:
        """Create an instance of WaitlistAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return WaitlistAllOf.parse_obj(obj)

        _obj = WaitlistAllOf.parse_obj({
            "creation_time": obj.get("creation_time"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "num_admitted": obj.get("num_admitted"),
            "num_created": obj.get("num_created"),
            "num_prospects": obj.get("num_prospects"),
            "num_verified": obj.get("num_verified"),
            "num_withdrawn": obj.get("num_withdrawn")
        })
        return _obj

