# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conint, constr

class ViralLoopWaitlists(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    bank_id: Optional[StrictInt] = Field(None, description="Bank ID")
    creation_time: Optional[datetime] = Field(None, description="Creation time")
    id: StrictStr = Field(..., description="Viral Loop Waitlist ID")
    last_updated_time: Optional[datetime] = Field(None, description="Most recent updated time")
    lead_count: Optional[conint(strict=True, ge=0)] = Field(None, description="Total number of leads/people on the waitlist")
    partner_id: Optional[StrictInt] = Field(None, description="Partner ID")
    viral_loop_api_token: constr(strict=True, min_length=5) = Field(..., description="viral loop api token")
    __properties = ["bank_id", "creation_time", "id", "last_updated_time", "lead_count", "partner_id", "viral_loop_api_token"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ViralLoopWaitlists:
        """Create an instance of ViralLoopWaitlists from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "bank_id",
                            "creation_time",
                            "id",
                            "last_updated_time",
                            "lead_count",
                            "partner_id",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ViralLoopWaitlists:
        """Create an instance of ViralLoopWaitlists from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ViralLoopWaitlists.parse_obj(obj)

        _obj = ViralLoopWaitlists.parse_obj({
            "bank_id": obj.get("bank_id"),
            "creation_time": obj.get("creation_time"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "lead_count": obj.get("lead_count"),
            "partner_id": obj.get("partner_id"),
            "viral_loop_api_token": obj.get("viral_loop_api_token")
        })
        return _obj

