# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator
from synctera_client.models.merchant import Merchant
from synctera_client.models.transfer_type import TransferType

class TransferResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_id: StrictStr = Field(..., description="The ID of the account to which the card will be linked")
    amount: StrictInt = Field(..., description="Amount of the transfer in cents")
    country_code: StrictStr = Field(..., description="ISO-3166-1 Alpha-2 country code")
    created_time: datetime = ...
    currency: constr(strict=True, max_length=3, min_length=3) = Field(..., description="ISO 4217  Alpha-3 currency code")
    customer_id: StrictStr = Field(..., description="The ID of the customer for which card is being activated")
    id: StrictStr = Field(..., description="The id of the transfer")
    last_modified_time: datetime = ...
    merchant: Merchant = ...
    status: StrictStr = Field(..., description="The status of the transfer")
    transaction_id: Optional[StrictStr] = Field(None, description="The transaction ID")
    type: TransferType = ...
    __properties = ["account_id", "amount", "country_code", "created_time", "currency", "customer_id", "id", "last_modified_time", "merchant", "status", "transaction_id", "type"]

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('SUCCEEDED', 'PENDING', 'DECLINED', 'CANCELED', 'UNKNOWN'):
            raise ValueError("must validate the enum values ('SUCCEEDED', 'PENDING', 'DECLINED', 'CANCELED', 'UNKNOWN')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransferResponse:
        """Create an instance of TransferResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of merchant
        if self.merchant:
            _dict['merchant'] = self.merchant.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransferResponse:
        """Create an instance of TransferResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransferResponse.parse_obj(obj)

        _obj = TransferResponse.parse_obj({
            "account_id": obj.get("account_id"),
            "amount": obj.get("amount"),
            "country_code": obj.get("country_code"),
            "created_time": obj.get("created_time"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "id": obj.get("id"),
            "last_modified_time": obj.get("last_modified_time"),
            "merchant": Merchant.from_dict(obj.get("merchant")) if obj.get("merchant") is not None else None,
            "status": obj.get("status"),
            "transaction_id": obj.get("transaction_id"),
            "type": obj.get("type")
        })
        return _obj

