# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, constr
from synctera_client.models.merchant import Merchant
from synctera_client.models.transfer_type_request import TransferTypeRequest

class TransferRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    amount: StrictInt = Field(..., description="Amount of the transfer in cents")
    currency: constr(strict=True, max_length=3, min_length=3) = Field(..., description="ISO 4217  Alpha-3 currency code")
    external_card_id: StrictStr = Field(..., description="The ID of the external card from/to which the transfer will be initiated/received")
    merchant: Optional[Merchant] = None
    originating_account_id: StrictStr = Field(..., description="The ID of the account to which the transfer will be initiated/received")
    type: TransferTypeRequest = ...
    __properties = ["amount", "currency", "external_card_id", "merchant", "originating_account_id", "type"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransferRequest:
        """Create an instance of TransferRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of merchant
        if self.merchant:
            _dict['merchant'] = self.merchant.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransferRequest:
        """Create an instance of TransferRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransferRequest.parse_obj(obj)

        _obj = TransferRequest.parse_obj({
            "amount": obj.get("amount"),
            "currency": obj.get("currency"),
            "external_card_id": obj.get("external_card_id"),
            "merchant": Merchant.from_dict(obj.get("merchant")) if obj.get("merchant") is not None else None,
            "originating_account_id": obj.get("originating_account_id"),
            "type": obj.get("type")
        })
        return _obj

