# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr

class TransactionOptions(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    additional_data: Optional[StrictStr] = None
    card_expiration_date_yymm: Optional[StrictStr] = None
    database_transaction_timeout: Optional[StrictInt] = None
    encryption_key_id: Optional[StrictStr] = None
    is_async: Optional[StrictBool] = False
    pre_auth_time_limit: Optional[StrictStr] = None
    send_expiration_date: Optional[StrictBool] = False
    send_track_data: Optional[StrictBool] = False
    transaction_id: Optional[StrictStr] = None
    transaction_timeout_threshold_seconds: Optional[StrictInt] = None
    __properties = ["additional_data", "card_expiration_date_yymm", "database_transaction_timeout", "encryption_key_id", "is_async", "pre_auth_time_limit", "send_expiration_date", "send_track_data", "transaction_id", "transaction_timeout_threshold_seconds"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionOptions:
        """Create an instance of TransactionOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionOptions:
        """Create an instance of TransactionOptions from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransactionOptions.parse_obj(obj)

        _obj = TransactionOptions.parse_obj({
            "additional_data": obj.get("additional_data"),
            "card_expiration_date_yymm": obj.get("card_expiration_date_yymm"),
            "database_transaction_timeout": obj.get("database_transaction_timeout"),
            "encryption_key_id": obj.get("encryption_key_id"),
            "is_async": obj.get("is_async") if obj.get("is_async") is not None else False,
            "pre_auth_time_limit": obj.get("pre_auth_time_limit"),
            "send_expiration_date": obj.get("send_expiration_date") if obj.get("send_expiration_date") is not None else False,
            "send_track_data": obj.get("send_track_data") if obj.get("send_track_data") is not None else False,
            "transaction_id": obj.get("transaction_id"),
            "transaction_timeout_threshold_seconds": obj.get("transaction_timeout_threshold_seconds")
        })
        return _obj

