# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime

from pydantic import BaseModel, Field, StrictInt, StrictStr
from synctera_client.models.transaction_data import TransactionData

class Transaction(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    data: TransactionData = ...
    effective_date: datetime = Field(..., description="The \"effective date\" of a transaction. This may be earlier than posted_date in some cases (for example, a transaction that occurs on a Saturday may not be posted until the following Monday, but would have an effective date of Saturday)")
    id: StrictInt = ...
    posted_date: datetime = Field(..., description="The date the transaction was posted. This is the date any money is considered to be added or removed from an account.")
    status: StrictStr = ...
    subtype: StrictStr = Field(..., description="The specific transaction type. For example, for `ach`, this may be \"outgoing_debit\".")
    type: StrictStr = Field(..., description="The general type of transaction. For example, \"card\" or \"ach\".")
    uuid: StrictStr = Field(..., description="The unique identifier of the transaction.")
    __properties = ["data", "effective_date", "id", "posted_date", "status", "subtype", "type", "uuid"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Transaction:
        """Create an instance of Transaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Transaction:
        """Create an instance of Transaction from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Transaction.parse_obj(obj)

        _obj = Transaction.parse_obj({
            "data": TransactionData.from_dict(obj.get("data")) if obj.get("data") is not None else None,
            "effective_date": obj.get("effective_date"),
            "id": obj.get("id"),
            "posted_date": obj.get("posted_date"),
            "status": obj.get("status"),
            "subtype": obj.get("subtype"),
            "type": obj.get("type"),
            "uuid": obj.get("uuid")
        })
        return _obj

