# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class StatementSummary(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_id: Optional[StrictStr] = Field(None, description="The unique identifier of the account the statement belongs to")
    due_date: Optional[date] = Field(None, description="The limit date when the due amount indicated on the statement should be paid")
    end_date: Optional[date] = Field(None, description="The date indicating the ending of the time interval covered by the statement")
    id: Optional[StrictStr] = Field(None, description="statement ID")
    issue_date: Optional[date] = Field(None, description="The date when the statement has been issued")
    start_date: Optional[date] = Field(None, description="The date indicating the beginning of the time interval covered by the statement")
    __properties = ["account_id", "due_date", "end_date", "id", "issue_date", "start_date"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StatementSummary:
        """Create an instance of StatementSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "account_id",
                            "due_date",
                            "end_date",
                            "id",
                            "issue_date",
                            "start_date",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StatementSummary:
        """Create an instance of StatementSummary from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StatementSummary.parse_obj(obj)

        _obj = StatementSummary.parse_obj({
            "account_id": obj.get("account_id"),
            "due_date": obj.get("due_date"),
            "end_date": obj.get("end_date"),
            "id": obj.get("id"),
            "issue_date": obj.get("issue_date"),
            "start_date": obj.get("start_date")
        })
        return _obj

