# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conint
from synctera_client.models.payment_type import PaymentType
from synctera_client.models.spend_control_direction import SpendControlDirection
from synctera_client.models.spend_control_time_range import SpendControlTimeRange

class SpendControlUpdateRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    action_case: Optional[StrictBool] = Field(None, description="If set, create a case for transactions that do not conform to the spend control")
    action_decline: Optional[StrictBool] = Field(None, description="If set, decline transactions that do not conform to the spend control")
    amount_limit: Optional[conint(strict=True, gt=0)] = Field(None, description="Monetary limit for the spend control in the smallest currency unit (eg cents)")
    direction: Optional[SpendControlDirection] = None
    is_active: Optional[StrictBool] = Field(None, description="Indicates if spend control is active")
    name: Optional[StrictStr] = Field(None, description="Name assigned to spend control")
    payment_types: Optional[List[PaymentType]] = Field(None, description="A list of payment types to which a spend control will apply, if set. If not set or the array is empty, then the spend control will apply to all types of payments.")
    time_range: Optional[SpendControlTimeRange] = None
    __properties = ["action_case", "action_decline", "amount_limit", "direction", "is_active", "name", "payment_types", "time_range"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SpendControlUpdateRequest:
        """Create an instance of SpendControlUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of time_range
        if self.time_range:
            _dict['time_range'] = self.time_range.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SpendControlUpdateRequest:
        """Create an instance of SpendControlUpdateRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SpendControlUpdateRequest.parse_obj(obj)

        _obj = SpendControlUpdateRequest.parse_obj({
            "action_case": obj.get("action_case"),
            "action_decline": obj.get("action_decline"),
            "amount_limit": obj.get("amount_limit"),
            "direction": obj.get("direction"),
            "is_active": obj.get("is_active"),
            "name": obj.get("name"),
            "payment_types": obj.get("payment_types"),
            "time_range": SpendControlTimeRange.from_dict(obj.get("time_range")) if obj.get("time_range") is not None else None
        })
        return _obj

