# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr, validator
from synctera_client.models.address1 import Address1
from synctera_client.models.recipient_name import RecipientName

class Shipping(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    address: Optional[Address1] = None
    care_of_line: Optional[StrictStr] = Field(None, description="The name of the person to send in care of")
    is_expedited_fulfillment: Optional[StrictBool] = Field(False, description="Is the shipment expedited")
    method: Optional[StrictStr] = Field('LOCAL_MAIL', description="The shipping method")
    phone_number: Optional[constr(strict=True)] = Field(None, description="The phone number of the recipient")
    recipient_name: Optional[RecipientName] = None
    __properties = ["address", "care_of_line", "is_expedited_fulfillment", "method", "phone_number", "recipient_name"]

    @validator('method')
    def method_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('LOCAL_MAIL', 'TWO_DAY', 'OVERNIGHT', 'INTERNATIONAL'):
            raise ValueError("must validate the enum values ('LOCAL_MAIL', 'TWO_DAY', 'OVERNIGHT', 'INTERNATIONAL')")
        return v

    @validator('phone_number')
    def phone_number_validate_regular_expression(cls, v):
        if not re.match(r"^\+[1-9]\d{1,14}$", v):
            raise ValueError(r"must validate the regular expression /^\+[1-9]\d{1,14}$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Shipping:
        """Create an instance of Shipping from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of recipient_name
        if self.recipient_name:
            _dict['recipient_name'] = self.recipient_name.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Shipping:
        """Create an instance of Shipping from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Shipping.parse_obj(obj)

        _obj = Shipping.parse_obj({
            "address": Address1.from_dict(obj.get("address")) if obj.get("address") is not None else None,
            "care_of_line": obj.get("care_of_line"),
            "is_expedited_fulfillment": obj.get("is_expedited_fulfillment") if obj.get("is_expedited_fulfillment") is not None else False,
            "method": obj.get("method") if obj.get("method") is not None else 'LOCAL_MAIL',
            "phone_number": obj.get("phone_number"),
            "recipient_name": RecipientName.from_dict(obj.get("recipient_name")) if obj.get("recipient_name") is not None else None
        })
        return _obj

