# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from synctera_client.models.account_relationship_type import AccountRelationshipType

class Relationship(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    business_id: Optional[StrictStr] = Field(None, description="Business associated with the current account")
    customer_id: Optional[StrictStr] = Field(None, description="Personal customer associated with the current account.")
    id: Optional[StrictStr] = Field(None, description="ID of account relationship")
    person_id: Optional[StrictStr] = Field(None, description="Person associated with the current account. This attribute is deprecated and will be removed in a future API version. Use customer_id instead.")
    relationship_type: AccountRelationshipType = ...
    __properties = ["business_id", "customer_id", "id", "person_id", "relationship_type"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Relationship:
        """Create an instance of Relationship from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "id",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Relationship:
        """Create an instance of Relationship from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Relationship.parse_obj(obj)

        _obj = Relationship.parse_obj({
            "business_id": obj.get("business_id"),
            "customer_id": obj.get("customer_id"),
            "id": obj.get("id"),
            "person_id": obj.get("person_id"),
            "relationship_type": obj.get("relationship_type")
        })
        return _obj

