# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, validator
from synctera_client.models.prospect_status import ProspectStatus
from synctera_client.models.vendor_info import VendorInfo

class Prospect1(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    creation_time: Optional[datetime] = Field(None, description="Creation time")
    email: StrictStr = Field(..., description="Email")
    email_validation: Optional[StrictStr] = None
    id: Optional[StrictStr] = Field(None, description="Prospect ID")
    last_updated_time: Optional[datetime] = Field(None, description="Most recent updated time")
    points: Optional[StrictInt] = Field(None, description="Number of referral points")
    recaptcha_token: Optional[StrictStr] = Field(None, description="A token used to verify the user is not a robot")
    referral_code: Optional[StrictStr] = Field(None, description="Referral code")
    referred_by: Optional[StrictStr] = Field(None, description="UUID of the referrer")
    referred_by_code: Optional[StrictStr] = Field(None, description="Referral code of the referrer")
    referred_prospects: Optional[StrictInt] = Field(None, description="Number of people this prospect referred")
    vendor_info: Optional[VendorInfo] = None
    verification_token: Optional[StrictStr] = Field(None, description="Verification token sent to prospect")
    waitlist_id: Optional[StrictStr] = Field(None, description="Waitlist ID")
    waitlist_position: Optional[StrictInt] = Field(None, description="Prospect's number in the waitlist")
    first_name: Optional[StrictStr] = Field(None, description="First Name")
    last_name: Optional[StrictStr] = Field(None, description="Last Name")
    metadata: Optional[StrictStr] = Field(None, description="Client supplied json metadata to be stored with the prospect")
    source: Optional[StrictStr] = Field(None, description="Source of prospect")
    status: Optional[ProspectStatus] = None
    __properties = ["creation_time", "email", "email_validation", "id", "last_updated_time", "points", "recaptcha_token", "referral_code", "referred_by", "referred_by_code", "referred_prospects", "vendor_info", "verification_token", "waitlist_id", "waitlist_position", "first_name", "last_name", "metadata", "source", "status"]

    @validator('email_validation')
    def email_validation_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('PENDING', 'VALID', 'INVALID'):
            raise ValueError("must validate the enum values ('PENDING', 'VALID', 'INVALID')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Prospect1:
        """Create an instance of Prospect1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "email_validation",
                            "id",
                            "last_updated_time",
                            "referral_code",
                            "referred_by",
                            "referred_prospects",
                            "verification_token",
                            "waitlist_id",
                            "waitlist_position",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of vendor_info
        if self.vendor_info:
            _dict['vendor_info'] = self.vendor_info.to_dict()
        # set to None if waitlist_position (nullable) is None
        if self.waitlist_position is None:
            _dict['waitlist_position'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Prospect1:
        """Create an instance of Prospect1 from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Prospect1.parse_obj(obj)

        _obj = Prospect1.parse_obj({
            "creation_time": obj.get("creation_time"),
            "email": obj.get("email"),
            "email_validation": obj.get("email_validation"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "points": obj.get("points"),
            "recaptcha_token": obj.get("recaptcha_token"),
            "referral_code": obj.get("referral_code"),
            "referred_by": obj.get("referred_by"),
            "referred_by_code": obj.get("referred_by_code"),
            "referred_prospects": obj.get("referred_prospects"),
            "vendor_info": VendorInfo.from_dict(obj.get("vendor_info")) if obj.get("vendor_info") is not None else None,
            "verification_token": obj.get("verification_token"),
            "waitlist_id": obj.get("waitlist_id"),
            "waitlist_position": obj.get("waitlist_position"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "metadata": obj.get("metadata"),
            "source": obj.get("source"),
            "status": obj.get("status")
        })
        return _obj

