# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr
from synctera_client.models.pending_transaction_data import PendingTransactionData

class PendingTransaction(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_id: StrictStr = Field(..., description="The account id associated with the hold")
    account_no: StrictStr = Field(..., description="The account number associated with the hold")
    created: datetime = Field(..., description="The creation date of the hold")
    data: PendingTransactionData = ...
    id: StrictInt = ...
    idemkey: StrictStr = Field(..., description="The idempotency key used when initially creating this hold.")
    offset_account_id: Optional[StrictStr] = Field(None, description="The offset account id associated with the hold")
    offset_account_no: Optional[StrictStr] = Field(None, description="The offset account number associated with the hold")
    reference_id: Optional[StrictStr] = Field(..., description="An external ID provided by the payment network to represent this transaction.")
    tenant: StrictStr = Field(..., description="The tenant associated with this hold, in the form \"<bankid>_<partnerid>\"")
    updated: datetime = Field(..., description="The date the hold was last update")
    uuid: StrictStr = Field(..., description="The unique identifier of the hold transaction.")
    __properties = ["account_id", "account_no", "created", "data", "id", "idemkey", "offset_account_id", "offset_account_no", "reference_id", "tenant", "updated", "uuid"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PendingTransaction:
        """Create an instance of PendingTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # set to None if reference_id (nullable) is None
        if self.reference_id is None:
            _dict['reference_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PendingTransaction:
        """Create an instance of PendingTransaction from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PendingTransaction.parse_obj(obj)

        _obj = PendingTransaction.parse_obj({
            "account_id": obj.get("account_id"),
            "account_no": obj.get("account_no"),
            "created": obj.get("created"),
            "data": PendingTransactionData.from_dict(obj.get("data")) if obj.get("data") is not None else None,
            "id": obj.get("id"),
            "idemkey": obj.get("idemkey"),
            "offset_account_id": obj.get("offset_account_id"),
            "offset_account_no": obj.get("offset_account_no"),
            "reference_id": obj.get("reference_id"),
            "tenant": obj.get("tenant"),
            "updated": obj.get("updated"),
            "uuid": obj.get("uuid")
        })
        return _obj

