# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr, validator
from synctera_client.models.additional_data import AdditionalData

class PatchPersonBusinessRelationship(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    additional_data: Optional[AdditionalData] = None
    creation_time: Optional[datetime] = Field(None, description="The date and time the resource was created.")
    from_person_id: Optional[StrictStr] = Field(None, description="Unique ID for the subject person. ")
    id: Optional[StrictStr] = Field(None, description="Relationship unique identifier.")
    last_updated_time: Optional[datetime] = Field(None, description="The date and time the resource was last updated.")
    metadata: Optional[Dict[str, Any]] = Field(None, description="Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. ")
    relationship_type: StrictStr = Field(..., description="The relationship type. One of the following: * `BENEFICIAL_OWNER_OF` – a person who directly or indirectly owns a portion of the business. * `MANAGING_PERSON_OF` – a person who is an officer, director, or other notable person of an organization. * `OWNER_OF` – a business with ownership of another business. ")
    to_business_id: Optional[StrictStr] = Field(None, description="Unique ID for the related business. ")
    __properties = ["additional_data", "creation_time", "from_person_id", "id", "last_updated_time", "metadata", "relationship_type", "to_business_id"]

    @validator('relationship_type')
    def relationship_type_validate_enum(cls, v):
        if v not in ('BENEFICIAL_OWNER_OF', 'MANAGING_PERSON_OF', 'OWNER_OF'):
            raise ValueError("must validate the enum values ('BENEFICIAL_OWNER_OF', 'MANAGING_PERSON_OF', 'OWNER_OF')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PatchPersonBusinessRelationship:
        """Create an instance of PatchPersonBusinessRelationship from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_updated_time",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of additional_data
        if self.additional_data:
            _dict['additional_data'] = self.additional_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PatchPersonBusinessRelationship:
        """Create an instance of PatchPersonBusinessRelationship from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PatchPersonBusinessRelationship.parse_obj(obj)

        _obj = PatchPersonBusinessRelationship.parse_obj({
            "additional_data": AdditionalData.from_dict(obj.get("additional_data")) if obj.get("additional_data") is not None else None,
            "creation_time": obj.get("creation_time"),
            "from_person_id": obj.get("from_person_id"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "metadata": obj.get("metadata"),
            "relationship_type": obj.get("relationship_type"),
            "to_business_id": obj.get("to_business_id")
        })
        return _obj

