# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr, validator
from synctera_client.models.address import Address
from synctera_client.models.ban_status import BanStatus
from synctera_client.models.ssn_source import SsnSource
from synctera_client.models.status1 import Status1
from synctera_client.models.verification_status import VerificationStatus

class PatchPerson(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    ban_status: Optional[BanStatus] = None
    chosen_name: Optional[StrictStr] = Field(None, description="Person's chosen name.")
    creation_time: Optional[datetime] = Field(None, description="The date and time the resource was created.")
    dob: Optional[date] = Field(None, description="Person's date of birth in RFC 3339 full-date format (YYYY-MM-DD).")
    email: Optional[StrictStr] = Field(None, description="Person's email.")
    first_name: Optional[StrictStr] = Field(None, description="Person's first name.")
    id: Optional[StrictStr] = Field(None, description="Person's unique identifier.")
    is_customer: Optional[StrictBool] = Field(None, description="True for personal and business customers with a direct relationship with the fintech or bank. Set this to true for any customer related to an account. ")
    last_name: Optional[StrictStr] = Field(None, description="Person's last name.")
    last_updated_time: Optional[datetime] = Field(None, description="The date and time the resource was last updated.")
    legal_address: Optional[Address] = None
    metadata: Optional[Dict[str, Any]] = Field(None, description="Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. ")
    middle_name: Optional[StrictStr] = Field(None, description="Person's middle name.")
    phone_number: Optional[constr(strict=True)] = Field(None, description="Person's mobile phone number with country code in E.164 format. Must have a valid country code. Area code and local phone number are not validated")
    shipping_address: Optional[Address] = None
    ssn: Optional[StrictStr] = Field(None, description="Person's full tax ID eg SSN formatted with hyphens. The response contains the last 4 digits only (e.g. 6789).")
    ssn_source: Optional[SsnSource] = None
    status: Optional[Status1] = None
    tenant: Optional[StrictStr] = Field(None, description="The id of the tenant containing the resource. ")
    verification_last_run: Optional[datetime] = Field(None, description="Date and time KYC verification was last run on the person.")
    verification_status: Optional[VerificationStatus] = None
    __properties = ["ban_status", "chosen_name", "creation_time", "dob", "email", "first_name", "id", "is_customer", "last_name", "last_updated_time", "legal_address", "metadata", "middle_name", "phone_number", "shipping_address", "ssn", "ssn_source", "status", "tenant", "verification_last_run", "verification_status"]

    @validator('phone_number')
    def phone_number_validate_regular_expression(cls, v):
        if not re.match(r"^\+[1-9]\d{1,14}$", v):
            raise ValueError(r"must validate the regular expression /^\+[1-9]\d{1,14}$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PatchPerson:
        """Create an instance of PatchPerson from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_updated_time",
                            "verification_last_run",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of legal_address
        if self.legal_address:
            _dict['legal_address'] = self.legal_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of shipping_address
        if self.shipping_address:
            _dict['shipping_address'] = self.shipping_address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PatchPerson:
        """Create an instance of PatchPerson from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PatchPerson.parse_obj(obj)

        _obj = PatchPerson.parse_obj({
            "ban_status": obj.get("ban_status"),
            "chosen_name": obj.get("chosen_name"),
            "creation_time": obj.get("creation_time"),
            "dob": obj.get("dob"),
            "email": obj.get("email"),
            "first_name": obj.get("first_name"),
            "id": obj.get("id"),
            "is_customer": obj.get("is_customer"),
            "last_name": obj.get("last_name"),
            "last_updated_time": obj.get("last_updated_time"),
            "legal_address": Address.from_dict(obj.get("legal_address")) if obj.get("legal_address") is not None else None,
            "metadata": obj.get("metadata"),
            "middle_name": obj.get("middle_name"),
            "phone_number": obj.get("phone_number"),
            "shipping_address": Address.from_dict(obj.get("shipping_address")) if obj.get("shipping_address") is not None else None,
            "ssn": obj.get("ssn"),
            "ssn_source": obj.get("ssn_source"),
            "status": obj.get("status"),
            "tenant": obj.get("tenant"),
            "verification_last_run": obj.get("verification_last_run"),
            "verification_status": obj.get("verification_status")
        })
        return _obj

