# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev4
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from synctera_client.models.account_verification import AccountVerification
from synctera_client.models.patch_accounts_request_account_identifiers import PatchAccountsRequestAccountIdentifiers
from synctera_client.models.patch_accounts_request_routing_identifiers import PatchAccountsRequestRoutingIdentifiers

class PatchExternalAccount(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_identifiers: Optional[PatchAccountsRequestAccountIdentifiers] = None
    account_owner_names: Optional[List[StrictStr]] = Field(None, description="The names of the account owners.")
    nickname: Optional[constr(strict=True, min_length=1)] = Field(None, description="A user-meaningful name for the account")
    routing_identifiers: Optional[PatchAccountsRequestRoutingIdentifiers] = None
    type: Optional[StrictStr] = Field(None, description="The type of the account")
    verification: Optional[AccountVerification] = None
    __properties = ["account_identifiers", "account_owner_names", "nickname", "routing_identifiers", "type", "verification"]

    @validator('type')
    def type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('CHECKING', 'SAVINGS'):
            raise ValueError("must validate the enum values ('CHECKING', 'SAVINGS')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PatchExternalAccount:
        """Create an instance of PatchExternalAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of account_identifiers
        if self.account_identifiers:
            _dict['account_identifiers'] = self.account_identifiers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of routing_identifiers
        if self.routing_identifiers:
            _dict['routing_identifiers'] = self.routing_identifiers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of verification
        if self.verification:
            _dict['verification'] = self.verification.to_dict()
        # set to None if verification (nullable) is None
        if self.verification is None:
            _dict['verification'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PatchExternalAccount:
        """Create an instance of PatchExternalAccount from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PatchExternalAccount.parse_obj(obj)

        _obj = PatchExternalAccount.parse_obj({
            "account_identifiers": PatchAccountsRequestAccountIdentifiers.from_dict(obj.get("account_identifiers")) if obj.get("account_identifiers") is not None else None,
            "account_owner_names": obj.get("account_owner_names"),
            "nickname": obj.get("nickname"),
            "routing_identifiers": PatchAccountsRequestRoutingIdentifiers.from_dict(obj.get("routing_identifiers")) if obj.get("routing_identifiers") is not None else None,
            "type": obj.get("type"),
            "verification": AccountVerification.from_dict(obj.get("verification")) if obj.get("verification") is not None else None
        })
        return _obj

